/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class ClusterLinkTopicState$ {
    public static final ClusterLinkTopicState$ MODULE$ = new ClusterLinkTopicState$();

    public String toJsonString(ClusterLinkTopicState state) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.state().name()), (Object)CollectionConverters$.MODULE$.MapHasAsJava(state.toMap()).asJava())}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTopicState fromJsonString(String json) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(json);
        if (option instanceof Some) {
            void var6_6;
            JsonObject jsonObj = ((JsonValue)((Some)option).value()).asJsonObject();
            List entries = TopicLinkState$.MODULE$.states().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), jsonObj.get(key.name()))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$2(x$2)));
            if (entries.size() != 1) {
                throw new IllegalStateException("Invalid cluster link topic state(s)");
            }
            Tuple2 tuple2 = (Tuple2)entries.head();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicLinkState k = (TopicLinkState)tuple2._1();
            JsonObject jsonObject = ((JsonValue)((Option)tuple2._2()).get()).asJsonObject();
            if (TopicLinkMirror$.MODULE$.equals(var6_6)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                return new ClusterLinkTopicState.Mirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), timeMs);
            }
            if (TopicLinkPausedMirror$.MODULE$.equals(var6_6)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean linkLevel = BoxesRunTime.unboxToBoolean((Object)jsonObject.apply("link_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean topicLevel = BoxesRunTime.unboxToBoolean((Object)jsonObject.apply("topic_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean wasFailed = BoxesRunTime.unboxToBoolean((Object)jsonObject.apply("was_failed").to(DecodeJson$DecodeBoolean$.MODULE$));
                return new ClusterLinkTopicState.PausedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), linkLevel, topicLevel, wasFailed, timeMs);
            }
            if (TopicLinkFailedMirror$.MODULE$.equals(var6_6)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                return new ClusterLinkTopicState.FailedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), timeMs);
            }
            if (TopicLinkPendingStoppedMirror$.MODULE$.equals(var6_6)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean synchronize = BoxesRunTime.unboxToBoolean((Object)jsonObject.apply("synchronize").to(DecodeJson$DecodeBoolean$.MODULE$));
                return new ClusterLinkTopicState.PendingStoppedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), synchronize, timeMs);
            }
            if (TopicLinkStoppedMirror$.MODULE$.equals(var6_6)) {
                void decodeSeq_factory;
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Factory factory = Seq$.MODULE$.iterableFactory();
                DecodeJson$DecodeLong$ decodeSeq_decodeJson = DecodeJson$DecodeLong$.MODULE$;
                Object var36_28 = null;
                factory = null;
                Seq logEndOffsets = (Seq)jsonObject.apply("log_end_offsets").to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                    private final DecodeJson decodeJson$2;
                    private final Factory factory$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, S> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                    }
                    {
                        this.decodeJson$2 = decodeJson$2;
                        this.factory$1 = factory$1;
                    }
                });
                return new ClusterLinkTopicState.StoppedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), (Seq<Object>)logEndOffsets, timeMs);
            }
            ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
            long timeMs = BoxesRunTime.unboxToLong((Object)jsonObject.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
            String linkName = jsonObject.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
            UUID linkId = UUID.fromString(jsonObject.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
            return new ClusterLinkTopicState.FailedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1(jsonObject), timeMs);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(26).append("Invalid topic state JSON: ").append(json).toString());
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<String, String>> sourceTopicIdOption(Uuid sourceTopicId) {
        Uuid uuid = sourceTopicId;
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source_topic_id"), (Object)sourceTopicId.toString()));
    }

    public ClusterLinkTopicState apply(MirrorTopic mirrorTopic, String linkName) {
        UUID linkId = CoreUtils$.MODULE$.toJavaUUID(mirrorTopic.linkId());
        MirrorTopic.State state = mirrorTopic.mirrorState();
        if (MirrorTopic.State.MIRROR.equals(state)) {
            return new ClusterLinkTopicState.Mirror(linkName, linkId, mirrorTopic.sourceTopicId(), mirrorTopic.timeMs());
        }
        if (MirrorTopic.State.PAUSED.equals(state)) {
            MirrorTopic.PausedMirrorTopic pausedMirror = (MirrorTopic.PausedMirrorTopic)mirrorTopic;
            MirrorTopic.State state2 = pausedMirror.prevToPausedState();
            MirrorTopic.State state3 = MirrorTopic.State.FAILED;
            return new ClusterLinkTopicState.PausedMirror(linkName, linkId, pausedMirror.sourceTopicId(), pausedMirror.linkLevel(), pausedMirror.topicLevel(), !(state2 != null ? !state2.equals(state3) : state3 != null), pausedMirror.timeMs());
        }
        if (MirrorTopic.State.PENDING_STOPPED.equals(state)) {
            MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirror = (MirrorTopic.PendingStoppedMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.PendingStoppedMirror(linkName, linkId, pendingStoppedMirror.sourceTopicId(), pendingStoppedMirror.promoted(), pendingStoppedMirror.timeMs());
        }
        if (MirrorTopic.State.STOPPED.equals(state)) {
            MirrorTopic.StoppedMirrorTopic stoppedMirror = (MirrorTopic.StoppedMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.StoppedMirror(linkName, linkId, stoppedMirror.sourceTopicId(), (Seq<Object>)CollectionConverters$.MODULE$.ListHasAsScala(stoppedMirror.offsets()).asScala().toList().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$6))), stoppedMirror.timeMs());
        }
        if (MirrorTopic.State.FAILED.equals(state)) {
            return new ClusterLinkTopicState.FailedMirror(linkName, linkId, mirrorTopic.sourceTopicId(), mirrorTopic.timeMs());
        }
        return new ClusterLinkTopicState.FailedMirror(linkName, linkId, mirrorTopic.sourceTopicId(), mirrorTopic.timeMs());
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$2(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    private static final void validateVersion$1(int expectedVersion, int actualVersion) {
        if (expectedVersion != actualVersion) {
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected version '").append(expectedVersion).append("', actual version '").append(actualVersion).append("'").toString());
        }
    }

    private static final Uuid sourceTopicId$1(JsonObject jsonOpt$1) {
        return (Uuid)jsonOpt$1.get("source_topic_id").map((Function1 & Serializable)x$4 -> x$4.to(DecodeJson$DecodeString$.MODULE$)).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5)))).map((Function1 & Serializable)x$1 -> Uuid.fromString((String)x$1)).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    private ClusterLinkTopicState$() {
    }
}

