/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.FilterJson;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.utils.Logging;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkUtils$
implements Logging {
    public static final ClusterLinkUtils$ MODULE$ = new ClusterLinkUtils$();
    private static final Set<Object> ConfluentCloudInternalPorts = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9071, 9072, 9073, 9080, 8090}));
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Set<Object> ConfluentCloudInternalPorts() {
        return ConfluentCloudInternalPorts;
    }

    public void validateLinkName(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public void overrideLinkConfigsForCompatibility(Properties config) {
        MirrorTopicConfigSyncRules$.MODULE$.decorateTopicConfigSyncRules(config);
    }

    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<UUID> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo, String tenantPrefix) {
        Option mirrorTopic = Option$.MODULE$.apply((Object)topic.mirrorTopic());
        Option option = Option$.MODULE$.apply((Object)topic.linkName());
        if (option instanceof Some) {
            String linkName = (String)((Some)option).value();
            ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
            if (mirrorTopic instanceof Some) {
                String mt = (String)((Some)mirrorTopic).value();
                String withoutTenantPrefixTopicName = topic.name().substring(tenantPrefix.length());
                Option clusterLinkPrefix = linkConfig.flatMap((Function1 & Serializable)x$1 -> x$1.clusterLinkPrefix());
                clusterLinkPrefix.foreach((Function1 & Serializable)linkPrefix -> {
                    ClusterLinkUtils$.$anonfun$resolveCreateTopic$2(withoutTenantPrefixTopicName, linkPrefix);
                    return BoxedUnit.UNIT;
                });
                int clusterLinkPrefixLength = ((String)clusterLinkPrefix.getOrElse((Function0 & Serializable)() -> "")).length();
                String unprefixedTopicName = withoutTenantPrefixTopicName.substring(clusterLinkPrefixLength);
                String string = mt.substring(tenantPrefix.length());
                if (string == null ? unprefixedTopicName != null : !string.equals(unprefixedTopicName)) {
                    throw new UnsupportedVersionException("Topic renaming for mirroring not yet supported.");
                }
            } else {
                if (None$.MODULE$.equals(mirrorTopic)) {
                    throw new InvalidRequestException("Mirror topic not set.");
                }
                throw new MatchError((Object)mirrorTopic);
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(41).append("Cluster link with name '").append(topic.linkName()).append("' does not exist.").toString());
            }
            MirrorTopicConfigSyncRules topicConfigSyncRules = ((ClusterLinkConfig)((Object)linkConfig.get())).topicConfigSyncRules();
            topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
            if (topicInfo instanceof Some) {
                ClusterLinkTopicInfo clusterLinkTopicInfo;
                CompletableFuture ti = (CompletableFuture)((Some)topicInfo).value();
                try {
                    if (!ti.isDone()) {
                        throw new IllegalStateException("Mirror information must have been resolved.");
                    }
                    clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (TimeoutException e) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        String msgWithLogIdent_msg = "Received timeout exception while fetching topic information over cluster link";
                        Object var21_19 = null;
                        this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), (Throwable)e);
                    }
                    throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                }
                ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                    throw new TopicAuthorizationException("Mirror topic creation requires READ access on the source topic.");
                }
                Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                return new ClusterLinkUtils.ResolveCreateTopic(newConfigs, (Option<ClusterLinkTopicState>)new Some((Object)new ClusterLinkTopicState.Mirror(linkName, (UUID)linkId.get(), info.description().topicId(), Time.SYSTEM.milliseconds())), info.description().partitions().size());
            }
            if (None$.MODULE$.equals(topicInfo)) {
                if (!validateOnly) {
                    throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                }
                return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
            }
            throw new MatchError(topicInfo);
        }
        if (None$.MODULE$.equals(option)) {
            if (mirrorTopic.nonEmpty()) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
            }
            return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
        }
        throw new MatchError((Object)option);
    }

    public String resolveCreateTopic$default$7() {
        return "";
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        if (partitions instanceof Some) {
            int n;
            CompletableFuture parts = (CompletableFuture)((Some)partitions).value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException(new StringBuilder(76).append("Cannot set '").append(numPartitions).append("' partitions for topic '").append(topic).append("', ").append("exceeds linked topic's '").append(mirrorNumPartitions).append("' partitions.").toString());
            }
            return;
        }
        if (None$.MODULE$.equals(partitions)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
            return;
        }
        throw new MatchError(partitions);
    }

    public scala.collection.immutable.Seq<ClusterLinkFilterInfo> clusterLinkFilters(Option<FilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        String prefix = new StringBuilder(0).append((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> "")).append(clusterLinkPrefix.getOrElse((Function0 & Serializable)() -> "")).toString();
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1 & Serializable)x$2 -> x$2.filters()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)filter -> {
            PatternType patternType = SecurityUtils.patternType((String)filter.patternType());
            if (!prefix.isEmpty()) {
                if (PatternType.LITERAL.equals(patternType)) {
                    String string = filter.name();
                    String string2 = "*";
                    if (string != null && string.equals(string2)) {
                        PatternType patternType2 = patternType;
                        PatternType patternType3 = PatternType.LITERAL;
                        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
                            return new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), (ClusterLinkFilter)filter);
                        }
                    }
                    return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), (ClusterLinkFilter)filter);
                }
                if (PatternType.PREFIXED.equals(patternType)) {
                    return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), (ClusterLinkFilter)filter);
                }
                throw new IllegalStateException(new StringBuilder(24).append("Unexpected pattern type ").append(filter.patternType()).toString());
            }
            return new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), (ClusterLinkFilter)filter);
        });
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        if (policy instanceof Some) {
            AlterConfigPolicy pol = (AlterConfigPolicy)((Some)policy).value();
            Map configs = Utils.propsToStringMap((Properties)props);
            if (pol instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)pol;
                Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(policy)) {
            return props;
        }
        throw new MatchError(policy);
    }

    public boolean canHandleClusterLinkRequests(MetadataSupport metadataSupport) {
        if (metadataSupport instanceof ZkSupport) {
            return ((ZkSupport)metadataSupport).controller().isActive();
        }
        if (metadataSupport instanceof RaftSupport) {
            return true;
        }
        throw new MatchError((Object)metadataSupport);
    }

    public void validateMirrorTopicConfig(String topic, Set<String> configKeys, ClusterLinkFactory.LinkManager clusterLinkManager, boolean isIncremental) {
        clusterLinkManager.clusterLinkMetadataManager().foreach((Function1 & Serializable)metadataManager -> {
            ClusterLinkUtils$.$anonfun$validateMirrorTopicConfig$1(topic, isIncremental, clusterLinkManager, configKeys, metadataManager);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public ApiException apiException(Throwable throwable, String message) {
        e = (throwable instanceof ExecutionException != false ? true : throwable instanceof CompletionException != false) != false ? throwable.getCause() : throwable;
        v0 = err = Errors.forException((Throwable)e);
        var6_5 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var6_5 != null : v0.equals(var6_5) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var7_6 = e.getMessage();
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == e ? e.getMessage() : new StringBuilder(14).append(e.getMessage()).append(", root cause: ").append(rootCause).toString();
        }
        errMessage = v2;
        apiError = new ApiError(err, errMessage);
        v3 = apiError.error();
        var10_10 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var10_10) == false : var10_10 != null) && e instanceof AuthenticationException) {
            apiError = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
        }
        errorMessage = new StringBuilder(15).append(message).append(" due to error: ").append(apiError.messageWithFallback()).toString();
        v4 = apiError.error();
        var12_12 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var12_12) == false : var12_12 != null)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, errorMessage), e);
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, errorMessage), e);
        }
        return apiError.error().exception(errorMessage);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilter(Set<String> toFilter, Option<FilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters = this.clusterLinkFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix);
        return this.doFilter(toFilter, filters);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilter(Set<String> toFilter, scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Set filtered = (Set)toFilter.filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilter$1(filters, usedFilters, item)));
        return new Tuple2((Object)filtered, filters.diff((Seq)usedFilters));
    }

    public boolean isInternalNetworkOrPort(InetSocketAddress socketAddress) {
        return this.ConfluentCloudInternalPorts().contains((Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort())) && (socketAddress.getAddress().isSiteLocalAddress() || socketAddress.getAddress().isLoopbackAddress());
    }

    public boolean isOutboundBootstrapCCloudHost(ClusterLinkConfig clusterLinkConfig) {
        Option firstHost = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(clusterLinkConfig.bootstrapServers()).asScala().filter((Function1 & Serializable)bootstrap -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$isOutboundBootstrapCCloudHost$1(bootstrap)))).map((Function1 & Serializable)bootstrap -> Utils.getHost((String)bootstrap))).headOption();
        if (firstHost instanceof Some) {
            String host = (String)((Some)firstHost).value();
            ConnectionMode connectionMode = clusterLinkConfig.connectionMode();
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            return connectionMode != null && connectionMode.equals(connectionMode$Outbound$) && host != null && (host.endsWith(".confluent.cloud") || host.endsWith(".cpdev.cloud"));
        }
        if (None$.MODULE$.equals(firstHost)) {
            return false;
        }
        throw new MatchError((Object)firstHost);
    }

    public static final /* synthetic */ void $anonfun$resolveCreateTopic$2(String withoutTenantPrefixTopicName$1, String linkPrefix) {
        if (!withoutTenantPrefixTopicName$1.startsWith(linkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Mirror topic name should start with cluster link prefix ").append(linkPrefix).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$resolveCreateTopic$4() {
        return "Received timeout exception while fetching topic information over cluster link";
    }

    public static final /* synthetic */ TimeoutException $anonfun$resolveCreateTopic$5(TimeoutException e$1) {
        return e$1;
    }

    public static final /* synthetic */ void $anonfun$validateMirrorTopicConfig$1(String topic$1, boolean isIncremental$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Set configKeys$1, ClusterLinkMetadataManager metadataManager) {
        if (metadataManager.hasTopic(topic$1)) {
            Option clusterLinkTopicState = metadataManager.clusterLinkTopicState((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})))).get((Object)topic$1);
            if (clusterLinkTopicState.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.mirrorIsEstablished()))) {
                if (!isIncremental$1) {
                    throw new InvalidRequestException(new StringBuilder(72).append("Non-incremental configuration updates for mirror topic '").append(topic$1).append("' are disallowed").toString());
                }
                UUID linkId = ((ClusterLinkTopicState)clusterLinkTopicState.get()).linkId();
                if (clusterLinkManager$1.linkConfig(linkId).isEmpty()) {
                    throw new ClusterLinkNotFoundException(new StringBuilder(71).append("The cluster link with ID ").append(linkId).append(" does not exist, or is temporarily unavailable").toString());
                }
                ((ClusterLinkConfig)((Object)clusterLinkManager$1.linkConfig(linkId).get())).topicConfigSyncRules().validateMirrorPropsForTopicAlteration(topic$1, (Set<String>)configKeys$1);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ boolean $anonfun$doFilter$1(scala.collection.immutable.Seq filters$1, Buffer usedFilters$1, String item) {
        scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters$1.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((IterableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isInclude()));
    }

    public static final /* synthetic */ boolean $anonfun$isOutboundBootstrapCCloudHost$1(String bootstrap) {
        return bootstrap != null && !bootstrap.isEmpty();
    }

    private ClusterLinkUtils$() {
    }
}

