/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.admin.BrokerMetadata;
import kafka.controller.StateChangeLogger;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=c\u0001B\u00181\u0001]B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005\u001d\")!\u000b\u0001C\u0001'\"9a\u000b\u0001a\u0001\n\u00139\u0006bB2\u0001\u0001\u0004%I\u0001\u001a\u0005\u0007U\u0002\u0001\u000b\u0015\u0002-\t\u000f=\u0004!\u0019!C\u0005a\"1q\u000f\u0001Q\u0001\nEDQ\u0001\u001f\u0001\u0005\neDq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\n\u0003s\u0004\u0011\u0013!C\u0001\u0003wD\u0011B!\u0005\u0001#\u0003%\t!a?\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!Q\u0004\u0001\u0005B\t}\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003L\u0001!\tA!\u0014\t\u000f\tE\u0003\u0001\"\u0011\u0003T!9!\u0011\u000b\u0001\u0005\n\t\u001d\u0004b\u0002B6\u0001\u0011\u0005#Q\u000e\u0005\b\u0005g\u0002A\u0011\tB;\u0011\u001d\u0011Y\b\u0001C!\u0005{BqA!&\u0001\t\u0003\u00129\nC\u0004\u0003\u001e\u0002!\tEa(\t\u000f\t\u001d\u0006\u0001\"\u0011\u0003*\"9!Q\u0016\u0001\u0005B\t=\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011\u001d\u0011y\r\u0001C!\u0005#DqAa5\u0001\t\u0013\u0011)\u000eC\u0004\u0003Z\u0002!\tEa7\t\u000f\t%\b\u0001\"\u0001\u0003l\"9!Q\u001e\u0001\u0005\u0002\t=\bb\u0002B{\u0001\u0011\u0005#q\u001f\u0005\b\u0005k\u0004A\u0011\tB~\u0011\u001d\u0011y\u0010\u0001C\u0001\u0007\u0003Aqaa\u0002\u0001\t\u0003\u001aI\u0001C\u0004\u0004 \u0001!\ta!\t\t\u000f\rU\u0002\u0001\"\u0011\u00048!91Q\t\u0001\u0005B\r\u001d#AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!!\r\u001a\u0002\u00115,G/\u00193bi\u0006T!a\r\u001b\u0002\rM,'O^3s\u0015\u0005)\u0014!B6bM.\f7\u0001A\n\u0006\u0001ar$\t\u0013\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0002U\"\u0001\u001a\n\u0005\u0005\u0013$!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002D\r6\tAI\u0003\u0002Fi\u0005)Q\u000f^5mg&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h!\tI%*D\u00011\u0013\tY\u0005G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006A!M]8lKJLE-F\u0001O!\tIt*\u0003\u0002Qu\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002U+B\u0011\u0011\n\u0001\u0005\u0006\u0019\u000e\u0001\rAT\u0001\u000e?\u000e,(O]3oi&k\u0017mZ3\u0016\u0003a\u0003\"!W1\u000e\u0003iS!a\u0017/\u0002\u000b%l\u0017mZ3\u000b\u0005Uj&B\u00010`\u0003\u0019\t\u0007/Y2iK*\t\u0001-A\u0002pe\u001eL!A\u0019.\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003Ey6-\u001e:sK:$\u0018*\\1hK~#S-\u001d\u000b\u0003K\"\u0004\"!\u000f4\n\u0005\u001dT$\u0001B+oSRDq![\u0003\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nabX2veJ,g\u000e^%nC\u001e,\u0007\u0005\u000b\u0002\u0007YB\u0011\u0011(\\\u0005\u0003]j\u0012\u0001B^8mCRLG.Z\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014X#A9\u0011\u0005I,X\"A:\u000b\u0005Q$\u0014AC2p]R\u0014x\u000e\u001c7fe&\u0011ao\u001d\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002\n\u0001$\\1zE\u00164\u0015\u000e\u001c;fe\u0006c\u0017N^3SKBd\u0017nY1t)%Q\u0018\u0011CA\n\u0003;\t\t\u0004E\u0003|\u0003\u0003\t)!D\u0001}\u0015\tih0\u0001\u0003vi&d'\"A@\u0002\t)\fg/Y\u0005\u0004\u0003\u0007a(\u0001\u0002'jgR\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017q\u0018\u0001\u00027b]\u001eLA!a\u0004\u0002\n\t9\u0011J\u001c;fO\u0016\u0014\b\"B.\n\u0001\u0004A\u0006bBA\u000b\u0013\u0001\u0007\u0011qC\u0001\bEJ|7.\u001a:t!\u0011I\u0014\u0011\u0004(\n\u0007\u0005m!HA\u0003BeJ\f\u0017\u0010C\u0004\u0002 %\u0001\r!!\t\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u00059a.\u001a;x_J\\'bAA\u00169\u000611m\\7n_:LA!a\f\u0002&\taA*[:uK:,'OT1nK\"9\u00111G\u0005A\u0002\u0005U\u0012A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bcA\u001d\u00028%\u0019\u0011\u0011\b\u001e\u0003\u000f\t{w\u000e\\3b]\u0006a1-\u001e:sK:$\u0018*\\1hKR\t\u0001,\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0003\u0007\n9)!#\u0002\u001e\u0006}\u00151\u0015\t\u0006s\u0005\u0015\u0013\u0011J\u0005\u0004\u0003\u000fR$AB(qi&|g\u000e\u0005\u0004\u0002L\u0005m\u0013\u0011\r\b\u0005\u0003\u001b\n9F\u0004\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019FN\u0001\u0007yI|w\u000e\u001e \n\u0003mJ1!!\u0017;\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0018\u0002`\tA\u0011\n^3sCR|'OC\u0002\u0002Zi\u0002B!a\u0019\u0002\u0002:!\u0011QMA>\u001d\u0011\t9'a\u001e\u000f\t\u0005%\u0014Q\u000f\b\u0005\u0003W\n\u0019H\u0004\u0003\u0002n\u0005Ed\u0002BA(\u0003_J\u0011\u0001Y\u0005\u0003=~K!!N/\n\u0007\u0005-B,\u0003\u0003\u0002z\u0005%\u0012aB7fgN\fw-Z\u0005\u0005\u0003{\ny(\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003s\nI#\u0003\u0003\u0002\u0004\u0006\u0015%!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!! \u0002\u0000!)1l\u0003a\u00011\"9\u00111R\u0006A\u0002\u00055\u0015!\u0003;pa&\u001cg*Y7f!\u0011\ty)a&\u000f\t\u0005E\u00151\u0013\t\u0004\u0003\u001fR\u0014bAAKu\u00051\u0001K]3eK\u001aLA!!'\u0002\u001c\n11\u000b\u001e:j]\u001eT1!!&;\u0011\u001d\tyb\u0003a\u0001\u0003CAq!!)\f\u0001\u0004\t)$A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bbBAS\u0017\u0001\u0007\u0011QG\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\nhKR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001cHc\u0002>\u0002,\u00065\u00161\u0018\u0005\u000672\u0001\r\u0001\u0017\u0005\b\u0003_c\u0001\u0019AAY\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u00024\u0006]VBAA[\u0015\t\tD,\u0003\u0003\u0002:\u0006U&!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003?a\u0001\u0019AA\u0011\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0002B\u0006-\u0017QZAi!\u0015I\u0014QIAb!\u0011\t)-a2\u000e\u0005\u0005%\u0012\u0002BAe\u0003S\u0011AAT8eK\")1,\u0004a\u00011\"1\u0011qZ\u0007A\u00029\u000b!!\u001b3\t\u000f\u0005}Q\u00021\u0001\u0002\"\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003/\fI/a=\u0002v\u0006]\bCBAm\u0003?\f\u0019/\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0006m'aA*fcB!\u00111MAs\u0013\u0011\t9/!\"\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG\"9\u00111\u001e\bA\u0002\u00055\u0018A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002Z\u0006=\u0018QR\u0005\u0005\u0003c\fYNA\u0002TKRDq!a\b\u000f\u0001\u0004\t\t\u0003C\u0005\u0002\":\u0001\n\u00111\u0001\u00026!I\u0011Q\u0015\b\u0011\u0002\u0003\u0007\u0011QG\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0003{TC!!\u000e\u0002\u0000.\u0012!\u0011\u0001\t\u0005\u0005\u0007\u0011i!\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0003\fi\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0003\u0002n\n]\u0001b\u0002B\r#\u0001\u0007!1D\u0001\u0010i\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e_(qiB)\u0011(!\u0012\u0002\u000e\u0006\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\u0011\tC!\u000b\u0011\r\u0005e\u0017q\u001eB\u0012!\u0011\t)M!\n\n\t\t\u001d\u0012\u0011\u0006\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tYI\u0005a\u0001\u0003\u001b\u000b!bZ3u)>\u0004\u0018nY%e)\u0011\u0011yC!\u000e\u0011\t\u0005\u0015'\u0011G\u0005\u0005\u0005g\tIC\u0001\u0003Vk&$\u0007bBAF'\u0001\u0007\u0011QR\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u00057\u0011Y\u0004C\u0004\u0003>Q\u0001\rAa\f\u0002\u000fQ|\u0007/[2JI\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA\u001b\u0005\u0007BQ\u0001T\u000bA\u00029\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u00026\t%\u0003\"\u0002'\u0017\u0001\u0004q\u0015\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u00026\t=\u0003\"\u0002'\u0018\u0001\u0004q\u0015aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\tU\u0003CBA&\u0005/\u0012Y&\u0003\u0003\u0003Z\u0005}#\u0001C%uKJ\f'\r\\3\u0011\t\tu#1M\u0007\u0003\u0005?R1A!\u00195\u0003\u0015\tG-\\5o\u0013\u0011\u0011)Ga\u0018\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!Q\u000bB5\u0011\u0015Y\u0016\u00041\u0001Y\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005\u0005'q\u000eB9\u0011\u0015a%\u00041\u0001O\u0011\u001d\tyB\u0007a\u0001\u0003C\t1cZ3u\u00032Lg/\u001a\"s_.,'OT8eKN$BAa\u001e\u0003zA1\u0011\u0011\\Ap\u0003\u0007Dq!a\b\u001c\u0001\u0004\t\t#\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1!q\u0010BH\u0005#\u0003R!OA#\u0005\u0003\u0003BAa!\u0003\n:!\u0011Q\rBC\u0013\u0011\u00119)a \u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005\u0017\u0013iI\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t\u001d\u0015q\u0010\u0005\b\u0003\u0017c\u0002\u0019AAG\u0011\u0019\u0011\u0019\n\ba\u0001\u001d\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!\u0011\u0014BN!\u0011I\u0014Q\t(\t\u000f\u0005-U\u00041\u0001\u0002\u000e\u0006yAo\u001c9jG:\u000bW.Z:U_&#7\u000f\u0006\u0002\u0003\"B91Pa)\u0002\u000e\n=\u0012b\u0001BSy\n\u0019Q*\u00199\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"Aa+\u0011\u000fm\u0014\u0019Ka\f\u0002\u000e\u0006YAo\u001c9jG&#\u0017J\u001c4p)\t\u0011\t\fE\u0004:\u0005g\u0013\tKa+\n\u0007\tU&H\u0001\u0004UkBdWMM\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0003\u0003\u0014YL!0\u0003@\"9\u00111R\u0011A\u0002\u00055\u0005B\u0002BJC\u0001\u0007a\nC\u0004\u0002 \u0005\u0002\r!!\t\u00029\u001d,G\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1F]\u0012\u0004x.\u001b8ugR1!Q\u0019Be\u0005\u001b\u0004r!a$\u0003H:\u000b\u0019-\u0003\u0003\u0003&\u0006m\u0005b\u0002BfE\u0001\u0007!1E\u0001\u0003iBDq!a\b#\u0001\u0004\t\t#A\bhKR\u001cuN\u001c;s_2dWM]%e+\t\u0011I*\u0001\u000bhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u00053\u00139\u000eC\u0003\\I\u0001\u0007\u0001,\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGC\u0002Bo\u0005G\u00149\u000f\u0005\u0003\u0002F\n}\u0017\u0002\u0002Bq\u0003S\u0011qa\u00117vgR,'\u000fC\u0004\u0003f\u0016\u0002\r!!$\u0002\u0013\rdWo\u001d;fe&#\u0007bBA\u0010K\u0001\u0007\u0011\u0011E\u0001\u0018gR\fG/Z\"iC:<W\r\u0016:bG\u0016,e.\u00192mK\u0012$\"!!\u000e\u0002'1|wm\u0015;bi\u0016\u001c\u0005.\u00198hKR\u0013\u0018mY3\u0015\u0007\u0015\u0014\t\u0010C\u0004\u0003t\u001e\u0002\r!!$\u0002\u0007M$(/\u0001\u0005d_:$\u0018-\u001b8t)\u0011\t)D!?\t\u000f\u0005-\u0005\u00061\u0001\u0002\u000eR!\u0011Q\u0007B\u007f\u0011\u001d\u0011Y-\u000ba\u0001\u0005G\t\u0001b]3u\u00136\fw-\u001a\u000b\u0004K\u000e\r\u0001BBB\u0003U\u0001\u0007\u0001,\u0001\u0005oK^LU.Y4f\u0003\u0019\u0019wN\u001c4jOR!11BB\t!\rY8QB\u0005\u0004\u0007\u001fa(A\u0003)s_B,'\u000f^5fg\"911C\u0016A\u0002\rU\u0011AD2p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0007/\u0019Y\"\u0004\u0002\u0004\u001a)!1qAA\u0015\u0013\u0011\u0019ib!\u0007\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006!B-Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN$Baa\t\u0004,A!1QEB\u0014\u001b\t\ty(\u0003\u0003\u0004*\u0005}$\u0001\t#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a#bi\u0006Dqa!\f-\u0001\u0004\u0019y#A\u0004sKF,Xm\u001d;\u0011\t\r\u00152\u0011G\u0005\u0005\u0007g\tyHA\u0010EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e#bi\u0006\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u000b\u0003\u0007s\u0001Baa\u000f\u0004B5\u00111Q\b\u0006\u0005\u0003W\u0019yD\u0003\u000249&!11IB\u001f\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001\u00034fCR,(/Z:\u0015\u0005\r%\u0003cA \u0004L%\u00191Q\n\u001a\u00033\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7/\u00118e\u000bB|7\r\u001b")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (None$.MODULE$.equals(tenantPrefixOpt)) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (tenantPrefixOpt instanceof Some) {
            String tenantName = (String)((Some)tenantPrefixOpt).value();
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(tenantPrefixOpt);
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokers$1(x$8)))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(b.rack()))));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).flatMap((Function1 & Serializable)x$9 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$9.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokerNodes$1(x$10)))).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch)));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<Map<String, Uuid>, Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeaturesAndEpoch features() {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.Map features = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(image.features().finalizedVersions()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                Short level = (Short)x0$1._2();
                if (name != null && level != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short(level)));
                }
            }
            throw new MatchError(x0$1);
        });
        MetadataVersion version = image.features().metadataVersion();
        features.put((Object)"confluent.metadata.version", (Object)BoxesRunTime.boxToShort((short)version.confluentFeatureLevel()));
        return new FinalizedFeaturesAndEpoch((scala.collection.immutable.Map<String, Object>)features.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), image.highestOffsetAndEpoch().offset);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if (broker.fenced() || !broker.listeners().containsKey(listenerName$3.value())) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokers$1(BrokerRegistration x$8) {
        return !x$8.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokerNodes$1(BrokerRegistration x$10) {
        return !x$10.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int replicaId) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)replicaId);
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(replicaId));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable)() -> Node.noNode());
        } else {
            throw new MatchError((Object)option);
        }
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        topic.partitions().values().forEach(partition -> ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replicaId -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)replicaId)), ClassTag$.MODULE$.apply(Option.class)));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

