/*
 * Decompiled with CFR 0.152.
 */
package kafka.shell;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.OptionalLong;
import kafka.log.Defaults;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.shell.MetadataShellObserver;
import kafka.utils.KafkaScheduler;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.metadata.util.LocalMetadataLogReader;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.NonInteractiveShell;

class MetadataShellTool {
    MetadataShellTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MetadataShellObserver source;
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"metadata-shell-tool").defaultHelp(true).description("The Apache Kafka metadata tool");
        parser.addArgument(new String[]{"--cluster-id", "-t"}).help("The cluster id. Required when using --controllers");
        MutuallyExclusiveGroup accessGroup = parser.addMutuallyExclusiveGroup().required(true);
        accessGroup.addArgument(new String[]{"--directory", "-d"}).help("The __cluster_metadata-0 directory to read.");
        accessGroup.addArgument(new String[]{"--controllers", "-q"}).help("The controller.quorum.voters.");
        parser.addArgument(new String[]{"--offset", "-o"}).type(Long.TYPE).help("The offset to read up to");
        parser.addArgument(new String[]{"command"}).nargs("*").help("The command to run.");
        Namespace res = parser.parseArgsOrFail(args);
        if (res.getString("directory") != null) {
            TopicPartition topicPartitionArg = Topic.METADATA_TOPIC_PARTITION;
            Uuid topicArg = Uuid.METADATA_TOPIC_ID;
            File datadirArg = new File(res.get("directory").toString());
            KafkaScheduler schedulerArg = new KafkaScheduler(1, "scheduler", true, false);
            MetadataLogConfig configArg = new MetadataLogConfig(0x800000, 0x800000, 10000L, Long.MAX_VALUE, Long.MAX_VALUE, 0x800000, 0x800000, Defaults.FileDeleteDelayMs(), 1);
            KafkaMetadataLog metadataLog = KafkaMetadataLog.createWithoutRecovery(topicPartitionArg, topicArg, datadirArg, (Time)new SystemTime(), new Metrics(), schedulerArg, configArg);
            OptionalLong stopOffset = res.get("offset") != null ? OptionalLong.of(res.getLong("offset")) : OptionalLong.empty();
            source = new LocalMetadataLogReader((ReplicatedLog)metadataLog, stopOffset);
        } else if (res.getString("controllers") != null) {
            String clusterId = res.getString("cluster_id");
            if (clusterId == null || clusterId.isEmpty()) {
                throw new RuntimeException("You must provide --cluster-id when connecting directly to the controllers.");
            }
            source = MetadataShellObserver.create(res.getString("controllers"), clusterId);
        } else {
            throw new RuntimeException("You must set either --directory or --controllers");
        }
        try {
            InteractiveShell shell;
            List command = res.getList("command");
            if (command.isEmpty()) {
                shell = new InteractiveShell((ClusterMetadataSource)source);
                try {
                    shell.run();
                }
                finally {
                    shell.close();
                }
            }
            shell = new NonInteractiveShell((ClusterMetadataSource)source);
            try {
                shell.run((OutputStream)System.out, command);
            }
            finally {
                shell.close();
            }
            Exit.exit((int)0);
        }
        catch (Throwable e) {
            System.err.println("Unexpected error: " + (e.getMessage() == null ? "" : e.getMessage()));
            e.printStackTrace(System.err);
            Exit.exit((int)1);
        }
    }
}

