/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.MetadataSnapshotInitiate;
import kafka.tier.state.OffsetAndEpoch;

public class TierMetadataSnapshotInitiate
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotInitiate metadata;

    public TierMetadataSnapshotInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotInitiate.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotInitiate.buildMetadataSnapshotInitiate(builder, tierEpoch, objectId, stateOffset);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotInitiate.getRootAsMetadataSnapshotInitiate(builder.dataBuffer());
    }

    public TierMetadataSnapshotInitiate(TopicIdPartition topicIdPartition, MetadataSnapshotInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    static int buildMetadataSnapshotInitiate(FlatBufferBuilder builder, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        MetadataSnapshotInitiate.startMetadataSnapshotInitiate(builder);
        MetadataSnapshotInitiate.addVersion(builder, (byte)1);
        MetadataSnapshotInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        MetadataSnapshotInitiate.addObjectId(builder, objectIdOffset);
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        MetadataSnapshotInitiate.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        return MetadataSnapshotInitiate.endMetadataSnapshotInitiate(builder);
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "MetadataSnapshotInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", )";
    }
}

