/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.nio.ByteBuffer;
import kafka.log.TimestampOffset;
import kafka.tier.fetcher.AbstractInputStreamFixedSizeIterator;

class TierTimestampIndexIterator
extends AbstractInputStreamFixedSizeIterator<TimestampOffset> {
    private static final int TIMESTAMP_ENTRY_SIZE = 8;
    private static final int RELATIVE_OFFSET_ENTRY_SIZE = 4;
    private static final int TIMESTAMP_OFFSET_ENTRY_SIZE = 12;
    private final long base;

    TierTimestampIndexIterator(InputStream inputStream, long base) {
        super(inputStream, 12);
        this.base = base;
    }

    @Override
    TimestampOffset toIndexEntry() {
        if (this.indexEntryBytes.length != 12) {
            throw new IllegalArgumentException("TimestampIndex entries must be 12 bytes");
        }
        ByteBuffer buf = ByteBuffer.wrap(this.indexEntryBytes);
        long timestamp = buf.getLong();
        int relativeOffset = buf.getInt();
        return TimestampOffset.apply(timestamp, (long)relativeOffset + this.base);
    }
}

