/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.CoreUtils;

public class Header {
    static final int HEADER_LENGTH_LENGTH = 2;
    private final TierPartitionStateHeader header;
    private final MaterializationInfo materializationInfo;

    Header(TierPartitionStateHeader header) {
        this.header = header;
        this.materializationInfo = new MaterializationInfo(header.materializationInfo());
    }

    public Header(UUID topicId, byte version, int tierEpoch, TierPartitionStatus status, long startOffset, long endOffset, OffsetAndEpoch globalMaterializedOffsetAndEpoch, OffsetAndEpoch localMaterializedOffsetAndEpoch, OffsetAndEpoch errorOffsetAndEpoch, OffsetAndEpoch lastRestoredOffsetAndEpoch, boolean hasStateChangeTimestamp) {
        this(topicId, version, tierEpoch, status, startOffset, endOffset, globalMaterializedOffsetAndEpoch, localMaterializedOffsetAndEpoch, errorOffsetAndEpoch, lastRestoredOffsetAndEpoch, false, -1L, CompactStats.EMPTY, CompactStats.EMPTY, hasStateChangeTimestamp);
    }

    public Header(UUID topicId, byte version, int tierEpoch, TierPartitionStatus status, long startOffset, long endOffset, OffsetAndEpoch globalMaterializedOffsetAndEpoch, OffsetAndEpoch localMaterializedOffsetAndEpoch, OffsetAndEpoch errorOffsetAndEpoch, OffsetAndEpoch lastRestoredOffsetAndEpoch, boolean compactFeatureFlag, long compactDirtyStartOffset, CompactStats lastCompactStats, CompactStats accumulatedCompactStats, boolean hasStateChangeTimestamp) {
        if (tierEpoch < -1) {
            throw new IllegalArgumentException("Illegal tierEpoch " + tierEpoch);
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
        int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo(builder, globalMaterializedOffsetAndEpoch.offset(), localMaterializedOffsetAndEpoch.offset(), globalMaterializedOffsetAndEpoch.epoch().orElse(-1), localMaterializedOffsetAndEpoch.epoch().orElse(-1));
        TierPartitionStateHeader.startTierPartitionStateHeader(builder);
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID(builder, topicId.getMostSignificantBits(), topicId.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId(builder, topicIdOffset);
        TierPartitionStateHeader.addTierEpoch(builder, tierEpoch);
        TierPartitionStateHeader.addVersion(builder, version);
        TierPartitionStateHeader.addStatus(builder, TierPartitionStatus.toByte(status));
        TierPartitionStateHeader.addStartOffset(builder, startOffset);
        TierPartitionStateHeader.addEndOffset(builder, endOffset);
        TierPartitionStateHeader.addMaterializationInfo(builder, materializedInfo);
        int errorOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, errorOffsetAndEpoch.offset(), errorOffsetAndEpoch.epoch().orElse(-1));
        TierPartitionStateHeader.addErrorOffsetAndEpoch(builder, errorOffsetAndEpochId);
        int restoreId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, lastRestoredOffsetAndEpoch.offset(), lastRestoredOffsetAndEpoch.epoch().orElse(-1));
        TierPartitionStateHeader.addRestoreOffsetAndEpoch(builder, restoreId);
        if (compactFeatureFlag) {
            TierPartitionStateHeader.addCompactDirtyStartOffset(builder, compactDirtyStartOffset);
            int lastCompactStatsOffset = kafka.tier.serdes.CompactStats.createCompactStats(builder, lastCompactStats.bytesRead(), lastCompactStats.bytesWritten(), lastCompactStats.dirtyBytesRead());
            TierPartitionStateHeader.addLastCompactStats(builder, lastCompactStatsOffset);
            int accumulatedCompactStatsOffset = kafka.tier.serdes.CompactStats.createCompactStats(builder, accumulatedCompactStats.bytesRead(), accumulatedCompactStats.bytesWritten(), accumulatedCompactStats.dirtyBytesRead());
            TierPartitionStateHeader.addAccumulatedCompactStats(builder, accumulatedCompactStatsOffset);
        }
        TierPartitionStateHeader.addHasStateChangeTimestamp(builder, hasStateChangeTimestamp);
        int entryId = TierPartitionStateHeader.endTierPartitionStateHeader(builder);
        builder.finish(entryId);
        this.header = TierPartitionStateHeader.getRootAsTierPartitionStateHeader(builder.dataBuffer());
        this.materializationInfo = new MaterializationInfo(this.header.materializationInfo());
    }

    ByteBuffer payloadBuffer() {
        return this.header.getByteBuffer().duplicate();
    }

    public int tierEpoch() {
        return this.header.tierEpoch();
    }

    public UUID topicId() {
        return new UUID(this.header.topicId().mostSignificantBits(), this.header.topicId().leastSignificantBits());
    }

    public TierPartitionStatus status() {
        return TierPartitionStatus.fromByte(this.header.status());
    }

    public long startOffset() {
        return this.header.startOffset();
    }

    public void mutateStartOffset(long startOffset) {
        this.header.mutateStartOffset(startOffset);
    }

    public long endOffset() {
        return this.header.endOffset();
    }

    public long size() {
        return this.payloadBuffer().remaining() + 2;
    }

    public short version() {
        return this.header.version();
    }

    public byte versionInByte() {
        return this.header.version();
    }

    public OffsetAndEpoch localMaterializedOffsetAndEpoch() {
        return this.materializationInfo.localMaterializedOffsetAndEpoch();
    }

    public OffsetAndEpoch globalMaterializedOffsetAndEpoch() {
        return this.materializationInfo.globalMaterializedOffsetAndEpoch();
    }

    public OffsetAndEpoch restoreOffsetAndEpoch() {
        return this.header.restoreOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.header.restoreOffsetAndEpoch());
    }

    public OffsetAndEpoch errorOffsetAndEpoch() {
        return this.header.errorOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.header.errorOffsetAndEpoch());
    }

    public long compactDirtyStartOffset() {
        return this.header.compactDirtyStartOffset();
    }

    public CompactStats lastCompactStats() {
        return this.header.lastCompactStats() == null ? CompactStats.EMPTY : new CompactStats(this.header.lastCompactStats());
    }

    public CompactStats accumulatedCompactStats() {
        return this.header.accumulatedCompactStats() == null ? CompactStats.EMPTY : new CompactStats(this.header.accumulatedCompactStats());
    }

    public boolean hasStateChangeTimestamp() {
        return this.header.hasStateChangeTimestamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header that = (Header)o;
        return Objects.equals(this.version(), that.version()) && Objects.equals(this.topicId(), that.topicId()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals((Object)this.status(), (Object)that.status()) && Objects.equals(this.startOffset(), that.startOffset()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.errorOffsetAndEpoch(), that.errorOffsetAndEpoch()) && Objects.equals(this.restoreOffsetAndEpoch(), that.restoreOffsetAndEpoch()) && Objects.equals(this.materializationInfo, that.materializationInfo) && Objects.equals(this.compactDirtyStartOffset(), that.compactDirtyStartOffset()) && Objects.equals(this.lastCompactStats(), that.lastCompactStats()) && Objects.equals(this.accumulatedCompactStats(), that.accumulatedCompactStats()) && Objects.equals(this.hasStateChangeTimestamp(), that.hasStateChangeTimestamp());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version(), this.topicId(), this.tierEpoch(), this.status(), this.startOffset(), this.endOffset(), this.restoreOffsetAndEpoch(), this.errorOffsetAndEpoch(), this.materializationInfo});
    }

    public String toString() {
        return "Header(version=" + this.version() + ", topicId=" + CoreUtils.uuidToBase64(this.topicId()) + ", tierEpoch=" + this.tierEpoch() + ", status=" + (Object)((Object)this.status()) + ", startOffset=" + this.startOffset() + ", endOffset=" + this.endOffset() + ", errorOffsetAndEpoch=" + this.errorOffsetAndEpoch() + ", restoreOffsetAndEpoch=" + this.restoreOffsetAndEpoch() + ", materializationInfo=" + this.materializationInfo + ", compactCleanCheckpoint=" + this.compactDirtyStartOffset() + ", lastCompactStats=" + this.lastCompactStats() + ", accumulatedCompactStats=" + this.accumulatedCompactStats() + ", hasStateChangeTimestamp=" + this.hasStateChangeTimestamp() + ")";
    }

    private static OffsetAndEpoch toOffsetAndEpoch(long offset, int epoch) {
        Optional<Integer> epochOpt = epoch == -1 ? Optional.empty() : Optional.of(epoch);
        return new OffsetAndEpoch(offset, epochOpt);
    }

    static class MaterializationInfo {
        OffsetAndEpoch globalMaterializedOffsetAndEpoch;
        OffsetAndEpoch localMaterializedOffsetAndEpoch;

        MaterializationInfo(MaterializationTrackingInfo info) {
            if (info == null) {
                FlatBufferBuilder builder = new FlatBufferBuilder(100);
                MaterializationTrackingInfo.startMaterializationTrackingInfo(builder);
                int entryId = MaterializationTrackingInfo.endMaterializationTrackingInfo(builder);
                builder.finish(entryId);
                info = MaterializationTrackingInfo.getRootAsMaterializationTrackingInfo(builder.dataBuffer());
            }
            this.globalMaterializedOffsetAndEpoch = Header.toOffsetAndEpoch(info.globalMaterializedOffset(), info.globalMaterializedEpoch());
            this.localMaterializedOffsetAndEpoch = Header.toOffsetAndEpoch(info.localMaterializedOffset(), info.localMaterializedEpoch());
        }

        OffsetAndEpoch globalMaterializedOffsetAndEpoch() {
            return this.globalMaterializedOffsetAndEpoch;
        }

        OffsetAndEpoch localMaterializedOffsetAndEpoch() {
            return this.localMaterializedOffsetAndEpoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterializationInfo that = (MaterializationInfo)o;
            return Objects.equals(this.localMaterializedOffsetAndEpoch(), that.localMaterializedOffsetAndEpoch()) && Objects.equals(this.globalMaterializedOffsetAndEpoch(), that.globalMaterializedOffsetAndEpoch());
        }

        public int hashCode() {
            return Objects.hash(this.localMaterializedOffsetAndEpoch(), this.globalMaterializedOffsetAndEpoch());
        }

        public String toString() {
            return "MaterializationInfo(localMaterializedOffset=" + this.localMaterializedOffsetAndEpoch() + ", globalMaterializedOffset=" + this.globalMaterializedOffsetAndEpoch() + ")";
        }
    }
}

