/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g!\u0002\f\u0018\u0003\u0003q\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000bq\u0002A\u0011A\u001f\t\u0011%\u0003\u0001\u0019!C\u00013)C\u0001B\u0014\u0001A\u0002\u0013\u0005\u0011d\u0014\u0005\u0007+\u0002\u0001\u000b\u0015B&\t\u000fi\u0003\u0001\u0019!C\u00057\"9Q\r\u0001a\u0001\n\u00131\u0007B\u00025\u0001A\u0003&A\fC\u0004k\u0001\u0001\u0007I\u0011B6\t\u000fe\u0004\u0001\u0019!C\u0005u\"1A\u0010\u0001Q!\n1DQA \u0001\u0007\u0002}Dq!!\u0003\u0001\r\u0003\tY\u0001C\u0004\u0002\u001a\u00011\t!a\u0007\t\r\u0005U\u0005\u0001\"\u0001\\\u0011\u001d\t9\n\u0001C\u0001\u00033Cq!!)\u0001\t\u0003\t\u0019\u000b\u0003\u0005\u0002.\u0002!\tbFAX\u0011!\t\u0019\r\u0001C\t/\u0005\u0015\u0007bBAe\u0001\u0011E\u00111\u001a\u0005\b\u0003\u001b\u0004A\u0011CAh\u0005!!\u0016.\u001a:UCN\\'B\u0001\r\u001a\u0003\u0015!\u0018m]6t\u0015\tQ2$\u0001\u0003uS\u0016\u0014(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001U\u0011qDQ\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(U5\t\u0001F\u0003\u0002*7\u0005)Q\u000f^5mg&\u00111\u0006\u000b\u0002\b\u0019><w-\u001b8h\u00031\u0011X\r\u001e:z%\u0006$Xm\u00149u!\r\tc\u0006M\u0005\u0003_\t\u0012aa\u00149uS>t\u0007CA\u0019;\u001b\u0005\u0011$BA\u001a5\u0003\u0011\u0019wN]3\u000b\u0005U2\u0014aB7fiJL7m\u001d\u0006\u0003oa\na!_1n[\u0016\u0014(\"A\u001d\u0002\u0007\r|W.\u0003\u0002<e\t)Q*\u001a;fe\u00061A(\u001b8jiz\"\"A\u0010%\u0011\u0007}\u0002\u0001)D\u0001\u0018!\t\t%\t\u0004\u0001\u0005\u000b\r\u0003!\u0019\u0001#\u0003\u0003Q\u000b\"!\u0012 \u0011\u0005\u00052\u0015BA$#\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\f\u0002A\u00025\n!B]3uef\u001cu.\u001e8u+\u0005Y\u0005CA\u0011M\u0013\ti%EA\u0002J]R\faB]3uef\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011\u0011%U\u0005\u0003%\n\u0012A!\u00168ji\"9A\u000bBA\u0001\u0002\u0004Y\u0015a\u0001=%c\u0005Y!/\u001a;ss\u000e{WO\u001c;!Q\t)q\u000b\u0005\u0002\"1&\u0011\u0011L\t\u0002\tm>d\u0017\r^5mK\u0006aq\f]1vg\u0016$WK\u001c;jYV\tA\fE\u0002\"]u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\tQLW.\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wLA\u0004J]N$\u0018M\u001c;\u0002!}\u0003\u0018-^:fIVsG/\u001b7`I\u0015\fHC\u0001)h\u0011\u001d!v!!AA\u0002q\u000bQb\u00189bkN,G-\u00168uS2\u0004\u0003F\u0001\u0005X\u0003\u0019yVM\u001d:peV\tA\u000eE\u0002\"]5\u0004\"A\u001c<\u000f\u0005=$hB\u00019t\u001b\u0005\t(B\u0001:\u001e\u0003\u0019a$o\\8u}%\t1%\u0003\u0002vE\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005%!\u0006N]8xC\ndWM\u0003\u0002vE\u0005Qq,\u001a:s_J|F%Z9\u0015\u0005A[\bb\u0002+\u000b\u0003\u0003\u0005\r\u0001\\\u0001\b?\u0016\u0014(o\u001c:!Q\tYq+\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\t)!D\u0001\u001a\u0013\r\t9!\u0007\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f1a\u0019;y+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\"G\u0001\bM\u0016$8\r[3s\u0013\u0011\t9\"!\u0005\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\b\u0002\u001e\u0005U\u0012qJA0\u0003_\ny(!#\u0015\t\u0005}\u00111\u0006\t\u0006\u0003C\t9\u0003Q\u0007\u0003\u0003GQ1!!\n#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003S\t\u0019C\u0001\u0004GkR,(/\u001a\u0005\b\u0003[q\u00019AA\u0018\u0003\t)7\r\u0005\u0003\u0002\"\u0005E\u0012\u0002BA\u001a\u0003G\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\r\u0001t\u0001\u0019AA\u001c!\u0011\tI$a\u0013\u000e\u0005\u0005m\"bA\u0015\u0002>)!\u0011qHA!\u0003\u0019\u0019w.\\7p]*\u0019A$a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0013aA8sO&!\u0011QJA\u001e\u0005\u0011!\u0016.\\3\t\u000f\u0005Ec\u00021\u0001\u0002T\u0005\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u001a\u0003\u0015!x\u000e]5d\u0013\u0011\ti&a\u0016\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u0002b9\u0001\r!a\u0019\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SJ\u0012!B:u_J,\u0017\u0002BA7\u0003O\u0012q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003cr\u0001\u0019AA:\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sZ\u0012AB:feZ,'/\u0003\u0003\u0002~\u0005]$A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003\u0003s\u0001\u0019AAB\u0003\u0019\u0019wN\u001c4jOB\u0019q(!\"\n\u0007\u0005\u001duCA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0011\u001d\tYI\u0004a\u0001\u0003\u001b\u000b\u0011\u0002\u001e5s_R$H.\u001a:\u0011\t\u0005r\u0013q\u0012\t\u0004O\u0005E\u0015bAAJQ\tIA\u000b\u001b:piRdWM]\u0001\fa\u0006,8/\u001a3V]RLG.\u0001\u0007jg\u0016\u0013(o\u001c:Ti\u0006$X-\u0006\u0002\u0002\u001cB\u0019\u0011%!(\n\u0007\u0005}%EA\u0004C_>dW-\u00198\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011Q\u0015\t\u0005\u0003O\u000bI+\u0004\u0002\u0002>%!\u00111VA\u001f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\faB]3uef$\u0016m]6MCR,'\u000fF\u0004Q\u0003c\u000b),a0\t\r\u0005M&\u00031\u0001L\u0003Ei\u0017\r\u001f*fiJL()Y2l_\u001a4Wj\u001d\u0005\b\u0003o\u0013\u0002\u0019AA]\u0003\u0015qwn^'t!\r\t\u00131X\u0005\u0004\u0003{\u0013#\u0001\u0002'p]\u001eDa!!1\u0013\u0001\u0004i\u0017!\u0001;\u0002-\r\fgnY3m\u0003:$7+\u001a;FeJ|'o\u0015;bi\u0016$2\u0001UAd\u0011\u0019\t\tm\u0005a\u0001[\u00061rN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eF\u0001Q\u0003}ygnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>tw+\u001b;i\t\u0016d\u0017-\u001f\u000b\u0006!\u0006E\u0017Q\u001b\u0005\b\u0003',\u0002\u0019AA]\u0003\u001d!W\r\\1z\u001bNDq!a.\u0016\u0001\u0004\tI\f")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private volatile Option<Throwable> _error;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Option<Throwable> _error() {
        return this._error;
    }

    private void _error_$eq(Option<Throwable> x$1) {
        this._error = x$1;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return this._error().isDefined();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1 & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(pauseMs).append("ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void cancelAndSetErrorState(Throwable t) {
        this._error_$eq((Option<Throwable>)new Some((Object)t));
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._error = None$.MODULE$;
    }
}

