/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.HeartbeatingShutdownableThread;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t}f\u0001B\u001c9\u0001}B\u0001\"\u0016\u0001\u0003\u0002\u0004%\tA\u0016\u0005\t7\u0002\u0011\t\u0019!C\u00019\"AQ\r\u0001B\u0001B\u0003&q\u000b\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011]\u0004!\u0011!Q\u0001\naD\u0001B \u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003s\u0001A\u0011KA\u001e\u0011%\t\u0019\u0006\u0001a\u0001\n\u0013\t)\u0006C\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002`!A\u00111\r\u0001!B\u0013\t9\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011Q\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002z!A\u0011q\u0012\u0001!\u0002\u0013\tY\bC\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003\u0002\u0014\"A\u0011Q\u0015\u0001!\u0002\u0013\t)\nC\u0005\u0002(\u0002\u0001\r\u0011\"\u0003\u0002*\"I\u0011q\u0017\u0001A\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003{\u0003\u0001\u0015)\u0003\u0002,\"Q\u0011q\u0018\u0001C\u0002\u0013\u0005!(!\u001f\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003wB\u0011\"a1\u0001\u0005\u0004%I!!2\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u000fD\u0011\"a5\u0001\u0005\u0004%I!!6\t\u0011\u0005\r\b\u0001)A\u0005\u0003/D\u0011\"!:\u0001\u0005\u0004%I!a:\t\u0011\u0005U\b\u0001)A\u0005\u0003SD!\"a>\u0001\u0005\u0004%\tAOA}\u0011!\u0011I\u0001\u0001Q\u0001\n\u0005m\b\"\u0003B\u0006\u0001\t\u0007I\u0011\u0002B\u0007\u0011!\u0011)\u0002\u0001Q\u0001\n\t=\u0001\"\u0003B\f\u0001\t\u0007I\u0011\u0002B\r\u0011!\u0011\t\u0004\u0001Q\u0001\n\tm\u0001b\u0002B\u001a\u0001\u0011\u0005#Q\u0007\u0005\b\u0005o\u0001A\u0011\u0001B\u001b\u0011\u001d\u0011I\u0004\u0001C!\u0005kAqAa\u000f\u0001\t\u0003\u0011i\u0004C\u0004\u0003F\u0001!\tAa\u0012\t\u000f\tE\u0003\u0001\"\u0011\u0003T!9!Q\f\u0001\u0005B\t}\u0003b\u0002B6\u0001\u0011\u0005#Q\u000e\u0005\t\u0005W\u0002A\u0011\u0001\u001e\u0003v\u001d9!1\u0010\u001d\t\u0002\tudAB\u001c9\u0011\u0003\u0011y\bC\u0004\u0002&A\"\tAa\"\t\u0013\t%\u0005G1A\u0005\u0006\t-\u0005\u0002\u0003BJa\u0001\u0006iA!$\t\u0013\tU\u0005G1A\u0005\u0002\t]\u0005\u0002\u0003BSa\u0001\u0006IA!'\t\u0013\t\u001d\u0006'%A\u0005\u0002\t%&!\u0003+jKJ$\u0016m]6t\u0015\tI$(A\u0003uCN\\7O\u0003\u0002<y\u0005!A/[3s\u0015\u0005i\u0014!B6bM.\f7\u0001A\n\u0006\u0001\u00013Ej\u0014\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007r\nQ!\u001e;jYNL!!\u0012\"\u0003=!+\u0017M\u001d;cK\u0006$\u0018N\\4TQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007CA$K\u001b\u0005A%BA%=\u0003\u001diW\r\u001e:jGNL!a\u0013%\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002B\u001b&\u0011aJ\u0011\u0002\b\u0019><w-\u001b8h!\t\u00016+D\u0001R\u0015\t\u0011F(\u0001\u0004tKJ4XM]\u0005\u0003)F\u0013AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017AB2p]\u001aLw-F\u0001X!\tA\u0016,D\u00019\u0013\tQ\u0006HA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003;\u000e\u0004\"AX1\u000e\u0003}S\u0011\u0001Y\u0001\u0006g\u000e\fG.Y\u0005\u0003E~\u0013A!\u00168ji\"9AMAA\u0001\u0002\u00049\u0016a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003FA\u0002h!\tq\u0006.\u0003\u0002j?\nAao\u001c7bi&dW-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005Ac\u0017BA7R\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0001/]\u0007\u0002u%\u0011!O\u000f\u0002\u0013)&,'OU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\u0011uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\bC\u00019v\u0013\t1(H\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\u0018!\u0005;jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feB\u0011\u0011\u0010`\u0007\u0002u*\u00111PO\u0001\u0006i>\u0004\u0018nY\u0005\u0003{j\u0014\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s\u0003=!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015!(A\u0003ti>\u0014X-\u0003\u0003\u0002\n\u0005\r!a\u0004+jKJ|%M[3diN#xN]3\u0002\tQLW.\u001a\t\u0005\u0003\u001f\t\t#\u0004\u0002\u0002\u0012)\u00191)a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007G>lWn\u001c8\u000b\u0007u\nIB\u0003\u0003\u0002\u001c\u0005u\u0011AB1qC\u000eDWM\u0003\u0002\u0002 \u0005\u0019qN]4\n\t\u0005\r\u0012\u0011\u0003\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b\u0003o\u0001\"\u0001\u0017\u0001\t\u000bUS\u0001\u0019A,\t\u000b)T\u0001\u0019A6\t\u000b9T\u0001\u0019A8\t\u000bMT\u0001\u0019\u0001;\t\u000b]T\u0001\u0019\u0001=\t\u000byT\u0001\u0019A@\t\u0013\u0005-!\u0002%AA\u0002\u00055\u0011A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\b\t\u0005\u0003\u007f\tiE\u0004\u0003\u0002B\u0005%\u0003cAA\"?6\u0011\u0011Q\t\u0006\u0004\u0003\u000fr\u0014A\u0002\u001fs_>$h(C\u0002\u0002L}\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA(\u0003#\u0012aa\u0015;sS:<'bAA&?\u0006\u0011B.Y:u\u0019\u0006<\u0007K]5oiRKW.Z't+\t\t9\u0006E\u0002_\u00033J1!a\u0017`\u0005\u0011auN\\4\u0002-1\f7\u000f\u001e'bOB\u0013\u0018N\u001c;US6,Wj]0%KF$2!XA1\u0011!!W\"!AA\u0002\u0005]\u0013a\u00057bgRd\u0015m\u001a)sS:$H+[7f\u001bN\u0004\u0013aA2uqV\u0011\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\u001e\u0002\u000f\u0019,Go\u00195fe&!\u00111OA7\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003\u0011\u0019G\u000f\u001f\u0011\u0002/\u0005\u00148\r[5wK\u0012+G.\u001a;j_:,\u00050Z2vi>\u0014XCAA>!\u0011\ti(a#\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t))a\"\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0013\u000bAA[1wC&!\u0011QRA@\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001G1sG\"Lg/\u001a#fY\u0016$\u0018n\u001c8Fq\u0016\u001cW\u000f^8sA\u0005q1\r\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cXCAAK!\u0019\t9*!)\u0002X5\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0004nkR\f'\r\\3\u000b\u0007\u0005}u,\u0001\u0006d_2dWm\u0019;j_:LA!a)\u0002\u001a\nY\u0011I\u001d:bs\n+hMZ3s\u0003=\u0019G.Z1oKJ$\u0006N]3bIN\u0004\u0013A\u0006;jKJ\u001cu.\u001c9bGRLwN\\\"qk6+G/\u001a:\u0016\u0005\u0005-\u0006#\u00020\u0002.\u0006E\u0016bAAX?\n1q\n\u001d;j_:\u00042!QAZ\u0013\r\t)L\u0011\u0002\u0010)\"\u0014X-\u00193t\u0007B,X*\u001a;fe\u0006QB/[3s\u0007>l\u0007/Y2uS>t7\t];NKR,'o\u0018\u0013fcR\u0019Q,a/\t\u0011\u00114\u0012\u0011!a\u0001\u0003W\u000bq\u0003^5fe\u000e{W\u000e]1di&|gn\u00119v\u001b\u0016$XM\u001d\u0011\u0002!\rdW-\u00198j]\u001e,\u00050Z2vi>\u0014\u0018!E2mK\u0006t\u0017N\\4Fq\u0016\u001cW\u000f^8sA\u0005\u0019\u0012M]2iSZ,G)\u001a7fi&|g\u000eU8pYV\u0011\u0011q\u0019\t\u0005\u0003\u0013\fi-\u0004\u0002\u0002L*\u0019\u0011\u0011Q0\n\t\u0005=\u00171\u001a\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018\u0001F1sG\"Lg/\u001a#fY\u0016$\u0018n\u001c8Q_>d\u0007%\u0001\u0007uS\u0016\u0014\u0018I]2iSZ,'/\u0006\u0002\u0002XB!\u0011\u0011\\Ap\u001b\t\tYNC\u0002\u0002^b\nq!\u0019:dQ&4X-\u0003\u0003\u0002b\u0006m'\u0001\u0004+jKJ\f%o\u00195jm\u0016\u0014\u0018!\u0004;jKJ\f%o\u00195jm\u0016\u0014\b%A\nuS\u0016\u0014H)\u001a7fi&|g.T1oC\u001e,'/\u0006\u0002\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002pb\na\u0001Z3mKR,\u0017\u0002BAz\u0003[\u00141\u0003V5fe\u0012+G.\u001a;j_:l\u0015M\\1hKJ\fA\u0003^5fe\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\u0013!\u0006;jKJdunZ\"mK\u0006tWM]'b]\u0006<WM]\u000b\u0003\u0003w\u0004RAXAW\u0003{\u0004B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0004\u0005\u0007A\u0014AC2p[B\f7\r^5p]&!!q\u0001B\u0001\u0005U!\u0016.\u001a:M_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fa\u0003^5fe2{wm\u00117fC:,'/T1oC\u001e,'\u000fI\u0001\u000eG\"\fgnZ3NC:\fw-\u001a:\u0016\u0005\t=\u0001c\u0001-\u0003\u0012%\u0019!1\u0003\u001d\u0003\u001b\rC\u0017M\\4f\u001b\u0006t\u0017mZ3s\u00039\u0019\u0007.\u00198hK6\u000bg.Y4fe\u0002\nqbY=dY\u0016$\u0016.\\3NKR\u0014\u0018nY\u000b\u0003\u00057\u0001BA!\b\u0003.5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#\u0001\u0003d_J,'bA%\u0003&)!!q\u0005B\u0015\u0003\u0019I\u0018-\\7fe*\u0011!1F\u0001\u0004G>l\u0017\u0002\u0002B\u0018\u0005?\u0011Q!T3uKJ\f\u0001cY=dY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u0011\u0002\r\u0011|wk\u001c:l)\u0005i\u0016aG7bs\n,Gj\\4US\u0016\u0014\u0018I]2iSZ,'\u000fT1h\u0013:4w.\u0001\u0005tQV$Hm\\<o\u0003E\t'o\u00195jm\u0016\u0014H+Y:l#V,W/Z\u000b\u0003\u0005\u007f\u0001B!!7\u0003B%!!1IAn\u0005E\t%o\u00195jm\u0016\u0014H+Y:l#V,W/Z\u0001\u0014G>l\u0007/Y2uS>tG+Y:l#V,W/Z\u000b\u0003\u0005\u0013\u0002RAXAW\u0005\u0017\u0002B!a@\u0003N%!!q\nB\u0001\u0005M\u0019u.\u001c9bGRLwN\u001c+bg.\fV/Z;f\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"A!\u0016\u0011\r\t]#\u0011LA\u001f\u001b\t\ti*\u0003\u0003\u0003\\\u0005u%aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004;\n\u0005\u0004b\u0002B2Y\u0001\u0007!QM\u0001\n]\u0016<8i\u001c8gS\u001e\u00042\u0001\u0015B4\u0013\r\u0011I'\u0015\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,G#B/\u0003p\tM\u0004b\u0002B9[\u0001\u0007!QM\u0001\n_2$7i\u001c8gS\u001eDqAa\u0019.\u0001\u0004\u0011)\u0007F\u0003^\u0005o\u0012I\b\u0003\u0004\u0003r9\u0002\ra\u0016\u0005\u0007\u0005Gr\u0003\u0019A,\u0002\u0013QKWM\u001d+bg.\u001c\bC\u0001-1'\r\u0001$\u0011\u0011\t\u0004=\n\r\u0015b\u0001BC?\n1\u0011I\\=SK\u001a$\"A! \u0002'A+%+S(E\u0013\u000e{FjT$`\u0019\u0006;u,T*\u0016\u0005\t5\u0005c\u00010\u0003\u0010&\u0019!\u0011S0\u0003\u0007%sG/\u0001\u000bQ\u000bJKu\nR%D?2{ui\u0018'B\u000f~k5\u000bI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011I\n\u0005\u0004\u0003X\te#1\u0014\t\u0005\u0005;\u0013\u0019+\u0004\u0002\u0003 *!!\u0011UAD\u0003\u0011a\u0017M\\4\n\t\u0005=#qT\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"Aa++\t\u00055!QV\u0016\u0003\u0005_\u0003BA!-\u0003<6\u0011!1\u0017\u0006\u0005\u0005k\u00139,A\u0005v]\u000eDWmY6fI*\u0019!\u0011X0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003>\nM&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TierTasks
extends HeartbeatingShutdownableThread
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private volatile TierTasksConfig config;
    private final TierTopicAppender tierTopicAppender;
    private final Time time;
    private long lastLagPrintTimeMs;
    private final CancellationContext ctx;
    private final ExecutorService archiveDeletionExecutor;
    private final ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads;
    private Option<ThreadsCpuMeter> kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    private final ExecutorService cleaningExecutor;
    private final ExecutionContextExecutor archiveDeletionPool;
    private final TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver;
    private final TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager;
    private final Option<TierLogCleanerManager> tierLogCleanerManager;
    private final ChangeManager changeManager;
    private final Meter cycleTimeMetric;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    public static Set<String> ReconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    public static int PERIODIC_LOG_LAG_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    public TierTasksConfig config() {
        return this.config;
    }

    public void config_$eq(TierTasksConfig x$1) {
        this.config = x$1;
    }

    @Override
    public String loggerName() {
        return TierTasks.class.getName();
    }

    private long lastLagPrintTimeMs() {
        return this.lastLagPrintTimeMs;
    }

    private void lastLagPrintTimeMs_$eq(long x$1) {
        this.lastLagPrintTimeMs = x$1;
    }

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ExecutorService archiveDeletionExecutor() {
        return this.archiveDeletionExecutor;
    }

    public ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads() {
        return this.kafka$tier$tasks$TierTasks$$cleanerThreads;
    }

    private Option<ThreadsCpuMeter> tierCompactionCpuMeter() {
        return this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    }

    public void kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = x$1;
    }

    public ExecutorService cleaningExecutor() {
        return this.cleaningExecutor;
    }

    private ExecutionContextExecutor archiveDeletionPool() {
        return this.archiveDeletionPool;
    }

    public TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver;
    }

    public TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager() {
        return this.kafka$tier$tasks$TierTasks$$tierDeletionManager;
    }

    public Option<TierLogCleanerManager> tierLogCleanerManager() {
        return this.tierLogCleanerManager;
    }

    private ChangeManager changeManager() {
        return this.changeManager;
    }

    private Meter cycleTimeMetric() {
        return this.cycleTimeMetric;
    }

    @Override
    public void doWork() {
        if (!this.tierTopicAppender.isReady()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "TierTopicAppender is not ready. Backing off.");
            while (!this.tierTopicAppender.isReady() && this.isRunning()) {
                this.pause(this.config().updateIntervalMs(), TimeUnit.MILLISECONDS);
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.cycleTimeMetric().mark();
        this.changeManager().process();
        this.tierLogCleanerManager().map((Function1 & Serializable)x$5 -> x$5.doWork());
        this.kafka$tier$tasks$TierTasks$$tierArchiver().doWork();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().doWork();
        this.maybeLogTierArchiverLagInfo();
        if (this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().taskCount() == 0 && this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().taskCount() == 0 && BoxesRunTime.unboxToInt((Object)this.tierLogCleanerManager().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)TierTasks.$anonfun$doWork$3(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == 0) {
            this.changeManager().processAtLeastOne();
            return;
        }
        this.time.sleep((long)this.config().updateIntervalMs());
    }

    public void maybeLogTierArchiverLagInfo() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastLagPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS()) {
            this.kafka$tier$tasks$TierTasks$$tierArchiver().logPartitionLagInfo(currentTime);
            this.lastLagPrintTimeMs_$eq(currentTime);
            return;
        }
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.initiateShutdown();
        this.ctx().cancel();
        this.changeManager().close();
        this.kafka$tier$tasks$TierTasks$$tierArchiver().shutdown();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().shutdown();
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        this.archiveDeletionExecutor().shutdown();
        this.archiveDeletionExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.cleaningExecutor().shutdown();
        this.cleaningExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.awaitShutdown();
    }

    public ArchiverTaskQueue archiverTaskQueue() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue();
    }

    public Option<CompactionTaskQueue> compactionTaskQueue() {
        return this.tierLogCleanerManager().map((Function1 & Serializable)x$8 -> x$8.taskQueue());
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        if (newTierTasksConfig.numCleanerThreads() < 1) {
            throw new ConfigException("Tier cleaner threads should be at least 1");
        }
        if (newTierTasksConfig.numCleanerThreads() < this.config().numCleanerThreads() / 2) {
            throw new ConfigException(new StringBuilder(75).append("Tier cleaner threads cannot be reduced to less than half the current value ").append(this.config().numCleanerThreads()).toString());
        }
        if (newTierTasksConfig.numCleanerThreads() > this.config().numCleanerThreads() * 2) {
            throw new ConfigException(new StringBuilder(79).append("Tier cleaner threads cannot be increased to more than double the current value ").append(this.config().numCleanerThreads()).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        TierTasksConfig oldTierTasksConfig = this.config();
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        this.reconfigure(oldTierTasksConfig, newTierTasksConfig);
    }

    public void reconfigure(TierTasksConfig oldConfig, TierTasksConfig newConfig) {
        this.config_$eq(newConfig);
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$9 -> {
            x$9.updateConfig(newConfig);
            return BoxedUnit.UNIT;
        });
        if (newConfig.numCleanerThreads() != oldConfig.numCleanerThreads()) {
            ThreadPoolExecutor cleaningThreadPool = (ThreadPoolExecutor)this.cleaningExecutor();
            cleaningThreadPool.setMaximumPoolSize(newConfig.numCleanerThreads());
            cleaningThreadPool.setCorePoolSize(newConfig.numCleanerThreads());
            return;
        }
    }

    public final /* synthetic */ double kafka$tier$tasks$TierTasks$$$anonfun$new$2() {
        return BoxesRunTime.unboxToDouble((Object)this.tierCompactionCpuMeter().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$new$1(TierTasks $this, TierLogCleanerManager x$1) {
        x$1.logCleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>($this){
            private final /* synthetic */ TierTasks $outer;

            public final double value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final /* synthetic */ int $anonfun$doWork$3(TierLogCleanerManager x$6) {
        return x$6.taskQueue().taskCount();
    }

    public TierTasks(TierTasksConfig config, ReplicaManager replicaManager, TierReplicaManager tierReplicaManager, TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time) {
        None$ none$;
        this.config = config;
        this.tierTopicAppender = tierTopicAppender;
        this.time = time;
        super("tier-tasks", true);
        this.lastLagPrintTimeMs = time.milliseconds();
        this.ctx = CancellationContext.newContext();
        this.archiveDeletionExecutor = Executors.newFixedThreadPool(this.config().numArchiverThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(9).append("TierTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.kafka$tier$tasks$TierTasks$$cleanerThreads = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = None$.MODULE$;
        this.cleaningExecutor = Executors.newFixedThreadPool(this.config().numCleanerThreads(), new ThreadFactory(this){
            private final AtomicInteger threadNum;
            private final /* synthetic */ TierTasks $outer;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(19).append("TierCompactionTask-").append(newThreadNum).toString();
                Object var4_3 = null;
                KafkaThread thread = new KafkaThread(nonDaemon_name, r, false);
                this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().append((Object)BoxesRunTime.boxToLong((long)thread.getId()));
                this.$outer.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().toSeq())));
                return thread;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.archiveDeletionPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.archiveDeletionExecutor());
        this.kafka$tier$tasks$TierTasks$$tierArchiver = new TierArchiver(this.config(), replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, time, (ExecutionContext)this.archiveDeletionPool());
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager = new TierDeletionManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)this.archiveDeletionPool());
        if (this.config().tierCleanerFeatureEnable()) {
            ExecutionContextExecutor cleaningPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.cleaningExecutor());
            none$ = new Some((Object)new TierLogCleanerManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)cleaningPool));
        } else {
            none$ = None$.MODULE$;
        }
        this.tierLogCleanerManager = none$;
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$1 -> {
            TierTasks.$anonfun$new$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.changeManager = new ChangeManager(this.ctx().subContext(), (Seq<TierTaskQueue<?>>)(this.tierLogCleanerManager().isDefined() ? new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue(), (List)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue(), (List)new .colon.colon((Object)((TierLogCleanerManager)this.tierLogCleanerManager().get()).taskQueue(), (List)Nil$.MODULE$))) : new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue(), (List)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue(), (List)Nil$.MODULE$))), time);
        this.removeMetric("HeartbeatMs", this.removeMetric$default$2());
        this.newGauge("HeartbeatMs", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public synchronized long value() {
                return System.currentTimeMillis() - this.$outer.lastHeartbeatMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric("CyclesPerSec", this.removeMetric$default$2());
        this.cycleTimeMetric = this.newMeter("CyclesPerSec", "tier tasks cycles per second", TimeUnit.SECONDS, this.newMeter$default$4());
        this.removeMetric("NumPartitionsInError", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInError", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount() + this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount() + BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anon$4.$anonfun$value$1(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$1(TierLogCleanerManager x$3) {
                return x$3.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$2()}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.removeMetric("NumPartitionsInErrorDuringArchival", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInErrorDuringArchival", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.removeMetric("NumPartitionsInErrorDuringDeletion", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInErrorDuringDeletion", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.removeMetric("NumPartitionsInErrorDuringCompaction", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInErrorDuringCompaction", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anon$7.$anonfun$value$3(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$3(TierLogCleanerManager x$4) {
                return x$4.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$4()}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        tierReplicaManager.addListener(this.changeManager());
        tierDeletedPartitionsCoordinator.registerListener(this.changeManager());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }
}

