/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ExtendedOffsetMap;
import kafka.log.SkimpyOffsetMap;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r-f\u0001B\"E\u00055C\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\tE\u0002\u0011\t\u0011)A\u00059\"A1\r\u0001BC\u0002\u0013\u0005C\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003f\u0011!Q\u0007A!a\u0001\n\u0003Y\u0007BCB)\u0001\t\u0005\r\u0011\"\u0001\u0004T!I1q\u000b\u0001\u0003\u0002\u0003\u0006K\u0001\u001c\u0005\u000b\u0003\u007f\u0003!Q1A\u0005\u0002\re\u0003BCB.\u0001\t\u0005\t\u0015!\u0003\u0002B\"9\u0011Q\u0001\u0001\u0005\u0002\ru\u0003bBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\n\u0007O\u0002\u0001\u0019!C\u0001\u0007SB\u0011b!\u001c\u0001\u0001\u0004%\taa\u001c\t\u0011\rM\u0004\u0001)Q\u0005\u0007WB\u0011b!\u001e\u0001\u0001\u0004%\taa\u001e\t\u0013\rm\u0004\u00011A\u0005\u0002\ru\u0004\u0002CBA\u0001\u0001\u0006Ka!\u001f\t\u000f\r-\u0005\u0001\"\u0001\u0004\u000e\"9\u00111\f\u0001\u0005B\rU\u0005b\u0002BA\u0001\u0011\u00053\u0011C\u0004\u0006s\u0012C\tA\u001f\u0004\u0006\u0007\u0012C\ta\u001f\u0005\b\u0003\u000b1B\u0011AA\u0004\u0011\u001d\tIA\u0006C)\u0003\u0017A\u0011\"!\b\u0017\u0005\u0004%\t!a\b\t\u0011\u0005\u001db\u0003)A\u0005\u0003CA\u0011\"!\u000b\u0017\u0005\u0004%\t!a\b\t\u0011\u0005-b\u0003)A\u0005\u0003CA\u0011\"!\f\u0017\u0005\u0004%\t!a\f\t\u0011\u0005ub\u0003)A\u0005\u0003c1!\"a\u0010\u0017!\u0003\r\n\u0003RA!\u0011\u001d\t\u0019e\bD\u0001\u0003?Aq!!\u0012 \r\u0003\t9\u0005C\u0004\u0002\\}1\t!!\u0018\u0007\r\u0005\u0015h\u0003QAt\u0011)\t\u0019e\tBK\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0005\u0003\u0019#\u0011#Q\u0001\n\u0005\u0005\u0002B\u0003B\u0002G\tU\r\u0011\"\u0001\u0003\u0006!Q!qA\u0012\u0003\u0012\u0003\u0006I!!\u0013\t\u000f\u0005\u00151\u0005\"\u0001\u0003\n!9\u0011QI\u0012\u0005B\u0005\u001d\u0003bBA.G\u0011\u0005#\u0011\u0003\u0005\b\u0005S\u0019C\u0011\u0001B\u0016\u0011\u001d\u0011Ye\tC\u0005\u0005\u001bBqAa\u0018$\t\u0003\u0011\t\u0007C\u0004\u0003\u0002\u000e\"\tEa!\t\u0013\t\u00155%!A\u0005\u0002\t\u001d\u0005\"\u0003BGGE\u0005I\u0011\u0001BH\u0011%\u0011)kII\u0001\n\u0003\u00119\u000bC\u0005\u0003,\u000e\n\t\u0011\"\u0011\u0003.\"I!QX\u0012\u0002\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0005\u007f\u001b\u0013\u0011!C\u0001\u0005\u0003D\u0011B!4$\u0003\u0003%\tEa4\t\u0013\tu7%!A\u0005\u0002\t}\u0007\"\u0003BrG\u0005\u0005I\u0011\tBs\u0011%\u0011IoIA\u0001\n\u0003\u0012Y\u000fC\u0005\u0003n\u000e\n\t\u0011\"\u0011\u0003p\u001eI!1\u001f\f\u0002\u0002#\u0005!Q\u001f\u0004\n\u0003K4\u0012\u0011!E\u0001\u0005oDq!!\u0002<\t\u0003\u0019y\u0001C\u0005\u0003\u0002n\n\t\u0011\"\u0012\u0004\u0012!I11C\u001e\u0002\u0002\u0013\u00055Q\u0003\u0005\n\u00077Y\u0014\u0011!CA\u0007;A\u0011ba\u000b<\u0003\u0003%Ia!\f\t\u000f\rUb\u0003\"\u0001\u00048!91q\t\f\u0005\n\r%#AD\"p[B\f7\r^5p]R\u000b7o\u001b\u0006\u0003\u000b\u001a\u000b!bY8na\u0006\u001cG/[8o\u0015\t9\u0005*A\u0003uCN\\7O\u0003\u0002J\u0015\u0006!A/[3s\u0015\u0005Y\u0015!B6bM.\f7\u0001A\n\u0004\u00019#\u0006cA(Q%6\ta)\u0003\u0002R\r\nAA+[3s)\u0006\u001c8\u000e\u0005\u0002T\u00015\tA\t\u0005\u0002V16\taK\u0003\u0002X\u0015\u0006)Q\u000f^5mg&\u0011\u0011L\u0016\u0002\b\u0019><w-\u001b8h\u0003\r\u0019G\u000f_\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011q\fS\u0001\bM\u0016$8\r[3s\u0013\t\tgLA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0003dib\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\u0005)\u0007C\u00014h\u001b\u0005A\u0015B\u00015I\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\u0002\nQa\u001d;bi\u0016,\u0012\u0001\u001c\t\u0003[~q!A\\\u000b\u000f\u0005=DhB\u00019x\u001d\t\thO\u0004\u0002sk6\t1O\u0003\u0002u\u0019\u00061AH]8pizJ\u0011aS\u0005\u0003\u0013*K!a\u0012%\n\u0005\u00153\u0015AD\"p[B\f7\r^5p]R\u000b7o\u001b\t\u0003'Z\u00192A\u0006?U!\ri\u0018\u0011A\u0007\u0002}*\tq0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0004y\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001{\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\t\u0011h0C\u0002\u0002\u0016y\fa\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b}\u0006!B)\u001a4bk2$X*\u0019=SKR\u0014\u0018pQ8v]R,\"!!\t\u0011\u0007u\f\u0019#C\u0002\u0002&y\u00141!\u00138u\u0003U!UMZ1vYRl\u0015\r\u001f*fiJL8i\\;oi\u0002\n\u0001\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'t\u0003e!UMZ1vYR\u0014V\r\u001e:z\u0013:$XM\u001d<bY&sWj\u001d\u0011\u0002%\u0011+g-Y;miJ+GO]=Q_2L7-_\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0015!B:u_J,\u0017\u0002BA\u001e\u0003k\u0011!\u0004V5fe>\u0013'.Z2u'R|'/\u001a'j]\u0016\f'OU3uef\f1\u0003R3gCVdGOU3uef\u0004v\u000e\\5ds\u0002\u00121cQ8na\u0006\u001cG/[8o)\u0006\u001c8n\u0015;bi\u0016\u001c\"a\b?\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\rG2,\u0017M\\3s'R\fGo\u001d\u000b\u0003\u0003\u0013\u0002R!`A&\u0003\u001fJ1!!\u0014\u007f\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V)\u000b1\u0001\\8h\u0013\u0011\tI&a\u0015\u0003\u0019\rcW-\u00198feN#\u0018\r^:\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\u000b\u0002`\u0005m\u0014QPA@\u0003\u001f\u000by*!+\u00024\u0006u\u0016q\u0019\u000b\u0005\u0003C\n\t\b\u0005\u0004\u0002d\u0005%\u0014QN\u0007\u0003\u0003KR1!a\u001a\u007f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003W\n)G\u0001\u0004GkR,(/\u001a\t\u0004\u0003_zR\"\u0001\f\t\u000f\u0005M$\u0005q\u0001\u0002v\u0005\u0011Qm\u0019\t\u0005\u0003G\n9(\u0003\u0003\u0002z\u0005\u0015$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015Q&\u00051\u0001]\u0011\u0015\u0019'\u00051\u0001f\u0011\u001d\t\tI\ta\u0001\u0003\u0007\u000baB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIIS\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u00055\u0015q\u0011\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d\t\tJ\ta\u0001\u0003'\u000b\u0011\u0003^5feR{\u0007/[2BaB,g\u000eZ3s!\u0011\t)*a'\u000e\u0005\u0005]%bAAM\u0011\u0006)Ao\u001c9jG&!\u0011QTAL\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM\u001d\u0005\b\u0003C\u0013\u0003\u0019AAR\u0003=!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0003BA\u001a\u0003KKA!a*\u00026\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X\rC\u0004\u0002,\n\u0002\r!!,\u0002\r\r|gNZ5h!\ry\u0015qV\u0005\u0004\u0003c3%a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\t\u000f\u0005U&\u00051\u0001\u00028\u0006IA\u000f\u001b:piRdWM\u001d\t\u0004+\u0006e\u0016bAA^-\nIA\u000b\u001b:piRdWM\u001d\u0005\b\u0003\u007f\u0013\u0003\u0019AAa\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u00042aUAb\u0013\r\t)\r\u0012\u0002\u0016)&,'oQ8na\u0006\u001cG/[8o\u001b\u0016$(/[2t\u0011\u001d\tIM\ta\u0001\u0003\u0017\fA\u0001^5nKB!\u0011QZAp\u001b\t\tyMC\u0002X\u0003#TA!a5\u0002V\u000611m\\7n_:T1aSAl\u0015\u0011\tI.a7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti.A\u0002pe\u001eLA!!9\u0002P\n!A+[7fS\ty2E\u0001\u0005DY\u0016\fg\u000eT8h'!\u0019C0!\u001c\u0002j\u0006=\bcA?\u0002l&\u0019\u0011Q\u001e@\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011_A~\u001d\u0011\t\u00190a>\u000f\u0007I\f)0C\u0001\u0000\u0013\r\tIP`\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti0a@\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005eh0\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%A\u0005mCN$8\u000b^1ugV\u0011\u0011\u0011J\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004CC\u0002B\u0006\u0005\u001b\u0011y\u0001E\u0002\u0002p\rBq!a\u0011)\u0001\u0004\t\t\u0003C\u0004\u0003\u0004!\u0002\r!!\u0013\u0015)\tM!q\u0003B\r\u00057\u0011iBa\b\u0003\"\t\r\"Q\u0005B\u0014)\u0011\t\tG!\u0006\t\u000f\u0005M$\u0006q\u0001\u0002v!)!L\u000ba\u00019\")1M\u000ba\u0001K\"9\u0011\u0011\u0011\u0016A\u0002\u0005\r\u0005bBAIU\u0001\u0007\u00111\u0013\u0005\b\u0003CS\u0003\u0019AAR\u0011\u001d\tYK\u000ba\u0001\u0003[Cq!!.+\u0001\u0004\t9\fC\u0004\u0002@*\u0002\r!!1\t\u000f\u0005%'\u00061\u0001\u0002L\u0006QAm\\\"mK\u0006tGj\\4\u0015-\t5\"\u0011\u0007B\u001a\u0005k\u00119D!\u000f\u0003<\t\r#Q\tB$\u0005\u0013\"B!!\u0019\u00030!9\u00111O\u0016A\u0004\u0005U\u0004\"\u0002.,\u0001\u0004a\u0006bBAIW\u0001\u0007\u00111\u0013\u0005\b\u0003\u0007Z\u0003\u0019AA\u0011\u0011\u0015\u00197\u00061\u0001f\u0011\u001d\t\ti\u000ba\u0001\u0003\u0007Cq!a+,\u0001\u0004\u0011i\u0004E\u0002P\u0005\u007fI1A!\u0011G\u0005U\u0019u.\u001c9bGRLwN\u001c+bg.\u001c8i\u001c8gS\u001eDq!!),\u0001\u0004\t\u0019\u000bC\u0004\u0002@.\u0002\r!!1\t\u000f\u0005U6\u00061\u0001\u00028\"9\u0011\u0011Z\u0016A\u0002\u0005-\u0017\u0001I:i_VdG\rR8Ek\u0006d7i\\7qC\u000e$\u0018n\u001c8WC2LG-\u0019;j_:$bAa\u0014\u0003V\tu\u0003cA?\u0003R%\u0019!1\u000b@\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u000b\u0017A\u0002\t]\u0003\u0003BA)\u00053JAAa\u0017\u0002T\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\tY\u000b\fa\u0001\u0005{\t1B]3d_J$7\u000b^1ugRa!1\rB5\u0005[\u0012yG!\u001f\u0003~A\u0019QP!\u001a\n\u0007\t\u001ddP\u0001\u0003V]&$\bb\u0002B6[\u0001\u0007\u0011QB\u0001\u0005i\u0006\u001c8\u000eC\u0003d[\u0001\u0007Q\rC\u0004\u0003r5\u0002\rAa\u001d\u0002\t\u0019\u0014x.\u001c\t\u0004{\nU\u0014b\u0001B<}\n!Aj\u001c8h\u0011\u001d\u0011Y(\fa\u0001\u0005g\n!\u0001^8\t\u000f\t}T\u00061\u0001\u0002P\u0005)1\u000f^1ug\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u000e\u0005!1m\u001c9z)\u0019\u0011YA!#\u0003\f\"I\u00111I\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0005\u0007y\u0003\u0013!a\u0001\u0003\u0013\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0012*\"\u0011\u0011\u0005BJW\t\u0011)\n\u0005\u0003\u0003\u0018\n\u0005VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BP}\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r&\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005SSC!!\u0013\u0003\u0014\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa,\u0011\t\tE&1X\u0007\u0003\u0005gSAA!.\u00038\u0006!A.\u00198h\u0015\t\u0011I,\u0001\u0003kCZ\f\u0017\u0002BA\r\u0005g\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003D\n%\u0007cA?\u0003F&\u0019!q\u0019@\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003LR\n\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!5\u0011\r\tM'\u0011\u001cBb\u001b\t\u0011)NC\u0002\u0003Xz\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YN!6\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u001f\u0012\t\u000fC\u0005\u0003LZ\n\t\u00111\u0001\u0003D\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011yKa:\t\u0013\t-w'!AA\u0002\u0005\u0005\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003P\tE\b\"\u0003Bfs\u0005\u0005\t\u0019\u0001Bb\u0003!\u0019E.Z1o\u0019><\u0007cAA8wM)1H!?\u0004\u0006AQ!1`B\u0001\u0003C\tIEa\u0003\u000e\u0005\tu(b\u0001B\u0000}\u00069!/\u001e8uS6,\u0017\u0002BB\u0002\u0005{\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u00199a!\u0004\u000e\u0005\r%!\u0002BB\u0006\u0005o\u000b!![8\n\t\u0005u8\u0011\u0002\u000b\u0003\u0005k$\"Aa,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t-1qCB\r\u0011\u001d\t\u0019E\u0010a\u0001\u0003CAqAa\u0001?\u0001\u0004\tI%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}1q\u0005\t\u0006{\u0006-3\u0011\u0005\t\b{\u000e\r\u0012\u0011EA%\u0013\r\u0019)C \u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\r%r(!AA\u0002\t-\u0011a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111q\u0006\t\u0005\u0005c\u001b\t$\u0003\u0003\u00044\tM&AB(cU\u0016\u001cG/A\thKR$\u0016.\u001a:M_\u001e$vn\u00117fC:$\u0002b!\u000f\u0004@\r\u000531\t\t\u0004'\u000em\u0012bAB\u001f\t\nqA+[3s\u0019><Gk\\\"mK\u0006t\u0007bBA+\u0003\u0002\u0007!q\u000b\u0005\b\u0003\u0013\f\u0005\u0019AAf\u0011\u001d\u0019)%\u0011a\u0001\u0005g\n1A\\8x\u0003)!\u0017N\u001d;z%\u0006tw-\u001a\u000b\u0007\u0007\u0017\u001aiea\u0014\u0011\u000fu\u001c\u0019Ca\u001d\u0003t!9\u0011Q\u000b\"A\u0002\t]\u0003bBB#\u0005\u0002\u0007!1O\u0001\ngR\fG/Z0%KF$BAa\u0019\u0004V!A!1\u001a\u0004\u0002\u0002\u0003\u0007A.\u0001\u0004ti\u0006$X\rI\u000b\u0003\u0003\u0003\fa\u0003^5fe\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000f\t\u000b\n%\u000e}3\u0011MB2\u0007KBQA\u0017\u0006A\u0002qCQa\u0019\u0006A\u0002\u0015DQA\u001b\u0006A\u00021Dq!a0\u000b\u0001\u0004\t\t-A\bmCN$\bK]8dKN\u001cX\rZ't+\t\u0019Y\u0007E\u0003~\u0003\u0017\u0012\u0019(A\nmCN$\bK]8dKN\u001cX\rZ't?\u0012*\u0017\u000f\u0006\u0003\u0003d\rE\u0004\"\u0003Bf\u001b\u0005\u0005\t\u0019AB6\u0003Aa\u0017m\u001d;Qe>\u001cWm]:fI6\u001b\b%\u0001\u0006m_\u001e$vn\u00117fC:,\"a!\u001f\u0011\u000bu\fYe!\u000f\u0002\u001d1|w\rV8DY\u0016\fgn\u0018\u0013fcR!!1MB@\u0011%\u0011Y\rEA\u0001\u0002\u0004\u0019I(A\u0006m_\u001e$vn\u00117fC:\u0004\u0003fA\t\u0004\u0006B\u0019Qpa\"\n\u0007\r%eP\u0001\u0005w_2\fG/\u001b7f\u0003Ui\u0017-\u001f2f+B$\u0017\r^3M_\u001e$vn\u00117fC:$ba!\u001f\u0004\u0010\u000eE\u0005bBAA%\u0001\u0007\u00111\u0011\u0005\b\u0007'\u0013\u0002\u0019\u0001B:\u0003%qwn^'jY2L7\u000f\u0006\b\u0004\u0018\u000eu5qTBQ\u0007G\u001b)ka*\u0015\t\re51\u0014\t\u0006\u0003G\nIG\u0015\u0005\b\u0003g\u001a\u00029AA;\u0011\u001d\tIm\u0005a\u0001\u0003\u0017Dq!!%\u0014\u0001\u0004\t\u0019\nC\u0004\u0002\"N\u0001\r!a)\t\u000f\u0005\u00055\u00031\u0001\u0002\u0004\"9\u00111V\nA\u0002\u00055\u0006bBA['\u0001\u00071\u0011\u0016\t\u0006{\u0006-\u0013q\u0017")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private Option<Object> lastProcessedMs;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        return CompactionTask$.MODULE$.getTierLogToClean(log, time, now);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public Option<Object> lastProcessedMs() {
        return this.lastProcessedMs;
    }

    public void lastProcessedMs_$eq(Option<Object> x$1) {
        this.lastProcessedMs = x$1;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis) {
        Option updatedNextLogToClean = (this.state() instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTierCompactable())) : None$.MODULE$).flatMap((Function1 & Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch())))) {
                return new Some((Object)CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, replicaManager.time(), nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq((Option<TierLogToClean>)updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        long nowMs = time.hiResClockMs();
        return (this.ctx().isCancelled() ? Future$.MODULE$.successful((Object)this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, (Throttler)throttler.get(), this.tierCompactionMetrics(), time, ec)).map((Function1 & Serializable)result -> {
            this.onSuccessfulTransition();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(CompactionTask.$anonfun$transition$2(this, result)));
            }
            this.lastProcessedMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)nowMs)));
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$1(this)), (Throwable)logCleaningAbortedException);
                    }
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$3(this)), (Throwable)tierLogCompactionFencedException);
                    }
                    Object var10_8 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$5(this)), (Throwable)cancellationException);
                    }
                    Object var11_10 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$7(this)), (Throwable)notTierablePartitionException);
                    }
                    Object var12_12 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 != null) {
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask error_this = compactionTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$9(this)), x1);
                    }
                    Object var13_13 = null;
                    this.$outer.cancelAndSetErrorState(x1);
                    return (B1)this.$outer;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (x1 instanceof CancellationException) {
                    return true;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    return true;
                }
                return x1 != null;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$transition$3 $this) {
                return new StringBuilder(35).append($this.$outer.topicIdPartition()).append(": compaction operation was aborted.").toString();
            }

            public static final /* synthetic */ LogCleaningAbortedException $anonfun$applyOrElse$2(LogCleaningAbortedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$3($anonfun$transition$3 $this) {
                return new StringBuilder(40).append($this.$outer.topicIdPartition()).append(" was fenced, stopping compaction process").toString();
            }

            public static final /* synthetic */ TierLogCompactionFencedException $anonfun$applyOrElse$4(TierLogCompactionFencedException x5$1) {
                return x5$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$5($anonfun$transition$3 $this) {
                return new StringBuilder(64).append($this.$outer.topicIdPartition()).append(" was fenced by cancellation context, stopping compaction process").toString();
            }

            public static final /* synthetic */ CancellationException $anonfun$applyOrElse$6(CancellationException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$3 $this) {
                return new StringBuilder(47).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot use tier compaction").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$8(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$9($anonfun$transition$3 $this) {
                return new StringBuilder(67).append($this.$outer.topicIdPartition()).append(": unhandled exception in CompactionTask. Moving task to error state").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$10(Throwable x8$1) {
                return x8$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(36).append("CompactionTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$transition$2(CompactionTask $this, CompactionTaskState result$1) {
        return new StringBuilder(23).append("Transitioned ").append($this.topicIdPartition()).append(" from ").append($this.state()).append(" to ").append(result$1).toString();
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(tierCompactionMetrics.retryRateOpt());
        this.lastProcessedMs = None$.MODULE$;
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = CleanLog.$anonfun$transition$4(topicIdPartition);
                Object var12_12 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var11_11 = null;
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, (CompactionTasksConfig)config.compactionTaskConfig().get(), tierObjectStore, tierCompactionMetrics, throttler, time, ec).map((Function1 & Serializable)state -> {
                CompactionTask$ info_this = CompactionTask$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = CleanLog.$anonfun$transition$6(topicIdPartition);
                    Object var3_3 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, CompactionTasksConfig config, TierObjectStore tierObjectStore, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Errors error = (Errors)((Left)either).value();
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Partition partition = (Partition)((Right)either).value();
                    return (CompactionTaskState)partition.log().map((Function1 & Serializable)log -> {
                        int tierEpoch = log.tierPartitionState().tierEpoch();
                        if (tierEpoch > leaderEpoch) {
                            throw new TierLogCompactionFencedException(topicIdPartition, null);
                        }
                        if (tierEpoch < leaderEpoch) {
                            throw new TierMetadataRetriableException(new StringBuilder(45).append("Leadership not established for ").append(topicIdPartition).append(". Backing off.").toString());
                        }
                        if (partition.isUncleanLeader()) {
                            throw new TierMetadataRetriableException(new StringBuilder(49).append(topicIdPartition).append(" undergoing unclean leader recovery. Backing off.").toString());
                        }
                        if (log.isTierMetadataStateRecovering()) {
                            throw new TierMetadataRetriableException(new StringBuilder(48).append(topicIdPartition).append(" undergoing tier metadata recovery. Backing off.").toString());
                        }
                        if (log.isFrozenLogStartOffsetState()) {
                            throw new TierMetadataRetriableException(new StringBuilder(46).append(topicIdPartition).append(" undergoing tiered data recovery. Backing off.").toString());
                        }
                        Some stats = this.lastStats();
                        if (!log.isTierCompactable()) {
                            CompactionTask$ warn_this = CompactionTask$.MODULE$;
                            if (warn_this.logger().underlying().isWarnEnabled()) {
                                String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$3(topicIdPartition);
                                Object var42_15 = null;
                                warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                            }
                            Object var34_14 = null;
                        } else {
                            void var33_47;
                            void var31_46;
                            Tuple2<Object, CleanerStats> tuple2;
                            if (log.tieredLogSegments().isEmpty()) {
                                CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                if (warn_this.logger().underlying().isWarnEnabled()) {
                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$4(topicIdPartition);
                                    Object var43_17 = null;
                                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                }
                                Object var35_16 = null;
                                throw new TierMetadataRetriableException(new StringBuilder(60).append("Log for ").append(topicIdPartition).append(" has no eligible tiered segments for tier compaction").toString());
                            }
                            SkimpyOffsetMap offsetMap = new SkimpyOffsetMap(config.skimpyOffsetMapMemory(), "MD5");
                            TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                            Function1 & Serializable checkDone = (Function1 & Serializable)x$3 -> {
                                CleanLog.$anonfun$doCleanLog$5(ctx, x$3);
                                return BoxedUnit.UNIT;
                            };
                            TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                            TierCleaner cleaner = new TierCleaner(offsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                            Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                            if (lockedOffset.isEmpty()) {
                                CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                if (warn_this.logger().underlying().isWarnEnabled()) {
                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$6(topicIdPartition);
                                    Object var44_25 = null;
                                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                }
                                Object var36_24 = null;
                                throw new LogCleaningAbortedException();
                            }
                            cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong((Object)lockedOffset.get()));
                            try {
                                long tierEndOffset = log.tierPartitionState().endOffset();
                                if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                    void var28_34;
                                    CleanerStats stats2;
                                    CompactionTask$ info_this = CompactionTask$.MODULE$;
                                    if (info_this.logger().underlying().isInfoEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$7(topicIdPartition, cleanable, tierEndOffset);
                                        Object var45_28 = null;
                                        info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                                    }
                                    Object var37_27 = null;
                                    SkimpyOffsetMap localOffsetMap = new SkimpyOffsetMap(config.skimpyOffsetMapMemory(), "MD5");
                                    ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                    Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                    Tuple2 tuple22 = CleanLog.liftedTree1$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics()), localOffsetMap);
                                    if (tuple22 == null) {
                                        throw new MatchError(null);
                                    }
                                    boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                    String failReason = (String)tuple22._2();
                                    if (var28_34 == false) {
                                        CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                        if (warn_this.logger().underlying().isWarnEnabled()) {
                                            void var29_35;
                                            String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$8(log, (String)var29_35);
                                            Object var46_37 = null;
                                            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                        }
                                        Object var38_36 = null;
                                        stats2.validationAborted();
                                    } else if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                        CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                        if (warn_this.logger().underlying().isWarnEnabled()) {
                                            String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$9(log, tierEndOffset);
                                            Object var47_39 = null;
                                            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                        }
                                        Object var39_38 = null;
                                        stats2.validationAborted();
                                    } else if (!cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2)) {
                                        CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                        if (warn_this.logger().underlying().isWarnEnabled()) {
                                            String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$10(log);
                                            Object var48_41 = null;
                                            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                        }
                                        Object var40_40 = null;
                                        stats2.validationFailed();
                                    } else {
                                        CompactionTask$ info_this2 = CompactionTask$.MODULE$;
                                        if (info_this2.logger().underlying().isInfoEnabled()) {
                                            String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$11(topicIdPartition);
                                            Object var49_43 = null;
                                            info_this2.logger().underlying().info(Logging.msgWithLogIdent$(info_this2, msgWithLogIdent_msg));
                                        }
                                        Object var41_42 = null;
                                        stats2.validationPassed();
                                    }
                                }
                                tuple2 = cleaner.clean(cleanable);
                            }
                            finally {
                                log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                            }
                            Tuple2<Object, CleanerStats> tuple23 = tuple2;
                            if (tuple23 == null) {
                                throw new MatchError(null);
                            }
                            long nextDirtyOffset = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple23._2();
                            if (var31_46 != -1L) {
                                this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), (long)var31_46, (CleanerStats)var33_47);
                            }
                            stats = new Some((Object)var33_47);
                        }
                        return new CleanLog(leaderEpoch, (Option<CleanerStats>)stats);
                    }).getOrElse((Function0 & Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return Predef$.MODULE$.Boolean2boolean(log.config().confluentLogConfig().tierCleanerDualCompaction()) && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, message));
            }
            Object var9_7 = null;
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$ warn_this = CompactionTask$.MODULE$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())}));
                    Object var11_9 = null;
                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                    return;
                }
                return;
            }
        }

        public String toString() {
            return new StringBuilder(22).append("CleanLog(leaderEpoch=").append(this.leaderEpoch()).append(")").toString();
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        public String productPrefix() {
            return "CleanLog";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "leaderEpoch";
                }
                case 1: {
                    return "lastStats";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.leaderEpoch()), (int)Statics.anyHash(this.lastStats())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof CleanLog)) break block3;
                    CleanLog cleanLog = (CleanLog)x$1;
                    if (this.leaderEpoch() != cleanLog.leaderEpoch()) break block3;
                    Option<CleanerStats> option = this.lastStats();
                    Option<CleanerStats> option2 = cleanLog.lastStats();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !cleanLog.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ String $anonfun$transition$4(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(33).append("Starting tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$transition$6(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(34).append("Completed tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$3(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(80).append("Log for ").append(topicIdPartition$2).append(" is not tier compact enabled, but is attempting to clean tiered segments").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$4(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(96).append("Log for ").append(topicIdPartition$2).append(" was scheduled in tier CompactionTask but has no eligible tiered segments for compaction").toString();
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$3) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$6(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(99).append("Log for ").append(topicIdPartition$2).append(" is still locked by previous compaction round. Abort current operation and will be retried.").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$7(TopicIdPartition topicIdPartition$2, TierLogToClean cleanable$1, long tierEndOffset$1) {
            return new StringBuilder(73).append("Starting dual compaction validation for ").append(topicIdPartition$2).append(" for offset range [").append(cleanable$1.firstCleanableOffset()).append(", end offset=").append(tierEndOffset$1).append("]").toString();
        }

        private static final /* synthetic */ Tuple2 liftedTree1$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, SkimpyOffsetMap localOffsetMap$1) {
            Tuple2 tuple2;
            try {
                if (!localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, baseOffsetMap$1, stats$1)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(96).append("offset map is too small for storing all keys in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append("Offset map memory: ").append(localOffsetMap$1.memory()).append(", slots: ").append(localOffsetMap$1.slots()).append(".").toString());
            }
            catch (Throwable e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(84).append("exception encountered when building offset map for local data in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append(e).toString());
            }
            return tuple2;
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$8(AbstractLog log$2, String failReason$1) {
            return new StringBuilder(39).append("Abort dual compaction validation for ").append(log$2).append(". ").append(failReason$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$9(AbstractLog log$2, long tierEndOffset$1) {
            return new StringBuilder(110).append("Abort dual compaction validation for ").append(log$2).append(" because tierEndOffset changed. old tierEndOffset: ").append(tierEndOffset$1).append(", new tierEndOffset: ").append(log$2.tierPartitionState().endOffset()).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$10(AbstractLog log$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(log$2).append(" failed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$11(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(topicIdPartition$2).append(" passed").toString();
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public static final /* synthetic */ String $anonfun$recordStats$1(String message$1) {
            return message$1;
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$((Product)this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, TierCompactionMetrics var8, Time var9, ExecutionContext var10);
    }
}

