/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import kafka.log.CleanerStats;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005]4AAC\u0006\u0001)!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!Y\u0003A!A!\u0002\u0013a\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dCQA\u0013\u0001\u0005\u0002-CaA\u0015\u0001\u0005R5\u0019\u0006BB1\u0001\t#j!\r\u0003\u0004o\u0001\u0011ESb\u001c\u0002\u0014\u0007>l\u0007/Y2uS>tG+Y:l#V,W/\u001a\u0006\u0003\u00195\t!bY8na\u0006\u001cG/[8o\u0015\tqq\"A\u0003uCN\\7O\u0003\u0002\u0011#\u0005!A/[3s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0003\u0001U\u00012AF\f\u001a\u001b\u0005i\u0011B\u0001\r\u000e\u00055!\u0016.\u001a:UCN\\\u0017+^3vKB\u0011!dG\u0007\u0002\u0017%\u0011Ad\u0003\u0002\u000f\u0007>l\u0007/Y2uS>tG+Y:l\u0003\r\u0019G\u000f\u001f\t\u0003?\tj\u0011\u0001\t\u0006\u0003C=\tqAZ3uG\",'/\u0003\u0002$A\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006AQ.\u0019=UCN\\7\u000f\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0002J]R\fA\u0001^5nKB\u0011QfN\u0007\u0002])\u0011q\u0006M\u0001\u0006kRLGn\u001d\u0006\u0003cI\naaY8n[>t'B\u0001\n4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005ar#\u0001\u0002+j[\u0016\f!\u0002\\8h)>\u001cE.Z1o!\u001513(G\u001fA\u0013\tatEA\u0005Gk:\u001cG/[8oeA\u0011aEP\u0005\u0003\u007f\u001d\u0012A\u0001T8oOB\u0019a%Q\"\n\u0005\t;#AB(qi&|g\u000e\u0005\u0002\u001b\t&\u0011Qi\u0003\u0002\u000f)&,'\u000fT8h)>\u001cE.Z1o\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004\"A\u0007%\n\u0005%[!!\u0006+jKJ\u001cu.\u001c9bGRLwN\\'fiJL7m]\u0001\u0007y%t\u0017\u000e\u001e \u0015\r1kej\u0014)R!\tQ\u0002\u0001C\u0003\u001e\r\u0001\u0007a\u0004C\u0003%\r\u0001\u0007Q\u0005C\u0003,\r\u0001\u0007A\u0006C\u0003:\r\u0001\u0007!\bC\u0003G\r\u0001\u0007q)A\u0005t_J$H+Y:lgR\u0011A\u000b\u0019\t\u0004+vKbB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI6#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011AlJ\u0001\ba\u0006\u001c7.Y4f\u0013\tqvL\u0001\u0003MSN$(B\u0001/(\u0011\u0015qq\u00011\u0001U\u0003\u001dqWm\u001e+bg.$2!G2j\u0011\u0015!\u0007\u00021\u0001f\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002gO6\tq\"\u0003\u0002i\u001f\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0006U\"\u0001\ra[\u0001\t[\u0016$\u0018\rZ1uCB\u0011a\u0003\\\u0005\u0003[6\u00111c\u0015;beR\u001c\u0005.\u00198hK6+G/\u00193bi\u0006\f!\"\\1z!J|7-Z:t)\t\u00018\u000f\u0005\u0002'c&\u0011!o\n\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0017\u00021\u0001u!\t1R/\u0003\u0002w\u001b\tq1\t[1oO\u0016lU\r^1eCR\f\u0007")
public class CompactionTaskQueue
extends TierTaskQueue<CompactionTask> {
    private final CancellationContext ctx;
    private final Time time;
    private final Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean;
    private final TierCompactionMetrics tierCompactionMetrics;

    @Override
    public List<CompactionTask> sortTasks(List<CompactionTask> tasks) {
        long now = this.time.milliseconds();
        List updated = tasks.map((Function1 & Serializable)task -> new Tuple2(task, $this.logToClean.apply(task, (Object)BoxesRunTime.boxToLong((long)now))));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ordering between task tier log to cleans: ").append(updated).toString());
        return ((List)updated.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueue.$anonfun$sortTasks$3(x0$1))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                CompactionTask task = (CompactionTask)x0$2._1();
                Option toCleanOpt = (Option)x0$2._2();
                return new Tuple2((Object)task, toCleanOpt.get());
            }
            throw new MatchError(null);
        }).sortBy((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                return (TierLogToClean)x0$3._2();
            }
            throw new MatchError(null);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                return (CompactionTask)x0$4._1();
            }
            throw new MatchError(null);
        });
    }

    @Override
    public CompactionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
        if (metadata instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)metadata;
            return new CompactionTask(this.ctx.subContext(), topicIdPartition, new CompactionTask.CleanLog(startLeadership.leaderEpoch(), (Option<CleanerStats>)None$.MODULE$), this.tierCompactionMetrics);
        }
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected change ").append(metadata).toString());
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        return metadata instanceof LeadershipChange;
    }

    public static final /* synthetic */ boolean $anonfun$sortTasks$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Option)x0$1._2()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cleanable()));
        }
        throw new MatchError(null);
    }

    public CompactionTaskQueue(CancellationContext ctx, int maxTasks, Time time, Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.time = time;
        this.logToClean = logToClean;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(ctx, maxTasks, time);
    }
}

