/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.server.Defaults;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicClient;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.CoreUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryUtils {
    private static final Logger log = LoggerFactory.getLogger(RecoveryUtils.class);
    public static final String TIER_PROPERTIES_CONFIG_FILE = "tier.config";
    public static final String TIER_PROPERTIES_CONFIG_FILE_DOC = "The path to a configuration file containing the required properties";
    public static final String COMPARISON_TOOL_INPUT = "input.json";
    public static final String COMPARISON_TOOL_INPUT_DOC = "The path to a json file to be accepted as the input to the tool";
    public static final String COMPARISON_TOOL_OUTPUT = "output.json";
    public static final String COMPARISON_TOOL_OUTPUT_DOC = "The path to a json file where the tool will generate the output";
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE_FORMAT = "<tiered_partition_topic_ID_base64_encoded>:<tiered_partition_topic_name>-<tiered_partition_number> <freeze_merged_log_start_offset>";

    public static int getNumPartitions(Producer<byte[], byte[]> producer, String topicName) {
        List partitions = producer.partitionsFor(topicName);
        Optional<Integer> max = partitions.stream().map(PartitionInfo::partition).max(Integer::compareTo);
        if (!max.isPresent()) {
            throw new IllegalStateException("Partitions not found for tier topic " + topicName);
        }
        if (max.get() + 1 > partitions.size()) {
            throw new IllegalStateException("Partitions missing for tier topic " + topicName);
        }
        return partitions.size();
    }

    public static Producer<byte[], byte[]> createTierTopicProducer(Properties properties, String clientId) {
        String tierTopicClientId = TierTopicClient.clientIdPrefix(clientId);
        Properties producerProperties = new Properties();
        producerProperties.putAll((Map<?, ?>)properties);
        TierTopicProducerSupplier.addBaseProperties(producerProperties, tierTopicClientId, Defaults.TierMetadataRequestTimeoutMs());
        KafkaProducer newProducer = new KafkaProducer(producerProperties);
        log.info("Created new TierTopic producer! properties={}, , tierTopicClientId={}, newProducer={}", new Object[]{properties, tierTopicClientId, newProducer});
        return newProducer;
    }

    public static RecordMetadata injectTierTopicEvent(Producer<byte[], byte[]> producer, AbstractTierMetadata event, String tierTopicName, int numTierTopicPartitions) throws InterruptedException, ExecutionException {
        TierTopicPartitioner partitioner = new TierTopicPartitioner(numTierTopicPartitions);
        TopicPartition tierTopicPartition = TierTopic.toTierTopicPartition(event.topicIdPartition(), tierTopicName, partitioner);
        try {
            log.info("Injecting TierTopic event: event={}, tierTopicPartition={}, tierTopicName={}, numTierTopicPartitions={}", new Object[]{event, tierTopicPartition, tierTopicName, numTierTopicPartitions});
            RecordMetadata injected = (RecordMetadata)producer.send(new ProducerRecord(tierTopicPartition.topic(), Integer.valueOf(tierTopicPartition.partition()), (Object)event.serializeKey(), (Object)event.serializeValue())).get();
            log.info("Injected TierTopic event! recordMetadata={}", (Object)injected);
            return injected;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to inject TierTopic event={}, tierTopicPartition={}, tierTopicName={}, numTierTopicPartitions={}", new Object[]{event, tierTopicPartition, tierTopicName, numTierTopicPartitions, e});
            throw e;
        }
    }

    private static Boolean parseBoolean(String value) {
        if (value.isEmpty() || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid boolean", value));
        }
        return Boolean.valueOf(value);
    }

    public static Map<TopicIdPartition, Boolean> parseFencingInformation(List<String> allPartitionsFencingInfo) {
        HashMap<TopicIdPartition, Boolean> partitions = new HashMap<TopicIdPartition, Boolean>();
        for (String partitionFencingInfo : allPartitionsFencingInfo) {
            int partition;
            String partitionStr;
            UUID topicId;
            String[] tokens = partitionFencingInfo.trim().split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException(String.format("'%s' does not contain topic information and freeze log start offset flag separated by a space. Required format is: '%s'", partitionFencingInfo, FENCE_TARGET_PARTITIONS_CONFIG_FILE_FORMAT));
            }
            String topicIdPartitionStr = tokens[0].trim();
            Boolean freezeMergedLogStartOffset = RecoveryUtils.parseBoolean(tokens[1].trim());
            String[] components = topicIdPartitionStr.split(":");
            if (components.length != 2) {
                throw new IllegalArgumentException(String.format("'%s' does not contain one colon (':').", topicIdPartitionStr));
            }
            try {
                topicId = CoreUtils.uuidFromBase64(components[0].trim());
            }
            catch (Exception e) {
                String msg = String.format("Item: '%s' has an invalid UUID provided as topic ID: '%s'", topicIdPartitionStr, components[0]);
                throw new IllegalArgumentException(msg, e);
            }
            String suffixTopicNameAndPartitionName = topicIdPartitionStr.substring(components[0].length() + 1).trim();
            int lastSplitIndex = suffixTopicNameAndPartitionName.lastIndexOf(45);
            if (lastSplitIndex == -1) {
                throw new IllegalArgumentException(String.format("Item: '%s' does not contain at least one hyphen ('-').", topicIdPartitionStr));
            }
            String topicName = suffixTopicNameAndPartitionName.substring(0, lastSplitIndex).trim();
            if (topicName.isEmpty()) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot contain an empty topic name: '%s'", topicIdPartitionStr, topicName));
            }
            try {
                partitionStr = suffixTopicNameAndPartitionName.substring(lastSplitIndex + 1).trim();
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot contain an invalid partition number", topicIdPartitionStr));
            }
            try {
                partition = Integer.parseInt(partitionStr);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Item: '%s' has an illegal partition number: '%s'", topicIdPartitionStr, partitionStr);
                throw new IllegalArgumentException(msg, e);
            }
            if (partition < 0) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot have a negative partition number: '%d'", topicIdPartitionStr, partition));
            }
            partitions.put(new TopicIdPartition(topicName, topicId, partition), freezeMergedLogStartOffset);
        }
        return partitions;
    }

    public static String makeArgument(String arg) {
        return String.format("--%s", arg);
    }

    public static void validatePartitions(Properties properties, Set<TopicPartition> inputPartitions) throws CancellationException, IllegalArgumentException {
        Map results;
        List checkTopics = inputPartitions.stream().map(TopicPartition::topic).collect(Collectors.toList());
        try {
            Admin admin = Admin.create((Properties)properties);
            Object object = null;
            try {
                results = (Map)admin.describeTopics(checkTopics).allTopicNames().get();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (object != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not validate fencing input user topics", e);
        }
        HashSet<TopicPartition> validPartitions = new HashSet<TopicPartition>();
        for (TopicPartition inputPartition : inputPartitions) {
            TopicDescription topicDescription = (TopicDescription)results.get(inputPartition.topic());
            if (topicDescription.isInternal()) {
                throw new IllegalArgumentException(String.format("Internal topic: '%s' can not be fenced", inputPartition.topic()));
            }
            List partitionInfoList = topicDescription.partitions();
            for (TopicPartitionInfo partitionInfo : partitionInfoList) {
                validPartitions.add(new TopicPartition(inputPartition.topic(), partitionInfo.partition()));
            }
        }
        HashSet<TopicPartition> withInvalidPartitions = new HashSet<TopicPartition>(inputPartitions);
        withInvalidPartitions.removeAll(validPartitions);
        if (!withInvalidPartitions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found invalid partitions: %s", withInvalidPartitions));
        }
    }
}

