/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.common.MessageReader;
import kafka.tools.ConsoleProducer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.runtime.java8.JFunction0;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$ = new ConsoleProducer$();

    public void main(String[] args) {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
            MessageReader reader = (MessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            reader.init(System.in, this.getReaderProps(config));
            KafkaProducer producer = new KafkaProducer(this.producerProps(config));
            Exit.addShutdownHook((String)"producer-shutdown-hook", () -> Exit$.$anonfun$addShutdownHook$1((Function0)(JFunction0.mcV.sp & Serializable)() -> producer.close()));
            while (true) {
                ProducerRecord<byte[], byte[]> record;
                if ((record = reader.readMessage()) != null) {
                    this.send((KafkaProducer<byte[], byte[]>)producer, record, config.sync());
                }
                if (record != null) {
                    continue;
                }
                break;
            }
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        throw Exit$.MODULE$.exit(0, (Option<String>)None$.MODULE$);
    }

    private void send(KafkaProducer<byte[], byte[]> producer, ProducerRecord<byte[], byte[]> record, boolean sync) {
        if (sync) {
            producer.send(record).get();
            return;
        }
        producer.send(record, (Callback)new ErrorLoggingCallback(record.topic(), (byte[])record.key(), (byte[])record.value(), false));
    }

    public Properties getReaderProps(ConsoleProducer.ProducerConfig config) {
        Properties props = new Properties();
        props.put("topic", config.topic());
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.cmdLineProps());
        return props;
    }

    public Properties producerProps(ConsoleProducer.ProducerConfig config) {
        Properties props = config.options().has(config.producerConfigOpt()) ? Utils.loadProps((String)((String)config.options().valueOf(config.producerConfigOpt())), null) : new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.extraProducerProps());
        if (config.bootstrapServer() != null) {
            props.put("bootstrap.servers", config.bootstrapServer());
        } else {
            props.put("bootstrap.servers", config.brokerList());
        }
        props.put("compression.type", config.compressionCodec());
        if (props.getProperty("client.id") == null) {
            props.put("client.id", "console-producer");
        }
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "linger.ms", config.options(), config.sendTimeoutOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "acks", config.options(), config.requestRequiredAcksOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "request.timeout.ms", config.options(), config.requestTimeoutMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "retries", config.options(), config.messageSendMaxRetriesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "retry.backoff.ms", config.options(), config.retryBackoffMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "send.buffer.bytes", config.options(), config.socketBufferSizeOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "buffer.memory", config.options(), config.maxMemoryBytesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "batch.size", config.options(), config.batchSizeOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "batch.size", config.options(), config.maxPartitionMemoryBytesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "metadata.max.age.ms", config.options(), config.metadataExpiryMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "max.block.ms", config.options(), config.maxBlockMsOpt());
        return props;
    }

    private ConsoleProducer$() {
    }
}

