/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\r\u001a\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u00039\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00199\u0005\u0001)A\u0005\u0011\"1!\u000b\u0001Q\u0001\nMCa!\u0017\u0001!\u0002\u0013Q\u0006B\u00021\u0001A\u0003%\u0011\r\u0003\u0004e\u0001\u0001\u0006I!\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00027\t\rI\u0004\u0001\u0015!\u0003t\u0011\u00151\b\u0001\"\u0001x\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u001dI\u0011qF\r\u0002\u0002#\u0005\u0011\u0011\u0007\u0004\t1e\t\t\u0011#\u0001\u00024!1\u0001i\u0005C\u0001\u0003kA\u0011\"a\u000e\u0014#\u0003%\t!!\u000f\t\u0013\u0005=3#%A\u0005\u0002\u0005E\u0003\"CA+'E\u0005I\u0011AA\u001d\u0005-\u0019\u0016p\u001d;f[RKW.\u001a:\u000b\u0005iY\u0012!\u0002;j[\u0016\u0014(B\u0001\u000f\u001e\u0003\u0015)H/\u001b7t\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\t\u0011$\u0003\u0002+3\t)A+[7fe\u0006aQ\r_3dkR|'OT1nKB\u0011Q\u0006\u000e\b\u0003]I\u0002\"aL\u0012\u000e\u0003AR!!M\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u00194%\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a$\u0003\u0019!\u0018nY6NgB\u0011!%O\u0005\u0003u\r\u0012A\u0001T8oO\u0006Iq\u000f[3fYNK'0\u001a\t\u0003EuJ!AP\u0012\u0003\u0007%sG/A\u0004ti\u0006\u0014H/T:\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\tA\u0003\u0001C\u0003,\u000b\u0001\u0007A\u0006C\u00048\u000bA\u0005\t\u0019\u0001\u001d\t\u000fm*\u0001\u0013!a\u0001y!9q(\u0002I\u0001\u0002\u0004A\u0014\u0001\u0004;bg.,\u00050Z2vi>\u0014\bCA%Q\u001b\u0005Q%BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b:\u000bA!\u001e;jY*\tq*\u0001\u0003kCZ\f\u0017BA)K\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u00033fY\u0006L\u0018+^3vKB\u0019\u0011\n\u0016,\n\u0005US%A\u0003#fY\u0006L\u0018+^3vKB\u0011\u0001fV\u0005\u00031f\u0011Q\u0002V5nKJ$\u0016m]6MSN$\u0018a\u0003;bg.\u001cu.\u001e8uKJ\u0004\"a\u00170\u000e\u0003qS!!\u0018&\u0002\r\u0005$x.\\5d\u0013\tyFLA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\fi&l\u0017N\\4XQ\u0016,G\u000e\u0005\u0002)E&\u00111-\u0007\u0002\f)&l\u0017N\\4XQ\u0016,G.A\u0007sK\u0006$wK]5uK2{7m\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q*\u000bQ\u0001\\8dWNL!A[4\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\f\u0001B]3bI2{7m\u001b\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u001e\faCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0005\u0003c:\u0014\u0001BU3bI2{7m[\u0001\noJLG/\u001a'pG.\u0004\"!\u001c;\n\u0005Ut'!C,sSR,Gj\\2l\u0003\r\tG\r\u001a\u000b\u0003qn\u0004\"AI=\n\u0005i\u001c#\u0001B+oSRDQ\u0001`\u0007A\u0002u\f\u0011\u0002^5nKJ$\u0016m]6\u0011\u0005!r\u0018BA@\u001a\u0005%!\u0016.\\3s)\u0006\u001c8.A\tbI\u0012$\u0016.\\3s)\u0006\u001c8.\u00128uef$2\u0001_A\u0003\u0011\u001d\t9A\u0004a\u0001\u0003\u0013\ta\u0002^5nKJ$\u0016m]6F]R\u0014\u0018\u0010E\u0002)\u0003\u0017I1!!\u0004\u001a\u00059!\u0016.\\3s)\u0006\u001c8.\u00128uef\fA\"\u00193wC:\u001cWm\u00117pG.$B!a\u0005\u0002\u001aA\u0019!%!\u0006\n\u0007\u0005]1EA\u0004C_>dW-\u00198\t\r\u0005mq\u00021\u00019\u0003%!\u0018.\\3pkRl5/\u0001\u0003tSj,W#\u0001\u001f\u0002\u0011MDW\u000f\u001e3po:$\u0012\u0001\u001f\u0015\u0004\u0001\u0005\u001d\u0002\u0003BA\u0015\u0003Wi\u0011aG\u0005\u0004\u0003[Y\"A\u0003;ie\u0016\fGm]1gK\u0006Y1+_:uK6$\u0016.\\3s!\tA3c\u0005\u0002\u0014CQ\u0011\u0011\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m\"f\u0001\u001d\u0002>-\u0012\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003%)hn\u00195fG.,GMC\u0002\u0002J\r\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti%a\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003'R3\u0001PA\u001f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class SystemTimer
implements Timer {
    private final String executorName;
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public static long $lessinit$greater$default$4() {
        return Time.SYSTEM.hiResClockMs();
    }

    public static int $lessinit$greater$default$3() {
        return 20;
    }

    public static long $lessinit$greater$default$2() {
        return 1L;
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.delayMs() + Time.SYSTEM.hiResClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry)) {
            if (!timerTaskEntry.cancelled()) {
                this.taskExecutor.submit(timerTaskEntry.timerTask());
                return;
            }
            return;
        }
    }

    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush((Function1<TimerTaskEntry, BoxedUnit>)(Function1 & Serializable)timerTaskEntry -> {
                        this.addTimerTaskEntry(timerTaskEntry);
                        return BoxedUnit.UNIT;
                    });
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    public SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.executorName = executorName;
        this.taskExecutor = Executors.newFixedThreadPool(1, runnable -> {
            String nonDaemon_name = new StringBuilder(9).append("executor-").append($this.executorName).toString();
            return new KafkaThread(nonDaemon_name, runnable, false);
        });
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
    }
}

