/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0015e\u0001\u0002!B\u0001\u0019C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u00069\u0002!\t!\u0018\u0005\n\u0003o\u0001\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0001#\u0003%\t!!\u0015\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005]\u0003\"CA.\u0001E\u0005I\u0011AA,\u0011%\ti\u0006AI\u0001\n\u0003\ty\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005E\u0003\"CAC\u0001E\u0005I\u0011AAD\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bC\u0011\"!.\u0001#\u0003%\t!a\u0016\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005]\u0003\"CA]\u0001E\u0005I\u0011AA,\u0011%\tY\fAI\u0001\n\u0003\ty\u0006C\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007\"CAr\u0001E\u0005I\u0011AA,\u0011%\t)\u000fAI\u0001\n\u0003\t9\u0006C\u0005\u0002h\u0002\t\n\u0011\"\u0001\u0002`!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\n\u0005C\u0001\u0011\u0013!C\u0001\u0005GA\u0011Ba\n\u0001#\u0003%\tA!\u000b\t\u0013\t5\u0002!%A\u0005\u0002\u0005]\u0003\"\u0003B\u0018\u0001E\u0005I\u0011\u0001B\u0019\u0011%\u0011)\u0004AI\u0001\n\u0003\ty\u0006C\u0004\u00038\u0001!\tA!\u000f\t\u0013\t%\u0003!%A\u0005\u0002\t\r\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u00057\u0002A\u0011\u0001B/\u0011%\u0011I\u0007AI\u0001\n\u0003\ty\u0006C\u0004\u0003l\u0001!IA!\u001c\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!\u0011\u0012\u0001\u0005\u0002\t-\u0005b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005G\u0003A\u0011\u0001BS\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005_CqAa.\u0001\t\u0003\u0011I\fC\u0004\u0003@\u0002!\tA!1\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003J\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bh\u0001\u0011\u0005!\u0011\u001c\u0005\b\u0005?\u0004A\u0011\u0001Bq\u0011\u001d\u0011)\u000f\u0001C\u0001\u0005ODqAa>\u0001\t\u0003\u0011I\u0010C\u0004\u0003~\u0002!\tAa@\t\u000f\r\r\u0001\u0001\"\u0003\u0004\u0006!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\r\u0001\u0011\u000511\u0004\u0005\b\u0007?\u0001A\u0011AB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0001\u0007OAq!a@\u0001\t\u0003\u0019y\u0003C\u0004\u0002\u0000\u0002!\ta!\u000f\t\u000f\ru\u0002\u0001\"\u0001\u0004@!91q\n\u0001\u0005\u0002\rE\u0003bBB,\u0001\u0011\u00051\u0011\f\u0005\b\u0007G\u0002A\u0011AB3\u0011\u001d\u0019I\u0007\u0001C\u0001\u0007WBqaa\u001c\u0001\t\u0003\u0019\t\bC\u0004\u0004v\u0001!\taa\u001e\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0015\t\u00115)\u0001\u0002{W*\tA)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u000e\u000bQ!\u001e;jYNL!AU(\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002V-6\t\u0011)\u0003\u0002X\u0003\ni1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDC\u0001.\\!\t)\u0006\u0001C\u0003T\u0005\u0001\u0007A+A\u0006de\u0016\fG/\u001a+pa&\u001cG\u0003\u00040b]N,x0a\u0004\u0002\u001a\u0005u\u0001C\u0001%`\u0013\t\u0001\u0017J\u0001\u0003V]&$\b\"\u00022\u0004\u0001\u0004\u0019\u0017!\u0002;pa&\u001c\u0007C\u00013l\u001d\t)\u0017\u000e\u0005\u0002g\u00136\tqM\u0003\u0002i\u000b\u00061AH]8pizJ!A[%\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U&CQa\\\u0002A\u0002A\f!\u0002]1si&$\u0018n\u001c8t!\tA\u0015/\u0003\u0002s\u0013\n\u0019\u0011J\u001c;\t\u000bQ\u001c\u0001\u0019\u00019\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004w\u0007A\u0005\t\u0019A<\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003qvl\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\n\u0003\u0003\u0019\u0001\u0013!a\u0001\u0003\u0007\tQB]1dW\u0006;\u0018M]3N_\u0012,\u0007\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1)A\u0003bI6Lg.\u0003\u0003\u0002\u000e\u0005\u001d!!\u0004*bG.\fu/\u0019:f\u001b>$W\rC\u0005\u0002\u0012\r\u0001\n\u00111\u0001\u0002\u0014\u0005\tRo]3t\u001b>$WM\u001d8U_BL7-\u00133\u0011\u0007!\u000b)\"C\u0002\u0002\u0018%\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001c\r\u0001\n\u00111\u0001\u0002\u0014\u0005\tRo]3t\u0019\u0016<\u0017mY=U_BL7-\u00133\t\u0013\u0005}1\u0001%AA\u0002\u0005\u0005\u0012aC2mkN$XM\u001d'j].\u0004R\u0001SA\u0012\u0003OI1!!\nJ\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027j].T1!!\rD\u0003\u0019\u0019XM\u001d<fe&!\u0011QGA\u0016\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002<)\u001aq/!\u0010,\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0013J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\n\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'\u0006\u0002\u0002T)\"\u00111AA\u001f\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIY*\"!!\u0017+\t\u0005M\u0011QH\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00138\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIa*\"!!\u0019+\t\u0005\u0005\u0012QH\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002h\u0005e\u00141\u0010\t\u0007\u0003S\ny'a\u001d\u000e\u0005\u0005-$bAA7\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00141\u000e\u0002\u0004'\u0016\f\b\u0003BA\u0003\u0003kJA!a\u001e\u0002\b\tq!I]8lKJlU\r^1eCR\f\u0007\"CA\u0001\u0013A\u0005\t\u0019AA\u0002\u0011%\ti(\u0003I\u0001\u0002\u0004\ty(\u0001\u0006ce>\\WM\u001d'jgR\u0004R\u0001SA\u0012\u0003\u0003\u0003R!!\u001b\u0002pA\fAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$\u0013'\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%%\u0006BA@\u0003{\t\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiRya,a$\u0002\u0012\u0006U\u00151VAX\u0003c\u000b\u0019\fC\u0003c\u0019\u0001\u00071\r\u0003\u0004\u0002\u00142\u0001\ra^\u0001\u0007G>tg-[4\t\u000f\u0005]E\u00021\u0001\u0002\u001a\u0006Q\u0002/\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiB9\u0011\u0011NANa\u0006}\u0015\u0002BAO\u0003W\u00121!T1q!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS\u0007\u0006Q1m\u001c8ue>dG.\u001a:\n\t\u0005%\u00161\u0015\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\b\"CAW\u0019A\u0005\t\u0019AA\n\u0003!1\u0018\r\\5eCR,\u0007\"CA\t\u0019A\u0005\t\u0019AA\n\u0011%\tY\u0002\u0004I\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0002 1\u0001\n\u00111\u0001\u0002\"\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$H%N\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uI]\n1\u0002^8qS\u000e,\u00050[:ugR!\u00111CAa\u0011\u0019\t\u0019-\u0005a\u0001G\u0006IAo\u001c9jG:\u000bW.Z\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2De\u0016\fG/\u001a\u000b\b=\u0006%\u00171ZAg\u0011\u0015\u0011'\u00031\u0001d\u0011\u001d\t9J\u0005a\u0001\u00033Ca!a%\u0013\u0001\u00049\u0018!H<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0015\u001by\u000b\u0019.!6\u0002Z\u0006u\u0017q\\Aq\u0011\u0015\u00117\u00031\u0001d\u0011\u001d\t9n\u0005a\u0001\u00033\u000b\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\tYn\u0005a\u0001\u0003'\t\u0001\"[:Va\u0012\fG/\u001a\u0005\n\u0003#\u0019\u0002\u0013!a\u0001\u0003'A\u0011\"a\u0007\u0014!\u0003\u0005\r!a\u0005\t\u0013\u0005}1\u0003%AA\u0002\u0005\u0005\u0012aJ<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\nqe\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007y\u000bi\u000fC\u0003c/\u0001\u00071-A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u00033\u000b\u00190!>\u0002z\u0006u(\u0011\u0001B\u0003\u0005\u0013\u0011YB!\b\t\u000b\tD\u0002\u0019A2\t\u000f\u0005]\b\u00041\u0001\u0002\u001a\u0006\u0011R\r_5ti&tw-Q:tS\u001etW.\u001a8u\u0011\u001d\tY\u0010\u0007a\u0001\u0003O\n!\"\u00197m\u0005J|7.\u001a:t\u0011!\ty\u0010\u0007I\u0001\u0002\u0004\u0001\u0018!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0005\u0002Xb\u0001\n\u00111\u0001\u0003\u0004A)\u0001*a\t\u0002\u001a\"I!q\u0001\r\u0011\u0002\u0003\u0007\u00111C\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\n\u0005\u0017A\u0002\u0013!a\u0001\u0005\u001b\ta\u0002^8qS\u000e\u0004F.Y2f[\u0016tG\u000fE\u0003I\u0003G\u0011y\u0001\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)bQ\u0001\u0007G>lWn\u001c8\n\t\te!1\u0003\u0002\u000f)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0011%\ty\u0002\u0007I\u0001\u0002\u0004\t\t\u0003C\u0004\u0003 a\u0001\r!a\u0005\u00021I\f7m['jq&twmU;qa>\u0014H/\u00128bE2,G-A\fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0005\u0016\u0004a\u0006u\u0012aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YC\u000b\u0003\u0003\u0004\u0005u\u0012aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$s'\u0006\u0002\u00034)\"!QBA\u001f\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$\u0003(A\u000fde\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8u)A\tIJa\u000f\u0003>\t}\"\u0011\tB\"\u0005\u000b\u00129\u0005C\u0003c=\u0001\u00071\rC\u0004\u0002xz\u0001\r!!'\t\u000f\u0005mh\u00041\u0001\u0002h!A\u0011q \u0010\u0011\u0002\u0003\u0007\u0001\u000fC\u0004\u0002Xz\u0001\rAa\u0001\t\u000f\t-a\u00041\u0001\u0003\u000e!9!q\u0004\u0010A\u0002\u0005M\u0011aJ2sK\u0006$XMT3x!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\nQC^1mS\u0012\fG/\u001a(foB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0003P\tU#q\u000bB-!\u0019A%\u0011KAAa&\u0019!1K%\u0003\rQ+\b\u000f\\33\u0011\u0015\u0011\u0007\u00051\u0001d\u0011\u001d\t9\u0010\ta\u0001\u00033Ca!a@!\u0001\u0004\u0001\u0018AH2sK\u0006$X\rU1si&$\u0018n\u001c8t/&$\b.Q:tS\u001etW.\u001a8u))\tIJa\u0018\u0003b\t\r$q\r\u0005\u0006E\u0006\u0002\ra\u0019\u0005\b\u0003o\f\u0003\u0019AAM\u0011\u001d\u0011)'\ta\u0001\u00033\u000baC\\3x!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0005\n\u0003?\t\u0003\u0013!a\u0001\u0003C\t\u0001f\u0019:fCR,\u0007+\u0019:uSRLwN\\:XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\n\u0011D^1mS\u0012\fG/\u001a*fa2L7-Y!tg&<g.\\3oiR9aLa\u001c\u0003r\tU\u0004bBAlG\u0001\u0007\u0011\u0011\u0014\u0005\u0007\u0005g\u001a\u0003\u0019\u00019\u00023\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b\u0005o\u001a\u0003\u0019\u0001B=\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t\u0011\u0014Y\b]\u0005\u0004\u0005{j'aA*fi\u0006Y\u0001/\u0019:tK\n\u0013xn[3s)\u0011\u0011\u0019I!\"\u0011\t!\u000b\u0019\u0003\u001d\u0005\u0007\u0005\u000f#\u0003\u0019A2\u0002\r\t\u0014xn[3s\u00035\u0019\u0007.\u00198hK\u000e{gNZ5hgR9aL!$\u0003\u0012\nU\u0005B\u0002BHK\u0001\u00071-\u0001\u0006f]RLG/\u001f+za\u0016DaAa%&\u0001\u0004\u0019\u0017AC3oi&$\u0018PT1nK\"1!qS\u0013A\u0002]\fqaY8oM&<7/\u0001\u000bdQ\u0006tw-Z\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\u0006=\nu%\u0011\u0015\u0005\u0007\u0005?3\u0003\u0019A2\u0002#M\fg.\u001b;ju\u0016$7\t\\5f]RLE\r\u0003\u0004\u0003\u0018\u001a\u0002\ra^\u0001\u001fG\"\fgnZ3Vg\u0016\u0014xJ]+tKJ\u001cE.[3oi&#7i\u001c8gS\u001e$RA\u0018BT\u0005WCaA!+(\u0001\u0004\u0019\u0017aE:b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007B\u0002BLO\u0001\u0007q/\u0001\twC2LG-\u0019;f\u0013B\u001cuN\u001c4jOR)aL!-\u00036\"1!1\u0017\u0015A\u0002\r\f!!\u001b9\t\r\t]\u0005\u00061\u0001x\u00039\u0019\u0007.\u00198hK&\u00038i\u001c8gS\u001e$RA\u0018B^\u0005{CaAa-*\u0001\u0004\u0019\u0007B\u0002BLS\u0001\u0007q/A\nwC2LG-\u0019;f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003_\u0005\u0007\u0014)\rC\u0003cU\u0001\u00071\r\u0003\u0004\u0003\u0018*\u0002\ra^\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u00020\u0003L\n5\u0007\"\u00022,\u0001\u0004\u0019\u0007B\u0002BLW\u0001\u0007q/\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#\u00020\u0003T\n]\u0007b\u0002BkY\u0001\u0007\u0011\u0011Q\u0001\bEJ|7.\u001a:t\u0011\u0019\u00119\n\fa\u0001oR)aLa7\u0003^\"9!qQ\u0017A\u0002\t\r\u0005B\u0002BL[\u0001\u0007q/\u0001\u000bwC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0004=\n\r\bB\u0002BL]\u0001\u0007q/A\fdQ\u0006tw-Z\"mkN$XM\u001d'j].\u001cuN\u001c4jOR)aL!;\u0003t\"9!1^\u0018A\u0002\t5\u0018A\u00027j].LE\rE\u0002y\u0005_L1A!=z\u0005\u0011)V+\u0013#\t\r\tUx\u00061\u0001x\u0003=\u0001XM]:jgR,g\u000e\u001e)s_B\u001c\u0018A\u00064fi\u000eD7\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0015\u0007]\u0014Y\u0010C\u0004\u0003lB\u0002\rA!<\u0002/\u0015t7/\u001e:f\u00072,8\u000f^3s\u0019&t7.\u0012=jgR\u001cHc\u00010\u0004\u0002!9!1^\u0019A\u0002\t5\u0018AE2iC:<W-\u00128uSRL8i\u001c8gS\u001e$rAXB\u0004\u0007\u0017\u0019y\u0001\u0003\u0004\u0004\nI\u0002\raY\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u0019\u0019iA\ra\u0001G\u00069b-\u001e7m'\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0005/\u0013\u0004\u0019A<\u0002#\u0019,Go\u00195F]RLG/_\"p]\u001aLw\rF\u0003x\u0007+\u00199\u0002\u0003\u0004\u0004\nM\u0002\ra\u0019\u0005\u0007\u0005S\u001b\u0004\u0019A2\u0002%\u001d,G/\u00117m)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0003\u0007;\u0001b!!\u001b\u0002\u001c\u000e<\u0018!\u00064fi\u000eD\u0017\t\u001c7F]RLG/_\"p]\u001aLwm\u001d\u000b\u0005\u0007;\u0019\u0019\u0003\u0003\u0004\u0003\u0010V\u0002\raY\u0001\u001bM\u0016$8\r[!mY\u000eC\u0017\u000e\u001c3F]RLG/_\"p]\u001aLwm\u001d\u000b\u0007\u0007;\u0019Ica\u000b\t\r\r%a\u00071\u0001d\u0011\u0019\u0019iC\u000ea\u0001G\u0006y1\r[5mI\u0016sG/\u001b;z)f\u0004X\r\u0006\u0003\u00042\rM\u0002CBA5\u00037\u001b\u0007\u000fC\u0004\u00046]\u0002\raa\u000e\u0002\rQ|\u0007/[2t!\u0011!'1P2\u0015\t\t\r51\b\u0005\u0006Eb\u0002\raY\u0001\u0012GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\G#\u00020\u0004B\r-\u0003bBB\"s\u0001\u00071QI\u0001\u0010G2,8\u000f^3s\u0019&t7\u000eR1uCB\u0019Qka\u0012\n\u0007\r%\u0013IA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u0019\u0019i%\u000fa\u0001o\u0006\t\u0002/\u001a:tSN$XM\u001c;D_:4\u0017nZ:\u0002\u001d\u001d,Go\u00117vgR,'\u000fT5oWR!11KB+!\u0015A\u00151EB#\u0011\u001d\u0011YO\u000fa\u0001\u0005[\fqbZ3u\u00072,8\u000f^3s\u0019&t7n\u001d\u000b\u0005\u00077\u001ai\u0006\u0005\u0005\u0002j\u0005m%Q^B#\u0011\u001d\u0019yf\u000fa\u0001\u0007C\nq\u0001\\5oW&#7\u000fE\u0003e\u0005w\u0012i/\u0001\nhKR\fE\u000e\\\"mkN$XM\u001d'j].\u001cHCAB4!\u0019\tI'a\u001c\u0004F\u0005q1/\u001a;DYV\u001cH/\u001a:MS:\\Gc\u00010\u0004n!911I\u001fA\u0002\r\u0015\u0013!\u00053fY\u0016$Xm\u00117vgR,'\u000fT5oWR\u0019ala\u001d\t\u000f\t-h\b1\u0001\u0003n\u0006\u0001S.Y=cKJ+WM\\2ssB$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4t)\rq6\u0011\u0010\u0005\b\u0007wz\u0004\u0019AB?\u0003E\u0019wN\u001c4jOR\u0013\u0018M\\:g_JlWM\u001d\t\u0007\u0011\u000e}toa!\n\u0007\r\u0005\u0015JA\u0005Gk:\u001cG/[8ocA!\u0001*a\tx\u0001")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, partitions, replicationFactor, -1, -1).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            }
            throw new MatchError(null);
        });
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack())))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$2(x$4)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$4(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink, boolean rackMixingSupportEnabled) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement, rackMixingSupportEnabled);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement, boolean rackMixingSupportEnabled) {
        void var9_9;
        Tuple2<Seq<Object>, Object> tuple2 = this.validateNewPartitions(topic, existingAssignment, numPartitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq existingAssignmentPartition0 = (Seq)tuple2._1();
        int n = tuple2._2$mcI$sp();
        replicaAssignment.foreach(arg_0 -> AdminZkClient.$anonfun$createNewPartitionsAssignment$1$adapted(this, (Seq)var9_9, allBrokers, arg_0));
        return (Map)((Map)replicaAssignment.getOrElse(() -> AdminZkClient.$anonfun$createNewPartitionsAssignment$3(allBrokers, (Seq)var9_9, topicPlacement, n, rackMixingSupportEnabled, existingAssignment))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Tuple2<Seq<Object>, Object> validateNewPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, int numPartitions) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        return new Tuple2(existingAssignmentPartition0, (Object)BoxesRunTime.boxToInteger((int)partitionsToAdd));
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                return x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        String string6 = ConfigType$.MODULE$.ClusterLink();
        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
            throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$10 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$10))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(UUID linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentProps);
    }

    public Properties fetchClusterLinkConfig(UUID linkId) {
        return this.fetchEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
    }

    public void ensureClusterLinkExists(UUID linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> numPartitions(scala.collection.immutable.Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                Seq partitions = (Seq)x0$1._2();
                return new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            }
            throw new MatchError(null);
        });
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        UUID linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(UUID linkId) {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).get((Object)linkId);
    }

    public Map<UUID, ClusterLinkData> getClusterLinks(scala.collection.immutable.Set<UUID> linkIds) {
        return this.zkClient.getClusterLinks(linkIds);
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((IterableOnceOps)this.zkClient.getChildren("/cluster_links").map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData) {
        UUID linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public void deleteClusterLink(UUID linkId) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId);
        this.zkClient.deleteEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.getAllClusterLinks().foreach((Function1 & Serializable)link -> {
            this.zkClient.transformEntityConfigs(ConfigType$.MODULE$.ClusterLink(), link.linkId().toString(), (Function1<Properties, Option<Properties>>)configTransformer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$2(ReplicaAssignment x$4) {
        return x$4.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$4(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$4(Seq existingAssignmentPartition0$1, BrokerMetadata x$9) {
        return x$9.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$3(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, boolean rackMixingSupportEnabled$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$4(existingAssignmentPartition0$1, x$9))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), rackMixingSupportEnabled$1, startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!assignment.replicas().toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$10) {
        return Integer.toString(x$10);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$1$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSet());
        return BoxedUnit.UNIT;
    }
}

