/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u00193\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005\u0002\u0005CQA\u0015\u0001\u0005\u0002\u0005CQa\u0016\u0001\u0005\u0002\u0005CQ\u0001\u0018\u0001\u0005\u0002\u0005CQA\u0018\u0001\u0005\u0002\u0005CQ\u0001\u0019\u0001\u0005\u0002\u0005CQA\u0019\u0001\u0005\u0002\u0005CQ\u0001\u001a\u0001\u0005\u0002\u0005CQA\u001a\u0001\u0005\u0002\u0005CQ\u0001\u001b\u0001\u0005\u0002\u0005CQA\u001b\u0001\u0005\u0002\u0005CQ\u0001\u001c\u0001\u0005\u0002\u0005CQA\u001c\u0001\u0005\u0002\u0005CQ\u0001\u001d\u0001\u0005\u0002\u0005CQA\u001d\u0001\u0005\nMDQA \u0001\u0005\u0002\u0005Ca!!\u0001\u0001\t\u0003\t\u0005BBA\u0003\u0001\u0011\u0005\u0011\t\u0003\u0004\u0002\n\u0001!\t!\u0011\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u00033\u0001!\u0019!C\u0005\u00037A\u0001\"!\u000b\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003W\u0001!\u0019!C\u0005\u00037A\u0001\"!\f\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"a\u0011\u0001A\u0003%\u00111\u0007\u0005\u0007\u0003\u000b\u0002A\u0011A!\t\r\u0005%\u0003\u0001\"\u0001B\u0011\u0019\ti\u0005\u0001C\u0001\u0003\"1\u0011\u0011\u000b\u0001\u0005\u0002\u0005Ca!!\u0016\u0001\t\u0003\t\u0005BBA-\u0001\u0011\u0005\u0011\t\u0003\u0004\u0002^\u0001!\t!\u0011\u0005\u0007\u0003C\u0002A\u0011A!\t\r\u0005\u0015\u0004\u0001\"\u0001B\u0011\u0019\tI\u0007\u0001C\u0001\u0003\"1\u0011Q\u000e\u0001\u0005\u0002\u0005Ca!!\u001d\u0001\t\u0003\t\u0005BBA;\u0001\u0011\u0005\u0011\t\u0003\u0004\u0002z\u0001!\t!\u0011\u0005\u0007\u0003{\u0002A\u0011A!\t\r\u0005\u0005\u0005\u0001\"\u0001B\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fC\u0011\"a<\u0001#\u0003%I!!=\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!q\u0003\u0001\u0005\u0002\te!!C&bM.\fG+Z:u\u0015\u0005\u0019\u0014!B6bM.\f7\u0001A\n\u0003\u0001Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001?!\ty\u0004!D\u00013\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0005CA\u001cD\u0013\t!\u0005H\u0001\u0003V]&$\bF\u0001\u0002G!\t9\u0005+D\u0001I\u0015\tI%*A\u0002ba&T!a\u0013'\u0002\u000f),\b/\u001b;fe*\u0011QJT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005EC%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0004)B\u0011q)V\u0005\u0003-\"\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:)\u0005\u0011I\u0006CA$[\u0013\tY\u0006J\u0001\u0003UKN$\u0018!\u000b;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001c\u0018\t\u001e+iK\u0016sG\r\u000b\u0002\u00063\u0006)C/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg>sG.\u001f\u0015\u0003\re\u000bQ\u0006^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON\fE\u000f\u00165f\u0005\u0016<w-\u001b8hQ\t9\u0011,\u0001\u0010uKN$(I]8lKJ\u0014v\u000e\\3O_\u0012,\u0017\n\u001a,bY&$\u0017\r^5p]\"\u0012\u0001\"W\u0001#i\u0016\u001cHoQ8oiJ|G\u000e\\3s%>dWMT8eK&#g+\u00197jI\u0006$\u0018n\u001c8)\u0005%I\u0016\u0001\t;fgR\u001cu.\u001c2j]\u0016$'k\u001c7f\u001d>$W-\u00133WC2LG-\u0019;j_:D#AC-\u0002/Q,7\u000f^%t\u0017J\u000bg\r^\"p[\nLg.\u001a3N_\u0012,\u0007FA\u0006Z\u0003\u0005\"Xm\u001d;Jg.\u0013\u0016M\u001a;Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u0014Xj\u001c3fQ\ta\u0011,\u0001\ruKN$\u0018j]'vYRLG/\u001a8b]R\u001cE.^:uKJD#!D-\u0002!Q,7\u000f^%t\u001b\u0012\u001cXI\\1cY\u0016$\u0007F\u0001\bZ\u00039\"Xm\u001d;NkN$8i\u001c8uC&t\u0017+^8sk64v\u000e^3sg&3Wk]5oOB\u0013xnY3tgJ{G.Z:)\u0005=I\u0016\u0001E:fi2K7\u000f^3oKJ\u0004&o\u001c9t)\t\u0011E\u000fC\u0003v!\u0001\u0007a/A\u0003qe>\u00048\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0011uKN$8\t\\5f]R\fVo\u001c;b\u001b\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\bFA\tZ\u0003e!Xm\u001d;CC:$w/\u001b3uQF+x\u000e^1D_:4\u0017nZ:)\u0005II\u0016!\u0006;fgR\\\u0015MZ6b'Nd\u0007+Y:to>\u0014Hm\u001d\u0015\u0003'e\u000b\u0001\u0005^3ti.\u000bgm[1Tg2\u0004\u0016m]:x_J$7oV5uQNKXNY8mg\"\u0012A#W\u0001\u0016E>|G.Z1o!J|\u0007OV1mk\u0016$vnU3u+\t\t\t\u0002E\u00028\u0003'I1!!\u00069\u0005\u001d\u0011un\u001c7fC:\faCY8pY\u0016\fg\u000e\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0015gR\u0014\u0018N\\4Qe>\u0004h+\u00197vKR{7+\u001a;\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\"0\u0001\u0003mC:<\u0017\u0002BA\u0014\u0003C\u0011aa\u0015;sS:<\u0017!F:ue&tw\r\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0017a\u0006\u001c8o^8sIB\u0013x\u000e\u001d,bYV,Gk\\*fi\u00069\u0002/Y:to>\u0014H\r\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0013Y&\u001cH\u000f\u0015:paZ\u000bG.^3U_N+G/\u0006\u0002\u00024A1\u0011QGA \u0003;i!!a\u000e\u000b\t\u0005e\u00121H\u0001\nS6lW\u000f^1cY\u0016T1!!\u00109\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\n9D\u0001\u0003MSN$\u0018a\u00057jgR\u0004&o\u001c9WC2,X\rV8TKR\u0004\u0013!\u0006;fgRT6nU:m\u00072LWM\u001c;F]\u0006\u0014G.\u001a\u0015\u0003;e\u000b\u0011\u0004^3tij[7k\u001d7LKf\u001cFo\u001c:f\u0019>\u001c\u0017\r^5p]\"\u0012a$W\u0001\u001ci\u0016\u001cHOW6Tg2$&/^:u'R|'/\u001a'pG\u0006$\u0018n\u001c8)\u0005}I\u0016!\b;fgRTvn\\6fKB,'oS3z'R|'/\u001a)bgN<xN\u001d3)\u0005\u0001J\u0016a\b;fgRTvn\\6fKB,'\u000f\u0016:vgR\u001cFo\u001c:f!\u0006\u001c8o^8sI\"\u0012\u0011%W\u0001\u0016i\u0016\u001cHOW6Tg2\\U-_*u_J,G+\u001f9fQ\t\u0011\u0013,A\fuKN$(l[*tYR\u0013Xo\u001d;Ti>\u0014X\rV=qK\"\u00121%W\u0001\u0012i\u0016\u001cHOW6Tg2\u0004&o\u001c;pG>d\u0007F\u0001\u0013Z\u0003e!Xm\u001d;[WN\u001bH.\u00128bE2,G\r\u0015:pi>\u001cw\u000e\\:)\u0005\u0015J\u0016!\u0006;fgRT6nU:m\u0007&\u0004\b.\u001a:Tk&$Xm\u001d\u0015\u0003Me\u000b\u0001\u0006^3tij[7k\u001d7F]\u0012\u0004x.\u001b8u\u0013\u0012,g\u000e^5gS\u000e\fG/[8o\u00032<wN]5uQ6D#aJ-\u0002%Q,7\u000f\u001e.l'Nd7I\u001d7F]\u0006\u0014G.\u001a\u0015\u0003Qe\u000b1\u0003^3tij[7k\u001d7PGN\u0004XI\\1cY\u0016D#!K-\u0002CQ,7\u000f^\"p]:,7\r^5p]Nl\u0015\r\u001f*fCV$\b.T:EK\u001a\fW\u000f\u001c;)\u0005)J\u0016A\t;fgR\u001cuN\u001c8fGRLwN\\:NCb\u0014V-Y;uQ6\u001bX\t\u001f9mS\u000eLG\u000f\u000b\u0002,3\u0006aD/Z:u)>\u0004\u0018n\u0019*fa2L7-Y!tg&<gn\u001c:SKR,(O\\:F[B$\u0018p\u00149uS>t7o\u00165f]:{GoQ8oM&<WO]3eQ\ta\u0013,\u0001\u0007uKN$(l[\"p]\u001aLw-\u0006\u0004\u0002\n\u0006M\u0016q\u001d\u000b\u0010\u0005\u0006-\u00151UAT\u0003W\u000b)-!9\u0002l\"9\u0011QR\u0017A\u0002\u0005=\u0015!D6bM.\f\u0007K]8q\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0006}e\u0002BAJ\u00037\u00032!!&9\u001b\t\t9JC\u0002\u0002\u001aR\na\u0001\u0010:p_Rt\u0014bAAOq\u00051\u0001K]3eK\u001aLA!a\n\u0002\"*\u0019\u0011Q\u0014\u001d\t\u000f\u0005\u0015V\u00061\u0001\u0002\u0010\u0006)R\r\u001f9fGR,GmS1gW\u0006\u0004&o\u001c9OC6,\u0007bBAU[\u0001\u0007\u0011qR\u0001\fgf\u001c\bK]8q\u001d\u0006lW\rC\u0004\u0002.6\u0002\r!a,\u0002\u001dA\u0014x\u000e\u001d,bYV,Gk\\*fiB!\u0011\u0011WAZ\u0019\u0001!q!!..\u0005\u0004\t9LA\u0001U#\u0011\tI,a0\u0011\u0007]\nY,C\u0002\u0002>b\u0012qAT8uQ&tw\rE\u00028\u0003\u0003L1!a19\u0005\r\te.\u001f\u0005\b\u0003\u000fl\u0003\u0019AAe\u0003A9W\r\u001e)s_B4\u0016\r\\;f\rJ|W\u000eE\u00048\u0003\u0017\fy-a7\n\u0007\u00055\u0007HA\u0005Gk:\u001cG/[8ocA!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002VJ\naa]3sm\u0016\u0014\u0018\u0002BAm\u0003'\u00141bS1gW\u0006\u001cuN\u001c4jOB)q'!8\u00020&\u0019\u0011q\u001c\u001d\u0003\r=\u0003H/[8o\u0011\u001d\t\u0019/\fa\u0001\u0003K\fQ#\u001a=qK\u000e$X\r\u001a)s_B,'\u000f^=WC2,X\r\u0005\u0003\u00022\u0006\u001dHaBAu[\t\u0007\u0011q\u0017\u0002\u0002+\"I\u0011Q^\u0017\u0011\u0002\u0003\u0007\u00111\\\u0001\u0015Kb\u0004Xm\u0019;fI\u0012+g-Y;miZ\u000bG.^3\u0002-Q,7\u000f\u001e.l\u0007>tg-[4%I\u00164\u0017-\u001e7uI]*b!a=\u0003\u0010\tEQCAA{U\u0011\t90!@\u000f\u0007]\nI0C\u0002\u0002|b\nAAT8oK.\u0012\u0011q \t\u0005\u0005\u0003\u0011Y!\u0004\u0002\u0003\u0004)!!Q\u0001B\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0003\na\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iAa\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u00026:\u0012\r!a.\u0005\u000f\u0005%hF1\u0001\u00028\u0006!\u0002O]3qCJ,G)\u001a4bk2$8i\u001c8gS\u001e$\"!a$\u0002\u001bA\u0014X\r]1sK\u000e{gNZ5h)\u0011\tyIa\u0007\t\u000f\tu\u0001\u00071\u0001\u0003 \u0005)A.\u001b8fgB)qG!\t\u0002\u0010&\u0019!1\u0005\u001d\u0003\u000b\u0005\u0013(/Y=")
public class KafkaTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    @BeforeEach
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"}));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList("compact"), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList("compact", "delete"), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testCombinedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testIsKRaftCombinedMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftCombinedMode());
    }

    @Test
    public void testIsKRaftIsolatedControllerMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftIsolatedControllerMode());
    }

    @Test
    public void testIsMultitenantCluster() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMultitenantCluster());
        propertiesFile.setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "io.dummmy");
        this.setListenerProps(propertiesFile);
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMultitenantCluster());
    }

    @Test
    public void testIsMdsEnabled() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        propertiesFile.setProperty("confluent.metadata.server.listeners", "dummy:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMdsEnabled());
        propertiesFile.setProperty("confluent.metadata.server.listeners", "");
        this.setListenerProps(propertiesFile);
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMdsEnabled());
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If using process.roles, controller.quorum.voters must contain a parseable set of voters.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("broker");
        boolean hasControllerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
            }
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testClientQuotaMaxThrottleTimeMs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)5000L, (Long)config1.clientQuotaMaxThrottleTimeMs());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "client.quota.max.throttle.time.ms=10000"}));
        Assertions.assertEquals((long)10000L, (Long)config2.clientQuotaMaxThrottleTimeMs());
    }

    @Test
    public void testBandwidthQuotaConfigs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)Long.MAX_VALUE, (Long)config1.confluentConfig().brokerLimitProducerConfig());
        Assertions.assertEquals((long)Long.MAX_VALUE, (Long)config1.confluentConfig().brokerLimitConsumerConfig());
        Assertions.assertEquals((long)0xC80000L, (Long)config1.confluentConfig().maxBrokerTenantProducerByteRate());
        Assertions.assertEquals((long)0xC80000L, (Long)config1.confluentConfig().maxBrokerTenantConsumerByteRate());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "confluent.quota.tenant.broker.max.consumer.rate=10000", "--override", "confluent.quota.tenant.broker.max.producer.rate=10000"}));
        Assertions.assertEquals((long)10000L, (Long)config2.confluentConfig().maxBrokerTenantProducerByteRate());
        Assertions.assertEquals((long)10000L, (Long)config2.confluentConfig().maxBrokerTenantProducerByteRate());
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableOnceOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable)x0$1 -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)expected -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()}));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testTopicReplicaAssignorReturnsEmptyOptionsWhenNotConfigured() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile})).topicReplicaAssignorBuilder().isDefined(), (String)"Expected the assignor builder to not be loaded");
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()}));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils.tempFile((String)"kafkatest", (String)".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                KafkaTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreLocation$1(KafkaConfig config) {
        return config.zkSslKeyStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreLocation$1(KafkaConfig config) {
        return config.zkSslTrustStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperKeyStorePassword$1(KafkaConfig config) {
        return config.zkSslKeyStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperTrustStorePassword$1(KafkaConfig config) {
        return config.zkSslTrustStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreType$1(KafkaConfig config) {
        return config.zkSslKeyStoreType();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreType$1(KafkaConfig config) {
        return config.zkSslTrustStoreType();
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ Option $anonfun$testZkSslEnabledProtocols$1(KafkaConfig config) {
        return config.ZkSslEnabledProtocols();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslCipherSuites$1(KafkaConfig config) {
        return config.ZkSslCipherSuites();
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4}));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()}));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

