/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005BeBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004B\u0001\u0001\u0006IA\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0003q\u0005BB/\u0001A\u0003%q\nC\u0004_\u0001\t\u0007I\u0011A\"\t\r}\u0003\u0001\u0015!\u0003E\u0011\u001d\u0001\u0007A1A\u0005\u00029Ca!\u0019\u0001!\u0002\u0013y\u0005b\u00022\u0001\u0005\u0004%\ta\u0011\u0005\u0007G\u0002\u0001\u000b\u0011\u0002#\t\u000f\u0011\u0004!\u0019!C\u0001\u001d\"1Q\r\u0001Q\u0001\n=CqA\u001a\u0001C\u0002\u0013\u00051\t\u0003\u0004h\u0001\u0001\u0006I\u0001\u0012\u0005\bQ\u0002\u0011\r\u0011\"\u0001O\u0011\u0019I\u0007\u0001)A\u0005\u001f\"9!\u000e\u0001b\u0001\n\u0003\u0019\u0005BB6\u0001A\u0003%A\tC\u0004m\u0001\t\u0007I\u0011\u0001(\t\r5\u0004\u0001\u0015!\u0003P\u0011%I\u0003\u00011AA\u0002\u0013\u0005a\u000eC\u0005|\u0001\u0001\u0007\t\u0019!C\u0001y\"Q\u0011Q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B8\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!'\u0001\t\u0003\tY\nC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003+\u0004A\u0011AAl\u0005E\tE\r\u001a)beRLG/[8ogR+7\u000f\u001e\u0006\u0003S)\nQ!\u00193nS:T\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001G\u0003\u00022U\u000511/\u001a:wKJL!a\r\u0019\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0015\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t\u0019\u0011J\u001c;\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\t1\fgn\u001a\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003A!x\u000e]5dc\u0005\u001b8/[4o[\u0016tG/F\u0001P!\u0011\u0001VKO,\u000e\u0003ES!AU*\u0002\u0013%lW.\u001e;bE2,'B\u0001+=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003-F\u00131!T1q!\tA6,D\u0001Z\u0015\tQ&&\u0001\u0006d_:$(o\u001c7mKJL!\u0001X-\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/A\tu_BL7-M!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u0011i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e\u0014\u0014i]:jO:lWM\u001c;!\u0003\u0019!x\u000e]5dg\u00059Ao\u001c9jGN\u0002\u0013\u0001\u0005;pa&\u001c7'Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0007i>\u0004\u0018n\u0019\u001b\u0002\u000fQ|\u0007/[25A\u0005\u0001Bo\u001c9jGR\n5o]5h]6,g\u000e^\u0001\u0012i>\u0004\u0018n\u0019\u001bBgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001cW'A\u0004u_BL7-\u000e\u0011\u0002!Q|\u0007/[26\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8uAU\tq\u000e\u0005\u0002qs6\t\u0011O\u0003\u0002*e*\u00111\u000f^\u0001\bG2LWM\u001c;t\u0015\tYSO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>r\u0005\u0015\tE-\\5o\u0003%\tG-\\5o?\u0012*\u0017\u000fF\u0002~\u0003\u0003\u0001\"a\u000f@\n\u0005}d$\u0001B+oSRD\u0001\"a\u0001\u001b\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0014AB1e[&t\u0007%A\u0003tKR,\u0006\u000fF\u0002~\u0003\u0017Aq!!\u0004\u001d\u0001\u0004\ty!\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t\t\"a\b\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t1!\u00199j\u0015\u0011\tI\"a\u0007\u0002\u000f),\b/\u001b;fe*\u0019\u0011QD<\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u00121\u0003\u0002\t)\u0016\u001cH/\u00138g_\"\u001aA$!\n\u0011\t\u0005E\u0011qE\u0005\u0005\u0003S\t\u0019B\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3ti^\u0013xN\\4SKBd\u0017nY1D_VtG\u000fF\u0002~\u0003_Aq!!\r\u001e\u0001\u0004\t\u0019$\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005}\u0002cAA\u001dy5\u0011\u00111\b\u0006\u0004\u0003{a\u0013A\u0002\u001fs_>$h(C\u0002\u0002Bq\na\u0001\u0015:fI\u00164\u0017bA&\u0002F)\u0019\u0011\u0011\t\u001f)\u000fu\tI%!\u0016\u0002XA!\u00111JA)\u001b\t\tiE\u0003\u0003\u0002P\u0005]\u0011A\u00029be\u0006l7/\u0003\u0003\u0002T\u00055#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\tI&\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\b;\u0005u\u0013\u0011NA6!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$\u0002BA2\u0003\u001b\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003O\n\tGA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003[\n\t(\t\u0002\u0002p\u0005\u0011!p[\u0011\u0003\u0003g\nQa\u001b:bMR\f1\u0005^3ti6K7o]5oOB\u000b'\u000f^5uS>t7/\u00138De\u0016\fG/\u001a+pa&\u001c7\u000fF\u0002~\u0003sBq!!\r\u001f\u0001\u0004\t\u0019\u0004K\u0004\u001f\u0003\u0013\n)&a\u0016)\u000fy\ti&!\u001b\u0002\u00001\"\u0011QNA9\u0003\u001d\"Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]NLen\u0011:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0007u\f)\tC\u0004\u00022}\u0001\r!a\r)\u000f}\tI%!\u0016\u0002X!:q$!\u0018\u0002j\u0005-E\u0006BA7\u0003c\nq\u0003^3ti&s7M]3nK:$\b+\u0019:uSRLwN\\:\u0015\u0007u\f\t\nC\u0004\u00022\u0001\u0002\r!a\r)\u000f\u0001\nI%!\u0016\u0002X!:\u0001%!\u0018\u0002j\u0005]E\u0006BA7\u0003c\nq\u0005^3ti&s7M]3nK:$\b+\u0019:uSRLwN\\:XSRDG)Z4sC\u0012\fG/[8ogR\u0019Q0!(\t\u000f\u0005E\u0012\u00051\u0001\u00024!:\u0011%!\u0013\u0002V\u0005]\u0003fB\u0011\u0002^\u0005%\u00141\u0015\u0017\u0005\u0003[\n\t(A\u0018uKN$\u0018J\\2sK6,g\u000e\u001e)beRLG/[8og\u00063G/\u001a:EK\u001e\u0014\u0018\rZ1uS>t7OU3n_Z,G\rF\u0002~\u0003SCq!!\r#\u0001\u0004\t\u0019\u0004K\u0004#\u0003\u0013\n)&a\u0016)\u000f\t\ni&!\u001b\u000202\"\u0011QNA9\u0003y!Xm\u001d;NC:,\u0018\r\\!tg&<g.\\3oi>3'+\u001a9mS\u000e\f7\u000fF\u0002~\u0003kCq!!\r$\u0001\u0004\t\u0019\u0004K\u0004$\u0003\u0013\n)&a\u0016)\u000f\r\ni&!\u001b\u0002<2\"\u0011QNA9\u0003y!Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oi\u0006cGnU3sm\u0016\u00148\u000fF\u0002~\u0003\u0003Dq!!\r%\u0001\u0004\t\u0019\u0004K\u0004%\u0003\u0013\n)&a\u0016)\u000f\u0011\ni&!\u001b\u0002H2\u0012\u0011QN\u0001#i\u0016\u001cHOU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;QCJ$\u0018.\u00197TKJ4XM]:\u0015\u0007u\fi\rC\u0004\u00022\u0015\u0002\r!a\r)\u000f\u0015\nI%!\u0016\u0002X!:Q%!\u0018\u0002j\u0005MGFAA7\u0003e1\u0018\r\\5eCR,G*Z1eKJ\fe\u000e\u001a*fa2L7-Y:\u0015\u0013u\fINa\u0002\u0003\n\t5\u0001bBAnM\u0001\u0007\u0011Q\\\u0001\t[\u0016$\u0018\rZ1uCB!\u0011q\u001cB\u0001\u001d\u0011\t\t/a?\u000f\t\u0005\r\u0018Q\u001f\b\u0005\u0003K\f\tP\u0004\u0003\u0002h\u0006=h\u0002BAu\u0003[tA!!\u000f\u0002l&\t\u00010\u0003\u0002wo&\u00111&^\u0005\u0004\u0003g$\u0018AB2p[6|g.\u0003\u0003\u0002x\u0006e\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0007\u0005MH/\u0003\u0003\u0002~\u0006}\u0018\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0015\u0011\t90!?\n\t\t\r!Q\u0001\u0002\u000e)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u000b\t\u0005u\u0018q \u0005\u0006\u0001\u001a\u0002\rA\u000f\u0005\u0007\u0005\u00171\u0003\u0019\u0001\u001e\u0002!\u0015D\b/Z2uK\u0012dU-\u00193fe&#\u0007b\u0002B\bM\u0001\u0007!\u0011C\u0001\u0011Kb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCN\u0004R!!\u000e\u0003\u0014iJAA!\u0006\u0002F\t\u00191+\u001a;")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)package$.MODULE$.Seq().empty()))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)package$.MODULE$.Seq().empty()))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)package$.MODULE$.Seq().empty()))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3})), (Seq)package$.MODULE$.Seq().empty()))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)package$.MODULE$.Seq().empty()))}));
    private Admin admin;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.isKRaftTest()) {
            this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        }
        this.createTopicWithAssignment(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int k = x0$3._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                int k = x0$4._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.admin_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongReplicaCount(String quorum) {
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)2, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause().getClass());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreateTopics(String quorum) {
        HashMap<Integer, java.util.List<Integer>> topic6Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic6Placements.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic6Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        HashMap<Integer, java.util.List<Integer>> topic7Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic7Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic7Placements.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        java.util.Map futures = this.admin().createTopics(Arrays.asList(new NewTopic("new-topic6", topic6Placements), new NewTopic("new-topic7", topic7Placements))).values();
        Throwable topic6Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic6")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic6Cause.getClass());
        Assertions.assertTrue((boolean)topic6Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic6Cause.getMessage()).toString());
        Throwable topic7Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic7")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic7Cause.getClass());
        Assertions.assertTrue((boolean)topic7Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic7Cause.getMessage()).toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreatePartitions(String quorum) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, cause.getClass());
        if (this.isKRaftTest()) {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Attempted to add 2 additional partition(s), but only 1 assignment(s) were specified."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        } else {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Increasing the number of partitions by 2 but 1 assignments provided."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        }
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> {
                AdminZkClient qual$1 = this.adminZkClient();
                String x$3 = this.topic5();
                scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
                AdminZkClient qual$2 = this.adminZkClient();
                RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
                Option x$2 = qual$2.getBrokerMetadatas$default$2();
                Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
                Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$))})));
                boolean x$9 = qual$1.addPartitions$default$6();
                Option x$10 = qual$1.addPartitions$default$7();
                Option x$11 = qual$1.addPartitions$default$8();
                qual$1.addPartitions(x$3, x$4, x$5, 2, (Option)x$7, x$9, x$10, x$11, false);
            })).getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementPartitions(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementPartitionsWithDegradations(String quorum) {
        CloudAdmin adminClient = this.createCloudAdminClient(this.createCloudAdminClient$default$1());
        HashMap<Integer, java.util.List<Integer>> assignment = new HashMap<Integer, java.util.List<Integer>>();
        assignment.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
        adminClient.createTopics(Collections.singletonList(new NewTopic("topic2", assignment))).all().get();
        this.waitUntilLogCreatedOnBrokers("topic2", 0);
        adminClient.alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "testing", false), new AlterBrokerHealthOptions()).all().get();
        ArrayList<java.util.List<Integer>> newPartitionAssignments = new ArrayList<java.util.List<Integer>>();
        newPartitionAssignments.add(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
        newPartitionAssignments.add(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, newPartitionAssignments))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitionsWithDegradations$2(partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)((ReplicaAssignment)this.topic1Assignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).replicas().head()), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.head()).leaderId.get()));
        Assertions.assertEquals((Integer)((Integer)((java.util.List)newPartitionAssignments.get(0)).get(1)), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.apply((int)1)).leaderId.get()));
        Assertions.assertEquals((Integer)((Integer)((java.util.List)newPartitionAssignments.get(1)).get(1)), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.apply((int)2)).leaderId.get()));
        adminClient.alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "testing", false), new AlterBrokerHealthOptions()).all().get();
        Admin x$1 = this.admin();
        String x$2 = this.topic1();
        Option x$4 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt(((java.util.List)newPartitionAssignments.get(0)).get(0))));
        long x$5 = 30000L;
        None$ x$6 = None$.MODULE$;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(x$1, x$2, 1, x$5, (Option<Object>)x$6, (Option<Object>)x$4);
        Admin x$7 = this.admin();
        String x$8 = this.topic1();
        Option x$10 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt(((java.util.List)newPartitionAssignments.get(1)).get(0))));
        long x$11 = 30000L;
        None$ x$12 = None$.MODULE$;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(x$7, x$8, 2, x$11, (Option<Object>)x$12, (Option<Object>)x$10);
        ArrayList<java.util.List<Integer>> newPartitionAssignment = new ArrayList<java.util.List<Integer>>();
        newPartitionAssignment.add(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)));
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)4, newPartitionAssignment))).all().get();
        Admin x$13 = this.admin();
        String x$14 = this.topic1();
        Option x$16 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt(((java.util.List)newPartitionAssignments.get(0)).get(0))));
        long x$17 = 30000L;
        None$ x$18 = None$.MODULE$;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(x$13, x$14, 3, x$17, (Option<Object>)x$18, (Option<Object>)x$16);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementPartitionsAfterDegradationsRemoved(String quorum) {
        CloudAdmin adminClient = this.createCloudAdminClient(this.createCloudAdminClient$default$1());
        HashMap<Integer, java.util.List<Integer>> assignment = new HashMap<Integer, java.util.List<Integer>>();
        assignment.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
        adminClient.createTopics(Collections.singletonList(new NewTopic("topic2", assignment))).all().get();
        this.waitUntilLogCreatedOnBrokers("topic2", 0);
        adminClient.alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "testing", false), new AlterBrokerHealthOptions()).all().get();
        ArrayList<java.util.List<Integer>> newPartitionAssignments = new ArrayList<java.util.List<Integer>>();
        newPartitionAssignments.add(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
        newPartitionAssignments.add(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, newPartitionAssignments))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitionsAfterDegradationsRemoved$2(partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)((ReplicaAssignment)this.topic1Assignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).replicas().head()), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.head()).leaderId.get()));
        Assertions.assertEquals((Integer)((Integer)((java.util.List)newPartitionAssignments.get(0)).get(1)), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.apply((int)1)).leaderId.get()));
        Assertions.assertEquals((Integer)((Integer)((java.util.List)newPartitionAssignments.get(1)).get(1)), (Integer)((Integer)((MetadataResponse.PartitionMetadata)partitions.apply((int)2)).leaderId.get()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testManualAssignmentOfReplicas(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition1Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        Assertions.assertEquals((int)leader1, (int)partition1Metadata.leader());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition2Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        Assertions.assertEquals((int)leader2, (int)partition2Metadata.leader());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Buffer partitionMetadata = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().toSet());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementAllServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic3(), NewPartitions.increaseTo((int)7))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 2, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 3, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 4, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 5, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 6, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementPartialServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, scala.collection.immutable.Set<Object> expectedReplicas) {
        Option partitionOpt = CollectionConverters$.MODULE$.ListHasAsScala(metadata.partitionMetadata()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$6)));
        Assertions.assertTrue((boolean)partitionOpt.isDefined(), (String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)expectedLeaderId)), (Object)partition.leaderId, (String)"Partition leader id should match");
        Assertions.assertEquals(expectedReplicas, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet(), (String)"Replica set should match");
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitionsWithDegradations$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
        Assertions.assertNotEquals((int)1, (Integer)leaderId);
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitionsAfterDegradationsRemoved$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
        Assertions.assertNotEquals((int)1, (Integer)leaderId);
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$6) {
        return x$6.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

