/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerHealthCommand$;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthResult;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.clients.admin.DescribeBrokerHealthResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\t\u000fY\u0002\u0001\u0019!C\u0001o!1Q\b\u0001Q!\n-BQA\u0010\u0001\u0005\u0002}BQ!\u0014\u0001\u0005\u0002}BQA\u0015\u0001\u0005\u0002}BQ\u0001\u0016\u0001\u0005\u0002}BQA\u0016\u0001\u0005\u0002}BQ\u0001\u0017\u0001\u0005\ne\u0013qC\u0011:pW\u0016\u0014\b*Z1mi\"\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005=\u0001\u0012!B1e[&t'\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005q\u0011a\u00042p_R\u001cHO]1q'\u0016\u0014h/\u001a:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004TiJLgnZ\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<fe\u0002\nq\u0002^3ti\u0006#W.\u001b8DY&,g\u000e^\u000b\u0002WA\u0011A\u0006N\u0007\u0002[)\u0011afL\u0001\bG2LWM\u001c;t\u0015\t\t\u0002G\u0003\u00022e\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0002g\u0005\u0011\u0011n\\\u0005\u0003k5\u0012!b\u00117pk\u0012\fE-\\5o\u0003M!Xm\u001d;BI6Lgn\u00117jK:$x\fJ3r)\tA4\b\u0005\u0002\u0016s%\u0011!H\u0006\u0002\u0005+:LG\u000fC\u0004=\u000b\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013'\u0001\tuKN$\u0018\tZ7j]\u000ec\u0017.\u001a8uA\u0005)1/\u001a;VaR\t\u0001\b\u000b\u0002\b\u0003B\u0011!iS\u0007\u0002\u0007*\u0011A)R\u0001\u0004CBL'B\u0001$H\u0003\u001dQW\u000f]5uKJT!\u0001S%\u0002\u000b),h.\u001b;\u000b\u0003)\u000b1a\u001c:h\u0013\ta5I\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0004^3ti\u0012+7o\u0019:jE\u0016\u0014%o\\6fe\"+\u0017\r\u001c;iQ\tAq\n\u0005\u0002C!&\u0011\u0011k\u0011\u0002\u0005)\u0016\u001cH/A\u000buKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5)\u0005%y\u0015A\b;fgR$Um]2sS\n,'I]8lKJDU-\u00197uQRC'o\\<tQ\tQq*A\u000euKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5UQJ|wo\u001d\u0015\u0003\u0017=\u000b!B];o\u0007>lW.\u00198e)\rQF-\u001b\t\u00037\nt!\u0001\u00181\u0011\u0005u3R\"\u00010\u000b\u0005}\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002b-\u00051\u0001K]3eK\u001aL!aJ2\u000b\u0005\u00054\u0002\"B3\r\u0001\u00041\u0017\u0001B1sON\u00042!F4[\u0013\tAgCA\u0003BeJ\f\u0017\u0010C\u0003k\u0019\u0001\u00071&A\bn_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0001")
public class BrokerHealthCommandTest {
    private final String bootstrapServer;
    private CloudAdmin testAdminClient = (CloudAdmin)Mockito.mock(CloudAdmin.class);

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public CloudAdmin testAdminClient() {
        return this.testAdminClient;
    }

    public void testAdminClient_$eq(CloudAdmin x$1) {
        this.testAdminClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.testAdminClient_$eq((CloudAdmin)Mockito.mock(CloudAdmin.class));
    }

    @Test
    public void testDescribeBrokerHealth() {
        DescribeBrokerHealthResult describeBrokerHealthResult = (DescribeBrokerHealthResult)Mockito.mock(DescribeBrokerHealthResult.class);
        .colon.colon degradedBrokers = new .colon.colon((Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("test", BrokerComponent.UNSPECIFIED.id())}))).asJava()), (List)new .colon.colon((Object)new DegradedBroker(2, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("test", BrokerComponent.STORAGE.id())}))).asJava()), (List)new .colon.colon((Object)new DegradedBroker(3, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("test", BrokerComponent.NETWORK.id())}))).asJava()), (List)Nil$.MODULE$)));
        KafkaFuture future = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)describeBrokerHealthResult.future()).thenReturn((Object)future);
        Mockito.when((Object)future.get()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)degradedBrokers).asJava());
        Mockito.when((Object)this.testAdminClient().describeBrokerHealth((DescribeBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)describeBrokerHealthResult);
        Assertions.assertEquals((Object)"\tDegraded Broker: 1\n\t\tDegraded Component: UNSPECIFIED\n\t\tReason: test\n\n\n\tDegraded Broker: 2\n\t\tDegraded Component: STORAGE\n\t\tReason: test\n\n\n\tDegraded Broker: 3\n\t\tDegraded Component: NETWORK\n\t\tReason: test\n\n\n", (Object)this.runCommand(new String[]{"--describe"}, this.testAdminClient()));
    }

    @Test
    public void testAlterBrokerHealth() {
        AlterBrokerHealthSpec alterBrokerHealthSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "test", false);
        AlterBrokerHealthSpec alterBrokerStorageHealthSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, "test2", false);
        AlterBrokerHealthSpec alterBrokerNetworkHealthSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.NETWORK, ComponentHealthStatus.DEGRADED, "test3", false);
        AlterBrokerHealthSpec alterBrokerHealthWithForceSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "test", true);
        AlterBrokerHealthResult alterBrokerHealthResult = (AlterBrokerHealthResult)Mockito.mock(AlterBrokerHealthResult.class);
        AlterBrokerHealthResult alterBrokerStorageHealthResult = (AlterBrokerHealthResult)Mockito.mock(AlterBrokerHealthResult.class);
        AlterBrokerHealthResult alterBrokerNetworkHealthResult = (AlterBrokerHealthResult)Mockito.mock(AlterBrokerHealthResult.class);
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        KafkaFuture controller = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Node mockControllerNode = (Node)Mockito.mock(Node.class);
        KafkaFuture alterFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        KafkaFuture alterStorageFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        KafkaFuture alterNetworkFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        scala.collection.immutable.Map alterResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)alterFuture)}));
        scala.collection.immutable.Map alterStorageResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)alterStorageFuture)}));
        scala.collection.immutable.Map alterNetworkResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)alterNetworkFuture)}));
        Mockito.when((Object)this.testAdminClient().describeCluster()).thenReturn((Object)describeClusterResult);
        Mockito.when((Object)describeClusterResult.controller()).thenReturn((Object)controller);
        Mockito.when((Object)controller.get()).thenReturn((Object)mockControllerNode);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockControllerNode.id())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)alterBrokerHealthSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerHealthResult);
        Mockito.when((Object)alterBrokerHealthResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterResult).asJava());
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.UNSPECIFIED, (ComponentHealthStatus)ComponentHealthStatus.DEGRADED));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: UNSPECIFIED\t\tState: DEGRADED\n", (Object)this.runCommand(new String[]{"--health-status", "DEGRADED", "--component", "UNSPECIFIED", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)alterBrokerStorageHealthSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerStorageHealthResult);
        Mockito.when((Object)alterBrokerStorageHealthResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterStorageResult).asJava());
        Mockito.when((Object)alterStorageFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.STORAGE, (ComponentHealthStatus)ComponentHealthStatus.DEGRADED));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: STORAGE\t\tState: DEGRADED\n", (Object)this.runCommand(new String[]{"--health-status", "DEGRADED", "--component", "STORAGE", "--broker-ids", "1", "--reason", "test2"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)alterBrokerNetworkHealthSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerNetworkHealthResult);
        Mockito.when((Object)alterBrokerNetworkHealthResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterNetworkResult).asJava());
        Mockito.when((Object)alterNetworkFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.NETWORK, (ComponentHealthStatus)ComponentHealthStatus.DEGRADED));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: NETWORK\t\tState: DEGRADED\n", (Object)this.runCommand(new String[]{"--health-status", "DEGRADED", "--component", "NETWORK", "--broker-ids", "1", "--reason", "test3"}, this.testAdminClient()));
        AlterBrokerHealthSpec healthySpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "test", false);
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)healthySpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerHealthResult);
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.UNSPECIFIED, (ComponentHealthStatus)ComponentHealthStatus.HEALTHY));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: UNSPECIFIED\t\tState: HEALTHY\n", (Object)this.runCommand(new String[]{"--health-status", "HEALTHY", "--component", "UNSPECIFIED", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        AlterBrokerHealthSpec healthyStorageSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, "test2", false);
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)healthyStorageSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerHealthResult);
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.STORAGE, (ComponentHealthStatus)ComponentHealthStatus.HEALTHY));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: STORAGE\t\tState: HEALTHY\n", (Object)this.runCommand(new String[]{"--health-status", "HEALTHY", "--component", "UNSPECIFIED", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        AlterBrokerHealthSpec healthyNetworkSpec = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, "test3", false);
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)healthyNetworkSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerNetworkHealthResult);
        Mockito.when((Object)alterNetworkFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.NETWORK, (ComponentHealthStatus)ComponentHealthStatus.HEALTHY));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: NETWORK\t\tState: HEALTHY\n", (Object)this.runCommand(new String[]{"--health-status", "HEALTHY", "--component", "NETWORK", "--broker-ids", "1", "--reason", "test3"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)alterBrokerHealthWithForceSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerHealthResult);
        Mockito.when((Object)alterBrokerHealthResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterResult).asJava());
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.UNSPECIFIED, (ComponentHealthStatus)ComponentHealthStatus.DEGRADED));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: UNSPECIFIED\t\tState: DEGRADED\n", (Object)this.runCommand(new String[]{"--health-status", "DEGRADED", "--component", "UNSPECIFIED", "--broker-ids", "1", "--reason", "test", "--force"}, this.testAdminClient()));
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerHealthStatusResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerComponent)BrokerComponent.UNSPECIFIED, (ComponentHealthStatus)ComponentHealthStatus.UNKNOWN));
        Assertions.assertEquals((Object)"\tBroker: 1\t\tComponent: UNSPECIFIED\t\tState: UNKNOWN\n", (Object)this.runCommand(new String[]{"--health-status", "HEALTHY", "--component", "UNSPECIFIED", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterBrokerHealth((AlterBrokerHealthSpec)ArgumentMatchers.eq((Object)alterBrokerHealthSpec), (AlterBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)alterBrokerHealthResult);
    }

    @Test
    public void testDescribeBrokerHealthThrows() {
        new .colon.colon((Object)new String[]{""}, (List)new .colon.colon((Object)new String[]{"--describe", "--health-status", "xyz"}, (List)new .colon.colon((Object)new String[]{"--describe", "--component", "xyz"}, (List)new .colon.colon((Object)new String[]{"--describe", "--reason", "xyz"}, (List)new .colon.colon((Object)new String[]{"--describe", "--broker-ids", "xyz"}, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerHealthCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143)));
        DescribeBrokerHealthResult describeBrokerHealthResult = (DescribeBrokerHealthResult)Mockito.mock(DescribeBrokerHealthResult.class);
        KafkaFuture future = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)future.get()).thenThrow(new Throwable[]{new ExecutionException((Throwable)new InvalidRequestException("invalid test"))});
        Mockito.when((Object)describeBrokerHealthResult.future()).thenReturn((Object)future);
        Mockito.when((Object)this.testAdminClient().describeBrokerHealth((DescribeBrokerHealthOptions)ArgumentMatchers.any())).thenReturn((Object)describeBrokerHealthResult);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand(new String[]{"--describe"}, this.testAdminClient()), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("BrokerHealthCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }

    @Test
    public void testAlterBrokerHealthThrows() {
        new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--component", "xyz"}, (List)new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--broker-ids", "1"}, (List)new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--reason", "xyz"}, (List)new .colon.colon((Object)new String[]{"--force", "--broker-ids", "1", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--force"}, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerHealthCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165)));
        new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--component", "UNSPECIFIED", "--broker-ids", "1a", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--component", "UNSPECIFIED", "--broker-ids", "1a", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--health-status", "xyz", "--component", "UNSPECIFIED", "--broker-ids", "1a", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--component", "xyz", "--broker-ids", "1a", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--health-status", "HEALTHY", "--component", "UNKNOWN", "--broker-ids", "1", "--reason", "valid"}, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("BrokerHealthCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175)));
    }

    private String runCommand(String[] args, CloudAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> BrokerHealthCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    public BrokerHealthCommandTest() {
        this.bootstrapServer = "localhost:9092";
    }
}

