/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.admin.ConsumerGroupCommand;
import kafka.api.BaseConsumerTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.provider.Arguments;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r-g\u0001\u00027n\u0001IDQ!\u001f\u0001\u0005\u0002iDq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\t\u0011\u0005E\u0001A1A\u0005\u0002yDq!a\u0005\u0001A\u0003%q\u0010C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018!I\u00111\n\u0001A\u0002\u0013%\u0011Q\n\u0005\t\u00037\u0002\u0001\u0015)\u0003\u0002\u001a!I\u0011Q\f\u0001A\u0002\u0013%\u0011q\f\u0005\n\u0007\u001f\u0001\u0001\u0019!C\u0005\u0007#A\u0001b!\u0006\u0001A\u0003&\u0011\u0011\r\u0005\b\u0007/\u0001A\u0011IB\r\u0011\u001d\u0019y\u0003\u0001C!\u0007cAqaa\u0013\u0001\t\u0003\u0012Y\u0002C\u0004\u0004V\u0001!\taa\u0016\t\u0013\r%\u0004!%A\u0005\u0002\r-\u0004\"CB8\u0001E\u0005I\u0011AB6\u0011\u001d\u0019\t\b\u0001C\u0001\u0007gBqa! \u0001\t\u0003\u0019y\bC\u0004\u0004\f\u0002!\ta!$\t\u0013\r\u0005\u0006!%A\u0005\u0002\r-\u0004\"CBR\u0001E\u0005I\u0011AB6\u0011%\u0019)\u000bAI\u0001\n\u0003\u0019Y\u0007C\u0005\u0004(\u0002\t\n\u0011\"\u0001\u0004*\"I1Q\u0016\u0001\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0007_\u0003\u0011\u0013!C\u0001\u0005\u0007B\u0011b!-\u0001#\u0003%\taa\u001b\t\u000f\rM\u0006\u0001\"\u0001\u00046\"I1Q\u0018\u0001\u0012\u0002\u0013\u00051q\u0018\u0005\n\u0007\u0007\u0004\u0011\u0013!C\u0001\u0007WBqa!2\u0001\t\u0013\u00199mB\u0004\u0002h5D\t!!\u001b\u0007\r1l\u0007\u0012AA6\u0011\u0019I\u0018\u0005\"\u0001\u0002t!9\u0011QO\u0011\u0005\u0002\u0005]daBASC\u0005\u0005\u0011q\u0015\u0005\u000b\u0003k##\u0011!Q\u0001\n\u0005]\u0006BCAcI\t\u0005\t\u0015!\u0003\u00028\"Q\u0011q\u0019\u0013\u0003\u0002\u0003\u0006I!!3\t\u0015\u0005]GE!A!\u0002\u0013\tI\u000e\u0003\u0004zI\u0011\u0005\u0011q\u001c\u0005\n\u0003[$#\u0019!C\u0001\u0003_D\u0001\"!=%A\u0003%\u0011q\u001a\u0005\n\u0003g$#\u0019!C\u0001\u0003kD\u0001B!\u0005%A\u0003%\u0011q\u001f\u0005\b\u0005'!C\u0011\u0001B\u000b\u0011\u001d\u0011I\u0002\nD\u0001\u00057AqA!\b%\t\u0003\u0011Y\u0002C\u0004\u0003 \u0011\"\tAa\u0007\b\u0013\t\u0005\u0012%!A\t\u0002\t\rb!CASC\u0005\u0005\t\u0012\u0001B\u0013\u0011\u0019I8\u0007\"\u0001\u0003(!I!\u0011F\u001a\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0005\u0003\u001a\u0014\u0013!C\u0001\u0005\u00072aAa\u0012\"\u0001\t%\u0003BCA[o\t\u0005\t\u0015!\u0003\u00028\"Q\u0011QY\u001c\u0003\u0002\u0003\u0006I!a.\t\u0015\t-sG!A!\u0002\u0013\t9\fC\u0005~o\t\u0005\t\u0015!\u0003\u00028\"Q!QJ\u001c\u0003\u0002\u0003\u0006I!a.\t\u0015\t=sG!A!\u0002\u0013\u0011\t\u0006\u0003\u0006\u0002H^\u0012\t\u0011)A\u0005\u0003\u0013D!\"a68\u0005\u0003\u0005\u000b\u0011BAm\u0011\u0019Ix\u0007\"\u0001\u0003T!9!1C\u001c\u0005B\t\u001d\u0004b\u0002B\ro\u0011\u0005#1D\u0004\n\u0005W\n\u0013\u0011!E\u0001\u0005[2\u0011Ba\u0012\"\u0003\u0003E\tAa\u001c\t\re$E\u0011\u0001B9\u0011%\u0011\u0019\bRI\u0001\n\u0003\u0011Y\u0003C\u0005\u0003v\u0011\u000b\n\u0011\"\u0001\u0003D\u00191!qO\u0011\u0001\u0005sB!\"!.I\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\t)\r\u0013B\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0005wB%\u0011!Q\u0001\n\tu\u0004BB=I\t\u0003\u0011y\tC\u0004\u0003\u001a!#\tEa\u0007\u0007\r\te\u0015\u0005\u0001BN\u0011)\u0011iJ\u0014B\u0001B\u0003%!q\u0014\u0005\u0007s:#\tA!*\t\u0013\t-fJ1A\u0005\n\t5\u0006\u0002\u0003B^\u001d\u0002\u0006IAa,\t\u0013\tufJ1A\u0005\n\t}\u0006\u0002\u0003Bi\u001d\u0002\u0006IA!1\t\u000f\tMg\n\"\u0001\u0003V\"9!q\u0004(\u0005\u0002\tmaA\u0002BnC\u0001\u0011i\u000e\u0003\u0006\u00026^\u0013\t\u0011)A\u0005\u0003oC!Ba8X\u0005\u0003\u0005\u000b\u0011\u0002BP\u0011)\t)m\u0016B\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0005\u0017:&\u0011!Q\u0001\n\u0005]\u0006\"C?X\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\u0011ie\u0016B\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0005\u001f:&\u0011!Q\u0001\n\tE\u0003BCAd/\n\u0005\t\u0015!\u0003\u0002J\"Q\u0011q[,\u0003\u0002\u0003\u0006I!!7\t\re<F\u0011\u0001Bq\u000f%\u001190IA\u0001\u0012\u0003\u0011IPB\u0005\u0003\\\u0006\n\t\u0011#\u0001\u0003|\"1\u0011p\u0019C\u0001\u0005{D\u0011B!\u001ed#\u0003%\tAa\u000b\t\u0013\t}8-%A\u0005\u0002\t\rcABB\u0001C\u0001\u0019\u0019\u0001\u0003\u0006\u00026\u001e\u0014\t\u0011)A\u0005\u0003oC!\"!2h\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\u0011Yh\u001aB\u0001B\u0003%!Q\u0010\u0005\u0007s\u001e$\ta!\u0002\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cHO\u0003\u0002o_\u0006)\u0011\rZ7j]*\t\u0001/A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\bC\u0001;x\u001b\u0005)(B\u0001<p\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005a,(AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\bC\u0001?\u0001\u001b\u0005i\u0017!\u0002;pa&\u001cW#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0003he>,\b/\u0001\u0004he>,\b\u000fI\u0001\u0015G>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0016\u0005\u0005e\u0001CBA\u000e\u0003_\t)D\u0004\u0003\u0002\u001e\u0005%b\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0012/\u0001\u0004=e>|GOP\u0005\u0003\u0003O\tQa]2bY\u0006LA!a\u000b\u0002.\u00059\u0001/Y2lC\u001e,'BAA\u0014\u0013\u0011\t\t$a\r\u0003\t1K7\u000f\u001e\u0006\u0005\u0003W\ti\u0003\u0005\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u0003rA!a\u000f\u0002@9!\u0011qDA\u001f\u0013\u0005\u0001\u0018B\u00018p\u0013\r\t\u0019%\\\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\n\t\u0005\u001d\u0013\u0011\n\u0002\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0007\u0005\rS.\u0001\rd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-Z0%KF$B!a\u0014\u0002XA!\u0011\u0011KA*\u001b\t\ti#\u0003\u0003\u0002V\u00055\"\u0001B+oSRD\u0011\"!\u0017\b\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'A\u000bd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-\u001a\u0011\u0002-\r|gn];nKJ<%o\\;q\u000bb,7-\u001e;peN,\"!!\u0019\u0011\r\u0005m\u0011qFA2!\r\t)G\u0014\b\u0003y\u0002\n\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u!\ta\u0018eE\u0002\"\u0003[\u0002B!!\u0015\u0002p%!\u0011\u0011OA\u0017\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011N\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m)\t\tI\b\u0005\u0004\u0002|\u0005\u0015\u0015\u0011R\u0007\u0003\u0003{RA!a \u0002\u0002\u000611\u000f\u001e:fC6TA!a!\u0002\b\u0005!Q\u000f^5m\u0013\u0011\t9)! \u0003\rM#(/Z1n!\u0011\tY)!)\u000e\u0005\u00055%\u0002BAH\u0003#\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003'\u000b)*\u0001\u0004qCJ\fWn\u001d\u0006\u0005\u0003/\u000bI*A\u0004kkBLG/\u001a:\u000b\t\u0005m\u0015QT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003?\u000b1a\u001c:h\u0013\u0011\t\u0019+!$\u0003\u0013\u0005\u0013x-^7f]R\u001c(\u0001G!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s%Vtg.\u00192mKN)A%!+\u00020B!\u0011\u0011AAV\u0013\u0011\ti+a\u0001\u0003\r=\u0013'.Z2u!\u0011\t\t!!-\n\t\u0005M\u00161\u0001\u0002\t%Vtg.\u00192mK\u00061!M]8lKJ\u0004B!!/\u0002B:!\u00111XA_!\u0011\ty\"!\f\n\t\u0005}\u0016QF\u0001\u0007!J,G-\u001a4\n\t\u00055\u00111\u0019\u0006\u0005\u0003\u007f\u000bi#A\u0004he>,\b/\u00133\u0002\u001d\r,8\u000f^8n!J|\u0007o](qiB1\u0011\u0011KAf\u0003\u001fLA!!4\u0002.\t1q\n\u001d;j_:\u0004B!!5\u0002T6\u0011\u0011\u0011Q\u0005\u0005\u0003+\f\tI\u0001\u0006Qe>\u0004XM\u001d;jKN\f!b]=oG\u000e{W.\\5u!\u0011\t\t&a7\n\t\u0005u\u0017Q\u0006\u0002\b\u0005>|G.Z1o))\t\t/!:\u0002h\u0006%\u00181\u001e\t\u0004\u0003G$S\"A\u0011\t\u000f\u0005U\u0016\u00061\u0001\u00028\"9\u0011QY\u0015A\u0002\u0005]\u0006\"CAdSA\u0005\t\u0019AAe\u0011%\t9.\u000bI\u0001\u0002\u0004\tI.A\u0003qe>\u00048/\u0006\u0002\u0002P\u00061\u0001O]8qg\u0002\n\u0001bY8ogVlWM]\u000b\u0003\u0003o\u0004\u0002\"!?\u0003\b\t-!1B\u0007\u0003\u0003wTA!a=\u0002~*!\u0011q B\u0001\u0003\u001d\u0019G.[3oiNT1\u0001\u001dB\u0002\u0015\u0011\u0011)!!(\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011I!a?\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0011\t\tF!\u0004\n\t\t=\u0011Q\u0006\u0002\b\u001d>$\b.\u001b8h\u0003%\u0019wN\\:v[\u0016\u0014\b%A\u0005d_:4\u0017nZ;sKR!\u0011q\nB\f\u0011\u001d\tiO\fa\u0001\u0003\u001f\f\u0011b];cg\u000e\u0014\u0018NY3\u0015\u0005\u0005=\u0013a\u0001:v]\u0006A1\u000f[;uI><h.\u0001\rBEN$(/Y2u\u0007>t7/^7feJ+hN\\1cY\u0016\u00042!a94'\r\u0019\u0014Q\u000e\u000b\u0003\u0005G\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0017U\u0011\tIMa\f,\u0005\tE\u0002\u0003\u0002B\u001a\u0005{i!A!\u000e\u000b\t\t]\"\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa\u000f\u0002.\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}\"Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0003F)\"\u0011\u0011\u001cB\u0018\u0005A\u0019uN\\:v[\u0016\u0014(+\u001e8oC\ndWmE\u00028\u0003C\fQb\u001a:pkB\u0004&o\u001c;pG>d\u0017\u0001C:ue\u0006$XmZ=\u0002\u001dI,Wn\u001c;f\u0003N\u001c\u0018n\u001a8peB1\u0011\u0011KAf\u0003o#\"C!\u0016\u0003X\te#1\fB/\u0005?\u0012\tGa\u0019\u0003fA\u0019\u00111]\u001c\t\u000f\u0005U\u0006\t1\u0001\u00028\"9\u0011Q\u0019!A\u0002\u0005]\u0006b\u0002B&\u0001\u0002\u0007\u0011q\u0017\u0005\u0007{\u0002\u0003\r!a.\t\u000f\t5\u0003\t1\u0001\u00028\"9!q\n!A\u0002\tE\u0003\"CAd\u0001B\u0005\t\u0019AAe\u0011%\t9\u000e\u0011I\u0001\u0002\u0004\tI\u000e\u0006\u0003\u0002P\t%\u0004bBAw\u0003\u0002\u0007\u0011qZ\u0001\u0011\u0007>t7/^7feJ+hN\\1cY\u0016\u00042!a9E'\r!\u0015Q\u000e\u000b\u0003\u0005[\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003H\u0001\fTS6\u0004H.Z\"p]N,X.\u001a:Sk:t\u0017M\u00197f'\rA\u0015\u0011]\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBA\u000e\u0005\u007f\u0012\u0019)\u0003\u0003\u0003\u0002\u0006M\"\u0001C%uKJ\f'\r\\3\u0011\t\t\u0015%1R\u0007\u0003\u0005\u000fSAA!#\u0003\u0002\u000511m\\7n_:LAA!$\u0003\b\nqAk\u001c9jGB\u000b'\u000f^5uS>tG\u0003\u0003BI\u0005'\u0013)Ja&\u0011\u0007\u0005\r\b\nC\u0004\u000262\u0003\r!a.\t\u000f\u0005\u0015G\n1\u0001\u00028\"9!1\u0010'A\u0002\tu$!H!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s\u000fJ|W\u000f]#yK\u000e,Ho\u001c:\u0014\u00079\u000bi'\u0001\u0006ok6$\u0006N]3bIN\u0004B!!\u0015\u0003\"&!!1UA\u0017\u0005\rIe\u000e\u001e\u000b\u0005\u0005O\u0013I\u000bE\u0002\u0002d:CqA!(Q\u0001\u0004\u0011y*\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\u0011y\u000b\u0005\u0003\u00032\n]VB\u0001BZ\u0015\u0011\u0011),!!\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003:\nM&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013!C2p]N,X.\u001a:t+\t\u0011\t\r\u0005\u0004\u0003D\n5\u0017\u0011]\u0007\u0003\u0005\u000bTAAa2\u0003J\u00069Q.\u001e;bE2,'\u0002\u0002Bf\u0003[\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yM!2\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u000bG>t7/^7feN\u0004\u0013AB:vE6LG\u000f\u0006\u0003\u0002P\t]\u0007b\u0002Bm+\u0002\u0007\u0011\u0011]\u0001\u000fG>t7/^7feRC'/Z1e\u0005U\u0019uN\\:v[\u0016\u0014xI]8va\u0016CXmY;u_J\u001c2a\u0016BT\u00031qW/\\\"p]N,X.\u001a:t)Q\u0011\u0019O!:\u0003h\n%(1\u001eBw\u0005_\u0014\tPa=\u0003vB\u0019\u00111],\t\u000f\u0005U\u0016\r1\u0001\u00028\"9!q\\1A\u0002\t}\u0005bBAcC\u0002\u0007\u0011q\u0017\u0005\b\u0005\u0017\n\u0007\u0019AA\\\u0011\u0019i\u0018\r1\u0001\u00028\"9!QJ1A\u0002\u0005]\u0006b\u0002B(C\u0002\u0007!\u0011\u000b\u0005\n\u0003\u000f\f\u0007\u0013!a\u0001\u0003\u0013D\u0011\"a6b!\u0003\u0005\r!!7\u0002+\r{gn];nKJ<%o\\;q\u000bb,7-\u001e;peB\u0019\u00111]2\u0014\u0007\r\fi\u0007\u0006\u0002\u0003z\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\u00121dU5na2,7i\u001c8tk6,'o\u0012:pkB,\u00050Z2vi>\u00148cA4\u0003(RA1qAB\u0005\u0007\u0017\u0019i\u0001E\u0002\u0002d\u001eDq!!.l\u0001\u0004\t9\fC\u0004\u0002F.\u0004\r!a.\t\u000f\tm4\u000e1\u0001\u0003~\u0005Q2m\u001c8tk6,'o\u0012:pkB,\u00050Z2vi>\u00148o\u0018\u0013fcR!\u0011qJB\n\u0011%\tIFCA\u0001\u0002\u0004\t\t'A\fd_:\u001cX/\\3s\u000fJ|W\u000f]#yK\u000e,Ho\u001c:tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0004\u001cA11QDB\u0010\u0007Gi!A!3\n\t\r\u0005\"\u0011\u001a\u0002\u0004'\u0016\f\b\u0003BB\u0013\u0007Wi!aa\n\u000b\u0007\r%r.\u0001\u0004tKJ4XM]\u0005\u0005\u0007[\u00199CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!B:fiV\u0003H\u0003BA(\u0007gAqa!\u000e\u000e\u0001\u0004\u00199$\u0001\u0005uKN$\u0018J\u001c4p!\u0011\u0019Ida\u0010\u000e\u0005\rm\"\u0002BB\u001f\u0003+\u000b1!\u00199j\u0013\u0011\u0019\tea\u000f\u0003\u0011Q+7\u000f^%oM>D3!DB#!\u0011\u0019Ida\u0012\n\t\r%31\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00079\u0019y\u0005\u0005\u0003\u0004:\rE\u0013\u0002BB*\u0007w\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002!\r|W.\\5ui\u0016$wJ\u001a4tKR\u001cHCBB-\u0007K\u001a9\u0007\u0005\u0005\u0004\u001e\rm#1QB0\u0013\u0011\u0019iF!3\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002R\r\u0005\u0014\u0002BB2\u0003[\u0011A\u0001T8oO\"AQp\u0004I\u0001\u0002\u0004\t9\fC\u0005\u0002\u0012=\u0001\n\u00111\u0001\u00028\u0006Q2m\\7nSR$X\rZ(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u000e\u0016\u0005\u0003o\u0013y#\u0001\u000ed_6l\u0017\u000e\u001e;fI>3gm]3ug\u0012\"WMZ1vYR$#'\u0001\u000ede\u0016\fG/\u001a(p\u0003V$xnQ8n[&$8i\u001c8tk6,'\u000f\u0006\u0003\u0004v\rm\u0004\u0003CA}\u0007o\n9,a.\n\t\re\u00141 \u0002\t\u0007>t7/^7fe\"9\u0011\u0011\u0003\nA\u0002\u0005]\u0016aF4fi\u000e{gn];nKJ<%o\\;q'\u0016\u0014h/[2f)\u0011\t)d!!\t\u000f\r\r5\u00031\u0001\u0004\u0006\u0006!\u0011M]4t!\u0019\t\tfa\"\u00028&!1\u0011RA\u0017\u0005\u0015\t%O]1z\u0003a\tG\rZ\"p]N,X.\u001a:He>,\b/\u0012=fGV$xN\u001d\u000b\u0013\u0007\u001f\u001b\tja%\u0004\u0016\u000e]5\u0011TBN\u0007;\u001by\nE\u0002\u0002f]CqAa8\u0015\u0001\u0004\u0011y\n\u0003\u0005~)A\u0005\t\u0019AA\\\u0011%\t\t\u0002\u0006I\u0001\u0002\u0004\t9\fC\u0005\u0003NQ\u0001\n\u00111\u0001\u00028\"I!q\n\u000b\u0011\u0002\u0003\u0007!\u0011\u000b\u0005\n\u0003\u000f$\u0002\u0013!a\u0001\u0003\u0013D\u0011\"a6\u0015!\u0003\u0005\r!!7\t\u0013\t-C\u0003%AA\u0002\u0005]\u0016AI1eI\u000e{gn];nKJ<%o\\;q\u000bb,7-\u001e;pe\u0012\"WMZ1vYR$#'\u0001\u0012bI\u0012\u001cuN\\:v[\u0016\u0014xI]8va\u0016CXmY;u_J$C-\u001a4bk2$HeM\u0001#C\u0012$7i\u001c8tk6,'o\u0012:pkB,\u00050Z2vi>\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002E\u0005$GmQ8ogVlWM]$s_V\u0004X\t_3dkR|'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019YK\u000b\u0003\u0003R\t=\u0012AI1eI\u000e{gn];nKJ<%o\\;q\u000bb,7-\u001e;pe\u0012\"WMZ1vYR$c'\u0001\u0012bI\u0012\u001cuN\\:v[\u0016\u0014xI]8va\u0016CXmY;u_J$C-\u001a4bk2$HeN\u0001#C\u0012$7i\u001c8tk6,'o\u0012:pkB,\u00050Z2vi>\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0002-\u0005$GmU5na2,wI]8va\u0016CXmY;u_J$baa.\u0004:\u000em\u0006cAA3O\"I!1\u0010\u000f\u0011\u0002\u0003\u0007!Q\u0010\u0005\n\u0003#a\u0002\u0013!a\u0001\u0003o\u000b\u0001%\u00193e'&l\u0007\u000f\\3He>,\b/\u0012=fGV$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\u0019\u0016\u0005\u0005{\u0012y#\u0001\u0011bI\u0012\u001c\u0016.\u001c9mK\u001e\u0013x.\u001e9Fq\u0016\u001cW\u000f^8sI\u0011,g-Y;mi\u0012\u0012\u0014aC1eI\u0016CXmY;u_J$B!a\u0019\u0004J\"9!1V\u0010A\u0002\u0005\r\u0004")
public class ConsumerGroupCommandTest
extends KafkaServerTestHarness {
    private final String topic;
    private final String group;
    private List<ConsumerGroupCommand.ConsumerGroupService> consumerGroupService = Nil$.MODULE$;
    private List<AbstractConsumerGroupExecutor> consumerGroupExecutors = Nil$.MODULE$;

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    public String topic() {
        return this.topic;
    }

    public String group() {
        return this.group;
    }

    private List<ConsumerGroupCommand.ConsumerGroupService> consumerGroupService() {
        return this.consumerGroupService;
    }

    private void consumerGroupService_$eq(List<ConsumerGroupCommand.ConsumerGroupService> x$1) {
        this.consumerGroupService = x$1;
    }

    private List<AbstractConsumerGroupExecutor> consumerGroupExecutors() {
        return this.consumerGroupExecutors;
    }

    private void consumerGroupExecutors_$eq(List<AbstractConsumerGroupExecutor> x$1) {
        this.consumerGroupExecutors = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        if (this.isNewGroupCoordinatorEnabled()) {
            configs.foreach((Function1 & Serializable)x$1 -> x$1.setProperty(KafkaConfig$.MODULE$.NewGroupCoordinatorEnableProp(), "true"));
        }
        return (Seq)configs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumerGroupService().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.consumerGroupExecutors().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public Map<TopicPartition, Object> committedOffsets(String topic, String group) {
        Map map;
        try (Consumer<String, String> consumer = this.createNoAutoCommitConsumer(group);){
            scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor(topic)).asScala().toSet().map((Function1 & Serializable)partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
            map = (Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava())).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommandTest.$anonfun$committedOffsets$2(x$4)))).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
                }
                throw new MatchError(null);
            });
        }
        return map;
    }

    public String committedOffsets$default$1() {
        return this.topic();
    }

    public String committedOffsets$default$2() {
        return this.group();
    }

    public Consumer<String, String> createNoAutoCommitConsumer(String group) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        props.put("group.id", group);
        props.put("enable.auto.commit", "false");
        return new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }

    public ConsumerGroupCommand.ConsumerGroupService getConsumerGroupService(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        ConsumerGroupCommand.ConsumerGroupService service = new ConsumerGroupCommand.ConsumerGroupService(opts, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retries"), (Object)Integer.toString(Integer.MAX_VALUE))})));
        this.consumerGroupService_$eq((List<ConsumerGroupCommand.ConsumerGroupService>)this.consumerGroupService().$colon$colon((Object)service));
        return service;
    }

    public ConsumerGroupExecutor addConsumerGroupExecutor(int numConsumers, String topic, String group, String strategy, Option<String> remoteAssignor, Option<Properties> customPropsOpt, boolean syncCommit, String groupProtocol) {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.bootstrapServers(this.bootstrapServers$default$1()), numConsumers, group, groupProtocol, topic, strategy, remoteAssignor, customPropsOpt, syncCommit);
        this.addExecutor(executor);
        return executor;
    }

    public String addConsumerGroupExecutor$default$2() {
        return this.topic();
    }

    public String addConsumerGroupExecutor$default$3() {
        return this.group();
    }

    public String addConsumerGroupExecutor$default$4() {
        return RangeAssignor.class.getName();
    }

    public Option<String> addConsumerGroupExecutor$default$5() {
        return None$.MODULE$;
    }

    public Option<Properties> addConsumerGroupExecutor$default$6() {
        return None$.MODULE$;
    }

    public boolean addConsumerGroupExecutor$default$7() {
        return false;
    }

    public String addConsumerGroupExecutor$default$8() {
        return GroupProtocol.CLASSIC.toString();
    }

    public SimpleConsumerGroupExecutor addSimpleGroupExecutor(Iterable<TopicPartition> partitions, String group) {
        SimpleConsumerGroupExecutor executor = new SimpleConsumerGroupExecutor(this.bootstrapServers(this.bootstrapServers$default$1()), group, partitions);
        this.addExecutor(executor);
        return executor;
    }

    public Iterable<TopicPartition> addSimpleGroupExecutor$default$1() {
        return new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)Nil$.MODULE$);
    }

    public String addSimpleGroupExecutor$default$2() {
        return this.group();
    }

    private AbstractConsumerGroupExecutor addExecutor(AbstractConsumerGroupExecutor executor) {
        this.consumerGroupExecutors_$eq((List<AbstractConsumerGroupExecutor>)this.consumerGroupExecutors().$colon$colon((Object)executor));
        return executor;
    }

    public static final /* synthetic */ boolean $anonfun$committedOffsets$2(Tuple2 x$4) {
        return x$4._2() != null;
    }

    public ConsumerGroupCommandTest() {
        this.topic = "foo";
        this.group = "test.group";
    }

    public static class AbstractConsumerGroupExecutor {
        private final ExecutorService executor;
        private final ArrayBuffer<AbstractConsumerRunnable> consumers;

        private ExecutorService executor() {
            return this.executor;
        }

        private ArrayBuffer<AbstractConsumerRunnable> consumers() {
            return this.consumers;
        }

        public void submit(AbstractConsumerRunnable consumerThread) {
            this.consumers().$plus$eq((Object)consumerThread);
            this.executor().submit(consumerThread);
        }

        public void shutdown() {
            this.consumers().foreach((Function1 & Serializable)x$6 -> {
                x$6.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdown();
            this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }

        public AbstractConsumerGroupExecutor(int numThreads) {
            this.executor = Executors.newFixedThreadPool(numThreads);
            this.consumers = new ArrayBuffer();
        }
    }

    public static abstract class AbstractConsumerRunnable
    implements Runnable {
        private final String broker;
        private final String groupId;
        private final boolean syncCommit;
        private final Properties props;
        private final KafkaConsumer<Nothing$, Nothing$> consumer;

        public Properties props() {
            return this.props;
        }

        public KafkaConsumer<Nothing$, Nothing$> consumer() {
            return this.consumer;
        }

        public void configure(Properties props) {
            props.put("bootstrap.servers", this.broker);
            props.put("group.id", this.groupId);
            props.put("key.deserializer", StringDeserializer.class.getName());
            props.put("value.deserializer", StringDeserializer.class.getName());
        }

        public abstract void subscribe();

        @Override
        public void run() {
            try {
                try {
                    this.subscribe();
                    while (true) {
                        this.consumer().poll(Duration.ofMillis(Long.MAX_VALUE));
                        if (!this.syncCommit) continue;
                        this.consumer().commitSync();
                    }
                }
                catch (WakeupException wakeupException) {
                }
            }
            finally {
                this.consumer().close();
            }
        }

        public void shutdown() {
            this.consumer().wakeup();
        }

        public AbstractConsumerRunnable(String broker, String groupId, Option<Properties> customPropsOpt, boolean syncCommit) {
            this.broker = broker;
            this.groupId = groupId;
            this.syncCommit = syncCommit;
            this.props = new Properties();
            this.configure(this.props());
            customPropsOpt.foreach((Function1 & Serializable)x$5 -> (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(this.props()).asScala().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(x$5).asScala()));
            this.consumer = new KafkaConsumer(this.props());
        }
    }

    public static class ConsumerGroupExecutor
    extends AbstractConsumerGroupExecutor {
        private final String broker;
        private final String groupId;
        private final String groupProtocol;
        private final String topic;
        private final String strategy;
        private final Option<String> remoteAssignor;
        private final Option<Properties> customPropsOpt;
        private final boolean syncCommit;

        public ConsumerGroupExecutor(String broker, int numConsumers, String groupId, String groupProtocol, String topic, String strategy, Option<String> remoteAssignor, Option<Properties> customPropsOpt, boolean syncCommit) {
            this.broker = broker;
            this.groupId = groupId;
            this.groupProtocol = groupProtocol;
            this.topic = topic;
            this.strategy = strategy;
            this.remoteAssignor = remoteAssignor;
            this.customPropsOpt = customPropsOpt;
            this.syncCommit = syncCommit;
            super(numConsumers);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numConsumers).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> this.submit(new ConsumerRunnable($this.broker, $this.groupId, $this.groupProtocol, $this.topic, $this.strategy, $this.remoteAssignor, $this.customPropsOpt, $this.syncCommit)));
        }
    }

    public static class ConsumerRunnable
    extends AbstractConsumerRunnable {
        private final String groupProtocol;
        private final String topic;
        private final String strategy;
        private final Option<String> remoteAssignor;

        @Override
        public void configure(Properties props) {
            super.configure(props);
            props.put("group.protocol", this.groupProtocol);
            String string = this.groupProtocol.toUpperCase();
            String string2 = GroupProtocol.CONSUMER.toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.remoteAssignor.foreach((Function1 & Serializable)assignor -> props.put("group.remote.assignor", assignor));
                return;
            }
            props.put("partition.assignment.strategy", this.strategy);
        }

        @Override
        public void subscribe() {
            this.consumer().subscribe(Collections.singleton(this.topic));
        }

        public ConsumerRunnable(String broker, String groupId, String groupProtocol, String topic, String strategy, Option<String> remoteAssignor, Option<Properties> customPropsOpt, boolean syncCommit) {
            this.groupProtocol = groupProtocol;
            this.topic = topic;
            this.strategy = strategy;
            this.remoteAssignor = remoteAssignor;
            super(broker, groupId, customPropsOpt, syncCommit);
        }
    }

    public static class SimpleConsumerGroupExecutor
    extends AbstractConsumerGroupExecutor {
        public SimpleConsumerGroupExecutor(String broker, String groupId, Iterable<TopicPartition> partitions) {
            super(1);
            this.submit(new SimpleConsumerRunnable(broker, groupId, partitions));
        }
    }

    public static class SimpleConsumerRunnable
    extends AbstractConsumerRunnable {
        private final Iterable<TopicPartition> partitions;

        @Override
        public void subscribe() {
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.partitions.toList()).asJava());
        }

        public SimpleConsumerRunnable(String broker, String groupId, Iterable<TopicPartition> partitions) {
            this.partitions = partitions;
            super(broker, groupId, (Option<Properties>)None$.MODULE$, false);
        }
    }
}

