/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.admin.LeadershipPriorityCommand$;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityResult;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DemotedBroker;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005)4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\t\u000f]\u0002\u0001\u0019!C\u0001q!1a\b\u0001Q!\n-BQa\u0010\u0001\u0005\u0002\u0001CQ\u0001\u0014\u0001\u0005\u0002\u0001CQ!\u0015\u0001\u0005\u0002\u0001CQa\u0015\u0001\u0005\u0002\u0001CQ!\u0016\u0001\u0005\u0002\u0001CQa\u0016\u0001\u0005\na\u0013Q\u0004T3bI\u0016\u00148\u000f[5q!JLwN]5us\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u001fA\tQ!\u00193nS:T\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u00039\tqBY8piN$(/\u00199TKJ4XM]\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB*ue&tw-\u0001\tc_>$8\u000f\u001e:baN+'O^3sA\u0005yA/Z:u\u0003\u0012l\u0017N\\\"mS\u0016tG/F\u0001,!\taS'D\u0001.\u0015\tyaF\u0003\u00020a\u000591\r\\5f]R\u001c(BA\t2\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\n\u0005Yj#AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0014i\u0016\u001cH/\u00113nS:\u001cE.[3oi~#S-\u001d\u000b\u0003sq\u0002\"!\u0006\u001e\n\u0005m2\"\u0001B+oSRDq!P\u0003\u0002\u0002\u0003\u00071&A\u0002yIE\n\u0001\u0003^3ti\u0006#W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0003eB#a\u0002\"\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015aA1qS*\u0011q\tS\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI5'A\u0003kk:LG/\u0003\u0002L\t\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002=Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3MK\u0006$WM]:iSB\u0004&/[8sSRL\bF\u0001\u0005O!\t\u0019u*\u0003\u0002Q\t\n!A+Z:u\u0003m!Xm\u001d;BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5us\"\u0012\u0011BT\u0001%i\u0016\u001cH\u000fR3tGJL'-\u001a'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif$\u0006N]8xg\"\u0012!BT\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0004&/[8sSRLH\u000b\u001b:poND#a\u0003(\u0002\u0015I,hnQ8n[\u0006tG\rF\u0002ZG\"\u0004\"AW1\u000f\u0005m{\u0006C\u0001/\u0017\u001b\u0005i&B\u00010\u0013\u0003\u0019a$o\\8u}%\u0011\u0001MF\u0001\u0007!J,G-\u001a4\n\u0005\u001d\u0012'B\u00011\u0017\u0011\u0015!G\u00021\u0001f\u0003\u0011\t'oZ:\u0011\u0007U1\u0017,\u0003\u0002h-\t)\u0011I\u001d:bs\")\u0011\u000e\u0004a\u0001W\u0005yQn\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f")
public class LeadershipPriorityCommandTest {
    private final String bootstrapServer;
    private ConfluentAdmin testAdminClient = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public ConfluentAdmin testAdminClient() {
        return this.testAdminClient;
    }

    public void testAdminClient_$eq(ConfluentAdmin x$1) {
        this.testAdminClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.testAdminClient_$eq((ConfluentAdmin)Mockito.mock(ConfluentAdmin.class));
    }

    @Test
    public void testDescribeLeadershipPriority() {
        DescribeLeadershipPriorityResult describeLeadershipPriorityResult = (DescribeLeadershipPriorityResult)Mockito.mock(DescribeLeadershipPriorityResult.class);
        .colon.colon demotedBrokers = new .colon.colon((Object)new DemotedBroker(1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"test", (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new DemotedBroker(2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"test", (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        KafkaFuture future = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)describeLeadershipPriorityResult.future()).thenReturn((Object)future);
        Mockito.when((Object)future.get()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)demotedBrokers).asJava());
        Mockito.when((Object)this.testAdminClient().describeLeadershipPriority((DescribeLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)describeLeadershipPriorityResult);
        Assertions.assertEquals((Object)"\tDemoted Broker: 1\tReasons: test\n\tDemoted Broker: 2\tReasons: test\n", (Object)this.runCommand(new String[]{"--describe"}, this.testAdminClient()));
    }

    @Test
    public void testAlterLeadershipPriority() {
        AlterLeadershipPrioritySpec alterLeadershipPrioritySpec = new AlterLeadershipPrioritySpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE, "test", false);
        AlterLeadershipPrioritySpec alterLeadershipPriorityWithForceSpec = new AlterLeadershipPrioritySpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE, "test", true);
        AlterLeadershipPriorityResult alterLeadershipPriorityResult = (AlterLeadershipPriorityResult)Mockito.mock(AlterLeadershipPriorityResult.class);
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        KafkaFuture controller = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Node mockControllerNode = (Node)Mockito.mock(Node.class);
        KafkaFuture alterFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        scala.collection.immutable.Map alterResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)alterFuture)}));
        Mockito.when((Object)this.testAdminClient().describeCluster()).thenReturn((Object)describeClusterResult);
        Mockito.when((Object)describeClusterResult.controller()).thenReturn((Object)controller);
        Mockito.when((Object)controller.get()).thenReturn((Object)mockControllerNode);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockControllerNode.id())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.testAdminClient().alterLeadershipPriority((AlterLeadershipPrioritySpec)ArgumentMatchers.eq((Object)alterLeadershipPrioritySpec), (AlterLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)alterLeadershipPriorityResult);
        Mockito.when((Object)alterLeadershipPriorityResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterResult).asJava());
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerLeadershipPriorityResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerLeadershipPriorityResult.LeadershipPriorityEnum)BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED));
        Assertions.assertEquals((Object)"\tBroker: 1\tBroker state: DEMOTED\n", (Object)this.runCommand(new String[]{"--demote", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        AlterLeadershipPrioritySpec promotionSpec = new AlterLeadershipPrioritySpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, "test", false);
        Mockito.when((Object)this.testAdminClient().alterLeadershipPriority((AlterLeadershipPrioritySpec)ArgumentMatchers.eq((Object)promotionSpec), (AlterLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)alterLeadershipPriorityResult);
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerLeadershipPriorityResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerLeadershipPriorityResult.LeadershipPriorityEnum)BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL));
        Assertions.assertEquals((Object)"\tBroker: 1\tBroker state: NORMAL\n", (Object)this.runCommand(new String[]{"--promote", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterLeadershipPriority((AlterLeadershipPrioritySpec)ArgumentMatchers.eq((Object)alterLeadershipPriorityWithForceSpec), (AlterLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)alterLeadershipPriorityResult);
        Mockito.when((Object)alterLeadershipPriorityResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)alterResult).asJava());
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerLeadershipPriorityResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerLeadershipPriorityResult.LeadershipPriorityEnum)BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED));
        Assertions.assertEquals((Object)"\tBroker: 1\tBroker state: DEMOTED\n", (Object)this.runCommand(new String[]{"--demote", "--broker-ids", "1", "--reason", "test", "--force"}, this.testAdminClient()));
        Mockito.when((Object)alterFuture.get()).thenReturn((Object)AdminClientTestUtils.brokerLeadershipPriorityResult((Integer)Predef$.MODULE$.int2Integer(1), (BrokerLeadershipPriorityResult.LeadershipPriorityEnum)BrokerLeadershipPriorityResult.LeadershipPriorityEnum.UNKNOWN));
        Assertions.assertEquals((Object)"\tBroker: 1\tBroker state: UNKNOWN\n", (Object)this.runCommand(new String[]{"--promote", "--broker-ids", "1", "--reason", "test"}, this.testAdminClient()));
        Mockito.when((Object)this.testAdminClient().alterLeadershipPriority((AlterLeadershipPrioritySpec)ArgumentMatchers.eq((Object)alterLeadershipPrioritySpec), (AlterLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)alterLeadershipPriorityResult);
    }

    @Test
    public void testDescribeLeadershipPriorityThrows() {
        new .colon.colon((Object)new String[]{""}, (List)new .colon.colon((Object)new String[]{"--describe", "--demote"}, (List)new .colon.colon((Object)new String[]{"--describe", "--promote"}, (List)new .colon.colon((Object)new String[]{"--describe", "--reason", "xyz"}, (List)new .colon.colon((Object)new String[]{"--describe", "--broker-ids", "xyz"}, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeadershipPriorityCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96)));
        DescribeLeadershipPriorityResult describeLeadershipPriorityResult = (DescribeLeadershipPriorityResult)Mockito.mock(DescribeLeadershipPriorityResult.class);
        KafkaFuture future = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)future.get()).thenThrow(new Throwable[]{new ExecutionException((Throwable)new InvalidRequestException("invalid test"))});
        Mockito.when((Object)describeLeadershipPriorityResult.future()).thenReturn((Object)future);
        Mockito.when((Object)this.testAdminClient().describeLeadershipPriority((DescribeLeadershipPriorityOptions)ArgumentMatchers.any())).thenReturn((Object)describeLeadershipPriorityResult);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand(new String[]{"--describe"}, this.testAdminClient()), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("LeadershipPriorityCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    @Test
    public void testAlterPriorityThrows() {
        new .colon.colon((Object)new String[]{"--demote", "--broker-ids", "1"}, (List)new .colon.colon((Object)new String[]{"--demote", "--reason", "1"}, (List)new .colon.colon((Object)new String[]{"--promote", "--reason", "1"}, (List)new .colon.colon((Object)new String[]{"--promote", "--demote"}, (List)new .colon.colon((Object)new String[]{"--force", "--broker-ids", "1", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--force"}, (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeadershipPriorityCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119)));
        new .colon.colon((Object)new String[]{"--demote", "--broker-ids", "1a", "--reason", "valid"}, (List)new .colon.colon((Object)new String[]{"--promote", "--broker-ids", "1a", "--reason", "valid"}, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)illegalArg -> Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.runCommand((String[])illegalArg, this.testAdminClient()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("LeadershipPriorityCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126)));
    }

    private String runCommand(String[] args, ConfluentAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> LeadershipPriorityCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    public LeadershipPriorityCommandTest() {
        this.bootstrapServer = "localhost:9092";
    }
}

