/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import joptsimple.OptionException;
import kafka.admin.MirrorCommand$;
import kafka.admin.MirrorCommandOptions;
import kafka.admin.MirrorCommandTest$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rue\u0001B\u001f?\u0005\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0015\u0005\u0006)\u0002!I!\u0016\u0005\n\u0003?\u0003!\u0019!C\u0005\u0003CC\u0001\"!1\u0001A\u0003%\u00111\u0015\u0005\n\u0003\u0007\u0004!\u0019!C\u0005\u0003\u000bD\u0001\"a;\u0001A\u0003%\u0011q\u0019\u0005\b\u0003[\u0004A\u0011BAx\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0005\u0003A\u0011Ba\b\u0001#\u0003%IA!\t\t\u0013\t]\u0002!%A\u0005\n\te\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005/\u0002A\u0011\u0001B \u0011\u001d\t)\u0007\u0001C\u0005\u00057B\u0011B! \u0001#\u0003%IA!\u000f\t\u0013\t}\u0004!%A\u0005\n\te\u0002\"\u0003BA\u0001E\u0005I\u0011\u0002BB\u0011\u001d\u00119\t\u0001C\u0001\u0005\u007fAqAa#\u0001\t\u0003\u0011y\u0004C\u0004\u0003\u0010\u0002!\tAa\u0010\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!Q\u0015\u0001\u0005\n\t\u001d\u0006\"\u0003B^\u0001E\u0005I\u0011\u0002B\u0011\u0011%\u0011i\fAI\u0001\n\u0013\u0011I\u0004C\u0004\u0003@\u0002!\tAa\u0010\t\u000f\t\r\u0007\u0001\"\u0001\u0003@!9\u0011\u0011\u0007\u0001\u0005\n\t\u001d\u0007\"\u0003Bk\u0001E\u0005I\u0011\u0002B\u0011\u0011%\u00119\u000eAI\u0001\n\u0013\u0011I\u0004C\u0004\u0003Z\u0002!\tAa\u0010\t\u000f\tu\u0007\u0001\"\u0001\u0003@!9!\u0011\u001d\u0001\u0005\u0002\t}\u0002b\u0002Bs\u0001\u0011%!q\u001d\u0005\n\u0005k\u0004\u0011\u0013!C\u0005\u0005CA\u0011Ba>\u0001#\u0003%IA!\u000f\t\u000f\te\b\u0001\"\u0001\u0003@!9!Q \u0001\u0005\n\t}\b\"CB\r\u0001E\u0005I\u0011BB\u000e\u0011\u001d\u0019y\u0002\u0001C\u0001\u0005\u007fAqaa\t\u0001\t\u0003\u0011y\u0004C\u0004\u0004(\u0001!\tAa\u0010\t\u000f\r-\u0002\u0001\"\u0001\u0003@!91q\u0006\u0001\u0005\u0002\t}\u0002bBB\u001a\u0001\u0011\u0005!q\b\u0005\b\u0007o\u0001A\u0011\u0001B \u0011\u001d\u0019Y\u0004\u0001C\u0005\u0007{A\u0011ba\u001e\u0001#\u0003%Ia!\u001f\t\u0013\ru\u0004!%A\u0005\n\r}\u0004\"CBB\u0001E\u0005I\u0011BBC\u0011%\u0019I\tAI\u0001\n\u0013\u0019y\bC\u0004\u0004\f\u0002!Ia!$\u0007\t)\u0004\u0001a\u001b\u0005\tqV\u0012\t\u0011)A\u0005s\")!*\u000eC\u0001\u007f\"9\u00111A\u001b\u0005B\u0005\u0015\u0001bBA\u0019k\u0011\u0005\u00131\u0007\u0005\b\u0003'*D\u0011IA+\u0011\u001d\t)'\u000eC!\u0003OBq!!!6\t\u0003\n\u0019IA\tNSJ\u0014xN]\"p[6\fg\u000e\u001a+fgRT!a\u0010!\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0005\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001'\u0011\u00055\u0003Q\"\u0001 \u0002\u0017\r,(O]3oiRKW.Z\u000b\u0002!B\u0011Q)U\u0005\u0003%\u001a\u00131!\u00138u\u00031\u0019WO\u001d:f]R$\u0016.\\3!\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0004-\u00064\u0007CA,_\u001d\tAF\f\u0005\u0002Z\r6\t!L\u0003\u0002\\\u0005\u00061AH]8pizJ!!\u0018$\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\u001aCQA\u0019\u0003A\u0002\r\fA!\u0019:hgB\u0019Q\t\u001a,\n\u0005\u00154%!B!se\u0006L\b\"B4\u0005\u0001\u0004A\u0017aD7pG.\fE-\\5o\u00072LWM\u001c;\u0011\u0005%,T\"\u0001\u0001\u0003\u001fQ+7\u000f^!e[&t7\t\\5f]R\u001c\"!\u000e7\u0011\u000554X\"\u00018\u000b\u0005}z'B\u00019r\u0003\u001d\u0019G.[3oiNT!!\u0011:\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0005\u0003o:\u0014q\"T8dW\u0006#W.\u001b8DY&,g\u000e^\u0001\u0005]>$W\r\u0005\u0002{{6\t1P\u0003\u0002}c\u000611m\\7n_:L!A`>\u0003\t9{G-\u001a\u000b\u0004Q\u0006\u0005\u0001\"\u0002=8\u0001\u0004I\u0018!\u0004:fa2L7-Y*uCR,8\u000f\u0006\u0004\u0002\b\u00055\u0011q\u0005\t\u0004[\u0006%\u0011bAA\u0006]\n\u0019\"+\u001a9mS\u000e\f7\u000b^1ukN\u0014Vm];mi\"9\u0011q\u0002\u001dA\u0002\u0005E\u0011A\u00039beRLG/[8ogB1\u00111CA\u000f\u0003Ci!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0005kRLGN\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"!\u0006\u0003\u0007M+G\u000fE\u0002{\u0003GI1!!\n|\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\u000b9\u0001\u0004\tY#A\u0004paRLwN\\:\u0011\u00075\fi#C\u0002\u000209\u0014ACU3qY&\u001c\u0017m\u0015;biV\u001cx\n\u001d;j_:\u001c\u0018\u0001D1mi\u0016\u0014X*\u001b:s_J\u001cHCBA\u001b\u0003w\tY\u0005E\u0002n\u0003oI1!!\u000fo\u0005I\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\t\u000f\u0005u\u0012\b1\u0001\u0002@\u0005\u0019q\u000e]:\u0011\u000f\u0005M\u0011\u0011\t,\u0002F%!\u00111IA\u000b\u0005\ri\u0015\r\u001d\t\u0004[\u0006\u001d\u0013bAA%]\ni\u0011\t\u001c;fe6K'O]8s\u001fBDq!!\u000b:\u0001\u0004\ti\u0005E\u0002n\u0003\u001fJ1!!\u0015o\u0005M\tE\u000e^3s\u001b&\u0014(o\u001c:t\u001fB$\u0018n\u001c8t\u0003-a\u0017n\u001d;NSJ\u0014xN]:\u0015\t\u0005]\u0013Q\f\t\u0004[\u0006e\u0013bAA.]\n\tB*[:u\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\t\u000f\u0005%\"\b1\u0001\u0002`A\u0019Q.!\u0019\n\u0007\u0005\rdN\u0001\nMSN$X*\u001b:s_J\u001cx\n\u001d;j_:\u001c\u0018a\u00043fg\u000e\u0014\u0018NY3NSJ\u0014xN]:\u0015\r\u0005%\u0014qNA=!\ri\u00171N\u0005\u0004\u0003[r'!\u0006#fg\u000e\u0014\u0018NY3NSJ\u0014xN]:SKN,H\u000e\u001e\u0005\b\u0003cZ\u0004\u0019AA:\u0003\u0019!x\u000e]5dgB)\u00111CA;-&!\u0011qOA\u000b\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0005\b\u0003SY\u0004\u0019AA>!\ri\u0017QP\u0005\u0004\u0003\u007fr'A\u0006#fg\u000e\u0014\u0018NY3NSJ\u0014xN]:PaRLwN\\:\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\r\u0005\u0015\u00151RAL!\ri\u0017qQ\u0005\u0004\u0003\u0013s'AE\"sK\u0006$X\rV8qS\u000e\u001c(+Z:vYRDq!!$=\u0001\u0004\ty)A\u0005oK^$v\u000e]5dgB1\u00111CA;\u0003#\u00032!\\AJ\u0013\r\t)J\u001c\u0002\t\u001d\u0016<Hk\u001c9jG\"9\u0011\u0011\u0006\u001fA\u0002\u0005e\u0005cA7\u0002\u001c&\u0019\u0011Q\u00148\u0003'\r\u0013X-\u0019;f)>\u0004\u0018nY:PaRLwN\\:\u0002\u001f\u0005dG\u000eR3tGJL\u0007\u000f^5p]N,\"!a)\u0011\u0011\u0005\u0015\u0016qVAY\u0003wk!!a*\u000b\t\u0005%\u00161V\u0001\nS6lW\u000f^1cY\u0016T1!!,G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\n9\u000b\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,!\u0007\u0002\t1\fgnZ\u0005\u0004?\u0006U\u0006cA7\u0002>&\u0019\u0011q\u00188\u0003-5K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0001#\u00197m\t\u0016\u001c8M]5qi&|gn\u001d\u0011\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t+\t\t9\r\u0005\u0005\u0002&\u0006=\u0016\u0011WAe!\u0019\t)+a3\u0002P&!\u0011QZAT\u0005\u0011a\u0015n\u001d;\u0011\r\u0005E\u00171\\Ap\u001d\u0011\t\u0019.a6\u000f\u0007e\u000b).C\u0001H\u0013\r\tINR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti-!8\u000b\u0007\u0005eg\t\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)o_\u0001\be\u0016\u0004H.[2b\u0013\u0011\tI/a9\u0003\u001bI+\u0007\u000f\\5dCN#\u0018\r^;t\u00039\tG\u000e\u001c)beRLG/[8og\u0002\n1\u0004\\3bI\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK\u0016C8-\u001a9uS>tG\u0003BAy\u0003{\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0004\u0003o\\\u0018AB3se>\u00148/\u0003\u0003\u0002|\u0006U(a\u0007'fC\u0012,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016,\u0005pY3qi&|g\u000eC\u0004\u0002\u0000&\u0001\r!!\t\u0002\u0013A\f'\u000f^5uS>tG\u0003\u0003B\u0002\u0005\u0013\u0011YA!\u0006\u0011\u0007\u0015\u0013)!C\u0002\u0003\b\u0019\u0013A!\u00168ji\")!M\u0003a\u0001G\"I!Q\u0002\u0006\u0011\u0002\u0003\u0007!qB\u0001\tY&t7NT1nKB!QI!\u0005W\u0013\r\u0011\u0019B\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\t]!\u0002%AA\u0002\te\u0011AD5oG2,H-Z*u_B\u0004X\r\u001a\t\u0004\u000b\nm\u0011b\u0001B\u000f\r\n9!i\\8mK\u0006t\u0017!\u00067jgRl\u0015N\u001d:peN$C-\u001a4bk2$HEM\u000b\u0003\u0005GQCAa\u0004\u0003&-\u0012!q\u0005\t\u0005\u0005S\u0011\u0019$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003%)hn\u00195fG.,GMC\u0002\u00032\u0019\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Da\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bmSN$X*\u001b:s_J\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm\"\u0006\u0002B\r\u0005K\tq\u0002^3ti2K7\u000f^'jeJ|'o\u001d\u000b\u0003\u0005\u0007A3!\u0004B\"!\u0011\u0011)Ea\u0015\u000e\u0005\t\u001d#\u0002\u0002B%\u0005\u0017\n1!\u00199j\u0015\u0011\u0011iEa\u0014\u0002\u000f),\b/\u001b;fe*\u0019!\u0011\u000b;\u0002\u000b),h.\u001b;\n\t\tU#q\t\u0002\u0005)\u0016\u001cH/A\nuKN$H)Z:de&\u0014W-T5se>\u00148\u000fK\u0002\u000f\u0005\u0007\"RB\u0016B/\u0005?\u0012IG!\u001c\u0003r\tU\u0004\"\u00022\u0010\u0001\u0004\u0019\u0007b\u0002B1\u001f\u0001\u0007!1M\u0001\u0016I\u0016\u001c8M]5cK6K'O]8sgR{\u0007/[2t!\u0015\t\tN!\u001aW\u0013\u0011\u00119'!8\u0003\u0007M+\u0017\u000fC\u0004\u0003l=\u0001\rAa\u0019\u00023\u0005$W.\u001b8DY&,g\u000e\u001e*fiV\u0014h.\u001a3U_BL7m\u001d\u0005\n\u0005_z\u0001\u0013!a\u0001\u00053\t!\"\u001a=qK\u000e$H*[:u\u0011%\u0011\u0019h\u0004I\u0001\u0002\u0004\u0011I\"A\u0006qK:$\u0017N\\4Ti>\u0004\b\"\u0003B<\u001fA\u0005\t\u0019\u0001B=\u0003q\tG-\\5o\u00072LWM\u001c;GS2$XM]3e\u001fV$Hk\u001c9jGN\u0004Ba\u0016B>-&\u0019\u0011q\u00041\u00023\u0011,7o\u0019:jE\u0016l\u0015N\u001d:peN$C-\u001a4bk2$H\u0005N\u0001\u001aI\u0016\u001c8M]5cK6K'O]8sg\u0012\"WMZ1vYR$S'A\reKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:tI\u0011,g-Y;mi\u00122TC\u0001BCU\u0011\u0011IH!\n\u0002mQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3NSJ\u0014xN]:XSRDGK]1og&$\u0018n\u001c8FeJ|'o](viB,HOT8NSJ\u0014xN]:)\u0007M\u0011\u0019%A\u0017uKN$H)Z:de&\u0014W-T5se>\u00148oV5uQR\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cx*\u001e;qkRD3\u0001\u0006B\"\u0003q\"Xm\u001d;EKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:t/&$\b\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]:PkR\u0004X\u000f^'vYRL\u0007\u000f\\3NSJ\u0014xN]:)\u0007U\u0011\u0019%A\rmSN$8\u000b^1uKR\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cH\u0003\u0003B\u0002\u0005/\u0013IJ!)\t\u000b\t4\u0002\u0019A2\t\u000f\tme\u00031\u0001\u0003\u001e\u0006aA-Z:de&\u0004H/[8ogB1qKa(W\u0003wK1!a\u0011a\u0011\u0019\u0011\u0019K\u0006a\u0001-\u0006qQ\r\u001f9fGR,GmT;uaV$\u0018aC:u_Bl\u0015N\u001d:peN$BBa\u0001\u0003*\n-&q\u0016BZ\u0005oCQAY\fA\u0002\rDqA!,\u0018\u0001\u0004\u0011\u0019'\u0001\bfqB,7\r^3e)>\u0004\u0018nY:\t\u000f\tEv\u00031\u0001\u0003\u001a\u0005\tR\r\u001f9fGR\u001c\u0016P\\2ie>t\u0017N_3\t\u0013\tUv\u0003%AA\u0002\t=\u0011AD3ya\u0016\u001cG\u000fT5oW:\u000bW.\u001a\u0005\n\u0005s;\u0002\u0013!a\u0001\u00053\t!#\u001a=qK\u000e$h+\u00197jI\u0006$Xm\u00148ms\u0006)2\u000f^8q\u001b&\u0014(o\u001c:tI\u0011,g-Y;mi\u0012\"\u0014!F:u_Bl\u0015N\u001d:peN$C-\u001a4bk2$H%N\u0001\u0013i\u0016\u001cH\u000f\u0015:p[>$X-T5se>\u00148\u000fK\u0002\u001b\u0005\u0007\n1\u0003^3ti\u001a\u000b\u0017\u000e\\8wKJl\u0015N\u001d:peND3a\u0007B\")1\u0011\u0019A!3\u0003L\n='\u0011\u001bBj\u0011\u0015\u0011G\u00041\u0001d\u0011\u001d\u0011i\r\ba\u0001\u0003\u000b\n!\"\u001a=qK\u000e$X\rZ(q\u0011\u001d\u0011i\u000b\ba\u0001\u0005GB\u0011B!.\u001d!\u0003\u0005\rAa\u0004\t\u0013\teF\u0004%AA\u0002\te\u0011AF1mi\u0016\u0014X*\u001b:s_J\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0002-\u0005dG/\u001a:NSJ\u0014xN]:%I\u00164\u0017-\u001e7uIU\n\u0001\u0003^3tiB\u000bWo]3NSJ\u0014xN]:)\u0007}\u0011\u0019%A\tuKN$(+\u001a9bSJl\u0015N\u001d:peND3\u0001\tB\"\u0003M!Xm\u001d;S_2d'-Y2l\u001b&\u0014(o\u001c:tQ\r\t#1I\u0001\u0016e\u00164XM]:f\u0003:$7k^1q\u001b&\u0014(o\u001c:t)1\u0011\u0019A!;\u0003l\n=(\u0011\u001fBz\u0011\u0015\u0011'\u00051\u0001d\u0011\u001d\u0011iO\ta\u0001\u00053\t\u0011c\u001d5pk2$7\u000b^1si6K'O]8s\u0011\u001d\u0011iK\ta\u0001\u0005GB\u0011B!.#!\u0003\u0005\rAa\u0004\t\u0013\te&\u0005%AA\u0002\te\u0011a\b:fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'o\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005y\"/\u001a<feN,\u0017I\u001c3To\u0006\u0004X*\u001b:s_J\u001cH\u0005Z3gCVdG\u000fJ\u001b\u00023Q,7\u000f\u001e*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'o\u001d\u0015\u0004K\t\r\u0013\u0001D2sK\u0006$X-T5se>\u0014H\u0003\u0004B\u0002\u0007\u0003\u0019\u0019aa\u0002\u0004\n\r5\u0001\"\u00022'\u0001\u0004\u0019\u0007bBB\u0003M\u0001\u0007!qB\u0001\fKb\u0004Xm\u0019;U_BL7\rC\u0004\u00036\u001a\u0002\rAa\u0004\t\u000f\r-a\u00051\u0001\u0003\u0010\u0005\tR\r\u001f9fGRl\u0015N\u001d:peR{\u0007/[2\t\u0013\r=a\u0005%AA\u0002\rE\u0011aF3ya\u0016\u001cGOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s!\u0015)%\u0011CB\n!\u0011\t\u0019l!\u0006\n\t\r]\u0011Q\u0017\u0002\b\u0013:$XmZ3s\u0003Y\u0019'/Z1uK6K'O]8sI\u0011,g-Y;mi\u0012*TCAB\u000fU\u0011\u0019\tB!\n\u0002!Q,7\u000f^\"sK\u0006$X-T5se>\u0014\bf\u0001\u0015\u0003D\u0005yA/Z:u\u0005\u0006$7i\\7nC:$7\u000fK\u0002*\u0005\u0007\nq\u0003^3ti6K7o]5oOJ+\u0017/^5sK\u0012\f%oZ:)\u0007)\u0012\u0019%A\buKN$\u0018J\u001c<bY&$\u0017I]4tQ\rY#1I\u0001,i\u0016\u001cH/\u00138wC2LG-\u0011:hg\u001a{'\u000fT5tiN#\u0018\r^3Ue\u0006t7/\u001b;j_:,%O]8sg\"\u001aAFa\u0011\u0002=Q,7\u000f^'jeJ|'\u000fU1si&$\u0018n\u001c8J]\u001a|'/\\1uS>t\u0007fA\u0017\u0003D\u0005QB/Z:u\u001b&\u0014(o\u001c:U_BL7-\u00138g_Jl\u0017\r^5p]\"\u001aaFa\u0011\u0002\u001d9,w\u000fR3tGJL\u0007\u000f^5p]R!\u00121XB \u0007\u0003\u001a)e!\u0013\u0004N\r]3QLB4\u0007gBaA!\u00040\u0001\u00041\u0006BBB\"_\u0001\u0007a+A\u0006t_V\u00148-\u001a+pa&\u001c\u0007BBB$_\u0001\u0007\u0001+A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0007\u0017z\u0003\u0019\u0001,\u0002\u0011M$\u0018\r^3TiJDqaa\u00140\u0001\u0004\u0019\t&A\u0006ti\u0006$X\rV5nK6\u001b\bcA#\u0004T%\u00191Q\u000b$\u0003\t1{gn\u001a\u0005\n\u00073z\u0003\u0013!a\u0001\u00077\nAc\u001d;paB,G\rT8h\u000b:$wJ\u001a4tKR\u001c\bCBAi\u00037\u001c\t\u0006C\u0005\u0004`=\u0002\n\u00111\u0001\u0004b\u00059Ao\u001c9jG&#\u0007c\u0001>\u0004d%\u00191QM>\u0003\tU+\u0018\u000e\u001a\u0005\n\u0007Sz\u0003\u0013!a\u0001\u0007W\nQc\u001d;bi\u0016$&/\u00198tSRLwN\\#se>\u00148\u000f\u0005\u0004\u0002R\n\u00154Q\u000e\t\u0004[\u000e=\u0014bAB9]\n!2\t\\;ti\u0016\u0014H*\u001b8l)\u0006\u001c8.\u0012:s_JD\u0011b!\u001e0!\u0003\u0005\ra!\u0019\u0002\r1Lgn[%e\u0003aqWm\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$C-\u001a4bk2$HEN\u000b\u0003\u0007wRCaa\u0017\u0003&\u0005Ab.Z<EKN\u001c'/\u001b9uS>tG\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r\u0005%\u0006BB1\u0005K\t\u0001D\\3x\t\u0016\u001c8M]5qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00139+\t\u00199I\u000b\u0003\u0004l\t\u0015\u0012\u0001\u00078fo\u0012+7o\u0019:jaRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%s\u0005aa.Z<QCJ$\u0018\u000e^5p]RQ\u0011qZBH\u0007#\u001b)j!'\t\r\r-C\u00071\u0001W\u0011\u001d\u0019\u0019\n\u000ea\u0001\u0007#\nA\u0002\\8h\u000b:$wJ\u001a4tKRDqaa&5\u0001\u0004\u0019\t&\u0001\u000emCN$X*\u001b:s_J4U\r^2i)&lW\rR3mi\u0006l5\u000fC\u0004\u0004\u001cR\u0002\ra!\u0015\u0002E1\f7\u000f^'jeJ|'OR3uG\"\u001cv.\u001e:dK\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0001")
public final class MirrorCommandTest {
    private final int currentTime;
    private final scala.collection.immutable.Map<String, MirrorTopicDescription> allDescriptions;
    private final scala.collection.immutable.Map<String, List<List<ReplicaStatus>>> allPartitions;

    private int currentTime() {
        return this.currentTime;
    }

    private String runCommand(String[] args, TestAdminClient mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> MirrorCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", "localhost:9092"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private scala.collection.immutable.Map<String, MirrorTopicDescription> allDescriptions() {
        return this.allDescriptions;
    }

    private scala.collection.immutable.Map<String, List<List<ReplicaStatus>>> allPartitions() {
        return this.allPartitions;
    }

    private LeaderNotAvailableException leaderNotAvailableException(TopicPartition partition) {
        return new LeaderNotAvailableException(new java.lang.StringBuilder(32).append("Leader for partition ").append(partition).append(" not found.").toString());
    }

    private void listMirrors(String[] args, Option<String> linkName, boolean includeStopped) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Set topics = ((MapOps)this.allDescriptions().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$listMirrors$1(linkName, includeStopped, x0$1)))).keys().toSet();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)topics).asJavaCollection());
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, linkName, includeStopped, result){
            private final BooleanRef issuedCommand$1;
            private final Option linkName$1;
            private final boolean includeStopped$1;
            private final ListMirrorsResult result$1;

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedCommand$1.elem = true;
                Assertions.assertEquals((Object)this.linkName$1, (Object)Option$.MODULE$.apply(options.linkName().orElse(null)));
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.includeStopped$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.includeStopped()));
                return this.result$1;
            }
            {
                this.issuedCommand$1 = issuedCommand$1;
                this.linkName$1 = linkName$1;
                this.includeStopped$1 = includeStopped$1;
                this.result$1 = result$1;
                super(node$1);
            }
        };
        String output = this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--list"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
        Mockito.reset((Object[])new ListMirrorsResult[]{result});
        this.allDescriptions().foreach((Function1 & Serializable)x0$2 -> {
            MirrorCommandTest.$anonfun$listMirrors$3(topics, output, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private Option<String> listMirrors$default$2() {
        return None$.MODULE$;
    }

    private boolean listMirrors$default$3() {
        return false;
    }

    @Test
    public void testListMirrors() {
        this.listMirrors((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<String>)None$.MODULE$, false);
        this.listMirrors(new String[]{"--link", "link-1"}, (Option<String>)new Some((Object)"link-1"), false);
        String[] x$1 = new String[]{"--include-stopped"};
        None$ x$3 = None$.MODULE$;
        this.listMirrors(x$1, (Option<String>)x$3, true);
        this.listMirrors(new String[]{"--link", "link-2", "--include-stopped"}, (Option<String>)new Some((Object)"link-2"), true);
    }

    @Test
    public void testDescribeMirrors() {
        this.describeMirrors(new String[]{"--topics", "topic-3"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-1,topic-4"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--pending-stopped-only"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-6", (List)new .colon.colon((Object)"topic-16", (List)new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-6", (List)new .colon.colon((Object)"topic-16", (List)Nil$.MODULE$)), true, true, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-7"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-7", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-7", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3", "topic-4", "topic-5", "topic-6", "topic-7", "topic-11", "topic-12", "topic-13", "topic-14", "topic-15", "topic-16", "topic-17", "topic-18"}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3", "topic-4", "topic-5", "topic-6", "topic-7", "topic-11", "topic-12", "topic-13", "topic-14", "topic-15", "topic-16", "topic-17", "topic-18"}))), true, false, this.describeMirrors$default$6());
        String[] x$1 = new String[]{"--topics", "topic-1,topic-18", "--links", "link-1"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-18", (List)Nil$.MODULE$));
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        scala.collection.immutable.Set x$4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-18"}));
        boolean x$5 = false;
        boolean x$6 = false;
        this.describeMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, (scala.collection.immutable.Seq<String>)x$3, x$5, x$6, (scala.collection.immutable.Set<String>)x$4);
    }

    private String describeMirrors(String[] args, scala.collection.immutable.Seq<String> describeMirrorsTopics, scala.collection.immutable.Seq<String> adminClientReturnedTopics, boolean expectList, boolean pendingStop, scala.collection.immutable.Set<String> adminClientFilteredOutTopics) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedReplicaStatusCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Map ret = (scala.collection.immutable.Map)((IterableOnceOps)describeMirrorsTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)this.allDescriptions().get(t)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            String t = (String)x0$1._1();
            Option d = (Option)x0$1._2();
            KafkaFutureImpl future = new KafkaFutureImpl();
            boolean bl = false;
            if (d instanceof Some) {
                bl = true;
                MirrorTopicDescription desc = (MirrorTopicDescription)((Some)d).value();
                if (!adminClientFilteredOutTopics.contains((Object)t)) {
                    future.complete((Object)new MirrorTopicDescription(desc.linkName(), desc.clusterLinkId(), desc.sourceTopic(), desc.numPartitions(), desc.state(), desc.stateTimeMs(), desc.stoppedLogEndOffsets(), desc.sourceTopicId(), desc.mirrorTopicError()));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
                }
            }
            if (bl) {
                future.complete(null);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
            }
            if (!None$.MODULE$.equals(d)) throw new MatchError((Object)d);
            future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
        });
        DescribeMirrorsResult result = (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ret).asJava());
        scala.collection.immutable.Map partitions = ((IterableOnceOps)((IterableOps)adminClientReturnedTopics.flatMap((Function1 & Serializable)topic -> this.allDescriptions().get(topic).map((Function1 & Serializable)desc -> package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommandTest.$anonfun$describeMirrors$5(this, topic, BoxesRunTime.unboxToInt((Object)part))).toList()))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ReplicaStatusResult replicaStatusResult = (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        Mockito.when((Object)replicaStatusResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitions).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        if (expectList) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$describeMirrors$6(x$2)))).keys()).asJavaCollection());
            Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        }
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedReplicaStatusCommand, replicaStatusResult, issuedListCommand, listResult, issuedCommand, pendingStop, adminClientReturnedTopics, adminClientFilteredOutTopics, result){
            private final BooleanRef issuedReplicaStatusCommand$1;
            private final ReplicaStatusResult replicaStatusResult$1;
            private final BooleanRef issuedListCommand$1;
            private final ListMirrorsResult listResult$1;
            private final BooleanRef issuedCommand$2;
            private final boolean pendingStop$1;
            private final scala.collection.immutable.Seq adminClientReturnedTopics$1;
            private final scala.collection.immutable.Set adminClientFilteredOutTopics$1;
            private final DescribeMirrorsResult result$2;

            public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
                this.issuedReplicaStatusCommand$1.elem = true;
                return this.replicaStatusResult$1;
            }

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$1.elem = true;
                return this.listResult$1;
            }

            public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
                this.issuedCommand$2.elem = true;
                if (!this.pendingStop$1) {
                    Assertions.assertEquals((Object)((scala.collection.immutable.Set)this.adminClientReturnedTopics$1.toSet().$plus$plus((IterableOnce)this.adminClientFilteredOutTopics$1)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(topics).asScala().toSet());
                }
                return this.result$2;
            }
            {
                this.issuedReplicaStatusCommand$1 = issuedReplicaStatusCommand$1;
                this.replicaStatusResult$1 = replicaStatusResult$1;
                this.issuedListCommand$1 = issuedListCommand$1;
                this.listResult$1 = listResult$1;
                this.issuedCommand$2 = issuedCommand$2;
                this.pendingStop$1 = pendingStop$1;
                this.adminClientReturnedTopics$1 = adminClientReturnedTopics$1;
                this.adminClientFilteredOutTopics$1 = adminClientFilteredOutTopics$1;
                this.result$2 = result$2;
                super(node$2);
            }
        };
        String output = this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--describe"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertTrue((boolean)issuedReplicaStatusCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectList), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        ((DescribeMirrorsResult)Mockito.verify((Object)result)).result();
        ((ReplicaStatusResult)Mockito.verify((Object)replicaStatusResult)).result();
        Mockito.reset((Object[])new DescribeMirrorsResult[]{result});
        Mockito.reset((Object[])new ReplicaStatusResult[]{replicaStatusResult});
        if (expectList) {
            ((ListMirrorsResult)Mockito.verify((Object)listResult)).result();
            Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
        }
        this.allDescriptions().foreach((Function1 & Serializable)x0$2 -> {
            MirrorCommandTest.$anonfun$describeMirrors$7(this, adminClientReturnedTopics, args, output, x0$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)output.contains(new StringBuilder().append('\n').append('\n').toString()));
        adminClientReturnedTopics.foreach((Function1 & Serializable)t -> {
            MirrorCommandTest.$anonfun$describeMirrors$10(this, output, t);
            return BoxedUnit.UNIT;
        });
        return output;
    }

    private boolean describeMirrors$default$4() {
        return false;
    }

    private boolean describeMirrors$default$5() {
        return false;
    }

    private scala.collection.immutable.Set<String> describeMirrors$default$6() {
        return Predef$.MODULE$.Set().empty();
    }

    @Test
    public void testDescribeMirrorsWithTransitionErrorsOutputNoMirrors() {
        this.listStateTransitionErrors(new String[]{"--topics", "topic-1"}, (scala.collection.immutable.Map<String, MirrorTopicDescription>)Predef$.MODULE$.Map().empty(), "No mirrors found.\n");
    }

    @Test
    public void testDescribeMirrorsWithTransitionErrorsOutput() {
        Uuid x$6 = Uuid.fromString((String)"w9lEbgnFQQGarXVZalNSfA");
        Uuid x$7 = Uuid.fromString((String)"MOHk_R5hRIGCMpxgK4wwug");
        .colon.colon x$8 = new .colon.colon((Object)new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR, "Encountered retriable exception, will retry in 500"), (List)Nil$.MODULE$);
        List<Object> x$9 = this.newDescription$default$6();
        MirrorTopicDescription desc = this.newDescription("link-14", "topic-1", 2, "PENDING_STOPPED", 500000000L, x$9, x$7, (scala.collection.immutable.Seq<ClusterLinkTaskError>)x$8, x$6);
        scala.collection.immutable.Map descriptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)desc)}));
        this.listStateTransitionErrors(new String[]{"--topics", "topic-1"}, (scala.collection.immutable.Map<String, MirrorTopicDescription>)descriptions, "Topic: topic-1\tState: PENDING_STOPPED\nError Code: INTERNAL_ERROR\tError Message: \"Encountered retriable exception, will retry in 500\"\n\n");
    }

    @Test
    public void testDescribeMirrorsWithTransitionErrorsOutputMultipleMirrors() {
        Uuid x$6 = Uuid.fromString((String)"w9lEbgnFQQGarXVZalNSfA");
        Uuid x$7 = Uuid.fromString((String)"MOHk_R5hRIGCMpxgK4wwug");
        .colon.colon x$8 = new .colon.colon((Object)new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR, "Encountered retriable exception, will retry in 500"), (List)Nil$.MODULE$);
        List<Object> x$9 = this.newDescription$default$6();
        MirrorTopicDescription descOne = this.newDescription("link-14", "topic-1", 2, "PENDING_STOPPED", 500000000L, x$9, x$7, (scala.collection.immutable.Seq<ClusterLinkTaskError>)x$8, x$6);
        Uuid x$15 = Uuid.fromString((String)"w9lEbgnFQQGarXVZalNSfA");
        Uuid x$16 = Uuid.fromString((String)"MOHk_R5hRIGCMpxgK4wwug");
        scala.collection.immutable.Seq x$17 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        List<Object> x$18 = this.newDescription$default$6();
        MirrorTopicDescription descTwo = this.newDescription("link-14", "topic-2", 2, "PENDING_STOPPED", 500000000L, x$18, x$16, (scala.collection.immutable.Seq<ClusterLinkTaskError>)x$17, x$15);
        scala.collection.immutable.Map descriptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)descOne), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)descTwo)}));
        this.listStateTransitionErrors(new String[]{"--topics", "topic-1", "topic-2"}, (scala.collection.immutable.Map<String, MirrorTopicDescription>)descriptions, "Topic: topic-1\tState: PENDING_STOPPED\nError Code: INTERNAL_ERROR\tError Message: \"Encountered retriable exception, will retry in 500\"\n\nTopic topic-2 has no state transition errors\n\n");
    }

    private void listStateTransitionErrors(String[] args, scala.collection.immutable.Map<String, MirrorTopicDescription> descriptions, String expectedOutput) {
        scala.collection.immutable.Map ret = (scala.collection.immutable.Map)descriptions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                MirrorTopicDescription d = (MirrorTopicDescription)x0$1._2();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)d);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
            }
            throw new MatchError(null);
        });
        DescribeMirrorsResult result = (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ret).asJava());
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, result){
            private final DescribeMirrorsResult result$3;

            public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
                return this.result$3;
            }
            {
                this.result$3 = result$3;
                super(node$3);
            }
        };
        String output = this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--list-state-transition-errors"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertEquals((Object)expectedOutput, (Object)output);
    }

    private void stopMirrors(String[] args, scala.collection.immutable.Seq<String> expectedTopics, boolean expectSynchronize, Option<String> expectLinkName, boolean expectValidateOnly) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedDescribeCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedReplicaStatusCommand = BooleanRef.create((boolean)false);
        DescribeMirrorsResult describeResult = (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        if (expectSynchronize && !expectValidateOnly) {
            scala.collection.immutable.Map ret = (scala.collection.immutable.Map)((IterableOnceOps)expectedTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)this.allDescriptions().get(t)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String t = (String)x0$1._1();
                    Option d = (Option)x0$1._2();
                    KafkaFutureImpl future = new KafkaFutureImpl();
                    if (d instanceof Some) {
                        MirrorTopicDescription desc = (MirrorTopicDescription)((Some)d).value();
                        future.complete((Object)desc);
                    } else if (None$.MODULE$.equals(d)) {
                        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
                    } else {
                        throw new MatchError((Object)d);
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
                }
                throw new MatchError(null);
            });
            Mockito.when((Object)describeResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ret).asJava());
        }
        ReplicaStatusResult replicaStatusResult = (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        if (expectSynchronize && !expectValidateOnly) {
            scala.collection.immutable.Map partitions = ((IterableOnceOps)((IterableOps)expectedTopics.flatMap((Function1 & Serializable)topic -> this.allDescriptions().get(topic).map((Function1 & Serializable)desc -> package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommandTest.$anonfun$stopMirrors$5(this, topic, BoxesRunTime.unboxToInt((Object)part))).toList()))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Mockito.when((Object)replicaStatusResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitions).asJava());
        }
        scala.collection.immutable.Map results = ((IterableOnceOps)expectedTopics.map((Function1 & Serializable)topic -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            Option option = this.allDescriptions().get(topic);
            if (option instanceof Some) {
                future.complete(null);
            } else if (None$.MODULE$.equals(option)) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        expectLinkName.foreach((Function1 & Serializable)linkName -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$stopMirrors$8(linkName, x$4)))).keys()).asJavaCollection());
            return Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        });
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedReplicaStatusCommand, replicaStatusResult, issuedListCommand, listResult, issuedCommand, expectedTopics, expectValidateOnly, expectSynchronize, result, issuedDescribeCommand, describeResult){
            private final BooleanRef issuedReplicaStatusCommand$2;
            private final ReplicaStatusResult replicaStatusResult$2;
            private final BooleanRef issuedListCommand$2;
            private final ListMirrorsResult listResult$2;
            private final BooleanRef issuedCommand$3;
            private final scala.collection.immutable.Seq expectedTopics$1;
            private final boolean expectValidateOnly$1;
            private final boolean expectSynchronize$1;
            private final AlterMirrorsResult result$4;
            private final BooleanRef issuedDescribeCommand$1;
            private final DescribeMirrorsResult describeResult$1;

            public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
                this.issuedReplicaStatusCommand$2.elem = true;
                return this.replicaStatusResult$2;
            }

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$2.elem = true;
                return this.listResult$2;
            }

            public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
                this.issuedCommand$3.elem = true;
                Assertions.assertEquals((int)this.expectedTopics$1.size(), (int)ops.size());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                CollectionConverters$.MODULE$.MapHasAsScala(ops).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$4.$anonfun$alterMirrors$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return this.result$4;
            }

            public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
                this.issuedDescribeCommand$1.elem = true;
                Assertions.assertEquals((Object)this.expectedTopics$1.toSet(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(topics).asScala().toSet());
                return this.describeResult$1;
            }

            public static final /* synthetic */ void $anonfun$alterMirrors$1($anon$4 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                    Assertions.assertTrue((boolean)$this.expectedTopics$1.contains((Object)topic));
                    Assertions.assertEquals((Object)($this.expectSynchronize$1 ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER), (Object)op);
                    return;
                }
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Unexpected op type");
            }
            {
                this.issuedReplicaStatusCommand$2 = issuedReplicaStatusCommand$2;
                this.replicaStatusResult$2 = replicaStatusResult$2;
                this.issuedListCommand$2 = issuedListCommand$2;
                this.listResult$2 = listResult$2;
                this.issuedCommand$3 = issuedCommand$3;
                this.expectedTopics$1 = expectedTopics$1;
                this.expectValidateOnly$1 = expectValidateOnly$1;
                this.expectSynchronize$1 = expectSynchronize$1;
                this.result$4 = result$4;
                this.issuedDescribeCommand$1 = issuedDescribeCommand$1;
                this.describeResult$1 = describeResult$1;
                super(node$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterMirrors$1$adapted(kafka.admin.MirrorCommandTest$$anon$4 scala.Tuple2 )}, serializedLambda);
            }
        };
        String command = expectSynchronize ? "--promote" : "--failover";
        this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{command}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectLinkName.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        if (!expectValidateOnly) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectSynchronize), (Object)BoxesRunTime.boxToBoolean((boolean)issuedDescribeCommand.elem));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectSynchronize), (Object)BoxesRunTime.boxToBoolean((boolean)issuedReplicaStatusCommand.elem));
        }
        ((AlterMirrorsResult)Mockito.verify((Object)result)).values();
        ((ListMirrorsResult)Mockito.verify((Object)listResult, (VerificationMode)Mockito.times((int)Option$.MODULE$.option2Iterable(expectLinkName).size()))).result();
        Mockito.reset((Object[])new AlterMirrorsResult[]{result});
        Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
        if (expectSynchronize && !expectValidateOnly) {
            ((DescribeMirrorsResult)Mockito.verify((Object)describeResult)).result();
            ((ReplicaStatusResult)Mockito.verify((Object)replicaStatusResult)).result();
            Mockito.reset((Object[])new DescribeMirrorsResult[]{describeResult});
            Mockito.reset((Object[])new ReplicaStatusResult[]{replicaStatusResult});
            return;
        }
    }

    private Option<String> stopMirrors$default$4() {
        return None$.MODULE$;
    }

    private boolean stopMirrors$default$5() {
        return false;
    }

    @Test
    public void testPromoteMirrors() {
        this.stopMirrors(new String[]{"--topics", "topic-13"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-13", (List)Nil$.MODULE$), true, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-11,topic-14"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-11", (List)new .colon.colon((Object)"topic-14", (List)Nil$.MODULE$)), true, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), true, (Option<String>)None$.MODULE$, false);
        String[] x$1 = new String[]{"--link", "link-12"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-13", (List)new .colon.colon((Object)"topic-14", (List)new .colon.colon((Object)"topic-15", (List)new .colon.colon((Object)"topic-16", (List)Nil$.MODULE$))));
        Some x$3 = new Some((Object)"link-12");
        boolean x$5 = false;
        this.stopMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, true, (Option<String>)x$3, x$5);
        String[] x$6 = new String[]{"--topics", "topic-11", "--validate-only"};
        .colon.colon x$7 = new .colon.colon((Object)"topic-11", (List)Nil$.MODULE$);
        None$ x$10 = None$.MODULE$;
        this.stopMirrors(x$6, (scala.collection.immutable.Seq<String>)x$7, true, (Option<String>)x$10, true);
    }

    @Test
    public void testFailoverMirrors() {
        this.stopMirrors(new String[]{"--topics", "topic-3"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), false, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-1,topic-4"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), false, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), false, (Option<String>)None$.MODULE$, false);
        String[] x$1 = new String[]{"--link", "link-2"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$))));
        Some x$3 = new Some((Object)"link-2");
        boolean x$5 = false;
        this.stopMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, false, (Option<String>)x$3, x$5);
        String[] x$6 = new String[]{"--topics", "topic-1", "--validate-only"};
        .colon.colon x$7 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$10 = None$.MODULE$;
        this.stopMirrors(x$6, (scala.collection.immutable.Seq<String>)x$7, false, (Option<String>)x$10, true);
    }

    private void alterMirrors(String[] args, AlterMirrorOp expectedOp, scala.collection.immutable.Seq<String> expectedTopics, Option<String> expectLinkName, boolean expectValidateOnly) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Map results = ((IterableOnceOps)expectedTopics.map((Function1 & Serializable)topic -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            Option option = this.allDescriptions().get(topic);
            if (option instanceof Some) {
                future.complete(null);
            } else if (None$.MODULE$.equals(option)) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        expectLinkName.foreach((Function1 & Serializable)linkName -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$alterMirrors$4(linkName, x$5)))).keys()).asJavaCollection());
            return Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        });
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedListCommand, listResult, issuedCommand, expectedTopics, expectValidateOnly, expectedOp, result){
            private final BooleanRef issuedListCommand$3;
            private final ListMirrorsResult listResult$3;
            private final BooleanRef issuedCommand$4;
            private final scala.collection.immutable.Seq expectedTopics$2;
            private final boolean expectValidateOnly$2;
            private final AlterMirrorOp expectedOp$1;
            private final AlterMirrorsResult result$5;

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$3.elem = true;
                return this.listResult$3;
            }

            public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
                this.issuedCommand$4.elem = true;
                Assertions.assertEquals((int)this.expectedTopics$2.size(), (int)ops.size());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$2), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                CollectionConverters$.MODULE$.MapHasAsScala(ops).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$5.$anonfun$alterMirrors$5(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return this.result$5;
            }

            public static final /* synthetic */ void $anonfun$alterMirrors$5($anon$5 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                    Assertions.assertTrue((boolean)$this.expectedTopics$2.contains((Object)topic));
                    Assertions.assertEquals((Object)$this.expectedOp$1, (Object)op);
                    return;
                }
                throw new MatchError(null);
            }
            {
                this.issuedListCommand$3 = issuedListCommand$3;
                this.listResult$3 = listResult$3;
                this.issuedCommand$4 = issuedCommand$4;
                this.expectedTopics$2 = expectedTopics$2;
                this.expectValidateOnly$2 = expectValidateOnly$2;
                this.expectedOp$1 = expectedOp$1;
                this.result$5 = result$5;
                super(node$5);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterMirrors$5$adapted(kafka.admin.MirrorCommandTest$$anon$5 scala.Tuple2 )}, serializedLambda);
            }
        };
        this.runCommand(args, mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectLinkName.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        ((AlterMirrorsResult)Mockito.verify((Object)result)).values();
        ((ListMirrorsResult)Mockito.verify((Object)listResult, (VerificationMode)Mockito.times((int)Option$.MODULE$.option2Iterable(expectLinkName).size()))).result();
        Mockito.reset((Object[])new AlterMirrorsResult[]{result});
        Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
    }

    private Option<String> alterMirrors$default$4() {
        return None$.MODULE$;
    }

    private boolean alterMirrors$default$5() {
        return false;
    }

    @Test
    public void testPauseMirrors() {
        this.alterMirrors(new String[]{"--pause", "--topics", "topic-3"}, AlterMirrorOp.PAUSE, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--pause", "--topics", "topic-1,topic-4"}, AlterMirrorOp.PAUSE, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--unpause", "--topics", "topic-nonexistent"}, AlterMirrorOp.RESUME, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--unpause", "--link", "link-2"}, AlterMirrorOp.RESUME, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$)))), (Option<String>)new Some((Object)"link-2"), false);
        String[] x$1 = new String[]{"--pause", "--topics", "topic-1", "--validate-only"};
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        this.alterMirrors(x$1, AlterMirrorOp.PAUSE, (scala.collection.immutable.Seq<String>)x$3, (Option<String>)x$5, true);
    }

    @Test
    public void testRepairMirrors() {
        this.alterMirrors(new String[]{"--repair", "--topics", "topic-3"}, AlterMirrorOp.REPAIR, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--repair", "--topics", "topic-1,topic-4"}, AlterMirrorOp.REPAIR, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--repair", "--topics", "topic-nonexistent"}, AlterMirrorOp.REPAIR, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--repair", "--link", "link-2"}, AlterMirrorOp.REPAIR, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$)))), (Option<String>)new Some((Object)"link-2"), false);
        String[] x$1 = new String[]{"--repair", "--topics", "topic-1", "--validate-only"};
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        this.alterMirrors(x$1, AlterMirrorOp.REPAIR, (scala.collection.immutable.Seq<String>)x$3, (Option<String>)x$5, true);
    }

    @Test
    public void testRollbackMirrors() {
        this.alterMirrors(new String[]{"--rollback", "--topics", "topic-3"}, AlterMirrorOp.ROLLBACK, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--rollback", "--topics", "topic-1,topic-4"}, AlterMirrorOp.ROLLBACK, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--rollback", "--topics", "topic-nonexistent"}, AlterMirrorOp.ROLLBACK, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.alterMirrors(new String[]{"--rollback", "--link", "link-2"}, AlterMirrorOp.ROLLBACK, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$)))), (Option<String>)new Some((Object)"link-2"), false);
        String[] x$1 = new String[]{"--rollback", "--topics", "topic-1", "--validate-only"};
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        this.alterMirrors(x$1, AlterMirrorOp.ROLLBACK, (scala.collection.immutable.Seq<String>)x$3, (Option<String>)x$5, true);
    }

    private void reverseAndSwapMirrors(String[] args, boolean shouldStartMirror, scala.collection.immutable.Seq<String> expectedTopics, Option<String> expectLinkName, boolean expectValidateOnly) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Map results = ((IterableOnceOps)expectedTopics.map((Function1 & Serializable)topic -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            Option option = this.allDescriptions().get(topic);
            if (option instanceof Some) {
                future.complete(null);
            } else if (None$.MODULE$.equals(option)) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        expectLinkName.foreach((Function1 & Serializable)linkName -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$reverseAndSwapMirrors$3(linkName, x$6)))).keys()).asJavaCollection());
            return Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        });
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedListCommand, listResult, issuedCommand, expectedTopics, expectValidateOnly, shouldStartMirror, result){
            private final BooleanRef issuedListCommand$4;
            private final ListMirrorsResult listResult$4;
            private final BooleanRef issuedCommand$5;
            private final scala.collection.immutable.Seq expectedTopics$3;
            private final boolean expectValidateOnly$3;
            private final boolean shouldStartMirror$1;
            private final AlterMirrorsResult result$6;

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$4.elem = true;
                return this.listResult$4;
            }

            public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
                this.issuedCommand$5.elem = true;
                Assertions.assertEquals((int)this.expectedTopics$3.size(), (int)ops.size());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$3), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                CollectionConverters$.MODULE$.MapHasAsScala(ops).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$6.$anonfun$alterMirrors$6(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return this.result$6;
            }

            public static final /* synthetic */ void $anonfun$alterMirrors$6($anon$6 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                    Assertions.assertTrue((boolean)$this.expectedTopics$3.contains((Object)topic));
                    Assertions.assertEquals((Object)($this.shouldStartMirror$1 ? AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR : AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR), (Object)op);
                    return;
                }
                throw new MatchError(null);
            }
            {
                this.issuedListCommand$4 = issuedListCommand$4;
                this.listResult$4 = listResult$4;
                this.issuedCommand$5 = issuedCommand$5;
                this.expectedTopics$3 = expectedTopics$3;
                this.expectValidateOnly$3 = expectValidateOnly$3;
                this.shouldStartMirror$1 = shouldStartMirror$1;
                this.result$6 = result$6;
                super(node$6);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterMirrors$6$adapted(kafka.admin.MirrorCommandTest$$anon$6 scala.Tuple2 )}, serializedLambda);
            }
        };
        this.runCommand(args, mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectLinkName.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        ((AlterMirrorsResult)Mockito.verify((Object)result)).values();
        ((ListMirrorsResult)Mockito.verify((Object)listResult, (VerificationMode)Mockito.times((int)Option$.MODULE$.option2Iterable(expectLinkName).size()))).result();
        Mockito.reset((Object[])new AlterMirrorsResult[]{result});
        Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
    }

    private Option<String> reverseAndSwapMirrors$default$4() {
        return None$.MODULE$;
    }

    private boolean reverseAndSwapMirrors$default$5() {
        return false;
    }

    @Test
    public void testReverseAndSwapMirrors() {
        this.reverseAndSwapMirrors(new String[]{"--reverse-and-start", "--topics", "topic-3"}, true, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.reverseAndSwapMirrors(new String[]{"--reverse-and-start", "--topics", "topic-1,topic-4"}, true, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (Option<String>)None$.MODULE$, false);
        this.reverseAndSwapMirrors(new String[]{"--reverse-and-pause", "--topics", "topic-nonexistent"}, false, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.reverseAndSwapMirrors(new String[]{"--reverse-and-pause", "--link", "link-2"}, false, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$)))), (Option<String>)new Some((Object)"link-2"), false);
        String[] x$1 = new String[]{"--reverse-and-start", "--topics", "topic-1", "--validate-only"};
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        this.reverseAndSwapMirrors(x$1, true, (scala.collection.immutable.Seq<String>)x$3, (Option<String>)x$5, true);
    }

    private void createMirror(String[] args, Option<String> expectTopic, Option<String> expectLinkName, Option<String> expectMirrorTopic, Option<Integer> expectReplicationFactor) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.allDescriptions().contains(expectTopic.get())) {
            future.completeExceptionally((Throwable)new TopicExistsException(String.format("Topic %s exists already.", expectTopic)));
        } else {
            future.complete(null);
        }
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(expectTopic.get()), (Object)future)}));
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{(KafkaFuture)results.values().head()}));
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, expectTopic, expectMirrorTopic, expectLinkName, expectReplicationFactor, result){
            private final BooleanRef issuedCommand$6;
            private final Option expectTopic$1;
            private final Option expectMirrorTopic$1;
            private final Option expectLinkName$1;
            private final Option expectReplicationFactor$1;
            private final CreateTopicsResult result$7;

            public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
                this.issuedCommand$6.elem = true;
                NewTopic newTopic = newTopics.stream().findFirst().get();
                Assertions.assertEquals((Object)this.expectTopic$1.get(), (Object)newTopic.name());
                Assertions.assertEquals((Object)this.expectMirrorTopic$1.get(), (Object)((NewMirrorTopic)newTopic.mirror().get()).sourceTopic());
                Assertions.assertEquals((Object)this.expectLinkName$1.get(), (Object)((NewMirrorTopic)newTopic.mirror().get()).linkName());
                Assertions.assertEquals((Integer)((Integer)this.expectReplicationFactor$1.get()), (int)newTopic.replicationFactor());
                return this.result$7;
            }
            {
                this.issuedCommand$6 = issuedCommand$6;
                this.expectTopic$1 = expectTopic$1;
                this.expectMirrorTopic$1 = expectMirrorTopic$1;
                this.expectLinkName$1 = expectLinkName$1;
                this.expectReplicationFactor$1 = expectReplicationFactor$1;
                this.result$7 = result$7;
                super(node$7);
            }
        };
        this.runCommand(args, mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        ((CreateTopicsResult)Mockito.verify((Object)result)).all();
        Mockito.reset((Object[])new CreateTopicsResult[]{result});
    }

    private Option<Integer> createMirror$default$5() {
        return new Some((Object)Predef$.MODULE$.int2Integer(-1));
    }

    @Test
    public void testCreateMirror() {
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--replication-factor", "2"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(2)));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.createMirror(new String[]{"--create", "--source-topic", "topic-1", "--mirror-topic", "topic-1", "--link", "link-1"}, (Option<String>)new Some((Object)"topic-1"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic-1"), this.createMirror$default$5()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-latest"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime", "2023-01-02T03:04:05.678"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--topic"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--link"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", ""}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "test+link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "", "--link", "test-link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "invalid+topic", "--link", "test-link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--partitions", "1"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--replica-assignment", "3:0,5:1"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--list"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--promote"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--failover"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--unpause"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--repair"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--rollback"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--link", "link-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
    }

    @Test
    public void testInvalidArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--topics", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--validate-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--link", "link-name"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--validate-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        IllegalArgumentException describeWithLinkException = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--link", "link-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        Assertions.assertEquals((Object)"Option --link cannot be used to filter with --describe. Please use --links instead.", (Object)describeWithLinkException.getMessage());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--promote", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--failover", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--unpause", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--repair", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--rollback", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause", "--unpause", "--topics", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> MirrorCommand$.MODULE$.parseTopicConfigsToBeAdded(new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--config", "confluent.placement.constraints={\"version\":1,\"replicas\":[{\"count\":3,\"constraints\":{\"rack\":\"us-west\"}}],\"observers\":[{\"count\":2,\"constraints\":{\"rack\":\"us-east\"}}]}"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-latest", "--from-datetime", "2023-01-02T03:04:05.678"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest", "--from-datetime", "2023-01-02T03:04:05.678"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest", "--from-latest"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime", "01-02"}).fromTimestamp(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
    }

    @Test
    public void testInvalidArgsForListStateTransitionErrors() {
        new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors"}).verifyArgs();
        new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--topics", "topic-1"}).verifyArgs();
        new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--links", "link-1"}).verifyArgs();
        new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--states", "PENDING_STOPPED"}).verifyArgs();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--link", "link-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--validate-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--pending-stopped-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--source-topic", "topic-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--mirror-topic", "topic-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--replication-factor", "1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--from-earliest"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--from-latest"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--from-datetime", "01-02"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list-state-transition-errors", "--config", "foo=bar"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
    }

    @Test
    public void testMirrorPartitionInformation() {
        int n = 100;
        int logEndOffset = 100;
        String info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n)), Optional.of("pull"), OptionalLong.of(-1L)), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: 100\tLag: 0\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
        n = -1;
        info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n)), Optional.of("pull"), OptionalLong.of(-1L)), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: -1\tLag: -1\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
        n = 150;
        info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n)), Optional.of("pull"), OptionalLong.of(-1L)), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: 150\tLag: 50\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
    }

    @Test
    public void testMirrorTopicInformation() {
        this.allDescriptions().foreach((Function1 & Serializable)x0$1 -> {
            MirrorCommandTest.$anonfun$testMirrorTopicInformation$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private MirrorTopicDescription newDescription(String linkName, String sourceTopic, int numPartitions, String stateStr, long stateTimeMs, List<Object> stoppedLogEndOffsets, Uuid topicId, scala.collection.immutable.Seq<ClusterLinkTaskError> stateTransitionErrors, Uuid linkId) {
        MirrorTopicDescription.State state;
        MirrorTopicDescription.State state2 = state = Enum.valueOf(MirrorTopicDescription.State.class, stateStr);
        MirrorTopicDescription.State state3 = MirrorTopicDescription.State.FAILED;
        MirrorTopicError failureReason = !(state2 != null ? !state2.equals(state3) : state3 != null) ? MirrorTopicError.SOURCE_TOPIC_ID_CHANGED : null;
        return new MirrorTopicDescription(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedLogEndOffsets.map((Function1 & Serializable)x$7 -> MirrorCommandTest.$anonfun$newDescription$1(BoxesRunTime.unboxToLong((Object)x$7)))).asJava(), topicId, failureReason, CollectionConverters$.MODULE$.SeqHasAsJava(stateTransitionErrors).asJava());
    }

    private List<Object> newDescription$default$6() {
        return package$.MODULE$.List().empty();
    }

    private Uuid newDescription$default$7() {
        return Uuid.randomUuid();
    }

    private scala.collection.immutable.Seq<ClusterLinkTaskError> newDescription$default$8() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private Uuid newDescription$default$9() {
        return Uuid.randomUuid();
    }

    private List<ReplicaStatus> newPartition(String stateStr, long logEndOffset, long lastMirrorFetchTimeDeltaMs, long lastMirrorFetchSourceHighWatermark) {
        ReplicaStatus.MirrorInfo.State state = Enum.valueOf(ReplicaStatus.MirrorInfo.State.class, stateStr);
        Optional<ReplicaStatus.MirrorInfo> mirrorInfo = Optional.of(new ReplicaStatus.MirrorInfo(state, (long)this.currentTime() - lastMirrorFetchTimeDeltaMs, lastMirrorFetchSourceHighWatermark));
        return new .colon.colon((Object)new ReplicaStatus(0, true, false, true, true, true, 0L, logEndOffset, (long)this.currentTime(), (long)this.currentTime(), Optional.empty(), mirrorInfo, Optional.of("pull"), OptionalLong.of(-1L)), (List)new .colon.colon((Object)new ReplicaStatus(1, false, false, true, true, true, 0L, logEndOffset - 10L, (long)this.currentTime(), (long)(this.currentTime() - 1000), Optional.empty(), Optional.empty(), Optional.of("pull"), OptionalLong.of(-1L)), (List)new .colon.colon((Object)new ReplicaStatus(2, false, false, true, false, false, 0L, logEndOffset - 20L, (long)this.currentTime(), (long)(this.currentTime() - 1500), Optional.empty(), Optional.empty(), Optional.of("pull"), OptionalLong.of(-1L)), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$2(MirrorTopicDescription d$1, String x$1) {
        String string = x$1;
        String string2 = d$1.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$1(Option linkName$1, boolean includeStopped$1, Tuple2 x0$1) {
        block2: {
            block3: {
                block4: {
                    if (x0$1 == null) break block2;
                    MirrorTopicDescription d = (MirrorTopicDescription)x0$1._2();
                    if (!linkName$1.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$listMirrors$2(d, x$1)))) break block3;
                    if (includeStopped$1) break block4;
                    MirrorTopicDescription.State state = d.state();
                    MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
                    if (!(state == null ? state2 != null : !state.equals(state2))) break block3;
                }
                return true;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$listMirrors$3(scala.collection.immutable.Set topics$1, String output$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String t = (String)x0$2._1();
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topics$1.contains((Object)t)), (Object)BoxesRunTime.boxToBoolean((boolean)output$1.contains(t)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeMirrors$5(MirrorCommandTest $this, String topic$1, int part) {
        TopicPartition tp = new TopicPartition(topic$1, part);
        List rsList = (List)((LinearSeqOps)$this.allPartitions().apply((Object)topic$1)).apply(part);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (rsList != null) {
            future.complete((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rsList).asJava());
        } else {
            future.completeExceptionally((Throwable)$this.leaderNotAvailableException(tp));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)future);
    }

    public static final /* synthetic */ boolean $anonfun$describeMirrors$6(Tuple2 x$2) {
        return x$2._2() != null;
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$7(MirrorCommandTest $this, scala.collection.immutable.Seq adminClientReturnedTopics$1, String[] args$2, String output$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String t = (String)x0$2._1();
            MirrorTopicDescription d = (MirrorTopicDescription)x0$2._2();
            if (adminClientReturnedTopics$1.contains((Object)t)) {
                StringBuilder builder = new StringBuilder();
                MirrorCommand$.MODULE$.addMirrorTopicInformation(builder, t, d);
                builder.append('\n');
                ((List)((StrictOptimizedIterableOps)$this.allPartitions().apply((Object)t)).zipWithIndex()).foreach((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        List rsList = (List)x0$3._1();
                        int index = x0$3._2$mcI$sp();
                        if (rsList != null) {
                            ReplicaStatus leader = (ReplicaStatus)rsList.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isLeader())).head();
                            ReplicaStatus.MirrorInfo mirrorInfo = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args$2), (Object)"--pending-stopped-only")) {
                                ReplicaStatus.MirrorInfo.State state = mirrorInfo.state();
                                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                                    builder.append(MirrorCommand$.MODULE$.getMirrorPartitionInformation(mirrorInfo, leader, index, -1L));
                                    return builder.append('\n');
                                }
                                return BoxedUnit.UNIT;
                            }
                            long stopLogEndOffset = d.stoppedLogEndOffsets().size() <= index ? mirrorInfo.lastFetchSourceHighWatermark() : Predef$.MODULE$.Long2long((Long)d.stoppedLogEndOffsets().get(index));
                            builder.append(MirrorCommand$.MODULE$.getMirrorPartitionInformation(mirrorInfo, leader, index, stopLogEndOffset));
                            return builder.append('\n');
                        }
                        TopicPartition tp = new TopicPartition(t, index);
                        builder.append(MirrorCommand$.MODULE$.getMirrorPartitionError(index, (Throwable)$this.leaderNotAvailableException(tp)));
                        return builder.append('\n');
                    }
                    throw new MatchError(null);
                });
                Assertions.assertTrue((boolean)output$2.contains(builder.toString()), (String)new java.lang.StringBuilder(46).append("Unexpected output: '").append(output$2).append("', expected to contain '").append((CharSequence)builder).append("''").toString());
                return;
            }
            Assertions.assertFalse((boolean)output$2.contains(new java.lang.StringBuilder(8).append("Topic: ").append(t).append(" ").toString()), (String)new java.lang.StringBuilder(49).append("Unexpected output: '").append(output$2).append("', contains unexpected topic ").append(t).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$10(MirrorCommandTest $this, String output$2, String t) {
        if (!$this.allDescriptions().contains((Object)t)) {
            Assertions.assertTrue((boolean)output$2.contains(new java.lang.StringBuilder(15).append("Topic: ").append(t).append("\tError: ").toString()));
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$stopMirrors$5(MirrorCommandTest $this, String topic$2, int part) {
        TopicPartition tp = new TopicPartition(topic$2, part);
        List rsList = (List)((LinearSeqOps)$this.allPartitions().apply((Object)topic$2)).apply(part);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (rsList != null) {
            future.complete((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rsList).asJava());
        } else {
            future.completeExceptionally((Throwable)$this.leaderNotAvailableException(tp));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)future);
    }

    public static final /* synthetic */ boolean $anonfun$stopMirrors$8(String linkName$2, Tuple2 x$4) {
        String string = ((MirrorTopicDescription)x$4._2()).linkName();
        return !(string != null ? !string.equals(linkName$2) : linkName$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrors$4(String linkName$3, Tuple2 x$5) {
        String string = ((MirrorTopicDescription)x$5._2()).linkName();
        return !(string != null ? !string.equals(linkName$3) : linkName$3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$reverseAndSwapMirrors$3(String linkName$4, Tuple2 x$6) {
        String string = ((MirrorTopicDescription)x$6._2()).linkName();
        return !(string != null ? !string.equals(linkName$4) : linkName$4 != null);
    }

    private static final ReplicaStatus.MirrorInfo mirrorInfo$1(IntRef lastFetchHwm$1) {
        return new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)lastFetchHwm$1.elem);
    }

    private static final ReplicaStatus leaderInfo$1(int logEndOffset$1, IntRef lastFetchHwm$1) {
        return new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset$1, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)lastFetchHwm$1.elem)), Optional.of("pull"), OptionalLong.of(-1L));
    }

    public static final /* synthetic */ void $anonfun$testMirrorTopicInformation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            MirrorTopicDescription desc = (MirrorTopicDescription)x0$1._2();
            String info = MirrorCommand$.MODULE$.getMirrorTopicInformation(topic, desc);
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(7).append("Topic: ").append(topic).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(10).append("LinkName: ").append(desc.linkName()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(8).append("LinkId: ").append(desc.clusterLinkId()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(13).append("SourceTopic: ").append(desc.sourceTopic()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(7).append("State: ").append(desc.state()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(15).append("SourceTopicId: ").append(desc.sourceTopicId()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(11).append("StateTime: ").append(MirrorCommand$.MODULE$.timeToDate(desc.stateTimeMs())).toString()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Long $anonfun$newDescription$1(long x$7) {
        return BoxesRunTime.boxToLong((long)x$7);
    }

    public MirrorCommandTest() {
        this.currentTime = 500000000;
        Object[] objectArray = new Tuple2[15];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.newDescription("link-1", "topic-1", 2, "ACTIVE", 100000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.newDescription("link-1", "topic-2", 2, "FAILED", 200000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.newDescription("link-2", "topic-3", 1, "ACTIVE", 300000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)this.newDescription("link-2", "topic-4", 1, "FAILED", 400000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)this.newDescription("link-2", "topic-5", 2, "STOPPED", 500000000L, (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{150L, 160L}))), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)this.newDescription("link-2", "topic-6", 2, "PENDING_STOPPED", 500000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)this.newDescription("link-3", "topic-7", 5, "ACTIVE", 600000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-11"), (Object)this.newDescription("link-11", "topic-11", 2, "ACTIVE", 100000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-12"), (Object)this.newDescription("link-11", "topic-12", 2, "FAILED", 200000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-13"), (Object)this.newDescription("link-12", "topic-13", 1, "ACTIVE", 300000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-14"), (Object)this.newDescription("link-12", "topic-14", 1, "FAILED", 400000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-15"), (Object)this.newDescription("link-12", "topic-15", 2, "STOPPED", 500000000L, this.newDescription$default$6(), Uuid.randomUuid(), this.newDescription$default$8(), Uuid.randomUuid()));
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-16"), (Object)this.newDescription("link-12", "topic-16", 2, "PENDING_STOPPED", 500000000L, this.newDescription$default$6(), this.newDescription$default$7(), this.newDescription$default$8(), this.newDescription$default$9()));
        Uuid x$6 = Uuid.ZERO_UUID;
        List<Object> x$7 = this.newDescription$default$6();
        scala.collection.immutable.Seq<ClusterLinkTaskError> x$8 = this.newDescription$default$8();
        Uuid x$9 = this.newDescription$default$9();
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-17"), (Object)this.newDescription("link-no-source-topic-ids", "topic-17", 1, "PAUSED", 600000000L, x$7, x$6, x$8, x$9));
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-18"), (Object)this.newDescription("link-13", "topic-1", 1, "ACTIVE", 100000000L, this.newDescription$default$6(), this.newDescription$default$7(), this.newDescription$default$8(), this.newDescription$default$9()));
        this.allDescriptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.allPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 160L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new .colon.colon(this.newPartition("FAILED", 100L, -1L, -1L), (List)new .colon.colon(this.newPartition("FAILED", 120L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new .colon.colon(this.newPartition("FAILED", 130L, 30L, 2000L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new .colon.colon(this.newPartition("FAILED", 140L, -1L, -1L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new .colon.colon(this.newPartition("STOPPED", 150L, 40L, 160L), (List)new .colon.colon(this.newPartition("STOPPED", 160L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)new .colon.colon(this.newPartition("PENDING_STOPPED", 160L, 40L, 160L), (List)new .colon.colon(this.newPartition("PENDING_STOPPED", 200L, 50L, 200L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)new .colon.colon(null, (List)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)new .colon.colon(null, (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 160L), (List)new .colon.colon(null, (List)Nil$.MODULE$)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-11"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 0L, 100L), (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 110L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-12"), (Object)new .colon.colon(this.newPartition("FAILED", 100L, -1L, -1L), (List)new .colon.colon(this.newPartition("FAILED", 120L, -1L, 120L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-13"), (Object)new .colon.colon(this.newPartition("FAILED", 2000L, 0L, 2000L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-14"), (Object)new .colon.colon(this.newPartition("FAILED", -1L, -1L, -1L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-15"), (Object)new .colon.colon(this.newPartition("STOPPED", 150L, 0L, 150L), (List)new .colon.colon(this.newPartition("STOPPED", 160L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-16"), (Object)new .colon.colon(this.newPartition("PENDING_STOPPED", 160L, 40L, 160L), (List)new .colon.colon(this.newPartition("PENDING_STOPPED", 200L, 50L, 200L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-17"), (Object)new .colon.colon(this.newPartition("PAUSED", 400L, 10L, 100L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-18"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)Nil$.MODULE$))}));
    }

    public class TestAdminClient
    extends MockAdminClient {
        public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
            return (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        }

        public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
            return (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        }

        public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
            return (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        }

        public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
            return (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        }

        public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
            return (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        }

        public /* synthetic */ MirrorCommandTest kafka$admin$MirrorCommandTest$TestAdminClient$$$outer() {
            return MirrorCommandTest.this;
        }

        public TestAdminClient(Node node) {
            if (MirrorCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }
}

