/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.admin.balancer.BalancerCommandOptions;
import kafka.admin.balancer.BrokerAdditionCommand$;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00044\u0001\u0001\u0006Ia\u000b\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019I\u0004\u0001)A\u0005m!9!\b\u0001b\u0001\n\u0003)\u0004BB\u001e\u0001A\u0003%a\u0007C\u0004=\u0001\t\u0007I\u0011A\u001b\t\ru\u0002\u0001\u0015!\u00037\u0011\u001dq\u0004A1A\u0005\u0002}Baa\u0011\u0001!\u0002\u0013\u0001\u0005b\u0002#\u0001\u0005\u0004%\ta\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002!\t\u000b\u0019\u0003A\u0011B$\t\u000b\u0015\u0004A\u0011\u00014\t\u000bU\u0004A\u0011\u00014\t\u000b]\u0004A\u0011\u00014\t\u000be\u0004A\u0011\u00014\t\u000bm\u0004A\u0011\u00014\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\tI\"I]8lKJ\fE\rZ5uS>t7i\\7nC:$G+Z:u\u0015\tA\u0012$\u0001\u0005cC2\fgnY3s\u0015\tQ2$A\u0003bI6LgNC\u0001\u001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\tq#A\bc_>$8\u000f\u001e:baN+'O^3s+\u0005Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0011a\u0017M\\4\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0007'R\u0014\u0018N\\4\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u0004\u0013a\u00022s_.,'\u000fM\u000b\u0002mA\u0011\u0001eN\u0005\u0003q\u0005\u00121!\u00138u\u0003!\u0011'o\\6feB\u0002\u0013a\u00022s_.,'/M\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002\u0017M$\u0018M\u001d;US6,Wj]\u000b\u0002\u0001B\u0011\u0001%Q\u0005\u0003\u0005\u0006\u0012A\u0001T8oO\u0006a1\u000f^1siRKW.Z'tA\u0005\u0001B.Y:u+B$\u0017\r^3US6,Wj]\u0001\u0012Y\u0006\u001cH/\u00169eCR,G+[7f\u001bN\u0004\u0013A\u0003:v]\u000e{W.\\1oIR\u0019\u0001JU,\u0011\u0005%\u0003fB\u0001&O!\tY\u0015%D\u0001M\u0015\tiU$\u0001\u0004=e>|GOP\u0005\u0003\u001f\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001\u001aR\u0015\ty\u0015\u0005C\u0003T\u001d\u0001\u0007A+\u0001\u0003be\u001e\u001c\bc\u0001\u0011V\u0011&\u0011a+\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u00061:\u0001\r!W\u0001\u0010[>\u001c7.\u00113nS:\u001cE.[3oiB\u0011!lY\u0007\u00027*\u0011!\u0004\u0018\u0006\u0003;z\u000bqa\u00197jK:$8O\u0003\u0002\u001d?*\u0011\u0001-Y\u0001\u0007CB\f7\r[3\u000b\u0003\t\f1a\u001c:h\u0013\t!7LA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003-\"Xm\u001d;EKN\u001c'/\u001b2f\u0005J|7.\u001a:BI\u0012LG/[8o'\"|wo]#naRLX*Z:tC\u001e,G#A4\u0011\u0005\u0001B\u0017BA5\"\u0005\u0011)f.\u001b;)\u0005=Y\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\r\t\u0007/\u001b\u0006\u0003aF\fqA[;qSR,'O\u0003\u0002sC\u0006)!.\u001e8ji&\u0011A/\u001c\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$H)Z:de&\u0014WM\u0011:pW\u0016\u0014\u0018\t\u001a3ji&|g\u000e\u000b\u0002\u0011W\u00069D/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s\u0003\u0012$\u0017\u000e^5p]>sG._*i_^\u001cH\u000b[3Ta\u0016\u001c\u0017NZ5fI\n\u0013xn[3s\u0013\u0012D#!E6\u0002UQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Ce>\\WM]!eI&$\u0018n\u001c8t)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u0012!c[\u0001\u0018i\u0016\u001cH/T5tg&twMU3rk&\u0014X\rZ!sOND#aE6\u0002\u001f\t\u0014xn[3s'V\u00147\u000f\u001e:j]\u001e$\"aK@\t\r\u0005\u0005A\u00031\u00017\u0003!\u0011'o\\6fe&#\u0017AD2pk:$8+\u001e2tiJLgn\u001a\u000b\u0006m\u0005\u001d\u00111\u0002\u0005\u0007\u0003\u0013)\u0002\u0019\u0001%\u0002\u0007M$(\u000f\u0003\u0004\u0002\u000eU\u0001\r\u0001S\u0001\u0007gV\u00147\u000f\u001e:")
public class BrokerAdditionCommandTest {
    private final String bootstrapServer;
    private final int broker0;
    private final int broker1;
    private final int broker2;
    private final long startTimeMs = new SystemTime().hiResClockMs();
    private final long lastUpdateTimeMs = this.startTimeMs() + new package.DurationInt(package$.MODULE$.DurationInt(30)).second().toMillis();

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public int broker0() {
        return this.broker0;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    private String runCommand(String[] args, MockAdminClient mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> BrokerAdditionCommand$.MODULE$.runAddition(new BalancerCommandOptions((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class))), (ConfluentAdmin)mockAdminClient);
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    @Test
    public void testDescribeBrokerAdditionShowsEmptyMessage() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        HashMap additionMap = new HashMap();
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand(new String[]{"--describe"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains("No broker additions in progress"), (String)"Empty results message should be shown");
    }

    @Test
    public void testDescribeBrokerAddition() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        BalancerOperationError opError = new BalancerOperationError(Errors.BALANCER_OPERATION_OVERRIDDEN, "SBK is offline!");
        HashMap<Integer, BrokerAdditionDescription> additionMap = new HashMap<Integer, BrokerAdditionDescription>();
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker0()), new BrokerAdditionDescription(this.broker0(), BalancerOperationStatus.SUCCESS, PartitionReassignmentsStatus.COMPLETED, Optional.empty(), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker1()), new BrokerAdditionDescription(this.broker1(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker2()), new BrokerAdditionDescription(this.broker2(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand(new String[]{"--describe"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker0())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker0()).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker1())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker1()).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker2())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker2()).toString());
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, PartitionReassignmentsStatus.COMPLETED.name()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, PartitionReassignmentsStatus.ERROR.name()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BalancerOperationOverriddenException.class.getName()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, opError.errorMessage()));
        Assertions.assertEquals((int)3, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())), (String)output);
        Assertions.assertEquals((int)3, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())), (String)output);
    }

    @Test
    public void testDescribeBrokerAdditionOnlyShowsTheSpecifiedBrokerId() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl singleAdditionFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.description(this.broker0())).thenReturn((Object)singleAdditionFutureMock);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        BalancerOperationError opError = new BalancerOperationError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        HashMap<Integer, BrokerAdditionDescription> additionMap = new HashMap<Integer, BrokerAdditionDescription>();
        BrokerAdditionDescription b0Addition = new BrokerAdditionDescription(this.broker0(), BalancerOperationStatus.SUCCESS, PartitionReassignmentsStatus.COMPLETED, Optional.empty(), this.startTimeMs(), this.lastUpdateTimeMs());
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker0()), b0Addition);
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker1()), new BrokerAdditionDescription(this.broker1(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker2()), new BrokerAdditionDescription(this.broker2(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)singleAdditionFutureMock.get()).thenReturn(Optional.of(b0Addition));
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-id", Integer.toString(this.broker0())}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker0())), (String)new StringBuilder(45).append("Output should contain broker id ").append(this.broker0()).append(". Output was ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.broker1())), (String)new StringBuilder(49).append("Output should not contain broker id ").append(this.broker1()).append(". Output was ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.broker2())), (String)new StringBuilder(49).append("Output should not contain broker id ").append(this.broker2()).append(". Output was ").append(output).toString());
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, PartitionReassignmentsStatus.COMPLETED.name()));
        Assertions.assertEquals((int)0, (int)this.countSubstring(output, PartitionReassignmentsStatus.ERROR.name()));
        Assertions.assertEquals((int)0, (int)this.countSubstring(output, BalancerOperationOverriddenException.class.getName()));
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())), (String)output);
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())), (String)output);
    }

    @Test
    public void testDescribeBrokerAdditionsThrowsException() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenThrow(new Throwable[]{new BalancerOfflineException("SBK is offline!")});
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        AdminCommandFailedException receivedException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> this.runCommand(new String[]{"--describe"}, admin));
        Assertions.assertNotNull((Object)receivedException.getCause(), (String)"Expected the exception to have a cause");
        Assertions.assertEquals(BalancerOfflineException.class, receivedException.getCause().getClass());
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BalancerCommandOptions(new String[]{"--broker-id", Integer.toString(this.broker1()), "--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerAdditionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }

    private String brokerSubstring(int brokerId) {
        return new StringBuilder(7).append("Broker ").append(brokerId).toString();
    }

    private int countSubstring(String str, String substr) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(substr)).findAllMatchIn((CharSequence)str).length();
    }

    public BrokerAdditionCommandTest() {
        this.bootstrapServer = "localhost:9092";
        this.broker0 = 0;
        this.broker1 = 1;
        this.broker2 = 2;
    }
}

