/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.balancer.BrokerRemovalCommand$;
import kafka.admin.balancer.BrokerRemovalCommandOptions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\u0010 \u0005\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u00047\u0001\u0001\u0006Ia\r\u0005\bo\u0001\u0011\r\u0011\"\u00013\u0011\u0019A\u0004\u0001)A\u0005g!9\u0011\b\u0001b\u0001\n\u0003\u0011\u0004B\u0002\u001e\u0001A\u0003%1\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u001a\t\rq\u0002\u0001\u0015!\u00034\u0011\u001di\u0004A1A\u0005\u0002yBaa\u0012\u0001!\u0002\u0013y\u0004b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007'\u0002\u0001\u000b\u0011\u0002&\t\u000bQ\u0003A\u0011B+\t\u000b5\u0004A\u0011\u00018\t\u000bu\u0004A\u0011\u00018\t\u000b}\u0004A\u0011\u00018\t\r\u0005\r\u0001\u0001\"\u0001o\u0011\u0019\t9\u0001\u0001C\u0001]\"1\u00111\u0002\u0001\u0005\u00029Da!a\u0004\u0001\t\u0003q\u0007BBA\n\u0001\u0011\u0005a\u000e\u0003\u0004\u0002\u0018\u0001!\tA\u001c\u0005\u0007\u00037\u0001A\u0011\u00018\t\r\u0005}\u0001\u0001\"\u0001o\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b\tA\"I]8lKJ\u0014V-\\8wC2\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\u0001\n\u0013\u0001\u00032bY\u0006t7-\u001a:\u000b\u0005\t\u001a\u0013!B1e[&t'\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005y\u0012A\u00032s_.,'/\u00133`cU\t1\u0007\u0005\u0002)i%\u0011Q'\u000b\u0002\u0004\u0013:$\u0018a\u00032s_.,'/\u00133`c\u0001\n!B\u0019:pW\u0016\u0014\u0018\nZ03\u0003-\u0011'o\\6fe&#wL\r\u0011\u0002\u0017M$\u0018M\u001d;US6,Wj]\u0001\rgR\f'\u000f\u001e+j[\u0016l5\u000fI\u0001\u0011Y\u0006\u001cH/\u00169eCR,G+[7f\u001bN\f\u0011\u0003\\1tiV\u0003H-\u0019;f)&lW-T:!\u0003=\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014X#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n11\u000b\u001e:j]\u001e\f\u0001CY8piN$(/\u00199TKJ4XM\u001d\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001cX#\u0001&\u0011\u0007-s\u0005+D\u0001M\u0015\ti5)\u0001\u0003vi&d\u0017BA(M\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0001\u000b\u0016B\u0001*B\u0005\u001dIe\u000e^3hKJ\f!B\u0019:pW\u0016\u0014\u0018\nZ:!\u0003u\u0011X-\\8wC2|\u0005\u000f^5p]N\f%oZ;nK:$X*\u0019;dQ\u0016\u0014HC\u0001,i!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\b[>\u001c7.\u001b;p\u0015\u0005Y\u0016aA8sO&\u0011Q\f\u0017\u0002\u0010\u0003J<W/\\3oi6\u000bGo\u00195feB\u0011qLZ\u0007\u0002A*\u0011!%\u0019\u0006\u0003E\u000e\fqa\u00197jK:$8O\u0003\u0002%I*\u0011QMW\u0001\u0007CB\f7\r[3\n\u0005\u001d\u0004'\u0001\u0006*f[>4XM\u0011:pW\u0016\u00148o\u00149uS>t7\u000fC\u0003j\u001d\u0001\u0007!.\u0001\ffqB,7\r^3e'\"|W\u000f\u001c3TQV$Hm\\<o!\tA3.\u0003\u0002mS\t9!i\\8mK\u0006t\u0017\u0001\b;fgR$U\r\\3uK\n\u0013xn[3s\u0013N\u001cVoY2fgN4W\u000f\u001c\u000b\u0002_B\u0011\u0001\u0006]\u0005\u0003c&\u0012A!\u00168ji\"\u0012qb\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\f1!\u00199j\u0015\tA\u00180A\u0004kkBLG/\u001a:\u000b\u0005iT\u0016!\u00026v]&$\u0018B\u0001?v\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f\u001e#fY\u0016$X-T;mi&\u0004H.\u001a\"s_.,'o]%t'V\u001c7-Z:tMVd\u0007F\u0001\tt\u0003]\"Xm\u001d;EK2,G/Z'vYRL\u0007\u000f\\3Ce>\\WM]:XSRDgj\\*ikR$wn\u001e8GY\u0006<\u0017j]*vG\u000e,7o\u001d4vY\"\u0012\u0011c]\u0001!i\u0016\u001cH\u000fR3mKR,'I]8lKJ|F\u000f\u001b:poN,\u0005pY3qi&|g\u000e\u000b\u0002\u0013g\u0006IB/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s%\u0016lwN^1mQ\t\u00192/\u0001\u001cuKN$H)Z:de&\u0014WM\u0011:pW\u0016\u0014(+Z7pm\u0006dwJ\u001c7z'\"|wo\u001d+iKN\u0003XmY5gS\u0016$'I]8lKJLE\r\u000b\u0002\u0015g\u0006)C/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s%\u0016lwN^1mg\u0016k\u0007\u000f^=SKN,H\u000e\u001e\u0015\u0003+M\f\u0011\u0007^3ti\u0012+7o\u0019:jE\u0016\u0014%o\\6feJ+Wn\u001c<bYN\u001c\u0006n\\<t'B,7-\u001b4jK\u0012\u0014%o\\6fe&#7\u000f\u000b\u0002\u0017g\u00069D/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s%\u0016lwN^1m'\"|wO\\:F[B$\u00180T3tg\u0006<Wm\u00148O_J,Wn\u001c<bYND#aF:\u0002\u001fQ,7\u000f\u001e\"bI\u000e{W.\\1oIND#\u0001G:\u0002/Q,7\u000f^'jgNLgn\u001a*fcVL'/\u001a3Be\u001e\u001c\bFA\rt\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0007\u0003O\tY$!\u0012\u0011\t\u0005%\u0012q\u0007\b\u0005\u0003W\t\u0019\u0004E\u0002\u0002.%j!!a\f\u000b\u0007\u0005ER%\u0001\u0004=e>|GOP\u0005\u0004\u0003kI\u0013A\u0002)sK\u0012,g-C\u0002G\u0003sQ1!!\u000e*\u0011\u001d\tiD\u0007a\u0001\u0003\u007f\tA!\u0019:hgB)\u0001&!\u0011\u0002(%\u0019\u00111I\u0015\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005\u001d#\u00041\u0001\u0002J\u0005yQn\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fE\u0002`\u0003\u0017J1!!\u0014a\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\fqB\u0019:pW\u0016\u00148+\u001e2tiJLgn\u001a\u000b\u0004\u007f\u0005M\u0003BBA+7\u0001\u00071'\u0001\u0005ce>\\WM]%e\u0003i\u0019\b.\u001e;e_^t7k\u00195fIVdW\rZ*vEN#(/\u001b8h)\ry\u00141\f\u0005\u0007\u0003;b\u0002\u0019\u00016\u0002#MDW\u000f\u001e3po:\u001c6\r[3ek2,G-\u0001\bd_VtGoU;cgR\u0014\u0018N\\4\u0015\u000bM\n\u0019'a\u001a\t\u000f\u0005\u0015T\u00041\u0001\u0002(\u0005\u00191\u000f\u001e:\t\u000f\u0005%T\u00041\u0001\u0002(\u000511/\u001e2TiJ\u0004")
public final class BrokerRemovalCommandTest {
    private final int brokerId_1;
    private final int brokerId_2;
    private final int startTimeMs;
    private final int lastUpdateTimeMs;
    private final String bootstrapServer;
    private final java.util.List<Integer> brokerIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)this.brokerId_1()), (List)Nil$.MODULE$)).asJava();

    public int brokerId_1() {
        return this.brokerId_1;
    }

    public int brokerId_2() {
        return this.brokerId_2;
    }

    public int startTimeMs() {
        return this.startTimeMs;
    }

    public int lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public java.util.List<Integer> brokerIds() {
        return this.brokerIds;
    }

    private ArgumentMatcher<RemoveBrokersOptions> removalOptionsArgumentMatcher(boolean expectedShouldShutdown) {
        return new ArgumentMatcher<RemoveBrokersOptions>(null, expectedShouldShutdown){
            private final boolean expectedShouldShutdown$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(RemoveBrokersOptions options) {
                return options.shouldShutdownBrokers() == this.expectedShouldShutdown$1;
            }
            {
                this.expectedShouldShutdown$1 = expectedShouldShutdown$1;
            }
        };
    }

    @Test
    public void testDeleteBrokerIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn(this.brokerIds());
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand(new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq(this.brokerIds()), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(10).append("brokers [").append(this.brokerId_1()).append("]").toString()), (String)new StringBuilder(40).append("Output should contain broker ").append(this.brokerId_1()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        java.util.List brokerIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()}))).map((Function1 & Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)))).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand(new String[]{"--delete", "--broker-ids", "0 , 1"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        boolean expectedShouldShutdown = false;
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */))).thenReturn((Object)removeBrokersResult);
        java.util.List brokerIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()}))).map((Function1 & Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)))).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        String output = this.runCommand(new String[]{"--delete", "--broker-ids", "0 , 1", "--no-shutdown"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat((ArgumentMatcher)new /* invalid duplicate definition of identical inner class */));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteBroker_throwsException() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenThrow(BrokerRemovalInProgressException.class);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.any(RemoveBrokersOptions.class))).thenReturn((Object)removeBrokersResult);
        Assertions.assertThrows(AdminCommandFailedException.class, () -> this.runCommand(new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}, admin), () -> new StringBuilder(32).append("Broker ").append(this.brokerId_1()).append(" is already being removed").toString());
    }

    @Test
    public void testDescribeBrokerRemoval() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.INSUFFICIENT_REBALANCE_PLAN_METRICS, "Cannot compute plan!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand(new String[]{"--describe"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_1())).append(". Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_2())).append(". Output - ").append(output).toString());
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerShutdownStatus.COMPLETED.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, PartitionReassignmentsStatus.IN_PROGRESS.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerReplicaExclusionStatus.ERROR.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, opError.errorMessage()), (String)output);
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the correct general operation status");
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)"Output should contain the shutdown scheduled flag");
    }

    @Test
    public void testDescribeBrokerRemovalOnlyShowsTheSpecifiedBrokerId() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(22).append("Output should contain ").append(this.brokerId_1()).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
        Assertions.assertFalse((boolean)output.contains(opError.errorMessage()), (String)"Output shouldn't contain the operation error for other brokers");
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)"Output should contain the shutdown sub task status");
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the general status SUCCESS");
    }

    @Test
    public void testDescribeBrokerRemovalsEmptyResult() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(new HashMap());
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-ids", "0 , 1, 2"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains("No broker removals in progress"), (String)new StringBuilder(57).append("Output should mention that no removals are in progress - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains("0, 1, 2"), (String)new StringBuilder(46).append("Output should contain broker ids 0, 1 and 2 - ").append(output).toString());
    }

    @Test
    public void testDescribeBrokerRemovalsShowsSpecifiedBrokerIds() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.FAILED, BrokerShutdownStatus.ERROR, PartitionReassignmentsStatus.ERROR, BrokerReplicaExclusionStatus.CANCELED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-ids", "0 , 1, 2"}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(35).append("Output should contain broker id ").append(this.brokerId_1()).append(" - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(35).append("Output should contain broker id ").append(this.brokerId_2()).append(" - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(2)), (String)new StringBuilder(36).append("Output should contain broker id 2 - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains("no removal operations"), (String)new StringBuilder(72).append("Output should contain no removal operations described for broker id 2 - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(opError.errorMessage()), (String)new StringBuilder(66).append("Output should contain the operation error for specified brokers - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)new StringBuilder(63).append("Output should contain the shutdown sub task status COMPLETED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.COMPLETED.toString()), (String)new StringBuilder(77).append("Output should contain the partition reassignment sub task status COMPLETED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)new StringBuilder(51).append("Output should contain the general status SUCCESS - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(false)), (String)new StringBuilder(52).append("Output should contain the shutdown scheduled flag - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.ERROR.toString()), (String)new StringBuilder(59).append("Output should contain the shutdown sub task status ERROR - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.ERROR.toString()), (String)new StringBuilder(73).append("Output should contain the partition reassignment sub task status ERROR - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.FAILED.toString()), (String)new StringBuilder(50).append("Output should contain the general status FAILED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)new StringBuilder(52).append("Output should contain the shutdown scheduled flag - ").append(output).toString());
    }

    @Test
    public void testDescribeBrokerRemovalShownsEmptyMessageOnNoremovals() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, null, (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}, admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(42).append("No broker removals in progress for broker ").append(this.brokerId_1()).toString()), (String)"Error message should be shown");
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--broker-id", "1", "--broker-ids", "1, 2, 3"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--broker-id", "1", "--broker-ids", "1, 2, 3"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--delete"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> new BrokerRemovalCommandOptions(new String[]{"--broker-id", Integer.toString(this.brokerId_1()), "--delete"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
    }

    public String runCommand(String[] args, ConfluentAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> BrokerRemovalCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String brokerSubstring(int brokerId) {
        return new StringBuilder(7).append("Broker ").append(brokerId).toString();
    }

    private String shutdownScheduledSubString(boolean shutdownScheduled) {
        return new StringBuilder(20).append("Shutdown Scheduled: ").append(shutdownScheduled).toString();
    }

    private int countSubstring(String str, String subStr) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(subStr)).findAllMatchIn((CharSequence)str).length();
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public BrokerRemovalCommandTest() {
        this.brokerId_1 = 0;
        this.brokerId_2 = 1;
        this.startTimeMs = 1000101;
        this.lastUpdateTimeMs = 11313215;
        this.bootstrapServer = "localhost:9092";
    }
}

