/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="bazel:size:large")
@ScalaSignature(bytes="\u0006\u0005m3AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!9A\u0003\u0001b\u0001\n\u0003)\u0002B\u0002\u000f\u0001A\u0003%a\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003M\u0001\u0011\u0005QJA\u000bCCN,\u0017i]=oG\u000e{gn];nKJ$Vm\u001d;\u000b\u0005!I\u0011aA1qS*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001d\u0001\t1\u0004Z3gCVdGO\u00117pG.LgnZ!Q\u0013RKW.Z8vi6\u001bX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG/\u0001\u000feK\u001a\fW\u000f\u001c;CY>\u001c7.\u001b8h\u0003BKE+[7f_V$Xj\u001d\u0011\u0002\u001fQ,7\u000f^\"p[6LG/Q:z]\u000e$\"a\b\u0012\u0011\u0005]\u0001\u0013BA\u0011\u0019\u0005\u0011)f.\u001b;\t\u000b\r\"\u0001\u0019\u0001\u0013\u0002\rE,xN];n!\t)CF\u0004\u0002'UA\u0011q\u0005G\u0007\u0002Q)\u0011\u0011fC\u0001\u0007yI|w\u000e\u001e \n\u0005-B\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\r)\t\u0011\u0001D(\u0010\t\u0003cij\u0011A\r\u0006\u0003gQ\na\u0001]1sC6\u001c(BA\u001b7\u0003\u001dQW\u000f]5uKJT!a\u000e\u001d\u0002\u000b),h.\u001b;\u000b\u0003e\n1a\u001c:h\u0013\tY$GA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\na(\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\u0005\t\u00013u\t\u0005\u0002B\t6\t!I\u0003\u0002De\u0005A\u0001O]8wS\u0012,'/\u0003\u0002F\u0005\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#\u0001\u0013&\"\u0003%\u000bQa\u001b:bMR\f\u0013aS\u0001\rWJ\fg\r^\u0016lSBDD\u0007O\u0001\u000fi\u0016\u001cHoQ8n[&$8+\u001f8d)\tyb\nC\u0003$\u000b\u0001\u0007A\u0005\u000b\u0003\u0006aqj\u0004\u0006B\u0003A\rFc#\u0001\u0013&)\t\u0001\u0019\u0006,\u0017\t\u0003)Zk\u0011!\u0016\u0006\u0003\u0011QJ!aV+\u0003\u0007Q\u000bw-A\u0003wC2,X-I\u0001[\u0003A\u0011\u0017M_3muML'0\u001a\u001emCJ<W\r")
public class BaseAsyncConsumerTest
extends AbstractConsumerTest {
    private final int defaultBlockingAPITimeoutMs;

    public int defaultBlockingAPITimeoutMs() {
        return this.defaultBlockingAPITimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "kraft+kip848"})
    public void testCommitAsync(String quorum) {
        Properties props = new Properties();
        props.setProperty("group.protocol", GroupProtocol.CONSUMER.name());
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitAsync();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.defaultBlockingAPITimeoutMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAsyncConsumerTest.$anonfun$testCommitAsync$1(this, consumer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"wait until commit is completed successfully");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "kraft+kip848"})
    public void testCommitSync(String quorum) {
        Properties props = new Properties();
        props.setProperty("group.protocol", GroupProtocol.CONSUMER.name());
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitSync();
        Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava(), Duration.ofMillis(this.defaultBlockingAPITimeoutMs()));
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    public static final /* synthetic */ boolean $anonfun$testCommitAsync$1(BaseAsyncConsumerTest $this, Consumer consumer$1) {
        return consumer$1.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.tp()}))).asJava(), Duration.ofMillis($this.defaultBlockingAPITimeoutMs())) != null;
    }

    public static final /* synthetic */ String $anonfun$testCommitAsync$2() {
        return "wait until commit is completed successfully";
    }

    public BaseAsyncConsumerTest() {
        this.defaultBlockingAPITimeoutMs = 1000;
    }
}

