/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B(\t\r\u0015\u0004\u0001\u0015!\u0003Q\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d\u0001\bA1A\u0005REDaa\u001f\u0001!\u0002\u0013\u0011\bb\u0002?\u0001\u0005\u0004%\t&\u001d\u0005\u0007{\u0002\u0001\u000b\u0011\u0002:\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!a#\u0001\t\u0013\ti\tC\u0004\u0002P\u0002!I!!5\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001e\u0001\u0005\n\u00055\bbBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011%\u0011I\u0005AI\u0001\n\u0013\u0011Y\u0005C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"I!q\u0013\u0001\u0012\u0002\u0013%!Q\n\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa/\u0001\t\u0013\u0011i\fC\u0005\u0003L\u0002\t\n\u0011\"\u0003\u0003N\"9!\u0011\u001b\u0001\u0005\n\tM'aD\"pe\u0016lU\r\u001e:jGN$Vm\u001d;\u000b\u0005\u001dB\u0013aA1qS*\t\u0011&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001a\u0003\u0007\u0005\u0002.]5\ta%\u0003\u00020M\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002.c%\u0011!G\n\u0002\n'\u0006\u001cHnU3ukB\fa\u0001P5oSRtD#A\u001b\u0011\u00055\u0002\u0011a\u00032s_.,'oQ8v]R,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0004\u0013:$\u0018\u0001\u00042s_.,'oQ8v]R\u0004\u0013\u0001\u00047jgR,g.\u001a:OC6,W#A!\u0011\u0005\tcU\"A\"\u000b\u0005\u0011+\u0015a\u00028fi^|'o\u001b\u0006\u0003\r\u001e\u000baaY8n[>t'BA\u0015I\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055\u001b%\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM#(/\u001b8h\u0003eY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\u001c\u0011\u00023-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn]\u000b\u00027B\u0019A,\u0019)\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u0013A\u0001T5ti\u0006Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA\u0005A2.\u00194lCN+'O^3s\u0015\u0006\f7/\u00128ueft\u0015-\\3\u00023-\fgm[1TKJ4XM\u001d&bCN,e\u000e\u001e:z\u001d\u0006lW\rI\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fA!Y;uQ*\u0011Q.R\u0001\tg\u0016\u001cWO]5us&\u0011qN\u001b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\fAc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001cX#\u0001:\u0011\u0007e\u001aX/\u0003\u0002uu\t!1k\\7f!\t1\u00180D\u0001x\u0015\tAH+\u0001\u0003vi&d\u0017B\u0001>x\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013!B:fiV\u0003H\u0003BA\u0001\u0003\u000f\u00012!OA\u0002\u0013\r\t)A\u000f\u0002\u0005+:LG\u000fC\u0004\u0002\nA\u0001\r!a\u0003\u0002\u0011Q,7\u000f^%oM>\u0004B!!\u0004\u0002\u001a5\u0011\u0011q\u0002\u0006\u0004O\u0005E!\u0002BA\n\u0003+\tqA[;qSR,'OC\u0002\u0002\u0018)\u000bQA[;oSRLA!a\u0007\u0002\u0010\tAA+Z:u\u0013:4w\u000eK\u0002\u0011\u0003?\u0001B!!\u0004\u0002\"%!\u00111EA\b\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\u0011\u0011\u0011\u0001\u0015\u0004#\u0005-\u0002\u0003BA\u0007\u0003[IA!a\f\u0002\u0010\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\fi\u0016\u001cH/T3ue&\u001c7\u000fK\u0002\u0013\u0003k\u0001B!!\u0004\u00028%!\u0011\u0011HA\b\u0005\u0011!Vm\u001d;\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0003\u0003\ty$!\u0018\u0002b\u0005\u0015\u0004bBA!'\u0001\u0007\u00111I\u0001\taJ|G-^2feBA\u0011QIA'\u0003#\n\t&\u0004\u0002\u0002H)!\u0011\u0011IA%\u0015\r\tYeR\u0001\bG2LWM\u001c;t\u0013\u0011\ty%a\u0012\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0015I\u00141KA,\u0013\r\t)F\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004s\u0005e\u0013bAA.u\t!!)\u001f;f\u0011\u0019\tyf\u0005a\u0001q\u0005Qa.^7SK\u000e|'\u000fZ:\t\r\u0005\r4\u00031\u00019\u0003)\u0011XmY8sINK'0\u001a\u0005\b\u0003O\u001a\u0002\u0019AA5\u0003\t!\b\u000f\u0005\u0003\u0002l\u00055T\"A#\n\u0007\u0005=TI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002;\u001d,g.\u001a:bi\u0016\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!!\u0001\u0002v!9\u0011q\r\u000bA\u0002\u0005%\u0014!\u000b<fe&4\u0017pS1gW\u0006\u0014\u0016\r^3NKR\u0014\u0018nY:ICZ,7)^7vY\u0006$\u0018N^3D_VtG\u000f\u0006\u0004\u0002\u0002\u0005m\u0014Q\u0010\u0005\b\u0003\u0003*\u0002\u0019AA\"\u0011\u001d\ty(\u0006a\u0001\u0003\u0003\u000b\u0001bY8ogVlWM\u001d\t\t\u0003\u0007\u000b9)!\u0015\u0002R5\u0011\u0011Q\u0011\u0006\u0005\u0003\u007f\nI%\u0003\u0003\u0002\n\u0006\u0015%\u0001C\"p]N,X.\u001a:\u00025Y,'/\u001b4z\u00072LWM\u001c;WKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\r\u0005\u0005\u0011qRA\\\u0011\u001d\t\tJ\u0006a\u0001\u0003'\u000bq!\\3ue&\u001c7\u000f\r\u0003\u0002\u0016\u0006\u0015\u0006c\u0002<\u0002\u0018\u0006m\u0015\u0011U\u0005\u0004\u00033;(aA'baB!\u00111NAO\u0013\r\ty*\u0012\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\u0003BAR\u0003Kc\u0001\u0001\u0002\u0007\u0002(\u0006=\u0015\u0011!A\u0001\u0006\u0003\tIKA\u0002`IE\nB!a+\u00022B\u0019\u0011(!,\n\u0007\u0005=&HA\u0004O_RD\u0017N\\4\u0011\t\u0005-\u00141W\u0005\u0004\u0003k+%AB'fiJL7\rC\u0004\u0002:Z\u0001\r!a/\u0002\r\u0015tG/\u001b;z!\u0011\ti,a3\u000f\t\u0005}\u0016q\u0019\t\u0004\u0003\u0003TTBAAb\u0015\r\t)MK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%'(\u0001\u0004Qe\u0016$WMZ\u0005\u0004/\u00065'bAAeu\u0005\tc/\u001a:jMf\u0014%o\\6fe\u0006+H\u000f[3oi&\u001c\u0017\r^5p]6+GO]5dgR!\u0011\u0011AAj\u0011\u001d\t)n\u0006a\u0001\u0003/\faa]3sm\u0016\u0014\b\u0003BAm\u0003;l!!a7\u000b\u0007\u0005U\u0007&\u0003\u0003\u0002`\u0006m'aC&bM.\f7+\u001a:wKJ\fAE^3sS\u001aL(I]8lKJlUm]:bO\u0016\u001cuN\u001c<feNLwN\\'fiJL7m\u001d\u000b\t\u0003\u0003\t)/a:\u0002j\"9\u0011Q\u001b\rA\u0002\u0005]\u0007BBA21\u0001\u0007\u0001\bC\u0004\u0002ha\u0001\r!!\u001b\u0002+Y,'/\u001b4z\u0005J|7.\u001a:[W6+GO]5dgR1\u0011\u0011AAx\u0003cDq!!6\u001a\u0001\u0004\t9\u000eC\u0004\u0002tf\u0001\r!a/\u0002\u000bQ|\u0007/[2\u00021Y,'/\u001b4z\u0005J|7.\u001a:FeJ|'/T3ue&\u001c7\u000f\u0006\u0003\u0002\u0002\u0005e\bbBAk5\u0001\u0007\u0011q[\u0001\u0012m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cW\u0003BA\u0000\u0005\u000b!\"B!\u0001\u0003.\tE\"Q\bB )\u0011\u0011\u0019A!\u0005\u0011\t\u0005\r&Q\u0001\u0003\b\u0005\u000fY\"\u0019\u0001B\u0005\u0005\u0005!\u0016\u0003BAV\u0005\u0017\u00012!\u000fB\u0007\u0013\r\u0011yA\u000f\u0002\u0004\u0003:L\bb\u0002B\n7\u0001\u0007!QC\u0001\u0007m\u0016\u0014\u0018NZ=\u0011\u000fe\u00129Ba\u0007\u0003\u0004%\u0019!\u0011\u0004\u001e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002B\u000f\u0005O\t\tL\u0004\u0003\u0003 \t\rb\u0002BAa\u0005CI\u0011aO\u0005\u0004\u0005KQ\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011)C\u000f\u0005\b\u0005_Y\u0002\u0019AA^\u0003\u0011q\u0017-\\3\t\u000f\u0005E5\u00041\u0001\u00034A\"!Q\u0007B\u001d!\u001d1\u0018qSAN\u0005o\u0001B!a)\u0003:\u0011a!1\bB\u0019\u0003\u0003\u0005\tQ!\u0001\u0002*\n\u0019q\f\n\u001a\t\u000f\u0005e6\u00041\u0001\u0002<\"I!\u0011I\u000e\u0011\u0002\u0003\u0007!1I\u0001\u0006OJ|W\u000f\u001d\t\u0006s\t\u0015\u00131X\u0005\u0004\u0005\u000fR$AB(qi&|g.A\u000ewKJLg-_&bM.\fW*\u001a;sS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0005\u0005\u001b\u0012\u0019'\u0006\u0002\u0003P)\"!1\tB)W\t\u0011\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B/u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005$q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B\u00049\t\u0007!\u0011B\u0001\u0014[\u0006D8*\u00194lC6+GO]5d-\u0006dW/\u001a\u000b\u000b\u0005S\u0012yG!\u001d\u0003~\t}\u0004cA\u001d\u0003l%\u0019!Q\u000e\u001e\u0003\r\u0011{WO\u00197f\u0011\u001d\u0011y#\ba\u0001\u0003wCq!!%\u001e\u0001\u0004\u0011\u0019\b\r\u0003\u0003v\te\u0004c\u0002<\u0002\u0018\u0006m%q\u000f\t\u0005\u0003G\u0013I\b\u0002\u0007\u0003|\tE\u0014\u0011!A\u0001\u0006\u0003\tIKA\u0002`IMBq!!/\u001e\u0001\u0004\tY\fC\u0004\u0003Bu\u0001\rAa\u0011\u00023Y,'/\u001b4z\u0017\u000647.Y'fiJL7MU3d_J$W\r\u001a\u000b\u000b\u0003\u0003\u0011)Ia\"\u0003\u0014\nU\u0005b\u0002B\u0018=\u0001\u0007\u00111\u0018\u0005\b\u0003#s\u0002\u0019\u0001BEa\u0011\u0011YIa$\u0011\u000fY\f9*a'\u0003\u000eB!\u00111\u0015BH\t1\u0011\tJa\"\u0002\u0002\u0003\u0005)\u0011AAU\u0005\ryF\u0005\u000e\u0005\b\u0003ss\u0002\u0019AA^\u0011%\u0011\tE\bI\u0001\u0002\u0004\u0011\u0019%A\u0012wKJLg-_&bM.\fW*\u001a;sS\u000e\u0014VmY8sI\u0016$G\u0005Z3gCVdG\u000f\n\u001b\u0002#e\fW.\\3s\u001b\u0016$(/[2WC2,X\r\u0006\u0003\u0003\f\tu\u0005b\u0002B\u0018A\u0001\u0007\u00111X\u0001\u0010s\u0006lW.\u001a:ISN$xn\u001a:b[R!!1\u0015B]!\u0011\u0011)K!.\u000e\u0005\t\u001d&\u0002\u0002BU\u0005W\u000bAaY8sK*!\u0011\u0011\u0013BW\u0015\u0011\u0011yK!-\u0002\re\fW.\\3s\u0015\t\u0011\u0019,A\u0002d_6LAAa.\u0003(\nI\u0001*[:u_\u001e\u0014\u0018-\u001c\u0005\b\u0005_\t\u0003\u0019AA^\u0003i1XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3e)\u0019\u0011IGa0\u0003B\"9!q\u0006\u0012A\u0002\u0005m\u0006\"\u0003B\nEA\u0005\t\u0019\u0001Bb!\u001dI$q\u0003B5\u0005\u000b\u00042!\u000fBd\u0013\r\u0011IM\u000f\u0002\b\u0005>|G.Z1o\u0003\u00112XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3eI\u0011,g-Y;mi\u0012\u0012TC\u0001BhU\u0011\u0011\u0019M!\u0015\u0002-Y,'/\u001b4z\u001d>\u0014V-];fgRlU\r\u001e:jGN$B!!\u0001\u0003V\"9!q\u001b\u0013A\u0002\u0005m\u0016\u0001D3se>\u0014X*Z:tC\u001e,\u0007")
public class CoreMetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            CoreMetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            CoreMetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)name -> {
            CoreMetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!CoreMetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)CoreMetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)CoreMetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = CoreMetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = CoreMetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return CoreMetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = CoreMetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = CoreMetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(CoreMetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> CoreMetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        CoreMetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(CoreMetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CoreMetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)CoreMetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public CoreMetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)CoreMetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        CoreMetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

