/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5b!B\u001c9\u0003\u0003i\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002%\u0001\r#I\u0005\"\u0002)\u0001\t#I\u0005bB)\u0001\u0005\u0004%\tA\u0015\u0005\u00077\u0002\u0001\u000b\u0011B*\t\u000fq\u0003!\u0019!C\u0001%\"1Q\f\u0001Q\u0001\nMCqA\u0018\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004`\u0001\u0001\u0006Ia\u0015\u0005\bA\u0002\u0011\r\u0011\"\u0001S\u0011\u0019\t\u0007\u0001)A\u0005'\"9!\r\u0001b\u0001\n\u0003\u0011\u0006BB2\u0001A\u0003%1\u000bC\u0004e\u0001\t\u0007I\u0011\u0001*\t\r\u0015\u0004\u0001\u0015!\u0003T\u0011\u001d1\u0007A1A\u0005\n\u001dDq!!\u0002\u0001A\u0003%\u0001\u000eC\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0002C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@!A\u0011q\n\u0001!\u0002\u0013\t\t\u0005C\u0004\u0002R\u0001!\t\"a\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0005\u0002h!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAG\u0001\u0011E\u0013q\u0012\u0005\b\u0003#\u0003A\u0011CAJ\u0011\u001d\t9\n\u0001C\t\u00033Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002@\u0002!\t\"!1\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007fD\u0011Ba\u000b\u0001#\u0003%\tA!\f\t\u0013\t=\u0003!%A\u0005\u0002\tE\u0003\"\u0003B,\u0001E\u0005I\u0011\u0001B-\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KB\u0011Ba'\u0001#\u0003%\tA!(\t\u0013\t5\u0006!%A\u0005\u0002\t=\u0006\"\u0003B[\u0001E\u0005I\u0011\u0001B\\\u0011%\u0011i\fAI\u0001\n\u0003\u0011y\fC\u0004\u0003J\u0002!\tAa3\t\u0013\tU\u0007!%A\u0005\u0002\tm\u0003b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\n\u0005c\u0004\u0011\u0013!C\u0001\u00057BqAa=\u0001\t\u0003\u0011)\u0010C\u0005\u0003~\u0002\t\n\u0011\"\u0001\u0003\u0000\"I11\u0001\u0001\u0012\u0002\u0013\u0005!1\f\u0005\b\u0007\u000b\u0001A\u0011AB\u0004\u0011%\u0019i\u0001AI\u0001\n\u0003\u0011y\u0010C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0001\u0003\\!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\u0012\u0001\u0011\u0005\u00131 \u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg*\u0011\u0011HO\u0001\u0004CBL'\"A\u001e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003j\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u00111\t\u0011\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u0012\t\u0003\u000f\u0002i\u0011\u0001O\u0001\fEJ|7.\u001a:D_VtG/F\u0001K!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\rIe\u000e^\u0001\fY><G)\u001b:D_VtG/\u0001\bqe>$WoY3s\u0007>tg-[4\u0016\u0003M\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\tU$\u0018\u000e\u001c\u0006\u00021\u0006!!.\u0019<b\u0013\tQVK\u0001\u0006Qe>\u0004XM\u001d;jKN\fq\u0002\u001d:pIV\u001cWM]\"p]\u001aLw\rI\u0001\u000fG>t7/^7fe\u000e{gNZ5h\u0003=\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e\u0004\u0013!E1e[&t7\t\\5f]R\u001cuN\u001c4jO\u0006\u0011\u0012\rZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4!\u0003U\u0019X\u000f]3skN,'o\u00117jK:$8i\u001c8gS\u001e\fac];qKJ,8/\u001a:DY&,g\u000e^\"p]\u001aLw\rI\u0001\rg\u0016\u0014h/\u001a:D_:4\u0017nZ\u0001\u000eg\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0011\u0002!\r|g\u000e\u001e:pY2,'oQ8oM&<\u0017!E2p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hA\u0005I1m\u001c8tk6,'o]\u000b\u0002QB\u0019\u0011N\u001c9\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011Q\u000eT\u0001\u000bG>dG.Z2uS>t\u0017BA8k\u0005\u0019\u0011UO\u001a4feB*\u0011/!\u0001\u0002\u0018A)!\u000f @\u0002\u00165\t1O\u0003\u0002uk\u0006A1m\u001c8tk6,'O\u0003\u0002wo\u000691\r\\5f]R\u001c(BA\u001ey\u0015\tI(0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0006\u0019qN]4\n\u0005u\u001c(\u0001C\"p]N,X.\u001a:\u0011\u0007}\f\t\u0001\u0004\u0001\u0005\u0017\u0005\r\u0011#!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0002\u0004?\u0012\n\u0014AC2p]N,X.\u001a:tAE!\u0011\u0011BA\b!\rY\u00151B\u0005\u0004\u0003\u001ba%a\u0002(pi\"Lgn\u001a\t\u0004\u0017\u0006E\u0011bAA\n\u0019\n\u0019\u0011I\\=\u0011\u0007}\f9\u0002B\u0006\u0002\u001aE\t\t\u0011!A\u0003\u0002\u0005\u001d!aA0%e\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003?\u0001B!\u001b8\u0002\"A2\u00111EA\u0019\u0003s\u0001\u0002\"!\n\u0002,\u0005=\u0012qG\u0007\u0003\u0003OQ1!!\u000bv\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BA\u0017\u0003O\u0011QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bcA@\u00022\u0011Y\u00111G\n\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryFeM\u0001\u000baJ|G-^2feN\u0004\u0003cA@\u0002:\u0011Y\u00111H\n\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryF\u0005N\u0001\rC\u0012l\u0017N\\\"mS\u0016tGo]\u000b\u0003\u0003\u0003\u0002B!\u001b8\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002JU\fQ!\u00193nS:LA!!\u0014\u0002H\t)\u0011\tZ7j]\u0006i\u0011\rZ7j]\u000ec\u0017.\u001a8ug\u0002\nq#\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\b]\u0016$xo\u001c:l\u0015\r\tyf^\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\t\u0005%\u0014q\u000e\t\u0004\u0017\u0006-\u0014bAA7\u0019\n!QK\\5u\u0011\u001d\t\th\u0006a\u0001\u0003g\nQ\u0001\u001d:paN\u0004R!!\u001e\u0002xMk\u0011\u0001\\\u0005\u0004\u0003sb'aA*fc\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002\u0000A1\u0011QOA<\u0003\u0003\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fS\u0014AB:feZ,'/\u0003\u0003\u0002\f\u0006\u0015%aC&bM.\f7i\u001c8gS\u001e\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003\u0003g\n!cY8oM&<WO]3MSN$XM\\3sgR!\u0011\u0011NAK\u0011\u001d\t\tH\u0007a\u0001\u0003g\n\u0011%\u001b8tKJ$8i\u001c8ue>dG.\u001a:MSN$XM\\3sg&3g*Z3eK\u0012$B!!\u001b\u0002\u001c\"9\u0011\u0011O\u000eA\u0002\u0005M\u0014!B:fiV\u0003H\u0003BA5\u0003CCq!a)\u001d\u0001\u0004\t)+\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t9+a-\u000e\u0005\u0005%&bA\u001d\u0002,*!\u0011QVAX\u0003\u001dQW\u000f]5uKJT1!!-{\u0003\u0015QWO\\5u\u0013\u0011\t),!+\u0003\u0011Q+7\u000f^%oM>D3\u0001HA]!\u0011\t9+a/\n\t\u0005u\u0016\u0011\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u00053p'V\u0004XM];tKJ\u001cV\r^;q)\u0011\tI'a1\t\u000f\u0005\rV\u00041\u0001\u0002&\u00069Am\\*fiV\u0004HCBA5\u0003\u0013\fY\rC\u0004\u0002$z\u0001\r!!*\t\u000f\u00055g\u00041\u0001\u0002P\u0006\u00112M]3bi\u0016|eMZ:fiN$v\u000e]5d!\rY\u0015\u0011[\u0005\u0004\u0003'd%a\u0002\"p_2,\u0017M\\\u0001\u0014G2LWM\u001c;TK\u000e,(/\u001b;z!J|\u0007o\u001d\u000b\u0004'\u0006e\u0007bBAn?\u0001\u0007\u0011Q\\\u0001\nG\u0016\u0014H/\u00117jCN\u0004B!a8\u0002n:!\u0011\u0011]Au!\r\t\u0019\u000fT\u0007\u0003\u0003KT1!a:=\u0003\u0019a$o\\8u}%\u0019\u00111\u001e'\u0002\rA\u0013X\rZ3g\u0013\u0011\ty/!=\u0003\rM#(/\u001b8h\u0015\r\tY\u000fT\u0001\u0017gV\u0004XM];tKJ\u001cVmY;sSRL\bK]8qgR\u00191+a>\t\u000f\u0005m\u0007\u00051\u0001\u0002^\u00061R\u000f\u001d3bi\u0016\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u0006\u0002\u0002j\u0005q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014XC\u0002B\u0001\u0005\u000f\u0011i\u0001\u0006\u0005\u0003\u0004\tE!\u0011\u0005B\u0014!!\t)#a\u000b\u0003\u0006\t-\u0001cA@\u0003\b\u00119!\u0011\u0002\u0012C\u0002\u0005\u001d!!A&\u0011\u0007}\u0014i\u0001B\u0004\u0003\u0010\t\u0012\r!a\u0002\u0003\u0003YC\u0011Ba\u0005#!\u0003\u0005\rA!\u0006\u0002\u001b-,\u0017pU3sS\u0006d\u0017N_3s!\u0019\u00119B!\b\u0003\u00065\u0011!\u0011\u0004\u0006\u0005\u00057\ti&A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0005?\u0011IB\u0001\u0006TKJL\u0017\r\\5{KJD\u0011Ba\t#!\u0003\u0005\rA!\n\u0002\u001fY\fG.^3TKJL\u0017\r\\5{KJ\u0004bAa\u0006\u0003\u001e\t-\u0001\u0002\u0003B\u0015EA\u0005\t\u0019A*\u0002\u001f\r|gNZ5h\u001fZ,'O]5eKN\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0019\u0011yCa\u0013\u0003NU\u0011!\u0011\u0007\u0016\u0005\u0005g\u0011I\u0004\u0005\u0003\u0003\u0018\tU\u0012\u0002\u0002B\u001c\u00053\u00111CQ=uK\u0006\u0013(/Y=TKJL\u0017\r\\5{KJ\\#Aa\u000f\u0011\t\tu\"qI\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000bb\u0015AC1o]>$\u0018\r^5p]&!!\u0011\nB \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0005\u0013\u0019#\u0019AA\u0004\t\u001d\u0011ya\tb\u0001\u0003\u000f\t\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u0011yCa\u0015\u0003V\u00119!\u0011\u0002\u0013C\u0002\u0005\u001dAa\u0002B\bI\t\u0007\u0011qA\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u001aTC\u0002B.\u0005?\u0012\t'\u0006\u0002\u0003^)\u001a1K!\u000f\u0005\u000f\t%QE1\u0001\u0002\b\u00119!qB\u0013C\u0002\u0005\u001d\u0011AD2sK\u0006$XmQ8ogVlWM]\u000b\u0007\u0005O\u0012iG!\u001d\u0015\u0015\t%$1\u000fB?\u0005\u0007\u0013)\t\u0005\u0004sy\n-$q\u000e\t\u0004\u007f\n5Da\u0002B\u0005M\t\u0007\u0011q\u0001\t\u0004\u007f\nEDa\u0002B\bM\t\u0007\u0011q\u0001\u0005\n\u0005k2\u0003\u0013!a\u0001\u0005o\nqb[3z\t\u0016\u001cXM]5bY&TXM\u001d\t\u0007\u0005/\u0011IHa\u001b\n\t\tm$\u0011\u0004\u0002\r\t\u0016\u001cXM]5bY&TXM\u001d\u0005\n\u0005\u007f2\u0003\u0013!a\u0001\u0005\u0003\u000b\u0011C^1mk\u0016$Um]3sS\u0006d\u0017N_3s!\u0019\u00119B!\u001f\u0003p!A!\u0011\u0006\u0014\u0011\u0002\u0003\u00071\u000bC\u0005\u0003\b\u001a\u0002\n\u00111\u0001\u0003\n\u0006y1m\u001c8gS\u001e\u001cHk\u001c*f[>4X\r\u0005\u0004\u0003\f\nU\u0015Q\u001c\b\u0005\u0005\u001b\u0013\tJ\u0004\u0003\u0002d\n=\u0015\"A'\n\u0007\tME*A\u0004qC\u000e\\\u0017mZ3\n\t\t]%\u0011\u0014\u0002\u0005\u0019&\u001cHOC\u0002\u0003\u00142\u000b\u0001d\u0019:fCR,7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0019\u0011yJ!+\u0003,V\u0011!\u0011\u0015\u0016\u0005\u0005G\u0013I\u0004\u0005\u0003\u0003\u0018\t\u0015\u0016\u0002\u0002BT\u00053\u0011QCQ=uK\u0006\u0013(/Y=EKN,'/[1mSj,'\u000fB\u0004\u0003\n\u001d\u0012\r!a\u0002\u0005\u000f\t=qE1\u0001\u0002\b\u0005A2M]3bi\u0016\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\r\t}%\u0011\u0017BZ\t\u001d\u0011I\u0001\u000bb\u0001\u0003\u000f!qAa\u0004)\u0005\u0004\t9!\u0001\rde\u0016\fG/Z\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIM*bAa\u0017\u0003:\nmFa\u0002B\u0005S\t\u0007\u0011q\u0001\u0003\b\u0005\u001fI#\u0019AA\u0004\u0003a\u0019'/Z1uK\u000e{gn];nKJ$C-\u001a4bk2$H\u0005N\u000b\u0007\u0005\u0003\u0014)Ma2\u0016\u0005\t\r'\u0006\u0002BE\u0005s!qA!\u0003+\u0005\u0004\t9\u0001B\u0004\u0003\u0010)\u0012\r!a\u0002\u00025\r\u0014X-\u0019;f\u0007>tg\r\\;f]R\fE-\\5o\u00072LWM\u001c;\u0015\t\t5'1\u001b\t\u0005\u0003\u000b\u0012y-\u0003\u0003\u0003R\u0006\u001d#AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\u001c\u0005\t\u0005SY\u0003\u0013!a\u0001'\u0006!3M]3bi\u0016\u001cuN\u001c4mk\u0016tG/\u00113nS:\u001cE.[3oi\u0012\"WMZ1vYR$\u0013'\u0001\fde\u0016\fG/Z\"m_V$\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0011\u0011YNa<\u0011\t\tu'1^\u0007\u0003\u0005?T1A\u001eBq\u0015\rY$1\u001d\u0006\u0005\u0005K\u00149/A\u0005d_:4G.^3oi*\u0011!\u0011^\u0001\u0003S>LAA!<\u0003`\nQ1\t\\8vI\u0006#W.\u001b8\t\u0011\t%R\u0006%AA\u0002M\u000b\u0001e\u0019:fCR,7\t\\8vI\u0006#W.\u001b8DY&,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\r\u0005\r#q\u001fB~\u0011%\u0011Ip\fI\u0001\u0002\u0004\t)&\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0003\u0005\u0003*=\u0002\n\u00111\u0001T\u0003m\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\u0001\u0016\u0005\u0003+\u0012I$A\u000ede\u0016\fG/Z!e[&t7\t\\5f]R$C-\u001a4bk2$HEM\u0001\u001bGJ,\u0017\r^3TkB,'/^:fe\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0007\u0003\u0007\u001aIaa\u0003\t\u0013\te(\u0007%AA\u0002\u0005U\u0003\u0002\u0003B\u0015eA\u0005\t\u0019A*\u0002I\r\u0014X-\u0019;f'V\u0004XM];tKJ\fE-\\5o\u00072LWM\u001c;%I\u00164\u0017-\u001e7uIE\nAe\u0019:fCR,7+\u001e9feV\u001cXM]!e[&t7\t\\5f]R$C-\u001a4bk2$HEM\u0001\rG\"\fgnZ3MK\u0006$WM\u001d\u000b\u0006\u0015\u000eU1q\u0003\u0005\b\u0003\u0013*\u0004\u0019AA\"\u0011\u001d\u0019I\"\u000ea\u0001\u00077\t!\u0001\u001e9\u0011\t\ru1qD\u0007\u0003\u0003;JAa!\t\u0002^\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0003;fCJ$un\u001e8)\u0007Y\u001a9\u0003\u0005\u0003\u0002(\u000e%\u0012\u0002BB\u0016\u0003S\u0013\u0011\"\u00114uKJ,\u0015m\u00195")
public abstract class IntegrationTestHarness
extends KafkaServerTestHarness {
    private final Properties producerConfig = new Properties();
    private final Properties consumerConfig = new Properties();
    private final Properties adminClientConfig = new Properties();
    private final Properties superuserClientConfig = new Properties();
    private final Properties serverConfig = new Properties();
    private final Properties controllerConfig = new Properties();
    private final Buffer<Consumer<?, ?>> consumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaProducer<?, ?>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Admin> adminClients = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public abstract int brokerCount();

    public int logDirCount() {
        return 1;
    }

    public Properties producerConfig() {
        return this.producerConfig;
    }

    public Properties consumerConfig() {
        return this.consumerConfig;
    }

    public Properties adminClientConfig() {
        return this.adminClientConfig;
    }

    public Properties superuserClientConfig() {
        return this.superuserClientConfig;
    }

    public Properties serverConfig() {
        return this.serverConfig;
    }

    public Properties controllerConfig() {
        return this.controllerConfig;
    }

    private Buffer<Consumer<?, ?>> consumers() {
        return this.consumers;
    }

    private Buffer<KafkaProducer<?, ?>> producers() {
        return this.producers;
    }

    private Buffer<Admin> adminClients() {
        return this.adminClients;
    }

    public ListenerName interBrokerListenerName() {
        return this.listenerName();
    }

    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)x$1 -> {
            IntegrationTestHarness.$anonfun$modifyConfigs$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        String x$22 = this.zkConnectOrNull();
        Some x$32 = new Some((Object)this.securityProtocol());
        Option<File> x$42 = this.trustStoreFile();
        Option<Properties> x$5 = this.serverSaslProperties();
        int x$6 = this.logDirCount();
        int x$7 = this.firstBrokerId();
        boolean x$8 = true;
        boolean x$9 = true;
        boolean x$10 = true;
        boolean x$11 = false;
        boolean x$12 = false;
        boolean x$13 = false;
        Map x$14 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        boolean x$18 = false;
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$1, x$22, x$8, x$9, (Option<SecurityProtocol>)x$32, x$42, x$5, x$10, x$11, x$12, x$13, (Map<Object, String>)x$14, x$6, x$15, x$16, x$17, x$7, x$18);
        this.configureListeners(cfgs);
        this.modifyConfigs(cfgs);
        if (this.isZkMigrationTest()) {
            cfgs.foreach((Function1 & Serializable)x$2 -> x$2.setProperty(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true"));
        }
        cfgs.foreach((Function1 & Serializable)props -> {
            this.maybeEnablePushReplication(props);
            return BoxedUnit.UNIT;
        });
        if (this.isNewGroupCoordinatorEnabled()) {
            cfgs.foreach((Function1 & Serializable)x$3 -> x$3.setProperty(KafkaConfig$.MODULE$.NewGroupCoordinatorEnableProp(), "true"));
        }
        if (this.isKRaftTest()) {
            cfgs.foreach((Function1 & Serializable)x$4 -> x$4.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), TestUtils.tempDirectory(null, null).getAbsolutePath()));
        }
        this.insertControllerListenersIfNeeded(cfgs);
        return (Seq)cfgs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.controllerConfig(), (List)Nil$.MODULE$);
    }

    public void configureListeners(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.interBrokerListenerName().value());
            Set listenerNames = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListenerName[]{this.listenerName(), this.interBrokerListenerName()}));
            String listeners = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> new StringBuilder(13).append(listenerName.value()).append("://localhost:").append(TestUtils$.MODULE$.RandomPort()).toString())).mkString(",");
            String listenerSecurityMap = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> new StringBuilder(1).append(listenerName.value()).append(":").append($this.securityProtocol().name).toString())).mkString(",");
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), listeners);
            config.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), listeners);
            return config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), listenerSecurityMap);
        });
    }

    public void insertControllerListenersIfNeeded(Seq<Properties> props) {
        if (this.isKRaftTest()) {
            props.foreach((Function1 & Serializable)config -> {
                Object[] securityPairs = config.getProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "").split(",");
                Object[] toAdd = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])config.getProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "").split(",")), arg_0 -> IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2$adapted((String[])securityPairs, arg_0));
                if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps(toAdd))) {
                    return config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(securityPairs), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(toAdd), (Function1 & Serializable)e -> new StringBuilder(1).append((String)e).append(":").append(this.controllerListenerSecurityProtocol().toString()).toString(), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class))).mkString(","));
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, true);
    }

    public void doSuperuserSetup(TestInfo testInfo) {
        this.superuserClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
    }

    public void doSetup(TestInfo testInfo, boolean createOffsetsTopic) {
        Properties PropertiesOps_properties = this.producerConfig();
        Object var3_3 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties).$plus$plus$eq(this.clientSecurityProps("producer"));
        Properties PropertiesOps_properties2 = this.consumerConfig();
        Object var4_4 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties2).$plus$plus$eq(this.clientSecurityProps("consumer"));
        Properties PropertiesOps_properties3 = this.adminClientConfig();
        Object var5_5 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties3).$plus$plus$eq(this.clientSecurityProps("adminClient"));
        Properties PropertiesOps_properties4 = this.superuserClientConfig();
        Object var6_6 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties4).$plus$plus$eq(this.superuserSecurityProps("superuserClient"));
        super.setUp(testInfo);
        this.producerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.producerConfig().putIfAbsent("acks", "-1");
        this.producerConfig().putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        this.producerConfig().putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        this.consumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.consumerConfig().putIfAbsent("auto.offset.reset", "earliest");
        this.consumerConfig().putIfAbsent("group.id", "group");
        this.consumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.consumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.maybeGroupProtocolSpecified(testInfo).map((Function1 & Serializable)groupProtocol -> this.consumerConfig().putIfAbsent("group.protocol", groupProtocol.name));
        this.adminClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.doSuperuserSetup(testInfo);
        if (createOffsetsTopic) {
            super.createOffsetsTopic(this.listenerName(), this.superuserClientConfig());
            return;
        }
    }

    public Properties clientSecurityProps(String certAlias) {
        return TestUtils$.MODULE$.securityConfigs(Mode.CLIENT, this.securityProtocol(), this.trustStoreFile(), certAlias, TestUtils$.MODULE$.SslCertificateCn(), this.clientSaslProperties(), TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Option<Object>)None$.MODULE$);
    }

    public Properties superuserSecurityProps(String certAlias) {
        return this.clientSecurityProps(certAlias);
    }

    public void updateBootstrapServers() {
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.brokers(), this.listenerName());
        this.producerConfig().put("bootstrap.servers", brokerList);
        this.consumerConfig().put("bootstrap.servers", brokerList);
        this.adminClientConfig().put("bootstrap.servers", brokerList);
    }

    public <K, V> KafkaProducer<K, V> createProducer(Serializer<K> keySerializer, Serializer<V> valueSerializer, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.producerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        KafkaProducer producer = new KafkaProducer(props, keySerializer, valueSerializer);
        this.producers().$plus$eq((Object)producer);
        return producer;
    }

    public <K, V> ByteArraySerializer createProducer$default$1() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$2() {
        return new ByteArraySerializer();
    }

    public <K, V> Properties createProducer$default$3() {
        return new Properties();
    }

    public <K, V> Consumer<K, V> createConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.consumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$6 -> props.remove(x$6));
        KafkaConsumer consumer = new KafkaConsumer(props, keyDeserializer, valueDeserializer);
        this.consumers().$plus$eq((Object)consumer);
        return consumer;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public ConfluentAdmin createConfluentAdminClient(Properties configOverrides) {
        return this.createCloudAdminClient(configOverrides);
    }

    public Properties createConfluentAdminClient$default$1() {
        return new Properties();
    }

    public CloudAdmin createCloudAdminClient(Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.adminClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        CloudAdmin adminClient = CloudAdmin.create((Properties)props);
        this.adminClients().$plus$eq((Object)adminClient);
        return adminClient;
    }

    public Properties createCloudAdminClient$default$1() {
        return new Properties();
    }

    public Admin createAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.adminClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createAdminClient$default$2() {
        return new Properties();
    }

    public Admin createSuperuserAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.superuserClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createSuperuserAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createSuperuserAdminClient$default$2() {
        return new Properties();
    }

    public int changeLeader(Admin admin, TopicPartition tp) {
        TopicPartitionInfo desc = (TopicPartitionInfo)((TopicDescription)((KafkaFuture)admin.describeTopics(Collections.singleton(tp.topic())).topicNameValues().get(tp.topic())).get(15L, TimeUnit.SECONDS)).partitions().get(tp.partition());
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(desc.replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()));
        Assertions.assertTrue((replicas.size() > 1 ? 1 : 0) != 0, (String)new StringBuilder(49).append("No replicas available to change leader, replicas=").append(replicas).toString());
        Buffer newReplicas = (Buffer)((SeqOps)replicas.tail()).$colon$plus(replicas.head());
        Integer newLeader = (Integer)newReplicas.head();
        Assertions.assertNotEquals((int)desc.leader().id(), (Integer)newLeader, (String)new StringBuilder(37).append(tp).append(" new leader is same as current leader").toString());
        NewPartitionReassignment assignment = new NewPartitionReassignment(CollectionConverters$.MODULE$.BufferHasAsJava(newReplicas).asJava());
        admin.alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(assignment))).all().get(15L, TimeUnit.SECONDS);
        admin.electLeaders(ElectionType.PREFERRED, Collections.singleton(tp)).all().get(15L, TimeUnit.SECONDS);
        TestUtils$.MODULE$.waitForLeaderToBecome(admin, tp, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(newLeader))));
        return Predef$.MODULE$.Integer2int(newLeader);
    }

    @Override
    @AfterEach
    public void tearDown() {
        CoreUtils$.MODULE$.tryAll((Seq)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> CoreUtils$.MODULE$.tryAll((Seq)((IterableOnceOps)this.producers().map((Function1 & Serializable)p -> (JFunction0.mcV.sp & Serializable)() -> p.close(Duration.ZERO))).toList()), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> CoreUtils$.MODULE$.tryAll((Seq)((IterableOnceOps)this.consumers().map((Function1 & Serializable)c -> (JFunction0.mcV.sp & Serializable)() -> c.wakeup())).toList()), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> CoreUtils$.MODULE$.tryAll((Seq)((IterableOnceOps)this.consumers().map((Function1 & Serializable)c -> (JFunction0.mcV.sp & Serializable)() -> c.close(Duration.ZERO))).toList()), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> CoreUtils$.MODULE$.tryAll((Seq)((IterableOnceOps)this.adminClients().map((Function1 & Serializable)c -> (JFunction0.mcV.sp & Serializable)() -> c.close(Duration.ZERO))).toList()), (List)Nil$.MODULE$)))));
        this.producers().clear();
        this.consumers().clear();
        this.adminClients().clear();
        super.tearDown();
    }

    public static final /* synthetic */ void $anonfun$modifyConfigs$1(IntegrationTestHarness $this, Properties x$1) {
        new Implicits.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$insertControllerListenersIfNeeded$2(String[] securityPairs$1, String x0$1) {
        return !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])securityPairs$1), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(new StringBuilder(1).append(x0$1).append(":").toString())));
    }

    public static final /* synthetic */ Object $anonfun$insertControllerListenersIfNeeded$2$adapted(String[] securityPairs$1, String x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2(securityPairs$1, x0$1));
    }
}

