/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\b\u0010\u0001QAQa\u0007\u0001\u0005\u0002qAqa\b\u0001C\u0002\u0013%\u0001\u0005\u0003\u0004(\u0001\u0001\u0006I!\t\u0005\bQ\u0001\u0011\r\u0011\"\u0003*\u0011\u0019\u0011\u0004\u0001)A\u0005U!91\u0007\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u001b\u0001A\u0003%\u0011\u0005C\u00056\u0001\u0001\u0007\t\u0019!C\u0005m!I!\b\u0001a\u0001\u0002\u0004%Ia\u000f\u0005\n\u0003\u0002\u0001\r\u0011!Q!\n]BQA\u0011\u0001\u0005B\rCQ!\u0016\u0001\u0005BYCQa\u0017\u0001\u0005\u0002q\u0013q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005A\t\u0012aA1qS*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0012\u0003\u0019\u0019XM\u001d<fe&\u0011!d\u0006\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0010\u0003!\u0011'o\\6fe&#W#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005)Ao\u001c9jGV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005Qa.^7SK\u000e|'\u000fZ:\u0002\u00179,XNU3d_J$7\u000fI\u0001\u0007EJ|7.\u001a:\u0016\u0003]\u0002\"A\u0006\u001d\n\u0005e:\"aC&bM.\f'I]8lKJ\f!B\u0019:pW\u0016\u0014x\fJ3r)\tat\b\u0005\u0002#{%\u0011ah\t\u0002\u0005+:LG\u000fC\u0004A\u0013\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013'A\u0004ce>\\WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005q\"\u0005\"B#\f\u0001\u00041\u0015\u0001\u0003;fgRLeNZ8\u0011\u0005\u001d{U\"\u0001%\u000b\u0005AI%B\u0001&L\u0003\u001dQW\u000f]5uKJT!\u0001T'\u0002\u000b),h.\u001b;\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001\u0006J\u0001\u0005UKN$\u0018J\u001c4pQ\tY!\u000b\u0005\u0002H'&\u0011A\u000b\u0013\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003qB#\u0001\u0004-\u0011\u0005\u001dK\u0016B\u0001.I\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\buKN$8i\\7qe\u0016\u001c8/[8o)\raT,\u001b\u0005\u0006=6\u0001\raX\u0001\u0007cV|'/^7\u0011\u0005\u0001<gBA1f!\t\u00117%D\u0001d\u0015\t!7#\u0001\u0004=e>|GOP\u0005\u0003M\u000e\na\u0001\u0015:fI\u00164\u0017BA\u0019i\u0015\t17\u0005C\u0003k\u001b\u0001\u0007q,A\u0006d_6\u0004(/Z:tS>t\u0007FA\u0007m!\ti\u0007/D\u0001o\u0015\ty\u0017*\u0001\u0004qCJ\fWn]\u0005\u0003c:\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u0011i1/\u001f>\u0011\u0005Q<X\"A;\u000b\u0005Yt\u0017\u0001\u00039s_ZLG-\u001a:\n\u0005a,(!C\"tmN{WO]2f\u0003\u00151\u0018\r\\;fY-YXp`A\u0002\u0003\u000f\tY!a\u0004\"\u0003q\f!b\u001b:bMRdcn\u001c8fC\u0005q\u0018AC6sC\u001a$Hf\u001a>ja\u0006\u0012\u0011\u0011A\u0001\rWJ\fg\r\u001e\u0017t]\u0006\u0004\b/_\u0011\u0003\u0003\u000b\t\u0011b\u001b:bMRdCN\u001f\u001b\"\u0005\u0005%\u0011AC6sC\u001a$HF_:uI\u0006\u0012\u0011QB\u0001\bu.dsM_5qC\t\t\t\"A\u0005{W2\u001ah.\u00199qs\u0002")
public class ProducerCompressionTest
extends QuorumTestHarness {
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaBroker broker;

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaBroker broker() {
        return this.broker;
    }

    private void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.broker_$eq(this.createBroker(new KafkaConfig((java.util.Map)props), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), true);
        super.tearDown();
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,none", "kraft,gzip", "kraft,snappy", "kraft,lz4", "kraft,zstd", "zk,gzip", "zk,snappy"})
    public void testCompression(String quorum, String compression) {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$));
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        Consumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, "group", (Option<String>)None$.MODULE$, "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer(), (String)null);
        try {
            try (Admin admin = TestUtils$.MODULE$.createAdminClient(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties());){
                TestUtils$.MODULE$.createTopicWithAdmin(admin, this.topic(), new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            }
            int partition = 0;
            IndexedSeq messageValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable)i -> ProducerCompressionTest.messageValue$1(BoxesRunTime.unboxToInt((Object)i)));
            Header[] headerArr = new Header[]{new RecordHeader("key", "value".getBytes())};
            RecordHeaders headers = new RecordHeaders(headerArr);
            long now = System.currentTimeMillis();
            ListBuffer responses = new ListBuffer();
            messageValues.foreach((Function1 & Serializable)message -> {
                responses.$plus$eq((Object)producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())));
                responses.$plus$eq((Object)producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), (Object)Integer.toString(message.length()).getBytes(), (Object)message.getBytes())));
                return (ListBuffer)responses.$plus$eq((Object)producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), (Object)Integer.toString(message.length()).getBytes(), (Object)message.getBytes(), (Iterable)headers)));
            });
            ((IterableOps)responses.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$2);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords() * 3, 15000L);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numRecords()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String messageValue = (String)messageValues.apply(i);
                int offset = i * 3;
                ConsumerRecord record = (ConsumerRecord)records.apply(offset);
                Assertions.assertNull((Object)record.key());
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((int)0, (int)record.headers().toArray().length);
                Assertions.assertEquals((long)now, (long)record.timestamp());
                Assertions.assertEquals((long)offset, (long)record.offset());
                offset = i * 3 + 1;
                record = (ConsumerRecord)records.apply(offset);
                Assertions.assertEquals((Object)Integer.toString(messageValue.length()), (Object)new String((byte[])record.key()));
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((int)0, (int)record.headers().toArray().length);
                Assertions.assertEquals((long)now, (long)record.timestamp());
                Assertions.assertEquals((long)offset, (long)record.offset());
                offset = i * 3 + 2;
                record = (ConsumerRecord)records.apply(offset);
                Assertions.assertEquals((Object)Integer.toString(messageValue.length()), (Object)new String((byte[])record.key()));
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((int)1, (int)record.headers().toArray().length);
                Assertions.assertEquals((Object)headerArr[0], (Object)record.headers().toArray()[0]);
                Assertions.assertEquals((long)now, (long)record.timestamp());
                Assertions.assertEquals((long)offset, (long)record.offset());
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray((ClassTag)ClassTag$.MODULE$.Char()));
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$2) {
        if (x$2 != null) {
            Future future = (Future)x$2._1();
            Assertions.assertEquals((long)x$2._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public ProducerCompressionTest() {
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
    }
}

