/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c!B\r\u001b\u0003\u0003y\u0002\"\u0002\u0013\u0001\t\u0003)\u0003bB\u0014\u0001\u0005\u0004%\t\u0001\u000b\u0005\u0007c\u0001\u0001\u000b\u0011B\u0015\t\u000fI\u0002!\u0019!C\u0001Q!11\u0007\u0001Q\u0001\n%Bq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004=\u0001\u0001\u0007I\u0011A\u001f\t\r\r\u0003\u0001\u0015)\u00037\u0011\u0015!\u0005\u0001\"\u0005F\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015y\u0006\u0001\"\u0011R\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011!Q\u0007\u0001#b\u0001\n#Z\u0007bB;\u0001\u0005\u0004%\tA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0001m\"1A\u0010\u0001Q\u0001\n]Dq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B@\t\ru\u0004A\u0011KA\u0007\u0011\u001d\tI\u0002\u0001C!\u00037Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002H\u0001!\t!!\u0010\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\t9\u0002K]8ysB\u0013x\u000e^8d_2,enZ5oKR+7\u000f\u001e\u0006\u00037q\t1!\u00199j\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0012\u000e\u0003iI!a\t\u000e\u0003)\u0005\u00137\u000f\u001e:bGR\u001cuN\\:v[\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\"\u0001\u0005\u0011\"I]8lKJd\u0015n\u001d;f]\u0016\u0014h*Y7f+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0011a\u0017M\\4\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002'\t\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002%\rc\u0017.\u001a8u\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0014\u00072LWM\u001c;MSN$XM\\3s\u001d\u0006lW\rI\u0001\nK:\f'\r\\3Tg2,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b\u0005>|G.Z1o\u00035)g.\u00192mKN\u001bHn\u0018\u0013fcR\u0011a(\u0011\t\u0003o}J!\u0001\u0011\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u001e\t\t\u00111\u00017\u0003\rAH%M\u0001\u000bK:\f'\r\\3Tg2\u0004\u0013a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0015\u0003\u0019\u0003\"a\u0012(\u000f\u0005!c\u0005CA%9\u001b\u0005Q%BA&\u001f\u0003\u0019a$o\\8u}%\u0011Q\nO\u0001\u0007!J,G-\u001a4\n\u0005Az%BA'9\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001S!\t\u0019V,D\u0001U\u0015\t)f+A\u0004oKR<xN]6\u000b\u0005]C\u0016AB2p[6|gN\u0003\u0002\u001e3*\u0011!lW\u0001\u0007CB\f7\r[3\u000b\u0003q\u000b1a\u001c:h\u0013\tqFK\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u0007mSN$XM\\3s\u001d\u0006lW-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\t!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!\u0011-\u001e;i\u0015\t9g+\u0001\u0005tK\u000e,(/\u001b;z\u0013\tIGM\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006qAO];tiN#xN]3GS2,W#\u00017\u0011\u0007]jw.\u0003\u0002oq\t1q\n\u001d;j_:\u0004\"\u0001]:\u000e\u0003ET!A]\u0017\u0002\u0005%|\u0017B\u0001;r\u0005\u00111\u0015\u000e\\3\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u+\u00059\bCA\u001cy\u0013\tI\bHA\u0002J]R\fabY8ogVlWM]\"pk:$\b%A\u0007qe>$WoY3s\u0007>,h\u000e^\u0001\u000faJ|G-^2fe\u000e{WO\u001c;!\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7/F\u0001\u0000!\u0019\t\t!a\u0002G\r6\u0011\u00111\u0001\u0006\u0004\u0003\u000bi\u0013\u0001B;uS2LA!!\u0003\u0002\u0004\t\u0019Q*\u00199\u00021\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001c\b\u0005F\u0002?\u0003\u001fAq!!\u0005\u0015\u0001\u0004\t\u0019\"\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!!\u0001\u0002\u0016%!\u0011qCA\u0002\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004}\u0005u\u0001bBA\u0010+\u0001\u0007\u0011\u0011E\u0001\ti\u0016\u001cH/\u00138g_B!\u00111EA\u0018\u001b\t\t)CC\u0002\u001c\u0003OQA!!\u000b\u0002,\u00059!.\u001e9ji\u0016\u0014(bAA\u00177\u0006)!.\u001e8ji&!\u0011\u0011GA\u0013\u0005!!Vm\u001d;J]\u001a|\u0007fA\u000b\u00026A!\u00111EA\u001c\u0013\u0011\tI$!\n\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000euKN$\b\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-Z\"p]N,X.\u001a\u000b\u0002}!\u001aa#!\u0011\u0011\t\u0005\r\u00121I\u0005\u0005\u0003\u000b\n)C\u0001\u0003UKN$\u0018!\u0006;fgR\u001c6\u000f\u001c)s_\u0012,8-Z\"p]N,X.\u001a\u0015\u0004/\u0005\u0005\u0013AE2p]\u001aLw-\u001e:f\u0019&\u001cH/\u001a8feN$2APA(\u0011\u001d\t\t\u0006\u0007a\u0001\u0003'\nQ\u0001\u001d:paN\u0004b!!\u0016\u0002\\\u0005MQBAA,\u0015\r\tI\u0006O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u00121aU3r\u0001")
public abstract class ProxyProtocolEngineTest
extends AbstractConsumerTest {
    private Option<File> trustStoreFile;
    private final String BrokerListenerName;
    private final String ClientListenerName;
    private boolean enableSsl = false;
    private final int consumerCount;
    private final int producerCount;
    private final Map<String, String> brokerPropertyOverrides;
    private volatile boolean bitmap$0;

    public String BrokerListenerName() {
        return this.BrokerListenerName;
    }

    public String ClientListenerName() {
        return this.ClientListenerName;
    }

    public boolean enableSsl() {
        return this.enableSsl;
    }

    public void enableSsl_$eq(boolean x$1) {
        this.enableSsl = x$1;
    }

    public String protocolVersion() {
        return "";
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(this.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(this.ClientListenerName());
    }

    @Override
    public SecurityProtocol securityProtocol() {
        if (this.enableSsl()) {
            return SecurityProtocol.SSL;
        }
        return SecurityProtocol.PLAINTEXT;
    }

    private Option<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)TestUtils.tempFile((String)"truststore", (String)".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    @Override
    public Option<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    public Map<String, String> brokerPropertyOverrides() {
        return this.brokerPropertyOverrides;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.putAll(this.brokerPropertyOverrides());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.brokerPropertyOverrides().clear();
        this.brokerPropertyOverrides().put(new StringBuilder(32).append(this.interBrokerListenerName().configPrefix()).append("confluent.proxy.protocol.version").toString(), ProxyProtocol.NONE.toString());
        this.brokerPropertyOverrides().put("confluent.proxy.protocol.version", this.protocolVersion());
        this.brokerPropertyOverrides().put("confluent.proxy.protocol.fallback.enabled", "false");
        this.enableSsl_$eq(false);
        super.setUp(testInfo);
    }

    @Test
    public void testPlaintextProduceConsume() {
        int numRecords = 1;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @Test
    public void testSslProduceConsume() {
        int numRecords = 1;
        this.enableSsl_$eq(true);
        this.recreateBrokers(true, true);
        Properties produerSecurityProps = new Properties();
        produerSecurityProps.putAll((Map<?, ?>)TestUtils$.MODULE$.producerSecurityConfigs(SecurityProtocol.SSL, this.trustStoreFile(), this.clientSaslProperties()));
        produerSecurityProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, produerSecurityProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties consumerSecurityProps = new Properties();
        consumerSecurityProps.putAll((Map<?, ?>)TestUtils$.MODULE$.consumerSecurityConfigs(SecurityProtocol.SSL, this.trustStoreFile(), this.clientSaslProperties()));
        consumerSecurityProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        ByteArrayDeserializer x$5 = this.createConsumer$default$1();
        ByteArrayDeserializer x$6 = this.createConsumer$default$2();
        List<String> x$7 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$5, x$6, consumerSecurityProps, x$7);
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$12 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$13 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$14 = this.consumeAndVerifyRecords$default$7();
        int x$15 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$12, startingTimestamp, x$13, x$14, x$15);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @Override
    public void configureListeners(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.interBrokerListenerName().value());
            String listeners = ((IterableOnceOps)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListenerName[]{this.listenerName(), this.interBrokerListenerName()}))).map((Function1 & Serializable)listenerName -> new StringBuilder(13).append(listenerName.value()).append("://localhost:").append(TestUtils$.MODULE$.RandomPort()).toString())).mkString(",");
            String listenerSecurityMap = new StringBuilder(12).append(this.listenerName().value()).append(":").append($this.securityProtocol().name).append(",").append(this.interBrokerListenerName().value()).append(":PLAINTEXT").toString();
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), listeners);
            config.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), listeners);
            return config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), listenerSecurityMap);
        });
    }

    public ProxyProtocolEngineTest() {
        this.BrokerListenerName = "BROKER";
        this.ClientListenerName = "CLIENT";
        this.consumerCount = 1;
        this.producerCount = 1;
        this.producerConfig().setProperty("confluent.proxy.protocol.client.version", this.protocolVersion());
        this.producerConfig().setProperty("confluent.proxy.protocol.client.address", "192.168.1.10");
        this.producerConfig().setProperty("confluent.proxy.protocol.client.port", "9092");
        this.consumerConfig().setProperty("confluent.proxy.protocol.client.version", this.protocolVersion());
        this.consumerConfig().setProperty("confluent.proxy.protocol.client.address", "192.168.1.11");
        this.consumerConfig().setProperty("confluent.proxy.protocol.client.port", "9093");
        this.brokerPropertyOverrides = new HashMap<String, String>();
    }
}

