/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaBroker;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tev!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002#\t\u000bA\u000bA\u0011A)\u0007\u000ba\n\u0014\u0011\u00012\t\u0011\r4!\u0011!Q\u0001\n\u0011C\u0001\u0002\u001a\u0004\u0003\u0002\u0003\u0006I!\u001a\u0005\tW\u001a\u0011\t\u0011)A\u0005\t\"AAN\u0002B\u0001B\u0003%A\t\u0003\u0005n\r\t\u0015\r\u0011\"\u0001o\u0011!ahA!A!\u0002\u0013y\u0007\u0002C?\u0007\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005%aA!A!\u0002\u0013y\bBCA\u0006\r\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u00111\u0004\u0004\u0003\u0002\u0003\u0006I!a\u0004\t\r\u00013A\u0011AA\u000f\u0011\u001d\tyC\u0002D\u0001\u0003cAq!a\u0013\u0007\r\u0003\ti\u0005C\u0004\u0002P\u00191\t\"!\u0015\t\u000f\u0005\rdA\"\u0005\u0002f!9\u0011q\u000f\u0004\u0005\u0002\u0005e\u0004\"CAM\rE\u0005I\u0011AAN\u0011%\t\tLBI\u0001\n\u0003\t\u0019\fC\u0004\u00028\u001a!\t!!/\t\u0013\u0005}f!%A\u0005\u0002\u0005m\u0005bBAa\r\u0011%\u00111\u0019\u0005\b\u0003?4A\u0011BAq\u0011\u001d\tiP\u0002C\u0001\u0003\u007fD\u0011Ba\u0003\u0007#\u0003%\t!a'\t\u0013\t5a!%A\u0005\u0002\u0005m\u0005b\u0002B\b\r\u0011\u0005!\u0011\u0003\u0005\n\u000531\u0011\u0013!C\u0001\u00037C\u0011Ba\u0007\u0007#\u0003%\t!a'\t\u000f\tua\u0001\"\u0003\u0003 !9!q\u0006\u0004\u0005\n\tE\u0002b\u0002B\u001f\r\u0011\u0005!q\b\u0005\b\u0005\u00172A\u0011\u0002B'\u0011\u001d\u0011\u0019F\u0002C\u0001\u0005+BqAa\u0016\u0007\t\u0013\u0011I\u0006C\u0004\u0003^\u0019!\tAa\u0018\t\u0013\t%d!%A\u0005\u0002\t-\u0004b\u0002B8\r\u0011\u0005!\u0011\u000f\u0005\b\u0005\u00073A\u0011\u0001BC\u0011\u001d\u0011IJ\u0002C\u0001\u00057CqAa*\u0007\t\u0003\u0011I\u000bC\u0005\u00034\u001a\t\n\u0011\"\u0001\u00036\u0006\u0001\u0012+^8uCR+7\u000f^\"mS\u0016tGo\u001d\u0006\u0003eM\n1!\u00199j\u0015\u0005!\u0014!B6bM.\f7\u0001\u0001\t\u0003o\u0005i\u0011!\r\u0002\u0011#V|G/\u0019+fgR\u001cE.[3oiN\u001c\"!\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta'A\u0007EK\u001a\fW\u000f\u001c;F]RLG/_\u000b\u0002\tB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u001f\u000e\u0003!S!!S\u001b\u0002\rq\u0012xn\u001c;?\u0013\tYE(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&=\u00039!UMZ1vYR,e\u000e^5us\u0002\n1\"\\3ue&\u001cg+\u00197vKR\u0011!+\u0016\t\u0003wMK!\u0001\u0016\u001f\u0003\r\u0011{WO\u00197f\u0011\u00151V\u00011\u0001X\u0003\u0019iW\r\u001e:jGB\u0011\u0001\fY\u0007\u00023*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u0005Qb&BA/_\u0003\u0019\t\u0007/Y2iK*\tq,A\u0002pe\u001eL!!Y-\u0003\r5+GO]5d'\t1!(A\u0003u_BL7-\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u001a\u0002\rM,'O^3s\u0013\tQwMA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003A\u0019wN\\:v[\u0016\u00148\t\\5f]RLE-\u0001\u0005qe>$WoY3s+\u0005y\u0007\u0003\u00029umZl\u0011!\u001d\u0006\u0003[JT!a].\u0002\u000f\rd\u0017.\u001a8ug&\u0011Q/\u001d\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007m:\u00180\u0003\u0002yy\t)\u0011I\u001d:bsB\u00111H_\u0005\u0003wr\u0012AAQ=uK\u0006I\u0001O]8ek\u000e,'\u000fI\u0001\tG>t7/^7feV\tq\u0010\u0005\u0004\u0002\u0002\u0005\u0015aO^\u0007\u0003\u0003\u0007Q!! :\n\t\u0005\u001d\u00111\u0001\u0002\t\u0007>t7/^7fe\u0006I1m\u001c8tk6,'\u000fI\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016I\fQ!\u00193nS:LA!!\u0007\u0002\u0014\t)\u0011\tZ7j]\u0006a\u0011\rZ7j]\u000ec\u0017.\u001a8uAQ\u0001\u0012qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012Q\u0006\t\u0003o\u0019AQaY\tA\u0002\u0011CQ\u0001Z\tA\u0002\u0015DQa[\tA\u0002\u0011CQ\u0001\\\tA\u0002\u0011CQ!\\\tA\u0002=DQ!`\tA\u0002}Dq!a\u0003\u0012\u0001\u0004\ty!\u0001\bpm\u0016\u0014(/\u001b3f#V|G/Y:\u0015\u0011\u0005M\u0012\u0011HA\"\u0003\u000f\u00022aOA\u001b\u0013\r\t9\u0004\u0010\u0002\u0005+:LG\u000fC\u0004\u0002<I\u0001\r!!\u0010\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\rY\u0014qH\u0005\u0004\u0003\u0003b$\u0001\u0002'p]\u001eDq!!\u0012\u0013\u0001\u0004\ti$A\u0007d_:\u001cX/\\3s#V|G/\u0019\u0005\u0007\u0003\u0013\u0012\u0002\u0019\u0001*\u0002\u0019I,\u0017/^3tiF+x\u000e^1\u0002)I,Wn\u001c<f#V|G/Y(wKJ\u0014\u0018\u000eZ3t)\t\t\u0019$A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0003bkRD'bAA/3\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002b\u0005]#AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u0010cV|G/Y'fiJL7\rV1hgR!\u0011qMA:!\u0019\tI'a\u001cE\t6\u0011\u00111\u000e\u0006\u0004\u0003[b\u0014AC2pY2,7\r^5p]&!\u0011\u0011OA6\u0005\ri\u0015\r\u001d\u0005\u0007\u0003k*\u0002\u0019\u0001#\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fQ\u0003\u001d:pIV\u001cW-\u00168uS2$\u0006N]8ui2,G\r\u0006\u0005\u0002|\u0005\u0005\u0015QQAH!\rY\u0014QP\u0005\u0004\u0003\u007fb$aA%oi\"9\u00111\u0011\fA\u0002\u0005m\u0014AC7bqJ+7m\u001c:eg\"I\u0011q\u0011\f\u0011\u0002\u0003\u0007\u0011\u0011R\u0001\u0019o\u0006LGOR8s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007cA\u001e\u0002\f&\u0019\u0011Q\u0012\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0013\f\u0011\u0002\u0003\u0007\u00111S\u0001\u000ba\u0006LHn\\1e\u001fB$\b\u0003B\u001e\u0002\u0016\u0012K1!a&=\u0005\u0019y\u0005\u000f^5p]\u0006y\u0002O]8ek\u000e,WK\u001c;jYRC'o\u001c;uY\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u%\u0006BAE\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Wc\u0014AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001 aJ|G-^2f+:$\u0018\u000e\u001c+ie>$H\u000f\\3eI\u0011,g-Y;mi\u0012\u001aTCAA[U\u0011\t\u0019*a(\u0002+\r|gn];nKVsG/\u001b7UQJ|G\u000f\u001e7fIR1\u00111PA^\u0003{Cq!a!\u001a\u0001\u0004\tY\bC\u0005\u0002\bf\u0001\n\u00111\u0001\u0002\n\u0006y2m\u001c8tk6,WK\u001c;jYRC'o\u001c;uY\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0002\u000bE,x\u000e^1\u0015\u0011\u0005\u0015\u0017\u0011[An\u0003;\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017L\u0016aB7fiJL7m]\u0005\u0005\u0003\u001f\fIMA\u0003Rk>$\u0018\rC\u0004\u0002Tn\u0001\r!!6\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0007\u0019\f9.C\u0002\u0002Z\u001e\u0014!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\"9\u0011qJ\u000eA\u0002\u0005M\u0003BBA;7\u0001\u0007A)\u0001\u0014wKJLg-\u001f+ie>$H\u000f\\3US6,'+Z9vKN$8\t[1o]\u0016dW*\u001a;sS\u000e$\"\"a\r\u0002d\u0006M\u0018q_A}\u0011\u001d\t)\u000f\ba\u0001\u0003O\fa!\u00199j\u0017\u0016L\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055\u0018,\u0001\u0005qe>$xnY8m\u0013\u0011\t\t0a;\u0003\u000f\u0005\u0003\u0018nS3zg\"1\u0011Q\u001f\u000fA\u0002\u0011\u000b\u0001#\\3ue&\u001cg*Y7f'V4g-\u001b=\t\r\u0005UD\u00041\u0001E\u0011\u001d\tY\u0010\ba\u0001\u0003\u0013\u000ba\"\u001a=qK\u000e$H\u000b\u001b:piRdW-A\u000bwKJLg-\u001f)s_\u0012,8-\u001a+ie>$H\u000f\\3\u0015\u0011\u0005M\"\u0011\u0001B\u0002\u0005\u000fAq!a?\u001e\u0001\u0004\tI\tC\u0005\u0003\u0006u\u0001\n\u00111\u0001\u0002\n\u0006\u0011b/\u001a:jMf\u001cE.[3oi6+GO]5d\u0011%\u0011I!\bI\u0001\u0002\u0004\tI)\u0001\u000ewKJLg-\u001f*fcV,7\u000f^\"iC:tW\r\\'fiJL7-A\u0010wKJLg-\u001f)s_\u0012,8-\u001a+ie>$H\u000f\\3%I\u00164\u0017-\u001e7uII\nqD^3sS\u001aL\bK]8ek\u000e,G\u000b\u001b:piRdW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003U1XM]5gs\u000e{gn];nKRC'o\u001c;uY\u0016$\u0002\"a\r\u0003\u0014\tU!q\u0003\u0005\b\u0003w\u0004\u0003\u0019AAE\u0011%\u0011)\u0001\tI\u0001\u0002\u0004\tI\tC\u0005\u0003\n\u0001\u0002\n\u00111\u0001\u0002\n\u0006yb/\u001a:jMf\u001cuN\\:v[\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001a\u0002?Y,'/\u001b4z\u0007>t7/^7f)\"\u0014x\u000e\u001e;mK\u0012\"WMZ1vYR$3'\u0001\rwKJLg-\u001f+ie>$H\u000f\\3US6,W*\u001a;sS\u000e$\u0002\"a\r\u0003\"\t-\"Q\u0006\u0005\b\u0005G\u0019\u0003\u0019\u0001B\u0013\u0003%\tXo\u001c;b)f\u0004X\rE\u0002g\u0005OI1A!\u000bh\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u0004\u0002v\r\u0002\r\u0001\u0012\u0005\b\u0003w\u001c\u0003\u0019AAE\u0003I!\bN]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0015\r\tM\"\u0011\bB\u001e!\rA&QG\u0005\u0004\u0005oI&AC'fiJL7MT1nK\"9!1\u0005\u0013A\u0002\t\u0015\u0002BBA;I\u0001\u0007A)\u0001\buQJ|G\u000f\u001e7f\u001b\u0016$(/[2\u0015\r\t\u0005#q\tB%!\u0011\t9Ma\u0011\n\t\t\u0015\u0013\u0011\u001a\u0002\f\u0017\u000647.Y'fiJL7\rC\u0004\u0003$\u0015\u0002\rA!\n\t\r\u0005UT\u00051\u0001E\u0003\t\u0012'o\\6feJ+\u0017/^3ti6+GO]5dgRC'o\u001c;uY\u0016$\u0016.\\3NgR)!Ka\u0014\u0003R!9\u0011Q\u001d\u0014A\u0002\u0005\u001d\bBBA{M\u0001\u0007A)A\nfq\u0016l\u0007\u000f\u001e*fcV,7\u000f^'fiJL7-\u0006\u0002\u0003B\u00051c/\u001a:jMf\u0004&o\u001c3vG\u0016\u00148\t\\5f]R$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\t\u0005M\"1\f\u0005\b\u0003wD\u0003\u0019AAE\u0003\u00192XM]5gs\u000e{gn];nKJ\u001cE.[3oiRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u000b\u0007\u0003g\u0011\tGa\u0019\t\u000f\u0005m\u0018\u00061\u0001\u0002\n\"I!QM\u0015\u0011\u0002\u0003\u0007!qM\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nKB!1(!&S\u0003A2XM]5gs\u000e{gn];nKJ\u001cE.[3oiRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u000e\u0016\u0005\u0005O\ny*A\tdY&,g\u000e^)v_R\fWI\u001c;jif$bAa\u001d\u0003~\t\u0005\u0005\u0003\u0002B;\u0005sj!Aa\u001e\u000b\u0007\u0005\u0005\u0017,\u0003\u0003\u0003|\t]$!E\"mS\u0016tG/U;pi\u0006,e\u000e^5us\"9!qP\u0016A\u0002\u0005M\u0015\u0001B;tKJDq!!\u001e,\u0001\u0004\t\u0019*A\u000bdY&,g\u000e^)v_R\f\u0017\t\u001c;fe\u0006$\u0018n\u001c8\u0015\u0015\t\u001d%Q\u0012BI\u0005+\u00139\n\u0005\u0003\u0003v\t%\u0015\u0002\u0002BF\u0005o\u0012Qc\u00117jK:$\u0018+^8uC\u0006cG/\u001a:bi&|g\u000eC\u0004\u0003\u00102\u0002\rAa\u001d\u0002\u0017E,x\u000e^1F]RLG/\u001f\u0005\b\u0003wa\u0003\u0019\u0001BJ!\u0015Y\u0014QSA\u001f\u0011\u001d\t)\u0005\fa\u0001\u0005'Cq!!\u0013-\u0001\u0004\u00119'A\tbYR,'o\u00117jK:$\u0018+^8uCN$B!a\r\u0003\u001e\"9!qT\u0017A\u0002\t\u0005\u0016\u0001E9v_R\f\u0017\t\u001c;fe\u0006$\u0018n\u001c8t!\u0015Y$1\u0015BD\u0013\r\u0011)\u000b\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0014AE<bSR4uN])v_R\fW\u000b\u001d3bi\u0016$\"\"a\r\u0003,\n5&q\u0016BY\u0011\u001d\tYD\fa\u0001\u0003{Aq!!\u0012/\u0001\u0004\ti\u0004\u0003\u0004\u0002J9\u0002\rA\u0015\u0005\bQ:\u0002\n\u00111\u0001f\u0003q9\u0018-\u001b;G_J\fVo\u001c;b+B$\u0017\r^3%I\u00164\u0017-\u001e7uIQ*\"Aa.+\u0007\u0015\fy\n")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaBroker leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final Consumer<byte[], byte[]> consumer;
    private final Admin adminClient;

    public static double metricValue(org.apache.kafka.common.Metric metric) {
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static String DefaultEntity() {
        return QuotaTestClients$.MODULE$.DefaultEntity();
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract KafkaPrincipal userPrincipal();

    public abstract Map<String, String> quotaMetricTags(String var1);

    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion, Option<String> payloadOpt) {
        boolean throttled;
        IntRef numProduced = IntRef.create((int)0);
        do {
            byte[] payload = ((String)payloadOpt.getOrElse((Function0 & Serializable)() -> Integer.toString(numProduced$1.elem))).getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced.elem;
            do {
                boolean bl;
                KafkaMetric metric;
                if ((metric = this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId)) != null) {
                    if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                        bl = true;
                        continue;
                    }
                }
                bl = throttled = false;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced.elem < maxRecords && !throttled);
        return numProduced.elem;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    public Option<String> produceUntilThrottled$default$3() {
        return None$.MODULE$;
    }

    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        boolean throttled;
        long timeoutMs = TimeUnit.MINUTES.toMillis(1L);
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        long startMs = System.currentTimeMillis();
        do {
            boolean bl;
            numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            KafkaMetric metric = this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId);
            if (metric != null) {
                if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                    bl = true;
                    continue;
                }
            }
            bl = throttled = false;
        } while (numConsumed < maxRecords && !throttled && System.currentTimeMillis() < startMs + timeoutMs);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            long startMs2 = System.currentTimeMillis();
            while (numConsumed < minRecords && System.currentTimeMillis() < startMs2 + timeoutMs) {
                numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            }
        }
        return numConsumed;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    private Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    private void verifyThrottleTimeRequestChannelMetric(ApiKeys apiKey, String metricNameSuffix, String clientId, boolean expectThrottle) {
        double throttleTimeMs = this.brokerRequestMetricsThrottleTimeMs(apiKey, metricNameSuffix);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(44).append("Client with id=").append(clientId).append(" should have been throttled, ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((double)0.0, (double)throttleTimeMs, (double)0.0, (String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString());
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.PRODUCE, "", this.producerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
            return;
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public boolean verifyProduceThrottle$default$3() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.FETCH, "Consumer", this.consumerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
            return;
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public boolean verifyConsumeThrottle$default$3() {
        return true;
    }

    private void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        KafkaMetric metricValue_metric = this.throttleMetric(quotaType, clientId);
        Object var6_4 = null;
        double throttleMetricValue = BoxesRunTime.unboxToDouble((Object)metricValue_metric.metricValue());
        if (expectThrottle) {
            Assertions.assertTrue((throttleMetricValue > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Client with id=").append(clientId).append(" should have been throttled").toString());
            return;
        }
        Assertions.assertTrue((boolean)Double.isNaN(throttleMetricValue), (String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString());
    }

    private MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        return this.leaderNode.metrics().metricName("throttle-time", quotaType.toString(), CollectionConverters$.MODULE$.MapHasAsJava(this.quotaMetricTags(clientId)).asJava());
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    private double brokerRequestMetricsThrottleTimeMs(ApiKeys apiKey, String metricNameSuffix) {
        return QuotaTestClients.yammerMetricValue$1(new StringBuilder(62).append("kafka.network:type=RequestMetrics,name=ThrottleTimeMs,request=").append(apiKey.name).append(metricNameSuffix).toString());
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", "Request", "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0, (String)"Should not have been throttled");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable)max -> Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()) <= max ? 1 : 0) != 0, (String)new StringBuilder(36).append("Maximum consumer throttle too high: ").append(BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue())).toString()));
            return;
        }
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0, (String)"Should not have been throttled");
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public ClientQuotaEntity clientQuotaEntity(Option<String> user2, Option<String> clientId2) {
        ObjectRef entries = ObjectRef.create((Object)((Map)Map$.MODULE$.empty()));
        user2.foreach((Function1 & Serializable)user -> {
            entries.elem = (Map)((Map)entries.elem).$plus$plus((IterableOnce)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user)})));
            return BoxedUnit.UNIT;
        });
        clientId2.foreach((Function1 & Serializable)clientId -> {
            entries.elem = (Map)((Map)entries.elem).$plus$plus((IterableOnce)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)})));
            return BoxedUnit.UNIT;
        });
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)entries.elem).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClientQuotaAlteration clientQuotaAlteration(ClientQuotaEntity quotaEntity, Option<Object> producerQuota, Option<Object> consumerQuota, Option<Object> requestQuota) {
        void addOp$1_value;
        void addOp$1_value2;
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Option option = producerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable)x$5 -> x$5);
        String addOp$1_key = "producer_byte_rate";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key, (Double)addOp$1_value2.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var5_7 = null;
        option = null;
        Option option2 = consumerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable)x$6 -> x$6);
        String addOp$1_key2 = "consumer_byte_rate";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key2, (Double)addOp$1_value.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var7_9 = null;
        option2 = null;
        String addOp$1_key3 = "request_percentage";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key3, (Double)requestQuota.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var9_10 = null;
        return new ClientQuotaAlteration(quotaEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)seq).asJava());
    }

    public void alterClientQuotas(scala.collection.immutable.Seq<ClientQuotaAlteration> quotaAlterations) {
        this.adminClient().alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(quotaAlterations).asJava()).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaBroker server) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                QuotaTestClients.$anonfun$waitForQuotaUpdate$1(this, server, producerQuota, consumerQuota, requestQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var14_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public KafkaBroker waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public static final /* synthetic */ boolean $anonfun$brokerRequestMetricsThrottleTimeMs$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith(name$1);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final double yammerMetricValue$1(String name) {
        void var3_3;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaTestClients.$anonfun$brokerRequestMetricsThrottleTimeMs$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$4 -> x$4.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var3_3 instanceof Meter) {
            return ((Meter)var3_3).count();
        }
        if (var3_3 instanceof Histogram) {
            return ((Histogram)var3_3).max();
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var3_3.getClass()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyProducerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyProducerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        return new StringBuilder(47).append("Producer throttle metric not updated: avg=").append(BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue())).append(" max=").append(BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        return new StringBuilder(47).append("Consumer throttle metric not updated: avg=").append(BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue())).append(" max=").append(BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue())).toString();
    }

    public static final /* synthetic */ Double $anonfun$clientQuotaAlteration$1(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    private static final void addOp$1(String key, Option value, ObjectRef ops$1) {
        ops$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)ops$1.elem).$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForQuotaUpdate$1(QuotaTestClients $this, KafkaBroker server$1, long producerQuota$1, long consumerQuota$1, double requestQuota$1) {
        void quota_clientId;
        void quota_userPrincipal;
        void quota_clientId2;
        void quota_userPrincipal2;
        void quota_clientId3;
        void quota_userPrincipal3;
        void quota_clientId4;
        void quota_userPrincipal4;
        QuotaFactory.QuotaManagers quotaManagers = server$1.dataPlaneRequestProcessor().quotas();
        String string = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager = quotaManagers.produce();
        Object var17_8 = null;
        kafkaPrincipal = null;
        string = null;
        Quota overrideProducerQuota = quota_quotaManager.quota((KafkaPrincipal)quota_userPrincipal4, (String)quota_clientId4);
        String string2 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal2 = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager2 = quotaManagers.fetch();
        Object var20_12 = null;
        kafkaPrincipal2 = null;
        string2 = null;
        Quota overrideConsumerQuota = quota_quotaManager2.quota((KafkaPrincipal)quota_userPrincipal3, (String)quota_clientId3);
        String string3 = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal3 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager3 = quotaManagers.request();
        Object var23_16 = null;
        kafkaPrincipal3 = null;
        string3 = null;
        Quota overrideProducerRequestQuota = quota_quotaManager3.quota((KafkaPrincipal)quota_userPrincipal2, (String)quota_clientId2);
        String string4 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal4 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager4 = quotaManagers.request();
        Object var26_20 = null;
        kafkaPrincipal4 = null;
        string4 = null;
        Quota overrideConsumerRequestQuota = quota_quotaManager4.quota((KafkaPrincipal)quota_userPrincipal, (String)quota_clientId);
        double upperBound_upperBound = producerQuota$1;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)new StringBuilder(43).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have producer quota").toString());
        double upperBound_upperBound2 = consumerQuota$1;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)new StringBuilder(43).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have consumer quota").toString());
        Assertions.assertEquals((Object)new Quota(requestQuota$1, true), (Object)overrideProducerRequestQuota, (String)new StringBuilder(42).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString());
        Assertions.assertEquals((Object)new Quota(requestQuota$1, true), (Object)overrideConsumerRequestQuota, (String)new StringBuilder(42).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString());
    }

    public QuotaTestClients(String topic, KafkaBroker leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer, Admin adminClient) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
        this.adminClient = adminClient;
    }
}

