/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.test.ValuelessCallable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t5g\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005R)Bq!\r\u0001A\u0002\u0013\u0005!\u0007C\u0004A\u0001\u0001\u0007I\u0011A!\t\r\u001d\u0003\u0001\u0015)\u00034\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002(\u0002!I!!+\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005[\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000bBqAa\u0015\u0001\t\u0003\u0011)\u0006C\u0004\u0003^\u0001!\tAa\u0018\t\u000f\tu\u0003\u0001\"\u0001\u0003l!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BO\u0001\u0011\u0005!q\u0014\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u00119\f\u0001C\u0005\u0005s\u0013qDU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8J]R,wM]1uS>tG+Z:u\u0015\tib$A\u0002ba&T\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0005\u0005\u0002$I5\tA$\u0003\u0002&9\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u00111\u0005A\u0001\fEJ|7.\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/F\u00014!\t!d(D\u00016\u0015\t1t'A\u0003bI6LgN\u0003\u00029s\u000591\r\\5f]R\u001c(BA\u0010;\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\n\u0005}*$AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011!)\u0012\t\u0003Y\rK!\u0001R\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\r\u0012\t\t\u00111\u00014\u0003\rAH%M\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0005*CQa\u0013\u0004A\u00021\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u001bNk\u0011A\u0014\u0006\u0003;=S!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!\u000bP\u0001\u0006UVt\u0017\u000e^\u0005\u0003):\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\rY\u0003\"!T,\n\u0005as%A\u0003\"fM>\u0014X-R1dQ\u0006\u0011C/Z:u\u000bb\u001cG.^:j_:\u001c%/Z1uKR{\u0007/[2WC2LG-\u0019;j_:$\"AQ.\t\u000bq;\u0001\u0019A/\u0002\rE,xN];n!\tqVM\u0004\u0002`GB\u0011\u0001-L\u0007\u0002C*\u0011!\rI\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011l\u0013A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z\u0017)\t\u001dIw\u000e\u001d\t\u0003U6l\u0011a\u001b\u0006\u0003Y>\u000ba\u0001]1sC6\u001c\u0018B\u00018l\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001r\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\"\"qa]={!\t!x/D\u0001v\u0015\t18.\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tAXOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003wv\f\u0013\u0001`\u0001\u0003u.\f\u0013A`\u0001\u0006WJ\fg\r^\u0001(i\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8De\u0016\fG/\u001a)beRLG/[8ogZ\u000bG.\u001b3bi&|g\u000eF\u0002C\u0003\u0007AQ\u0001\u0018\u0005A\u0002uCC\u0001C5pa\"*\u0001b]=\u0002\n1\u001210`\u0001\u001ai\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fF\u0002C\u0003\u001fAQ\u0001X\u0005A\u0002uCC!C5pa\"*\u0011b]=\u0002\u00161\u001210`\u0001\u001ai\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8Ba&\u001cV-\\1oi&\u001c7\u000fF\u0002C\u00037AQ\u0001\u0018\u0006A\u0002uCCAC5pa\"*!b]=\u0002\"1\u001210`\u0001$i\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8Bi>l\u0017nY5us\u0006sG-\u0012:s_J\u001c\u0015m]3t)\r\u0011\u0015q\u0005\u0005\u00069.\u0001\r!\u0018\u0015\u0005\u0017%|\u0007\u000fK\u0003\fgf\fi\u0003\f\u0002|{\u0006)B/Z:u\u000bb\u001cG.^:j_:4\u0015-\u001b7pm\u0016\u0014Hc\u0001\"\u00024!)A\f\u0004a\u0001;\"\"A\"[8qQ\u0015a1/_A\u001dY\u0005i\u0018aF1tg\u0016\u0014H/\u00113nS:\u001cE.[3oiRC'o\\<t+\u0011\ty$!\u001d\u0015\t\u0005\u0005\u0013q\u0013\u000b\u0007\u0003\u0007\ni&a!\u0011\t\u0005\u0015\u0013q\u000b\b\u0005\u0003\u000f\n\tF\u0004\u0003\u0002J\u00055cb\u00011\u0002L%\tQ(C\u0002\u0002Pq\n\u0011b]2bY\u0006$Xm\u001d;\n\t\u0005M\u0013QK\u0001\ba\u0006\u001c7.Y4f\u0015\r\ty\u0005P\u0005\u0005\u00033\nYFA\u0005BgN,'\u000f^5p]*!\u00111KA+\u0011\u001d\ty&\u0004a\u0002\u0003C\n\u0001b\u00197bgN$\u0016m\u001a\t\u0007\u0003G\nI'!\u001c\u000e\u0005\u0005\u0015$bAA4[\u00059!/\u001a4mK\u000e$\u0018\u0002BA6\u0003K\u0012\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003_\n\t\b\u0004\u0001\u0005\u000f\u0005MTB1\u0001\u0002v\t\tA+\u0005\u0003\u0002x\u0005u\u0004c\u0001\u0017\u0002z%\u0019\u00111P\u0017\u0003\u000f9{G\u000f[5oOB\u0019A&a \n\u0007\u0005\u0005UF\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0003\u000bk\u00019AAD\u0003\r\u0001xn\u001d\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0019\u0019x.\u001e:dK*\u0019\u0011\u0011\u0013\u001f\u0002\u0013M\u001c\u0017\r\\1di&\u001c\u0017\u0002BAK\u0003\u0017\u0013\u0001\u0002U8tSRLwN\u001c\u0005\t\u00033kA\u00111\u0001\u0002\u001c\u0006\ta\rE\u0003-\u0003;\u000b\t+C\u0002\u0002 6\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004Y\u0005\r\u0016bAAS[\t\u0019\u0011I\\=\u0002/Y,'/\u001b4z\u000bb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>tGc\u0002\"\u0002,\u00065\u0017\u0011\u001b\u0005\b\u0003[s\u0001\u0019AAX\u0003=)\u0007p\u00197vg&|gNU3tk2$\b\u0003BAY\u0003\u000ftA!a-\u0002D:!\u0011QWAa\u001d\u0011\t9,a0\u000f\t\u0005e\u0016Q\u0018\b\u0005\u0003\u0013\nY,\u0003\u0002<y%\u0011qDO\u0005\u0003qeJ!AN\u001c\n\u0007\u0005\u0015W'\u0001\u0012BYR,'O\u0011:pW\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:SKN,H\u000e^\u0005\u0005\u0003\u0013\fYM\u0001\tFq\u000edWo]5p]N\u0014Vm];mi*\u0019\u0011QY\u001b\t\r\u0005=g\u00021\u0001,\u0003!\u0011'o\\6fe&#\u0007bBAj\u001d\u0001\u0007\u0011Q[\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003!\u0001(o\u001c;pG>d'bAAps\u000511m\\7n_:LA!a9\u0002Z\n1QI\u001d:peN\f1$Y:tKJ$8+^2dKN\u001ch-\u001e7BYR,'OU3tk2$H#\u0002\"\u0002j\u0006E\bbBAv\u001f\u0001\u0007\u0011Q^\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\t\u0005=\u0018q\u0019\b\u0004i\u0005\r\u0007bBAz\u001f\u0001\u0007\u0011Q_\u0001\be\u0016\f7o\u001c8t!\u0015\t90a@^\u001d\u0011\tI0!@\u000f\u0007\u0001\fY0C\u0001/\u0013\r\t\u0019&L\u0005\u0005\u0005\u0003\u0011\u0019A\u0001\u0003MSN$(bAA*[\u0005Y1M]3bi\u0016$v\u000e]5d)\u001d\u0011%\u0011\u0002B\t\u0005+Aa!\r\tA\u0002\t-\u0001c\u0001\u001b\u0003\u000e%\u0019!qB\u001b\u0003\u000b\u0005#W.\u001b8\t\r\tM\u0001\u00031\u0001^\u0003%!x\u000e]5d\u001d\u0006lW\rC\u0004\u0003\u0018A\u0001\rA!\u0007\u0002\u001fQ|\u0007/[2BgNLwM\\7f]R\u0004rAa\u0007\u0003&-\u0012I#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003%IW.\\;uC\ndWMC\u0002\u0003$5\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119C!\b\u0003\u00075\u000b\u0007\u000fE\u0003\u0003\u001c\t-2&\u0003\u0003\u0003\u0002\tu\u0011\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)%\u0011%\u0011\u0007B\u001a\u0005k\u0011I\u0004\u0003\u00042#\u0001\u0007!1\u0002\u0005\u0007\u0005'\t\u0002\u0019A/\t\r\t]\u0012\u00031\u0001,\u0003]qWm\u001e+pi\u0006d7i\\;oiB\u000b'\u000f^5uS>t7\u000fC\u0004\u0003<E\u0001\rA!\u0007\u0002'A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0015\u000f\t\u0013yD!\u0011\u0003D!1\u0011G\u0005a\u0001\u0005\u0017AaAa\u0005\u0013\u0001\u0004i\u0006B\u0002B\u001c%\u0001\u00071\u0006F\u0005C\u0005\u000f\u0012IEa\u0013\u0003P!1\u0011g\u0005a\u0001\u0005\u0017AaAa\u0005\u0014\u0001\u0004i\u0006B\u0002B''\u0001\u00071&A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0005#\u001a\u0002\u0019A\u0016\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'/A\fwC2LG-\u0019;f)>\u0004\u0018nY!tg&<g.\\3oiR)!Ia\u0016\u0003Z!1!1\u0003\u000bA\u0002uCqAa\u0017\u0015\u0001\u0004\u0011I\"A\nfqB,7\r^3e\u0003N\u001c\u0018n\u001a8nK:$8/A\u000ewC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\b\u0005\n\u0005$1\rB4\u0011\u0019\u0011\u0019\"\u0006a\u0001;\"1!QM\u000bA\u0002-\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\t%T\u00031\u0001\u0003*\u0005\u0011R\r\u001f9fGR,G-Q:tS\u001etW.\u001a8u)\u001d\u0011%Q\u000eB<\u0005sBqAa\u001c\u0017\u0001\u0004\u0011\t(\u0001\tu_BL7\rR3tGJL\u0007\u000f^5p]B\u0019AGa\u001d\n\u0007\tUTG\u0001\tU_BL7\rR3tGJL\u0007\u000f^5p]\"1!Q\r\fA\u0002-BqA!\u001b\u0017\u0001\u0004\u0011I#A\u0007xC&$hi\u001c:BgN,'\u000f\u001e\u000b\b\u0005\n}$q\u0012BM\u0011\u001d\u0011\ti\u0006a\u0001\u0005\u0007\u000bQ\u0002^3ti\u000e{g\u000eZ5uS>t\u0007\u0003\u0002BC\u0005\u0017k!Aa\"\u000b\u0007\t%\u0015(\u0001\u0003uKN$\u0018\u0002\u0002BG\u0005\u000f\u0013Q\u0002V3ti\u000e{g\u000eZ5uS>t\u0007b\u0002BI/\u0001\u0007!1S\u0001\n[\u0006Dx+Y5u\u001bN\u00042\u0001\fBK\u0013\r\u00119*\f\u0002\u0005\u0019>tw\r\u0003\u0004\u0003\u001c^\u0001\r!X\u0001\u0011G>tG-\u001b;j_:$U\r^1jYN\fQE^1mS\u0012\fG/\u001a+pa&\u001cGi\\3t]R\u001c\u0006/\u00198Fq\u000edW\u000fZ3e\u0005J|7.\u001a:\u0015\u000f\t\u0013\tKa)\u0003.\"1!1\u0003\rA\u0002uCqA!*\u0019\u0001\u0004\u00119+A\tfq\u000edW\u000fZ3e\u0005J|7.\u001a:JIN\u0004BA\u0018BUW%\u0019!1V4\u0003\u0007M+G\u000f\u0003\u0004\u00030b\u0001\raK\u0001\u0016Kb\u0004Xm\u0019;fI:+X\u000eU1si&$\u0018n\u001c8t\u00035!Wm]2sS\n,Gk\u001c9jGR!!\u0011\u000fB[\u0011\u0019\u0011\u0019\"\u0007a\u0001;\u0006A!/Z1tg&<g\u000eF\u0003C\u0005w\u00139\rC\u0004\u0003>j\u0001\rAa0\u0002\u0005Q\u0004\b\u0003\u0002Ba\u0005\u0007l!!!8\n\t\t\u0015\u0017Q\u001c\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011IM\u0007a\u0001\u0005\u0017\fa\u0002^1sO\u0016$(+\u001a9mS\u000e\f7\u000fE\u0003\u0002x\u0006}8\u0006")
public class ReplicaExclusionIntegrationTest
extends IntegrationTestHarness {
    private ConfluentAdmin adminClient = null;

    @Override
    public int brokerCount() {
        return 3;
    }

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(ConfluentAdmin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionCreateTopicValidation(String quorum) {
        String topicName = "topic";
        int p0 = 0;
        int p1 = 1;
        int p2 = 2;
        int excludedBrokerId = 0;
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, excludedBrokerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, excludedBrokerId, 1})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1})))}));
        this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        this.validateTopicAssignment(topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        String secondTopic = new StringBuilder(2).append(topicName).append("-2").toString();
        this.createTopic((Admin)this.adminClient(), secondTopic, 5, 2);
        this.validateTopicDoesntSpanExcludedBroker(secondTopic, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 5);
        String thirdTopic = new StringBuilder(2).append(topicName).append("-3").toString();
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount()), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount());
        this.createTopic((Admin)this.adminClient(), "fourthTopic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionCreatePartitionsValidation(String quorum) {
        String rf3Topic = "rf-3-topic";
        String rf2Topic = "rf-2-topic";
        int newP3 = 3;
        int newP4 = 4;
        int newPartitionCount = 5;
        int excludedBrokerId = 0;
        this.createTopic((Admin)this.adminClient(), rf3Topic, 3, 3);
        this.createTopic((Admin)this.adminClient(), rf2Topic, 3, 2);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP3)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP4)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.createTopic((Admin)this.adminClient(), "rf-2-topic-2", 3, 2);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 3);
        this.createPartitions((Admin)this.adminClient(), "rf-2-topic-2", 20);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 20);
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount);
        this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionReassignment(String quorum) {
        String topic = "reassignment-topic";
        int excludedBrokerId = 0;
        TopicPartition tp = new TopicPartition(topic, 0);
        this.createTopic((Admin)this.adminClient(), topic, (scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1})))}))));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        ObjectRef newAssignment = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId}))));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        newAssignment.elem = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        List invalidAssignment = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.reassign(tp, (List<Object>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deletionResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deletionResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.reassign(tp, (List<Object>)invalidAssignment);
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)invalidAssignment);
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append(invalidAssignment).toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionApiSemantics(String quorum) {
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4101})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$))));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$))));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionAtomicityAndErrorCases(String quorum) {
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-10)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(UnrepresentableBrokerIdException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance=maintenance=][]asmaintenancemaintenancemaintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(InvalidBrokerReplicaExclusionException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)2, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 1, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected replica exclusion to be applied");
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)3, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 10, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        this.verifyExpectedException(result, 11, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testExclusionFailover(String quorum) {
        int b2;
        IntRef b1 = IntRef.create((int)-1);
        if (this.isKRaftTest()) {
            b1.elem = ((KafkaBroker)this.brokers().head()).config().brokerId();
            b2 = ((KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$1(b1, s)))).head()).config().brokerId();
        } else {
            b1.elem = ((KafkaServer)this.servers().head()).config().brokerId();
            b2 = ((KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$2(b1, s)))).head()).config().brokerId();
        }
        List excludedBrokers = (List)((StrictOptimizedSeqOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{b1.elem, b2}))).sorted((Ordering)Ordering.Int$.MODULE$);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b1.elem)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)));
        ObjectRef describedExclusions = ObjectRef.create(null);
        ValuelessCallable retryOnExceptionWithTimeout_runnable = () -> {
            describedExclusions$1.elem = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
            Assertions.assertEquals((int)2, (int)((java.util.List)describedExclusions$1.elem).size());
            Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describedExclusions$1.elem).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
            Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describedExclusions$1.elem).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        };
        TestUtils.retryOnExceptionWithTimeout((long)15000L, (long)100L, (ValuelessCallable)retryOnExceptionWithTimeout_runnable);
        Object var7_7 = null;
        if (this.isKRaftTest()) {
            this.restartController();
        } else {
            this.getController().shutdown();
        }
        ValuelessCallable retryOnExceptionWithTimeout_runnable2 = () -> {
            describedExclusions$1.elem = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
            Assertions.assertEquals((int)2, (int)((java.util.List)describedExclusions$1.elem).size());
            Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describedExclusions$1.elem).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
            Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describedExclusions$1.elem).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        };
        TestUtils.retryOnExceptionWithTimeout((long)15000L, (long)100L, (ValuelessCallable)retryOnExceptionWithTimeout_runnable2);
        Object var8_8 = null;
        excludedBrokers.foreach((Function1 & Serializable)excludedBroker -> ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$9(this, BoxesRunTime.unboxToInt((Object)excludedBroker)));
    }

    public <T> Assertion assertAdminClientThrows(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> {
            try {
                return f.apply();
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, classTag, pos);
    }

    private void verifyExpectedException(AlterBrokerReplicaExclusionsResult.ExclusionsResult exclusionResult, int brokerId, Errors error) {
        java.util.Map exclusionsByBroker = exclusionResult.exclusionResultByBroker();
        Assertions.assertTrue((boolean)exclusionsByBroker.containsKey(BoxesRunTime.boxToInteger((int)brokerId)), (String)new StringBuilder(44).append("Expected exclusions by broker (").append(exclusionsByBroker).append(") to contain ").append(brokerId).toString());
        Optional brokerErrorOpt = ((ExclusionOpResult)exclusionsByBroker.get(BoxesRunTime.boxToInteger((int)brokerId))).errorOpt();
        Assertions.assertTrue((boolean)brokerErrorOpt.isPresent(), (String)new StringBuilder(56).append("Expected broker ").append(brokerId).append(" to have an exception with its exclusion").toString());
        Exception receivedException = ((ExclusionOperationError)brokerErrorOpt.get()).exception();
        ApiException expectedException = error.exception();
        Assertions.assertTrue((boolean)expectedException.getClass().isInstance(receivedException), (String)new StringBuilder(60).append("Expected broker ").append(brokerId).append("'s exception to be of type ").append(expectedException.getClass()).append(", instead it was ").append(receivedException).toString());
    }

    private void assertSuccessfulAlterResult(AlterBrokerReplicaExclusionsResult.ExclusionsResult result, List<String> reasons) {
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)new StringBuilder(53).append("Expected result ").append(result).append(" to have been applied, but it was not").toString());
        scala.collection.mutable.Map resultByBroker = CollectionConverters$.MODULE$.MapHasAsScala(result.exclusionResultByBroker()).asScala();
        Assertions.assertTrue((boolean)resultByBroker.values().forall((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$assertSuccessfulAlterResult$1(r))), (String)new StringBuilder(69).append("Expected no exclusion results to have errors, but instead found some ").append(resultByBroker).toString());
        Assertions.assertEquals(reasons, (Object)((IterableOnceOps)resultByBroker.values().map((Function1 & Serializable)value -> value.reason())).toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                List value = (List)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value.map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)))).asJava());
            }
            throw new MatchError(null);
        })).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions, scala.collection.immutable.Map<Object, List<Object>> partitionAssignment) {
        java.util.List newAssignments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)partitionAssignment.toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)x$2._2()).map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createPartitions$3(BoxesRunTime.unboxToInt((Object)x)))).asJava())).asJava();
        adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions, (java.util.List)newAssignments))}))).asJava()).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions) {
        adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions))}))).asJava()).all().get();
    }

    public void createTopic(Admin adminClient, String topicName, int numPartitions, int replicationFactor) {
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, numPartitions, (short)replicationFactor))).all().get();
    }

    public void validateTopicAssignment(String topicName, scala.collection.immutable.Map<Object, List<Object>> expectedAssignments) {
        TopicDescription topicDescription = this.describeTopic(topicName);
        Assertions.assertEquals((int)topicDescription.partitions().size(), (int)expectedAssignments.size());
        expectedAssignments.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$validateTopicAssignment$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicAssignment$2(this, topicDescription, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void validatePartitionAssignment(String topicName, int partition, List<Object> expectedAssignment) {
        TopicDescription topicDescription = this.describeTopic(topicName);
        this.validatePartitionAssignment(topicDescription, partition, expectedAssignment);
    }

    public void validatePartitionAssignment(TopicDescription topicDescription, int partition, List<Object> expectedAssignment) {
        Assertions.assertTrue((topicDescription.partitions().size() > partition ? 1 : 0) != 0, (String)new StringBuilder(83).append("Topic description for topic ").append(topicDescription.name()).append(" did not have enough partitions - wanted ").append(partition).append(" but had only ").append(topicDescription.partitions().size()).toString());
        Assertions.assertEquals(expectedAssignment, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()))).toList());
    }

    private void waitForAssert(TestCondition testCondition, long maxWaitMs, String conditionDetails) {
        AtomicReference<String> failureReason = new AtomicReference<String>("");
        Supplier<String> waitForCondition_conditionDetailsSupplier = () -> new StringBuilder(28).append(conditionDetails).append(" ; last reason for failure: ").append((Object)(((String)failureReason.get()).isEmpty() ? "<empty>" : failureReason.get())).toString();
        TestUtils.waitForCondition(() -> {
            try {
                return testCondition.conditionMet();
            }
            catch (AssertionError err) {
                failureReason.set(((Throwable)((Object)err)).toString());
                return false;
            }
        }, (long)maxWaitMs, (long)100L, waitForCondition_conditionDetailsSupplier);
    }

    public void validateTopicDoesntSpanExcludedBroker(String topicName, Set<Object> excludedBrokerIds, int expectedNumPartitions) {
        ObjectRef topicDescription = ObjectRef.create(null);
        ValuelessCallable retryOnExceptionWithTimeout_runnable = () -> {
            topicDescription$2.elem = this.describeTopic(topicName);
            Assertions.assertEquals((int)expectedNumPartitions, (int)((TopicDescription)topicDescription$2.elem).partitions().size(), (String)new StringBuilder(41).append("Expected topic ").append(topicName).append(" to").append(" have ").append(expectedNumPartitions).append(" but instead got ").append(((TopicDescription)topicDescription$2.elem).partitions().size()).toString());
        };
        TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)100L, (ValuelessCallable)retryOnExceptionWithTimeout_runnable);
        Object var5_5 = null;
        CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)topicDescription.elem).partitions()).asScala().foreach((Function1 & Serializable)pInfo -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicDoesntSpanExcludedBroker$2(excludedBrokerIds, topicName, pInfo);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private TopicDescription describeTopic(String topicName) {
        TopicDescription topicDescription = null;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            try {
                topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(topicName)).topicNameValues().get(topicName)).get();
                bl = true;
            }
            catch (ExecutionException $anonfun$describeTopic$1_e) {
                if ($anonfun$describeTopic$1_e.getCause() != null && $anonfun$describeTopic$1_e.getCause() instanceof UnknownTopicOrPartitionException) {
                    bl = false;
                }
                throw $anonfun$describeTopic$1_e;
            }
            Object var8_6 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaExclusionIntegrationTest.$anonfun$describeTopic$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return topicDescription;
    }

    private void reassign(TopicPartition tp, List<Object> targetReplicas) {
        NewPartitionReassignment reassignment = new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)targetReplicas.map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$reassign$1(BoxesRunTime.unboxToInt((Object)x)))).asJava());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(reassignment))).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testExclusionFailover$1(IntRef b1$1, KafkaBroker s) {
        return s.config().brokerId() != b1$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testExclusionFailover$2(IntRef b1$1, KafkaServer s) {
        return s.config().brokerId() != b1$1.elem;
    }

    public static final /* synthetic */ Assertion $anonfun$testExclusionFailover$9(ReplicaExclusionIntegrationTest $this, int excludedBroker) {
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBroker})))}));
        return $this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.createTopic((Admin)$this.adminClient(), "topic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulAlterResult$1(ExclusionOpResult r) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.errorOpt())).isEmpty();
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createPartitions$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicAssignment$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$validateTopicAssignment$2(ReplicaExclusionIntegrationTest $this, TopicDescription topicDescription$1, Tuple2 x$3) {
        if (x$3 != null) {
            int partition = x$3._1$mcI$sp();
            List expectedAssignment = (List)x$3._2();
            $this.validatePartitionAssignment(topicDescription$1, partition, (List<Object>)expectedAssignment);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$validateTopicDoesntSpanExcludedBroker$2(Set excludedBrokerIds$1, String topicName$2, TopicPartitionInfo pInfo) {
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pInfo.replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()));
        Assertions.assertTrue((boolean)replicas.forall((Function1)(JFunction1.mcZI.sp & Serializable)r -> !excludedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)r))), (String)new StringBuilder(93).append("Expected replicas for ").append(topicName$2).append("-").append(pInfo.partition()).append(" to not include excluded brokers ").append(excludedBrokerIds$1).append(" but instead it had a replica set of ").append(replicas).toString());
    }

    public static final /* synthetic */ boolean $anonfun$describeTopic$1(ReplicaExclusionIntegrationTest $this, ObjectRef topicDescription$3, String topicName$3) {
        try {
            topicDescription$3.elem = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
            return true;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw e;
        }
    }

    public static final /* synthetic */ String $anonfun$describeTopic$2(String topicName$3) {
        return new StringBuilder(24).append("Failed describing topic ").append(topicName$3).toString();
    }

    public static final /* synthetic */ Integer $anonfun$reassign$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

