/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="bazel:size:large"), @Tag(value="bazel:shard_count:12")})
@ScalaSignature(bytes="\u0006\u0005\rEd\u0001B\u001e=\u0001\u0005CQA\u0012\u0001\u0005\u0002\u001dCQ!\u0013\u0001\u0005B)Cq!\u0015\u0001C\u0002\u0013\u0005!\n\u0003\u0004S\u0001\u0001\u0006Ia\u0013\u0005\b'\u0002\u0011\r\u0011\"\u0001K\u0011\u0019!\u0006\u0001)A\u0005\u0017\"9Q\u000b\u0001b\u0001\n\u0003Q\u0005B\u0002,\u0001A\u0003%1\nC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0011\u001d\u0011\u0007A1A\u0005\u0002aCaa\u0019\u0001!\u0002\u0013I\u0006b\u00023\u0001\u0005\u0004%\tA\u0013\u0005\u0007K\u0002\u0001\u000b\u0011B&\t\u000f\u0019\u0004!\u0019!C\u0001O\"9\u0011q\u0001\u0001!\u0002\u0013A\u0007\"CA\u0005\u0001\t\u0007I\u0011AA\u0006\u0011!\tY\u0002\u0001Q\u0001\n\u00055\u0001\"CA\u000f\u0001\t\u0007I\u0011AA\u0006\u0011!\ty\u0002\u0001Q\u0001\n\u00055\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003c\u0001A\u0011KA\u001a\u0011\u001d\t9\u0005\u0001C)\u0003\u0013Bq!a\u0013\u0001\t\u0003\t\u0019\u0003C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!a<\u0001\t\u0003\t\t\u0010C\u0004\u0002~\u0002!I!a@\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0014\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqA!\u0015\u0001\t\u0003\u0011\u0019\u0006C\u0004\u0003`\u0001!\tA!\u0019\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cCqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003L\u0002!\tA!4\t\u000f\te\u0007\u0001\"\u0001\u0003\\\"9!q\u001d\u0001\u0005\n\t%\bb\u0002B\u007f\u0001\u0011%!q \u0005\n\u0007\u0017\u0001\u0011\u0013!C\u0005\u0007\u001bA\u0011ba\t\u0001#\u0003%Ia!\n\t\u0013\r%\u0002!%A\u0005\n\r-\u0002bBB\u0018\u0001\u0011%1\u0011\u0007\u0005\b\u0007k\u0001A\u0011BB\u001c\u0011%\u0019\u0019\u0006AI\u0001\n\u0013\u0019)\u0006C\u0005\u0004Z\u0001\t\n\u0011\"\u0003\u0004V!I11\f\u0001\u0012\u0002\u0013%1Q\u0005\u0005\n\u0007;\u0002\u0011\u0013!C\u0005\u0007K\u0011\u0001\u0003\u0016:b]N\f7\r^5p]N$Vm\u001d;\u000b\u0005ur\u0014aA1qS*\tq(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0005CA\"E\u001b\u0005a\u0014BA#=\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001I!\t\u0019\u0005!A\u0006ce>\\WM]\"pk:$X#A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\u0007%sG/\u0001\u000eue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:D_VtG/A\u000eue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:D_VtG\u000fI\u0001\u001biJ\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u001ciJ\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002;9|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'oQ8v]R\faD\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002\rQ|\u0007/[22+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003Y!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cX#\u00015\u0011\u0007%t\u0007/D\u0001k\u0015\tYG.A\u0004nkR\f'\r\\3\u000b\u00055l\u0015AC2pY2,7\r^5p]&\u0011qN\u001b\u0002\u0007\u0005V4g-\u001a:\u0011\tE\\X0`\u0007\u0002e*\u00111\u000f^\u0001\taJ|G-^2fe*\u0011QO^\u0001\bG2LWM\u001c;t\u0015\tytO\u0003\u0002ys\u00061\u0011\r]1dQ\u0016T\u0011A_\u0001\u0004_J<\u0017B\u0001?s\u00055Y\u0015MZ6b!J|G-^2feB!AJ`A\u0001\u0013\tyXJA\u0003BeJ\f\u0017\u0010E\u0002M\u0003\u0007I1!!\u0002N\u0005\u0011\u0011\u0015\u0010^3\u0002/Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u0016\u0005\u00055\u0001\u0003B5o\u0003\u001f\u0001b!!\u0005\u0002\u0018ulXBAA\n\u0015\r\t)\u0002^\u0001\tG>t7/^7fe&!\u0011\u0011DA\n\u0005!\u0019uN\\:v[\u0016\u0014\u0018a\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0003eqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u000259|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0011\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN$\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b^\u0003\u0011)H/\u001b7\n\t\u0005=\u0012\u0011\u0006\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!D7pI&4\u0017pQ8oM&<7\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001'\u00028%\u0019\u0011\u0011H'\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003{1\u0002\u0019AA \u0003\u0015\u0001(o\u001c9t!\u0019\t\t%a\u0011\u0002&5\tA.C\u0002\u0002F1\u00141aU3r\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cHCAA \u0003-!x\u000e]5d\u0007>tg-[4\u0002\u000bM,G/\u00169\u0015\t\u0005U\u0012\u0011\u000b\u0005\b\u0003'J\u0002\u0019AA+\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA,\u0003Gj!!!\u0017\u000b\u0007u\nYF\u0003\u0003\u0002^\u0005}\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003CJ\u0018!\u00026v]&$\u0018\u0002BA3\u00033\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u00043\u0005%\u0004\u0003BA,\u0003WJA!!\u001c\u0002Z\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\"!!\u000e)\u0007i\t)\b\u0005\u0003\u0002X\u0005]\u0014\u0002BA=\u00033\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002+Q,7\u000f\u001e\"bg&\u001cGK]1og\u0006\u001cG/[8ogR1\u0011QGA@\u0003/Cq!!!\u001c\u0001\u0004\t\u0019)\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u000b\u000b\u0019J\u0004\u0003\u0002\b\u0006=\u0005cAAE\u001b6\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u0003\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u00126\u000ba\u0001\u0015:fI\u00164\u0017b\u00011\u0002\u0016*\u0019\u0011\u0011S'\t\u000f\u0005e5\u00041\u0001\u0002\u0004\u0006Y!/\u001a9mS\u000e\fG/[8oQ\u001dY\u0012QTAU\u0003W\u0003B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000bY&\u0001\u0004qCJ\fWn]\u0005\u0005\u0003O\u000b\tKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011QV\u0001)w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhF]3qY&\u001c\u0017\r^5p]vZ\u0018' \u0015\b7\u0005E\u0016QXA`!\u0011\t\u0019,!/\u000e\u0005\u0005U&\u0002BA\\\u0003C\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003w\u000b)L\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002B\u0006\u0012\u00111Y\u00017\u00032d7+\u001e9q_J$X\rZ)v_J,X.\u00118e%\u0016\u0004H.[2bi&|gnQ8nE&t\u0017\r^5p]N<\u0016\u000e\u001e5LSBDD\u0007O\u00013i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'o\u00155pk2$gj\u001c;TK\u0016,f\u000eZ3dS\u0012,G\rR1uCR1\u0011QGAe\u0003\u0017Dq!!!\u001d\u0001\u0004\t\u0019\tC\u0004\u0002\u001ar\u0001\r!a!)\u000fq\ti*!+\u0002,\":A$!-\u0002>\u0006EGFAAa\u0003)\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00138dYV$Wm]!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:$b!!\u000e\u0002X\u0006e\u0007bBAA;\u0001\u0007\u00111\u0011\u0005\b\u00033k\u0002\u0019AABQ\u001di\u0012QTAU\u0003WCs!HAY\u0003{\u000by\u000e\f\u0002\u0002B\u0006QB/Z:u'\u0016tGm\u00144gg\u0016$8oV5uQ\u001e\u0013x.\u001e9JIR1\u0011QGAs\u0003ODq!!!\u001f\u0001\u0004\t\u0019\tC\u0004\u0002\u001az\u0001\r!a!)\u000fy\ti*!+\u0002,\":a$!-\u0002>\u00065HFAAa\u0003\u0001\"Xm\u001d;TK:$wJ\u001a4tKR\u001cx+\u001b;i\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0015\r\u0005U\u00121_A{\u0011\u001d\t\ti\ba\u0001\u0003\u0007Cq!!' \u0001\u0004\t\u0019\tK\u0004 \u0003;\u000bI+a+)\u000f}\t\t,!0\u0002|2\u0012\u0011\u0011Y\u0001\u000bg\u0016tGm\u00144gg\u0016$H\u0003BA\u001b\u0005\u0003AqAa\u0001!\u0001\u0004\u0011)!\u0001\u0004d_6l\u0017\u000e\u001e\t\u000b\u0019\n\u001d\u0001/a!\u0002\u0010\u0005U\u0012b\u0001B\u0005\u001b\nIa)\u001e8di&|gnM\u0001\u0014i\u0016\u001cHOR3oG&twm\u00148D_6l\u0017\u000e\u001e\u000b\u0007\u0003k\u0011yA!\u0005\t\u000f\u0005\u0005\u0015\u00051\u0001\u0002\u0004\"9\u0011\u0011T\u0011A\u0002\u0005\r\u0005fB\u0011\u0002\u001e\u0006%\u00161\u0016\u0015\bC\u0005E\u0016Q\u0018B\fY\t\t\t-\u0001\ruKN$h)\u001a8dS:<wJ\\*f]\u0012|eMZ:fiN$b!!\u000e\u0003\u001e\t}\u0001bBAAE\u0001\u0007\u00111\u0011\u0005\b\u00033\u0013\u0003\u0019AABQ\u001d\u0011\u0013QTAU\u0003WCsAIAY\u0003{\u0013)\u0003\f\u0002\u0002B\u0006aC/Z:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0013:\u001cVM\u001c3PM\u001a\u001cX\r^:U_R\u0013\u0018M\\:bGRLwN\u001c\u000b\u0007\u0003k\u0011YC!\f\t\u000f\u0005\u00055\u00051\u0001\u0002\u0004\"9\u0011\u0011T\u0012A\u0002\u0005\r\u0005fB\u0012\u0002\u001e\u0006%\u00161\u0016\u0015\bG\u0005E\u0016Q\u0018B\u001aY\t\t\t-A\u000euKN$\u0018J\\5u)J\fgn]1di&|gn\u001d+j[\u0016|W\u000f\u001e\u000b\u0007\u0003k\u0011IDa\u000f\t\u000f\u0005\u0005E\u00051\u0001\u0002\u0004\"9\u0011\u0011\u0014\u0013A\u0002\u0005\r\u0005f\u0002\u0013\u0002\u001e\u0006%\u00161\u0016\u0015\bI\u0005E\u0016Q\u0018B!Y\t\t\t-A\u0012uKN$8+\u001a8e\u001f\u001a47/\u001a;t)>$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;\u0015\r\u0005U\"q\tB%\u0011\u001d\t\t)\na\u0001\u0003\u0007Cq!!'&\u0001\u0004\t\u0019\tK\u0004&\u0003;\u000bI+a+)\u000f\u0015\n\t,!0\u0003P1\u0012\u0011\u0011Y\u0001\u001di\u0016\u001cHoQ8n[&$HK]1og\u0006\u001cG/[8o)&lWm\\;u)\u0019\t)D!\u0016\u0003X!9\u0011\u0011\u0011\u0014A\u0002\u0005\r\u0005bBAMM\u0001\u0007\u00111\u0011\u0015\bM\u0005u\u0015\u0011VAVQ\u001d1\u0013\u0011WA_\u0005;b#!!1\u00027Q,7\u000f^!c_J$HK]1og\u0006\u001cG/[8o)&lWm\\;u)\u0019\t)Da\u0019\u0003f!9\u0011\u0011Q\u0014A\u0002\u0005\r\u0005bBAMO\u0001\u0007\u00111\u0011\u0015\bO\u0005u\u0015\u0011VAVQ\u001d9\u0013\u0011WA_\u0005Wb#!!1\u0002\u0017Q,7\u000f\u001e+j[\u0016|W\u000f\u001e\u000b\u0007\u0003k\u0011\tHa\u001f\t\u000f\tM\u0004\u00061\u0001\u0003v\u0005\u0011b.Z3e\u0013:LG/\u00118e'\u0016tG-T:h!\ra%qO\u0005\u0004\u0005sj%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005{B\u0003\u0019\u0001B@\u00039!\u0018.\\3pkR\u0004&o\\2fgN\u0004b\u0001\u0014BAa\u0006U\u0012b\u0001BB\u001b\nIa)\u001e8di&|g.M\u0001\u0012i\u0016\u001cHOR3oG&twm\u00148TK:$GCBA\u001b\u0005\u0013\u0013Y\tC\u0004\u0002\u0002&\u0002\r!a!\t\u000f\u0005e\u0015\u00061\u0001\u0002\u0004\":\u0011&!(\u0002*\u0006-\u0006fB\u0015\u00022\u0006u&\u0011\u0013\u0017\u0003\u0003\u0003\f!\u0004^3ti\u001a+gnY5oO>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$b!!\u000e\u0003\u0018\ne\u0005bBAAU\u0001\u0007\u00111\u0011\u0005\b\u00033S\u0003\u0019AABQ\u001dQ\u0013QTAU\u0003WCsAKAY\u0003{\u0013y\n\f\u0002\u0002B\u0006\u0011C/Z:u\r\u0016t7-\u001b8h\u001f:$&/\u00198tC\u000e$\u0018n\u001c8FqBL'/\u0019;j_:$b!!\u000e\u0003&\n\u001d\u0006bBAAW\u0001\u0007\u00111\u0011\u0005\b\u00033[\u0003\u0019AABQ\u001dY\u0013QTAU\u0003WCsaKAY\u0003{\u0013i\u000b\f\u0002\u0002B\u0006aB/Z:u\u001bVdG/\u001b9mK6\u000b'o[3sg>sW\rT3bI\u0016\u0014HCBA\u001b\u0005g\u0013)\fC\u0004\u0002\u00022\u0002\r!a!\t\u000f\u0005eE\u00061\u0001\u0002\u0004\":A&!(\u0002*\u0006-\u0006f\u0002\u0017\u00022\u0006u&1\u0018\u0017\u0003\u0003\u0003\fA\u0005^3ti\u000e{gn]3dkRLg/\u001a7z%Vt\u0017J\\5u)J\fgn]1di&|gn\u001d\u000b\u0007\u0003k\u0011\tMa1\t\u000f\u0005\u0005U\u00061\u0001\u0002\u0004\"9\u0011\u0011T\u0017A\u0002\u0005\r\u0005fB\u0017\u0002\u001e\u0006%\u00161\u0016\u0015\b[\u0005E\u0016Q\u0018BeY\t\t\t-\u0001\u000euKN$()^7q)J\fgn]1di&|g.\u00197Fa>\u001c\u0007\u000e\u0006\u0004\u00026\t='\u0011\u001b\u0005\b\u0003\u0003s\u0003\u0019AAB\u0011\u001d\tIJ\fa\u0001\u0003\u0007CsALAO\u0003S\u000bY\u000bK\u0004/\u0003c\u000biLa6-\u0005\u0005\u0005\u0017a\u0006;fgR4\u0015-\u001b7ve\u0016$vNR3oG\u0016,\u0005o\\2i)\u0019\t)D!8\u0003`\"9\u0011\u0011Q\u0018A\u0002\u0005\r\u0005bBAM_\u0001\u0007\u00111\u0011\u0015\b_\u0005u\u0015\u0011VAVQ\u001dy\u0013\u0011WA_\u0005Kd#!!1\u0002OM,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fG.T3tg\u0006<Wm],ji\"4\u0016\r\\;f%\u0006tw-\u001a\u000b\r\u0003k\u0011YO!<\u0003r\nU(\u0011 \u0005\u0006gB\u0002\r\u0001\u001d\u0005\b\u0005_\u0004\u0004\u0019AAB\u0003\u0015!x\u000e]5d\u0011\u0019\u0011\u0019\u0010\ra\u0001\u0017\u0006)1\u000f^1si\"1!q\u001f\u0019A\u0002-\u000b1!\u001a8e\u0011\u001d\u0011Y\u0010\ra\u0001\u0005k\nqb^5mY\n+7i\\7nSR$X\rZ\u0001\u001cGJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\u0011\u0005=1\u0011AB\u0003\u0007\u0013A\u0011ba\u00012!\u0003\u0005\r!a!\u0002\u000b\u001d\u0014x.\u001e9\t\u0011\r\u001d\u0011\u0007%AA\u0002-\u000ba\"\\1y!>dGNU3d_J$7\u000fC\u0005\u0002>E\u0002\n\u00111\u0001\u0002&\u0005)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$H%M\u000b\u0003\u0007\u001fQC!a!\u0004\u0012-\u001211\u0003\t\u0005\u0007+\u0019y\"\u0004\u0002\u0004\u0018)!1\u0011DB\u000e\u0003%)hn\u00195fG.,GMC\u0002\u0004\u001e5\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\tca\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0005\u0016\u0004\u0017\u000eE\u0011!J2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iC\u000b\u0003\u0002&\rE\u0011!H2sK\u0006$XMU3bIVs7m\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\t\u0005=11\u0007\u0005\b\u0007\u0007)\u0004\u0019AAB\u0003m\u0019'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2feRY\u0001o!\u000f\u0004>\r\u001d31JB(\u0011\u001d\u0019YD\u000ea\u0001\u0003\u0007\u000bq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0005\n\u0007\u007f1\u0004\u0013!a\u0001\u0007\u0003\nA\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\bc\u0001'\u0004D%\u00191QI'\u0003\t1{gn\u001a\u0005\n\u0007\u00132\u0004\u0013!a\u0001\u0007\u0003\n!\"\\1y\u00052|7m['t\u0011!\u0019iE\u000eI\u0001\u0002\u0004Y\u0015!\u00053fY&4XM]=US6,w.\u001e;Ng\"A1\u0011\u000b\u001c\u0011\u0002\u0003\u00071*\u0001\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0006)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007/RCa!\u0011\u0004\u0012\u0005)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HeM\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIQ\nQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b)\u000f\u0001\u0019\t'!0\u0004hA!\u0011qKB2\u0013\u0011\u0019)'!\u0017\u0003\u0007Q\u000bw-\t\u0002\u0004j\u0005\u0001\"-\u0019>fYj\u001a\u0018N_3;Y\u0006\u0014x-\u001a\u0015\b\u0001\r\u0005\u0014QXB7C\t\u0019y'\u0001\u000bcCj,GNO:iCJ$wlY8v]RT\u0014G\r")
public class TransactionsTest
extends IntegrationTestHarness {
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    @Override
    public int brokerCount() {
        return 3;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        props.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        if (this.isNewGroupCoordinatorEnabled()) {
            props.put(KafkaConfig$.MODULE$.TransactionPartitionVerificationEnableProp(), "false");
        }
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    public Properties topicConfig() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        return topicConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable)x$1 -> this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable)x$2 -> this.createReadCommittedConsumer("transactional-group", 500, new Properties()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable)x$3 -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testBasicTransactions(String quorum, String replication) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, 15000L);
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testReadCommittedConsumerShouldNotSeeUndecidedData(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        Consumer readCommittedConsumer = (Consumer)this.transactionalConsumers().head();
        Consumer readUncommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, 15000L);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L).foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testDelayedFetchIncludesAbortedTransaction(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        TopicPartition tp10 = new TopicPartition(this.topic1(), 0);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = "group";
        int x$3 = 500;
        Consumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L);
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testSendOffsetsWithGroupId(String quorum, String replication) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testSendOffsetsWithGroupMetadata(String quorum, String replication) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.brokers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), 15000L);
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        ListBuffer partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        Consumer verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFencingOnCommit(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFencingOnSendOffsets(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testOffsetMetadataInSendOffsetsToTransaction(String quorum, String replication) {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, 500, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cannot read committed offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testInitTransactionsTimeout(String quorum, String replication) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testSendOffsetsToTransactionTimeout(String quorum, String replication) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testCommitTransactionTimeout(String quorum, String replication) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testAbortTransactionTimeout(String quorum, String replication) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionProducer", x$3, 3000L, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> timeoutProcess.apply((Object)producer));
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFencingOnSend(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$8 -> x$8.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFencingOnAddPartitions(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFencingOnTransactionExpiration(String quorum, String replication) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised a ProducerFencedException since the transaction has expired");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        Consumer nonTransactionalConsumer = (Consumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, 15000L);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        Consumer transactionalConsumer = (Consumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testMultipleMarkersOneLeader(String quorum, String replication) {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        this.createTopic(topicWith10Partitions, 10, this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, 15000L);
        scala.collection.immutable.Set expectedValues = package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable)x$10 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$10))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testConsecutivelyRunInitTransactions(String quorum, String replication) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", 60000L, 60000L, 120000, 30000);
        producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> producer.initTransactions());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testBumpTransactionalEpoch(String quorum, String replication) {
        long x$4 = 60000L;
        long x$5 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$4, x$5, 5000, 5000);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((AbstractLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((AbstractLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinationsWithKip848"})
    public void testFailureToFenceEpoch(String quorum, String replication) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("transactional-producer", x$3, 1000L, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), 15000L);
        LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        Iterator activeProducersIter = ((AbstractLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
        Assertions.assertTrue((boolean)activeProducersIter.hasNext());
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        long x$10 = 60000L;
        int x$11 = 120000;
        int x$12 = 30000;
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer("transactional-producer", x$10, 5000L, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((AbstractLog)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        None$ x$6 = None$.MODULE$;
        String x$7 = "earliest";
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, (Option<String>)x$6, x$7, false, true, maxPollRecords, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12, (String)null);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private Consumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        None$ x$4 = None$.MODULE$;
        String x$5 = "earliest";
        boolean x$6 = false;
        int x$7 = 500;
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, (Option<String>)x$4, x$5, false, x$6, x$7, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12, (String)null);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$7 = 16384;
        int x$8 = 5;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ ListBuffer $anonfun$sendOffset$4(TransactionsTest $this, ListBuffer partitions$1, int partition) {
        return (ListBuffer)partitions$1.$plus$eq((Object)new TopicPartition($this.topic2(), partition));
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$10) {
        return Integer.toString(x$10);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$7, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

