/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kafka.assignor.ConfluentReplicaPlacer;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.DefaultDirProvider;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConfluentReplicaPlacerTest {
    @Test
    public void testPlaceCallsTopicPlacementReplicaPlacerWhenTopicPlacementIsSpecified() {
        ReplicaPlacer replicaPlacer = (ReplicaPlacer)Mockito.mock(ReplicaPlacer.class);
        PartitionAssignment partitionAssignment = new PartitionAssignment(Arrays.asList(0, 2, 1, 3), Arrays.asList(1, 3), __ -> DirectoryId.MIGRATING);
        List<PartitionAssignment> partitionAssignments = Arrays.asList(partitionAssignment);
        TopicAssignment topicAssignment = new TopicAssignment(partitionAssignments);
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":3,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack1\"}}],\"observers\": [{\"count\":2,\"constraints\":{\"rack\":\"rack2\"}}]}";
        Optional topicPlacementOpt = TopicPlacement.parse((String)topicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacementOpt.isPresent());
        PlacementSpec placementSpec = new PlacementSpec(0, 1, 1, "topic-1", KafkaPrincipal.ANONYMOUS, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE, topicPlacementOpt);
        TopicPlacementReplicaPlacer.PlacementSpec topicPlacementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)topicPlacementOpt.get(), Collections.emptySet(), 0, 1);
        Iterator brokers = (Iterator)Mockito.mock(Iterator.class);
        TopicPlacementReplicaPlacer topicPlacementReplicaPlacer = (TopicPlacementReplicaPlacer)Mockito.mock(TopicPlacementReplicaPlacer.class);
        Mockito.when((Object)topicPlacementReplicaPlacer.place((TopicPlacementReplicaPlacer.PlacementSpec)Mockito.eq((Object)topicPlacementSpec), (Iterator)Mockito.eq((Object)brokers), (DefaultDirProvider)Mockito.any())).thenReturn((Object)topicAssignment);
        ConfluentReplicaPlacer confluentReplicaPlacer = new ConfluentReplicaPlacer(new LogContext(), replicaPlacer, Optional.empty(), topicPlacementReplicaPlacer);
        ClusterDescriber describer = (ClusterDescriber)Mockito.mock(ClusterDescriber.class);
        Mockito.when((Object)describer.usableBrokers()).thenReturn((Object)brokers);
        TopicAssignment actualTopicAssignment = confluentReplicaPlacer.place(placementSpec, describer);
        ((TopicPlacementReplicaPlacer)Mockito.verify((Object)topicPlacementReplicaPlacer, (VerificationMode)Mockito.times((int)1))).place((TopicPlacementReplicaPlacer.PlacementSpec)Mockito.eq((Object)topicPlacementSpec), (Iterator)Mockito.eq((Object)brokers), (DefaultDirProvider)Mockito.any());
        Assertions.assertEquals((Object)topicAssignment, (Object)actualTopicAssignment);
    }
}

