/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.availability.AllThreadsStuck$;
import kafka.availability.AnyThreadStuck$;
import kafka.availability.BrokerHealthManager;
import kafka.availability.BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.Unhealthy$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.server.ConfigEntityName$;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005Ba2A!\u0013\u0001A\u0015\"AQl\u0001BI\u0002\u0013\u0005a\f\u0003\u0005j\u0007\t\u0005\r\u0011\"\u0001k\u0011!i7A!E!B\u0013y\u0006\u0002\u00038\u0004\u0005#\u0007I\u0011A8\t\u0011M\u001c!\u00111A\u0005\u0002QD\u0001B^\u0002\u0003\u0012\u0003\u0006K\u0001\u001d\u0005\u0006g\r!\ta\u001e\u0005\by\u000e\t\t\u0011\"\u0001~\u0011%\t\taAI\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u001a\r\t\n\u0011\"\u0001\u0002\u001c!I\u0011qD\u0002\u0002\u0002\u0013\u0005\u0013\u0011\u0005\u0005\n\u0003_\u0019\u0011\u0011!C\u0001\u0003cA\u0011\"!\u000f\u0004\u0003\u0003%\t!a\u000f\t\u0013\u0005\u00153!!A\u0005B\u0005\u001d\u0003\"CA+\u0007\u0005\u0005I\u0011AA,\u0011%\t\tgAA\u0001\n\u0003\n\u0019\u0007C\u0005\u0002h\r\t\t\u0011\"\u0011\u0002j!I\u00111N\u0002\u0002\u0002\u0013\u0005\u0013Q\u000e\u0005\n\u0003_\u001a\u0011\u0011!C!\u0003c:\u0011\"!\u001e\u0001\u0003\u0003E\t!a\u001e\u0007\u0011%\u0003\u0011\u0011!E\u0001\u0003sBaa\r\r\u0005\u0002\u0005=\u0005\"CA61\u0005\u0005IQIA7\u0011%\t\t\nGA\u0001\n\u0003\u000b\u0019\nC\u0005\u0002\u001ab\t\t\u0011\"!\u0002\u001c\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003AqA!\b\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\"\u0001!\tA!\u0001\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003\u0002!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B-\u0001\u0011\u0005!\u0011\u0001\u0002#\u0005J|7.\u001a:IK\u0006dG\u000f['b]\u0006<WM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005!J\u0013\u0001D1wC&d\u0017MY5mSRL(\"\u0001\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\f\t\u0003]Ej\u0011a\f\u0006\u0003a%\naa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u00016!\t1\u0004!D\u0001(\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5u\u0011\u0015\u0001%\u00011\u0001B\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005)\u0001&o\u001c9feRLWm\u001d\u0002#)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o\u001d(v[N#XoY6TC6\u0004H.Z:\u0014\t\rYe*\u0015\t\u0003u1K!!T\u001e\u0003\r\u0005s\u0017PU3g!\tQt*\u0003\u0002Qw\t9\u0001K]8ek\u000e$\bC\u0001*[\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002WW\u00051AH]8pizJ\u0011\u0001P\u0005\u00033n\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011lO\u0001\u0014i\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]\u000b\u0002?B\u0011\u0001mZ\u0007\u0002C*\u0011\u0001F\u0019\u0006\u0003U\rT!\u0001Z3\u0002\u0013\r|gN\u001a7vK:$(\"\u00014\u0002\u0005%|\u0017B\u00015b\u0005M!\u0006N]3bI2{7-\u00197D_VtG/\u001a:t\u0003]!\bN]3bI2{7-\u00197D_VtG/\u001a:t?\u0012*\u0017\u000f\u0006\u0002:W\"9A.BA\u0001\u0002\u0004y\u0016a\u0001=%c\u0005!B\u000f\u001b:fC\u0012dunY1m\u0007>,h\u000e^3sg\u0002\n\u0001B\\;n'R,8m[\u000b\u0002aB\u0011!(]\u0005\u0003en\u0012A\u0001T8oO\u0006aa.^7TiV\u001c7n\u0018\u0013fcR\u0011\u0011(\u001e\u0005\bY\"\t\t\u00111\u0001q\u0003%qW/\\*uk\u000e\\\u0007\u0005F\u0002yun\u0004\"!_\u0002\u000e\u0003\u0001AQ!\u0018\u0006A\u0002}CQA\u001c\u0006A\u0002A\fAaY8qsR\u0019\u0001P`@\t\u000fu[\u0001\u0013!a\u0001?\"9an\u0003I\u0001\u0002\u0004\u0001\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bQ3aXA\u0004W\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\nw\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003;Q3\u0001]A\u0004\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F#\u0002\t1\fgnZ\u0005\u0005\u0003[\t9C\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003g\u00012AOA\u001b\u0013\r\t9d\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\t\u0019\u0005E\u0002;\u0003\u007fI1!!\u0011<\u0005\r\te.\u001f\u0005\tYB\t\t\u00111\u0001\u00024\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JA1\u00111JA)\u0003{i!!!\u0014\u000b\u0007\u0005=3(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0015\u0002N\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI&a\u0018\u0011\u0007i\nY&C\u0002\u0002^m\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005m%\u0005\u0005\t\u0019AA\u001f\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u0012Q\r\u0005\tYN\t\t\u00111\u0001\u00024\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00024\u0005AAo\\*ue&tw\r\u0006\u0002\u0002$\u00051Q-];bYN$B!!\u0017\u0002t!AANFA\u0001\u0002\u0004\ti$\u0001\u0012UQJ,\u0017\r\u001a'pG\u0006d7i\\;oi\u0016\u00148OT;n'R,8m[*b[BdWm\u001d\t\u0003sb\u0019R\u0001GA>\u0003\u000f\u0003r!! \u0002\u0004~\u0003\b0\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q\u001e\u0002\u000fI,h\u000e^5nK&!\u0011QQA@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u0013\u000bi)\u0004\u0002\u0002\f*\u0011a-R\u0005\u00047\u0006-ECAA<\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A\u0018QSAL\u0011\u0015i6\u00041\u0001`\u0011\u0015q7\u00041\u0001q\u0003\u001d)h.\u00199qYf$B!!(\u0002*B)!(a(\u0002$&\u0019\u0011\u0011U\u001e\u0003\r=\u0003H/[8o!\u0015Q\u0014QU0q\u0013\r\t9k\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-F$!AA\u0002a\f1\u0001\u001f\u00131\u0003A1\u0017N\u001c3TiV\u001c7\u000e\u00165sK\u0006$7\u000fF\u0004:\u0003c\u000bY,a6\t\u000f\u0005MV\u00041\u0001\u00026\u0006\u0019\"M]8lKJDU-\u00197uQ6\u000bg.Y4feB\u0019a'a.\n\u0007\u0005evEA\nCe>\\WM\u001d%fC2$\b.T1oC\u001e,'\u000fC\u0004\u0002>v\u0001\r!a0\u0002\u0019QD'/Z1egN#XoY6\u0011\u0011\u0005\u0005\u0017qYAf\u0003#l!!a1\u000b\t\u0005\u0015\u0017QJ\u0001\b[V$\u0018M\u00197f\u0013\u0011\tI-a1\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002&\u00055\u0017\u0002BAh\u0003O\u0011a\u0001\u00165sK\u0006$\u0007#BAa\u0003'D\u0018\u0002BAk\u0003\u0007\u0014!\u0002T5ti\n+hMZ3s\u0011\u0019\tI.\ba\u0001a\u0006\u0001b.^7TC6\u0004H.Z:U_^\u000b\u0017\u000e^\u0001\u0014M&tGMT;n)\"\u0014X-\u00193t'R,8m\u001b\u000b\u0006q\u0006}\u0017\u0011\u001d\u0005\b\u0003{s\u0002\u0019AA`\u0011\u0019\t\u0019O\ba\u0001a\u0006Qa.^7TC6\u0004H.Z:\u0002\u00175,GO]5d-\u0006dW/\u001a\u000b\u0007\u0003g\tI/a?\t\u000f\u0005-x\u00041\u0001\u0002n\u0006QQ.\u001a;sS\u000e$\u0016\u0010]3\u0011\t\u0005=\u0018q\u001f\b\u0005\u0003c\f\u0019\u0010\u0005\u0002Uw%\u0019\u0011Q_\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#!?\u000b\u0007\u0005U8\bC\u0004\u0002~~\u0001\r!!<\u0002\t9\fW.Z\u0001Fi\u0016\u001cHO\u0011:pW\u0016\u0014\b*Z1mi\"LxJ\\3TiV\u001c7\u000e\u00165sK\u0006$')\u001e;SK\u000e|g/\u001a:t\u0005\u00164wN]3Ce>\\WM\u001d#fK6,G-\u00168iK\u0006dG\u000f[=\u0015\u0003eB3\u0001\tB\u0003!\u0011\u00119A!\u0007\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t1!\u00199j\u0015\u0011\u0011yA!\u0005\u0002\u000f),\b/\u001b;fe*!!1\u0003B\u000b\u0003\u0015QWO\\5u\u0015\t\u00119\"A\u0002pe\u001eLAAa\u0007\u0003\n\t!A+Z:u\u0003\u001d\"Xm\u001d;Ce>\\WM\u001d%fC2$\bNR8sG\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8)\u0007\u0005\u0012)!\u0001\u001buKN$(I]8lKJDU-\u00197uQN#\u0018\r^;t)J\fgn]5uS>tgI]8n'V\u001c\b/Z2u)>DU-\u00197uQfD3A\tB\u0003\u0003\u0005\"Xm\u001d;Es:\fW.[2D_:4\u0017nZ:BaBd\u0017.\u001a3Qe>\u0004XM\u001d7zQ\r\u0019#QA\u0001\u0018i\u0016\u001cHo\u0013:bMR$\u0015P\\1nS\u000e\u001cuN\u001c4jON$2!\u000fB\u0017\u0011\u001d\u0011y\u0003\na\u0001\u0003[\fa!];peVl\u0007f\u0002\u0013\u00034\u0005u(q\b\t\u0005\u0005k\u0011Y$\u0004\u0002\u00038)!!\u0011\bB\u0007\u0003\u0019\u0001\u0018M]1ng&!!Q\bB\u001c\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0011\u0003\u0005\u0003\n!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\bf\u0002\u0013\u0003F\tE#1\u000b\t\u0005\u0005\u000f\u0012i%\u0004\u0002\u0003J)!!1\nB\u001c\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002\u0002B(\u0005\u0013\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHF\u0001B+C\t\u00119&A\u0003le\u00064G/A\u0015uKN$(I]8lKJDU-\u00197uQ6\u000bg.Y4feB\u000b7o]3e)>\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004K\t\u0015\u0001")
public class BrokerHealthManagerIntegrationTest
extends BaseRequestTest {
    private volatile BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples$module;

    public BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples() {
        if (this.ThreadLocalCountersNumStuckSamples$module == null) {
            this.ThreadLocalCountersNumStuckSamples$lzycompute$1();
        }
        return this.ThreadLocalCountersNumStuckSamples$module;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    public void findStuckThreads(BrokerHealthManager brokerHealthManager, scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamplesToWait) {
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + numSamplesToWait) {
            brokerHealthManager.prevThreadLocalCountersSnapshot().forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
                ObjectRef tlcInMap = ObjectRef.create(null);
                ListBuffer threadLocalCountersNumStuckSamplesList = (ListBuffer)threadsStuck.getOrElseUpdate(thread, (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
                threadLocalCountersNumStuckSamplesList.foreach((Function1 & Serializable)threadLocalCountersNumStuckSample -> {
                    BrokerHealthManagerIntegrationTest.$anonfun$findStuckThreads$4(threadLocalCounters, tlcInMap, threadLocalCountersNumStuckSample);
                    return BoxedUnit.UNIT;
                });
                if ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem == null) {
                    tlcInMap.elem = new ThreadLocalCountersNumStuckSamples(this, (ThreadLocalCounters)threadLocalCounters, 0L);
                    threadLocalCountersNumStuckSamplesList.$plus$eq((Object)((ThreadLocalCountersNumStuckSamples)tlcInMap.elem));
                }
                if (threadLocalCounters.numInProgressOps >= 1L) {
                    ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)tlcInMap.elem;
                    threadLocalCountersNumStuckSamples.numStuck_$eq(threadLocalCountersNumStuckSamples.numStuck() + threadLocalCounters.numInProgressOps);
                    return;
                }
                ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem).numStuck_$eq(0L);
            }));
        }
    }

    public ThreadLocalCountersNumStuckSamples findNumThreadsStuck(scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamples) {
        ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal = new ThreadLocalCountersNumStuckSamples(this, null, 0L);
        threadsStuck.foreach((Function1 & Serializable)x0$1 -> {
            BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$1(numSamples, threadLocalCountersNumStuckSamplesReturnVal, x0$1);
            return BoxedUnit.UNIT;
        });
        return threadLocalCountersNumStuckSamplesReturnVal;
    }

    public int metricValue(String metricType, String name) {
        return BoxesRunTime.unboxToInt((Object)((Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManagerIntegrationTest.$anonfun$metricValue$1(name, metricType, x0$1)))).head())._2()).value());
    }

    @Test
    public void testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy() {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean condVar = new AtomicBoolean(false);
        KafkaServer kafkaServer = (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + 5L) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        int numSamplesEngineThreadGroupsStuck = this.metricValue("BrokerHealthManager", "ContiguousSamplesEngineThreadGroupsStuck");
        int numUnhealthySamples = this.metricValue("BrokerHealthManager", "ContiguousUnhealthySamples");
        int numSamplesNoStorageThreadsMakingProgress = this.metricValue("BrokerHealthManager", "ContiguousSamplesNoStorageThreadMakingProgress");
        Predef$.MODULE$.assert(numSamplesEngineThreadGroupsStuck >= 0);
        Predef$.MODULE$.assert(numUnhealthySamples >= 0);
        Predef$.MODULE$.assert(numSamplesNoStorageThreadsMakingProgress >= 0);
        kafkaServer.kafkaScheduler().scheduleOnce("broker-health-test", () -> BrokerHealthManagerIntegrationTest.stuckThreadRunnable$1(lock, condVar, condition));
        scala.collection.mutable.Map threadsStuck = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        brokerHealthManager.totalSamples();
        this.findStuckThreads(brokerHealthManager, (scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        int numSamplesStorageThreadGroupsStuck = this.metricValue("BrokerHealthManager", "ContiguousSamplesStorageThreadGroupsStuck");
        ThreadLocalCountersNumStuckSamples threadCountersNumStuckCounters = this.findNumThreadsStuck((scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        ThreadLocalCounters counters = threadCountersNumStuckCounters.threadLocalCounters();
        long totalThreadCountersStuck = threadCountersNumStuckCounters.numStuck();
        lock.lock();
        condVar.set(true);
        condition.signal();
        lock.unlock();
        Predef$.MODULE$.assert(totalThreadCountersStuck >= 1L);
        Predef$.MODULE$.assert(counters != null);
        ThreadLocalCounters.ThreadGroupType threadGroupType = counters.threadGroupType;
        ThreadLocalCounters.ThreadGroupType threadGroupType2 = ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD;
        Predef$.MODULE$.assert(!(threadGroupType != null ? !threadGroupType.equals(threadGroupType2) : threadGroupType2 != null));
        Predef$.MODULE$.assert(numSamplesStorageThreadGroupsStuck > 1, (Function0 & Serializable)() -> new StringBuilder(45).append("Num of samples storage thread groups stuck = ").append(numSamplesStorageThreadGroupsStuck).toString());
        BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        int brokerHealthStatusMetric = this.metricValue("BrokerHealthManager", "StorageHealthStatus");
        Predef$.MODULE$.assert(brokerHealthStatusMetric == 1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthForceControlledShutdown() {
        VolatileBooleanRef hasCalledExit = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(x$1, x$2) -> BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$1(hasCalledExit, BoxesRunTime.unboxToInt((Object)x$1), x$2);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var9_2 = null;
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableOps)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "0");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$3(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Num Samples is not 1");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Num Samples is not 1");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$7(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Num Samples is not 0");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$9(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Num Samples is not 0");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        try {
            long l5 = 100L;
            long waitUntilTrue_waitTimeMs5 = 15000L;
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$11(kafkaServer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)"Broker is still Healthy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            long l6 = 100L;
            long waitUntilTrue_waitTimeMs6 = 15000L;
            long waitUntilTrue_startTime6 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$13(kafkaServer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                    Assertions.fail((String)"Broker is not undergoing controlled shutdown");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
            }
            long l7 = 100L;
            long waitUntilTrue_waitTimeMs7 = 15000L;
            long waitUntilTrue_startTime7 = System.currentTimeMillis();
            while (!hasCalledExit.elem) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                    Assertions.fail((String)"Exit wasn't triggered");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthStatusTransitionFromSuspectToHealthy() {
        KafkaServer kafkaServer = (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "50");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(this, kafkaServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Broker is still Healthy");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(kafkaServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Broker is still Suspect");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConfigsAppliedProperly() {
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableOps)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        Properties props = new Properties();
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 180 ? 1 : 0) != 0, (String)"Default number of unhealthy samples should be 180");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1000");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$2(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Num Samples is not 1000");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 30 ? 1 : 0) != 0, (String)"Default number of suspect samples should be 30");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "250");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Num Samples is not 250");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 90 ? 1 : 0) != 0, (String)"Default number of suspect samples percentage should be 90");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$8(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Num % Samples is not 99");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 70 ? 1 : 0) != 0, (String)"Default number of unhealthy samples percentage should be 70");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$11(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Num % Samples is not 99");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AllThreadsStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$14(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Thread status criteria size is not 3");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$16(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Request handler thread isn't present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$18(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$19(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "Disabled");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$21(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)"Thread status criteria size is not 2");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$23(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                Assertions.fail((String)"Request handler thread is still present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AnyThreadStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime10 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$26(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime10 + waitUntilTrue_waitTimeMs10) {
                Assertions.fail((String)"Thread status criteria size is not 3");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs10), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs11 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime11 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$28(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime11 + waitUntilTrue_waitTimeMs11) {
                Assertions.fail((String)"Request handler thread isn't present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs11), (long)waitUntilTrue_pause));
        }
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime12 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$30(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime12 + waitUntilTrue_waitTimeMs12) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$31(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs12), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "2000");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs13 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime13 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$33(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime13 + waitUntilTrue_waitTimeMs13) {
                Assertions.fail((String)"SampleDurationMs is not 2000");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs13), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)brokerHealthManager.config().isBrokerHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        Assertions.assertTrue((boolean)brokerHealthManager.isMitigationEnabled(), (String)"Mitigation must be on");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "false");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime14 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$36(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime14 + waitUntilTrue_waitTimeMs14) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs14), (long)waitUntilTrue_pause));
        }
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs15 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime15 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$38(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime15 + waitUntilTrue_waitTimeMs15) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs15), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "");
        kafkaServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime16 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$41(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime16 + waitUntilTrue_waitTimeMs16) {
                Assertions.fail((String)"Thread status criteria size is not 3");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs16), (long)waitUntilTrue_pause));
        }
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs17 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime17 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$43(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime17 + waitUntilTrue_waitTimeMs17) {
                Assertions.fail((String)"Request handler thread isn't present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs17), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testKraftDynamicConfigs(String quorum) {
        BrokerServer brokerServer = (BrokerServer)this.brokers().head();
        BrokerHealthManager brokerHealthManager = brokerServer.brokerHealthManager();
        Assertions.assertTrue((boolean)brokerHealthManager.config().isBrokerHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        Assertions.assertTrue((boolean)brokerHealthManager.isMitigationEnabled(), (String)"Mitigation must be on");
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "false");
        brokerServer.dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$2(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$4(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testBrokerHealthManagerPassedToPartitions() {
        String topic = "topic1";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopicWithAssignment("topic1", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.createTopicWithAssignment$default$3()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        KafkaServer kafkaServer = (KafkaServer)this.serverForId(leader).get();
        Assertions.assertNotNull((Object)kafkaServer.brokerHealthManager());
        Assertions.assertTrue((boolean)kafkaServer.replicaManager().brokerHealthManager().nonEmpty());
        TopicPartition tp = new TopicPartition(topic, partition);
        HostedPartition hostedPartition = kafkaServer.replicaManager().getPartition(tp);
        Assertions.assertTrue((boolean)(hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().brokerHealthManagerOpt().nonEmpty() : false));
    }

    private final void ThreadLocalCountersNumStuckSamples$lzycompute$1() {
        synchronized (this) {
            if (this.ThreadLocalCountersNumStuckSamples$module == null) {
                this.ThreadLocalCountersNumStuckSamples$module = new BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findStuckThreads$4(ThreadLocalCounters threadLocalCounters$1, ObjectRef tlcInMap$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSample) {
        block7: {
            block6: {
                ThreadLocalCounters.MetricComponentType metricComponentType;
                ThreadLocalCounters.MetricComponentType metricComponentType2;
                block5: {
                    metricComponentType2 = threadLocalCountersNumStuckSample.threadLocalCounters().metricComponentType;
                    metricComponentType = threadLocalCounters$1.metricComponentType;
                    if (metricComponentType2 != null) break block5;
                    if (metricComponentType != null) {
                        return;
                    }
                    break block6;
                }
                if (!metricComponentType2.equals(metricComponentType)) break block7;
            }
            tlcInMap$1.elem = threadLocalCountersNumStuckSample;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$2(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples) {
        if (threadLocalCountersNumStuckSamples.numStuck() >= numSamples$1) {
            threadLocalCountersNumStuckSamplesReturnVal$1.threadLocalCounters_$eq(threadLocalCountersNumStuckSamples.threadLocalCounters());
            threadLocalCountersNumStuckSamplesReturnVal$1.numStuck_$eq(threadLocalCountersNumStuckSamplesReturnVal$1.numStuck() + 1L);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$1(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ((ListBuffer)x0$1._2()).foreach((Function1 & Serializable)threadLocalCountersNumStuckSamples -> {
                BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$2(numSamples$1, threadLocalCountersNumStuckSamplesReturnVal$1, threadLocalCountersNumStuckSamples);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, String metricType$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.getName();
            if (!(string != null ? !string.equals(name$1) : name$1 != null)) {
                String string2 = metricName.getType();
                if (!(string2 != null ? !string2.equals(metricType$1) : metricType$1 != null)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        lock$1.lock();
        while (!condVar$1.get()) {
            condition$1.await();
        }
        lock$1.unlock();
    }

    private static final void stuckThreadRunnable$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        ThreadCountersManager.wrapIO(() -> {
            BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(lock$1, condVar$1, condition$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testBrokerHealthForceControlledShutdown$1(VolatileBooleanRef hasCalledExit$1, int x$1, Option x$2) {
        hasCalledExit$1.elem = true;
        throw new Exception();
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$3(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$4() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$5(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$6() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$7(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$8() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$9(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$10() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$11(KafkaServer kafkaServer$1) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$1.brokerHealthManager().brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(unhealthy$);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$12() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$13(KafkaServer kafkaServer$1) {
        BrokerState brokerState = kafkaServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$14() {
        return "Broker is not undergoing controlled shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$15(VolatileBooleanRef hasCalledExit$1) {
        return hasCalledExit$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$16() {
        return "Exit wasn't triggered";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(BrokerHealthManagerIntegrationTest $this, KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Suspect$ suspect$ = Suspect$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(suspect$) && $this.metricValue("BrokerHealthManager", "StorageHealthStatus") == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$3() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(healthy$);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$5() {
        return "Broker is still Suspect";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$2(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$3() {
        return "Num Samples is not 1000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$5(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 250;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$6() {
        return "Num Samples is not 250";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$8(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$9() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$11(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$12() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$14(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$15() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$16(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$17() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$18(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AllThreadsStuck$ allThreadsStuck$ = AllThreadsStuck$.MODULE$;
        return object != null && object.equals(allThreadsStuck$);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$19(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$21(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$22() {
        return "Thread status criteria size is not 2";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$23(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$24() {
        return "Request handler thread is still present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$26(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$27() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$28(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$29() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$30(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AnyThreadStuck$ anyThreadStuck$ = AnyThreadStuck$.MODULE$;
        return object != null && object.equals(anyThreadStuck$);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$31(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$33(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerSampleDurationMs() == 2000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$34() {
        return "SampleDurationMs is not 2000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$36(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().isBrokerHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$37() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$38(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.isMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$39() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$41(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$42() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$43(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$44() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testKraftDynamicConfigs$2(BrokerHealthManager brokerHealthManager$3) {
        return !brokerHealthManager$3.config().isBrokerHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testKraftDynamicConfigs$3() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testKraftDynamicConfigs$4(BrokerHealthManager brokerHealthManager$3) {
        return !brokerHealthManager$3.isMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testKraftDynamicConfigs$5() {
        return "Mitigation must be off";
    }

    public BrokerHealthManagerIntegrationTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "true");
    }

    public class ThreadLocalCountersNumStuckSamples
    implements Product,
    Serializable {
        private ThreadLocalCounters threadLocalCounters;
        private long numStuck;
        public final /* synthetic */ BrokerHealthManagerIntegrationTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ThreadLocalCounters threadLocalCounters() {
            return this.threadLocalCounters;
        }

        public void threadLocalCounters_$eq(ThreadLocalCounters x$1) {
            this.threadLocalCounters = x$1;
        }

        public long numStuck() {
            return this.numStuck;
        }

        public void numStuck_$eq(long x$1) {
            this.numStuck = x$1;
        }

        public ThreadLocalCountersNumStuckSamples copy(ThreadLocalCounters threadLocalCounters, long numStuck) {
            return new ThreadLocalCountersNumStuckSamples(this.kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer(), threadLocalCounters, numStuck);
        }

        public ThreadLocalCounters copy$default$1() {
            return this.threadLocalCounters();
        }

        public long copy$default$2() {
            return this.numStuck();
        }

        public String productPrefix() {
            return "ThreadLocalCountersNumStuckSamples";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.threadLocalCounters();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.numStuck());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ThreadLocalCountersNumStuckSamples;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "threadLocalCounters";
                }
                case 1: {
                    return "numStuck";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.threadLocalCounters())), (int)Statics.longHash((long)this.numStuck())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ThreadLocalCountersNumStuckSamples && ((ThreadLocalCountersNumStuckSamples)x$1).kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() == this.kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer())) break block3;
                    ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)x$1;
                    if (this.numStuck() != threadLocalCountersNumStuckSamples.numStuck()) break block3;
                    ThreadLocalCounters threadLocalCounters = this.threadLocalCounters();
                    ThreadLocalCounters threadLocalCounters2 = threadLocalCountersNumStuckSamples.threadLocalCounters();
                    if ((threadLocalCounters != null ? !threadLocalCounters.equals(threadLocalCounters2) : threadLocalCounters2 != null) || !threadLocalCountersNumStuckSamples.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ BrokerHealthManagerIntegrationTest kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() {
            return this.$outer;
        }

        public ThreadLocalCountersNumStuckSamples(BrokerHealthManagerIntegrationTest $outer, ThreadLocalCounters threadLocalCounters, long numStuck) {
            this.threadLocalCounters = threadLocalCounters;
            this.numStuck = numStuck;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

