/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.availability.AutomaticDemotionStatus;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.Demoted$;
import kafka.availability.Demoting$;
import kafka.availability.NetworkHealthManager;
import kafka.availability.NetworkHealthStatus;
import kafka.availability.NetworkUnhealthy$;
import kafka.availability.Promoted$;
import kafka.availability.Unhealthy$;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.ConfigEntityName$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0005\rEg\u0001\u0002\u001f>\u0001\tCQ!\u0013\u0001\u0005\u0002)C\u0011\"\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001(\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0006\"\u0003/\u0001\u0001\u0004\u0005\t\u0015)\u0003P\u0011%i\u0006\u00011AA\u0002\u0013\u0005a\nC\u0005_\u0001\u0001\u0007\t\u0019!C\u0001?\"I\u0011\r\u0001a\u0001\u0002\u0003\u0006Ka\u0014\u0005\nE\u0002\u0001\r\u00111A\u0005\u00029C\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00013\t\u0013\u0019\u0004\u0001\u0019!A!B\u0013y\u0005\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0001i\u0011%)\b\u00011AA\u0002\u0013\u0005a\u000fC\u0005y\u0001\u0001\u0007\t\u0011)Q\u0005S\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bbBA\u0004\u0001\u0001\u0006Ia\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"!\u0007\u0001A\u0003%\u0011Q\u0002\u0005\n\u00037\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"!\b\u0001A\u0003%\u0011Q\u0002\u0005\t\u0003?\u0001!\u0019!C\u0001u\"9\u0011\u0011\u0005\u0001!\u0002\u0013Y\b\"CA\u0012\u0001\t\u0007I\u0011AA\u0006\u0011!\t)\u0003\u0001Q\u0001\n\u00055\u0001\"CA\u0014\u0001\t\u0007I\u0011AA\u0006\u0011!\tI\u0003\u0001Q\u0001\n\u00055\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001c\u0001\t\u0003\t)\u0007C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003l\u0001!\t!!\u001a\t\u000f\t=\u0004\u0001\"\u0001\u0002f!9!1\u000f\u0001\u0005\u0002\tU\u0004b\u0002BB\u0001\u0011\u0005!Q\u0011\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0011\u001d\u0011y\n\u0001C\u0005\u0005CC\u0011B!/\u0001#\u0003%IAa/\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!Q\u001c\u0001\u0005\n\t}\u0007b\u0002Bt\u0001\u0011%!\u0011\u001e\u0005\b\u0005[\u0004A\u0011\u0002Bx\u0011%\u0019)\u0001AI\u0001\n\u0013\u00199\u0001C\u0005\u0004\f\u0001\t\n\u0011\"\u0003\u0004\u000e!91\u0011\u0003\u0001\u0005\n\rM\u0001bBB\f\u0001\u0011%1\u0011\u0004\u0005\b\u0007C\u0001A\u0011BB\u0012\u0011%\u0019Y\u0003AI\u0001\n\u0013\u00199\u0001C\u0004\u0004.\u0001!Iaa\f\t\u0013\rE\u0003!%A\u0005\n\r5\u0001bBB*\u0001\u0011%1Q\u000b\u0005\b\u0007c\u0002A\u0011BB:\u0011\u001d\u0019)\t\u0001C\u0005\u0007\u000fCqaa%\u0001\t\u0013\u0019)JA\u0012OKR<xN]6IK\u0006dG\u000f['b]\u0006<WM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005yz\u0014\u0001D1wC&d\u0017MY5mSRL(\"\u0001!\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r~\naa]3sm\u0016\u0014\u0018B\u0001%F\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001L!\ta\u0005!D\u0001>\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002\u001fB\u0011A\tU\u0005\u0003#\u0016\u00131bS1gW\u0006\u0014%o\\6fe\u0006q1m\u001c8ue>dG.\u001a:`I\u0015\fHC\u0001+[!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u0011)f.\u001b;\t\u000fm\u001b\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\bg\u0016\u0014h/\u001a:2\u0003-\u0019XM\u001d<feFzF%Z9\u0015\u0005Q\u0003\u0007bB.\u0007\u0003\u0003\u0005\raT\u0001\tg\u0016\u0014h/\u001a:2A\u000591/\u001a:wKJ\u0014\u0014aC:feZ,'OM0%KF$\"\u0001V3\t\u000fmK\u0011\u0011!a\u0001\u001f\u0006A1/\u001a:wKJ\u0014\u0004%A\u0003bI6Lg.F\u0001j!\tQ7/D\u0001l\u0015\t9GN\u0003\u0002n]\u000691\r\\5f]R\u001c(B\u0001!p\u0015\t\u0001\u0018/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0006\u0019qN]4\n\u0005Q\\'!B!e[&t\u0017!C1e[&tw\fJ3r)\t!v\u000fC\u0004\\\u0019\u0005\u0005\t\u0019A5\u0002\r\u0005$W.\u001b8!\u0003\u0015!x\u000e]5d+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013a\u0001;qaU\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u00038\u0002\r\r|W.\\8o\u0013\u0011\t9\"!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006!A\u000f\u001d\u0019!\u0003\r!\b/M\u0001\u0005iB\f\u0004%A\u0007j]R,'O\\1m)>\u0004\u0018nY\u0001\u000fS:$XM\u001d8bYR{\u0007/[2!\u0003\u0011IG\u000f\u001d\u0019\u0002\u000b%$\b\u000f\r\u0011\u0002\t%$\b/M\u0001\u0006SR\u0004\u0018\u0007I\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$2\u0001VA\u0018\u0011\u001d\t\tD\u0007a\u0001\u0003g\t!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d\u007f\u0006!Q\u000f^5m\u0013\u0011\ti$a\u000e\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003tKR,\u0006\u000fF\u0002U\u0003\u0007Bq!!\u0012\u001c\u0001\u0004\t9%\u0001\u0005uKN$\u0018J\u001c4p!\u0011\tI%a\u0016\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n1!\u00199j\u0015\u0011\t\t&a\u0015\u0002\u000f),\b/\u001b;fe*\u0019\u0011QK9\u0002\u000b),h.\u001b;\n\t\u0005e\u00131\n\u0002\t)\u0016\u001cH/\u00138g_\"\u001a1$!\u0018\u0011\t\u0005%\u0013qL\u0005\u0005\u0003C\nYE\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002)\"\u001aA$!\u001b\u0011\t\u0005%\u00131N\u0005\u0005\u0003[\nYEA\u0005BMR,'/R1dQ\u0006\tC/Z:u\tft\u0017-\\5d\u0007>tg-[4t\u0003B\u0004H.[3e!J|\u0007/\u001a:ms\"\u001aQ$a\u001d\u0011\t\u0005%\u0013QO\u0005\u0005\u0003o\nYE\u0001\u0003UKN$\u0018!\u0004;fgR|en\u0015;beR,\b\u000fF\u0002U\u0003{Bq!a \u001f\u0001\u0004\t\t)\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u0007\u000b\tJ\u0004\u0003\u0002\u0006\u00065\u0005cAAD-6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017\u000b\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0010Z\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003'S1!a$WQ\u001dq\u0012qSAR\u0003K\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by%\u0001\u0004qCJ\fWn]\u0005\u0005\u0003C\u000bYJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qU\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\u000fy\tY+a.\u0002:B!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006m\u0015\u0001\u00039s_ZLG-\u001a:\n\t\u0005U\u0016q\u0016\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005m\u0016qX\u0011\u0003\u0003{\u000b!A_6\"\u0005\u0005\u0005\u0017!B6sC\u001a$\u0018!\b;fgR$U-\\8uS>t\u0007+\u001a:tSN$8o\u00148SKN$\u0018M\u001d;\u0015\u0007Q\u000b9\rC\u0004\u0002\u0000}\u0001\r!!!)\u000f}\t9*a)\u0002&\":q$a+\u00028\u00065G\u0006BA^\u0003\u007f\u000b\u0011\u0007^3tiVs\u0007.Z1mi\"Lh*\u001a;x_J\\\u0017)\u001e;p[\u0006$\u0018n\u0019)s_6|G/[8o\u0003:$G)Z7pi&|g\u000eF\u0002U\u0003'Dq!a !\u0001\u0004\t\t\tK\u0004!\u0003/\u000b\u0019+!*)\u000f\u0001\nY+a.\u0002Z2\"\u00111XA`\u0003=#Xm\u001d;BkR|W.\u0019;jG\u0006cG/\u001a:MK\u0006$WM]:iSB<\u0016\u000e\u001e5NC:,\u0018\r\\!mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9SK6|g/\u001b8h\u001b\u0006tW/\u00197EK6|G/[8o\u0019\u0006\u001cH\u000fF\u0003U\u0003?\f\t\u000fC\u0004\u0002\u0000\u0005\u0002\r!!!\t\u000f\u0005\r\u0018\u00051\u0001\u0002f\u0006Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\u0007U\u000b9/C\u0002\u0002jZ\u0013Qa\u00155peRD3!IAw!\u0011\tI%a<\n\t\u0005E\u00181\n\u0002\t\t&\u001c\u0018M\u00197fI\":\u0011%a&\u0002$\u0006\u0015\u0006fB\u0011\u0002x\u0006u\u0018q \t\u0005\u0003[\u000bI0\u0003\u0003\u0002|\u0006=&!C\"tmN{WO]2f\u0003\u00151\u0018\r\\;fYQ\u0011\tA!\u0002\u0003\n\t5!\u0011\u0003B\u000b\u00053\u0011iB!\t\u0003&\u0005\u0012!1A\u0001\u0005u.d\u0013'\t\u0002\u0003\b\u0005!!p\u001b\u00173C\t\u0011Y!\u0001\u0003{W2\u001a\u0014E\u0001B\b\u0003\u0011Q8\u000e\f\u001b\"\u0005\tM\u0011\u0001\u0002>lYU\n#Aa\u0006\u0002\u000f-\u0014\u0018M\u001a;-c\u0005\u0012!1D\u0001\bWJ\fg\r\u001e\u00173C\t\u0011y\"A\u0004le\u00064G\u000fL\u001a\"\u0005\t\r\u0012aB6sC\u001a$H\u0006N\u0011\u0003\u0005O\tqa\u001b:bMRdS'\u0001)uKN$\u0018)\u001e;p[\u0006$\u0018nY!mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9XSRDW*\u00198vC2\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004(+Z7pm&tw-T1ok\u0006dG)Z7pi&|gNR5sgR$R\u0001\u0016B\u0017\u0005_Aq!a #\u0001\u0004\t\t\tC\u0004\u0002d\n\u0002\r!!:)\u000f\t\n9*a)\u0002&\":!%a>\u0002~\nUB\u0006\u0006B\u0001\u0005\u000b\u0011IA!\u0004\u0003\u0012\tU!\u0011\u0004B\u000f\u0005C\u0011)#\u0001\ruKN$XK\\:vG\u000e,7o\u001d4vY\u0012+Wn\u001c;j_:$R\u0001\u0016B\u001e\u0005{Aq!a $\u0001\u0004\t\t\tC\u0004\u0002d\u000e\u0002\r!!:)\u000f\r\n9*a)\u0002&\":1%a>\u0002~\n\rC\u0006\u0006B\u0001\u0005\u000b\u0011IA!\u0004\u0003\u0012\tU!\u0011\u0004B\u000f\u0005C\u0011)#A\u0018uKN$H)Z7pi&|g\u000eT5nSR<\u0016\u000e\u001e5NC:,\u0018\r\\!oI\u0006+Ho\\7bi&\u001cG)Z7pi&|g\u000eF\u0003U\u0005\u0013\u0012Y\u0005C\u0004\u0002\u0000\u0011\u0002\r!!!\t\u000f\u0005\rH\u00051\u0001\u0002f\":A%a&\u0002$\u0006\u0015\u0006f\u0002\u0013\u0002x\u0006u(\u0011\u000b\u0017\u0015\u0005\u0003\u0011)A!\u0003\u0003\u000e\tE!Q\u0003B\r\u0005;\u0011\tC!\n)\u000f\u0011\u0012)&!@\u0003bA!!q\u000bB/\u001b\t\u0011IF\u0003\u0003\u0003\\\u0005-\u0013\u0001\u00039be\u0006dG.\u001a7\n\t\t}#\u0011\f\u0002\n\u000bb,7-\u001e;j_:$#Aa\u0019\n\t\t\u0015$qM\u0001\f'\u0006kUi\u0018+I%\u0016\u000bEI\u0003\u0003\u0003j\te\u0013!D#yK\u000e,H/[8o\u001b>$W-A\u001fuKN$XK\u001c5fC2$\b.\u001f\"s_.,'o\u00155vi\u0012|wO\\,pe.\u001cx+\u001b;i\u001d\u0016$xo\u001c:l+:DW-\u00197uQ&tWm]:GSJ\u001cH\u000fK\u0002&\u0003g\n\u0001\u0006^3ti\u0012Kh.Y7jG\u000e{gNZ5hkJ\fG/[8o!J,g/\u001a8ug\u0012+Wn\u001c;j_:D3AJA:\u0003\u0005\"Xm\u001d;Qe>lw\u000e^5p]\u00063G/\u001a:SK\u000e|gNZ5hkJ\fG/[8o)\r!&q\u000f\u0005\b\u0003G<\u0003\u0019AAsQ\r9\u0013q\u0013\u0015\bO\u0005-&Q\u0010B@\u0003\u0019\u0019\bn\u001c:ug2\u0012!\u0011Q\u000e\u0002\u0007\u0005YC/Z:u!J|Wn\u001c;f\u000bb$XM\u001d8bY\u000e{gN\\3di&4\u0018\u000e^=BMR,'o\u0015;beR,\b\u000fF\u0003U\u0005\u000f\u0013I\tC\u0004\u0002\u0000!\u0002\r!!!\t\u000f\u0005\r\b\u00061\u0001\u0002f\":\u0001&a&\u0002$\u0006\u0015\u0006f\u0002\u0015\u0002x\u0006u(q\u0012\u0017\u0003\u0005K\tq\u0007^3ti\u000ecW-\u0019:j]\u001e$U-\\8uS>t\u0017I\u001c3FqR,'O\\1m\u0007>tg.Z2uSZLG/_!gi\u0016\u00148\u000b^1siV\u0004H#\u0002+\u0003\u0016\n]\u0005bBA@S\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003GL\u0003\u0019AAsQ\u001dI\u0013qSAR\u0003KCs!KA|\u0003{\u0014i\n\f\u0002\u0003&\u00051\u0012m]:feR$U-\\8uS>t7\u000b^1ukN|e\rF\u0004U\u0005G\u0013)Ka,\t\u000b\u0019S\u0003\u0019A(\t\u000f\t\u001d&\u00061\u0001\u0003*\u0006yR\r\u001f9fGR,G-Q;u_6\fG/[2EK6|G/[8o'R\fG/^:\u0011\u00071\u0013Y+C\u0002\u0003.v\u0012q#Q;u_6\fG/[2EK6|G/[8o'R\fG/^:\t\u0013\tE&\u0006%AA\u0002\tM\u0016aF2iK\u000e\\\u0007*Z1mi\"\u001c\u0016-\u001c9mK^Kg\u000eZ8x!\r)&QW\u0005\u0004\u0005o3&a\u0002\"p_2,\u0017M\\\u0001!CN\u001cXM\u001d;EK6|G/[8o'R\fG/^:PM\u0012\"WMZ1vYR$3'\u0006\u0002\u0003>*\"!1\u0017B`W\t\u0011\t\r\u0005\u0003\u0003D\n5WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bf-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t='Q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aG4fiB\u000b'\u000f^5uS>tG*Z1eKJ\u001cxJ\u001c\"s_.,'\u000f\u0006\u0003\u0003V\nm\u0007CBAB\u0005/\fi!\u0003\u0003\u0003Z\u0006M%aA*fi\")a\t\fa\u0001\u001f\u0006\u0011\u0012m]:feRdU-\u00193feND\u0017\u000e](g)\u0015!&\u0011\u001dBr\u0011\u00151U\u00061\u0001P\u0011\u001d\u0011)/\fa\u0001\u0005+\f\u0001d]3sm\u0016\u0014X\t\u001f9fGR,G\rU1si&$\u0018n\u001c8t\u0003E!(/[4hKJ$U-\\8uS>twJ\u001a\u000b\u0004)\n-\b\"\u0002$/\u0001\u0004y\u0015a\u0006;sS\u001e<WM]'b]V\fG\u000eR3n_RLwN\\(g)%!&\u0011\u001fB{\u0005o\u0014Y\u0010C\u0004\u0003t>\u0002\r!!:\u00027\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\b.\u00119j-\u0016\u00148/[8o\u0011\u00151u\u00061\u0001P\u0011%\u0011Ip\fI\u0001\u0002\u0004\t\t)\u0001\u0004sK\u0006\u001cxN\u001c\u0005\n\u0005{|\u0003\u0013!a\u0001\u0005\u007f\f\u0011bY8na>tWM\u001c;\u0011\u0007U\u001b\t!C\u0002\u0004\u0004Y\u0013AAQ=uK\u0006\tCO]5hO\u0016\u0014X*\u00198vC2$U-\\8uS>twJ\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0002\u0016\u0005\u0003\u0003\u0013y,A\u0011ue&<w-\u001a:NC:,\u0018\r\u001c#f[>$\u0018n\u001c8PM\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0010)\"!q B`\u0003I!(/[4hKJ\u0004&o\\7pi&|gn\u00144\u0015\u0007Q\u001b)\u0002C\u0003Ge\u0001\u0007q*\u0001\u0014es:\fW.[2bY2L8i\u001c8gS\u001e,(/Z'ji&<\u0017\r^5p]\u000e{gNZ5h\u001f\u001a$R\u0001VB\u000e\u0007;AQAR\u001aA\u0002=Cqaa\b4\u0001\u0004\t\t)A\u0006d_:4\u0017n\u001a,bYV,\u0017\u0001\u0007;sS\u001e<WM]'b]V\fG\u000e\u0015:p[>$\u0018n\u001c8PMR9Ak!\n\u0004(\r%\u0002bBAri\u0001\u0007\u0011Q\u001d\u0005\u0006\rR\u0002\ra\u0014\u0005\n\u0005s$\u0004\u0013!a\u0001\u0003\u0003\u000b!\u0005\u001e:jO\u001e,'/T1ok\u0006d\u0007K]8n_RLwN\\(gI\u0011,g-Y;mi\u0012\u001a\u0014AH2sK\u0006$X-\u00117uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i%\u0016\fX/Z:u)1\u0019\td!\u0010\u0004@\r%31JB(!\u0011\u0019\u0019d!\u000f\u000e\u0005\rU\"\u0002BB\u001c\u0003#\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007w\u0019)D\u0001\rBYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"\u0014V-];fgRDq!a97\u0001\u0004\t)\u000fC\u0004\u0004BY\u0002\raa\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042!VB#\u0013\r\u00199E\u0016\u0002\u0004\u0013:$\bb\u0002B}m\u0001\u0007\u0011\u0011\u0011\u0005\b\u0007\u001b2\u0004\u0019\u0001B\u0000\u0003)\u0019H/\u0019;vg\u000e{G-\u001a\u0005\n\u0005{4\u0004\u0013!a\u0001\u0005\u007f\f\u0001f\u0019:fCR,\u0017\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIU\nAd]3oI\u0006cG/\u001a:Ce>\\WM\u001d%fC2$\bNU3rk\u0016\u001cH\u000f\u0006\u0004\u0004X\ru3\u0011\r\t\u0005\u0007g\u0019I&\u0003\u0003\u0004\\\rU\"!G!mi\u0016\u0014(I]8lKJDU-\u00197uQJ+7\u000f]8og\u0016Dqaa\u00189\u0001\u0004\u0019\t$A\u0004sKF,Xm\u001d;\t\u000f\r\r\u0004\b1\u0001\u0004f\u0005YA-Z:uS:\fG/[8o!\u0011\u00199g!\u001c\u000e\u0005\r%$bAB6\u007f\u00059a.\u001a;x_J\\\u0017\u0002BB8\u0007S\u0012AbU8dW\u0016$8+\u001a:wKJ\fA\u0003Z3tGJL'-\u001a\"s_.,'\u000fS3bYRDGCBB;\u0007\u0003\u001b\u0019\tE\u0003V\u0007o\u001aY(C\u0002\u0004zY\u0013aa\u00149uS>t\u0007c\u00016\u0004~%\u00191qP6\u0003\u001d\u0011+wM]1eK\u0012\u0014%o\\6fe\")a)\u000fa\u0001\u001f\"9\u00111]\u001dA\u0002\u0005\u0015\u0018aH:f]\u0012$Um]2sS\n,'I]8lKJDU-\u00197uQJ+\u0017/^3tiR11\u0011RBH\u0007#\u0003Baa\r\u0004\f&!1QRB\u001b\u0005q!Um]2sS\n,'I]8lKJDU-\u00197uQJ+7\u000f]8og\u0016Dq!a9;\u0001\u0004\t)\u000fC\u0004\u0004di\u0002\ra!\u001a\u000259,Go^8sW\"+\u0017\r\u001c;i\u001b\u0006tw-\u001a:D_:4\u0017nZ:\u0015\u0011\r]5QWB\\\u0007\u001b\u0004\u0002\"!\u000e\u0004\u001a\u000eu5\u0011V\u0005\u0005\u00077\u000b9DA\u0002NCB\u0004Baa(\u0004&6\u00111\u0011\u0015\u0006\u0005\u0007G\u000b\t\"\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0007O\u001b\tK\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0011\r\u0005U21VBX\u0013\u0011\u0019i+a\u000e\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002k\u0007cK1aa-l\u00055\tE\u000e^3s\u0007>tg-[4Pa\"91\u0011I\u001eA\u0002\u0005\u0005\u0005bBB]w\u0001\u000711X\u0001\fG>tg-[4OC6,7\u000f\u0005\u0004\u0004>\u000e\u001d\u0017\u0011\u0011\b\u0005\u0007\u007f\u001b\u0019M\u0004\u0003\u0002\b\u000e\u0005\u0017\"A,\n\u0007\r\u0015g+A\u0004qC\u000e\\\u0017mZ3\n\t\r%71\u001a\u0002\u0005\u0019&\u001cHOC\u0002\u0004FZCqaa4<\u0001\u0004\u0019Y,\u0001\u0007d_:4\u0017n\u001a,bYV,7\u000f")
public class NetworkHealthManagerIntegrationTest
extends BaseRequestTest {
    private KafkaBroker controller;
    private KafkaBroker server1;
    private KafkaBroker server2;
    private Admin admin;
    private final String topic;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final String internalTopic = (String)CollectionConverters$.MODULE$.SetHasAsScala(Topic.EXTERNAL_CONNECTIVITY_STARTUP_TOPICS).asScala().head();
    private final TopicPartition itp0 = new TopicPartition(this.internalTopic(), 0);
    private final TopicPartition itp1 = new TopicPartition(this.internalTopic(), 1);

    public KafkaBroker controller() {
        return this.controller;
    }

    public void controller_$eq(KafkaBroker x$1) {
        this.controller = x$1;
    }

    public KafkaBroker server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaBroker x$1) {
        this.server1 = x$1;
    }

    public KafkaBroker server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaBroker x$1) {
        this.server2 = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public String internalTopic() {
        return this.internalTopic;
    }

    public TopicPartition itp0() {
        return this.itp0;
    }

    public TopicPartition itp1() {
        return this.itp1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        void var5_5;
        void var4_4;
        SeqOps seqOps;
        block6: {
            List list;
            block5: {
                super.setUp(testInfo);
                this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()));
                if (this.isKRaftTest()) {
                    this.controller_$eq((KafkaBroker)this.brokers().head());
                } else {
                    this.controller_$eq((KafkaBroker)this.getController());
                }
                list = ((IterableOnceOps)((IterableOps)this.brokers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)NetworkHealthManagerIntegrationTest.$anonfun$setUp$1(this, s)))).take(2)).toList();
                if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list))) break block5;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) break block6;
            }
            throw new MatchError((Object)list);
        }
        KafkaBroker first = (KafkaBroker)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        KafkaBroker second = (KafkaBroker)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        this.server1_$eq((KafkaBroker)var4_4);
        this.server2_$eq((KafkaBroker)var5_5);
        scala.collection.immutable.Map replicaAssignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server1().config().brokerId(), this.server2().config().brokerId(), this.controller().config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server2().config().brokerId(), this.server1().config().brokerId(), this.controller().config().brokerId()})))}));
        this.createTopicWithAssignment(this.topic(), (Map<Object, Seq<Object>>)replicaAssignments, this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.internalTopic(), (Map<Object, Seq<Object>>)replicaAssignments, this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), this.topic(), 2);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), this.internalTopic(), 2);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        if (this.admin() != null) {
            this.admin().close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConfigsAppliedProperly() {
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableOps)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        String brokerId = Integer.toString(kafkaServer.config().brokerId());
        NetworkHealthManager networkHealthManager = kafkaServer.networkHealthManager();
        Assertions.assertTrue((boolean)networkHealthManager.config().isNetworkHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        this.dynamicallyConfigureMitigationConfigOf((KafkaBroker)kafkaServer, "false");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$1(networkHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$3(networkHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(brokerId, (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerSampleDurationMsProp(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)"2000", (List)Nil$.MODULE$)));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$5(networkHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"SampleDurationMs is not 2000");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(brokerId, (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerNetworkSampleWindowSizeProp(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)"1000", (List)Nil$.MODULE$)));
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$7(networkHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Num Samples is not 1000");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(brokerId, (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerMinPercentageHealthyNetworkSamplesProp(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)"15", (List)Nil$.MODULE$)));
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$9(networkHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"SampleDurationMs is not 2000");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOnStartup(String quorum) {
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionPersistsOnRestart(String quorum) {
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.server2().shutdown();
        this.server2().startup();
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUnhealthyNetworkAutomaticPromotionAndDemotion(String quorum) {
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerPromotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"zk,1", "zk,2", "zk,3", "zk,4", "zk,5", "kraft,1", "kraft,2", "kraft,3", "kraft,4", "kraft,5"})
    public void testAutomaticAlterLeadershipWithManualAlterLeadershipRemovingManualDemotionLast(String quorum, short apiVersion) {
        this.triggerManualDemotionOf(apiVersion, this.server2(), "manual-reason", BrokerComponent.UNSPECIFIED.id());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerPromotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerManualPromotionOf(apiVersion, this.server2(), "manual-reason");
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"zk,1", "zk,2", "zk,3", "zk,4", "zk,5", "kraft,1", "kraft,2", "kraft,3", "kraft,4", "kraft,5"})
    public void testAutomaticAlterLeadershipWithManualAlterLeadershipRemovingManualDemotionFirst(String quorum, short apiVersion) {
        this.triggerManualDemotionOf(apiVersion, this.server2(), "manual-reason", BrokerComponent.UNSPECIFIED.id());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerManualPromotionOf(apiVersion, this.server2(), "manual-reason");
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerPromotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"zk,1", "zk,2", "zk,3", "zk,4", "zk,5", "kraft,1", "kraft,2", "kraft,3", "kraft,4", "kraft,5"})
    public void testUnsuccessfulDemotion(String quorum, short apiVersion) {
        this.triggerManualDemotionOf(apiVersion, this.server1(), "manual-reason", BrokerComponent.UNSPECIFIED.id());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoting$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.triggerPromotionOf(this.server2());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.triggerManualPromotionOf(apiVersion, this.server1(), "manual-reason");
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"zk,1", "zk,2", "zk,3", "zk,4", "zk,5", "kraft,1", "kraft,2", "kraft,3", "kraft,4", "kraft,5"})
    @Execution(value=ExecutionMode.SAME_THREAD)
    public void testDemotionLimitWithManualAndAutomaticDemotion(String quorum, short apiVersion) {
        this.triggerManualDemotionOf(apiVersion, this.server1(), "manual-reason", BrokerComponent.UNSPECIFIED.id());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoting$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.triggerManualPromotionOf(apiVersion, this.server1(), "manual-reason");
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.triggerPromotionOf(this.server2());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst() {
        VolatileBooleanRef hasCalledExit = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(x$6, x$7) -> NetworkHealthManagerIntegrationTest.$anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$1(hasCalledExit, BoxesRunTime.unboxToInt((Object)x$6), x$7);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_2 = null;
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "0");
        ((KafkaServer)this.server2()).dynamicConfigHandlers().get((Object)"brokers").foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!NetworkHealthManagerIntegrationTest.$anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$3(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker is still Healthy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!NetworkHealthManagerIntegrationTest.$anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$5(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Broker is not undergoing controlled shutdown");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!hasCalledExit.elem) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Exit wasn't triggered");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
        this.server2().shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker to shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server2().startup();
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Timed out waiting for broker to start running");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, false);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    @Test
    public void testDynamicConfigurationPreventsDemotion() {
        this.triggerDemotionOf(this.server1());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.triggerDemotionOf(this.server2());
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoting$.MODULE$, true);
        this.servers().foreach((Function1 & Serializable)server -> {
            NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$1(this, server);
            return BoxedUnit.UNIT;
        });
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, false);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, false);
        this.triggerPromotionOf(this.server1());
        this.servers().foreach((Function1 & Serializable)server -> {
            NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$6(this, server);
            return BoxedUnit.UNIT;
        });
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Demoted$.MODULE$, false);
    }

    @ParameterizedTest
    @ValueSource(shorts={3})
    public void testPromotionAfterReconfiguration(short apiVersion) {
        String x$2 = this.zkConnectOrNull();
        Some x$3 = new Some((Object)this.securityProtocol());
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.serverSaslProperties();
        int x$6 = this.logDirCount();
        boolean x$82 = true;
        boolean x$9 = true;
        boolean x$10 = true;
        boolean x$11 = false;
        boolean x$12 = false;
        boolean x$13 = false;
        Map x$14 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        boolean x$18 = false;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, x$2, x$82, x$9, (Option<SecurityProtocol>)x$3, x$4, x$5, x$10, x$11, x$12, x$13, (Map<Object, String>)x$14, x$6, x$15, x$16, x$17, 3, x$18).head();
        this.brokerPropertyOverrides(props);
        boolean apply_doLog = true;
        this.addBroker(3, new KafkaConfig((java.util.Map)props, apply_doLog));
        ((KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)NetworkHealthManagerIntegrationTest.$anonfun$testPromotionAfterReconfiguration$1(s)))).head()).startup();
        this.servers().foreach((Function1 & Serializable)server -> {
            NetworkHealthManagerIntegrationTest.$anonfun$testPromotionAfterReconfiguration$2(this, server);
            return BoxedUnit.UNIT;
        });
        this.server1().shutdown();
        this.server1().awaitShutdown();
        this.triggerManualDemotionOf(apiVersion, this.server1(), AlterBrokerHealthRequest.networkHealthManagerDetectedAlterBrokerHealthReason, BrokerComponent.UNSPECIFIED.id());
        short describeBrokerHealthApiVersion = apiVersion >= 2 ? (short)1 : 0;
        Option<DegradedBroker> degradedBroker = this.describeBrokerHealth(this.server1(), describeBrokerHealthApiVersion);
        Assertions.assertTrue((degradedBroker.isDefined() && CollectionConverters$.MODULE$.SetHasAsScala(((DegradedBroker)degradedBroker.get()).degradedBrokerComponents()).asScala().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)NetworkHealthManagerIntegrationTest.$anonfun$testPromotionAfterReconfiguration$7(x$8))) ? 1 : 0) != 0);
        this.server1().startup();
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"kraft,5"})
    public void testPromoteExternalConnectivityAfterStartup(String quorum, short apiVersion) {
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
        this.triggerManualDemotionOf(apiVersion, this.server1(), AlterBrokerHealthRequest.networkHealthStartupAlterBrokerHealthReason, BrokerComponent.EXTERNAL_CONNECTIVITY_STARTUP.id());
        this.triggerManualPromotionOf(apiVersion, this.server1(), "trigger-PLE");
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp1()}))));
        this.server1().shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testPromoteExternalConnectivityAfterStartup$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker to shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server1().startup();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testPromoteExternalConnectivityAfterStartup$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for broker to start running");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testPromoteExternalConnectivityAfterStartup$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for broker to become healthy after startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        TestUtils$.MODULE$.waitForBrokersInIsr(this.admin(), this.tp0(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server1().config().brokerId()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr(this.admin(), this.itp0(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server1().config().brokerId()}))));
        this.admin().electLeaders(ElectionType.PREFERRED, null);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"kraft,5"})
    public void testClearingDemotionAndExternalConnectivityAfterStartup(String quorum, short apiVersion) {
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
        this.triggerManualDemotionOf(apiVersion, this.server1(), AlterBrokerHealthRequest.networkHealthStartupAlterBrokerHealthReason, BrokerComponent.EXTERNAL_CONNECTIVITY_STARTUP.id());
        this.triggerDemotionOf(this.server1());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Demoted$.MODULE$, true);
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.tp1(), this.itp0(), this.itp1()}))));
        this.server1().shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker to shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server1().startup();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for broker to start running");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Demoted$.MODULE$, false);
        Option<DegradedBroker> degradedBroker = this.describeBrokerHealth(this.server1(), (short)1);
        Assertions.assertTrue((boolean)degradedBroker.isDefined());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala(((DegradedBroker)degradedBroker.get()).degradedBrokerComponents()).asScala().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)NetworkHealthManagerIntegrationTest.$anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$5(x$9))));
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        this.triggerPromotionOf(this.server1());
        this.assertDemotionStatusOf(this.server1(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for broker to become healthy after startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.assertDemotionStatusOf(this.server2(), (AutomaticDemotionStatus)Promoted$.MODULE$, true);
        TestUtils$.MODULE$.waitForBrokersInIsr(this.admin(), this.tp0(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server1().config().brokerId()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr(this.admin(), this.itp0(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.server1().config().brokerId()}))));
        this.admin().electLeaders(ElectionType.PREFERRED, null);
        this.assertLeadershipOf(this.server1(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0(), this.itp0()}))));
        this.assertLeadershipOf(this.server2(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.itp1()}))));
    }

    /*
     * WARNING - void declaration
     */
    private void assertDemotionStatusOf(KafkaBroker server, AutomaticDemotionStatus expectedAutomaticDemotionStatus, boolean checkHealthSampleWindow) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$assertDemotionStatusOf$1(server, expectedAutomaticDemotionStatus)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)NetworkHealthManagerIntegrationTest.$anonfun$assertDemotionStatusOf$2(server, expectedAutomaticDemotionStatus));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (checkHealthSampleWindow) {
            NetworkHealthStatus networkHealthStatus = server.networkHealthManager().networkHealthStatus();
            NetworkUnhealthy$ networkUnhealthy$ = NetworkUnhealthy$.MODULE$;
            if (networkHealthStatus != null && networkHealthStatus.equals(networkUnhealthy$)) {
                Assertions.assertTrue((server.networkHealthManager().networkSampleWindowSize() > server.networkHealthManager().config().networkHealthManagerNetworkSampleWindowSize() ? 1 : 0) != 0);
            } else {
                Assertions.assertEquals((int)server.networkHealthManager().config().networkHealthManagerNetworkSampleWindowSize(), (int)server.networkHealthManager().networkSampleWindowSize());
            }
            Assertions.assertTrue((boolean)server.networkHealthManager().networkHealthStateTransitionHistory().nonEmpty());
            return;
        }
    }

    private boolean assertDemotionStatusOf$default$3() {
        return true;
    }

    private Set<TopicPartition> getPartitionLeadersOnBroker(KafkaBroker server) {
        if (this.isKRaftTest()) {
            HashSet partitionsOnLeader = (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)this.internalTopic(), (List)Nil$.MODULE$))).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().foreach((Function1 & Serializable)tm -> {
                NetworkHealthManagerIntegrationTest.$anonfun$getPartitionLeadersOnBroker$1(server, partitionsOnLeader, tm);
                return BoxedUnit.UNIT;
            });
            return partitionsOnLeader.toSet();
        }
        return this.getController().kafkaController().controllerContext().partitionLeadersOnBroker(server.config().brokerId()).toSet();
    }

    /*
     * WARNING - void declaration
     */
    private void assertLeadershipOf(KafkaBroker server, Set<TopicPartition> serverExpectedPartitions) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$assertLeadershipOf$1(this, server, serverExpectedPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)NetworkHealthManagerIntegrationTest.$anonfun$assertLeadershipOf$2(this, server, serverExpectedPartitions));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void triggerDemotionOf(KafkaBroker server) {
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(Integer.toString(server.config().brokerId()), (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerNetworkSampleWindowSizeProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerMinPercentageHealthyNetworkSamplesProp(), (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"100", (List)Nil$.MODULE$))));
    }

    private void triggerManualDemotionOf(short alterBrokerHealthApiVersion, KafkaBroker server, String reason, byte component) {
        this.sendAlterBrokerHealthRequest(this.createAlterBrokerHealthRequest(alterBrokerHealthApiVersion, server.config().brokerId(), reason, ComponentHealthStatus.DEGRADED.id(), component), this.brokerSocketServer(this.controller().config().brokerId()));
    }

    private String triggerManualDemotionOf$default$3() {
        return "manual-reason";
    }

    private byte triggerManualDemotionOf$default$4() {
        return BrokerComponent.UNSPECIFIED.id();
    }

    private void triggerPromotionOf(KafkaBroker server) {
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(Integer.toString(server.config().brokerId()), (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerNetworkSampleWindowSizeProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerMinPercentageHealthyNetworkSamplesProp(), (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"2147483647", (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$))));
    }

    private void dynamicallyConfigureMitigationConfigOf(KafkaBroker server, String configValue) {
        this.admin().incrementalAlterConfigs(this.networkHealthMangerConfigs(Integer.toString(server.config().brokerId()), (List<String>)new .colon.colon((Object)KafkaConfig$.MODULE$.NetworkHealthManagerMitigationEnabledProp(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)configValue, (List)Nil$.MODULE$)));
    }

    private void triggerManualPromotionOf(short apiVersion, KafkaBroker server, String reason) {
        this.sendAlterBrokerHealthRequest(this.createAlterBrokerHealthRequest(apiVersion, server.config().brokerId(), reason, ComponentHealthStatus.HEALTHY.id(), BrokerComponent.UNSPECIFIED.id()), this.brokerSocketServer(this.controller().config().brokerId()));
    }

    private String triggerManualPromotionOf$default$3() {
        return "manual-reason";
    }

    private AlterBrokerHealthRequest createAlterBrokerHealthRequest(short apiVersion, int brokerId, String reason, byte statusCode, byte component) {
        return new AlterBrokerHealthRequest.Builder(new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(Predef$.MODULE$.int2Integer(brokerId))).setReason(reason).setComponentCode(component).setStatusCode(statusCode)).build(apiVersion);
    }

    private byte createAlterBrokerHealthRequest$default$5() {
        return BrokerComponent.UNSPECIFIED.id();
    }

    private AlterBrokerHealthResponse sendAlterBrokerHealthRequest(AlterBrokerHealthRequest request, SocketServer destination) {
        return (AlterBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, destination, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Option<DegradedBroker> describeBrokerHealth(KafkaBroker server, short apiVersion) {
        DescribeBrokerHealthResponse describeBrokerHealthResponse = this.sendDescribeBrokerHealthRequest(apiVersion, this.brokerSocketServer(this.controller().config().brokerId()));
        return CollectionConverters$.MODULE$.ListHasAsScala(new DescribeBrokerHealthResponse(describeBrokerHealthResponse.data()).degradedBrokers()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NetworkHealthManagerIntegrationTest.$anonfun$describeBrokerHealth$1(server, x$11)));
    }

    private DescribeBrokerHealthResponse sendDescribeBrokerHealthRequest(short apiVersion, SocketServer destination) {
        return (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)new DescribeBrokerHealthRequest.Builder().build(apiVersion), destination, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private java.util.Map<ConfigResource, Collection<AlterConfigOp>> networkHealthMangerConfigs(String brokerId, List<String> configNames, List<String> configValues) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
        List networkHealthManagerCfg = ((List)configNames.zip(configValues)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                String value = (String)x0$1._2();
                return new ConfigEntry(name, value);
            }
            throw new MatchError(null);
        });
        java.util.List configs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)networkHealthManagerCfg.map((Function1 & Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET))).asJava();
        return Collections.singletonMap(configResource, configs);
    }

    public static final /* synthetic */ boolean $anonfun$setUp$1(NetworkHealthManagerIntegrationTest $this, KafkaBroker s) {
        return s.config().brokerId() != $this.controller().config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$1(NetworkHealthManager networkHealthManager$1) {
        return !networkHealthManager$1.config().isNetworkHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$2() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$3(NetworkHealthManager networkHealthManager$1) {
        return !networkHealthManager$1.isExternalNetworkMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$4() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$5(NetworkHealthManager networkHealthManager$1) {
        return networkHealthManager$1.config().networkHealthManagerSampleDurationMs() == 2000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$6() {
        return "SampleDurationMs is not 2000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$7(NetworkHealthManager networkHealthManager$1) {
        return networkHealthManager$1.config().networkHealthManagerNetworkSampleWindowSize() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$8() {
        return "Num Samples is not 1000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$9(NetworkHealthManager networkHealthManager$1) {
        return networkHealthManager$1.config().networkHealthManagerMinPercentageHealthyNetworkSamples() == 15;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$10() {
        return "SampleDurationMs is not 2000";
    }

    public static final /* synthetic */ Nothing$ $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$1(VolatileBooleanRef hasCalledExit$1, int x$6, Option x$7) {
        hasCalledExit$1.elem = true;
        throw new Exception();
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$3(NetworkHealthManagerIntegrationTest $this) {
        BrokerHealthStatus brokerHealthStatus = $this.server2().brokerHealthManager().brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(unhealthy$);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$4() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$5(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$6() {
        return "Broker is not undergoing controlled shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$7(VolatileBooleanRef hasCalledExit$1) {
        return hasCalledExit$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$8() {
        return "Exit wasn't triggered";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$9(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$10() {
        return "Timed out waiting for broker to shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$11(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownWorksWithNetworkUnhealthinessFirst$12() {
        return "Timed out waiting for broker to start running";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigurationPreventsDemotion$2(KafkaServer server$1) {
        return !server$1.networkHealthManager().config().isNetworkHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigurationPreventsDemotion$3() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigurationPreventsDemotion$4(KafkaServer server$1) {
        return !server$1.networkHealthManager().isExternalNetworkMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigurationPreventsDemotion$5() {
        return "Mitigation must be off";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDynamicConfigurationPreventsDemotion$1(NetworkHealthManagerIntegrationTest $this, KafkaServer server) {
        $this.dynamicallyConfigureMitigationConfigOf((KafkaBroker)server, "false");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$2(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$4(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigurationPreventsDemotion$7(KafkaServer server$2) {
        return !server$2.networkHealthManager().config().isNetworkHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigurationPreventsDemotion$8() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigurationPreventsDemotion$9(KafkaServer server$2) {
        return !server$2.networkHealthManager().isExternalNetworkMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigurationPreventsDemotion$10() {
        return "Mitigation must be off";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDynamicConfigurationPreventsDemotion$6(NetworkHealthManagerIntegrationTest $this, KafkaServer server) {
        $this.dynamicallyConfigureMitigationConfigOf((KafkaBroker)server, "true");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$7(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testDynamicConfigurationPreventsDemotion$9(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPromotionAfterReconfiguration$1(KafkaServer s) {
        return s.config().brokerId() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testPromotionAfterReconfiguration$3(KafkaServer server$3) {
        return !server$3.networkHealthManager().config().isNetworkHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testPromotionAfterReconfiguration$4() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testPromotionAfterReconfiguration$5(KafkaServer server$3) {
        return !server$3.networkHealthManager().isExternalNetworkMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testPromotionAfterReconfiguration$6() {
        return "Mitigation must be off";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testPromotionAfterReconfiguration$2(NetworkHealthManagerIntegrationTest $this, KafkaServer server) {
        $this.dynamicallyConfigureMitigationConfigOf((KafkaBroker)server, "false");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testPromotionAfterReconfiguration$3(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!NetworkHealthManagerIntegrationTest.$anonfun$testPromotionAfterReconfiguration$5(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mitigation must be off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPromotionAfterReconfiguration$7(DegradedBrokerComponent x$8) {
        String string = x$8.reason();
        String string2 = AlterBrokerHealthRequest.networkHealthManagerDetectedAlterBrokerHealthReason;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPromoteExternalConnectivityAfterStartup$1(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server1().brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPromoteExternalConnectivityAfterStartup$2() {
        return "Timed out waiting for broker to shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testPromoteExternalConnectivityAfterStartup$3(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server1().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPromoteExternalConnectivityAfterStartup$4() {
        return "Timed out waiting for broker to start running";
    }

    public static final /* synthetic */ boolean $anonfun$testPromoteExternalConnectivityAfterStartup$5(NetworkHealthManagerIntegrationTest $this) {
        return $this.describeBrokerHealth($this.server1(), (short)1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPromoteExternalConnectivityAfterStartup$6() {
        return "Timed out waiting for broker to become healthy after startup";
    }

    public static final /* synthetic */ boolean $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$1(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server1().brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$2() {
        return "Timed out waiting for broker to shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$3(NetworkHealthManagerIntegrationTest $this) {
        BrokerState brokerState = $this.server1().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$4() {
        return "Timed out waiting for broker to start running";
    }

    public static final /* synthetic */ boolean $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$5(DegradedBrokerComponent x$9) {
        String string = x$9.reason();
        String string2 = AlterBrokerHealthRequest.networkHealthStartupAlterBrokerHealthReason;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$6(NetworkHealthManagerIntegrationTest $this) {
        return $this.describeBrokerHealth($this.server1(), (short)1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClearingDemotionAndExternalConnectivityAfterStartup$7() {
        return "Timed out waiting for broker to become healthy after startup";
    }

    public static final /* synthetic */ boolean $anonfun$assertDemotionStatusOf$1(KafkaBroker server$4, AutomaticDemotionStatus expectedAutomaticDemotionStatus$1) {
        AutomaticDemotionStatus automaticDemotionStatus = server$4.networkHealthManager().brokerAutomaticDemotionStatus();
        return !(automaticDemotionStatus != null ? !automaticDemotionStatus.equals(expectedAutomaticDemotionStatus$1) : expectedAutomaticDemotionStatus$1 != null);
    }

    public static final /* synthetic */ String $anonfun$assertDemotionStatusOf$2(KafkaBroker server$4, AutomaticDemotionStatus expectedAutomaticDemotionStatus$1) {
        return new StringBuilder(16).append("Network is ").append(server$4.networkHealthManager().brokerAutomaticDemotionStatus()).append(" not ").append(expectedAutomaticDemotionStatus$1).toString();
    }

    public static final /* synthetic */ void $anonfun$getPartitionLeadersOnBroker$1(KafkaBroker server$5, HashSet partitionsOnLeader$1, MetadataResponse.TopicMetadata tm) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(tm.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.partition()), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)partition -> {
            if (partition.leaderId.isPresent() && BoxesRunTime.equals(partition.leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)server$5.config().brokerId()))) {
                return BoxesRunTime.boxToBoolean((boolean)partitionsOnLeader$1.add((Object)partition.topicPartition));
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$assertLeadershipOf$1(NetworkHealthManagerIntegrationTest $this, KafkaBroker server$6, Set serverExpectedPartitions$1) {
        Set<TopicPartition> set = $this.getPartitionLeadersOnBroker(server$6);
        return !(set != null ? !set.equals((Object)serverExpectedPartitions$1) : serverExpectedPartitions$1 != null);
    }

    public static final /* synthetic */ String $anonfun$assertLeadershipOf$2(NetworkHealthManagerIntegrationTest $this, KafkaBroker server$6, Set serverExpectedPartitions$1) {
        return new StringBuilder(19).append("Leadership is ").append($this.getPartitionLeadersOnBroker(server$6)).append(" not ").append(serverExpectedPartitions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$describeBrokerHealth$1(KafkaBroker server$7, DegradedBroker x$11) {
        return x$11.brokerId() == server$7.config().brokerId();
    }

    public NetworkHealthManagerIntegrationTest() {
        this.topic = "topic";
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerMitigationEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerMinPercentageHealthyNetworkSamplesProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerNetworkSampleWindowSizeProp(), "2147483647");
        this.serverConfig().put(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "34");
        this.serverConfig().put(KafkaConfig$.MODULE$.NetworkHealthManagerExternalConnectivityStartupEnabledProp(), "true");
    }
}

