/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import io.confluent.kafka.availability.NetworkAvailabilityManager;
import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.MockAsyncAuthExecutor;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0002\u0004\b\u00011AQa\u0005\u0001\u0005\u0002QAQa\u0006\u0001\u0005\u0002aAQ!\u000b\u0001\u0005\u0002aAQa\u000b\u0001\u0005\n1BQ!\u0011\u0001\u0005\n\t\u0013AeU1tY\u0006+H\u000f[3oi&\u001c\u0017\r^8s\u0007>tg.Z2uS>t\u0007+\u001b8hgR+7\u000f\u001e\u0006\u0003\u0011%\tA\"\u0019<bS2\f'-\u001b7jifT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\u001d\tA\u0004^3ti2\u000bG/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fF\u0001\u001a!\tq!$\u0003\u0002\u001c\u001f\t!QK\\5uQ\t\u0011Q\u0004\u0005\u0002\u001fO5\tqD\u0003\u0002!C\u0005\u0019\u0011\r]5\u000b\u0005\t\u001a\u0013a\u00026va&$XM\u001d\u0006\u0003I\u0015\nQA[;oSRT\u0011AJ\u0001\u0004_J<\u0017B\u0001\u0015 \u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^\"p]:,7\r^5p]BKgnZ:Ba&4VM]:j_:\u001c(+Z9vKN$\bFA\u0002\u001e\u0003Y!Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$H\u0003B\r.e}BQA\f\u0003A\u0002=\nqA^3sg&|g\u000e\u0005\u0002\u000fa%\u0011\u0011g\u0004\u0002\u0006'\"|'\u000f\u001e\u0005\u0006g\u0011\u0001\r\u0001N\u0001\u0015Kb\u0004Xm\u0019;fIN{g\r^<be\u0016t\u0015-\\3\u0011\u0005UbdB\u0001\u001c;!\t9t\"D\u00019\u0015\tI4\"\u0001\u0004=e>|GOP\u0005\u0003w=\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111h\u0004\u0005\u0006\u0001\u0012\u0001\r\u0001N\u0001\u0018Kb\u0004Xm\u0019;fIN{g\r^<be\u00164VM]:j_:\f!c]3ukB\fU\u000f\u001e5f]RL7-\u0019;peR91\t\u00154oaVT\bC\u0001#O\u001b\u0005)%B\u0001$H\u00035\tW\u000f\u001e5f]RL7-\u0019;pe*\u0011\u0001*S\u0001\tg\u0016\u001cWO]5us*\u0011!jS\u0001\u0007G>lWn\u001c8\u000b\u0005)a%BA'&\u0003\u0019\t\u0007/Y2iK&\u0011q*\u0012\u0002\u0018'\u0006\u001cHnU3sm\u0016\u0014\u0018)\u001e;iK:$\u0018nY1u_JDQ!U\u0003A\u0002I\u000bqaY8oM&<7\u000f\r\u0002T;B!A+\u0017\u001b\\\u001b\u0005)&B\u0001,X\u0003\u0011)H/\u001b7\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0004\u001b\u0006\u0004\bC\u0001/^\u0019\u0001!\u0011B\u0018)\u0002\u0002\u0003\u0005)\u0011A0\u0003\u0007}#\u0013'\u0005\u0002aGB\u0011a\"Y\u0005\u0003E>\u0011qAT8uQ&tw\r\u0005\u0002\u000fI&\u0011Qm\u0004\u0002\u0004\u0003:L\b\"B4\u0006\u0001\u0004A\u0017A\u0004;sC:\u001c\bo\u001c:u\u0019\u0006LXM\u001d\t\u0003S2l\u0011A\u001b\u0006\u0003W&\u000bqA\\3uo>\u00148.\u0003\u0002nU\nqAK]1ogB|'\u000f\u001e'bs\u0016\u0014\b\"B8\u0006\u0001\u0004!\u0014!C7fG\"\fg.[:n\u0011\u0015\tX\u00011\u0001s\u0003AiW\r^1eCR\f'+Z4jgR\u0014\u0018\u0010\u0005\u0002jg&\u0011AO\u001b\u0002\u0018\u0007\"\fgN\\3m\u001b\u0016$\u0018\rZ1uCJ+w-[:uefDQA^\u0003A\u0002]\fQ#[:J]R,'O\u0011:pW\u0016\u0014H*[:uK:,'\u000f\u0005\u0002\u000fq&\u0011\u0011p\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015YX\u00011\u0001}\u0003iqW\r^<pe.\fe/Y5mC\nLG.\u001b;z\u001b\u0006t\u0017mZ3s!\ri\u0018\u0011B\u0007\u0002}*\u0011\u0001b \u0006\u0004\u0015\u0005\u0005!\u0002BA\u0002\u0003\u000b\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005\u001d\u0011AA5p\u0013\r\tYA \u0002\u001b\u001d\u0016$xo\u001c:l\u0003Z\f\u0017\u000e\\1cS2LG/_'b]\u0006<WM\u001d")
public class SaslAuthenticatorConnectionPingsTest {
    @Test
    public void testLatestApiVersionsRequest() {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), "apache-kafka-java", AppInfoParser.getVersion());
    }

    @Test
    public void testConnectionPingsApiVersionsRequest() {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME(), AppInfoParser.getVersion());
    }

    private void testApiVersionsRequest(short version, String expectedSoftwareName, String expectedSoftwareVersion) {
        String string = expectedSoftwareName;
        String string2 = NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
        boolean isConnectionPingsClient = !(string != null ? !string.equals(string2) : string2 != null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        NetworkAvailabilityManager networkAvailabilityManager = new NetworkAvailabilityManager(KafkaConfig$.MODULE$.fromProps(props));
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        DefaultChannelMetadataRegistry metadataRegistry = new DefaultChannelMetadataRegistry();
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)metadataRegistry, false, networkAvailabilityManager);
        ByteBuffer headerBuffer = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(ApiKeys.API_VERSIONS, version, "clientId", 0));
        ByteBuffer requestBuffer = (isConnectionPingsClient ? new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName(expectedSoftwareName).setClientSoftwareVersion(AppInfoParser.getVersion()), version) : new ApiVersionsRequest.Builder().build(version)).serialize();
        requestBuffer.rewind();
        Mockito.when((Object)transportLayer.socketChannel().socket().getInetAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class)))).then(invocation -> BoxesRunTime.boxToInteger((int)SaslAuthenticatorConnectionPingsTest.foo$1(invocation, headerBuffer, requestBuffer))).then(invocation -> BoxesRunTime.boxToInteger((int)SaslAuthenticatorConnectionPingsTest.foo$2(invocation, headerBuffer, requestBuffer)));
        Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.connectionPings());
        Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.externalRequests());
        Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.healthCheckRequests());
        authenticator.authenticate();
        if (isConnectionPingsClient) {
            Assertions.assertEquals((long)1L, (long)networkAvailabilityManager.connectionPings());
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.externalRequests());
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.healthCheckRequests());
        } else {
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.connectionPings());
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.externalRequests());
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.healthCheckRequests());
        }
        Assertions.assertEquals((Object)expectedSoftwareName, (Object)metadataRegistry.clientInformation().softwareName());
        Assertions.assertEquals((Object)expectedSoftwareVersion, (Object)metadataRegistry.clientInformation().softwareVersion());
        ((ReadableByteChannel)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism, ChannelMetadataRegistry metadataRegistry, boolean isInterBrokerListener, NetworkAvailabilityManager networkAvailabilityManager) {
        new TestJaasConfig().addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap());
        Map<String, Subject> subjects = Collections.singletonMap(mechanism, new Subject());
        Map<String, SaslServerCallbackHandler> callbackHandlers = Collections.singletonMap(mechanism, new SaslServerCallbackHandler());
        ApiMessageType.ListenerType confluentCloudApiVersionsResponse_listenerType = ApiMessageType.ListenerType.ZK_BROKER;
        Object var10_9 = null;
        ApiVersionsResponse apiVersionsResponse = TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)confluentCloudApiVersionsResponse_listenerType, (boolean)true, (ApiMessageType.ApiVisibility)ApiMessageType.ApiVisibility.CONFLUENT_CLOUD);
        return new SaslServerAuthenticator(configs, callbackHandlers, "node", -1L, subjects, null, new ListenerName("ssl"), isInterBrokerListener, SecurityProtocol.SASL_SSL, transportLayer, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), (AsyncAuthExecutor)new MockAsyncAuthExecutor(), metadataRegistry, Time.SYSTEM, () -> apiVersionsResponse, (RequestCallback)networkAvailabilityManager);
    }

    private static final int foo$1(InvocationOnMock invocation, ByteBuffer headerBuffer$1, ByteBuffer requestBuffer$1) {
        ((ByteBuffer)invocation.getArgument(0)).putInt(headerBuffer$1.remaining() + requestBuffer$1.remaining());
        return 4;
    }

    private static final int foo$2(InvocationOnMock invocation, ByteBuffer headerBuffer$1, ByteBuffer requestBuffer$1) {
        ((ByteBuffer)invocation.getArgument(0)).put(headerBuffer$1.duplicate()).put(requestBuffer$1.duplicate());
        return headerBuffer$1.remaining() + requestBuffer$1.remaining();
    }
}

