/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kafka.catalog.MetadataCollectorTestUtils$;
import kafka.catalog.MetadataEventUtils;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.server.link.ConnectionMode;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT, brokers=3, controllers=3)
@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019Y\u0005\u0001)A\u0005\u0007\"9A\n\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0004O\u0001\t\u0007I\u0011\u0001\"\t\r=\u0003\u0001\u0015!\u0003D\u0011\u001d\u0001\u0006A1A\u0005\u0002\tCa!\u0015\u0001!\u0002\u0013\u0019\u0005b\u0002*\u0001\u0005\u0004%\tA\u0011\u0005\u0007'\u0002\u0001\u000b\u0011B\"\t\u000bQ\u0003A\u0011A+\t\u000b\u0001\u0004A\u0011A+\t\u000bm\u0004A\u0011A+\t\r\u0005]\u0001\u0001\"\u0001V\u0011\u0019\tI\u0003\u0001C\u0001+\"1\u0011Q\u0007\u0001\u0005\u0002UCa!!\u0011\u0001\t\u0003)\u0006bBA$\u0001\u0011%\u0011\u0011\n\u0005\u0007\u0003#\u0002A\u0011B+\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!1\u0011Q\u000f\u0001\u0005\nUCq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002~\u0001!I!a \u0003K-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007>dG.Z2u_JLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u000f\u001e\u0003\u001d\u0019\u0017\r^1m_\u001eT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\tI\u0013H\u0004\u0002+m9\u00111f\r\b\u0003YEr!!\f\u0019\u000e\u00039R!aL\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u001a\u001e\u0003\u0011!Xm\u001d;\n\u0005Q*\u0014!\u00026v]&$(B\u0001\u001a\u001e\u0013\t9\u0004(\u0001\u000fSC\u001a$8\t\\;ti\u0016\u0014\u0018J\u001c<pG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b\u0005Q*\u0014B\u0001\u001e<\u0005M\u0011\u0016M\u001a;DYV\u001cH/\u001a:J]N$\u0018M\\2f\u0015\t9\u0004(\u0001\u0004=S:LGO\u0010\u000b\u0003}\u0001\u0003\"a\u0010\u0001\u000e\u0003mAQa\n\u0002A\u0002!\na\u0001^3oC:$X#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n11\u000b\u001e:j]\u001e\fq\u0001^3oC:$\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\fG2,8\u000f^3s\u0019&t7.\u0001\u0007dYV\u001cH/\u001a:MS:\\\u0007%A\u0007gk2dGk\u001c9jG:\u000bW.Z\u0001\u000fMVdG\u000eV8qS\u000et\u0015-\\3!\u0003M1W\u000f\u001c7DYV\u001cH/\u001a:MS:\\g*Y7f\u0003Q1W\u000f\u001c7DYV\u001cH/\u001a:MS:\\g*Y7fA\u0005iB/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G\u000e\\3di>\u0014H)[:bE2,G\rF\u0001W!\t\u0011s+\u0003\u0002YG\t!QK\\5uQ\ti!\f\u0005\u0002\\=6\tAL\u0003\u0002^k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}c&aC\"mkN$XM\u001d+fgR\fA\u0004^3ti6+G/\u00193bi\u0006\u001cu\u000e\u001c7fGR|'/\u00128bE2,G\r\u000b\u0003\u000fE6t\u0007CA2l\u001b\u0005!'BA3g\u0003\r\t\u0007/\u001b\u0006\u0003O\"\fqA[;qSR,'O\u0003\u00025S*\t!.A\u0002pe\u001eL!\u0001\u001c3\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\t!\u0002\u000b\u0003\u000f5B\f\u0018\u0001E:feZ,'\u000f\u0015:pa\u0016\u0014H/[3tY\u0005\u00118&B:wo6L\bCA.u\u0013\t)HLA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001y\u0003\t\u001awN\u001c4mk\u0016tGOL2bi\u0006dwn\u001a\u0018d_2dWm\u0019;pe:*g.\u00192mK\u0006\n!0\u0001\u0003ueV,\u0017\u0001\u0006;fgR$v\u000e]5d\t\u0016dG/Y#wK:$8\u000f\u000b\u0003\u00105BlHF\u0002:\u007f\u0003\u0007\tiaK\u0003tm~l\u00170\t\u0002\u0002\u0002\u0005y3m\u001c8gYV,g\u000e\u001e\u0018dCR\fGn\\4/G>dG.Z2u_Jtc-\u001e7m]\r|gNZ5hg:*g.\u00192mK.:1O^A\u0003[\u0006%\u0011EAA\u0004\u0003M\u001awN\u001c4mk\u0016tGOL2bi\u0006dwn\u001a\u0018d_2dWm\u0019;pe:\u001ah.\u00199tQ>$h&\u001b8ji:\"W\r\\1z]M,7-\t\u0002\u0002\f\u0005\u00111\u0007M\u0016\bgZ\fy!\\A\nC\t\t\t\"\u0001\tnKR\u0014\u0018n\u0019\u0018sKB|'\u000f^3sg\u0006\u0012\u0011QC\u0001$W\u000647.\u0019\u0018uKN$h&T8dW\u00163XM\u001c;F[&$H/\u001a:Qe>4\u0018\u000eZ3s\u0003]!Xm\u001d;U_BL7m\u00158baNDw\u000e^#wK:$8\u000fK\u0003\u00115B\fY\u0002L\u0004s\u0003;\t\u0019#!\u0004,\u000fM4\u0018QA7\u0002 \u0005\u0012\u0011\u0011E\u0001\u0002e-:1O^A\u0013[\u0006}\u0011EAA\u0014\u0003E\u001awN\u001c4mk\u0016tGOL2bi\u0006dwn\u001a\u0018d_2dWm\u0019;pe:\u001ah.\u00199tQ>$h&\u001b8uKJ4\u0018\r\u001c\u0018tK\u000e\fQ\u0003^3ti6+H\u000e^5UK:\fg\u000e^#wK:$8\u000fK\u0003\u00125B\fi\u0003L\u0004s\u0003_\t\u0019#!\u0004,\u000fM4\u0018QA7\u00022\u0005\u0012\u00111G\u0001\u0002a\u00059C/Z:u\u00072,8\u000f^3s\u0019&t7.\u00118e\u001b&\u0014(o\u001c:U_BL7\rR3mi\u0006,e/\u001a8uQ\u0015\u0011\"\f]A\u001dY\u001d\u0011\u0018QDA\u001e\u0003\u001bYsa\u001d<\u0002&5\fi$\t\u0002\u0002@\u0005\t\u0011'A\u0016uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0003:$W*\u001b:s_J$v\u000e]5d':\f\u0007o\u001d5pi\u00163XM\u001c;tQ\u0015\u0019\"\f]A#Y\u001d\u0011\u0018QDA\u001e\u0003\u001b\tA#Y2uSZ,7i\u001c7mK\u000e$xN]\"pk:$XCAA&!\r\u0011\u0013QJ\u0005\u0004\u0003\u001f\u001a#aA%oi\u0006ab/\u001a:jMf|e\u000e\\=P]\u0016\f5\r^5wK\u000e{G\u000e\\3di>\u0014\u0018aC2p]R\u0014x\u000e\u001c7feN$\"!a\u0016\u0011\r\u0005e\u00131MA5\u001d\u0011\tY&a\u0018\u000f\u00075\ni&C\u0001%\u0013\r\t\tgI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)'a\u001a\u0003\u0011%#XM]1cY\u0016T1!!\u0019$!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8;\u000511/\u001a:wKJLA!a\u001d\u0002n\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\u0013G>tGO]8mY\u0016\u0014h)Y5m_Z,'/\u0001\u0010xC&$hi\u001c:D_:\u001c\u0018n\u001d;f]R\\%+\u00194u\u001b\u0016$\u0018\rZ1uCR\u0019a+a\u001f\t\u000b\u001dB\u0002\u0019\u0001\u0015\u0002+M,G/\u001e9N_\u000e\\WI^3oi\u0016k\u0017\u000e\u001e;feR\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000b9*\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0019)g/\u001a8ug*\u0019Q-a#\u000b\t\u00055\u0015qR\u0001\ni\u0016dW-\\3uefTA!!%\u0002\u0014\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003+\u000b!![8\n\t\u0005e\u0015Q\u0011\u0002\r\u000bZ,g\u000e^#nSR$XM\u001d\u0015\u0007\u0001\u0005uU.!+\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)e\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002(\u0006\u0005&AC#yi\u0016tGmV5uQ2\u0012\u00111V\u0012\u0003\u0003[\u0003B!a,\u000226\t\u0001(C\u0002\u00024b\u0012Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000fK\b\u0001\u0003o\u000bi,a0\u0002J\u0006-\u00171KAf!\rY\u0016\u0011X\u0005\u0004\u0003wc&aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001c\u0018aC2mkN$XM\u001d+za\u0016$#!!1\n\t\u0005\r\u0017QY\u0001\u0006\u0017J\u000be\t\u0016\u0006\u0004\u0003\u000fd\u0016\u0001\u0002+za\u0016\fqA\u0019:pW\u0016\u00148/H\u0001\u0004Q\u0015\u0001!-\\Ah=\u0005A\bF\u0002\u0001\u0002T6\fI\u000eE\u0002d\u0003+L1!a6e\u0005\r!\u0016mZ\u0011\u0003\u00037\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class KRaftMetadataCollectorIntegrationTest {
    private final RaftClusterInvocationContext.RaftClusterInstance cluster;
    private final String tenant;
    private final String topic;
    private final String clusterLink;
    private final String fullTopicName;
    private final String fullClusterLinkName;

    public String tenant() {
        return this.tenant;
    }

    public String topic() {
        return this.topic;
    }

    public String clusterLink() {
        return this.clusterLink;
    }

    public String fullTopicName() {
        return this.fullTopicName;
    }

    public String fullClusterLinkName() {
        return this.fullClusterLinkName;
    }

    @ClusterTest
    public void testMetadataCollectorDisabled() {
        this.cluster.waitForReadyBrokers();
        this.cluster.controllers().forEach(controller -> Assertions.assertFalse((boolean)controller.metadataCollector().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActive()))));
    }

    @Timeout(value=10L)
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true")})
    public void testMetadataCollectorEnabled() {
        this.cluster.waitForReadyBrokers();
        this.verifyOnlyOneActiveCollector();
        this.controllerFailover();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testMetadataCollectorEnabled$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No active collector after leader change");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.verifyOnlyOneActiveCollector();
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.full.configs.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="30"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicDeltaEvents() {
        Option<Event> option;
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        int numPartitions = 2;
        short replicationFactor = 2;
        Admin adminClient = this.cluster.createAdminClient();
        long overrideRetention = 86400000L;
        ConfigEntry entry = new ConfigEntry("log.retention.ms", Long.toString(overrideRetention));
        Set<AlterConfigOp> config = Collections.singleton(new AlterConfigOp(entry, AlterConfigOp.OpType.SET));
        ConfigResource broker = new ConfigResource(ConfigResource.Type.BROKER, "");
        adminClient.incrementalAlterConfigs(Collections.singletonMap(broker, config)).all().get();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, this.fullTopicName(), numPartitions, replicationFactor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event topicCreationEvent = (Event)option.get();
        int initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(topicCreationEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$2 = this.tenant();
        String x$3 = this.topic();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions));
        Some x$5 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)overrideRetention));
        Option<Object> x$9 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$10 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$11 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$12 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$13 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$14 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$15 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$16 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicCreationEvent, x$2, x$3, (Option<Object>)x$4, (Option<Object>)x$5, (Option<Object>)x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, initEpoch, true);
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fullTopicName()), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionsMap).asJava()).values().get(this.fullTopicName())).get();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event partitionsChangeEvent = (Event)option.get();
        String x$18 = this.tenant();
        String x$19 = this.topic();
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions));
        Some x$21 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        Some x$22 = new Some((Object)BoxesRunTime.boxToLong((long)overrideRetention));
        Option<Object> x$25 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$26 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$27 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$28 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$29 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$30 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$31 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$32 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(partitionsChangeEvent, x$18, x$19, (Option<Object>)x$20, (Option<Object>)x$21, (Option<Object>)x$22, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, initEpoch, true);
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.fullTopicName());
        long newRetention = 100000L;
        ConfigEntry retentionEntry = new ConfigEntry("retention.ms", Long.toString(newRetention));
        AlterConfigOp op = new AlterConfigOp(retentionEntry, AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJava())}));
        ((KafkaFuture)adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava()).values().get(resource)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event retentionChangeEvent = (Event)option.get();
        String x$34 = this.tenant();
        String x$35 = this.topic();
        Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions));
        Some x$37 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        Some x$38 = new Some((Object)BoxesRunTime.boxToLong((long)newRetention));
        Option<Object> x$41 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$42 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$43 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$44 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$45 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$46 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$47 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$48 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(retentionChangeEvent, x$34, x$35, (Option<Object>)x$36, (Option<Object>)x$37, (Option<Object>)x$38, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, initEpoch, true);
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        adminClient.deleteTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.fullTopicName(), (List)Nil$.MODULE$)).asJava()).all().get();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event topicDeletionEvent = (Event)option.get();
        String x$50 = this.tenant();
        String x$51 = this.topic();
        Option<Object> x$54 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$4();
        Option<Object> x$55 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$5();
        Option<Object> x$56 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$6();
        Option<Object> x$57 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$60 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$61 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$62 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$63 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$64 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicDeletionEvent, x$50, x$51, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, initEpoch, true);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicSnapshotEvents() {
        Option<Event> option;
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, this.fullTopicName(), numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds)).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)option.get();
        int initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(snapshotEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$2 = this.tenant();
        String x$3 = this.topic();
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        boolean x$19 = true;
        int x$20 = 0;
        int x$21 = 1;
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent, x$2, x$3, numPartitions, replicationFactor, (Option<Object>)x$7, (Option<Object>)x$8, (Option<TopicMetadata.CleanupPolicy>)x$9, (Option<String>)x$10, (Option<String>)x$11, (Option<String>)x$12, (Option<String>)x$13, (Option<String>)x$14, (Option<ClusterLinkConfig.LinkMode>)x$15, (Option<ConnectionMode>)x$16, (Option<String>)x$17, (Option<String>)x$18, x$19, initEpoch, x$20, x$21);
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fullTopicName()), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionsMap).asJava()).values().get(this.fullTopicName())).get();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds)).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent2 = (Event)option.get();
        String x$23 = this.tenant();
        String x$24 = this.topic();
        Option<Object> x$28 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$29 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$30 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$31 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$32 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$10();
        Option<String> x$33 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$34 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$35 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        Option<ClusterLinkConfig.LinkMode> x$36 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$14();
        Option<ConnectionMode> x$37 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$15();
        Option<String> x$38 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$16();
        Option<String> x$39 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$17();
        boolean x$40 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$41 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$42 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent2, x$23, x$24, newNumPartitions, replicationFactor, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, initEpoch, x$41, x$42);
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        this.controllerFailover();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No active controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        int newEpoch = initEpoch + 1;
        EventEmitter newMockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllersMap().values()).asScala().flatMap((Function1 & Serializable)x$4 -> x$4.metadataCollector())).find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isActive())).map((Function1 & Serializable)x$6 -> x$6.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter, (scala.collection.mutable.Set<String>)eventIds)).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent3 = (Event)option.get();
        String x$44 = this.tenant();
        String x$45 = this.topic();
        Option<Object> x$49 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$50 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$51 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$52 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$53 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$10();
        Option<String> x$54 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$55 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$56 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        Option<ClusterLinkConfig.LinkMode> x$57 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$14();
        Option<ConnectionMode> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$15();
        Option<String> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$16();
        Option<String> x$60 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$17();
        boolean x$61 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$62 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$63 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent3, x$44, x$45, newNumPartitions, replicationFactor, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, newEpoch, x$62, x$63);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="0"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMultiTenantEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set newEvents = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant1 = "lkc-t1";
        String tenant2 = "lkc-t2";
        String topic1 = "topic1";
        String fullTopicName1 = new StringBuilder(1).append(tenant1).append("_").append(topic1).toString();
        String topic2 = "topic2";
        String fullTopicName2 = new StringBuilder(1).append(tenant1).append("_").append(topic2).toString();
        String topic3 = "topic3";
        String fullTopicName3 = new StringBuilder(1).append(tenant2).append("_").append(topic3).toString();
        scala.collection.mutable.Map mapping = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant1), Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant2), Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic3})))}));
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName1, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName2, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName3, numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$1(mockEventEmitter, eventIds, newEvents)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Not enough events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOnceOps)newEvents.map((Function1 & Serializable)event -> MetadataChange.parseFrom((byte[])((byte[])event.data().get())))).foreach((Function1 & Serializable)change -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$4(mapping, change);
            return BoxedUnit.UNIT;
        });
        mapping.values().foreach((Function1 & Serializable)pendingTopics -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$7(pendingTopics);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="1"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testClusterLinkAndMirrorTopicDeltaEvent() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        int numPartitions = 1;
        short replicationFactor = 1;
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin) -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicDeltaEvent$1(this, numPartitions, replicationFactor, adminClient, lastNewEvent, mockEventEmitter, eventIds, remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="1"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testClusterLinkAndMirrorTopicSnapshotEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        int numPartitions = 1;
        short replicationFactor = 1;
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin) -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$1(this, numPartitions, replicationFactor, adminClient, lastNewEvent, mockEventEmitter, eventIds, remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    private int activeCollectorCount() {
        return this.controllers().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCollectorIntegrationTest.$anonfun$activeCollectorCount$1(x$8)));
    }

    private void verifyOnlyOneActiveCollector() {
        IntRef activeCount = IntRef.create((int)0);
        this.controllers().foreach((Function1 & Serializable)controllerServer -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$1(activeCount, controllerServer);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)activeCount.elem, (String)"Should have exactly one active collector");
    }

    private Iterable<ControllerServer> controllers() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllersMap().values()).asScala();
    }

    private void controllerFailover() {
        ControllerServer oldLeader = (ControllerServer)this.controllers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCollectorIntegrationTest.$anonfun$controllerFailover$1(x$12))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No controller leader found, should not have happened");
        });
        int oldEpoch = KRaftMetadataCollectorIntegrationTest.getCurrentEpoch$1(oldLeader);
        oldLeader.raftManager().client().resign(oldEpoch);
        this.controllers().foreach((Function1 & Serializable)controller -> {
            KRaftMetadataCollectorIntegrationTest.$anonfun$controllerFailover$3(oldEpoch, controller);
            return BoxedUnit.UNIT;
        });
    }

    private void waitForConsistentKRaftMetadata(RaftClusterInvocationContext.RaftClusterInstance cluster) {
        TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokersMap().values()).asScala().toSeq(), (ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.controllersMap().values()).asScala().head(), "Timeout waiting for controller metadata propagating to brokers");
    }

    private EventEmitter setupMockEventEmitter() {
        EventEmitter mockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllersMap().values()).asScala().flatMap((Function1 & Serializable)x$13 -> x$13.metadataCollector())).find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isActive())).map((Function1 & Serializable)x$15 -> x$15.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)mockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        return mockEventEmitter;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataCollectorEnabled$1(KRaftMetadataCollectorIntegrationTest $this) {
        return $this.activeCollectorCount() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testMetadataCollectorEnabled$2() {
        return "No active collector after leader change";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$1(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$3(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$5(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$6() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$7(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$8() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$1(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2);
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$3(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2);
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$5(KRaftMetadataCollectorIntegrationTest $this) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.controllersMap().values()).asScala().flatMap((Function1 & Serializable)x$2 -> x$2.metadataCollector())).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isActive())) == 1;
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$8() {
        return "No active controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$13(ObjectRef lastNewEvent$2, EventEmitter newMockEventEmitter$1, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$2);
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$14() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMultiTenantEvents$1(EventEmitter mockEventEmitter$3, scala.collection.mutable.Set eventIds$3, scala.collection.mutable.Set newEvents$1) {
        Option<Event> lastEvent = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3);
        if (lastEvent.isDefined()) {
            newEvents$1.add(lastEvent.get());
        }
        return newEvents$1.size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testMultiTenantEvents$2() {
        return "Not enough events emitted";
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$4(scala.collection.mutable.Map mapping$1, MetadataChange change) {
        scala.collection.mutable.Set topics = (scala.collection.mutable.Set)mapping$1.apply((Object)change.getSource());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(change.getEventsList()).asScala().map((Function1 & Serializable)x$7 -> x$7.getTopicMetadata().getTopicName())).foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)topics.remove((Object)elem)));
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$7(scala.collection.mutable.Set pendingTopics) {
        Assertions.assertTrue((boolean)pendingTopics.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$2(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$4(ConfluentAdmin adminClient$1) {
        return !CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient$1.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$5() {
        return "No cluster link found";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$6(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$7() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$8(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$9() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$10(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$11() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$12(ConfluentAdmin adminClient$1) {
        return !CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient$1.listMirrors(new ListMirrorsOptions()).result().get()).asScala().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$13() {
        return "No mirror topics found";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$14(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$15() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$16(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$17() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$18(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4);
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$19() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicDeltaEvent$1(KRaftMetadataCollectorIntegrationTest $this, int numPartitions$1, short replicationFactor$1, ConfluentAdmin adminClient$1, ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        IntegrationTestUtils$.MODULE$.createTopic((Admin)remoteAdmin, $this.fullTopicName(), numPartitions$1, replicationFactor$1);
        NewClusterLink newClusterLink = new NewClusterLink($this.fullClusterLinkName(), (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$1.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event clusterLinkCreationEvent = (Event)((Option)lastNewEvent$3.elem).get();
        int initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(clusterLinkCreationEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$2 = $this.tenant();
        String x$3 = $this.clusterLink();
        Some x$5 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$6 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$8 = new Some((Object)$this.tenant());
        int x$10 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$9();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkCreationEvent, x$2, x$3, true, (Option<ClusterLinkConfig.LinkMode>)x$5, (Option<ConnectionMode>)x$6, (Option<String>)remoteClusterId, (Option<String>)x$8, x$10, initEpoch);
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicDeltaEvent$4(adminClient$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No cluster link found");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        adminClient$1.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, $this.fullClusterLinkName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("cluster.link.paused", "true"), AlterConfigOp.OpType.SET)))).all().get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event clusterLinkUpdateEvent1 = (Event)((Option)lastNewEvent$3.elem).get();
        initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(clusterLinkUpdateEvent1.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$12 = $this.tenant();
        String x$13 = $this.clusterLink();
        Some x$15 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$16 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$18 = new Some((Object)$this.tenant());
        int x$20 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$9();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkUpdateEvent1, x$12, x$13, true, (Option<ClusterLinkConfig.LinkMode>)x$15, (Option<ConnectionMode>)x$16, (Option<String>)remoteClusterId, (Option<String>)x$18, x$20, initEpoch);
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        adminClient$1.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, $this.fullClusterLinkName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("cluster.link.paused", "false"), AlterConfigOp.OpType.SET)))).all().get();
        $this.waitForConsistentKRaftMetadata($this.cluster);
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        NewTopic newTopic = new NewTopic($this.fullTopicName(), Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)replicationFactor$1)));
        newTopic.mirror(Optional.of(new NewMirrorTopic($this.fullClusterLinkName(), $this.fullTopicName())));
        adminClient$1.createTopics(Collections.singleton(newTopic)).all().get();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        Event topicCreationEvent = (Event)((Option)lastNewEvent$3.elem).get();
        initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(topicCreationEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$22 = $this.tenant();
        String x$23 = $this.topic();
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions$1));
        Some x$25 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor$1));
        None$ x$26 = None$.MODULE$;
        Some x$28 = new Some((Object)$this.clusterLink());
        Some x$29 = new Some((Object)$this.topic());
        Some x$30 = new Some((Object)"MIRROR");
        Option<Object> x$32 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$33 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$34 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$35 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        boolean x$36 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$16();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicCreationEvent, x$22, x$23, (Option<Object>)x$24, (Option<Object>)x$25, (Option<Object>)x$26, x$32, x$33, (Option<String>)x$30, x$34, (Option<String>)x$28, x$35, (Option<String>)x$29, (Option<String>)remoteClusterId, initEpoch, x$36);
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicDeltaEvent$12(adminClient$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"No mirror topics found");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        adminClient$1.alterMirrors(Collections.singletonMap($this.fullTopicName(), AlterMirrorOp.PAUSE), new AlterMirrorsOptions()).all().get();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        Event topicUpdateEvent = (Event)((Option)lastNewEvent$3.elem).get();
        initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(topicUpdateEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$38 = $this.tenant();
        String x$39 = $this.topic();
        Some x$40 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions$1));
        Some x$41 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor$1));
        None$ x$42 = None$.MODULE$;
        Some x$44 = new Some((Object)$this.clusterLink());
        Some x$45 = new Some((Object)$this.topic());
        Some x$46 = new Some((Object)"PAUSED");
        Option<Object> x$48 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$49 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$50 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$51 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        boolean x$52 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$16();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicUpdateEvent, x$38, x$39, (Option<Object>)x$40, (Option<Object>)x$41, (Option<Object>)x$42, x$48, x$49, (Option<String>)x$46, x$50, (Option<String>)x$44, x$51, (Option<String>)x$45, (Option<String>)remoteClusterId, initEpoch, x$52);
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        DeleteClusterLinksOptions forceDeleteClusterLinksOptions = new DeleteClusterLinksOptions();
        forceDeleteClusterLinksOptions.force(true);
        adminClient$1.deleteClusterLinks(Collections.singletonList($this.fullClusterLinkName()), forceDeleteClusterLinksOptions).all().get();
        $this.waitForConsistentKRaftMetadata($this.cluster);
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        Event clusterLinkDeletionEvent = (Event)((Option)lastNewEvent$3.elem).get();
        initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(clusterLinkDeletionEvent.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$54 = $this.tenant();
        String x$55 = $this.clusterLink();
        boolean x$57 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$4();
        Option<ClusterLinkConfig.LinkMode> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$5();
        Option<ConnectionMode> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$6();
        Option<String> x$60 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$7();
        Option<String> x$61 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$8();
        int x$62 = MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$9();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkDeletionEvent, x$54, x$55, x$57, x$58, x$59, x$60, x$61, x$62, initEpoch);
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
        Thread.sleep(3000L);
        Mockito.when((Object)mockEventEmitter$4.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4);
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
        }
        MetadataChange metadataChange = MetadataChange.parseFrom((byte[])((byte[])((Event)((Option)lastNewEvent$3.elem).get()).data().get()));
        Assertions.assertEquals((Object)MirrorTopicMetadata.getDefaultInstance(), (Object)metadataChange.getEvents(0).getTopicMetadata().getMirrorTopicMetadata());
        Mockito.mockingDetails((Object)mockEventEmitter$4).getInvocations().clear();
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$2(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$5, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5);
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$4(ConfluentAdmin adminClient$2) {
        return !CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient$2.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$5() {
        return "No cluster link found";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$6(ConfluentAdmin adminClient$2) {
        return !CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient$2.listMirrors(new ListMirrorsOptions()).result().get()).asScala().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$7() {
        return "No mirror topic found";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$8(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$5, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5);
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$9() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$10(ObjectRef lastNewEvent$4, EventEmitter newMockEventEmitter$2, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$5);
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$11() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$1(KRaftMetadataCollectorIntegrationTest $this, int numPartitions$2, short replicationFactor$2, ConfluentAdmin adminClient$2, ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$5, scala.collection.mutable.Set eventIds$5, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        IntegrationTestUtils$.MODULE$.createTopic((Admin)remoteAdmin, $this.fullTopicName(), numPartitions$2, replicationFactor$2);
        NewClusterLink newClusterLink = new NewClusterLink($this.fullClusterLinkName(), (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$2.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5);
            if (((Option)lastNewEvent$4.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapShotEvent1 = (Event)((Option)lastNewEvent$4.elem).get();
        int initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(snapShotEvent1.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$2 = $this.tenant();
        Some x$6 = new Some((Object)$this.clusterLink());
        Some x$7 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$10 = new Some((Object)$this.tenant());
        Option<Object> x$12 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$13 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$14 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$15 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$16 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$17 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$18 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        Option<ConnectionMode> x$19 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$15();
        boolean x$20 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$21 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapShotEvent1, x$2, null, numPartitions$2, replicationFactor$2, x$12, x$13, x$14, x$15, (Option<String>)x$6, x$16, x$17, x$18, (Option<ClusterLinkConfig.LinkMode>)x$7, x$19, (Option<String>)remoteClusterId, (Option<String>)x$10, x$20, initEpoch, x$21, 0);
        Mockito.mockingDetails((Object)mockEventEmitter$5).getInvocations().clear();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$4(adminClient$2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No cluster link found");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        $this.waitForConsistentKRaftMetadata($this.cluster);
        NewTopic newTopic = new NewTopic($this.fullTopicName(), Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)replicationFactor$2)));
        newTopic.mirror(Optional.of(new NewMirrorTopic($this.fullClusterLinkName(), $this.fullTopicName())));
        adminClient$2.createTopics(Collections.singleton(newTopic)).all().get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$testClusterLinkAndMirrorTopicSnapshotEvents$6(adminClient$2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No mirror topic found");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        $this.waitForConsistentKRaftMetadata($this.cluster);
        Collection clusterLinkListings = (Collection)adminClient$2.listClusterLinks(new ListClusterLinksOptions()).result().get();
        String linkId = ((ClusterLinkListing)CollectionConverters$.MODULE$.CollectionHasAsScala(clusterLinkListings).asScala().head()).clusterLinkId().toString();
        java.util.Map topicDescription = (java.util.Map)remoteAdmin.describeTopics(Collections.singletonList($this.fullTopicName())).allTopicNames().get();
        String sourceTopicId = ((TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala(topicDescription).asScala().apply((Object)$this.fullTopicName())).topicId().toString();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5);
            if (((Option)lastNewEvent$4.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event snapShotEvent2 = (Event)((Option)lastNewEvent$4.elem).get();
        initEpoch = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(snapShotEvent2.extension(MetadataEventUtils.Extensions.epoch.name())));
        String x$23 = $this.tenant();
        String x$24 = $this.topic();
        Some x$27 = new Some((Object)$this.clusterLink());
        Some x$28 = new Some((Object)linkId);
        Some x$29 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$32 = new Some((Object)$this.tenant());
        Some x$33 = new Some((Object)"Mirror");
        Some x$34 = new Some((Object)$this.topic());
        Some x$35 = new Some((Object)sourceTopicId);
        Option<Object> x$36 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$37 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$38 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<ConnectionMode> x$39 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$15();
        boolean x$40 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$41 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$42 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapShotEvent2, x$23, x$24, numPartitions$2, replicationFactor$2, x$36, x$37, x$38, (Option<String>)x$33, (Option<String>)x$27, (Option<String>)x$28, (Option<String>)x$35, (Option<String>)x$34, (Option<ClusterLinkConfig.LinkMode>)x$29, x$39, (Option<String>)remoteClusterId, (Option<String>)x$32, x$40, initEpoch, x$41, x$42);
        Mockito.mockingDetails((Object)mockEventEmitter$5).getInvocations().clear();
        $this.controllerFailover();
        $this.waitForConsistentKRaftMetadata($this.cluster);
        int newEpoch = initEpoch + 1;
        EventEmitter newMockEventEmitter = $this.setupMockEventEmitter();
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter, (scala.collection.mutable.Set<String>)eventIds$5);
            if (((Option)lastNewEvent$4.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        Event newSnapShotEvent = (Event)((Option)lastNewEvent$4.elem).get();
        String x$44 = $this.tenant();
        String x$45 = $this.topic();
        Some x$48 = new Some((Object)$this.clusterLink());
        Some x$49 = new Some((Object)linkId);
        Some x$50 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$51 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$54 = new Some((Object)$this.tenant());
        Option<Object> x$55 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$56 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$57 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$60 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        boolean x$61 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$62 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$63 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(newSnapShotEvent, x$44, x$45, numPartitions$2, replicationFactor$2, x$55, x$56, x$57, x$58, (Option<String>)x$48, (Option<String>)x$49, x$59, x$60, (Option<ClusterLinkConfig.LinkMode>)x$50, (Option<ConnectionMode>)x$51, (Option<String>)remoteClusterId, (Option<String>)x$54, x$61, newEpoch, x$62, x$63);
        Mockito.mockingDetails((Object)newMockEventEmitter).getInvocations().clear();
    }

    public static final /* synthetic */ boolean $anonfun$activeCollectorCount$1(ControllerServer x$8) {
        return x$8.metadataCollector().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isActive()));
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyOneActiveCollector$1(IntRef activeCount$1, ControllerServer controllerServer) {
        if (controllerServer.controller().isActive()) {
            Assertions.assertTrue((boolean)controllerServer.metadataCollector().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isActive())));
            ++activeCount$1.elem;
            return;
        }
        Assertions.assertFalse((boolean)controllerServer.metadataCollector().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isActive())));
    }

    private static final int getCurrentEpoch$1(ControllerServer controller) {
        return controller.raftManager().leaderAndEpoch().epoch();
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$1(ControllerServer x$12) {
        return x$12.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$4(ControllerServer controller$1, int oldEpoch$1) {
        return controller$1.raftManager().leaderAndEpoch().leaderId().isPresent() && KRaftMetadataCollectorIntegrationTest.getCurrentEpoch$1(controller$1) > oldEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$controllerFailover$5() {
        return "Leader didn't advance epoch";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$controllerFailover$3(int oldEpoch$1, ControllerServer controller) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftMetadataCollectorIntegrationTest.$anonfun$controllerFailover$4(controller, oldEpoch$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader didn't advance epoch");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public KRaftMetadataCollectorIntegrationTest(RaftClusterInvocationContext.RaftClusterInstance cluster) {
        this.cluster = cluster;
        this.tenant = "lkc-t1";
        this.topic = "test-topic";
        this.clusterLink = "test-link";
        this.fullTopicName = new StringBuilder(1).append(this.tenant()).append("_").append(this.topic()).toString();
        this.fullClusterLinkName = new StringBuilder(1).append(this.tenant()).append("_").append(this.clusterLink()).toString();
    }
}

