/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.OptionalInt;
import kafka.catalog.KRaftMetadataCollector;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KRaftMetadataCollectorTest {
    private KRaftMetadataCollector collector;
    private Metrics metrics;

    @BeforeEach
    void setUp() {
        MockTime time = new MockTime();
        this.metrics = new Metrics();
        this.collector = new KRaftMetadataCollector(this.metrics, false, 10, 10, 5, "catalog-topic", 0, null, (Time)time);
    }

    @Test
    public void testCatalogMetricsLifecycle() {
        MetricName activeCollectorMetricName = this.metrics.metricName("active-collector", "catalog-metrics", "Reports 1 if the catalog metadata collector is active, 0 otherwise.");
        Assertions.assertNull((Object)this.collector.catalogMetrics());
        LeaderAndEpoch oldLeaderAndEpoch = new LeaderAndEpoch(OptionalInt.of(0), 0);
        this.collector.onControllerChange(oldLeaderAndEpoch);
        Assertions.assertNotNull((Object)this.collector.catalogMetrics());
        this.testMetricsRegistered(this.metrics);
        Assertions.assertEquals((Object)1.0, (Object)this.metrics.metric(activeCollectorMetricName).metricValue());
        LeaderAndEpoch newLeaderAndEpoch = new LeaderAndEpoch(OptionalInt.of(1), 1);
        this.collector.onControllerChange(newLeaderAndEpoch);
        Assertions.assertNull((Object)this.collector.catalogMetrics());
        this.testMetricsRemoved(this.metrics);
        Assertions.assertEquals((Object)0.0, (Object)this.metrics.metric(activeCollectorMetricName).metricValue());
        this.collector.onControllerChange(oldLeaderAndEpoch);
        Assertions.assertNotNull((Object)this.collector.catalogMetrics());
        this.testMetricsRegistered(this.metrics);
        Assertions.assertEquals((Object)1.0, (Object)this.metrics.metric(activeCollectorMetricName).metricValue());
    }

    private void testMetricsRegistered(Metrics metrics) {
        Assertions.assertNotNull((Object)metrics.getSensor("num-delta-event-emit"));
        Assertions.assertNotNull((Object)metrics.getSensor("num-snapshot-event-emit"));
        Assertions.assertNotNull((Object)metrics.getSensor("num-collector-event-handle-error"));
        Assertions.assertNotNull((Object)metrics.metric(metrics.metricName("cached-topics-total", "catalog-metrics")));
        Assertions.assertNotNull((Object)metrics.metric(metrics.metricName("cached-entities-total", "catalog-metrics")));
        Assertions.assertNotNull((Object)metrics.metric(metrics.metricName("snapshot-emitting-delay-ms", "catalog-metrics")));
    }

    private void testMetricsRemoved(Metrics metrics) {
        Assertions.assertNull((Object)metrics.getSensor("num-delta-event-emit"));
        Assertions.assertNull((Object)metrics.getSensor("num-snapshot-event-emit"));
        Assertions.assertNull((Object)metrics.getSensor("num-collector-event-handle-error"));
        Assertions.assertNull((Object)metrics.metric(metrics.metricName("cached-topics-total", "catalog-metrics")));
        Assertions.assertNull((Object)metrics.metric(metrics.metricName("cached-entities-total", "catalog-metrics")));
        Assertions.assertNull((Object)metrics.metric(metrics.metricName("snapshot-emitting-delay-ms", "catalog-metrics")));
    }
}

