/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.io.Serializable;
import kafka.catalog.MetadataEventUtils;
import kafka.server.link.ConnectionMode;
import kafka.test.ClusterInstance;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class MetadataCollectorTestUtils$ {
    public static final MetadataCollectorTestUtils$ MODULE$ = new MetadataCollectorTestUtils$();
    private static final int INIT_EPOCH = 1;

    public int INIT_EPOCH() {
        return INIT_EPOCH;
    }

    public void verifyTopicDeltaEvent(Event event, String tenant, String topicName, Option<Object> numPartitions, Option<Object> replicationFactor, Option<Object> retentionMs, Option<Object> retentionBytes, Option<TopicMetadata.CleanupPolicy> cleanupPolicy, Option<String> mirrorTopicState, Option<String> linkId, Option<String> linkName, Option<String> sourceTopicId, Option<String> sourceTopicName, Option<String> remoteClusterId, int epoch, boolean includeFullConfigs) {
        Assertions.assertEquals((Object)"DELTA", (Object)event.type(), (String)"Event type mismatched");
        Assertions.assertEquals((Object)MetadataEventUtils.topicDeltaSourceUrl((String)tenant, (String)topicName), (Object)event.source().toString(), (String)"Event source mismatched");
        String x$18 = "topic";
        this.verifyTopicEvent(event, 0, tenant, topicName, epoch, numPartitions, replicationFactor, retentionMs, retentionBytes, cleanupPolicy, x$18, mirrorTopicState, linkId, linkName, sourceTopicId, sourceTopicName, remoteClusterId, includeFullConfigs);
    }

    public Option<Object> verifyTopicDeltaEvent$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> verifyTopicDeltaEvent$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> verifyTopicDeltaEvent$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> verifyTopicDeltaEvent$default$7() {
        return None$.MODULE$;
    }

    public Option<TopicMetadata.CleanupPolicy> verifyTopicDeltaEvent$default$8() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$9() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$10() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$11() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$12() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$13() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicDeltaEvent$default$14() {
        return None$.MODULE$;
    }

    public int verifyTopicDeltaEvent$default$15() {
        return this.INIT_EPOCH();
    }

    public boolean verifyTopicDeltaEvent$default$16() {
        return false;
    }

    public void verifyClusterLinkDeltaEvent(Event event, String tenant, String clusterLinkName, boolean checkLinkId, Option<ClusterLinkConfig.LinkMode> linkMode, Option<ConnectionMode> connectionMode, Option<String> remoteClusterId, Option<String> localClusterId, int index, int epoch) {
        Assertions.assertEquals((Object)"DELTA", (Object)event.type(), (String)"Event type mismatched");
        Assertions.assertEquals((Object)MetadataEventUtils.clusterLinkDeltaSourceUrl((String)tenant, (String)clusterLinkName), (Object)event.source().toString(), (String)"Event source mismatched");
        this.verifyClusterLinkEvent(event, index, tenant, clusterLinkName, epoch, checkLinkId, linkMode, connectionMode, remoteClusterId, localClusterId, "clusterLink");
    }

    public boolean verifyClusterLinkDeltaEvent$default$4() {
        return false;
    }

    public Option<ClusterLinkConfig.LinkMode> verifyClusterLinkDeltaEvent$default$5() {
        return None$.MODULE$;
    }

    public Option<ConnectionMode> verifyClusterLinkDeltaEvent$default$6() {
        return None$.MODULE$;
    }

    public Option<String> verifyClusterLinkDeltaEvent$default$7() {
        return None$.MODULE$;
    }

    public Option<String> verifyClusterLinkDeltaEvent$default$8() {
        return None$.MODULE$;
    }

    public int verifyClusterLinkDeltaEvent$default$9() {
        return 0;
    }

    public int verifyClusterLinkDeltaEvent$default$10() {
        return this.INIT_EPOCH();
    }

    public void verifyMetadataSnapshotEvent(Event event, String tenant, String topicName, int numPartitions, short replicationFactor, Option<Object> retentionMs, Option<Object> retentionBytes, Option<TopicMetadata.CleanupPolicy> cleanupPolicy, Option<String> mirrorTopicState, Option<String> clusterLinkName, Option<String> linkId, Option<String> sourceTopicId, Option<String> sourceTopicName, Option<ClusterLinkConfig.LinkMode> linkMode, Option<ConnectionMode> connectionMode, Option<String> remoteClusterId, Option<String> localClusterId, boolean checkLinkId, int epoch, int topicEventIndex, int clusterLinkEventIndex) {
        Assertions.assertEquals((Object)"topicAndClusterLink", (Object)event.subject(), (String)"Event subject mismatched");
        Assertions.assertEquals((Object)"SNAPSHOT", (Object)event.type(), (String)"Event type mismatched");
        Assertions.assertEquals((Object)MetadataEventUtils.snapshotSourceUrl((String)tenant), (Object)event.source().toString(), (String)"Event source mismatched");
        Assertions.assertEquals((Object)"0", (Object)event.extension("page"));
        Assertions.assertEquals((Object)"true", (Object)event.extension("lastpage"));
        Assertions.assertNotNull((Object)event.extension("snapshotid"));
        if (topicName != null) {
            this.verifyTopicEvent(event, topicEventIndex, tenant, topicName, epoch, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), retentionMs, retentionBytes, cleanupPolicy, "topicAndClusterLink", mirrorTopicState, linkId, clusterLinkName, sourceTopicId, sourceTopicName, remoteClusterId, false);
        }
        clusterLinkName.foreach((Function1 & Serializable)name -> {
            MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkEvent(event, clusterLinkEventIndex, tenant, name, epoch, checkLinkId, (Option<ClusterLinkConfig.LinkMode>)linkMode, (Option<ConnectionMode>)connectionMode, (Option<String>)remoteClusterId, (Option<String>)localClusterId, "topicAndClusterLink");
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> verifyMetadataSnapshotEvent$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> verifyMetadataSnapshotEvent$default$7() {
        return None$.MODULE$;
    }

    public Option<TopicMetadata.CleanupPolicy> verifyMetadataSnapshotEvent$default$8() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$9() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$10() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$11() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$12() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$13() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkConfig.LinkMode> verifyMetadataSnapshotEvent$default$14() {
        return None$.MODULE$;
    }

    public Option<ConnectionMode> verifyMetadataSnapshotEvent$default$15() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$16() {
        return None$.MODULE$;
    }

    public Option<String> verifyMetadataSnapshotEvent$default$17() {
        return None$.MODULE$;
    }

    public boolean verifyMetadataSnapshotEvent$default$18() {
        return true;
    }

    public int verifyMetadataSnapshotEvent$default$19() {
        return this.INIT_EPOCH();
    }

    public int verifyMetadataSnapshotEvent$default$20() {
        return 0;
    }

    public int verifyMetadataSnapshotEvent$default$21() {
        return 1;
    }

    public void verifyTopicEvent(Event event, int index, String tenant, String topicName, int epoch, Option<Object> numPartitions, Option<Object> replicationFactor, Option<Object> retentionMs, Option<Object> retentionBytes, Option<TopicMetadata.CleanupPolicy> cleanupPolicy, String entityType, Option<String> mirrorTopicState, Option<String> linkId, Option<String> linkName, Option<String> sourceTopicId, Option<String> sourceTopicName, Option<String> remoteClusterId, boolean includeFullConfigs) {
        Assertions.assertEquals((Object)entityType, (Object)event.subject(), (String)"Event subject mismatched");
        Assertions.assertEquals((Object)"application/protobuf", (Object)event.dataContentType(), (String)"Event data content type mismatched");
        Assertions.assertEquals((Object)"telemetry.events.data_catalog_source", (Object)event.extension(MetadataEventUtils.Extensions.route.name()), (String)"Event route extension mismatched");
        Assertions.assertEquals((Object)tenant, (Object)event.extension(MetadataEventUtils.Extensions.partitionkey.name()), (String)"Event partition key extension mismatched");
        Assertions.assertEquals((Object)Integer.toString(epoch), (Object)event.extension(MetadataEventUtils.Extensions.epoch.name()), (String)"Event epoch extension mismatched");
        MetadataChange metadataChange = MetadataChange.parseFrom((byte[])((byte[])event.data().get()));
        TopicMetadata topicMetadata = metadataChange.getEvents(index).getTopicMetadata();
        Assertions.assertEquals((Object)topicName, (Object)topicMetadata.getTopicName(), (String)"MetadataChange topic name mismatched");
        numPartitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> Assertions.assertEquals((int)x$1, (int)topicMetadata.getPartitionsCount(), (String)"MetadataChange partition count mismatched"));
        replicationFactor.foreach((Function1 & Serializable)x$2 -> {
            MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$2(topicMetadata, BoxesRunTime.unboxToShort((Object)x$2));
            return BoxedUnit.UNIT;
        });
        retentionMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$3 -> Assertions.assertEquals((long)x$3, (long)topicMetadata.getRetentionMs(), (String)"MetadataChange retentionMs mismatched"));
        retentionBytes.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$4 -> Assertions.assertEquals((long)x$4, (long)topicMetadata.getRetentionBytes(), (String)"MetadataChange retentionBytes mismatched"));
        cleanupPolicy.foreach((Function1 & Serializable)x$5 -> {
            MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$5(topicMetadata, x$5);
            return BoxedUnit.UNIT;
        });
        OpType opType = metadataChange.getOp();
        OpType opType2 = OpType.DELETE;
        if ((opType == null ? opType2 != null : !opType.equals(opType2)) && includeFullConfigs) {
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)topicMetadata.getFlushMs(), (String)"MetadataChange flushMs mismatched");
            Assertions.assertEquals((double)0.5, (double)topicMetadata.getMinCleanableDirtyRatio(), (String)"MetadataChange min cleanable dirty ratio mismatched");
        } else {
            OpType opType3 = metadataChange.getOp();
            OpType opType4 = OpType.DELETE;
            if ((opType3 == null ? opType4 != null : !opType3.equals(opType4)) && !includeFullConfigs) {
                Assertions.assertEquals((long)0L, (long)topicMetadata.getFlushMs(), (String)"MetadataChange flushMs mismatched");
                Assertions.assertEquals((double)0.0, (double)topicMetadata.getMinCleanableDirtyRatio(), (String)"MetadataChange min cleanable dirty ratio mismatched");
            }
        }
        if (mirrorTopicState.isDefined()) {
            mirrorTopicState.foreach((Function1 & Serializable)state -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$6(topicMetadata, state);
                return BoxedUnit.UNIT;
            });
            linkId.foreach((Function1 & Serializable)x$6 -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$7(topicMetadata, x$6);
                return BoxedUnit.UNIT;
            });
            linkName.foreach((Function1 & Serializable)x$7 -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$8(topicMetadata, x$7);
                return BoxedUnit.UNIT;
            });
            sourceTopicId.foreach((Function1 & Serializable)x$8 -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$9(topicMetadata, x$8);
                return BoxedUnit.UNIT;
            });
            sourceTopicName.foreach((Function1 & Serializable)x$9 -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$10(topicMetadata, x$9);
                return BoxedUnit.UNIT;
            });
            remoteClusterId.foreach((Function1 & Serializable)x$10 -> {
                MetadataCollectorTestUtils$.$anonfun$verifyTopicEvent$11(topicMetadata, x$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<Object> verifyTopicEvent$default$8() {
        return None$.MODULE$;
    }

    public String verifyTopicEvent$default$11() {
        return "topic";
    }

    public Option<String> verifyTopicEvent$default$12() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicEvent$default$13() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicEvent$default$14() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicEvent$default$15() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicEvent$default$16() {
        return None$.MODULE$;
    }

    public Option<String> verifyTopicEvent$default$17() {
        return None$.MODULE$;
    }

    public boolean verifyTopicEvent$default$18() {
        return false;
    }

    public void verifyClusterLinkEvent(Event event, int index, String tenant, String clusterLinkName, int epoch, boolean checkLinkId, Option<ClusterLinkConfig.LinkMode> linkMode, Option<ConnectionMode> connectionMode, Option<String> remoteClusterId, Option<String> localClusterId, String entityType) {
        Assertions.assertEquals((Object)entityType, (Object)event.subject(), (String)"Event subject mismatched");
        Assertions.assertEquals((Object)"application/protobuf", (Object)event.dataContentType(), (String)"Event data content type mismatched");
        Assertions.assertEquals((Object)"telemetry.events.data_catalog_source", (Object)event.extension(MetadataEventUtils.Extensions.route.name()), (String)"Event route extension mismatched");
        Assertions.assertEquals((Object)tenant, (Object)event.extension(MetadataEventUtils.Extensions.partitionkey.name()), (String)"Event partition key extension mismatched");
        Assertions.assertEquals((Object)Integer.toString(epoch), (Object)event.extension(MetadataEventUtils.Extensions.epoch.name()), (String)"Event epoch extension mismatched");
        ClusterLinkMetadata clusterLinkMetadata = MetadataChange.parseFrom((byte[])((byte[])event.data().get())).getEvents(index).getClusterLinkMetadata();
        Assertions.assertEquals((Object)clusterLinkName, (Object)clusterLinkMetadata.getClusterLinkName(), (String)"MetadataChange cluster link name mismatched");
        if (checkLinkId) {
            Assertions.assertNotNull((Object)clusterLinkMetadata.getClusterLinkId(), (String)"MetadataChange cluster link id null");
        }
        linkMode.foreach((Function1 & Serializable)lm -> {
            MetadataCollectorTestUtils$.$anonfun$verifyClusterLinkEvent$1(clusterLinkMetadata, lm);
            return BoxedUnit.UNIT;
        });
        connectionMode.foreach((Function1 & Serializable)cm -> {
            MetadataCollectorTestUtils$.$anonfun$verifyClusterLinkEvent$2(clusterLinkMetadata, cm);
            return BoxedUnit.UNIT;
        });
        remoteClusterId.foreach((Function1 & Serializable)src -> {
            MetadataCollectorTestUtils$.$anonfun$verifyClusterLinkEvent$3(clusterLinkMetadata, src);
            return BoxedUnit.UNIT;
        });
        localClusterId.foreach((Function1 & Serializable)dest -> {
            MetadataCollectorTestUtils$.$anonfun$verifyClusterLinkEvent$4(clusterLinkMetadata, dest);
            return BoxedUnit.UNIT;
        });
    }

    public String verifyClusterLinkEvent$default$11() {
        return "clusterLink";
    }

    public Option<Event> getLastNewEvent(EventEmitter mockEventEmitter, Set<String> eventIds, String subject) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(Mockito.mockingDetails((Object)mockEventEmitter).getInvocations()).asScala().map((Function1 & Serializable)x$11 -> (Event)x$11.getArgument(0))).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataCollectorTestUtils$.$anonfun$getLastNewEvent$2(subject, x$12)))).find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)eventIds.add((Object)e.id())));
    }

    public Option<Event> getLastNewMetadataEvent(EventEmitter mockEventEmitter, Set<String> eventIds) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(Mockito.mockingDetails((Object)mockEventEmitter).getInvocations()).asScala().map((Function1 & Serializable)x$13 -> (Event)x$13.getArgument(0))).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetadataCollectorTestUtils$.$anonfun$getLastNewMetadataEvent$2(x$14)))).find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)eventIds.add((Object)e.id())));
    }

    public void runWithRemoteCluster(ClusterInstance cluster, Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit> callback) {
        ClusterInstance remoteCluster = cluster.duplicateCluster(builder -> builder.brokers(3));
        remoteCluster.start();
        remoteCluster.waitForReadyBrokers();
        try {
            Admin admin = remoteCluster.createAdminClient();
            String clusterId = (String)admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            callback.apply((Object)remoteCluster, (Object)remoteCluster.bootstrapServers(), (Object)Option$.MODULE$.apply((Object)clusterId), (Object)((ConfluentAdmin)admin));
        }
        finally {
            remoteCluster.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$2(TopicMetadata topicMetadata$1, short x$2) {
        Assertions.assertEquals((int)x$2, (int)topicMetadata$1.getReplicationFactor(), (String)"MetadataChange replication factor mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$5(TopicMetadata topicMetadata$1, TopicMetadata.CleanupPolicy x$5) {
        Assertions.assertEquals((Object)x$5, (Object)topicMetadata$1.getCleanupPolicy(), (String)"MetadataChange cleanup Policy mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$6(TopicMetadata topicMetadata$1, String state) {
        Assertions.assertTrue((boolean)state.equalsIgnoreCase(topicMetadata$1.getMirrorTopicMetadata().getMirrorTopicState()));
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$7(TopicMetadata topicMetadata$1, String x$6) {
        Assertions.assertEquals((Object)x$6, (Object)topicMetadata$1.getMirrorTopicMetadata().getLinkId(), (String)"Mirror topic's link id mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$8(TopicMetadata topicMetadata$1, String x$7) {
        Assertions.assertEquals((Object)x$7, (Object)topicMetadata$1.getMirrorTopicMetadata().getLinkName(), (String)"Mirror topic's link name mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$9(TopicMetadata topicMetadata$1, String x$8) {
        Assertions.assertEquals((Object)x$8, (Object)topicMetadata$1.getMirrorTopicMetadata().getSourceTopicId(), (String)"Mirror topic's source topic id mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$10(TopicMetadata topicMetadata$1, String x$9) {
        Assertions.assertEquals((Object)x$9, (Object)topicMetadata$1.getMirrorTopicMetadata().getSourceTopicName(), (String)"Mirror topic's source topic name mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyTopicEvent$11(TopicMetadata topicMetadata$1, String x$10) {
        Assertions.assertEquals((Object)x$10, (Object)topicMetadata$1.getMirrorTopicMetadata().getRemoteClusterId(), (String)"Remote cluster id mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyClusterLinkEvent$1(ClusterLinkMetadata clusterLinkMetadata$1, ClusterLinkConfig.LinkMode lm) {
        Assertions.assertTrue((boolean)lm.toString().equalsIgnoreCase(clusterLinkMetadata$1.getLinkMode().toString()), (String)"MetadataChange link mode mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyClusterLinkEvent$2(ClusterLinkMetadata clusterLinkMetadata$1, ConnectionMode cm) {
        Assertions.assertTrue((boolean)cm.toString().equalsIgnoreCase(clusterLinkMetadata$1.getConnectionMode().toString()), (String)"MetadataChange connection mode mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyClusterLinkEvent$3(ClusterLinkMetadata clusterLinkMetadata$1, String src) {
        Assertions.assertEquals((Object)src, (Object)clusterLinkMetadata$1.getRemoteClusterId(), (String)"MetadataChange remote cluster id mismatched");
    }

    public static final /* synthetic */ void $anonfun$verifyClusterLinkEvent$4(ClusterLinkMetadata clusterLinkMetadata$1, String dest) {
        Assertions.assertEquals((Object)dest, (Object)clusterLinkMetadata$1.getLocalClusterId(), (String)"MetadataChange local cluster id mismatched");
    }

    public static final /* synthetic */ boolean $anonfun$getLastNewEvent$2(String subject$1, Event x$12) {
        return x$12.subject().equals(subject$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLastNewMetadataEvent$2(Event x$14) {
        return x$14.type().equals("SNAPSHOT");
    }

    private MetadataCollectorTestUtils$() {
    }
}

