/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataEventUtilsTest {
    String tenant = "lkc-12345";
    String tenantPrefix = "lkc-12345_";

    private MetadataEvent getTestTopicMetadataEvent(Uuid topicId, MirrorTopicMetadata mirrorTopicMetadata, boolean includeFullConfigs) {
        Properties logProps = new Properties();
        logProps.setProperty("retention.ms", "100");
        logProps.setProperty("retention.bytes", "-1");
        logProps.setProperty("confluent.schema.registry.url", "foo");
        logProps.setProperty("confluent.schema.validator.interceptor.class", InterceptorUtils.MockRecordInterceptor.class.getName());
        logProps.setProperty("confluent.key.schema.validation", "false");
        logProps.setProperty("confluent.value.schema.validation", "true");
        logProps.setProperty("cleanup.policy", String.format("%s, %s", "delete", "compact"));
        logProps.setProperty("follower.replication.throttled.replicas", "0:100,1:101");
        logProps.setProperty("leader.replication.throttled.replicas", "0:106,1:106");
        Set override = Collections.emptySet();
        LogConfig logConfig = new LogConfig((Map)logProps, override);
        return MetadataEventUtils.topicMetadataEventFromLogConfig((LogConfig)logConfig, (String)(this.tenantPrefix + topicId), (Uuid)topicId, (int)1, (int)2, (MirrorTopicMetadata)mirrorTopicMetadata, (boolean)includeFullConfigs, null, null);
    }

    @Test
    public void testBuildFullTopicMetadataEventFromLogConfig() {
        Uuid topicId = Uuid.randomUuid();
        MetadataEvent event = this.getTestTopicMetadataEvent(topicId, null, true);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
        Assertions.assertEquals((Object)"0:100", (Object)topicEvent.getFollowerReplicationThrottledReplicas(0));
        Assertions.assertEquals((Object)"1:101", (Object)topicEvent.getFollowerReplicationThrottledReplicas(1));
        Assertions.assertEquals((Object)"0:106", (Object)topicEvent.getLeaderReplicationThrottledReplicas(0));
        Assertions.assertEquals((Object)"1:106", (Object)topicEvent.getLeaderReplicationThrottledReplicas(1));
        Assertions.assertEquals((Object)TopicMetadata.CompressionType.valueOf((String)LogConfig.DEFAULT_COMPRESSION_TYPE.toUpperCase(Locale.ROOT)), (Object)topicEvent.getCompressionType());
        Assertions.assertEquals((long)86400000L, (long)topicEvent.getDeleteRetentionMs());
        Assertions.assertEquals((long)60000L, (long)topicEvent.getFileDeleteDelayMs());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)topicEvent.getFlushMessages());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)topicEvent.getFlushMs());
        Assertions.assertEquals((int)4096, (int)topicEvent.getIndexIntervalBytes());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)topicEvent.getMaxCompactionLagMs());
        Assertions.assertEquals((int)0x10000C, (int)topicEvent.getMaxMessageBytes());
        Assertions.assertEquals((Object)true, (Object)topicEvent.getMessageDownconversionEnable());
        Assertions.assertEquals((Object)LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION, (Object)topicEvent.getMessageFormatVersion());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)topicEvent.getMessageTimestampDifferenceMaxMs());
        Assertions.assertEquals((Object)"CreateTime", (Object)topicEvent.getMessageTimestampType());
        Assertions.assertEquals((double)0.5, (double)topicEvent.getMinCleanableDirtyRatio());
        Assertions.assertEquals((long)0L, (long)topicEvent.getMinCompactionLagMs());
        Assertions.assertEquals((int)1, (int)topicEvent.getMinInsyncReplicas());
        Assertions.assertEquals((Object)false, (Object)topicEvent.getPreallocate());
        Assertions.assertEquals((int)0x40000000, (int)topicEvent.getSegmentBytes());
        Assertions.assertEquals((int)0xA00000, (int)topicEvent.getSegmentIndexBytes());
        Assertions.assertEquals((long)0L, (long)topicEvent.getSegmentJitterMs());
        Assertions.assertEquals((long)604800000L, (long)topicEvent.getSegmentMs());
        Assertions.assertEquals((Object)false, (Object)topicEvent.getUncleanLeaderElectionEnable());
    }

    @Test
    public void testBuildTopicMetadataEventFromLogConfig() {
        Uuid topicId = Uuid.randomUuid();
        MetadataEvent event = this.getTestTopicMetadataEvent(topicId, null, false);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
        Assertions.assertEquals((Object)TopicMetadata.CompressionType.COMPRESSION_UNSPECIFIED, (Object)topicEvent.getCompressionType());
        Assertions.assertEquals((long)0L, (long)topicEvent.getDeleteRetentionMs());
        Assertions.assertEquals((long)0L, (long)topicEvent.getFileDeleteDelayMs());
    }

    @Test
    public void testBuildMirrorTopicMetadataEventFromLogConfig() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        Uuid topicId = Uuid.randomUuid();
        String mirrorTopicState = "ACTIVE";
        String remoteClusterId = "remoteClusterId";
        MirrorTopicMetadata mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata((Uuid)linkId, (String)linkName, (Uuid)topicId, (String)sourceTopicName, (String)mirrorTopicState, (String)remoteClusterId, null);
        MetadataEvent event = this.getTestTopicMetadataEvent(topicId, mirrorTopicMetadata, false);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        MirrorTopicMetadata mirrorTopicEvent = event.getTopicMetadata().getMirrorTopicMetadata();
        Assertions.assertNotNull((Object)mirrorTopicEvent);
        Assertions.assertEquals((Object)linkId.toString(), (Object)mirrorTopicEvent.getLinkId());
        Assertions.assertEquals((Object)linkName, (Object)mirrorTopicEvent.getLinkName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)mirrorTopicEvent.getSourceTopicId());
        Assertions.assertEquals((Object)sourceTopicName, (Object)mirrorTopicEvent.getSourceTopicName());
        Assertions.assertEquals((Object)mirrorTopicState, (Object)mirrorTopicEvent.getMirrorTopicState());
        Assertions.assertEquals((Object)remoteClusterId, (Object)mirrorTopicEvent.getRemoteClusterId());
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
    }

    @Test
    public void testClusterLinkMetadataEvent() {
        String linkName = this.tenantPrefix + "test_linkName";
        Uuid linkId = Uuid.randomUuid();
        String srcClusterId = "srcClusterId";
        String destClusterId = "destClusterId";
        MetadataEvent event = MetadataEventUtils.clusterLinkMetadataEvent((String)linkName, (Uuid)linkId, (ClusterLinkConfig.LinkMode)ClusterLinkConfig.LinkMode.fromString((String)"destination"), (ConnectionMode)ConnectionMode.fromString((String)"outbound"), (String)srcClusterId, (String)destClusterId, null, null);
        Assertions.assertNotNull((Object)event);
        ClusterLinkMetadata clusterLinkEvent = event.getClusterLinkMetadata();
        Assertions.assertNotNull((Object)clusterLinkEvent);
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkEvent.getClusterLinkName());
        Assertions.assertEquals((Object)linkId.toString(), (Object)clusterLinkEvent.getClusterLinkId());
        Assertions.assertTrue((boolean)ClusterLinkConfig.LinkMode.fromString((String)"Destination").toString().equalsIgnoreCase(clusterLinkEvent.getLinkMode().toString()));
        Assertions.assertTrue((boolean)ConnectionMode.fromString((String)"Outbound").toString().equalsIgnoreCase(clusterLinkEvent.getConnectionMode().toString()));
        Assertions.assertEquals((Object)srcClusterId, (Object)clusterLinkEvent.getRemoteClusterId());
        Assertions.assertEquals((Object)destClusterId, (Object)clusterLinkEvent.getLocalClusterId());
        Assertions.assertEquals((long)0L, (long)clusterLinkEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)clusterLinkEvent.getUpdateTime().getSeconds());
    }

    @Test
    public void testBuildMetadataChange() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestTopicMetadataEvent(topicId1, null, false);
        MetadataEvent event2 = this.getTestTopicMetadataEvent(topicId2, null, false);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Assertions.assertEquals((Object)OpType.SNAPSHOT, (Object)change.getOp());
        Assertions.assertEquals((int)2, (int)change.getEventsCount());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
        Assertions.assertEquals((Object)topicId2.toString(), (Object)change.getEvents(1).getTopicMetadata().getTopicId());
        change = MetadataEventUtils.entityCreateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.CREATE, (Object)change.getOp());
        change = MetadataEventUtils.entityUpdateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.UPDATE, (Object)change.getOp());
        change = MetadataEventUtils.entityDeleteEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.DELETE, (Object)change.getOp());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
    }

    @Test
    public void testBuildCloudEvent() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestTopicMetadataEvent(topicId1, null, false);
        MetadataEvent event2 = this.getTestTopicMetadataEvent(topicId2, null, false);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Uuid snapshotId = Uuid.randomUuid();
        Event snapshotCloudEvent = MetadataEventUtils.metadataSnapshotCloudEvent((MetadataChange)change, (int)0, (String)"_catalog_kafka_topic", (int)0, (boolean)true, (Uuid)snapshotId);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)"crn://confluent.cloud/kafka=lkc-12345/topics-and-cluster-links", (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"topicAndClusterLink", (Object)snapshotCloudEvent.subject());
        Assertions.assertEquals((Object)"SNAPSHOT", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"_catalog_kafka_topic", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertEquals((Object)"true", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.lastpage.name()));
        Assertions.assertEquals((Object)snapshotId.toString(), (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.snapshotid.name()));
        change = MetadataEventUtils.entityCreateEvent((String)this.tenant, (MetadataEvent)event1);
        snapshotCloudEvent = MetadataEventUtils.topicMetadataDeltaCloudEvent((MetadataChange)change, (int)1, null);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)("crn://confluent.cloud/kafka=lkc-12345/topic=" + this.tenantPrefix + topicId1), (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"DELTA", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"1", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.lastpage.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.snapshotid.name()));
    }

    @Test
    public void testEventHasChanged() {
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder().setTopicId("topic-123").setTopicName("topic-1").setReplicationFactor(3).setPartitionsCount(10).setKeySchemaValidation(false).setValueSchemaValidation(true).setRetentionBytes(100000L).setCleanupPolicy(TopicMetadata.CleanupPolicy.DELETE).setRetentionMs(86400000L).setDeleteRetentionMs(666L);
        MetadataEvent event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
        MetadataEvent event2 = event1.toBuilder().build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged(null, null));
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, null));
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged(null, (MetadataEvent)event2));
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicId("topic-456")).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicId("topic-123")).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicName("topic-2")).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicName("topic-1")).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setReplicationFactor(5)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setReplicationFactor(3)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setPartitionsCount(6)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setPartitionsCount(10)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setKeySchemaValidation(true)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setKeySchemaValidation(false)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setValueSchemaValidation(false)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setValueSchemaValidation(true)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionBytes(200000L)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionBytes(100000L)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.COMPACT)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.DELETE)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionMs(604800000L)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionMs(86400000L)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setDeleteRetentionMs(3333L)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setDeleteRetentionMs(666L)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
    }
}

