/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorConfig;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class ZKMetadataCollectorEventQueueIntegrationTest {
    @Mock
    private KafkaConfig mockConfig;
    @Mock
    private KafkaZkClient mockZkClient;
    @Mock
    private Logger mockLogger;
    private ZKMetadataCollector collector;
    private ZKMetadataCollectorConfig config;
    private ArgumentCaptor<MetadataCollectorEvent> submittedEvent;
    private Metrics metrics;
    private Time time;
    private MetadataCollectorEventQueue eventQueue;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.submittedEvent = ArgumentCaptor.forClass(MetadataCollectorEvent.class);
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.config = new ZKMetadataCollectorConfig(false, 30, 300, 500, 1, 1, "foo");
        this.eventQueue = new MetadataCollectorEventQueue(this.time);
        this.collector = new ZKMetadataCollector(this.mockConfig, this.config, this.mockZkClient, this.metrics, this.mockLogger, this.eventQueue, Optional.empty(), Boolean.valueOf(false), this.time);
    }

    @AfterEach
    void tearDown() {
        this.collector.shutdown();
    }

    @Test
    public void testCollectorLifeCycle() throws InterruptedException {
        CountDownLatch testLatch = new CountDownLatch(4);
        this.collector.enable(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 0);
        this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, 0, true, this.time));
        TestUtils.waitForCondition(() -> testLatch.getCount() == 3L, (String)"Test Latch never decrement");
        this.collector.disable();
        this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, -1, false, this.time));
        TestUtils.waitForCondition(() -> testLatch.getCount() == 2L, (String)"Test Latch never decrement");
        this.collector.enable(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 1);
        this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, 1, true, this.time));
        TestUtils.waitForCondition(() -> testLatch.getCount() == 1L, (String)"Test Latch never decrement");
        this.collector.disable();
        this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, -1, false, this.time));
        TestUtils.waitForCondition(() -> testLatch.getCount() == 0L, (String)"Test Latch never decrement");
        this.collector.shutdown();
        Assertions.assertThrows(IllegalStateException.class, () -> this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, -1, false, this.time)), (String)"Should not enqueue event after collector is shutdown.");
    }

    @Test
    void testDoubleDisable() throws InterruptedException {
        CountDownLatch testLatch = new CountDownLatch(1);
        this.collector.enable(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 1);
        this.collector.disable();
        this.collector.disable();
        this.eventQueue.append((MetadataCollectorEvent)new TestControllerActiveEvent(this.collector, testLatch, -1, false, this.time));
        TestUtils.waitForCondition(() -> testLatch.getCount() == 0L, (String)"Test Latch never decrement");
    }

    @Test
    void testDoubleShutdown() {
        this.collector.shutdown();
        this.collector.shutdown();
        ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.times((int)2))).info((String)ArgumentMatchers.eq((Object)"Finished shutdown."));
    }

    @Test
    public void testCollectorListenBeforeStart() throws InterruptedException {
        final AtomicReference<Object> exceptionClass = new AtomicReference<Object>(null);
        MetadataCollectorEvent testEvent = new MetadataCollectorEvent(this.collector, this.time){

            public void run() throws Exception {
                this.context();
            }

            public void handleException(Throwable e) {
                exceptionClass.set(e.getClass());
            }
        };
        this.eventQueue.append(testEvent);
        TestUtils.waitForCondition(() -> ((Class)exceptionClass.get()).equals(CollectorContextNotInitializedException.class), (String)"Didn't get expected exception.");
    }

    @Test
    public void testEnableCollectorAfterShutdown() {
        ArgumentCaptor exceptionArgumentCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        this.collector.shutdown();
        this.collector.enable(Collections.emptyMap(), Collections.EMPTY_MAP, 1);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error((String)ArgumentMatchers.any(), (Throwable)exceptionArgumentCaptor.capture());
        Assertions.assertNotNull((Object)exceptionArgumentCaptor.getValue());
    }

    public class TestControllerActiveEvent
    extends MetadataCollectorEvent {
        private final boolean shouldActive;
        private final int expectedEpoch;
        private final CountDownLatch countDownLatch;

        public TestControllerActiveEvent(ZKMetadataCollector collector, CountDownLatch countDownLatch, int expectedEpoch, boolean shouldActive, Time time) {
            super(collector, time);
            this.expectedEpoch = expectedEpoch;
            this.countDownLatch = countDownLatch;
            this.shouldActive = shouldActive;
        }

        public void run() throws Exception {
            Assertions.assertEquals((Object)this.shouldActive, (Object)this.collector.isActive());
            if (this.shouldActive) {
                Assertions.assertEquals((int)this.expectedEpoch, (int)((ZKMetadataCollectorContext)this.collector.collectorContext().get()).epoch());
            }
            this.countDownLatch.countDown();
        }
    }
}

