/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kafka.catalog.MetadataCollectorTestUtils$;
import kafka.controller.KafkaController;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.link.ConnectionMode;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ZK, brokers=3)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u000e\u001d\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019I\u0004\u0001)A\u0005m!)!\b\u0001C\u0001w!)a\t\u0001C\u0001w!)A\u000b\u0001C\u0001w!)q\u000b\u0001C\u0001w!)q\r\u0001C\u0001w!)\u0001\u000f\u0001C\u0001w!)1\u000f\u0001C\u0001w!)\u0011\u0010\u0001C\u0001w!)A\u0010\u0001C\u0001w!)q\u0010\u0001C\u0001w!1\u0011Q\u0001\u0001\u0005\u0002mBq!!\u0005\u0001\t\u0013\t\u0019\u0002\u0003\u0004\u00022\u0001!Ia\u000f\u0005\u0007\u0003g\u0001A\u0011B\u001e\t\r\u0005U\u0002\u0001\"\u0003<\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAU\u0001\u0011%\u00111\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0005\tR6*T3uC\u0012\fG/Y\"pY2,7\r^8s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011QDH\u0001\bG\u0006$\u0018\r\\8h\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003U5j\u0011a\u000b\u0006\u0003Yy\tA\u0001^3ti&\u0011af\u000b\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u000f\t\u000b!\u0012\u0001\u0019A\u0015\u0002\u0015%s\u0015\nV0F!>\u001b\u0005*F\u00017!\t\u0019s'\u0003\u00029I\t\u0019\u0011J\u001c;\u0002\u0017%s\u0015\nV0F!>\u001b\u0005\nI\u0001\u001ei\u0016\u001cH/T3uC\u0012\fG/Y\"pY2,7\r^8s\t&\u001c\u0018M\u00197fIR\tA\b\u0005\u0002${%\u0011a\b\n\u0002\u0005+:LG\u000f\u000b\u0002\u0006\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111iK\u0001\u000bC:tw\u000e^1uS>t\u0017BA#C\u0005-\u0019E.^:uKJ$Vm\u001d;\u00029Q,7\u000f^'fi\u0006$\u0017\r^1D_2dWm\u0019;pe\u0016s\u0017M\u00197fI\"\"a\u0001\u0011%J\u0003A\u0019XM\u001d<feB\u0013x\u000e]3si&,7\u000fL\u0001KW\u0015YejT)S!\t\tE*\u0003\u0002N\u0005\n)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\n\u0001+\u0001\u0012d_:4G.^3oi:\u001a\u0017\r^1m_\u001et3m\u001c7mK\u000e$xN\u001d\u0018f]\u0006\u0014G.Z\u0001\u0006m\u0006dW/Z\u0011\u0002'\u0006!AO];f\u0003e!Xm\u001d;Es:\fW.[2D_:4\u0017n\u001a#jg\u0006\u0014G.\u001a3)\t\u001d\u0001\u0005J\u0016\u0017\u0002\u0015\u0006!B/Z:u)>\u0004\u0018n\u0019#fYR\fWI^3oiNDC\u0001\u0003!I32\"!JW/cW\u0015YejW)SC\u0005a\u0016aL2p]\u001adW/\u001a8u]\r\fG/\u00197pO:\u001aw\u000e\u001c7fGR|'O\f4vY2t3m\u001c8gS\u001e\u001ch&\u001a8bE2,7&B&O=F\u0003\u0017%A0\u0002g\r|gN\u001a7vK:$hfY1uC2|wML2pY2,7\r^8s]Mt\u0017\r]:i_Rt\u0013N\\5u]\u0011,G.Y=/g\u0016\u001c\u0017%A1\u0002\u0005M\u00024&B&OGF+\u0017%\u00013\u0002!5,GO]5d]I,\u0007o\u001c:uKJ\u001c\u0018%\u00014\u0002G-\fgm[1/i\u0016\u001cHOL'pG.,e/\u001a8u\u000b6LG\u000f^3s!J|g/\u001b3fe\u0006QB/Z:u\u001b&\u0014(o\u001c:U_BL7\rR3mi\u0006,e/\u001a8ug\"\"\u0011\u0002\u0011%jY\u0011Q%.\u001c2,\u000b-se,U6\"\u00031\f\u0011AM\u0016\u0006\u0017:s\u0017k[\u0011\u0002_\u0006\t4m\u001c8gYV,g\u000e\u001e\u0018dCR\fGn\\4/G>dG.Z2u_Jt3O\\1qg\"|GOL5oi\u0016\u0014h/\u00197/g\u0016\u001c\u0017A\u0007;fgR\u001cE.^:uKJd\u0015N\\6EK2$\u0018-\u0012<f]R\u001c\b\u0006\u0002\u0006A\u0011Jd3AS/c\u0003q!Xm\u001d;Ce>\\WM]\"p]\u001aLwm\u00115b]\u001e,WI^3oiNDCa\u0003!Ik2\"!J^7cW\u0015YeJX)xC\u0005A\u0018!A\u001a\u0002CQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e|e/\u001a:sS\u0012,\u0017I\u001c3SKN$\u0018M\u001d;)\t1\u0001\u0005j\u001f\u0017\u0005\u0015*l'-\u0001\u000euKN$X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^#wK:$8\u000f\u000b\u0003\u000e\u0001\"sH\u0006\u0002&k[\n\f1\u0007^3ti6+G/\u00193bi\u0006\u001cE.^:uKJd\u0015N\\6B]\u0012l\u0015N\u001d:peR{\u0007/[2T]\u0006\u00048\u000f[8u\u000bZ,g\u000e^:)\u000b9\u0001\u0005*a\u0001-\t)SWNY\u0001\u0016i\u0016\u001cH/T;mi&$VM\\1oi\u00163XM\u001c;tQ\u0015y\u0001\tSA\u0005Y\u0015Q\u00151B7cW\u0019YeJX)\u0002\u000e\u0005\u0012\u0011qB\u0001\u0002a\u0005iq-\u001a;D_:$(o\u001c7mKJ$B!!\u0006\u0002\"A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cy\t!bY8oiJ|G\u000e\\3s\u0013\u0011\ty\"!\u0007\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDq!a\t\u0011\u0001\u0004\t)#\u0001\u0004ce>\\WM\u001d\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006\u0010\u0002\rM,'O^3s\u0013\u0011\ty#!\u000b\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0013G>tGO]8mY\u0016\u0014h)Y5m_Z,'/\u0001\u000fwKJLg-_(oYf|e.Z!di&4XmQ8mY\u0016\u001cGo\u001c:\u0002/Y,'/\u001b4z\u001d>\f5\r^5wK\u000e{G\u000e\\3di>\u0014\u0018!F:fiV\u0004Xj\\2l\u000bZ,g\u000e^#nSR$XM\u001d\u000b\u0003\u0003w\u0001B!!\u0010\u0002T5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004fm\u0016tGo\u001d\u0006\u0005\u0003\u000b\n9%A\u0002ba&TA!!\u0013\u0002L\u0005IA/\u001a7f[\u0016$(/\u001f\u0006\u0005\u0003\u001b\ny%A\u0005d_:4G.^3oi*\u0011\u0011\u0011K\u0001\u0003S>LA!!\u0016\u0002@\taQI^3oi\u0016k\u0017\u000e\u001e;fe\u0006yQM\\1cY\u0016\u001cu\u000e\u001c7fGR|'\u000fF\u0002=\u00037Bq!!\u0018\u0016\u0001\u0004\ty&A\u0006bI6Lgn\u00117jK:$\b\u0003BA1\u0003kj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003S\nY'A\u0004dY&,g\u000e^:\u000b\u0007}\tiG\u0003\u0003\u0002p\u0005E\u0014AB1qC\u000eDWM\u0003\u0002\u0002t\u0005\u0019qN]4\n\t\u0005]\u00141\r\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0016I\u0016dW\r^3D_2dWm\u0019;pe\u000e{gNZ5h)\ra\u0014Q\u0010\u0005\b\u0003;2\u0002\u0019AA0\u0003A!\u0017n]1cY\u0016\u001cu\u000e\u001c7fGR|'\u000fF\u0002=\u0003\u0007Cq!!\u0018\u0018\u0001\u0004\ty&A\rdQ\u0006tw-\u001a\"s_.,'\u000fR3gCVdGoQ8oM&<Gc\u0002\u001f\u0002\n\u0006-\u0015Q\u0015\u0005\b\u0003;B\u0002\u0019AA0\u0011\u001d\ti\t\u0007a\u0001\u0003\u001f\u000b\u0011bY8oM&<7*Z=\u0011\t\u0005E\u0015q\u0014\b\u0005\u0003'\u000bY\nE\u0002\u0002\u0016\u0012j!!a&\u000b\u0007\u0005e\u0005%\u0001\u0004=e>|GOP\u0005\u0004\u0003;#\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\"\u0006\r&AB*ue&twMC\u0002\u0002\u001e\u0012Bq!a*\u0019\u0001\u0004\ty)A\u0006d_:4\u0017n\u001a,bYV,\u0017!\u00073fY\u0016$XM\u0011:pW\u0016\u0014H)\u001f8b[&\u001c7i\u001c8gS\u001e$R\u0001PAW\u0003_Cq!!\u0018\u001a\u0001\u0004\ty\u0006C\u0004\u0002\u000ef\u0001\r!a$\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0005=\u0003k\u000b9,a/\u0002>\"9\u0011Q\f\u000eA\u0002\u0005}\u0003bBA]5\u0001\u0007\u0011qR\u0001\u000eMVdG\u000eV8qS\u000et\u0015-\\3\t\u000f\u00055%\u00041\u0001\u0002\u0010\"9\u0011q\u0015\u000eA\u0002\u0005=\u0005F\u0002\u0001\u0002BF\u000b9\u000e\u0005\u0003\u0002D\u0006MWBAAc\u0015\u0011\t9-!3\u0002\u0013\u0015DH/\u001a8tS>t'\u0002BA#\u0003\u0017TA!!4\u0002P\u00069!.\u001e9ji\u0016\u0014(\u0002BAi\u0003c\nQA[;oSRLA!!6\u0002F\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5-\u0005\u0005e7EAAn!\u0011\ti.!9\u000e\u0005\u0005}'bAAiW%!\u00111]Ap\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]ND3\u0002AAt\u0003[\fy/!?\u0002|B\u0019\u0011)!;\n\u0007\u0005-(IA\nDYV\u001cH/\u001a:UKN$H)\u001a4bk2$8/A\u0006dYV\u001cH/\u001a:UsB,GEAAy\u0013\u0011\t\u00190!>\u0002\u0005i[%bAA|\u0005\u0006!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012a\u0001\u0015\u0007\u0001\u0005}\u0018Ka\u0002\u0011\t\t\u0005!1A\u0007\u0003\u0003\u0013LAA!\u0002\u0002J\n\u0019A+Y4\"\u0005\t%\u0011aC5oi\u0016<'/\u0019;j_:\u0004")
public class ZKMetadataCollectorIntegrationTest {
    private final ClusterInstance cluster;
    private final int INIT_EPOCH;

    public int INIT_EPOCH() {
        return this.INIT_EPOCH;
    }

    @ClusterTest
    public void testMetadataCollectorDisabled() {
        this.cluster.waitForReadyBrokers();
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> ZKMetadataCollectorIntegrationTest.getController$1(broker))).foreach((Function1 & Serializable)controller -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMetadataCollectorDisabled$2(controller);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true")})
    public void testMetadataCollectorEnabled() {
        this.cluster.waitForReadyBrokers();
        this.verifyOnlyOneActiveCollector();
        this.controllerFailover();
        this.verifyOnlyOneActiveCollector();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true")})
    public void testDynamicConfigDisabled() {
        Admin adminClient = this.cluster.createAdminClient();
        this.cluster.waitForReadyBrokers();
        this.verifyOnlyOneActiveCollector();
        this.disableCollector(adminClient);
        this.verifyNoActiveCollector();
        this.enableCollector(adminClient);
        this.verifyOnlyOneActiveCollector();
        this.deleteCollectorConfig(adminClient);
        this.verifyOnlyOneActiveCollector();
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.full.configs.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="30"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicDeltaEvents() {
        Option<Event> option;
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 2;
        short replicationFactor = 2;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName, numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event topicCreationEvent = (Event)option.get();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions));
        Some x$5 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        Option<String> x$13 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$14 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$15 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this = MetadataCollectorTestUtils$.MODULE$;
        Object var93_25 = null;
        int x$16 = verifyTopicDeltaEvent$default$15_this.INIT_EPOCH();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicCreationEvent, tenant, topic, (Option<Object>)x$4, (Option<Object>)x$5, (Option<Object>)x$7, (Option<Object>)x$8, (Option<TopicMetadata.CleanupPolicy>)x$9, (Option<String>)x$10, (Option<String>)x$11, (Option<String>)x$12, x$13, x$14, x$15, x$16, true);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fullTopicName), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionsMap).asJava()).values().get(fullTopicName)).get();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event partitionsChangeEvent = (Event)option.get();
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions));
        Some x$21 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        Option<Object> x$23 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$6();
        Option<Object> x$24 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$25 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$26 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$27 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$28 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$29 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$30 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$31 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this2 = MetadataCollectorTestUtils$.MODULE$;
        Object var94_44 = null;
        int x$32 = verifyTopicDeltaEvent$default$15_this2.INIT_EPOCH();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(partitionsChangeEvent, tenant, topic, (Option<Object>)x$20, (Option<Object>)x$21, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, true);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, fullTopicName);
        long newRetention = 100000L;
        ConfigEntry retentionEntry = new ConfigEntry("retention.ms", Long.toString(newRetention));
        AlterConfigOp op = new AlterConfigOp(retentionEntry, AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJava())}));
        ((KafkaFuture)adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava()).values().get(resource)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event retentionChangeEvent = (Event)option.get();
        Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions));
        Some x$37 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor));
        Some x$38 = new Some((Object)BoxesRunTime.boxToLong((long)newRetention));
        Option<Object> x$40 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$41 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$42 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$43 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$44 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$45 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$46 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$47 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this3 = MetadataCollectorTestUtils$.MODULE$;
        Object var95_66 = null;
        int x$48 = verifyTopicDeltaEvent$default$15_this3.INIT_EPOCH();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(retentionChangeEvent, tenant, topic, (Option<Object>)x$36, (Option<Object>)x$37, (Option<Object>)x$38, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, true);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        adminClient.deleteTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)fullTopicName, (List)Nil$.MODULE$)).asJava()).all().get();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event topicDeletionEvent = (Event)option.get();
        Option<Object> x$53 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$4();
        Option<Object> x$54 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$5();
        Option<Object> x$55 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$6();
        Option<Object> x$56 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$57 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        Option<String> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$9();
        Option<String> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$10();
        Option<String> x$60 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$11();
        Option<String> x$61 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$12();
        Option<String> x$62 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$13();
        Option<String> x$63 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$14();
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this4 = MetadataCollectorTestUtils$.MODULE$;
        Object var96_83 = null;
        int x$64 = verifyTopicDeltaEvent$default$15_this4.INIT_EPOCH();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicDeletionEvent, tenant, topic, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMirrorTopicDeltaEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 3;
        short replicationFactor = 2;
        String clusterLink = "link1";
        String fullClusterLinkName = new StringBuilder(1).append(tenant).append("_").append(clusterLink).toString();
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin) -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMirrorTopicDeltaEvents$1(fullTopicName, numPartitions, replicationFactor, fullClusterLinkName, adminClient, lastNewEvent, mockEventEmitter, eventIds, tenant, clusterLink, topic, remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="30"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testClusterLinkDeltaEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String clusterLink = "link1";
        String fullClusterLinkName = new StringBuilder(1).append(tenant).append("_").append(clusterLink).toString();
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, x$2) -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testClusterLinkDeltaEvents$1(fullClusterLinkName, adminClient, lastNewEvent, mockEventEmitter, eventIds, tenant, clusterLink, remoteCluster, remoteBootstrapServers, remoteClusterId, x$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="3"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testBrokerConfigChangeEvents() {
        Option<Event> option;
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic1 = "topic1";
        String topic2 = "topic2";
        String fullTopicName1 = new StringBuilder(1).append(tenant).append("_").append(topic1).toString();
        String fullTopicName2 = new StringBuilder(1).append(tenant).append("_").append(topic2).toString();
        int numPartitions = 2;
        short replicationFactor = 2;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName1, numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event cfr_ignored_0 = (Event)option.get();
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        int brokerLogRetentionMs = 20000;
        int brokerLogRetentionBytes = 8888;
        ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigOp alterRetentionMsOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), Integer.toString(brokerLogRetentionMs)), AlterConfigOp.OpType.SET);
        AlterConfigOp alterRetentionBytes = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogRetentionBytesProp(), Integer.toString(brokerLogRetentionBytes)), AlterConfigOp.OpType.SET);
        AlterConfigOp alterCleanupPolicy = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogCleanupPolicyProp(), ""), AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map brokerConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerConfigResource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)alterRetentionMsOp, (List)new .colon.colon((Object)alterRetentionBytes, (List)new .colon.colon((Object)alterCleanupPolicy, (List)Nil$.MODULE$)))).asJava())}));
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerConfigs).asJava()).all().get();
        NewTopic newTopic2 = new NewTopic(fullTopicName2, numPartitions, replicationFactor);
        newTopic2.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"delete,compact")}))).asJava());
        adminClient.createTopics(Collections.singletonList(newTopic2)).all().get();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event topicCreationEvent = (Event)option.get();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicCreationEvent, tenant, topic2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)brokerLogRetentionMs)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)brokerLogRetentionBytes)), (Option<TopicMetadata.CleanupPolicy>)new Some((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), false);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        int topic2RetentionMs = 40000;
        this.changeTopicConfig(adminClient, fullTopicName2, "retention.ms", Integer.toString(topic2RetentionMs));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event topicConfigChangeEvent = (Event)option.get();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(topicConfigChangeEvent, tenant, topic2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)40000L)), (Option<Object>)None$.MODULE$, (Option<TopicMetadata.CleanupPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), false);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        brokerLogRetentionMs = 30000;
        this.changeBrokerDefaultConfig(adminClient, KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), Integer.toString(brokerLogRetentionMs));
        this.deleteBrokerDynamicConfig(adminClient, KafkaConfig$.MODULE$.LogRetentionBytesProp());
        Thread.sleep(2000L);
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds)).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)option.get();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent(snapshotEvent, 0, tenant, topic1, this.INIT_EPOCH(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)brokerLogRetentionMs)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Option<TopicMetadata.CleanupPolicy>)new Some((Object)TopicMetadata.CleanupPolicy.UNSPECIFIED), "topicAndClusterLink", MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$12(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$13(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$14(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$15(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$16(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$17(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$18());
        MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent(snapshotEvent, 1, tenant, topic2, this.INIT_EPOCH(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)topic2RetentionMs)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Option<TopicMetadata.CleanupPolicy>)new Some((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE), "topicAndClusterLink", MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$12(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$13(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$14(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$15(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$16(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$17(), MetadataCollectorTestUtils$.MODULE$.verifyTopicEvent$default$18());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicConfigOverrideAndRestart() {
        Option<Event> option;
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic1 = "topic1";
        String fullTopicName1 = new StringBuilder(1).append(tenant).append("_").append(topic1).toString();
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName1, numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event deltaEvent = (Event)option.get();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(deltaEvent, tenant, topic1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<TopicMetadata.CleanupPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), false);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        int brokerLogRetentionBytes = 30000;
        this.changeBrokerDefaultConfig(adminClient, KafkaConfig$.MODULE$.LogRetentionBytesProp(), Integer.toString(brokerLogRetentionBytes));
        int topicLogRetentionMs = 20000;
        this.changeTopicConfig(adminClient, fullTopicName1, "retention.ms", Integer.toString(topicLogRetentionMs));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter, (scala.collection.mutable.Set<String>)eventIds, "topic")).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        deltaEvent = (Event)option.get();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(deltaEvent, tenant, topic1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)topicLogRetentionMs)), (Option<Object>)None$.MODULE$, (Option<TopicMetadata.CleanupPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), false);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter});
        this.controllerFailover();
        int newEpoch = this.INIT_EPOCH() + 1;
        EventEmitter newMockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> this.getController((KafkaBroker)broker))).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isActive())).flatMap((Function1 & Serializable)x$4 -> x$4.metadataCollector()).map((Function1 & Serializable)x$5 -> x$5.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(option = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter, (scala.collection.mutable.Set<String>)eventIds)).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)option.get();
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)topicLogRetentionMs));
        Some x$7 = new Some((Object)BoxesRunTime.boxToLong((long)brokerLogRetentionBytes));
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        boolean x$19 = true;
        int x$20 = 0;
        int x$21 = 1;
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent, tenant, topic1, numPartitions, replicationFactor, (Option<Object>)x$6, (Option<Object>)x$7, (Option<TopicMetadata.CleanupPolicy>)x$9, (Option<String>)x$10, (Option<String>)x$11, (Option<String>)x$12, (Option<String>)x$13, (Option<String>)x$14, (Option<ClusterLinkConfig.LinkMode>)x$15, (Option<ConnectionMode>)x$16, (Option<String>)x$17, (Option<String>)x$18, x$19, newEpoch, x$20, x$21);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMetadataSnapshotEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 1;
        short replicationFactor = 1;
        String clusterLink = "link1";
        String fullClusterLinkName = new StringBuilder(1).append(tenant).append("_").append(clusterLink).toString();
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin) -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMetadataSnapshotEvents$1(this, adminClient, fullTopicName, numPartitions, replicationFactor, lastNewEvent, mockEventEmitter, eventIds, tenant, topic, fullClusterLinkName, clusterLink, remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMetadataClusterLinkAndMirrorTopicSnapshotEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 1;
        short replicationFactor = 1;
        String clusterLink = "link1";
        String fullClusterLinkName = new StringBuilder(1).append(tenant).append("_").append(clusterLink).toString();
        ConfluentAdmin adminClient = (ConfluentAdmin)this.cluster.createAdminClient();
        MetadataCollectorTestUtils$.MODULE$.runWithRemoteCluster(this.cluster, (Function4<ClusterInstance, String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function4 & Serializable)(remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin) -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$1(this, fullTopicName, numPartitions, replicationFactor, fullClusterLinkName, adminClient, lastNewEvent, mockEventEmitter, eventIds, tenant, clusterLink, topic, remoteCluster, remoteBootstrapServers, remoteClusterId, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="0"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMultiTenantEvents() {
        this.cluster.waitForReadyBrokers();
        scala.collection.mutable.Set eventIds = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set newEvents = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant1 = "lkc-t1";
        String tenant2 = "lkc-t2";
        String topic1 = "topic1";
        String fullTopicName1 = new StringBuilder(1).append(tenant1).append("_").append(topic1).toString();
        String topic2 = "topic2";
        String fullTopicName2 = new StringBuilder(1).append(tenant1).append("_").append(topic2).toString();
        String topic3 = "topic3";
        String fullTopicName3 = new StringBuilder(1).append(tenant2).append("_").append(topic3).toString();
        scala.collection.mutable.Map mapping = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant1), Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant2), Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic3})))}));
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName1, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName2, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName3, numPartitions, replicationFactor);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$1(mockEventEmitter, eventIds, newEvents)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Not enough events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOnceOps)newEvents.map((Function1 & Serializable)event -> MetadataChange.parseFrom((byte[])((byte[])event.data().get())))).foreach((Function1 & Serializable)change -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$4(mapping, change);
            return BoxedUnit.UNIT;
        });
        mapping.values().foreach((Function1 & Serializable)pendingTopics -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$7(pendingTopics);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaController getController(KafkaBroker broker) {
        return ((KafkaServer)broker).kafkaController();
    }

    private void controllerFailover() {
        int activeControllerBrokerId = BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ZKMetadataCollectorIntegrationTest.$anonfun$controllerFailover$1(this, broker))).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)ZKMetadataCollectorIntegrationTest.$anonfun$controllerFailover$2(x$13))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No controller leader found, should not have happened");
        }));
        this.cluster.shutdownBroker(activeControllerBrokerId);
        this.cluster.startBroker(activeControllerBrokerId);
    }

    private void verifyOnlyOneActiveCollector() {
        IntRef activeCount = IntRef.create((int)0);
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> this.getController((KafkaBroker)broker))).foreach((Function1 & Serializable)controller -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$2(activeCount, controller);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)activeCount.elem, (String)"Should have exactly one active collector");
    }

    private void verifyNoActiveCollector() {
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> this.getController((KafkaBroker)broker))).foreach((Function1 & Serializable)controller -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$verifyNoActiveCollector$2(controller);
            return BoxedUnit.UNIT;
        });
    }

    private EventEmitter setupMockEventEmitter() {
        EventEmitter mockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> this.getController((KafkaBroker)broker))).find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.isActive())).flatMap((Function1 & Serializable)x$18 -> x$18.metadataCollector()).map((Function1 & Serializable)x$19 -> x$19.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)mockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        return mockEventEmitter;
    }

    private void enableCollector(Admin adminClient) {
        ConfigEntry entry = new ConfigEntry("confluent.catalog.collector.enable", "true");
        Set<AlterConfigOp> configs = Collections.singleton(new AlterConfigOp(entry, AlterConfigOp.OpType.SET));
        ConfigResource broker = new ConfigResource(ConfigResource.Type.BROKER, "");
        adminClient.incrementalAlterConfigs(Collections.singletonMap(broker, configs));
    }

    private void deleteCollectorConfig(Admin adminClient) {
        ConfigEntry entry = new ConfigEntry("confluent.catalog.collector.enable", "");
        Set<AlterConfigOp> configs = Collections.singleton(new AlterConfigOp(entry, AlterConfigOp.OpType.DELETE));
        ConfigResource broker = new ConfigResource(ConfigResource.Type.BROKER, "");
        adminClient.incrementalAlterConfigs(Collections.singletonMap(broker, configs));
    }

    private void disableCollector(Admin adminClient) {
        ConfigEntry entry = new ConfigEntry("confluent.catalog.collector.enable", "false");
        Set<AlterConfigOp> configs = Collections.singleton(new AlterConfigOp(entry, AlterConfigOp.OpType.SET));
        ConfigResource broker = new ConfigResource(ConfigResource.Type.BROKER, "");
        adminClient.incrementalAlterConfigs(Collections.singletonMap(broker, configs));
    }

    private void changeBrokerDefaultConfig(Admin adminClient, String configKey, String configValue) {
        ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        ConfigEntry configEntry = new ConfigEntry(configKey, configValue);
        AlterConfigOp op = new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map brokerConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerConfigResource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJava())}));
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerConfigs).asJava()).all().get();
    }

    private void deleteBrokerDynamicConfig(Admin adminClient, String configKey) {
        ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        ConfigEntry configEntry = new ConfigEntry(configKey, "");
        AlterConfigOp op = new AlterConfigOp(configEntry, AlterConfigOp.OpType.DELETE);
        scala.collection.immutable.Map brokerConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerConfigResource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJava())}));
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerConfigs).asJava()).all().get();
    }

    private void changeTopicConfig(Admin adminClient, String fullTopicName, String configKey, String configValue) {
        ConfigResource topicConfigResource = new ConfigResource(ConfigResource.Type.TOPIC, fullTopicName);
        ConfigEntry configEntry = new ConfigEntry(configKey, configValue);
        AlterConfigOp topicOp = new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicConfigResource), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicOp, (List)Nil$.MODULE$)).asJava())}));
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava()).all().get();
    }

    private static final KafkaController getController$1(KafkaBroker broker) {
        return ((KafkaServer)broker).kafkaController();
    }

    public static final /* synthetic */ void $anonfun$testMetadataCollectorDisabled$2(KafkaController controller) {
        Assertions.assertFalse((boolean)controller.metadataCollector().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActive())));
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$1(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$3(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$5(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$6() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$7(ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, scala.collection.mutable.Set eventIds$1) {
        lastNewEvent$1.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$1, "topic");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$8() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorTopicDeltaEvents$2(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "clusterLink");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMirrorTopicDeltaEvents$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorTopicDeltaEvents$4(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "topic");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMirrorTopicDeltaEvents$5() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorTopicDeltaEvents$6(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "topic");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMirrorTopicDeltaEvents$7() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorTopicDeltaEvents$8(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "clusterLink");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMirrorTopicDeltaEvents$9() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorTopicDeltaEvents$10(ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2) {
        lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2);
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMirrorTopicDeltaEvents$11() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMirrorTopicDeltaEvents$1(String fullTopicName$1, int numPartitions$1, short replicationFactor$1, String fullClusterLinkName$1, ConfluentAdmin adminClient$1, ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, scala.collection.mutable.Set eventIds$2, String tenant$1, String clusterLink$1, String topic$1, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        IntegrationTestUtils$.MODULE$.createTopic((Admin)remoteAdmin, fullTopicName$1, numPartitions$1, replicationFactor$1);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(remoteCluster.brokersMap().values()).asScala().toSeq(), fullTopicName$1, numPartitions$1);
        java.util.Map topicDescription = (java.util.Map)remoteAdmin.describeTopics(Collections.singletonList(fullTopicName$1)).allTopicNames().get();
        String sourceTopicId = ((TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala(topicDescription).asScala().apply((Object)fullTopicName$1)).topicId().toString();
        NewClusterLink newClusterLink = new NewClusterLink(fullClusterLinkName$1, (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$1.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "clusterLink");
            if (((Option)lastNewEvent$2.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event clusterLinkCreationEvent = (Event)((Option)lastNewEvent$2.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkCreationEvent, tenant$1, clusterLink$1, true, (Option<ClusterLinkConfig.LinkMode>)new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION), (Option<ConnectionMode>)new Some((Object)ConnectionMode.Outbound$.MODULE$), (Option<String>)remoteClusterId, (Option<String>)new Some((Object)tenant$1), 0, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$2});
        NewMirrorTopic mirrorTopic = new NewMirrorTopic(fullClusterLinkName$1, fullTopicName$1);
        NewTopic newTopic = new NewTopic(fullTopicName$1, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)replicationFactor$1))).mirror(Optional.of(mirrorTopic));
        adminClient$1.createTopics(Collections.singletonList(newTopic)).all().get();
        Collection clusterLinkListings = (Collection)adminClient$1.listClusterLinks(new ListClusterLinksOptions()).result().get();
        String linkId = ((ClusterLinkListing)CollectionConverters$.MODULE$.CollectionHasAsScala(clusterLinkListings).asScala().head()).clusterLinkId().toString();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "topic");
            if (((Option)lastNewEvent$2.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event mirrorTopicCreationEvent = (Event)((Option)lastNewEvent$2.elem).get();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions$1));
        Some x$5 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor$1));
        Some x$6 = new Some((Object)"Mirror");
        Some x$7 = new Some((Object)clusterLink$1);
        Some x$8 = new Some((Object)linkId);
        Some x$9 = new Some((Object)sourceTopicId);
        Some x$10 = new Some((Object)topic$1);
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this = MetadataCollectorTestUtils$.MODULE$;
        Object var81_40 = null;
        int x$15 = verifyTopicDeltaEvent$default$15_this.INIT_EPOCH();
        boolean x$16 = false;
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(mirrorTopicCreationEvent, tenant$1, topic$1, (Option<Object>)x$4, (Option<Object>)x$5, (Option<Object>)x$12, (Option<Object>)x$13, (Option<TopicMetadata.CleanupPolicy>)x$14, (Option<String>)x$6, (Option<String>)x$8, (Option<String>)x$7, (Option<String>)x$9, (Option<String>)x$10, (Option<String>)remoteClusterId, x$15, x$16);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$2});
        adminClient$1.alterMirrors(Collections.singletonMap(fullTopicName$1, AlterMirrorOp.PAUSE), new AlterMirrorsOptions()).all().get();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "topic");
            if (((Option)lastNewEvent$2.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event mirrorTopicChangeEvent = (Event)((Option)lastNewEvent$2.elem).get();
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions$1));
        Some x$21 = new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor$1));
        Some x$22 = new Some((Object)"PausedMirror");
        Some x$23 = new Some((Object)clusterLink$1);
        Some x$24 = new Some((Object)linkId);
        Some x$25 = new Some((Object)sourceTopicId);
        Some x$26 = new Some((Object)topic$1);
        None$ x$28 = None$.MODULE$;
        Option<Object> x$29 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$30 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$8();
        MetadataCollectorTestUtils$ verifyTopicDeltaEvent$default$15_this2 = MetadataCollectorTestUtils$.MODULE$;
        Object var82_57 = null;
        int x$31 = verifyTopicDeltaEvent$default$15_this2.INIT_EPOCH();
        boolean x$32 = MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent$default$16();
        MetadataCollectorTestUtils$.MODULE$.verifyTopicDeltaEvent(mirrorTopicChangeEvent, tenant$1, topic$1, (Option<Object>)x$20, (Option<Object>)x$21, (Option<Object>)x$28, x$29, x$30, (Option<String>)x$22, (Option<String>)x$24, (Option<String>)x$23, (Option<String>)x$25, (Option<String>)x$26, (Option<String>)remoteClusterId, x$31, x$32);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$2});
        adminClient$1.deleteClusterLinks(Collections.singletonList(fullClusterLinkName$1), new DeleteClusterLinksOptions().force(true)).all().get();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2, "clusterLink");
            if (((Option)lastNewEvent$2.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event clusterLinkDeletionEvent = (Event)((Option)lastNewEvent$2.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkDeletionEvent, tenant$1, clusterLink$1, MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$4(), MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$5(), MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$6(), MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$7(), MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$8(), MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent$default$9(), MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$2});
        Thread.sleep(2000L);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$2.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$2);
            if (((Option)lastNewEvent$2.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        MetadataChange metadataChange = MetadataChange.parseFrom((byte[])((byte[])((Event)((Option)lastNewEvent$2.elem).get()).data().get()));
        Assertions.assertEquals((Object)MirrorTopicMetadata.getDefaultInstance(), (Object)metadataChange.getEvents(0).getTopicMetadata().getMirrorTopicMetadata());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$2});
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkDeltaEvents$2(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$3, scala.collection.mutable.Set eventIds$3) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkDeltaEvents$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkDeltaEvents$4(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$3, scala.collection.mutable.Set eventIds$3) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkDeltaEvents$5() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkDeltaEvents$6(ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$3, scala.collection.mutable.Set eventIds$3) {
        lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
        return ((Option)lastNewEvent$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkDeltaEvents$7() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkDeltaEvents$1(String fullClusterLinkName$2, ConfluentAdmin adminClient$2, ObjectRef lastNewEvent$3, EventEmitter mockEventEmitter$3, scala.collection.mutable.Set eventIds$3, String tenant$2, String clusterLink$2, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin x$2) {
        NewClusterLink newClusterLink = new NewClusterLink(fullClusterLinkName$2, (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$2.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event clusterLinkCreationEvent = (Event)((Option)lastNewEvent$3.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkCreationEvent, tenant$2, clusterLink$2, true, (Option<ClusterLinkConfig.LinkMode>)new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION), (Option<ConnectionMode>)new Some((Object)ConnectionMode.Outbound$.MODULE$), (Option<String>)remoteClusterId, (Option<String>)new Some((Object)tenant$2), 0, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$3});
        adminClient$2.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, fullClusterLinkName$2), Collections.singleton(new AlterConfigOp(new ConfigEntry("cluster.link.paused", "true"), AlterConfigOp.OpType.SET))));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event clusterLinkConfigChangeEvent = (Event)((Option)lastNewEvent$3.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkConfigChangeEvent, tenant$2, clusterLink$2, true, (Option<ClusterLinkConfig.LinkMode>)new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION), (Option<ConnectionMode>)new Some((Object)ConnectionMode.Outbound$.MODULE$), (Option<String>)remoteClusterId, (Option<String>)new Some((Object)tenant$2), 0, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$3});
        adminClient$2.deleteClusterLinks(Collections.singletonList(fullClusterLinkName$2), new DeleteClusterLinksOptions());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$3.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$3, "clusterLink");
            if (((Option)lastNewEvent$3.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event clusterLinkDeletionEvent = (Event)((Option)lastNewEvent$3.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyClusterLinkDeltaEvent(clusterLinkDeletionEvent, tenant$2, clusterLink$2, false, (Option<ClusterLinkConfig.LinkMode>)None$.MODULE$, (Option<ConnectionMode>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, 0, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$3});
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerConfigChangeEvents$1(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testBrokerConfigChangeEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerConfigChangeEvents$3(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testBrokerConfigChangeEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerConfigChangeEvents$5(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4, "topic");
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testBrokerConfigChangeEvents$6() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerConfigChangeEvents$7(ObjectRef lastNewEvent$4, EventEmitter mockEventEmitter$4, scala.collection.mutable.Set eventIds$4) {
        lastNewEvent$4.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$4, (scala.collection.mutable.Set<String>)eventIds$4);
        return ((Option)lastNewEvent$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testBrokerConfigChangeEvents$8() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigOverrideAndRestart$1(ObjectRef lastNewEvent$5, EventEmitter mockEventEmitter$5, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$5.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5, "topic");
        return ((Option)lastNewEvent$5.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigOverrideAndRestart$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigOverrideAndRestart$3(ObjectRef lastNewEvent$5, EventEmitter mockEventEmitter$5, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$5.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewEvent(mockEventEmitter$5, (scala.collection.mutable.Set<String>)eventIds$5, "topic");
        return ((Option)lastNewEvent$5.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigOverrideAndRestart$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigOverrideAndRestart$10(ObjectRef lastNewEvent$5, EventEmitter newMockEventEmitter$1, scala.collection.mutable.Set eventIds$5) {
        lastNewEvent$5.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter$1, (scala.collection.mutable.Set<String>)eventIds$5);
        return ((Option)lastNewEvent$5.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigOverrideAndRestart$11() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataSnapshotEvents$2(ObjectRef lastNewEvent$6, EventEmitter mockEventEmitter$6, scala.collection.mutable.Set eventIds$6) {
        lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
        return ((Option)lastNewEvent$6.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataSnapshotEvents$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataSnapshotEvents$4(ObjectRef lastNewEvent$6, EventEmitter mockEventEmitter$6, scala.collection.mutable.Set eventIds$6) {
        lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
        return ((Option)lastNewEvent$6.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataSnapshotEvents$5() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataSnapshotEvents$6(ObjectRef lastNewEvent$6, EventEmitter mockEventEmitter$6, scala.collection.mutable.Set eventIds$6) {
        lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
        return ((Option)lastNewEvent$6.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataSnapshotEvents$7() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataSnapshotEvents$13(ObjectRef lastNewEvent$6, EventEmitter newMockEventEmitter$2, scala.collection.mutable.Set eventIds$6) {
        lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter$2, (scala.collection.mutable.Set<String>)eventIds$6);
        return ((Option)lastNewEvent$6.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataSnapshotEvents$14() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMetadataSnapshotEvents$1(ZKMetadataCollectorIntegrationTest $this, ConfluentAdmin adminClient$3, String fullTopicName$2, int numPartitions$2, short replicationFactor$2, ObjectRef lastNewEvent$6, EventEmitter mockEventEmitter$6, scala.collection.mutable.Set eventIds$6, String tenant$3, String topic$2, String fullClusterLinkName$3, String clusterLink$3, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        IntegrationTestUtils$.MODULE$.createTopic((Admin)adminClient$3, fullTopicName$2, numPartitions$2, replicationFactor$2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
            if (((Option)lastNewEvent$6.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)((Option)lastNewEvent$6.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent, tenant$3, topic$2, numPartitions$2, replicationFactor$2, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<TopicMetadata.CleanupPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ClusterLinkConfig.LinkMode>)None$.MODULE$, (Option<ConnectionMode>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, true, MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), 0, 1);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$6});
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fullTopicName$2), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient$3.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionsMap).asJava()).values().get(fullTopicName$2)).get();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
            if (((Option)lastNewEvent$6.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent2 = (Event)((Option)lastNewEvent$6.elem).get();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent2, tenant$3, topic$2, newNumPartitions, replicationFactor$2, MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$10(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$14(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$15(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$16(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$17(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18(), MetadataCollectorTestUtils$.MODULE$.INIT_EPOCH(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20(), MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21());
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$6});
        NewClusterLink newClusterLink = new NewClusterLink(fullClusterLinkName$3, (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$3.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$6, (scala.collection.mutable.Set<String>)eventIds$6);
            if (((Option)lastNewEvent$6.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent3 = (Event)((Option)lastNewEvent$6.elem).get();
        Some x$62 = new Some((Object)clusterLink$3);
        Some x$72 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$82 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$10 = new Some((Object)tenant$3);
        Option<Object> x$11 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$12 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$13 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$14 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$15 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$16 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$17 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        boolean x$18 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        MetadataCollectorTestUtils$ verifyMetadataSnapshotEvent$default$19_this = MetadataCollectorTestUtils$.MODULE$;
        Object var78_43 = null;
        int x$19 = verifyMetadataSnapshotEvent$default$19_this.INIT_EPOCH();
        int x$20 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$21 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent3, tenant$3, topic$2, newNumPartitions, replicationFactor$2, x$11, x$12, x$13, x$14, (Option<String>)x$62, x$15, x$16, x$17, (Option<ClusterLinkConfig.LinkMode>)x$72, (Option<ConnectionMode>)x$82, (Option<String>)remoteClusterId, (Option<String>)x$10, x$18, x$19, x$20, x$21);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$6});
        $this.controllerFailover();
        int newEpoch = $this.INIT_EPOCH() + 1;
        EventEmitter newMockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> $this.getController((KafkaBroker)broker))).find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isActive())).flatMap((Function1 & Serializable)x$7 -> x$7.metadataCollector()).map((Function1 & Serializable)x$8 -> x$8.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$6.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter, (scala.collection.mutable.Set<String>)eventIds$6);
            if (((Option)lastNewEvent$6.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent4 = (Event)((Option)lastNewEvent$6.elem).get();
        Some x$27 = new Some((Object)clusterLink$3);
        Some x$28 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$29 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$31 = new Some((Object)tenant$3);
        Option<Object> x$33 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$34 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$35 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$36 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$37 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$38 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$39 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        boolean x$40 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$41 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$42 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent4, tenant$3, topic$2, newNumPartitions, replicationFactor$2, x$33, x$34, x$35, x$36, (Option<String>)x$27, x$37, x$38, x$39, (Option<ClusterLinkConfig.LinkMode>)x$28, (Option<ConnectionMode>)x$29, (Option<String>)remoteClusterId, (Option<String>)x$31, x$40, newEpoch, x$41, x$42);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$6});
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$2(ObjectRef lastNewEvent$7, EventEmitter mockEventEmitter$7, scala.collection.mutable.Set eventIds$7) {
        lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
        return ((Option)lastNewEvent$7.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$3() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$4(ObjectRef lastNewEvent$7, EventEmitter mockEventEmitter$7, scala.collection.mutable.Set eventIds$7) {
        lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
        return ((Option)lastNewEvent$7.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$5() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$6(ObjectRef lastNewEvent$7, EventEmitter mockEventEmitter$7, scala.collection.mutable.Set eventIds$7) {
        lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
        return ((Option)lastNewEvent$7.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$7() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$13(ObjectRef lastNewEvent$7, EventEmitter newMockEventEmitter$3, scala.collection.mutable.Set eventIds$7) {
        lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter$3, (scala.collection.mutable.Set<String>)eventIds$7);
        return ((Option)lastNewEvent$7.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$14() {
        return "No events emitted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMetadataClusterLinkAndMirrorTopicSnapshotEvents$1(ZKMetadataCollectorIntegrationTest $this, String fullTopicName$3, int numPartitions$3, short replicationFactor$3, String fullClusterLinkName$4, ConfluentAdmin adminClient$4, ObjectRef lastNewEvent$7, EventEmitter mockEventEmitter$7, scala.collection.mutable.Set eventIds$7, String tenant$4, String clusterLink$4, String topic$3, ClusterInstance remoteCluster, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        IntegrationTestUtils$.MODULE$.createTopic((Admin)remoteAdmin, fullTopicName$3, numPartitions$3, replicationFactor$3);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(remoteCluster.brokersMap().values()).asScala().toSeq(), fullTopicName$3, numPartitions$3);
        java.util.Map topicDescription = (java.util.Map)remoteAdmin.describeTopics(Collections.singletonList(fullTopicName$3)).allTopicNames().get();
        String sourceTopicId = ((TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala(topicDescription).asScala().apply((Object)fullTopicName$3)).topicId().toString();
        NewClusterLink newClusterLink = new NewClusterLink(fullClusterLinkName$4, (String)remoteClusterId.get(), Collections.singletonMap("bootstrap.servers", remoteBootstrapServers));
        adminClient$4.createClusterLinks(Collections.singletonList(newClusterLink), new CreateClusterLinksOptions());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
            if (((Option)lastNewEvent$7.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)((Option)lastNewEvent$7.elem).get();
        Some x$6 = new Some((Object)clusterLink$4);
        Some x$7 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$8 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$102 = new Some((Object)tenant$4);
        Option<Object> x$12 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$13 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$14 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        Option<String> x$15 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$9();
        Option<String> x$16 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$11();
        Option<String> x$17 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$12();
        Option<String> x$18 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$13();
        boolean x$19 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$20 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$19();
        int x$21 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent, tenant$4, null, 0, (short)0, x$12, x$13, x$14, x$15, (Option<String>)x$6, x$16, x$17, x$18, (Option<ClusterLinkConfig.LinkMode>)x$7, (Option<ConnectionMode>)x$8, (Option<String>)remoteClusterId, (Option<String>)x$102, x$19, x$20, x$21, 0);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$7});
        NewMirrorTopic mirrorTopic = new NewMirrorTopic(fullClusterLinkName$4, fullTopicName$3);
        NewTopic newTopic = new NewTopic(fullTopicName$3, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)replicationFactor$3))).mirror(Optional.of(mirrorTopic));
        adminClient$4.createTopics(Collections.singletonList(newTopic)).all().get();
        Collection clusterLinkListings = (Collection)adminClient$4.listClusterLinks(new ListClusterLinksOptions()).result().get();
        String linkId = ((ClusterLinkListing)CollectionConverters$.MODULE$.CollectionHasAsScala(clusterLinkListings).asScala().head()).clusterLinkId().toString();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
            if (((Option)lastNewEvent$7.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent2 = (Event)((Option)lastNewEvent$7.elem).get();
        Some x$27 = new Some((Object)clusterLink$4);
        Some x$28 = new Some((Object)linkId);
        Some x$29 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$30 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$32 = new Some((Object)tenant$4);
        Some x$33 = new Some((Object)"Mirror");
        Some x$34 = new Some((Object)topic$3);
        Some x$35 = new Some((Object)sourceTopicId);
        Option<Object> x$36 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$37 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$38 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        boolean x$39 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$40 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$19();
        int x$41 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$42 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent2, tenant$4, topic$3, numPartitions$3, replicationFactor$3, x$36, x$37, x$38, (Option<String>)x$33, (Option<String>)x$27, (Option<String>)x$28, (Option<String>)x$35, (Option<String>)x$34, (Option<ClusterLinkConfig.LinkMode>)x$29, (Option<ConnectionMode>)x$30, (Option<String>)remoteClusterId, (Option<String>)x$32, x$39, x$40, x$41, x$42);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$7});
        adminClient$4.alterMirrors(Collections.singletonMap(fullTopicName$3, AlterMirrorOp.PAUSE), new AlterMirrorsOptions()).all().get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$7, (scala.collection.mutable.Set<String>)eventIds$7);
            if (((Option)lastNewEvent$7.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent3 = (Event)((Option)lastNewEvent$7.elem).get();
        Some x$48 = new Some((Object)clusterLink$4);
        Some x$49 = new Some((Object)linkId);
        Some x$50 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$51 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$53 = new Some((Object)tenant$4);
        Some x$54 = new Some((Object)"PausedMirror");
        Some x$55 = new Some((Object)topic$3);
        Some x$56 = new Some((Object)sourceTopicId);
        Option<Object> x$57 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$58 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$59 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        boolean x$60 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$61 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$19();
        int x$62 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$63 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent3, tenant$4, topic$3, numPartitions$3, replicationFactor$3, x$57, x$58, x$59, (Option<String>)x$54, (Option<String>)x$48, (Option<String>)x$49, (Option<String>)x$56, (Option<String>)x$55, (Option<ClusterLinkConfig.LinkMode>)x$50, (Option<ConnectionMode>)x$51, (Option<String>)remoteClusterId, (Option<String>)x$53, x$60, x$61, x$62, x$63);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$7});
        $this.controllerFailover();
        int newEpoch = $this.INIT_EPOCH() + 1;
        EventEmitter newMockEventEmitter = (EventEmitter)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokersMap().values()).asScala().map((Function1 & Serializable)broker -> $this.getController((KafkaBroker)broker))).find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isActive())).flatMap((Function1 & Serializable)x$10 -> x$10.metadataCollector()).map((Function1 & Serializable)x$11 -> x$11.eventEmitter()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            lastNewEvent$7.elem = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(newMockEventEmitter, (scala.collection.mutable.Set<String>)eventIds$7);
            if (((Option)lastNewEvent$7.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"No events emitted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent4 = (Event)((Option)lastNewEvent$7.elem).get();
        Some x$69 = new Some((Object)clusterLink$4);
        Some x$70 = new Some((Object)linkId);
        Some x$71 = new Some((Object)ClusterLinkConfig.LinkMode.DESTINATION);
        Some x$72 = new Some((Object)ConnectionMode.Outbound$.MODULE$);
        Some x$74 = new Some((Object)tenant$4);
        Some x$75 = new Some((Object)"PausedMirror");
        Some x$76 = new Some((Object)topic$3);
        Some x$77 = new Some((Object)sourceTopicId);
        Option<Object> x$79 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$6();
        Option<Object> x$80 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$7();
        Option<TopicMetadata.CleanupPolicy> x$81 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$8();
        boolean x$82 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$18();
        int x$83 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$20();
        int x$84 = MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent$default$21();
        MetadataCollectorTestUtils$.MODULE$.verifyMetadataSnapshotEvent(snapshotEvent4, tenant$4, topic$3, numPartitions$3, replicationFactor$3, x$79, x$80, x$81, (Option<String>)x$75, (Option<String>)x$69, (Option<String>)x$70, (Option<String>)x$77, (Option<String>)x$76, (Option<ClusterLinkConfig.LinkMode>)x$71, (Option<ConnectionMode>)x$72, (Option<String>)remoteClusterId, (Option<String>)x$74, x$82, newEpoch, x$83, x$84);
        Mockito.clearInvocations((Object[])new EventEmitter[]{mockEventEmitter$7});
    }

    public static final /* synthetic */ boolean $anonfun$testMultiTenantEvents$1(EventEmitter mockEventEmitter$8, scala.collection.mutable.Set eventIds$8, scala.collection.mutable.Set newEvents$1) {
        Option<Event> lastEvent = MetadataCollectorTestUtils$.MODULE$.getLastNewMetadataEvent(mockEventEmitter$8, (scala.collection.mutable.Set<String>)eventIds$8);
        if (lastEvent.isDefined()) {
            newEvents$1.add(lastEvent.get());
        }
        return newEvents$1.size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testMultiTenantEvents$2() {
        return "Not enough events emitted";
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$4(scala.collection.mutable.Map mapping$1, MetadataChange change) {
        scala.collection.mutable.Set topics = (scala.collection.mutable.Set)mapping$1.apply((Object)change.getSource());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(change.getEventsList()).asScala().map((Function1 & Serializable)x$12 -> x$12.getTopicMetadata().getTopicName())).foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)topics.remove((Object)elem)));
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$7(scala.collection.mutable.Set pendingTopics) {
        Assertions.assertTrue((boolean)pendingTopics.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$1(ZKMetadataCollectorIntegrationTest $this, KafkaBroker broker) {
        return ((KafkaServer)broker).kafkaController().isActive();
    }

    public static final /* synthetic */ int $anonfun$controllerFailover$2(KafkaBroker x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$verifyOnlyOneActiveCollector$3(KafkaController controller$1) {
        return controller$1.metadataCollector().exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isActive()));
    }

    public static final /* synthetic */ String $anonfun$verifyOnlyOneActiveCollector$5() {
        return "Collector isn't active";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyOnlyOneActiveCollector$2(IntRef activeCount$1, KafkaController controller) {
        if (controller.isActive()) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZKMetadataCollectorIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$3(controller)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Collector isn't active");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ++activeCount$1.elem;
            return;
        }
        Assertions.assertFalse((boolean)controller.metadataCollector().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isActive())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoActiveCollector$3(KafkaController controller$2) {
        return !controller$2.metadataCollector().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isActive()));
    }

    public static final /* synthetic */ String $anonfun$verifyNoActiveCollector$5() {
        return "Collector hasn't been disabled yet";
    }

    public static final /* synthetic */ void $anonfun$verifyNoActiveCollector$2(KafkaController controller) {
        if (controller.isActive()) {
            long waitUntilTrue_pause = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZKMetadataCollectorIntegrationTest.$anonfun$verifyNoActiveCollector$3(controller)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Collector hasn't been disabled yet");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
            }
            return;
        }
    }

    public ZKMetadataCollectorIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.INIT_EPOCH = 1;
    }
}

