/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PartitionTest$;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.MetadataCache;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ZkAlterPartitionManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011mr!B3g\u0011\u0003Yg!B7g\u0011\u0003q\u0007\"B;\u0002\t\u00031\bbB<\u0002\u0005\u0004%\t\u0001\u001f\u0005\u0007y\u0006\u0001\u000b\u0011B=\u0007\t54\u0007! \u0005\u0006k\u0016!\tA \u0005\bo\u0016\u0011\r\u0011\"\u0001y\u0011\u0019aX\u0001)A\u0005s\"A\u0011\u0011A\u0003C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\u0004\u0015\u0001\u000b\u0011B=\t\u0013\u0005\u0015QA1A\u0005\u0002\u0005\u001d\u0001\u0002CA\u0010\u000b\u0001\u0006I!!\u0003\t\u0013\u0005\u0005RA1A\u0005\u0002\u0005\r\u0002\u0002CA\u001b\u000b\u0001\u0006I!!\n\t\u0017\u0005]R\u00011AA\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003\u0017*\u0001\u0019!a\u0001\n\u0003\ti\u0005C\u0006\u0002Z\u0015\u0001\r\u0011!Q!\n\u0005m\u0002bCA.\u000b\u0001\u0007\t\u0019!C\u0001\u0003sA1\"!\u0018\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002`!Y\u00111M\u0003A\u0002\u0003\u0005\u000b\u0015BA\u001e\u0011-\t)'\u0002a\u0001\u0002\u0004%\t!!\u000f\t\u0017\u0005\u001dT\u00011AA\u0002\u0013\u0005\u0011\u0011\u000e\u0005\f\u0003[*\u0001\u0019!A!B\u0013\tY\u0004C\u0006\u0002p\u0015\u0001\r\u00111A\u0005\u0002\u0005e\u0002bCA9\u000b\u0001\u0007\t\u0019!C\u0001\u0003gB1\"a\u001e\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002<!Y\u0011\u0011P\u0003A\u0002\u0003\u0007I\u0011AA>\u0011-\tI)\u0002a\u0001\u0002\u0004%\t!a#\t\u0017\u0005=U\u00011A\u0001B\u0003&\u0011Q\u0010\u0005\f\u0003#+\u0001\u0019!a\u0001\n\u0003\t\u0019\nC\u0006\u00026\u0016\u0001\r\u00111A\u0005\u0002\u0005]\u0006bCA^\u000b\u0001\u0007\t\u0011)Q\u0005\u0003+C1\"!0\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002@\"Y\u0011qY\u0003A\u0002\u0003\u0007I\u0011AAe\u0011-\ti-\u0002a\u0001\u0002\u0003\u0006K!!1\t\u0017\u0005=W\u00011AA\u0002\u0013\u0005\u0011\u0011\u001b\u0005\f\u0003K,\u0001\u0019!a\u0001\n\u0003\t9\u000fC\u0006\u0002l\u0016\u0001\r\u0011!Q!\n\u0005M\u0007bCAw\u000b\u0001\u0007\t\u0019!C\u0001\u0003_D1\"a@\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0002!Y!QA\u0003A\u0002\u0003\u0005\u000b\u0015BAy\u0011%\u00119!\u0002b\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u0012\u0015\u0001\u000b\u0011\u0002B\u0006\u0011%\u0011\u0019\"\u0002b\u0001\n\u0003\u0011)\u0002\u0003\u0005\u0003 \u0015\u0001\u000b\u0011\u0002B\f\u0011%\u0011\t#\u0002b\u0001\n\u0003\u0011\u0019\u0003\u0003\u0005\u00032\u0015\u0001\u000b\u0011\u0002B\u0013\u0011-\u0011\u0019$\u0002a\u0001\u0002\u0004%\tA!\u000e\t\u0017\tuR\u00011AA\u0002\u0013\u0005!q\b\u0005\f\u0005\u0007*\u0001\u0019!A!B\u0013\u00119\u0004C\u0005\u0003F\u0015\u0011\r\u0011\"\u0001\u0002\b!A!qI\u0003!\u0002\u0013\tI\u0001C\u0005\u0003J\u0015\u0011\r\u0011\"\u0001\u0003L!A!\u0011L\u0003!\u0002\u0013\u0011i\u0005C\u0006\u0003\\\u0015\u0001\r\u00111A\u0005\u0002\u0005m\u0004b\u0003B/\u000b\u0001\u0007\t\u0019!C\u0001\u0005?B1Ba\u0019\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002~!I!QM\u0003C\u0002\u0013\u0005!q\r\u0005\t\u0005_*\u0001\u0015!\u0003\u0003j!I!\u0011O\u0003C\u0002\u0013\u0005!1\u000f\u0005\t\u0005w*\u0001\u0015!\u0003\u0003v!I!QP\u0003C\u0002\u0013\u0005!q\u0010\u0005\t\u0005\u0017+\u0001\u0015!\u0003\u0003\u0002\"I!QR\u0003C\u0002\u0013\u0005!q\u0012\u0005\t\u0005;+\u0001\u0015!\u0003\u0003\u0012\"Y!qT\u0003A\u0002\u0003\u0007I\u0011AAi\u0011-\u0011\t+\u0002a\u0001\u0002\u0004%\tAa)\t\u0017\t\u001dV\u00011A\u0001B\u0003&\u00111\u001b\u0005\n\u0005S+!\u0019!C\u0001\u0005WC\u0001Ba-\u0006A\u0003%!Q\u0016\u0005\f\u0005k+\u0001\u0019!a\u0001\n\u0003\u00119\fC\u0006\u0003F\u0016\u0001\r\u00111A\u0005\u0002\t\u001d\u0007b\u0003Bf\u000b\u0001\u0007\t\u0011)Q\u0005\u0005sC\u0011B!4\u0006\u0005\u0004%\tAa4\t\u0011\tuW\u0001)A\u0005\u0005#D\u0011Ba8\u0006\u0005\u0004%\tA!9\t\u0011\t-X\u0001)A\u0005\u0005GDqA!<\u0006\t\u0003\u0011y\u000fC\u0004\u0004\b\u0015!\ta!\u0003\t\u0013\rMR!%A\u0005\u0002\rU\u0002\"CB&\u000bE\u0005I\u0011AB'\u0011%\u0019\t&BI\u0001\n\u0003\u0019\u0019\u0006C\u0004\u0004\u000e\u0015!\tba\u0016\t\u000f\reS\u0001\"\u0005\u00038\"911L\u0003\u0005\u0002\ru\u0003bBB@\u000b\u0011\u0005!q\u001e\u0005\b\u0007\u0013+A\u0011CBF\u0011\u001d\u0019Y*\u0002C\u0001\u0007;C\u0011b!7\u0006#\u0003%\taa7\t\u0013\r}W!%A\u0005\u0002\r\u0005\bbBBs\u000b\u0011E1q\u001d\u0005\n\t3)\u0011\u0013!C\t\u0007CD\u0011\u0002b\u0007\u0006#\u0003%\tba7\t\u0013\u0011uQ!%A\u0005\u0012\u0011}\u0001\"\u0003C\u0012\u000bE\u0005I\u0011\u0003C\u0010\u0011%!)#BI\u0001\n#\u0019\t\u000fC\u0005\u0005(\u0015\t\n\u0011\"\u0005\u0005*!IAQF\u0003\u0012\u0002\u0013EAq\u0006\u0005\n\tg)\u0011\u0013!C\t\u0007CDq\u0001\"\u000e\u0006\t\u0003!9$A\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005\u001dD\u0017aB2mkN$XM\u001d\u0006\u0002S\u0006)1.\u00194lC\u000e\u0001\u0001C\u00017\u0002\u001b\u00051'!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f^\n\u0003\u0003=\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001l\u0003!\u0011'o\\6fe&#W#A=\u0011\u0005AT\u0018BA>r\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\u001a\"!B8\u0015\u0003}\u0004\"\u0001\\\u0003\u0002\u001fI,Wn\u001c;f%\u0016\u0004H.[2b\u0013\u0012\f\u0001C]3n_R,'+\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\tY\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0019\u0019w.\\7p]*\u0019\u0011.a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007CB\f7\r[3\u000b\u0005\u0005e\u0011aA8sO&!\u0011QDA\u0007\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0005i&lW-\u0006\u0002\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001B;uS2TA!a\f\u0002\u0012\u000511/\u001a:wKJLA!a\r\u0002*\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0002j_*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\u0011\ty%!\u0016\u0011\u0007A\f\t&C\u0002\u0002TE\u0014A!\u00168ji\"I\u0011q\u000b\t\u0002\u0002\u0003\u0007\u00111H\u0001\u0004q\u0012\n\u0014a\u0002;na\u0012K'\u000fI\u0001\bY><G)\u001b:2\u0003-awn\u001a#jeFzF%Z9\u0015\t\u0005=\u0013\u0011\r\u0005\n\u0003/\u001a\u0012\u0011!a\u0001\u0003w\t\u0001\u0002\\8h\t&\u0014\u0018\u0007I\u0001\bY><G)\u001b:3\u0003-awn\u001a#jeJzF%Z9\u0015\t\u0005=\u00131\u000e\u0005\n\u0003/2\u0012\u0011!a\u0001\u0003w\t\u0001\u0002\\8h\t&\u0014(\u0007I\u0001\bY><G)\u001b:4\u0003-awn\u001a#jeNzF%Z9\u0015\t\u0005=\u0013Q\u000f\u0005\n\u0003/J\u0012\u0011!a\u0001\u0003w\t\u0001\u0002\\8h\t&\u00148\u0007I\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAABQ\u0006\u0019An\\4\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u001f\ni\tC\u0005\u0002Xq\t\t\u00111\u0001\u0002~\u0005YAn\\4NC:\fw-\u001a:!\u0003U\tG\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ,\"!!&\u0011\t\u0005]\u0015q\u0016\b\u0005\u00033\u000bIK\u0004\u0003\u0002\u001c\u0006\u0015f\u0002BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005&.\u0001\u0004=e>|GOP\u0005\u0002S&\u0019\u0011q\u00155\u0002\u000bU$\u0018\u000e\\:\n\t\u0005-\u0016QV\u0001\n)\u0016\u001cH/\u0016;jYNT1!a*i\u0013\u0011\t\t,a-\u000335{7m[!mi\u0016\u0014\b+\u0019:uSRLwN\\'b]\u0006<WM\u001d\u0006\u0005\u0003W\u000bi+A\rbYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:`I\u0015\fH\u0003BA(\u0003sC\u0011\"a\u0016 \u0003\u0003\u0005\r!!&\u0002-\u0005dG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4fe\u0002\na#\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]\u000b\u0003\u0003\u0003\u0004B!a&\u0002D&!\u0011QYAZ\u0005iiunY6BYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s\u0003i\tG\u000e^3s!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014x\fJ3r)\u0011\ty%a3\t\u0013\u0005]#%!AA\u0002\u0005\u0005\u0017aF1mi\u0016\u0014\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002TB!\u0011Q[Aq\u001b\t\t9N\u0003\u0003\u0002\u0004\u0006e'\u0002BAn\u0003;\f\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005}\u0017\u0011C\u0001\bgR|'/Y4f\u0013\u0011\t\u0019/a6\u0003\u00131{wmQ8oM&<\u0017!\u00047pO\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005%\b\"CA,K\u0005\u0005\t\u0019AAj\u0003)awnZ\"p]\u001aLw\rI\u0001\u0011G>tg-[4SKB|7/\u001b;pef,\"!!=\u0011\t\u0005M\u00181`\u0007\u0003\u0003kTA!a>\u0002z\u0006AQ.\u001a;bI\u0006$\u0018MC\u0002\u00020!LA!!@\u0002v\n!Rj\\2l\u0007>tg-[4SKB|7/\u001b;pef\fAcY8oM&<'+\u001a9pg&$xN]=`I\u0015\fH\u0003BA(\u0005\u0007A\u0011\"a\u0016)\u0003\u0003\u0005\r!!=\u0002#\r|gNZ5h%\u0016\u0004xn]5u_JL\b%A\teK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]N,\"Aa\u0003\u0011\u00071\u0014i!C\u0002\u0003\u0010\u0019\u0014\u0011\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8t\u0003I!W\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u001d\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\u00119\u0002\u0005\u0003\u0003\u001a\tmQBAA}\u0013\u0011\u0011i\"!?\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0011c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;t+\t\u0011)\u0003\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\u0011\u0011Y#!?\u0002\u0017\rDWmY6q_&tGo]\u0005\u0005\u0005_\u0011ICA\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiN\f!c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;tA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0005o\u00012\u0001\u001cB\u001d\u0013\r\u0011YD\u001a\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fH\u0003BA(\u0005\u0003B\u0011\"a\u00162\u0003\u0003\u0005\rAa\u000e\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u000buS\u0016\u0014X\r\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0016i&,'/\u001a3U_BL7\rU1si&$\u0018n\u001c8!\u0003Y!\u0018.\u001a:fIR{\u0007/[2JIB\u000b'\u000f^5uS>tWC\u0001B'!\u0011\u0011yE!\u0016\u000e\u0005\tE#b\u0001B*Q\u0006!A/[3s\u0013\u0011\u00119F!\u0015\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017a\u0006;jKJ,G\rV8qS\u000eLE\rU1si&$\u0018n\u001c8!\u0003U!\u0018.\u001a:F]\u0006\u0014G.\u001a3M_\u001el\u0015M\\1hKJ\f\u0011\u0004^5fe\u0016s\u0017M\u00197fI2{w-T1oC\u001e,'o\u0018\u0013fcR!\u0011q\nB1\u0011%\t9\u0006OA\u0001\u0002\u0004\ti(\u0001\fuS\u0016\u0014XI\\1cY\u0016$Gj\\4NC:\fw-\u001a:!\u0003I!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\t%\u0004\u0003\u0002B(\u0005WJAA!\u001c\u0003R\t\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003M!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:!\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0005k\u0002B!a \u0003x%!!\u0011PAA\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u0001\u0013i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\b%A\u0007dYV\u001cH/\u001a:MS:\\\u0017\nZ\u000b\u0003\u0005\u0003\u0003BAa!\u0003\b6\u0011!Q\u0011\u0006\u0005\u0003W\t\u0019%\u0003\u0003\u0003\n\n\u0015%\u0001B+V\u0013\u0012\u000bab\u00197vgR,'\u000fT5oW&#\u0007%\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\u0011\t\n\u0005\u0003\u0003\u0014\neUB\u0001BK\u0015\u0011\u00119J!\"\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003\u001c\nU%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013a\u0004;jKJ,G\rT8h\u0007>tg-[4\u0002'QLWM]3e\u0019><7i\u001c8gS\u001e|F%Z9\u0015\t\u0005=#Q\u0015\u0005\n\u0003/\u001a\u0015\u0011!a\u0001\u0003'\f\u0001\u0003^5fe\u0016$Gj\\4D_:4\u0017n\u001a\u0011\u0002\u000fQ|\u0007/[2JIV\u0011!Q\u0016\t\u0005\u0003\u0017\u0011y+\u0003\u0003\u00032\u00065!\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0017aV\u001c\bNU3qY&\u001c\u0017\r^5p]6\u000bg.Y4feV\u0011!\u0011\u0018\t\u0006a\nm&qX\u0005\u0004\u0005{\u000b(AB(qi&|g\u000e\u0005\u0003\u0002\u0018\n\u0005\u0017\u0002\u0002Bb\u0003g\u0013q\"T8dWB+8\u000f['b]\u0006<WM]\u0001\u001baV\u001c\bNU3qY&\u001c\u0017\r^5p]6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u001f\u0012I\rC\u0005\u0002X!\u000b\t\u00111\u0001\u0003:\u00069\u0002/^:i%\u0016\u0004H.[2bi&|g.T1oC\u001e,'\u000fI\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\"A!5\u0011\t\tM'\u0011\\\u0007\u0003\u0005+TAAa6\u0002\u000e\u00059a.\u001a;x_J\\\u0017\u0002\u0002Bn\u0005+\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0001$\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3!\u0003-\u0011X\r\u001d7jG\u0006tu\u000eZ3\u0016\u0005\t\r\b#\u00029\u0003<\n\u0015\b\u0003BA\u0006\u0005OLAA!;\u0002\u000e\t!aj\u001c3f\u00031\u0011X\r\u001d7jG\u0006tu\u000eZ3!\u0003\u0015\u0019X\r^;q)\t\ty\u0005K\u0002O\u0005g\u0004BA!>\u0004\u00045\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0A\u0002ba&TAA!@\u0003\u0000\u00069!.\u001e9ji\u0016\u0014(\u0002BB\u0001\u0003/\tQA[;oSRLAa!\u0002\u0003x\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002'5\f7.\u001a+jKJ,G\rU1si&$\u0018n\u001c8\u0015\u0011\t]21BB\r\u0007SA\u0011b!\u0004P!\u0003\u0005\raa\u0004\u00025%tG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\t\rE1QC\u0007\u0003\u0007'QA!a\u0004\u0002.%!1qCB\n\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0007\"CB\u000e\u001fB\u0005\t\u0019AB\u000f\u0003!Q8n\u00117jK:$\b\u0003BB\u0010\u0007Ki!a!\t\u000b\u0007\r\r\u0002.\u0001\u0002{W&!1qEB\u0011\u00055Y\u0015MZ6b5.\u001cE.[3oi\"I11F(\u0011\u0002\u0003\u00071QF\u0001\ng\u000eDW\rZ;mKJ\u0004B!a\n\u00040%!1\u0011GA\u0015\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\fQ$\\1lKRKWM]3e!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0007oQCaa\u0004\u0004:-\u001211\b\t\u0005\u0007{\u00199%\u0004\u0002\u0004@)!1\u0011IB\"\u0003%)hn\u00195fG.,GMC\u0002\u0004FE\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Iea\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fnC.,G+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019yE\u000b\u0003\u0004\u001e\re\u0012!H7bW\u0016$\u0016.\u001a:fIB\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rU#\u0006BB\u0017\u0007s)\"aa\u0004\u00029\r\u0014X-\u0019;f!V\u001c\bNU3qY&\u001c\u0017\r^5p]6\u000bg.Y4fe\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!1qLB3!\u0011\u0011\u0019i!\u0019\n\t\r\r$Q\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBB4+\u0002\u00071\u0011N\u0001\n_Z,'O]5eKN\u0004\u0002ba\u001b\u0004t\re4\u0011\u0010\b\u0005\u0007[\u001ay\u0007E\u0002\u0002\u001eFL1a!\u001dr\u0003\u0019\u0001&/\u001a3fM&!1QOB<\u0005\ri\u0015\r\u001d\u0006\u0004\u0007c\n\b\u0003BB6\u0007wJAa! \u0004x\t11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004-\u000e\r\u0005\u0003\u0002B{\u0007\u000bKAaa\"\u0003x\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$bAa\u000e\u0004\u000e\u000eE\u0005BBBH/\u0002\u0007\u00110A\u0006mK\u0006$WM]#q_\u000eD\u0007bBBJ/\u0002\u00071QS\u0001\tSNdU-\u00193feB\u0019\u0001oa&\n\u0007\re\u0015OA\u0004C_>dW-\u00198\u00025\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:\u0015\u0015\r}51VBd\u0007#\u001c)\u000e\u0005\u0003\u0004\"\u000e\u001dVBABR\u0015\u0011\u0019)+!\u0004\u0002\rI,7m\u001c:e\u0013\u0011\u0019Ika)\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0019i\u000b\u0017a\u0001\u0007_\u000bqA]3d_J$7\u000f\u0005\u0004\u00042\u000em6\u0011\u0019\b\u0005\u0007g\u001b9L\u0004\u0003\u0002\u001e\u000eU\u0016\"\u0001:\n\u0007\re\u0016/A\u0004qC\u000e\\\u0017mZ3\n\t\ru6q\u0018\u0002\t\u0013R,'/\u00192mK*\u00191\u0011X9\u0011\t\r\u000561Y\u0005\u0005\u0007\u000b\u001c\u0019K\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0004\u0004Jb\u0003\raa3\u0002\u0015\t\f7/Z(gMN,G\u000fE\u0002q\u0007\u001bL1aa4r\u0005\u0011auN\\4\t\u0011\rM\u0007\f%AA\u0002e\fABY1tKN+\u0017/^3oG\u0016D\u0011ba6Y!\u0003\u0005\raa3\u0002\u0015A\u0014x\u000eZ;dKJLE-\u0001\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fGNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iNK\u0002z\u0007s\tAe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007GTCaa3\u0004:\u0005ia-\u001a;dQ\u001a{G\u000e\\8xKJ$\u0002d!;\u0004p\u000eE8Q_B}\u0007{$\t\u0001\"\u0002\u0005\n\u00115Aq\u0002C\u000b!\u0011\t)na;\n\t\r5\u0018q\u001b\u0002\f\u0019><'+Z1e\u0013:4w\u000eC\u0004\u00034m\u0003\rAa\u000e\t\r\rM8\f1\u0001z\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0004\u0004xn\u0003\raa3\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\n\u0007w\\\u0006\u0013!a\u0001\u0007\u0017\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0003\u0005\u0004\u0000n\u0003\n\u00111\u0001z\u0003!i\u0017\r\u001f\"zi\u0016\u001c\b\"CBH7B\u0005\t\u0019\u0001C\u0002!\u0011\u0001(1X=\t\u0013\u0011\u001d1\f%AA\u0002\u0011\r\u0011\u0001\u00057bgR4U\r^2iK\u0012,\u0005o\\2i\u0011%!Ya\u0017I\u0001\u0002\u0004\u0019Y-A\u0006gKR\u001c\u0007\u000eV5nK6\u001b\b\"\u0003BU7B\u0005\t\u0019\u0001BW\u0011%!\tb\u0017I\u0001\u0002\u0004!\u0019\"\u0001\u0007sKBd\u0017nY1Fa>\u001c\u0007\u000eE\u0003q\u0005w\u001bY\rC\u0005\u0005\u0018m\u0003\n\u00111\u0001\u0004L\u0006!\"/\u001a9mS\u000e\fG/[8o'\u0016\u001c8/[8o\u0013\u0012\fqCZ3uG\"4u\u000e\u001c7po\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002/\u0019,Go\u00195G_2dwn^3sI\u0011,g-Y;mi\u0012*\u0014a\u00064fi\u000eDgi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!\tC\u000b\u0003\u0005\u0004\re\u0012a\u00064fi\u000eDgi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003]1W\r^2i\r>dGn\\<fe\u0012\"WMZ1vYR$\u0003(A\fgKR\u001c\u0007NR8mY><XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011A1\u0006\u0016\u0005\u0005[\u001bI$\u0001\rgKR\u001c\u0007NR8mY><XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"\u0001\"\r+\t\u0011M1\u0011H\u0001\u0019M\u0016$8\r\u001b$pY2|w/\u001a:%I\u00164\u0017-\u001e7uIE\n\u0014A\u00053fM\u0006,H\u000e\u001e\"s_.,'/\u00129pG\"$Baa3\u0005:!)q\u000f\u001aa\u0001s\u0002")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private File logDir3;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;
    private final TopicPartition tieredTopicPartition = new TopicPartition("tiered-test-topic", 0);
    private final TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("tiered-test-topic", UUID.randomUUID(), 0);
    private LogManager tierEnabledLogManager;
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final UUID clusterLinkId = UUID.randomUUID();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private LogConfig tieredLogConfig;
    private final Uuid topicId = Uuid.randomUuid();
    private Option<TestUtils.MockPushManager> pushReplicationManager;
    private final ListenerName interBrokerListenerName = (ListenerName)Mockito.mock(ListenerName.class);
    private final Option<Node> replicaNode = Option$.MODULE$.apply((Object)new Node(this.remoteReplicaId(), "", 8080));

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public File logDir3() {
        return this.logDir3;
    }

    public void logDir3_$eq(File x$1) {
        this.logDir3 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition tieredTopicPartition() {
        return this.tieredTopicPartition;
    }

    public TopicIdPartition tieredTopicIdPartition() {
        return this.tieredTopicIdPartition;
    }

    public LogManager tierEnabledLogManager() {
        return this.tierEnabledLogManager;
    }

    public void tierEnabledLogManager_$eq(LogManager x$1) {
        this.tierEnabledLogManager = x$1;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public UUID clusterLinkId() {
        return this.clusterLinkId;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public LogConfig tieredLogConfig() {
        return this.tieredLogConfig;
    }

    public void tieredLogConfig_$eq(LogConfig x$1) {
        this.tieredLogConfig = x$1;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Option<TestUtils.MockPushManager> pushReplicationManager() {
        return this.pushReplicationManager;
    }

    public void pushReplicationManager_$eq(Option<TestUtils.MockPushManager> x$1) {
        this.pushReplicationManager = x$1;
    }

    public ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    public Option<Node> replicaNode() {
        return this.replicaNode;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka"));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka"));
        .colon.colon x$1 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$2 = this.logConfig();
        MockConfigRepository x$3 = this.configRepository();
        CleanerConfig x$4 = new CleanerConfig(false);
        MockTime x$5 = this.time();
        MetadataVersion x$6 = this.interBrokerProtocolVersion();
        Metrics x$8 = new Metrics();
        boolean x$10 = false;
        TierLogComponents x$11 = TierLogComponents$.MODULE$.EMPTY();
        int x$12 = 4;
        None$ x$13 = None$.MODULE$;
        Optional<E2EChecksumStore> x$14 = TestUtils$.MODULE$.createLogManager$default$14();
        boolean x$15 = false;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$1, x$2, x$3, x$4, x$5, x$8, null, x$6, x$10, x$11, x$12, true, (Option<MergedLog>)x$13, x$14, x$15));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$16 = Predef$.MODULE$.Set().empty();
        Function1 x$17 = qual$1.startup$default$2();
        qual$1.startup((Set)x$16, x$17);
        this.alterPartitionManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.alterPartitionListener_$eq(new TestUtils.MockAlterPartitionListener());
        this.pushReplicationManager_$eq(this.createPushReplicationManager());
        TopicPartition x$18 = this.topicPartition();
        long x$19 = Defaults$.MODULE$.ReplicaLagTimeMaxMs();
        MetadataVersion x$20 = this.interBrokerProtocolVersion();
        int x$21 = this.brokerId();
        JFunction0.mcJ.sp & Serializable x$22 = (JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId());
        MockTime x$23 = this.time();
        TestUtils.MockAlterPartitionListener x$24 = this.alterPartitionListener();
        DelayedOperations x$25 = this.delayedOperations();
        MetadataCache x$26 = this.metadataCache();
        LogManager x$27 = this.logManager();
        Some x$28 = new Some((Object)this.tierReplicaManager());
        None$ x$29 = None$.MODULE$;
        TestUtils.MockAlterPartitionManager x$30 = this.alterPartitionManager();
        None$ x$31 = None$.MODULE$;
        Option<TestUtils.MockPushManager> x$32 = this.pushReplicationManager();
        ListenerName x$33 = this.interBrokerListenerName();
        None$ x$34 = None$.MODULE$;
        boolean x$35 = false;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        this.partition_$eq(new Partition(x$18, x$19, x$20, x$33, x$21, (Function0)x$22, (Time)x$23, (AlterPartitionListener)x$24, x$25, x$26, x$27, (Option)x$28, (Option)x$29, (Option)x$34, (AlterPartitionManager)x$30, (Option)x$31, x$35, (Option)x$36, x$32, (Option)x$37));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Properties tieredLogProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.enable"), (Object)"true")}))));
        this.tieredLogConfig_$eq(new LogConfig((Map)tieredLogProps));
        this.logDir3_$eq(TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka"));
        .colon.colon x$38 = new .colon.colon((Object)this.logDir3(), (List)Nil$.MODULE$);
        LogConfig x$39 = this.tieredLogConfig();
        MockConfigRepository x$40 = this.configRepository();
        CleanerConfig x$41 = new CleanerConfig(false);
        MockTime x$42 = this.time();
        TierLogComponents x$43 = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, new TierPartitionStateFactory(true, false, true, TierPartitionStateCleanupConfig.EMPTY, false, -1), (Option)None$.MODULE$);
        Metrics x$44 = new Metrics();
        MetadataVersion x$46 = MetadataVersion.latestTesting();
        boolean x$47 = false;
        int x$48 = 4;
        boolean x$49 = false;
        None$ x$50 = None$.MODULE$;
        Optional<E2EChecksumStore> x$51 = TestUtils$.MODULE$.createLogManager$default$14();
        boolean x$52 = false;
        this.tierEnabledLogManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$38, x$39, x$40, x$41, x$42, x$44, null, x$46, x$47, x$43, x$48, x$49, (Option<MergedLog>)x$50, x$51, x$52));
        LogManager qual$2 = this.tierEnabledLogManager();
        scala.collection.immutable.Set x$53 = Predef$.MODULE$.Set().empty();
        Function1 x$54 = qual$2.startup$default$2();
        qual$2.startup((Set)x$53, x$54);
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.tieredTopicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getBrokerTags(ArgumentMatchers.anyInt())).thenReturn((Object)Predef$.MODULE$.Map().empty());
    }

    public Partition makeTieredPartition(MetadataVersion interBrokerProtocolVersion, KafkaZkClient zkClient, KafkaScheduler scheduler) {
        TestUtils.MockAlterPartitionManager partitionManager;
        if (interBrokerProtocolVersion.isAtLeast(MetadataVersion.IBP_2_7_IV0)) {
            partitionManager = this.alterPartitionManager();
        } else {
            Predef$.MODULE$.assert(zkClient != null && scheduler != null);
            MockTime apply_time = this.time();
            Object var5_5 = null;
            partitionManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)apply_time, zkClient);
        }
        return new Partition(this.tieredTopicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), interBrokerProtocolVersion, this.interBrokerListenerName(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.tierEnabledLogManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)new Some((Object)this.executor()), (AlterPartitionManager)partitionManager, (Option)None$.MODULE$, false, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
    }

    public MetadataVersion makeTieredPartition$default$1() {
        return MetadataVersion.latestTesting();
    }

    public KafkaZkClient makeTieredPartition$default$2() {
        return null;
    }

    public KafkaScheduler makeTieredPartition$default$3() {
        return null;
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latestTesting();
    }

    public Option<TestUtils.MockPushManager> createPushReplicationManager() {
        return None$.MODULE$;
    }

    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            LogManager qual$1 = this.logManager();
            long x$1 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$1);
            Utils.delete((File)this.tmpDir(), (boolean)false);
            TestUtils$.MODULE$.clearYammerMetrics();
        }
        this.executor().shutdownNow();
        this.executor().awaitTermination(30L, TimeUnit.SECONDS);
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        Partition qual$1 = this.partition();
        OffsetCheckpoints x$3 = this.offsetCheckpoints();
        None$ x$4 = None$.MODULE$;
        Option x$5 = qual$1.createLogIfNotExists$default$5();
        qual$1.createLogIfNotExists(false, false, x$3, (Option)x$4, x$5);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Partition qual$2 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$6 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$7 = this.offsetCheckpoints();
            Some x$8 = new Some((Object)this.topicId());
            Option x$9 = qual$2.makeLeader$default$4();
            Assertions.assertTrue((boolean)qual$2.makeLeader(x$6, x$7, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Partition qual$3 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$10 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$11 = this.offsetCheckpoints();
            Some x$12 = new Some((Object)this.topicId());
            Option x$13 = qual$3.makeFollower$default$4();
            Assertions.assertTrue((boolean)qual$3.makeFollower(x$10, x$11, (Option)x$12, x$13), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset, int baseSequence, long producerId) {
        void builder_partitionLeaderEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        short producerEpoch = (short)0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        CompressionType builder_compressionType = CompressionType.NONE;
        int n = -1;
        long l = -1L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        byte builder_magic = 2;
        timestampType = null;
        Object var11_8 = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    public long createTransactionalRecords$default$4() {
        return 1L;
    }

    public LogReadInfo fetchFollower(Partition partition, int replicaId, long fetchOffset, long logStartOffset, int maxBytes, Option<Object> leaderEpoch, Option<Object> lastFetchedEpoch, long fetchTimeMs, Uuid topicId, Option<Object> replicaEpoch, long replicationSessionId) {
        long x$3 = !replicaEpoch.isDefined() ? this.defaultBrokerEpoch(replicaId) : BoxesRunTime.unboxToLong((Object)replicaEpoch.get());
        long x$4 = 0L;
        int x$5 = 1;
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(replicaId, x$3, x$4, x$5, maxBytes);
        FullPartitionFetchMetadata fetchPartitionData = new FullPartitionFetchMetadata(topicId, fetchOffset, logStartOffset, maxBytes, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpoch.map((Function1 & Serializable)x -> AbstractPartitionTest.$anonfun$fetchFollower$1(BoxesRunTime.unboxToInt((Object)x))))), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(lastFetchedEpoch.map((Function1 & Serializable)x -> AbstractPartitionTest.$anonfun$fetchFollower$2(BoxesRunTime.unboxToInt((Object)x))))), replicationSessionId);
        return partition.fetchRecords(fetchParams, (PartitionFetchMetadata)fetchPartitionData, fetchTimeMs, maxBytes, true, true);
    }

    public long fetchFollower$default$4() {
        return 0L;
    }

    public int fetchFollower$default$5() {
        return Integer.MAX_VALUE;
    }

    public Option<Object> fetchFollower$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> fetchFollower$default$7() {
        return None$.MODULE$;
    }

    public long fetchFollower$default$8() {
        return this.time().milliseconds();
    }

    public Uuid fetchFollower$default$9() {
        return Uuid.ZERO_UUID;
    }

    public Option<Object> fetchFollower$default$10() {
        return Option$.MODULE$.empty();
    }

    public long fetchFollower$default$11() {
        return -1L;
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }

    public static final /* synthetic */ Integer $anonfun$fetchFollower$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$fetchFollower$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

