/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.ObserverPartitionTest$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u0012%\u0005%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004D\u0001\u0001\u0006IA\u000e\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"I!\n\u0001a\u0001\u0002\u0004%\ta\u0013\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002MC\u0011\"\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0003Y\u0006\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0001f\u0011%9\u0007\u00011A\u0001B\u0003&A\fC\u0005i\u0001\u0001\u0007\t\u0019!C\u0001S\"IQ\u000e\u0001a\u0001\u0002\u0004%\tA\u001c\u0005\na\u0002\u0001\r\u0011!Q!\n)Dq!\u001d\u0001C\u0002\u0013\u0005!\u000f\u0003\u0004w\u0001\u0001\u0006Ia\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0001y\u0011\u0019q\b\u0001)A\u0005s\"Aq\u0010\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0002\u0011%\t\t\u0002\u0001b\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0011\u0011%\t\u0019\u0004\u0001b\u0001\n\u0003\t)\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001c\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!a\u0017\u0001\t\u0003\t\u0019\u0005C\u0004\u0002f\u0001!\t!a\u0011\b\u000f\u0005=D\u0005#\u0001\u0002r\u001911\u0005\nE\u0001\u0003gBa\u0001M\u0010\u0005\u0002\u0005U\u0004bBA<?\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u0017{B\u0011AAG\u0005Uy%m]3sm\u0016\u0014\b+\u0019:uSRLwN\u001c+fgRT!!\n\u0014\u0002\u000f\rdWo\u001d;fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005!A/[7f+\u00051\u0004CA\u001cB\u001b\u0005A$BA\u001d;\u0003\u0011)H/\u001b7\u000b\u0005mb\u0014AB:feZ,'O\u0003\u0002({)\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011\u0005H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003!\u0011'o\\6fe&#W#\u0001$\u0011\u0005-:\u0015B\u0001%-\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005a\u0005CA'Q\u001b\u0005q%BA('\u0003\rawnZ\u0005\u0003#:\u0013!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$\"\u0001V,\u0011\u0005-*\u0016B\u0001,-\u0005\u0011)f.\u001b;\t\u000fa;\u0011\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0005%|'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\u0005Q3\u0007b\u0002-\u000b\u0003\u0003\u0005\r\u0001X\u0001\bi6\u0004H)\u001b:!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001k!\t\u00194.\u0003\u0002mI\tI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0005Q{\u0007b\u0002-\u000e\u0003\u0003\u0005\rA[\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013a\u00043fY\u0006Lx\n]3sCRLwN\\:\u0016\u0003M\u0004\"a\r;\n\u0005U$#!\u0005#fY\u0006LX\rZ(qKJ\fG/[8og\u0006\u0001B-\u001a7bs>\u0003XM]1uS>t7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003e\u0004\"A\u001f?\u000e\u0003mT!a\u000f\u0014\n\u0005u\\(!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002#=4gm]3u\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nm\f1b\u00195fG.\u0004x.\u001b8ug&!\u0011QBA\u0004\u0005EyeMZ:fi\u000eCWmY6q_&tGo]\u0001\u0013_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\b%\u0001\fbYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s+\t\t)\u0002E\u00024\u0003/I1!!\u0007%\u0005Y\tE\u000e^3s!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014\u0018aF1mi\u0016\u0014\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:!\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012a\u00028fi^|'o\u001b\u0006\u0004\u0003Wa\u0014AB2p[6|g.\u0003\u0003\u00020\u0005\u0015\"\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001G5oi\u0016\u0014(I]8lKJd\u0015n\u001d;f]\u0016\u0014h*Y7fA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u001c!\u0011\tI$a\u000f\u000e\u0005\u0005%\u0012\u0002BA\u001f\u0003S\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0015\u0019X\r^;q)\u0005!\u0006fA\u000e\u0002HA!\u0011\u0011JA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013aA1qS*!\u0011\u0011KA*\u0003\u001dQW\u000f]5uKJT1!!\u0016@\u0003\u0015QWO\\5u\u0013\u0011\tI&a\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ra\u0012q\f\t\u0005\u0003\u0013\n\t'\u0003\u0003\u0002d\u0005-#!C!gi\u0016\u0014X)Y2i\u00039\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o[%oGJ,\u0017m]3t/&$\bn\\;u\u001f\n\u001cXM\u001d<fe\u001a+Go\u00195)\u0007u\tI\u0007\u0005\u0003\u0002J\u0005-\u0014\u0002BA7\u0003\u0017\u0012A\u0001V3ti\u0006)rJY:feZ,'\u000fU1si&$\u0018n\u001c8UKN$\bCA\u001a '\ty\"\u0006\u0006\u0002\u0002r\u0005Y1/Z3e\u0019><G)\u0019;b)\u001d!\u00161PAB\u0003\u000fCaaT\u0011A\u0002\u0005u\u0004cA'\u0002\u0000%\u0019\u0011\u0011\u0011(\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\u0007\u0003\u000b\u000b\u0003\u0019\u0001$\u0002\u00159,XNU3d_J$7\u000f\u0003\u0004\u0002\n\u0006\u0002\rAR\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002\u0010\u0006e\u0005\u0003BAI\u0003+k!!a%\u000b\u0005e\u0002\u0017\u0002BAL\u0003'\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tYJ\ta\u0001\u0003;\u000b\u0011b\u001c<feJLG-Z:\u0011\u0011\u0005}\u0015QVAZ\u0003gsA!!)\u0002*B\u0019\u00111\u0015\u0017\u000e\u0005\u0005\u0015&bAATQ\u00051AH]8pizJ1!a+-\u0003\u0019\u0001&/\u001a3fM&!\u0011qVAY\u0005\ri\u0015\r\u001d\u0006\u0004\u0003Wc\u0003\u0003BAP\u0003kKA!a.\u00022\n11\u000b\u001e:j]\u001e\u0004")
public final class ObserverPartitionTest {
    private final MockTime time = new MockTime();
    private final int brokerId;
    private LogManager logManager;
    private File tmpDir;
    private Partition partition;
    private final DelayedOperations delayOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private final AlterPartitionListener alterPartitionListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
    private final ListenerName interBrokerListenerName = (ListenerName)Mockito.mock(ListenerName.class);
    private final TopicPartition topicPartition = new TopicPartition("test-observer", 0);

    public static Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        return ObserverPartitionTest$.MODULE$.createLogProperties(overrides);
    }

    public static void seedLogData(AbstractLog log, int numRecords, int leaderEpoch) {
        ObserverPartitionTest$.MODULE$.seedLogData(log, numRecords, leaderEpoch);
    }

    public MockTime time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public DelayedOperations delayOperations() {
        return this.delayOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public AlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setup() {
        void randomPartitionLogDir_parentDir;
        Properties logProperties = ObserverPartitionTest$.MODULE$.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "replica"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "observer"))))}))));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        File file = this.tmpDir();
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var7_3 = null;
        file = null;
        File logDir1 = randomPartitionLogDir_this.randomPartitionForTopicLogDir((File)randomPartitionLogDir_parentDir, "kafka");
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProperties);
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)Nil$.MODULE$), new LogConfig((Map)logProperties), configRepository, new CleanerConfig(false), this.time(), new Metrics(), null, MetadataVersion.latestTesting(), false, TierLogComponents$.MODULE$.EMPTY(), 4, false, (Option<MergedLog>)None$.MODULE$, TestUtils$.MODULE$.createLogManager$default$14(), false));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
        Function1 x$2 = qual$1.startup$default$2();
        qual$1.startup((Set)x$1, x$2);
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latestTesting(), this.interBrokerListenerName(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Time)this.time(), this.alterPartitionListener(), this.delayOperations(), this.metadataCache(), this.logManager(), (Option)new Some(Mockito.mock(TierReplicaManager.class)), (Option)new Some(Mockito.mock(TierStateFetcher.class)), (Option)None$.MODULE$, (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class), (Option)None$.MODULE$, false, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getBrokerTags(ArgumentMatchers.anyInt())).thenReturn((Object)Predef$.MODULE$.Map().empty());
    }

    @AfterEach
    public void tearDown() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void testHighWatermarkIncreasesWithoutObserverFetch() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int followerId = this.brokerId() + 1;
        int observerId = followerId + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)Nil$.MODULE$))).asJava();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        ObserverPartitionTest$.MODULE$.seedLogData(log, 6, 4);
        Partition qual$2 = this.partition();
        OffsetCheckpoints x$8 = this.offsetCheckpoints();
        None$ x$9 = None$.MODULE$;
        Option x$10 = qual$2.createLogIfNotExists$default$5();
        qual$2.createLogIfNotExists(false, false, x$8, (Option)x$9, x$10);
        Partition qual$3 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$11 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topicPartition().topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setPartitionEpoch(1).setReplicas(replicas).setObservers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)).asJava()).setIsNew(true);
        OffsetCheckpoints x$12 = this.offsetCheckpoints();
        None$ x$13 = None$.MODULE$;
        Option x$14 = qual$3.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$3.makeLeader(x$11, x$12, (Option)x$13, x$14), (String)"Expected become leader transition to succeed");
        this.partition().updateFollowerFetchState((Replica)this.partition().getReplica(observerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(58).append("Failed to find replica state for observer ").append(observerId).append(" from partition ").append(this.partition()).toString())), new LogOffsetMetadata(3L), 0L, this.time().milliseconds(), 3L, 1L, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), -1L);
        this.partition().updateFollowerFetchState((Replica)this.partition().getReplica(followerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(58).append("Failed to find replica state for follower ").append(followerId).append(" from partition ").append(this.partition()).toString())), new LogOffsetMetadata(5L), 0L, this.time().milliseconds(), 5L, 1L, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), -1L);
        Assertions.assertEquals((long)this.partition().localLogOrException().highWatermark(), (long)5L, (String)"Expect the high watermark to only include followers");
    }

    public ObserverPartitionTest() {
        this.brokerId = 101;
    }
}

