/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogTestUtils;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.MetadataCache;
import kafka.server.PartitionFetchMetadata;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.TierFetchDataInfo;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetTieredException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u00181\u0001UBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001H\u0011\u0019i\u0005\u0001)A\u0005\u0011\"9a\n\u0001b\u0001\n\u00039\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011A)\t\r}\u0003\u0001\u0015!\u0003S\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005DaA\u001b\u0001!\u0002\u0013\u0011\u0007bB6\u0001\u0005\u0004%\t!\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u00022\t\u000f5\u0004!\u0019!C\u0001]\"1a\u000f\u0001Q\u0001\n=Dqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0001y\u0011\u0019q\b\u0001)A\u0005s\"Aq\u0010\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0002\u0011%\t\t\u0002\u0001b\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u000b\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%\t!!\n\t\u0017\u00055\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0006\u0005\f\u0003w\u0001\u0001\u0019!A!B\u0013\t9\u0003C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0002bCA$\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013B1\"!\u0014\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002B!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002T!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA>\u0001\u0011\u0005\u00111\r\u0005\b\u0003\u000b\u0003A\u0011AA2\u0011\u001d\ty\t\u0001C\u0001\u0003GBq!a%\u0001\t\u0003\t\u0019\u0007C\u0004\u0002&\u0002!\t!a\u0019\t\u000f\u0005%\u0006\u0001\"\u0003\u0002d!9\u00111\u0016\u0001\u0005\n\u0005\r\u0004bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqAa\n\u0001\t\u0013\u0011I\u0003C\u0004\u0003.\u0001!IAa\f\t\u000f\tM\u0003\u0001\"\u0003\u0003V!9!1\f\u0001\u0005\n\tu#!\u0005)beRLG/[8o\u0019>\u001c7\u000eV3ti*\u0011\u0011GM\u0001\bG2,8\u000f^3s\u0015\u0005\u0019\u0014!B6bM.\f7\u0001A\n\u0004\u0001Yb\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g\r\u0005\u0002>\u00016\taH\u0003\u0002@e\u0005)Q\u000f^5mg&\u0011\u0011I\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\t\u0005\u0002F\u00015\t\u0001'\u0001\nok6\u0014V\r\u001d7jG\u00064U\r^2iKJ\u001cX#\u0001%\u0011\u0005]J\u0015B\u0001&9\u0005\rIe\u000e^\u0001\u0014]Vl'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u00148\u000fI\u0001\r]Vl\u0007K]8ek\u000e,'o]\u0001\u000e]Vl\u0007K]8ek\u000e,'o\u001d\u0011\u0002+9,XNU3d_J$7\u000fU3s!J|G-^2fe\u00061b.^7SK\u000e|'\u000fZ:QKJ\u0004&o\u001c3vG\u0016\u0014\b%\u0001\u0005n_\u000e\\G+[7f+\u0005\u0011\u0006CA*^\u001b\u0005!&BA+W\u0003\u0011)H/\u001b7\u000b\u0005]C\u0016AB:feZ,'O\u0003\u000243*\u0011!lW\u0001\u0007CB\f7\r[3\u000b\u0003q\u000b1a\u001c:h\u0013\tqFK\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u0010Kb,7-\u001e;peN+'O^5dKV\tq\u000e\u0005\u0002qi6\t\u0011O\u0003\u0002sg\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U3\u0017BA;r\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001E3yK\u000e,Ho\u001c:TKJ4\u0018nY3!\u0003=\t\u0007\u000f]3oIN+W.\u00199i_J,W#A=\u0011\u0005AT\u0018BA>r\u0005%\u0019V-\\1qQ>\u0014X-\u0001\tbaB,g\u000eZ*f[\u0006\u0004\bn\u001c:fA\u0005\u00112\u000f\u001b:j].L5O]*f[\u0006\u0004\bn\u001c:f\u0003M\u0019\bN]5oW&\u001b(oU3nCBDwN]3!\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0011\u0014a\u00017pO&!\u0011QBA\u0004\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u0001\u0013i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\b%\u0001\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000ee\u0005!A/[3s\u0013\u0011\ty\"!\u0007\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u0014!\u0011\t)!!\u000b\n\t\u0005-\u0012q\u0001\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u00028\u0003gI1!!\u000e9\u0005\u0011)f.\u001b;\t\u0013\u0005e\u0012$!AA\u0002\u0005\u001d\u0012a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002BA\u0019Q)a\u0011\n\u0007\u0005\u0015\u0003GA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!!\r\u0002L!I\u0011\u0011\b\u000f\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033B\u0016AB2p[6|g.\u0003\u0003\u0002^\u0005]#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005)1/\u001a;VaR\u0011\u0011\u0011\u0007\u0015\u0004A\u0005\u001d\u0004\u0003BA5\u0003oj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0004CBL'\u0002BA9\u0003g\nqA[;qSR,'OC\u0002\u0002vm\u000bQA[;oSRLA!!\u001f\u0002l\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!IA@!\u0011\tI'!!\n\t\u0005\r\u00151\u000e\u0002\n\u0003\u001a$XM]#bG\"\fA\u0005^3ti:{Gj\\2l\u0007>tG/\u001a8uS>tw+\u001b;i_V$\u0018j\u001d:Va\u0012\fG/\u001a\u0015\u0004E\u0005%\u0005\u0003BA5\u0003\u0017KA!!$\u0002l\t!A+Z:u\u0003Q\"Xm\u001d;BaB,g\u000e\u001a*fa2L7-\u0019$fi\u000eDw+\u001b;i'\u000eDW\rZ;mKJ\u001c\u0005.Z2l\r>\u00148\u000b\u001b:j].L5O\u001d\u0015\u0004G\u0005%\u0015a\t;fgR\f\u0005\u000f]3oIJ+\u0007\u000f\\5dC\u001a+Go\u00195XSRDW\u000b\u001d3bi\u0016L5O\u001d\u0015\u0004I\u0005%\u0005f\u0002\u0013\u0002\u001a\u0006}\u0015\u0011\u0015\t\u0005\u0003S\nY*\u0003\u0003\u0002\u001e\u0006-$\u0001\u0003#jg\u0006\u0014G.\u001a3\u0002\u000bY\fG.^3\"\u0005\u0005\r\u0016aC&F\u001d\u001eKe*R\u00172sI\n\u0001\u0006^3ti\u001e+GOU3qY&\u001c\u0017mV5uQV\u0003H-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3JgJD3!JAE\u0003\u0019\u001awN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a$fi\u000eDw+\u001b;i%\u0016\fG\rT8dW>sG._\u0001$G>t7-\u001e:sK:$\bK]8ek\u000e,g)\u001a;dQ^KG\u000f[,sSR,Gj\\2l\u0003=\u00198\r[3ek2,\u0017\t\u001d9f]\u0012\u001cHCAAY!\u0019\t\u0019,a1\u0002J:!\u0011QWA`\u001d\u0011\t9,!0\u000e\u0005\u0005e&bAA^i\u00051AH]8pizJ\u0011!O\u0005\u0004\u0003\u0003D\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9MA\u0002TKFT1!!19a\u0011\tY-!6\u0011\u000bA\fi-!5\n\u0007\u0005=\u0017O\u0001\u0004GkR,(/\u001a\t\u0005\u0003'\f)\u000e\u0004\u0001\u0005\u0017\u0005]\u0007&!A\u0001\u0002\u000b\u0005\u0011\u0011\u001c\u0002\u0004?\u0012\n\u0014\u0003BAn\u0003C\u00042aNAo\u0013\r\ty\u000e\u000f\u0002\b\u001d>$\b.\u001b8h!\r9\u00141]\u0005\u0004\u0003KD$aA!os\u000692o\u00195fIVdWMR8mY><XM\u001d$fi\u000eDWm\u001d\u000b\u0007\u0003W\f90a?\u0011\r\u0005M\u00161YAwa\u0011\ty/a=\u0011\u000bA\fi-!=\u0011\t\u0005M\u00171\u001f\u0003\f\u0003kL\u0013\u0011!A\u0001\u0006\u0003\tINA\u0002`IIBa!!?*\u0001\u0004A\u0015a\u00037fC\u0012,'/\u00129pG\"Da!!@*\u0001\u0004A\u0015A\u00038v[J+7m\u001c:eg\u0006\t2o\u00195fIVdWm\u00155sS:\\\u0017j\u001d:\u0015\r\t\r!Q\u0002B\u000fa\u0011\u0011)A!\u0003\u0011\u000bA\fiMa\u0002\u0011\t\u0005M'\u0011\u0002\u0003\f\u0005\u0017Q\u0013\u0011!A\u0001\u0006\u0003\tINA\u0002`IMBqAa\u0004+\u0001\u0004\u0011\t\"\u0001\u0006bGRLg/\u001a$mC\u001e\u0004BAa\u0005\u0003\u001a5\u0011!Q\u0003\u0006\u0004\u0005/\t\u0018AB1u_6L7-\u0003\u0003\u0003\u001c\tU!!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u0003 )\u0002\rA!\t\u0002\u001f5|7m\u001b+j[\u0016\u001cF.Z3q\u001bN\u00042a\u000eB\u0012\u0013\r\u0011)\u0003\u000f\u0002\u0005\u0019>tw-A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgR!\u0011\u0011\tB\u0016\u0011\u001d\t\u0019c\u000ba\u0001\u0003O\t1c\u0019:fCR,Gj\\4Qe>\u0004XM\u001d;jKN$BA!\r\u0003:A!!1\u0007B\u001b\u001b\u0005\u0019\u0018b\u0001B\u001cg\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\tmB\u00061\u0001\u0003>\u0005IqN^3se&$Wm\u001d\t\t\u0005\u007f\u00119E!\u0014\u0003N9!!\u0011\tB\"!\r\t9\fO\u0005\u0004\u0005\u000bB\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003J\t-#aA'ba*\u0019!Q\t\u001d\u0011\t\t}\"qJ\u0005\u0005\u0005#\u0012YE\u0001\u0004TiJLgnZ\u0001\u0007CB\u0004XM\u001c3\u0015\r\u0005E\"q\u000bB-\u0011\u001d\ti$\fa\u0001\u0003\u0003Ba!!@.\u0001\u0004A\u0015!\u00044fi\u000eDgi\u001c7m_^,'\u000f\u0006\u0006\u00022\t}#\u0011\rB3\u0005OBq!!\u0010/\u0001\u0004\t\t\u0005\u0003\u0004\u0003d9\u0002\r\u0001S\u0001\u000bM>dGn\\<fe&#\u0007BBA}]\u0001\u0007\u0001\n\u0003\u0004\u0002~:\u0002\r\u0001\u0013")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka");
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(false), this.mockTime(), new Metrics(), null, MetadataVersion.latestTesting(), false, TierLogComponents$.MODULE$.EMPTY(), 4, false, (Option<MergedLog>)None$.MODULE$, TestUtils$.MODULE$.createLogManager$default$14(), false));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled(value="KENGINE-192")
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = PartitionLockTest.partitionState$1(secondReplicaSet);
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        qual$1.makeLeader(x$1, offsetCheckpoints, (Option)x$3, x$4);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                Partition qual$2 = this.partition();
                LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$5 = PartitionLockTest.partitionState$1(replicas);
                None$ x$7 = None$.MODULE$;
                Option x$8 = qual$2.makeLeader$default$4();
                qual$2.makeLeader(x$5, offsetCheckpoints, (Option)x$7, x$8);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$10 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$10)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener alterPartitionListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        ListenerName interBrokerListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty(), logManager.startup$default$2());
        Partition partition = new Partition(this, interBrokerListenerName, brokerId, alterPartitionListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public AbstractLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId, Option<Uuid> targetLogDirectoryId) {
                AbstractLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, topicId, (Option)None$.MODULE$);
                return new LogTestUtils.SlowAppendAsLeaderLog((MergedLog)log, this.$outer.tierLogComponents(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latestTesting(), interBrokerListenerName$1, brokerId$1, (Function0)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final long apply() {
                        return 1L;
                    }

                    public final long apply$mcJ$sp() {
                        return 1L;
                    }
                }, (Time)$outer.mockTime(), alterPartitionListener$1, delayedOperations$1, metadataCache$1, logManager$1, (Option)new Some((Object)$outer.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, alterIsrManager$1, (Option)None$.MODULE$, false, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)partition.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.kafka$cluster$PartitionLockTest$$topicPartition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn(new CompletableFuture());
        Mockito.when((Object)metadataCache.getBrokerTags(ArgumentMatchers.anyInt())).thenReturn((Object)Predef$.MODULE$.Map().empty());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$, partition.createLogIfNotExists$default$5());
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$2(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$, partition.makeLeader$default$4()), (String)"Expected become leader transition to succeed");
        return partition;
    }

    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), followerId, 1L, 0L, 1, maxBytes, FetchIsolation.LOG_END, Optional.empty());
            FullPartitionFetchMetadata fetchPartitionData = new FullPartitionFetchMetadata(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch, -1L);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, (PartitionFetchMetadata)fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((!logReadInfo.divergingEpoch.isPresent() ? 1 : 0) != 0);
            AbstractFetchDataInfo abstractFetchDataInfo = logReadInfo.fetchedData;
            if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                if (abstractFetchDataInfo instanceof TierFetchDataInfo) {
                    throw new OffsetTieredException(new StringBuilder(34).append("Unexpected tiered fetch at offset ").append(fetchOffset).toString());
                }
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(logReadInfo.fetchedData.getClass()).toString());
            }
            FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
            Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala();
            if (!batches.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)batches.size());
            RecordBatch batch = (RecordBatch)batches.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$10) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$2(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$11) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        return partition$1.appendRecordsToLeader(batch, AppendOrigin.CLIENT, 0, requestLocal$1, partition$1.appendRecordsToLeader$default$5(), partition$1.appendRecordsToLeader$default$6());
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }
}

