/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.replication.push.PushSession;
import io.confluent.kafka.replication.push.ReplicationState;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.LogDeleteRecordsResult;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.FencedReplicationSessionIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.PushReplicationStartedException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}f\u0001\u0002\u001c8\u0001qBQ!\u0011\u0001\u0005\u0002\tCQ\u0001\u0012\u0001\u0005B\u0015Cq\u0001\u0018\u0001C\u0002\u0013\u0005S\f\u0003\u0004g\u0001\u0001\u0006IA\u0018\u0005\bO\u0002\u0011\r\u0011\"\u0001i\u0011\u0019)\b\u0001)A\u0005S\")a\u000f\u0001C\u0001o\"1\u0011Q\u0002\u0001\u0005\u0002]Da!!\u0005\u0001\t\u00039\bBBA\u000b\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u001a\u0001!\ta\u001e\u0005\u0007\u0003;\u0001A\u0011A<\t\r\u0005\u0005\u0002\u0001\"\u0001x\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAa!a\u0016\u0001\t\u00039\bBBA.\u0001\u0011\u0005q\u000f\u0003\u0004\u0002`\u0001!\ta\u001e\u0005\u0007\u0003G\u0002A\u0011A<\t\r\u0005\u001d\u0004\u0001\"\u0001x\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Ba!a(\u0001\t\u00039\bBBAR\u0001\u0011\u0005q\u000f\u0003\u0004\u0002(\u0002!\ta\u001e\u0005\u0007\u0003W\u0003A\u0011A<\t\r\u0005=\u0006\u0001\"\u0001x\u0011\u0019\t\u0019\f\u0001C\u0001o\"1\u0011q\u0017\u0001\u0005\u0002]Da!a/\u0001\t\u00039\bBBA`\u0001\u0011\u0005q\u000f\u0003\u0004\u0002D\u0002!\ta\u001e\u0005\u0007\u0003\u000f\u0004A\u0011A<\t\r\u0005-\u0007\u0001\"\u0001x\u0011\u0019\ty\r\u0001C\u0001o\"1\u00111\u001b\u0001\u0005\u0002]Da!a6\u0001\t\u00039\bBBAn\u0001\u0011\u0005q\u000f\u0003\u0004\u0002`\u0002!\ta\u001e\u0005\u0007\u0003G\u0004A\u0011A<\t\r\u0005\u001d\b\u0001\"\u0001x\u0011\u0019\tY\u000f\u0001C\u0001o\"9\u0011q\u001e\u0001\u0005\n\u0005E\bB\u0002B\u0001\u0001\u0011\u0005q\u000f\u0003\u0004\u0003\u0006\u0001!\ta\u001e\u0005\u0007\u0005\u0013\u0001A\u0011A<\t\r\t5\u0001\u0001\"\u0001x\u0011\u0019\u0011\t\u0002\u0001C\u0001o\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!\u001f\u0001\t\u0013\u0011Y\bC\u0004\u0003&\u0002!IAa*\t\u000f\tM\u0006\u0001\"\u0003\u00036\na\u0002+^:i%\u0016\u0004H.[2bi&|g\u000eU1si&$\u0018n\u001c8UKN$(B\u0001\u001d:\u0003\u001d\u0019G.^:uKJT\u0011AO\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\b\u0005\u0002?\u007f5\tq'\u0003\u0002Ao\t)\u0012IY:ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001D!\tq\u0004!\u0001\u000fde\u0016\fG/\u001a)vg\"\u0014V\r\u001d7jG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003\u0019\u00032a\u0012&M\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB(qi&|g\u000e\u0005\u0002N3:\u0011aJ\u0016\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!AU\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014BA+:\u0003\u0015)H/\u001b7t\u0013\t9\u0006,A\u0005UKN$X\u000b^5mg*\u0011Q+O\u0005\u00035n\u0013q\"T8dWB+8\u000f['b]\u0006<WM\u001d\u0006\u0003/b\u000bQ\"\\3uC\u0012\fG/Y\"bG\",W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001C7fi\u0006$\u0017\r^1\u000b\u0005\rL\u0014AB:feZ,'/\u0003\u0002fA\n\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003%\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\r\r|W.\\8o\u0015\t\u0019gN\u0003\u0002;_*\u0011\u0001/]\u0001\u0007CB\f7\r[3\u000b\u0003I\f1a\u001c:h\u0013\t!8N\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0011\u0002mQ,7\u000f^'bW\u0016dU-\u00193feJ+7/\u001a;t%\u0016\u0004H.[2bi&|gnU3tg&|gn\u00148OK^dU-\u00193fe\u0016\u0003xn\u00195\u0015\u0003a\u0004\"aR=\n\u0005iD%\u0001B+oSRD#a\u0002?\u0011\u0007u\fI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0004CBL'\u0002BA\u0002\u0003\u000b\tqA[;qSR,'OC\u0002\u0002\bE\fQA[;oSRL1!a\u0003\u007f\u0005\u0011!Vm\u001d;\u0002cQ,7\u000f^'bW\u0016dU-\u00193fe\u0016sGm\u001d)vg\"\u001cVm]:j_:\u001cx\u000b[3o\r\u0016t7-\u001b8h%\u0016\u0004H.[2bg\"\u0012\u0001\u0002`\u00012i\u0016\u001cH/T1lK2+\u0017\rZ3s\u000b:$7\u000fU;tQN+7o]5p]^CWM\u001c*fa2L7-Y:TQV$Hi\\<oQ\tIA0\u0001\u001buKN$X*Y6f\u0019\u0016\fG-\u001a:F]\u0012\u001c\b+^:i'\u0016\u001c8/[8o/\",g\u000e\u0015:p[>$\u0018N\\4MS:\\G*Z1eKJD#A\u0003?\u0002UQ,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\%teNC'/\u001b8l\u000b:$7\u000fU;tQN+7o]5p]\"\u00121\u0002`\u0001$i\u0016\u001cH\u000fR3mKR,\u0007+\u0019:uSRLwN\\#oIN\u0004Vo\u001d5TKN\u001c\u0018n\u001c8tQ\taA0\u0001\u0015uKN$X*\u0019:l!\u0006\u0014H/\u001b;j_:|eM\u001a7j]\u0016,e\u000eZ:QkND7+Z:tS>t7\u000f\u000b\u0002\u000ey\u0006IC/Z:u\u0007>t7-\u001e:sK:$X*Y6f\u0019\u0016\fG-\u001a:XSRD7)Y;hQR,\u0006OR3uG\"$2\u0001_A\u0015\u0011\u001d\tYC\u0004a\u0001\u0003[\t!\"\\1lK2+\u0017\rZ3s!\r9\u0015qF\u0005\u0004\u0003cA%a\u0002\"p_2,\u0017M\u001c\u0015\u0004\u001d\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u0012\u0011A\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005}\u0012\u0011\b\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\b\u0002D\u0005=\u0013\u0011\u000b\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)!\u0011\u0011JA\u001d\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA'\u0003\u000f\u00121BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002T\u0005U\u0013$\u0001\u0001\u001a\u0003\u0005\ta\u0005^3ti6\u000b7.\u001a$pY2|w/\u001a:F]\u0012\u001c(+\u001a9mS\u000e\fG/[8o'\u0016\u001c8/[8oQ\tyA0\u0001\u001auKN$8i\u001c8dkJ\u0014XM\u001c;DCV<\u0007\u000e^+q\r\u0016$8\r[!oI:+wOU3qY&\u001c\u0017-\u00129pG\"4U\r^2iQ\t\u0001B0\u0001\u001buKN$8i\u001c8dkJ\u0014XM\u001c;DCV<\u0007\u000e^+q\r\u0016$8\r[!oI:+wOU3qY&\u001c\u0017mU3tg&|gNR3uG\"D#!\u0005?\u0002WQ,7\u000f\u001e$fi\u000eDGK]1og&$\u0018n\u001c8t)>\u0004Vo\u001d5XQ\u0016tg)\u001e7ms\u000e\u000bWo\u001a5u+BD#A\u0005?\u0002aQ,7\u000f\u001e$fi\u000eDGK]1og&$\u0018n\u001c8t)>\u0004Vo\u001d5P]2Lx+\u001b;i\t\u00164\u0017N\\3e)>\u0004\u0018nY%eQ\t\u0019B0\u0001\u0018uKN$h)\u001a;dQ\u0012{Wm\u001d(piR\u0013\u0018M\\:ji&|g.\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000fV8QkNDGc\u0001=\u0002p!9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014!\u0002;pa&\u001c\u0007\u0003BA;\u0003{rA!a\u001e\u0002zA\u0011\u0001\u000bS\u0005\u0004\u0003wB\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\u0005\u0005%AB*ue&twMC\u0002\u0002|!C3\u0001FA\u001bQ\u001d!\u00121IAD\u0003\u0013\u000bqa\u001d;sS:<7\u000f\f\u0006\u0002\f\u0006=\u00151SAL\u00037\u000b#!!$\u0002%}{6m\u001c8tk6,'oX8gMN,Go]\u0011\u0003\u0003#\u000b1cX0ue\u0006t7/Y2uS>twl\u001d;bi\u0016\f#!!&\u0002+}\u001bwN\u001c4mk\u0016tG/\f;jKJl3\u000f^1uK\u0006\u0012\u0011\u0011T\u0001\u0019?\u000e|gN\u001a7vK:$X\u0006\\5oW6jW\r^1eCR\f\u0017EAAO\u0003Ey6m\u001c8gYV,g\u000e^\u0017rk>$\u0018m]\u0001-i\u0016\u001cHOR3uG\"$&/\u00198tSRLwN\\:U_B+8\u000f[,iK:LenQ8n[&$H/\u001a3JgJD#!\u0006?\u0002iQ,7\u000f\u001e$fi\u000eDw+\u001b;i\u0013:4\u0018\r\\5e'\u0016\u001c8/[8o\u0013\u0012$u.Z:O_R$&/\u00198tSRLwN\u001c+p!V\u001c\b\u000e\u000b\u0002\u0017y\u0006iD/Z:u\r\u0016$8\r[,ji\"4\u0015N\\1m%\u0016\u0004H.[2bi&|gnU3tg&|g.\u00133E_\u0016\u001chj\u001c;Ue\u0006t7/\u001b;j_:$v\u000eU;tQ\"\u0012q\u0003`\u00012i\u0016\u001cHOR3uG\"<\u0016\u000e\u001e5pkR\u0014%o\\6fe:{G-\u001a#pKNtu\u000e\u001e+sC:\u001c\u0018\u000e^5p]R{\u0007+^:iQ\tAB0\u0001,uKN$h)\u001a;dQ^KG\u000f\u001b$j]\u0006d'+\u001a9mS\u000e\fG/[8o'\u0016\u001c8/[8o\u0013\u0012$&/\u00198tSRLwN\\:U_B+H\u000e\\!oI\u000e\u000bgNT3wKJ$&/\u00198tSRLwN\u001c\"bG.$v\u000eU;tQ\"\u0012\u0011\u0004`\u00013i\u0016\u001cHOR3uG\"<\u0016\u000e\u001e5ESZ,'oZ5oO\u0016\u0003xn\u00195E_\u0016\u001chj\u001c;Ue\u0006t7/\u001b;j_:$v\u000eU;mY\"\u0012!\u0004`\u0001.i\u0016\u001cHOR3uG\"<\u0016\u000e\u001e5OK^\u0014V\r\u001d7jG\u0006,\u0005o\\2i)J\fgn]5uS>t7\u000fV8Qk2d\u0007FA\u000e}\u0003]\"Xm\u001d;GKR\u001c\u0007nV5uQ:+wOU3qY&\u001c\u0017-\u00129pG\",\u0006\u000fZ1uKN\u0014V\r\u001d7jG\u0006$\u0018n\u001c8TKN\u001c\u0018n\u001c8JI\"\u0012A\u0004`\u00014i\u0016\u001cHOR3uG\"<\u0016\u000e\u001e5OK^\u0014V\r\u001d7jG\u0006$\u0018n\u001c8TKN\u001c\u0018n\u001c8Ue\u0006t7/\u001b;j_:\u001cHk\u001c)vY2D#!\b?\u0002\u000bR,7\u000f\u001e$pY2|w/\u001a:GKR\u001c\u0007.\u00114uKJ$&/\u00198tSRLwN\u001c+ie><8\u000fU;tQJ+\u0007\u000f\\5dCRLwN\\*uCJ$X\rZ#yG\u0016\u0004H/[8oQ\tqB0\u0001&uKN$hi\u001c7m_^,'OR3uG\"<\u0016\u000e\u001e5Ue\u0006t7/\u001b;j_:,\u0006\u000fZ1uKN4U\r^2i'R\fG/Z!oI&s7M]3nK:$8\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007FA\u0010}\u00039\"Xm\u001d;Va\u0012\fG/\u001a$pY2|w/\u001a:GKR\u001c\u0007n\u0015;bi\u00164UM\\2fgN#\u0018\r\\3GKR\u001c\u0007.Z:)\u0005\u0001b\u0018!\n;fgR|e\u000eU;tQN+7o]5p]\u0016sG-\u001a3G_J\u001cF/\u00197f'\u0016\u001c8/[8oQ\t\tC0A\u0018uKN$xJ\u001c)vg\"\u001cVm]:j_:,e\u000eZ3e+B$\u0017\r^3t%\u0016\u0004H.[2bi&|gnU3tg&|g\u000e\u000b\u0002#y\u0006QC/Z:u\u001f:\u0004Vo\u001d5TKN\u001c\u0018n\u001c8F]\u0012,Gm\u00165f]B\u000b'\u000f^5uS>tG)\u001a7fi\u0016$\u0007FA\u0012}\u0003=\"Xm\u001d;P]\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t%\u0016\u001c\bo\u001c8tKV\u0003H-\u0019;fg\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\t!C0\u0001\u0018uKN$xJ\\!qa\u0016tGMU3d_J$7OU3ta>t7/Z+qI\u0006$Xm\u001d'po^\u000bG/\u001a:nCJ\\\u0007FA\u0013}\u00035\"Xm\u001d;P]\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t%\u0016\u001c\bo\u001c8tK\u000e{W\u000e\u001d7fi\u0016\u001c\b+\u001e:hCR|'/\u001f\u0015\u0003Mq\fq\u0006^3ti>s\u0017\t\u001d9f]\u0012\u0014VmY8sIN\u0014Vm\u001d9p]N,w+\u001b;i'R\fG.\u001a)vg\"\u001cVm]:j_:D#a\n?\u0002_Q,7\u000f^(o\u0003B\u0004XM\u001c3SK\u000e|'\u000fZ:SKN\u0004xN\\:f/&$\b\u000eR3mKR,G\rU1si&$\u0018n\u001c8)\u0005!b\u0018aD:fK\u0012dunZ,ji\"$\u0015\r^1\u0015\u0007a\f\u0019\u0010C\u0004\u0002v&\u0002\r!a>\u0002\u00071|w\r\u0005\u0003\u0002z\u0006uXBAA~\u0015\r\t)0O\u0005\u0005\u0003\u007f\fYPA\u0006BEN$(/Y2u\u0019><\u0017a\u0010;fgRdU-\u00193fe2{w-\u00119qK:$G*[:uK:,'OT8uS\u001aLWm\u001d)vg\"\u0014V\r\u001d7jG\u0006\u001chi\u001c:MK\u0006$WM]!qa\u0016tGm\u001d\u0015\u0003Uq\fq\t^3ti2+\u0017\rZ3s\u001f\u001a47/\u001a;t\u0019&\u001cH/\u001a8fe:{G/\u001b4jKN\u0004Vo\u001d5SKBd\u0017nY1t\r>\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018J\\2sK6,g\u000e\u001e\u0015\u0003Wq\fa\t^3ti2+\u0017\rZ3s\u001f\u001a47/\u001a;t\u0019&\u001cH/\u001a8fe:{G/\u001b4jKN\u0004Vo\u001d5SKBd\u0017nY1t\r>\u0014\b*[4i/\u0006$XM]7be.Len\u0019:f[\u0016tG\u000f\u000b\u0002-y\u0006\u0001D/Z:u\u0019\u0016\fG-\u001a:M_\u001e\f\u0005\u000f]3oI2K7\u000f^3oKJLuM\\8sKN4u\u000e\u001c7po\u0016\u0014XI^3oiND#!\f?\u0002wQ,7\u000f\u001e'fC\u0012,'\u000fT8h\u0003B\u0004XM\u001c3MSN$XM\\3s\u0013:\u001cG.\u001e3fgR\u0013\u0018M\\:bGRLwN\\'be.,'/\u00119qK:$7\u000f\u000b\u0002/y\u0006Y\u0011\r\u001d9f]\u0012$v\u000eT8h)\u001dA(\u0011\u0004B\u000e\u0005KAq!!>0\u0001\u0004\t9\u0010C\u0004\u0003\u001e=\u0002\rAa\b\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0004\u000f\n\u0005\u0012b\u0001B\u0012\u0011\n\u0019\u0011J\u001c;\t\u000f\t\u001dr\u00061\u0001\u0003 \u0005)1m\\;oi\u0006\t\u0012\r\u001d9f]\u0012$v\u000eU1si&$\u0018n\u001c8\u0015\r\t5\"1\bB#!\u0011\u0011yCa\u000e\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\taA]3d_J$'B\u00017o\u0013\u0011\u0011ID!\r\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0011i\u0004\ra\u0001\u0005\u007f\t\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007y\u0012\t%C\u0002\u0003D]\u0012\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\t\u001d\u0002\u00071\u0001\u0003 \u00051b-\u001a;dQ\u0006\u001b8)Y;hQR,\u0006OU3qY&\u001c\u0017\r\u0006\u0005\u0003L\tu#q\fB5!\u0011\u0011iE!\u0017\u000e\u0005\t=#\u0002BA{\u0005#RAAa\u0015\u0003V\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0005/r\u0017aB:u_J\fw-Z\u0005\u0005\u00057\u0012yEA\u0006M_\u001e\u0014V-\u00193J]\u001a|\u0007b\u0002B\u001fc\u0001\u0007!q\b\u0005\b\u0005C\n\u0004\u0019\u0001B2\u00031\u0011X\r\u001d7jG\u0006,\u0005o\\2i!\r9%QM\u0005\u0004\u0005OB%\u0001\u0002'p]\u001eDqAa\u001b2\u0001\u0004\u0011\u0019'\u0001\u000bsKBd\u0017nY1uS>t7+Z:tS>t\u0017\nZ\u0001\u001bCN\u001cXM\u001d;SKBd\u0017nY1uS>t7+Z:tS>t\u0017\n\u001a\u000b\u0006q\nE$Q\u000f\u0005\b\u0005g\u0012\u0004\u0019\u0001B\u0010\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0004\u0003lI\u0002\rAa\u001e\u0011\t\u001dS%1M\u0001\u001dCN\u001cXM\u001d;SKBd\u0017nY1uS>t7+Z:tS>tWj\u001c3f)\u0015A(Q\u0010B@\u0011\u001d\u0011\u0019h\ra\u0001\u0005?AqA!!4\u0001\u0004\u0011\u0019)A\bsKBd\u0017nY1uS>tWj\u001c3f!\u0011\u0011)Ia(\u000f\t\t\u001d%1T\u0007\u0003\u0005\u0013SAAa#\u0003\u000e\u0006!\u0001/^:i\u0015\u0011\u0011yI!%\u0002\u0017I,\u0007\u000f\\5dCRLwN\u001c\u0006\u0004u\tM%\u0002\u0002BK\u0005/\u000b\u0011bY8oM2,XM\u001c;\u000b\u0005\te\u0015AA5p\u0013\u0011\u0011iJ!#\u0002!I+\u0007\u000f\\5dCRLwN\\*uCR,\u0017\u0002\u0002BQ\u0005G\u0013A!T8eK*!!Q\u0014BE\u0003]\t7\r^5wKB+8\u000f[*fgNLwN\\(s\r\u0006LG\u000e\u0006\u0004\u0003*\n=&\u0011\u0017\t\u0005\u0005\u000f\u0013Y+\u0003\u0003\u0003.\n%%a\u0003)vg\"\u001cVm]:j_:DqAa\u001d5\u0001\u0004\u0011y\u0002C\u0004\u0003lQ\u0002\rAa\u0019\u0002-Y,'/\u001b4z!V\u001c\bnU3tg&|g.\u00128eK\u0012$r\u0001\u001fB\\\u0005s\u0013Y\fC\u0004\u0003tU\u0002\rAa\b\t\u000f\t-T\u00071\u0001\u0003d!9!QX\u001bA\u0002\u00055\u0012\u0001F:i_VdGmU3oI\u0016sGmU3tg&|g\u000e")
public class PushReplicationPartitionTest
extends AbstractPartitionTest {
    private final KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(this.topicId(), this.topicPartition().partition());

    @Override
    public Option<TestUtils.MockPushManager> createPushReplicationManager() {
        return new Some((Object)new TestUtils.MockPushManager());
    }

    public KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Test
    public void testMakeLeaderResetsReplicationSessionOnNewLeaderEpoch() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        int addingReplica = this.remoteReplicaId() + 1;
        Assertions.assertNotEquals((int)this.brokerId(), (int)addingReplica);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        Assertions.assertTrue((boolean)this.partition().getReplica(this.remoteReplicaId()).isDefined());
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        this.assertReplicationSessionId(addingReplica, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
        Partition qual$2 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$5 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(3).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$6 = this.offsetCheckpoints();
        Some x$7 = new Some((Object)this.topicId());
        Option x$8 = qual$2.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$2.makeLeader(x$5, x$6, (Option)x$7, x$8), (String)"Expected become leader transition not to change leader");
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
        this.assertReplicationSessionId(addingReplica, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
    }

    @Test
    public void testMakeLeaderEndsPushSessionsWhenFencingReplicas() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        int addingReplica = this.remoteReplicaId() + 1;
        Assertions.assertNotEquals((int)this.brokerId(), (int)addingReplica);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().isBrokerFenced(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, true);
    }

    @Test
    public void testMakeLeaderEndsPushSessionWhenReplicasShutDown() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        int addingReplica = this.remoteReplicaId() + 1;
        Assertions.assertNotEquals((int)this.brokerId(), (int)addingReplica);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().isBrokerFenced(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().isBrokerShuttingDown(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
    }

    @Test
    public void testMakeLeaderEndsPushSessionWhenPromotingLinkLeader() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        int addingReplica = this.remoteReplicaId() + 1;
        Assertions.assertNotEquals((int)this.brokerId(), (int)addingReplica);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setClusterLinkId(this.clusterLinkId().toString()).setClusterLinkTopicState(TopicLinkMirror$.MODULE$.name()).setLinkedLeaderEpoch(-1).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, true);
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 3L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterPartitionIsrShrinkEndsPushSession() {
        void withRecords_records;
        void withRecords_compressionType;
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        Partition qual$1 = this.partition();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Long.toString(this.time().milliseconds()).getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        RequestLocal x$4 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        long x$5 = qual$1.appendRecordsToLeader$default$5();
        VerificationGuard x$6 = qual$1.appendRecordsToLeader$default$6();
        qual$1.appendRecordsToLeader(x$1, AppendOrigin.CLIENT, 0, x$4, x$5, x$6);
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        this.alterPartitionManager().completeIsrUpdate(2);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, true);
    }

    @Test
    public void testDeletePartitionEndsPushSessions() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        this.partition().delete();
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
    }

    @Test
    public void testMarkPartitionOfflineEndsPushSessions() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        this.partition().markOffline();
        this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testConcurrentMakeLeaderWithCaughtUpFetch(boolean makeLeader) {
        int leaderEpoch = 5;
        this.setupPartitionWithMocks(leaderEpoch, true);
        Semaphore semaphore = new Semaphore(0);
        Future<LogReadInfo> fetchFuture = this.executor().submit(() -> {
            semaphore.acquire();
            Partition x$1 = this.partition();
            int x$2 = this.remoteReplicaId();
            Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
            Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
            long x$7 = this.fetchFollower$default$4();
            int x$8 = this.fetchFollower$default$5();
            Option<Object> x$9 = this.fetchFollower$default$7();
            long x$10 = this.fetchFollower$default$8();
            Uuid x$11 = this.fetchFollower$default$9();
            return this.fetchFollower(x$1, x$2, 0L, x$7, x$8, (Option<Object>)x$4, x$9, x$10, x$11, (Option<Object>)x$5, 0L);
        });
        Future<Object> updatePartitionFuture = this.executor().submit(() -> BoxesRunTime.boxToBoolean((boolean)PushReplicationPartitionTest.$anonfun$testConcurrentMakeLeaderWithCaughtUpFetch$2(this, semaphore, makeLeader, leaderEpoch)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PushReplicationPartitionTest.$anonfun$testConcurrentMakeLeaderWithCaughtUpFetch$3(semaphore)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for threads to prepare.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        semaphore.release(2);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToBoolean((boolean)makeLeader), (Object)updatePartitionFuture.get(15L, TimeUnit.SECONDS), (String)"Unexpected leadership change");
        Throwable e = Assertions.assertThrows(Exception.class, () -> fetchFuture.get(15L, TimeUnit.SECONDS)).getCause();
        Assertions.assertTrue((e instanceof FencedLeaderEpochException || e instanceof PushReplicationStartedException ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$1 -> x$1.pushReplicationSessions()).get()).isEmpty());
        if (!(e instanceof FencedLeaderEpochException)) {
            this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, true);
        }
        None$ expectedReplicationSessionId = makeLeader ? new Some((Object)BoxesRunTime.boxToLong((long)-1L)) : None$.MODULE$;
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)expectedReplicationSessionId);
    }

    @Test
    public void testMakeFollowerEndsReplicationSession() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeFollower$default$4();
        Assertions.assertTrue((boolean)qual$1.makeFollower(x$1, x$2, (Option)x$3, x$4));
        this.verifyPushSessionEnded(this.remoteReplicaId(), 0L, false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentCaughtUpFetchAndNewReplicaEpochFetch() {
        boolean triggeredTransitionToPush;
        Future<LogReadInfo> newReplicaEpochFetchFuture;
        block5: {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = this.topicPartition();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            this.seedLogWithData(log);
            Assertions.assertEquals((long)17L, (long)log.logEndOffset());
            int leaderEpoch = 10;
            Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L))).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L)));
            Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
            this.setupPartitionWithMocks(leaderEpoch, true);
            Semaphore semaphore = new Semaphore(0);
            Future<LogReadInfo> caughtUpFetchFuture = this.executor().submit(() -> {
                semaphore.acquire();
                Partition x$6 = this.partition();
                int x$7 = this.remoteReplicaId();
                Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
                Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
                long x$12 = this.fetchFollower$default$4();
                int x$13 = this.fetchFollower$default$5();
                Option<Object> x$14 = this.fetchFollower$default$7();
                long x$15 = this.fetchFollower$default$8();
                Uuid x$16 = this.fetchFollower$default$9();
                return this.fetchFollower(x$6, x$7, 17L, x$12, x$13, (Option<Object>)x$9, x$14, x$15, x$16, (Option<Object>)x$10, 2L);
            });
            newReplicaEpochFetchFuture = this.executor().submit(() -> {
                semaphore.acquire();
                Partition x$17 = this.partition();
                int x$18 = this.remoteReplicaId();
                Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
                Some x$21 = new Some((Object)BoxesRunTime.boxToLong((long)2L));
                long x$23 = this.fetchFollower$default$4();
                int x$24 = this.fetchFollower$default$5();
                Option<Object> x$25 = this.fetchFollower$default$7();
                long x$26 = this.fetchFollower$default$8();
                Uuid x$27 = this.fetchFollower$default$9();
                return this.fetchFollower(x$17, x$18, 12L, x$23, x$24, (Option<Object>)x$20, x$25, x$26, x$27, (Option<Object>)x$21, 0L);
            });
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PushReplicationPartitionTest.$anonfun$testConcurrentCaughtUpFetchAndNewReplicaEpochFetch$3(semaphore)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for threads to prepare.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            semaphore.release(2);
            triggeredTransitionToPush = false;
            try {
                caughtUpFetchFuture.get(15L, TimeUnit.SECONDS);
            }
            catch (ExecutionException executionException) {
                if (!(executionException.getCause() instanceof PushReplicationStartedException)) break block5;
                triggeredTransitionToPush = true;
            }
        }
        newReplicaEpochFetchFuture.get(15L, TimeUnit.SECONDS);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertTrue((boolean)((TestUtils.MockPushManager)this.pushReplicationManager().get()).pushReplicationSessions().isEmpty());
        if (triggeredTransitionToPush) {
            this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentCaughtUpFetchAndNewReplicaSessionFetch() {
        boolean triggeredTransitionToPush;
        Future<LogReadInfo> newReplicaSessionFetchFuture;
        block5: {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = this.topicPartition();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            this.seedLogWithData(log);
            Assertions.assertEquals((long)17L, (long)log.logEndOffset());
            int leaderEpoch = 10;
            this.setupPartitionWithMocks(leaderEpoch, true);
            Semaphore semaphore = new Semaphore(0);
            Future<LogReadInfo> caughtUpFetchFuture = this.executor().submit(() -> {
                semaphore.acquire();
                Partition x$6 = this.partition();
                int x$7 = this.remoteReplicaId();
                Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
                Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
                long x$12 = this.fetchFollower$default$4();
                int x$13 = this.fetchFollower$default$5();
                Option<Object> x$14 = this.fetchFollower$default$7();
                long x$15 = this.fetchFollower$default$8();
                Uuid x$16 = this.fetchFollower$default$9();
                return this.fetchFollower(x$6, x$7, 17L, x$12, x$13, (Option<Object>)x$9, x$14, x$15, x$16, (Option<Object>)x$10, 2L);
            });
            Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
            Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
            newReplicaSessionFetchFuture = this.executor().submit(() -> {
                semaphore.acquire();
                Partition x$17 = this.partition();
                int x$18 = this.remoteReplicaId();
                Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
                Some x$21 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
                long x$23 = this.fetchFollower$default$4();
                int x$24 = this.fetchFollower$default$5();
                Option<Object> x$25 = this.fetchFollower$default$7();
                long x$26 = this.fetchFollower$default$8();
                Uuid x$27 = this.fetchFollower$default$9();
                return this.fetchFollower(x$17, x$18, 12L, x$23, x$24, (Option<Object>)x$20, x$25, x$26, x$27, (Option<Object>)x$21, 3L);
            });
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PushReplicationPartitionTest.$anonfun$testConcurrentCaughtUpFetchAndNewReplicaSessionFetch$3(semaphore)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for threads to prepare.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            semaphore.release(2);
            triggeredTransitionToPush = false;
            try {
                caughtUpFetchFuture.get(15L, TimeUnit.SECONDS);
            }
            catch (ExecutionException executionException) {
                if (!(executionException.getCause() instanceof PushReplicationStartedException)) break block5;
                triggeredTransitionToPush = true;
            }
        }
        newReplicaSessionFetchFuture.get(15L, TimeUnit.SECONDS);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)3L)));
        Assertions.assertTrue((boolean)((TestUtils.MockPushManager)this.pushReplicationManager().get()).pushReplicationSessions().isEmpty());
        if (triggeredTransitionToPush) {
            this.verifyPushSessionEnded(this.remoteReplicaId(), 2L, false);
            return;
        }
    }

    @Test
    public void testFetchTransitionsToPushWhenFullyCaughtUp() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$22 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        Option x$52 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$32, x$42, (Option)x$22, x$52);
        this.seedLogWithData(log);
        int leaderEpoch = 10;
        long logStartOffset = 0L;
        Partition qual$2 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$6 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava()).setPartitionEpoch(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(true);
        OffsetCheckpoints x$7 = this.offsetCheckpoints();
        Some x$8 = new Some((Object)this.topicId());
        Option x$9 = qual$2.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$2.makeLeader(x$6, x$7, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
        Partition x$10 = this.partition();
        int x$11 = this.remoteReplicaId();
        Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$15 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$17 = this.fetchFollower$default$5();
        Option<Object> x$18 = this.fetchFollower$default$7();
        long x$19 = this.fetchFollower$default$8();
        Uuid x$20 = this.fetchFollower$default$9();
        this.fetchFollower(x$10, x$11, 5L, logStartOffset, x$17, (Option<Object>)x$14, x$18, x$19, x$20, (Option<Object>)x$15, 0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$2 -> x$2.pushReplicationSessions()).get()).isEmpty());
        this.appendToPartition(this.partition(), 3);
        Assertions.assertEquals((long)20L, (long)log.logEndOffset());
        Partition x$21 = this.partition();
        int x$222 = this.remoteReplicaId();
        Some x$25 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$26 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$28 = this.fetchFollower$default$5();
        Option<Object> x$29 = this.fetchFollower$default$7();
        long x$30 = this.fetchFollower$default$8();
        Uuid x$31 = this.fetchFollower$default$9();
        this.fetchFollower(x$21, x$222, 17L, logStartOffset, x$28, (Option<Object>)x$25, x$29, x$30, x$31, (Option<Object>)x$26, 0L);
        this.appendToPartition(this.partition(), 3);
        Assertions.assertEquals((long)20L, (long)log.highWatermark());
        Assertions.assertEquals((long)23L, (long)log.logEndOffset());
        Partition x$322 = this.partition();
        int x$33 = this.remoteReplicaId();
        Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$37 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$39 = this.fetchFollower$default$5();
        Option<Object> x$40 = this.fetchFollower$default$7();
        long x$41 = this.fetchFollower$default$8();
        Uuid x$422 = this.fetchFollower$default$9();
        this.fetchFollower(x$322, x$33, 20L, logStartOffset, x$39, (Option<Object>)x$36, x$40, x$41, x$422, (Option<Object>)x$37, 0L);
        this.alterPartitionManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), this.remoteReplicaId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$3 -> x$3.pushReplicationSessions()).get()).isEmpty());
        this.appendToPartition(this.partition(), 3);
        Assertions.assertEquals((long)26L, (long)log.logEndOffset());
        Partition x$43 = this.partition();
        int x$44 = this.remoteReplicaId();
        Some x$47 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$48 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$50 = this.fetchFollower$default$5();
        Option<Object> x$51 = this.fetchFollower$default$7();
        long x$522 = this.fetchFollower$default$8();
        Uuid x$53 = this.fetchFollower$default$9();
        this.fetchFollower(x$43, x$44, 23L, logStartOffset, x$50, (Option<Object>)x$47, x$51, x$522, x$53, (Option<Object>)x$48, 0L);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$4 -> x$4.pushReplicationSessions()).get()).isEmpty());
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> {
            Partition x$54 = this.partition();
            int x$55 = this.remoteReplicaId();
            Some x$58 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
            Some x$59 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
            int x$61 = this.fetchFollower$default$5();
            Option<Object> x$62 = this.fetchFollower$default$7();
            long x$63 = this.fetchFollower$default$8();
            Uuid x$64 = this.fetchFollower$default$9();
            this.fetchFollower(x$54, x$55, 26L, logStartOffset, x$61, (Option<Object>)x$58, x$62, x$63, x$64, (Option<Object>)x$59, 0L);
        });
        Assertions.assertFalse((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$5 -> x$5.pushReplicationSessions()).get()).isEmpty());
    }

    @Test
    public void testFetchTransitionsToPushOnlyWithDefinedTopicId() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.brokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(true);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition to succeed");
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L);
        Partition qual$2 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$5 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
        OffsetCheckpoints x$6 = this.offsetCheckpoints();
        Some x$7 = new Some((Object)this.topicId());
        Option x$8 = qual$2.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$2.makeLeader(x$5, x$6, (Option)x$7, x$8), (String)"Partition leader ID should not change");
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
    }

    @ParameterizedTest
    @ValueSource(strings={"__consumer_offsets", "__transaction_state", "_confluent-tier-state", "_confluent-link-metadata", "_confluent-quotas"})
    public void testFetchDoesNotTransitionInternalTopicsToPush(String topic) {
        int leaderEpoch = 5;
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.configRepository().setTopicConfig("_confluent-tier-state", "retention.ms", Integer.toString(-1));
        long x$2 = Defaults$.MODULE$.ReplicaLagTimeMaxMs();
        MetadataVersion x$3 = this.interBrokerProtocolVersion();
        int x$4 = this.brokerId();
        JFunction0.mcJ.sp & Serializable x$5 = (JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId());
        MockTime x$6 = this.time();
        TestUtils.MockAlterPartitionListener x$7 = this.alterPartitionListener();
        DelayedOperations x$8 = this.delayedOperations();
        KRaftMetadataCache x$9 = this.metadataCache();
        LogManager x$10 = this.logManager();
        Some x$11 = new Some((Object)this.tierReplicaManager());
        None$ x$12 = None$.MODULE$;
        TestUtils.MockAlterPartitionManager x$13 = this.alterPartitionManager();
        None$ x$14 = None$.MODULE$;
        Option<TestUtils.MockPushManager> x$15 = this.pushReplicationManager();
        ListenerName x$16 = this.interBrokerListenerName();
        None$ x$17 = None$.MODULE$;
        boolean x$18 = false;
        None$ x$19 = None$.MODULE$;
        None$ x$20 = None$.MODULE$;
        this.partition_$eq(new Partition(topicPartition, x$2, x$3, x$16, x$4, (Function0)x$5, (Time)x$6, (AlterPartitionListener)x$7, x$8, (MetadataCache)x$9, x$10, (Option)x$11, (Option)x$12, (Option)x$17, (AlterPartitionManager)x$13, (Option)x$14, x$18, (Option)x$19, x$15, (Option)x$20));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)topicPartition))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$21 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(true);
        OffsetCheckpoints x$22 = this.offsetCheckpoints();
        Some x$23 = new Some((Object)this.topicId());
        Option x$24 = qual$1.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$1.makeLeader(x$21, x$22, (Option)x$23, x$24), (String)"Expected become leader transition to succeed");
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L);
    }

    @Test
    public void testFetchTransitionsToPushWhenInCommittedIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        int leaderEpoch = 10;
        long logStartOffset = 0L;
        Partition qual$2 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$62 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava()).setPartitionEpoch(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(true);
        OffsetCheckpoints x$72 = this.offsetCheckpoints();
        Some x$8 = new Some((Object)this.topicId());
        Option x$9 = qual$2.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$2.makeLeader(x$62, x$72, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Partition x$10 = this.partition();
        int x$11 = this.remoteReplicaId();
        Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$15 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$17 = this.fetchFollower$default$5();
        Option<Object> x$18 = this.fetchFollower$default$7();
        long x$19 = this.fetchFollower$default$8();
        Uuid x$20 = this.fetchFollower$default$9();
        this.fetchFollower(x$10, x$11, 17L, logStartOffset, x$17, (Option<Object>)x$14, x$18, x$19, x$20, (Option<Object>)x$15, 0L);
        this.alterPartitionManager().assertInFlightLeaderAndIsr((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), this.remoteReplicaId()}))), leaderEpoch, 1);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$6 -> x$6.pushReplicationSessions()).get()).isEmpty());
        Partition x$21 = this.partition();
        int x$22 = this.remoteReplicaId();
        Some x$25 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$26 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$28 = this.fetchFollower$default$5();
        Option<Object> x$29 = this.fetchFollower$default$7();
        long x$30 = this.fetchFollower$default$8();
        Uuid x$31 = this.fetchFollower$default$9();
        this.fetchFollower(x$21, x$22, 17L, logStartOffset, x$28, (Option<Object>)x$25, x$29, x$30, x$31, (Option<Object>)x$26, 0L);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$7 -> x$7.pushReplicationSessions()).get()).isEmpty());
        this.alterPartitionManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), this.remoteReplicaId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> {
            Partition x$32 = this.partition();
            int x$33 = this.remoteReplicaId();
            Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
            Some x$37 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
            int x$39 = this.fetchFollower$default$5();
            Option<Object> x$40 = this.fetchFollower$default$7();
            long x$41 = this.fetchFollower$default$8();
            Uuid x$42 = this.fetchFollower$default$9();
            this.fetchFollower(x$32, x$33, 17L, logStartOffset, x$39, (Option<Object>)x$36, x$40, x$41, x$42, (Option<Object>)x$37, 0L);
        });
    }

    @Test
    public void testFetchWithInvalidSessionIdDoesNotTransitionToPush() {
        int leaderEpoch = 5;
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.fetchAsCaughtUpReplica(this.partition(), 1L, -1L);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$8 -> x$8.pushReplicationSessions()).get()).isEmpty());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        Assertions.assertFalse((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$9 -> x$9.pushReplicationSessions()).get()).isEmpty());
    }

    @Test
    public void testFetchWithFinalReplicationSessionIdDoesNotTransitionToPush() {
        int leaderEpoch = 5;
        long replicaEpoch = 1L;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)replicaEpoch)));
        this.setupPartitionWithMocks(leaderEpoch, true);
        this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, Long.MAX_VALUE);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)));
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$10 -> x$10.pushReplicationSessions()).get()).isEmpty());
        this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, Long.MAX_VALUE);
        Assertions.assertThrows(FencedReplicationSessionIdException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, 0L));
    }

    @Test
    public void testFetchWithoutBrokerNodeDoesNotTransitionToPush() {
        int leaderEpoch = 5;
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn((Object)Option$.MODULE$.empty());
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$11 -> x$11.pushReplicationSessions()).get()).isEmpty());
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        Assertions.assertFalse((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$12 -> x$12.pushReplicationSessions()).get()).isEmpty());
    }

    @Test
    public void testFetchWithFinalReplicationSessionIdTransitionsToPullAndCanNeverTransitionBackToPush() {
        int leaderEpoch = 5;
        long replicaEpoch = 1L;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)replicaEpoch)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, 0L));
        this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, Long.MAX_VALUE);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)));
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyPushSessionEnded(new TestUtils.TopicIdPartitionReplica(this.topicIdPartition(), this.remoteReplicaId()), 0L, false);
        this.fetchAsCaughtUpReplica(this.partition(), replicaEpoch, Long.MAX_VALUE);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$13 -> x$13.pushReplicationSessions()).get()).isEmpty());
    }

    @Test
    public void testFetchWithDivergingEpochDoesNotTransitionToPull() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        int leaderEpoch = 10;
        long logStartOffset = 0L;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        this.read$1(2, 5L, true, partition, logStartOffset, leaderEpoch);
        this.read$1(0, 4L, true, partition, logStartOffset, leaderEpoch);
        this.read$1(6, 6L, true, partition, logStartOffset, leaderEpoch);
        this.read$1(8, 17L, true, partition, logStartOffset, leaderEpoch);
        this.read$1(10, 18L, true, partition, logStartOffset, leaderEpoch);
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$14 -> x$14.pushReplicationSessions()).get()).isEmpty());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.read$1(9, 17L, false, partition, logStartOffset, leaderEpoch));
        Assertions.assertFalse((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$15 -> x$15.pushReplicationSessions()).get()).isEmpty());
    }

    @Test
    public void testFetchWithNewReplicaEpochTransitionsToPull() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L))).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)5L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L));
        this.fetchAsCaughtUpReplica(this.partition(), 5L, 0L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 1L, false);
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
    }

    @Test
    public void testFetchWithNewReplicaEpochUpdatesReplicationSessionId() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 0L, false);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        this.fetchAsCaughtUpReplica(this.partition(), 2L, 0L);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 2L, 1L));
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        this.fetchAsCaughtUpReplica(this.partition(), 3L, 0L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 1L, false);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    @Test
    public void testFetchWithNewReplicationSessionTransitionsToPull() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 0L, false);
        Assertions.assertThrows(FencedReplicationSessionIdException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        Assertions.assertTrue((boolean)((IterableOnceOps)this.pushReplicationManager().map((Function1 & Serializable)x$16 -> x$16.pushReplicationSessions()).get()).isEmpty());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 1L);
    }

    @Test
    public void testFollowerFetchAfterTransitionThrowsPushReplicationStartedException() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
    }

    @Test
    public void testFollowerFetchWithTransitionUpdatesFetchStateAndIncrementsHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        int leaderEpoch = 10;
        long logStartOffset = 0L;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((long)0L, (long)log.highWatermark());
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        int x$7 = this.remoteReplicaId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        int x$13 = this.fetchFollower$default$5();
        Option<Object> x$14 = this.fetchFollower$default$7();
        long x$15 = this.fetchFollower$default$8();
        Uuid x$16 = this.fetchFollower$default$9();
        this.fetchFollower(partition, x$7, 5L, logStartOffset, x$13, (Option<Object>)x$10, x$14, x$15, x$16, (Option<Object>)x$11, 0L);
        Assertions.assertEquals((long)5L, (long)log.highWatermark());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(partition, 1L, 0L));
        Assertions.assertEquals((long)log.logEndOffset(), (long)log.highWatermark());
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderHwmEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), log.highWatermark());
    }

    @Test
    public void testUpdateFollowerFetchStateFencesStaleFetches() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        long currentBrokerEpoch = 3L;
        long currentReplicationSessionId = 4L;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)currentBrokerEpoch)));
        int x$7 = this.remoteReplicaId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)currentBrokerEpoch));
        int x$13 = this.fetchFollower$default$5();
        Option<Object> x$14 = this.fetchFollower$default$7();
        long x$15 = this.fetchFollower$default$8();
        Uuid x$16 = this.fetchFollower$default$9();
        this.fetchFollower(partition, x$7, 5L, 0L, x$13, (Option<Object>)x$10, x$14, x$15, x$16, (Option<Object>)x$11, currentReplicationSessionId);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentReplicationSessionId)));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.updateFetchState$1(this.remoteReplicaId(), Optional.of(Predef$.MODULE$.int2Integer(9)), currentBrokerEpoch, currentReplicationSessionId, partition, log));
        Assertions.assertThrows(FencedReplicationSessionIdException.class, () -> this.updateFetchState$1(this.remoteReplicaId(), Optional.of(Predef$.MODULE$.int2Integer(10)), currentBrokerEpoch, currentReplicationSessionId - 1L, partition, log));
    }

    @Test
    public void testOnPushSessionEndedForStaleSession() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 0L, false);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        pushSession.onPushSessionEnded();
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 1L));
        pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 1L);
        this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 1L, false);
        pushSession.onPushSessionEnded();
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 2L));
        pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 2L);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader not to change leadership");
        pushSession.onPushSessionEnded();
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
    }

    @Test
    public void testOnPushSessionEndedUpdatesReplicationSession() {
        int leaderEpoch = 5;
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        pushSession.onPushSessionEnded();
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        this.assertReplicationSessionMode(this.remoteReplicaId(), ReplicationState.Mode.PULL);
    }

    @Test
    public void testOnPushSessionEndedWhenPartitionDeleted() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        this.assertReplicationSessionId(this.remoteReplicaId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        this.partition().delete();
        pushSession.onPushSessionEnded();
    }

    @Test
    public void testOnAppendRecordsResponseUpdatesHighWatermark() {
        int leaderEpoch = 10;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Assertions.assertEquals((long)17L, (long)log.highWatermark());
        this.appendToPartition(this.partition(), 5);
        pushSession.onAppendRecordsResponse(19L, 3L);
        Assertions.assertEquals((long)19L, (long)log.highWatermark());
        Assertions.assertEquals((long)0L, (long)this.partition().lowWatermarkIfLeader());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        this.alterPartitionManager().completeIsrUpdate(2);
        pushSession.onAppendRecordsResponse(log.logEndOffset(), 3L);
        Assertions.assertTrue((boolean)this.alterPartitionManager().isrUpdates().isEmpty());
    }

    @Test
    public void testOnAppendRecordsResponseUpdatesLowWatermark() {
        int leaderEpoch = 10;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().hasAliveBroker(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Assertions.assertEquals((long)17L, (long)log.highWatermark());
        LogDeleteRecordsResult deletionResult = this.partition().deleteRecordsOnLeader(5L);
        Assertions.assertEquals((long)5L, (long)deletionResult.requestedOffset());
        Assertions.assertEquals((long)0L, (long)deletionResult.lowWatermark());
        pushSession.onAppendRecordsResponse(17L, 5L);
        Assertions.assertEquals((long)5L, (long)this.partition().lowWatermarkIfLeader());
    }

    @Test
    public void testOnAppendRecordsResponseCompletesPurgatory() {
        int leaderEpoch = 10;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().hasAliveBroker(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Assertions.assertEquals((long)17L, (long)log.highWatermark());
        this.appendToPartition(this.partition(), 5);
        pushSession.onAppendRecordsResponse(17L, 0L);
        ((DelayedOperations)Mockito.verify((Object)this.delayedOperations(), (VerificationMode)Mockito.never())).checkAndCompleteAll();
        pushSession.onAppendRecordsResponse(19L, 0L);
        Assertions.assertEquals((long)19L, (long)log.highWatermark());
        ((DelayedOperations)Mockito.verify((Object)this.delayedOperations(), (VerificationMode)Mockito.times((int)1))).checkAndCompleteAll();
        Mockito.reset((Object[])new DelayedOperations[]{this.delayedOperations()});
        pushSession.onAppendRecordsResponse(19L, 3L);
        ((DelayedOperations)Mockito.verify((Object)this.delayedOperations(), (VerificationMode)Mockito.times((int)0))).checkAndCompleteAll();
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.delayedOperations().numDelayedDelete())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        this.partition().deleteRecordsOnLeader(5L);
        Assertions.assertEquals((long)3L, (long)this.partition().lowWatermarkIfLeader());
        pushSession.onAppendRecordsResponse(19L, 5L);
        ((DelayedOperations)Mockito.verify((Object)this.delayedOperations(), (VerificationMode)Mockito.times((int)1))).checkAndCompleteAll();
    }

    @Test
    public void testOnAppendRecordsResponseWithStalePushSession() {
        int leaderEpoch = 10;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        this.setupPartitionWithMocks(leaderEpoch, true);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Assertions.assertEquals((long)17L, (long)log.highWatermark());
        this.appendToPartition(this.partition(), 5);
        Assertions.assertEquals((long)22L, (long)log.logEndOffset());
        pushSession.onAppendRecordsResponse(19L, 0L);
        Assertions.assertEquals((long)19L, (long)log.highWatermark());
        Partition x$6 = this.partition();
        int x$7 = this.remoteReplicaId();
        Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        long x$12 = this.fetchFollower$default$4();
        int x$13 = this.fetchFollower$default$5();
        Option<Object> x$14 = this.fetchFollower$default$7();
        long x$15 = this.fetchFollower$default$8();
        Uuid x$16 = this.fetchFollower$default$9();
        this.fetchFollower(x$6, x$7, 17L, x$12, x$13, (Option<Object>)x$9, x$14, x$15, x$16, (Option<Object>)x$10, 1L);
        this.verifyPushSessionEnded(this.remoteReplicaId(), 0L, false);
        pushSession.onAppendRecordsResponse(21L, 3L);
        Assertions.assertEquals((long)19L, (long)log.highWatermark());
        Partition x$17 = this.partition();
        int x$18 = this.remoteReplicaId();
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Some x$21 = new Some((Object)BoxesRunTime.boxToLong((long)2L));
        long x$23 = this.fetchFollower$default$4();
        int x$24 = this.fetchFollower$default$5();
        Option<Object> x$25 = this.fetchFollower$default$7();
        long x$26 = this.fetchFollower$default$8();
        Uuid x$27 = this.fetchFollower$default$9();
        this.fetchFollower(x$17, x$18, 17L, x$23, x$24, (Option<Object>)x$20, x$25, x$26, x$27, (Option<Object>)x$21, 0L);
        pushSession.onAppendRecordsResponse(21L, 3L);
        Assertions.assertEquals((long)19L, (long)log.highWatermark());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 2L, 0L));
        pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        this.appendToPartition(this.partition(), 5);
        Assertions.assertEquals((long)27L, (long)log.logEndOffset());
        pushSession.onAppendRecordsResponse(23L, 3L);
        Assertions.assertEquals((long)23L, (long)log.highWatermark());
        Partition qual$2 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$28 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
        OffsetCheckpoints x$29 = this.offsetCheckpoints();
        Some x$30 = new Some((Object)this.topicId());
        Option x$31 = qual$2.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$2.makeLeader(x$28, x$29, (Option)x$30, x$31), (String)"Expected become leader not to change leadership");
        pushSession.onAppendRecordsResponse(25L, 3L);
        Assertions.assertEquals((long)23L, (long)log.highWatermark());
    }

    @Test
    public void testOnAppendRecordsResponseWithDeletedPartition() {
        int leaderEpoch = 10;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        this.seedLogWithData(log);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().hasAliveBroker(this.remoteReplicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        Assertions.assertEquals((long)17L, (long)log.highWatermark());
        this.appendToPartition(this.partition(), 5);
        Assertions.assertEquals((long)22L, (long)log.logEndOffset());
        this.partition().delete();
        pushSession.onAppendRecordsResponse(22L, 0L);
    }

    private void seedLogWithData(AbstractLog log) {
        this.appendToLog(log, 0, 2);
        this.appendToLog(log, 3, 3);
        this.appendToLog(log, 3, 3);
        this.appendToLog(log, 4, 5);
        this.appendToLog(log, 7, 1);
        this.appendToLog(log, 9, 3);
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
    }

    @Test
    public void testLeaderLogAppendListenerNotifiesPushReplicasForLeaderAppends() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        int addingReplica = this.remoteReplicaId() + 1;
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setPartitionEpoch(this.partition().getPartitionEpoch() + 1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        AbstractLog log = this.partition().localLogOrException();
        this.appendToPartition(this.partition(), 5);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.remoteReplicaId()), Predef$.MODULE$.int2Integer(addingReplica)}))));
        int expectedLogEndOffset = 5;
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log.logEndOffset());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        MemoryRecords appendedRecords = this.appendToPartition(this.partition(), 5);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderAppendEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), expectedLogEndOffset, (AbstractRecords)appendedRecords);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplica)}))));
        Assertions.assertEquals((long)(expectedLogEndOffset += 5), (long)log.logEndOffset());
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(addingReplica)).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)3L)));
        this.fetchFollower(this.partition(), addingReplica, 3L, this.fetchFollower$default$4(), this.fetchFollower$default$5(), this.fetchFollower$default$6(), this.fetchFollower$default$7(), this.fetchFollower$default$8(), this.fetchFollower$default$9(), this.fetchFollower$default$10(), this.fetchFollower$default$11());
        Assertions.assertEquals((long)3L, (long)this.partition().localLogOrException().highWatermark());
        appendedRecords = this.appendToPartition(this.partition(), 5);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderAppendEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), expectedLogEndOffset, (AbstractRecords)appendedRecords);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplica)}))));
        Assertions.assertEquals((long)(expectedLogEndOffset += 5), (long)log.logEndOffset());
    }

    @Test
    public void testLeaderOffsetsListenerNotifiesPushReplicasForLogStartOffsetIncrement() {
        int leaderEpoch = 5;
        int addingReplicaId = this.remoteReplicaId() + 1;
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(this.partition().getPartitionEpoch()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplicaId), (List)Nil$.MODULE$)))).asJava()).setIsNew(true);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition to succeed");
        this.appendToPartition(this.partition(), 5);
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 0L, 0L));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> PushReplicationPartitionTest.$anonfun$testLeaderOffsetsListenerNotifiesPushReplicasForLogStartOffsetIncrement$2(this, BoxesRunTime.unboxToInt((Object)i)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderLsoEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), i);
            ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderLsoEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplicaId)}))));
        });
    }

    @Test
    public void testLeaderOffsetsListenerNotifiesPushReplicasForHighWatermarkIncrement() {
        int leaderEpoch = 5;
        int addingReplicaId = this.remoteReplicaId() + 1;
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(this.partition().getPartitionEpoch()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplicaId), (List)Nil$.MODULE$)))).asJava()).setIsNew(true);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertTrue((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition to succeed");
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 0L, 0L));
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderHwmEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), 0L);
        PushSession pushSession = this.activePushSessionOrFail(this.remoteReplicaId(), 0L);
        this.appendToPartition(this.partition(), 5);
        Assertions.assertEquals((long)this.partition().localLogOrException().highWatermark(), (long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            pushSession.onAppendRecordsResponse((long)i, this.partition().logStartOffset());
            Assertions.assertEquals((long)i, (long)this.partition().localLogOrException().highWatermark());
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderHwmEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), i);
            ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderHwmEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplicaId)}))));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderLogAppendListenerIgnoresFollowerEvents() {
        void withRecords_records;
        void withRecords_compressionType;
        int leaderEpoch = 5;
        this.setupPartitionWithMocks(leaderEpoch, false);
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> PushReplicationPartitionTest.$anonfun$testLeaderLogAppendListenerIgnoresFollowerEvents$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        this.partition().appendRecordsToFollower(0L, AppendOrigin.REPLICATION, -1L, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), records, 3L, Optional.empty());
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))));
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderHwmEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))));
        this.partition().localLogOrException().maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderLsoEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))));
    }

    @Test
    public void testLeaderLogAppendListenerIncludesTransactionMarkerAppends() {
        int leaderEpoch = 5;
        Mockito.when((Object)this.metadataCache().getAliveBrokerEpoch(this.remoteReplicaId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNode(this.remoteReplicaId(), this.interBrokerListenerName())).thenReturn(this.replicaNode());
        this.setupPartitionWithMocks(leaderEpoch, true);
        int addingReplica = this.remoteReplicaId() + 1;
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setPartitionEpoch(this.partition().getPartitionEpoch() + 1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(addingReplica), (List)Nil$.MODULE$)))).asJava()).setIsNew(false);
        OffsetCheckpoints x$2 = this.offsetCheckpoints();
        Some x$3 = new Some((Object)this.topicId());
        Option x$4 = qual$1.makeLeader$default$4();
        Assertions.assertFalse((boolean)qual$1.makeLeader(x$1, x$2, (Option)x$3, x$4), (String)"Expected become leader transition not to change leader");
        Assertions.assertThrows(PushReplicationStartedException.class, () -> this.fetchAsCaughtUpReplica(this.partition(), 1L, 0L));
        AbstractLog log = this.partition().localLogOrException();
        long pid = 1L;
        short epoch = 0;
        VerificationGuard verificationGuard = this.partition().maybeStartTransactionVerification(pid, 0, epoch);
        .colon.colon x$5 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$);
        int x$8 = this.createTransactionalRecords$default$3();
        MemoryRecords transactionRecords = this.createTransactionalRecords((Iterable<SimpleRecord>)x$5, 0L, x$8, pid);
        this.partition().appendRecordsToLeader(transactionRecords, AppendOrigin.CLIENT, -1, RequestLocal$.MODULE$.withThreadConfinedCaching(), this.time().milliseconds(), verificationGuard);
        int numMessages = CollectionConverters$.MODULE$.IterableHasAsScala(transactionRecords.records()).asScala().size();
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderAppendEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), 0L, (AbstractRecords)transactionRecords);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplica)}))));
        Assertions.assertEquals((long)numMessages, (long)log.logEndOffset());
        MemoryRecords endTransactionMarker = MemoryRecords.withEndTransactionMarker((long)pid, (short)epoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, (int)epoch));
        Partition qual$2 = this.partition();
        RequestLocal x$12 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        long x$13 = qual$2.appendRecordsToLeader$default$5();
        VerificationGuard x$14 = qual$2.appendRecordsToLeader$default$6();
        qual$2.appendRecordsToLeader(endTransactionMarker, AppendOrigin.COORDINATOR, -1, x$12, x$13, x$14);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyLeaderAppendEvent(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))), numMessages, (AbstractRecords)endTransactionMarker);
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyNoLeaderAppendEvents(this.topicIdPartition(), (Set<Integer>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(addingReplica)}))));
        Assertions.assertEquals((long)(numMessages + CollectionConverters$.MODULE$.IterableHasAsScala(endTransactionMarker.records()).asScala().size()), (long)log.logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    private void appendToLog(AbstractLog log, int leaderEpoch, int count) {
        void withRecords_records;
        void withRecords_compressionType;
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)i -> PushReplicationPartitionTest.$anonfun$appendToLog$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        log.appendAsLeader(records, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords appendToPartition(Partition partition, int count) {
        void withRecords_records;
        void withRecords_compressionType;
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)i -> PushReplicationPartitionTest.$anonfun$appendToPartition$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var9_7 = null;
        compressionType = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        partition.appendRecordsToLeader(records, AppendOrigin.CLIENT, 1, RequestLocal$.MODULE$.NoCaching(), partition.appendRecordsToLeader$default$5(), partition.appendRecordsToLeader$default$6());
        return records;
    }

    private LogReadInfo fetchAsCaughtUpReplica(Partition partition, long replicaEpoch, long replicationSessionId) {
        AbstractLog log = partition.localLogOrException();
        int x$2 = this.remoteReplicaId();
        long x$3 = log.logEndOffset();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch()));
        Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)replicaEpoch));
        long x$7 = this.fetchFollower$default$4();
        int x$8 = this.fetchFollower$default$5();
        Option<Object> x$9 = this.fetchFollower$default$7();
        long x$10 = this.fetchFollower$default$8();
        Uuid x$11 = this.fetchFollower$default$9();
        return this.fetchFollower(partition, x$2, x$3, x$7, x$8, (Option<Object>)x$4, x$9, x$10, x$11, (Option<Object>)x$5, replicationSessionId);
    }

    private void assertReplicationSessionId(int replicaId, Option<Object> replicationSessionId) {
        Assertions.assertEquals(replicationSessionId, (Object)this.partition().getReplica(replicaId).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)PushReplicationPartitionTest.$anonfun$assertReplicationSessionId$1(x$17))));
    }

    private void assertReplicationSessionMode(int replicaId, ReplicationState.Mode replicationMode) {
        Replica replica = (Replica)this.partition().getReplica(replicaId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Expected replica to exist"));
        Assertions.assertEquals((Object)replicationMode, (Object)replica.stateSnapshot().replicationSessionState().mode());
    }

    private PushSession activePushSessionOrFail(int replicaId, long replicationSessionId) {
        Assertions.assertTrue((boolean)this.partition().remotePushReplicas().contains((Object)Predef$.MODULE$.int2Integer(replicaId)));
        return ((TestUtils.MockPushManager)this.pushReplicationManager().get()).activePushSessionOrFail(new TestUtils.TopicIdPartitionReplica(this.topicIdPartition(), replicaId), replicationSessionId);
    }

    private void verifyPushSessionEnded(int replicaId, long replicationSessionId, boolean shouldSendEndSession) {
        Assertions.assertFalse((boolean)this.partition().remotePushReplicas().contains((Object)Predef$.MODULE$.int2Integer(replicaId)));
        ((TestUtils.MockPushManager)this.pushReplicationManager().get()).verifyPushSessionEnded(new TestUtils.TopicIdPartitionReplica(this.topicIdPartition(), this.remoteReplicaId()), replicationSessionId, shouldSendEndSession);
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentMakeLeaderWithCaughtUpFetch$2(PushReplicationPartitionTest $this, Semaphore semaphore$1, boolean makeLeader$1, int leaderEpoch$1) {
        semaphore$1.acquire();
        if (makeLeader$1) {
            Partition qual$1 = $this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$12 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader($this.brokerId()).setLeaderEpoch(leaderEpoch$1 + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
            OffsetCheckpoints x$13 = $this.offsetCheckpoints();
            Some x$14 = new Some((Object)$this.topicId());
            Option x$15 = qual$1.makeLeader$default$4();
            return qual$1.makeLeader(x$12, x$13, (Option)x$14, x$15);
        }
        Partition qual$2 = $this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$16 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader($this.remoteReplicaId()).setLeaderEpoch(leaderEpoch$1 + 1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setPartitionEpoch(2).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer($this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava()).setIsNew(false);
        OffsetCheckpoints x$17 = $this.offsetCheckpoints();
        Some x$18 = new Some((Object)$this.topicId());
        Option x$19 = qual$2.makeFollower$default$4();
        return qual$2.makeFollower(x$16, x$17, (Option)x$18, x$19);
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentMakeLeaderWithCaughtUpFetch$3(Semaphore semaphore$1) {
        return semaphore$1.getQueueLength() == 2;
    }

    public static final /* synthetic */ String $anonfun$testConcurrentMakeLeaderWithCaughtUpFetch$4() {
        return "Timed out waiting for threads to prepare.";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCaughtUpFetchAndNewReplicaEpochFetch$3(Semaphore semaphore$2) {
        return semaphore$2.getQueueLength() == 2;
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCaughtUpFetchAndNewReplicaEpochFetch$4() {
        return "Timed out waiting for threads to prepare.";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCaughtUpFetchAndNewReplicaSessionFetch$3(Semaphore semaphore$3) {
        return semaphore$3.getQueueLength() == 2;
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCaughtUpFetchAndNewReplicaSessionFetch$4() {
        return "Timed out waiting for threads to prepare.";
    }

    private final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, boolean expectDivergingEpoch, Partition partition$1, long logStartOffset$3, int leaderEpoch$6) {
        int x$2 = this.remoteReplicaId();
        Some x$5 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch$6));
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        Some x$7 = new Some((Object)BoxesRunTime.boxToInteger((int)lastFetchedEpoch));
        int x$9 = this.fetchFollower$default$5();
        long x$10 = this.fetchFollower$default$8();
        Uuid x$11 = this.fetchFollower$default$9();
        LogReadInfo logReadInfo = this.fetchFollower(partition$1, x$2, fetchOffset, logStartOffset$3, x$9, (Option<Object>)x$5, (Option<Object>)x$7, x$10, x$11, (Option<Object>)x$6, 0L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectDivergingEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)logReadInfo.divergingEpoch.isPresent()));
        return logReadInfo;
    }

    private final void updateFetchState$1(int replicaId, Optional leaderEpoch, long brokerEpoch, long replicationSessionId, Partition partition$3, AbstractLog log$1) {
        Replica replica = (Replica)partition$3.getReplica(replicaId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Expected replica to be defined"));
        LogOffsetMetadata x$3 = new LogOffsetMetadata(7L);
        long x$5 = this.time().milliseconds();
        long x$6 = log$1.logEndOffset();
        partition$3.updateFollowerFetchState(replica, x$3, 0L, x$5, x$6, brokerEpoch, leaderEpoch, replicationSessionId);
    }

    public static final /* synthetic */ LogDeleteRecordsResult $anonfun$testLeaderOffsetsListenerNotifiesPushReplicasForLogStartOffsetIncrement$2(PushReplicationPartitionTest $this, int i) {
        return $this.partition().deleteRecordsOnLeader((long)i);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLeaderLogAppendListenerIgnoresFollowerEvents$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendToLog$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendToPartition$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public static final /* synthetic */ long $anonfun$assertReplicationSessionId$1(Replica x$17) {
        return x$17.stateSnapshot().replicationSessionState().replicationSessionId();
    }
}

