/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.replication.push.ReplicationState;
import io.confluent.kafka.replication.push.ReplicationStateMetadata;
import java.io.Serializable;
import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.MergedLog$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedReplicationSessionIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rr!\u0002\u0016,\u0011\u0003\u0001d!\u0002\u001a,\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%\t!\u0010\u0005\u0007\u0003\u0006\u0001\u000b\u0011\u0002 \t\u000f\t\u000b!\u0019!C\u0001\u0007\"1q*\u0001Q\u0001\n\u0011Cq\u0001U\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004V\u0003\u0001\u0006IA\u0015\u0004\u0005e-\u0002a\u000bC\u0003;\u0013\u0011\u0005q\u000bC\u0004Z\u0013\t\u0007I\u0011\u0001.\t\r\rL\u0001\u0015!\u0003\\\u0011%!\u0017\u00021AA\u0002\u0013\u0005Q\rC\u0005j\u0013\u0001\u0007\t\u0019!C\u0001U\"I\u0001/\u0003a\u0001\u0002\u0003\u0006KA\u001a\u0005\u0006c&!\tA\u001d\u0005\u0006}&!Ia \u0005\n\u0003{I\u0011\u0013!C\u0005\u0003\u007fA\u0011\"!\u0016\n#\u0003%I!a\u0016\t\u000f\u0005m\u0013\u0002\"\u0001\u0002^!9\u0011\u0011N\u0005\u0005\n\u0005-\u0004bBA=\u0013\u0011%\u00111\u0010\u0005\b\u0003+KA\u0011BAL\u0011\u001d\tI+\u0003C\u0005\u0003WCq!a,\n\t\u0013\t\t\f\u0003\u0004\u00026&!\tA\u001d\u0005\u0007\u0003\u007fKA\u0011\u0001:\t\r\u0005\r\u0017\u0002\"\u0001s\u0011\u0019\t9-\u0003C\u0001e\"1\u00111Z\u0005\u0005\u0002IDa!a4\n\t\u0003\u0011\bBBAj\u0013\u0011\u0005!\u000f\u0003\u0004\u0002X&!\tA\u001d\u0005\u0007\u00037LA\u0011\u0001:\t\r\u0005}\u0017\u0002\"\u0001s\u0011\u0019\t\u0019/\u0003C\u0001e\"1\u0011q]\u0005\u0005\u0002IDa!a;\n\t\u0003\u0011\bBBAx\u0013\u0011\u0005!\u000f\u0003\u0004\u0002t&!\tA\u001d\u0005\b\u0003oLA\u0011AA}\u0003-\u0011V\r\u001d7jG\u0006$Vm\u001d;\u000b\u00051j\u0013aB2mkN$XM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005Y#a\u0003*fa2L7-\u0019+fgR\u001c\"!\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001'\u0001\u0005Ce>\\WM]%e+\u0005q\u0004CA\u001b@\u0013\t\u0001eGA\u0002J]R\f\u0011B\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0013A\u000b'\u000f^5uS>tW#\u0001#\u0011\u0005\u0015kU\"\u0001$\u000b\u0005\u001dC\u0015AB2p[6|gN\u0003\u0002/\u0013*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h\u0013\tqeI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\u000b'\u000f^5uS>t\u0007%A\nSKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5/F\u0001S!\t)4+\u0003\u0002Um\t!Aj\u001c8h\u0003Q\u0011V\r\u001d7jG\u0006d\u0015m\u001a+j[\u0016l\u0015\r_'tAM\u0011\u0011\u0002\u000e\u000b\u00021B\u0011\u0011'C\u0001\u0005i&lW-F\u0001\\!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0003vi&d'B\u00011I\u0003\u0019\u0019XM\u001d<fe&\u0011!-\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!/\u001a9mS\u000e\fW#\u00014\u0011\u0005E:\u0017B\u00015,\u0005\u001d\u0011V\r\u001d7jG\u0006\f1B]3qY&\u001c\u0017m\u0018\u0013fcR\u00111N\u001c\t\u0003k1L!!\u001c\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b_:\t\t\u00111\u0001g\u0003\rAH%M\u0001\te\u0016\u0004H.[2bA\u0005)1/\u001a;vaR\t1\u000e\u000b\u0002\u0011iB\u0011Q\u000f`\u0007\u0002m*\u0011q\u000f_\u0001\u0004CBL'BA={\u0003\u001dQW\u000f]5uKJT!a_&\u0002\u000b),h.\u001b;\n\u0005u4(A\u0003\"fM>\u0014X-R1dQ\u0006\u0011\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)=Y\u0017\u0011AA\u0003\u0003\u0013\ti!!\u0005\u0002\u0016\u0005}\u0001BBA\u0002#\u0001\u0007!+\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\r\u0005\u001d\u0011\u00031\u0001S\u00031awnZ#oI>3gm]3u\u0011\u0019\tY!\u0005a\u0001%\u0006\u0011B.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z't\u0011\u0019\ty!\u0005a\u0001%\u0006YB.Y:u\r\u0016$8\r\u001b'fC\u0012,'\u000fT8h\u000b:$wJ\u001a4tKRDa!a\u0005\u0012\u0001\u0004\u0011\u0016a\u00047bgR4U\r^2i)&lW-T:\t\u0013\u0005]\u0011\u0003%AA\u0002\u0005e\u0011a\u00032s_.,'/\u00129pG\"\u0004B!NA\u000e%&\u0019\u0011Q\u0004\u001c\u0003\r=\u0003H/[8o\u0011%\t\t#\u0005I\u0001\u0002\u0004\t\u0019#A\fsKBd\u0017nY1uS>t7+Z:tS>t7\u000b^1uKB!\u0011QEA\u001d\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00029vg\"TA!!\f\u00020\u0005Y!/\u001a9mS\u000e\fG/[8o\u0015\rq\u0013\u0011\u0007\u0006\u0005\u0003g\t)$A\u0005d_:4G.^3oi*\u0011\u0011qG\u0001\u0003S>LA!a\u000f\u0002(\tA\"+\u001a9mS\u000e\fG/[8o'R\fG/Z'fi\u0006$\u0017\r^1\u00029\u0005\u001c8/\u001a:u%\u0016\u0004H.[2b'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011\u0011\t\u0016\u0005\u00033\t\u0019e\u000b\u0002\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!C;oG\",7m[3e\u0015\r\tyEN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA*\u0003\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q\t7o]3siJ+\u0007\u000f\\5dCN#\u0018\r^3%I\u00164\u0017-\u001e7uI]*\"!!\u0017+\t\u0005\r\u00121I\u0001 CN\u001cXM\u001d;SKBd\u0017nY1Ti\u0006$X\rR8fg:{Go\u00115b]\u001e,GcA6\u0002`!A\u0011\u0011\r\u000b\u0005\u0002\u0004\t\u0019'\u0001\u0002paB!Q'!\u001al\u0013\r\t9G\u000e\u0002\ty\tLh.Y7f}\u0005\u0001R\u000f\u001d3bi\u00164U\r^2i'R\fG/\u001a\u000b\b%\u00065\u0014\u0011OA;\u0011\u0019\ty'\u0006a\u0001%\u0006\u0019bm\u001c7m_^,'OR3uG\"|eMZ:fi\"1\u00111O\u000bA\u0002I\u000b1CZ8mY><XM]*uCJ$xJ\u001a4tKRDa!a\u001e\u0016\u0001\u0004\u0011\u0016a\u00047fC\u0012,'/\u00128e\u001f\u001a47/\u001a;\u00021U\u0004H-\u0019;f%\u0016\u0004H.[2bi&|gnU3tg&|g\u000eF\u0004l\u0003{\ny(a!\t\r\u0005]a\u00031\u0001S\u0011\u0019\t\tI\u0006a\u0001%\u0006!\"/\u001a9mS\u000e\fG/[8o'\u0016\u001c8/[8o\u0013\u0012Dq!!\"\u0017\u0001\u0004\t9)A\bsKBd\u0017nY1uS>tWj\u001c3f!\u0011\tI)a$\u000f\t\u0005\u0015\u00121R\u0005\u0005\u0003\u001b\u000b9#\u0001\tSKBd\u0017nY1uS>t7\u000b^1uK&!\u0011\u0011SAJ\u0005\u0011iu\u000eZ3\u000b\t\u00055\u0015qE\u0001\u0012e\u0016\u001cX\r\u001e*fa2L7-Y*uCR,Gc\u0002*\u0002\u001a\u0006m\u0015Q\u0015\u0005\u0007\u0003o:\u0002\u0019\u0001*\t\u000f\u0005uu\u00031\u0001\u0002 \u0006Y\u0011n\u001d(fo2+\u0017\rZ3s!\r)\u0014\u0011U\u0005\u0004\u0003G3$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003O;\u0002\u0019AAP\u0003AI7OR8mY><XM]%o'ft7-\u0001\u000enCf\u0014WMU3tKRd\u0015m\u001d;DCV<\u0007\u000e^+q)&lW\rF\u0002S\u0003[Ca!a\u001e\u0019\u0001\u0004\u0011\u0016AC5t\u0007\u0006,x\r\u001b;VaR!\u0011qTAZ\u0011\u0019\t9(\u0007a\u0001%\u0006\u0001B/Z:u\u0013:LG/[1m'R\fG/\u001a\u0015\u00045\u0005e\u0006cA;\u0002<&\u0019\u0011Q\u0018<\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH/\u00169eCR,g)\u001a;dQN#\u0018\r^3)\u0007m\tI,\u0001\u001fuKN$(+Z:fiJ+\u0007\u000f\\5dCN#\u0018\r^3XQ\u0016tG*Z1eKJL5OU3fY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5/\u00138Ts:\u001c\u0007f\u0001\u000f\u0002:\u0006yD/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u0019\u0016\fG-\u001a:JgJ+W\r\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1Jg:{G/\u00138Ts:\u001c\u0007fA\u000f\u0002:\u0006iD/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u001d\u0016<H*Z1eKJL5/\u00127fGR,G-\u00118e%\u0016\u0004H.[2b\u0013NLenU=oG\"\u001aa$!/\u0002\u0001R,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c(fo2+\u0017\rZ3s\u0013N,E.Z2uK\u0012\fe\u000e\u001a*fa2L7-Y%t\u001d>$\u0018J\\*z]\u000eD3aHA]\u0003e!Xm\u001d;SKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3)\u0007\u0001\nI,A$uKN$(+Z:fi2\u000b7\u000f^\"bk\u001eDG/\u00169US6,\u0017j\u001d(piJ+7/\u001a;BMR,'\u000fT3bI\u0016\u0014X\t\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1O_RLe.S:sQ\r\t\u0013\u0011X\u0001Hi\u0016\u001cH\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Jg:{GOU3tKR<\u0006.\u001a8Va\u0012\fG/\u001a$fi\u000eD7\u000b^1uK^KG\u000f[*uC2,Gj\\4F]\u0012|eMZ:fi\"\u001a!%!/\u0002qQ,7\u000f\u001e*fa2L7-Y*i_VdGMT8u\u0005\u0016\u001c\u0015-^4iiV\u0003x\u000b[3o+NLgnZ*uC2,Gj\\4F]\u0012|eMZ:fi\"\u001a1%!/\u0002WQ,7\u000f^%t\u0007\u0006,x\r\u001b;Va^CWM\u001c*fa2L7-Y%t\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D3\u0001JA]\u00039\"Xm\u001d;Jg\u000e\u000bWo\u001a5u+B<\u0006.\u001a8SKBd\u0017nY1Jg:{GoQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0007\u0015\nI,A&uKN$\u0018j]\"bk\u001eDG/\u00169US6,\u0017j\u001d(pi\u0006cw/Y=t%\u0016\u001cX\r^,iK:4u\u000e\u001c7po\u0016\u0014\u0018j]\"bk\u001eDG/\u00169U_N#\u0018\r\\3M_\u001e,e\u000eZ(gMN,G\u000fK\u0002'\u0003s\u000bA\u0003^3tiR\u0013\u0018M\\:ji&|g\u000eV8QkND\u0007fA\u0014\u0002:\u0006!B/Z:u)J\fgn]5uS>tGk\u001c)vY2D3\u0001KA]\u0003U!Xm\u001d;GK:\u001cWm\u0015;bY\u0016,\u0006\u000fZ1uKN$2a[A~\u0011\u001d\ti0\u000ba\u0001\u0003?\u000bq![:Le\u00064G\u000fK\u0002*\u0005\u0003\u0001BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0004\u0005\u000fA\u0018A\u00029be\u0006l7/\u0003\u0003\u0003\f\t\u0015!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":\u0011Fa\u0004\u0003\u001c\tu\u0001\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\t\tU!QA\u0001\taJ|g/\u001b3fe&!!\u0011\u0004B\n\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCAa\b\u0003\"e\t\u0011!G\u0001\u0001\u0001")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), (MetadataCache)metadataCache));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, Option<Object> brokerEpoch, ReplicationStateMetadata replicationSessionState) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
        Assertions.assertEquals(brokerEpoch, (Object)replicaState.brokerEpoch(), (String)"Broker Epoch Mismatch");
        Assertions.assertEquals((Object)replicationSessionState, (Object)replicaState.replicationSessionState());
    }

    private Option<Object> assertReplicaState$default$6() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
    }

    private ReplicationStateMetadata assertReplicaState$default$7() {
        return ReplicationStateMetadata.INITIAL;
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchStateOrThrow(new LogOffsetMetadata(followerFetchOffset), followerStartOffset, currentTimeMs, leaderEndOffset, 1L, -1L);
        return currentTimeMs;
    }

    private void updateReplicationSession(long brokerEpoch, long replicationSessionId, ReplicationState.Mode replicationMode) {
        this.replica().updateReplicationSessionState(brokerEpoch, replicationSessionId, replicationMode);
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private long maybeResetLastCaughtUpTime(long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().maybeResetLastCaughtUpTime(currentTimeMs, leaderEndOffset);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L, (Option<Object>)Option$.MODULE$.empty(), ReplicationStateMetadata.INITIAL);
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.updateReplicationSession(2L, 1L, ReplicationState.Mode.PULL);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2L)), new ReplicationStateMetadata(ReplicationState.Mode.PULL, 1L));
        this.time().sleep(1000L);
        long fetchTimeMs4 = this.time().milliseconds();
        Assertions.assertThrows(FencedReplicationSessionIdException.class, () -> this.replica().updateFetchStateOrThrow(new LogOffsetMetadata(18L), 4L, fetchTimeMs4, 19L, 2L, 0L));
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        ReplicationStateMetadata x$6 = ReplicationStateMetadata.INITIAL;
        Option x$7 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)x$7, x$6);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.updateReplicationSession(1L, 5L, ReplicationState.Mode.PULL);
        this.resetReplicaState(11L, false, false);
        ReplicationStateMetadata x$6 = ReplicationStateMetadata.INITIAL;
        Option x$7 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L, (Option<Object>)x$7, x$6);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.updateReplicationSession(1L, 5L, ReplicationState.Mode.PULL);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), resetTimeMs1, MergedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty(), ReplicationStateMetadata.INITIAL);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.updateReplicationSession(1L, 5L, ReplicationState.Mode.PULL);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, MergedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty(), ReplicationStateMetadata.INITIAL);
    }

    @Test
    public void testResetLastCaughtUpTime() {
        this.updateFetchState(5L, 1L, 10L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(15L));
        this.time().sleep(1000L);
        this.updateFetchState(10L, 1L, 15L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        this.time().sleep(1000L);
        this.updateFetchState(16L, 1L, 16L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(17L);
        this.assertReplicaState(1L, 16L, resetTimeMs1, 17L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
    }

    @Test
    public void testResetLastCaughtUpTimeIsNotResetAfterLeaderElectedAndReplicaNotInIsr() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(10L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 10L, 0L, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
    }

    @Test
    public void testLastCaughtUpTimeIsNotResetWhenUpdateFetchStateWithStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
    }

    @Test
    public void testReplicaShouldNotBeCaughtUpWhenUsingStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(0L, 0L, 10L);
        this.assertReplicaState(0L, 0L, 0L, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(12L));
        this.updateFetchState(10L, 1L, 10L);
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(12L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @Test
    public void testIsCaughtUpTimeIsNotAlwaysResetWhenFollowerIsCaughtUpToStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        Assertions.assertTrue((boolean)this.isCaughtUp(11L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(12L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        Assertions.assertTrue((boolean)this.isCaughtUp(12L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(13L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), ReplicationStateMetadata.INITIAL);
        Assertions.assertTrue((boolean)this.isCaughtUp(13L));
        this.time().sleep(1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(13L));
    }

    @Test
    public void testTransitionToPush() {
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canTransitionToPush(1L, -1L));
        long fetchTimeMs = this.time().milliseconds();
        this.updateFetchState(5L, 2L, 6L);
        this.replica().updateReplicationSessionState(1L, 1L, ReplicationState.Mode.PULL);
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canTransitionToPush(0L, 1L));
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canTransitionToPush(1L, 0L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.replica().updateReplicationSessionState(1L, 0L, ReplicationState.Mode.PUSH));
        Assertions.assertThrows(IllegalStateException.class, () -> this.replica().updateReplicationSessionState(0L, 1L, ReplicationState.Mode.PUSH));
        this.assertReplicaState(2L, 5L, 0L, 6L, fetchTimeMs, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), new ReplicationStateMetadata(ReplicationState.Mode.PULL, 1L));
        this.time().sleep(1000L);
        Assertions.assertTrue((boolean)this.replica().stateSnapshot().canTransitionToPush(1L, 1L));
        this.replica().updateReplicationSessionState(1L, 1L, ReplicationState.Mode.PUSH);
        this.assertReplicaState(2L, 5L, 0L, 6L, fetchTimeMs, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), new ReplicationStateMetadata(ReplicationState.Mode.PUSH, 1L));
    }

    @Test
    public void testTransitionToPull() {
        long fetchTimeMs = this.time().milliseconds();
        this.updateFetchState(5L, 2L, 6L);
        this.time().sleep(1000L);
        this.replica().updateReplicationSessionState(1L, 1L, ReplicationState.Mode.PUSH);
        this.assertReplicaState(2L, 5L, 0L, 6L, fetchTimeMs, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), new ReplicationStateMetadata(ReplicationState.Mode.PUSH, 1L));
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canUpdateBrokerEpochOrReplicationSession(1L, 1L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.replica().updateReplicationSessionState(1L, 1L, ReplicationState.Mode.PULL));
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canUpdateBrokerEpochOrReplicationSession(0L, 2L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.replica().updateReplicationSessionState(0L, 2L, ReplicationState.Mode.PULL));
        Assertions.assertFalse((boolean)this.replica().stateSnapshot().canUpdateBrokerEpochOrReplicationSession(1L, 0L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.replica().updateReplicationSessionState(1L, 0L, ReplicationState.Mode.PULL));
        this.assertReplicaState(2L, 5L, 0L, 6L, fetchTimeMs, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), new ReplicationStateMetadata(ReplicationState.Mode.PUSH, 1L));
        Assertions.assertTrue((boolean)this.replica().stateSnapshot().canUpdateBrokerEpochOrReplicationSession(2L, 0L));
        Assertions.assertTrue((boolean)this.replica().stateSnapshot().canUpdateBrokerEpochOrReplicationSession(1L, 2L));
        this.replica().updateReplicationSessionState(2L, 0L, ReplicationState.Mode.PULL);
        this.assertReplicaState(2L, 5L, 0L, 6L, fetchTimeMs, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2L)), new ReplicationStateMetadata(ReplicationState.Mode.PULL, 0L));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFenceStaleUpdates(boolean isKraft) {
        MetadataCache metadataCache;
        if (isKraft) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
            Mockito.when((Object)kRaftMetadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L)));
            metadataCache = kRaftMetadataCache;
        } else {
            metadataCache = (MetadataCache)Mockito.mock(ZkMetadataCache.class);
        }
        MetadataCache metadataCache2 = metadataCache;
        Replica replica = new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), metadataCache2);
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 1L, 1L, 10L, 2L, -1L);
        if (isKraft) {
            Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 3L, 10L, 1L, -1L));
        } else {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 3L, 10L, 1L, -1L);
        }
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 4L, 10L, -1L, -1L);
    }
}

