/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersSnapshot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AliveBrokersSnapshotTest {
    private final Map<Integer, Long> liveBrokerIdsAndEpochs = new HashMap<Integer, Long>();
    private final Set<Integer> brokerReplicaExclusions = new HashSet<Integer>();
    private final Set<Integer> demotedBrokers = new HashSet<Integer>();

    @BeforeEach
    public void setUp() {
        this.liveBrokerIdsAndEpochs.put(1, 1L);
        this.liveBrokerIdsAndEpochs.put(2, 2L);
        this.liveBrokerIdsAndEpochs.put(3, 3L);
        this.brokerReplicaExclusions.add(3);
    }

    @Test
    public void testSnapshot() {
        Set<Integer> excludedBrokers = Collections.singleton(3);
        Set<Integer> demotedBrokers = Collections.singleton(4);
        HashMap<Integer, Long> liveBrokerIdsAndEpochs = new HashMap<Integer, Long>();
        liveBrokerIdsAndEpochs.put(1, 10L);
        liveBrokerIdsAndEpochs.put(2, 20L);
        AliveBrokersSnapshot snapshot = new AliveBrokersSnapshot(liveBrokerIdsAndEpochs, excludedBrokers, demotedBrokers);
        Assertions.assertEquals(Optional.of(10L), (Object)snapshot.epochFor(1));
        Assertions.assertEquals(Optional.of(20L), (Object)snapshot.epochFor(2));
        Assertions.assertEquals(Optional.empty(), (Object)snapshot.epochFor(3), (String)"Expected an empty epoch optional because broker 3 is not alive");
        Assertions.assertEquals(demotedBrokers, (Object)snapshot.demotedBrokers());
        Assertions.assertEquals(excludedBrokers, (Object)snapshot.replicaExclusions());
        Assertions.assertEquals(Optional.empty(), (Object)snapshot.endpointFor(null), (String)"endpointFor should always return an empty optional");
        Assertions.assertEquals(liveBrokerIdsAndEpochs.keySet(), (Object)snapshot.aliveBrokers());
    }

    @Test
    public void testEquals() {
        AliveBrokersSnapshot snapshot1 = new AliveBrokersSnapshot(this.liveBrokerIdsAndEpochs, this.brokerReplicaExclusions, this.demotedBrokers);
        AliveBrokersSnapshot snapshot2 = new AliveBrokersSnapshot(this.liveBrokerIdsAndEpochs, this.brokerReplicaExclusions, this.demotedBrokers);
        Assertions.assertEquals((Object)snapshot1, (Object)snapshot2);
        AliveBrokersSnapshot diffSnapshot = new AliveBrokersSnapshot(this.liveBrokerIdsAndEpochs, new HashSet(), this.demotedBrokers);
        Assertions.assertNotEquals((Object)snapshot1, (Object)diffSnapshot);
        Assertions.assertNotEquals((Object)snapshot2, (Object)diffSnapshot);
        Assertions.assertNotEquals((Object)snapshot1, (Object)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
        Assertions.assertNotEquals((Object)snapshot2, (Object)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
        Assertions.assertNotEquals((Object)diffSnapshot, (Object)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
    }

    @Test
    public void testIsEmpty() {
        AliveBrokersSnapshot emptySnapshot = new AliveBrokersSnapshot(Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
        Assertions.assertTrue((boolean)emptySnapshot.isEmpty(), (String)"Expected an empty snapshot to be empty");
        Assertions.assertTrue((boolean)AliveBrokersSnapshot.EMPTY_SNAPSHOT.isEmpty(), (String)"Expected the empty snapshot to be empty");
        AliveBrokersSnapshot snapshot = new AliveBrokersSnapshot(this.liveBrokerIdsAndEpochs, this.brokerReplicaExclusions, this.demotedBrokers);
        Assertions.assertFalse((boolean)snapshot.isEmpty(), (String)"Expected the snapshot with something in it to NOT be empty");
    }
}

