/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.QueueItem;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004:\u0001\u0001\u0006IA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!)q\t\u0001C\u0001\u0011\")\u0011\f\u0001C\u0001\u0011\")a\f\u0001C\u0001\u0011\")\u0001\r\u0001C\u0001\u0011\")!\r\u0001C\u0001\u0011\")A\r\u0001C\u0001\u0011\")a\r\u0001C\u0001\u0011\")\u0001\u000e\u0001C\u0001\u0011\")!\u000e\u0001C\u0001W\u001a9A\u000f\u0001I\u0001$\u0003)\bbBA\u0001\u001f\u0019\u0005\u00111\u0001\u0004\u0007\u00037\u0001\u0001!!\b\t\u0015\u0005%\u0012C!b\u0001\n\u0003\tY\u0003\u0003\u0006\u00024E\u0011\t\u0011)A\u0005\u0003[A\u0011\u0002]\t\u0003\u0006\u0004%\t!!\u000e\t\u0013\u0005]\u0012C!A!\u0002\u0013\t\bB\u0002\u0019\u0012\t\u0003\tI\u0004C\u0005\u0002BE\u0011\r\u0011\"\u0001\u0002D!A\u0011qJ\t!\u0002\u0013\t)\u0005\u0003\u0004\u0002RE!\t\u0001\u0013\u0005\b\u0003\u0003\tB\u0011AA*\r\u0019\t)\u0006\u0001\u0001\u0002X!Q\u0011\u0011F\u000e\u0003\u0006\u0004%\t!a\u000b\t\u0015\u0005M2D!A!\u0002\u0013\ti\u0003\u0003\u000417\u0011\u0005\u00111\f\u0005\n\u0003\u0003Z\"\u0019!C\u0001\u0003CB\u0001\"a\u0014\u001cA\u0003%\u00111\r\u0005\u0007\u0003#ZB\u0011\u0001%\t\u000f\u0005\u00051\u0004\"\u0001\u0002f\tA2i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"$Vm\u001d;\u000b\u0005\u00152\u0013AC2p]R\u0014x\u000e\u001c7fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005Aa\u000e\u00165sK\u0006$7/F\u00017!\tYs'\u0003\u00029Y\t\u0019\u0011J\u001c;\u0002\u00139$\u0006N]3bIN\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003q\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012 \u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0013\t\u0003W)K!a\u0013\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003\r5\u0003\"AT,\u000e\u0003=S!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S'\u00069!.\u001e9ji\u0016\u0014(B\u0001+V\u0003\u0015QWO\\5u\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0014\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0003^3ti\u000e\u000bg\u000eU;u\u0003:$G+Y6fQ\t91\f\u0005\u0002O9&\u0011Ql\u0014\u0002\u0005)\u0016\u001cH/A\ruKN$\b+\u001e;NKJ<W-\u00118e\u0013:4\u0018\r\\5eCR,\u0007F\u0001\u0005\\\u0003e!Xm\u001d;QkR\u0014Vm\u001d9fGR\u0014En\\2l'R\fG/^:)\u0005%Y\u0016!\u0007;fgR\u0004V\u000f\u001e*f[>4X-R7qif\u0014\u0015\r^2iKND#AC.\u0002\u001dQ,7\u000f\u001e+bW\u0016\u0014En\\2lg\"\u00121bW\u0001(i\u0016\u001cHoQ8oGV\u0014(/\u001a8u!V$8/\u00118e)\u0006\\Wm]%o%\u0006tGm\\7Pe\u0012,'\u000f\u000b\u0002\r7\u0006IA/Z:u\u00072|7/\u001a\u0015\u0003\u001bm\u000bAB\\3x#V,W/Z%uK6$\"\u0001\\8\u0011\u0005Mj\u0017B\u00018%\u0005%\tV/Z;f\u0013R,W\u000eC\u0003q\u001d\u0001\u0007\u0011/A\u0003cCR\u001c\u0007\u000e\u0005\u00024e&\u00111\u000f\n\u0002\u0015\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195\u0003\r\u0005\u001bG/[8o+\r1\u0018\u0011B\n\u0004\u001f]l\bC\u0001=|\u001b\u0005I(B\u0001>C\u0003\u0011a\u0017M\\4\n\u0005qL(AB(cU\u0016\u001cG\u000f\u0005\u0002y}&\u0011q0\u001f\u0002\t%Vtg.\u00192mK\u0006)\u0011m^1jiR\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI\u0001\u0004\u0001\u0005\u000f\u0005-qB1\u0001\u0002\u000e\t\tA+\u0005\u0003\u0002\u0010\u0005U\u0001cA\u0016\u0002\u0012%\u0019\u00111\u0003\u0017\u0003\u000f9{G\u000f[5oOB\u00191&a\u0006\n\u0007\u0005eAFA\u0002B]f\u00141\u0001U;u'\u0011\tr/a\b\u0011\u000b\u0005\u0005r\"a\t\u000e\u0003\u0001\u00012aKA\u0013\u0013\r\t9\u0003\f\u0002\b\u0005>|G.Z1o\u0003\u0015\tX/Z;f+\t\ti\u0003E\u00024\u0003_I1!!\r%\u0005i\u0019uN\u001c;s_2lU\r^1eCR\f\u0017iY2v[Vd\u0017\r^8s\u0003\u0019\tX/Z;fAU\t\u0011/\u0001\u0004cCR\u001c\u0007\u000e\t\u000b\u0007\u0003w\ti$a\u0010\u0011\u0007\u0005\u0005\u0012\u0003C\u0004\u0002*Y\u0001\r!!\f\t\u000bA4\u0002\u0019A9\u0002\u000fA\u0014x.\\5tKV\u0011\u0011Q\t\t\u0007\u0003\u000f\nY%a\t\u000e\u0005\u0005%#BA -\u0013\u0011\ti%!\u0013\u0003\u000fA\u0013x.\\5tK\u0006A\u0001O]8nSN,\u0007%A\u0002sk:$\"!a\t\u0003\tQ\u000b7.Z\n\u00057]\fI\u0006\u0005\u0003\u0002\"=\tH\u0003BA/\u0003?\u00022!!\t\u001c\u0011\u001d\tIC\ba\u0001\u0003[)\"!a\u0019\u0011\u000b\u0005\u001d\u00131J9\u0015\u0003E\u0004")
public class ControlMetadataBatchTest {
    private final int nThreads;
    private final ExecutorService executor = Executors.newFixedThreadPool(this.nThreads());

    public int nThreads() {
        return this.nThreads;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    @AfterEach
    public void tearDown() {
        if (this.executor() != null) {
            this.executor().shutdownNow();
            return;
        }
    }

    @Test
    public void testCanPutAndTake() {
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        StopReplicaBatch stopReplica = new StopReplicaBatch(0).addPartitionState(new TopicPartition("topic", 0), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setLeaderEpoch(0));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica));
        Assertions.assertEquals((Object)accumulator.take().batch(), (Object)stopReplica);
    }

    @Test
    public void testPutMergeAndInvalidate() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(2));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        StopReplicaBatch stopReplica2 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(3));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica2));
        Assertions.assertEquals((int)2, (int)accumulator.size());
        QueueItem firstItem = accumulator.take();
        Assertions.assertTrue((boolean)(firstItem.batch() instanceof LeaderAndIsrBatch));
        LeaderAndIsrBatch takenLeaderAndIsr = (LeaderAndIsrBatch)firstItem.batch();
        Assertions.assertEquals((int)1, (int)takenLeaderAndIsr.partitions().size());
        Assertions.assertNotNull((Object)takenLeaderAndIsr.partitions().get((Object)tp1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        QueueItem secondItem = accumulator.take();
        Assertions.assertTrue((boolean)(secondItem.batch() instanceof StopReplicaBatch));
        StopReplicaBatch takenStopReplica = (StopReplicaBatch)secondItem.batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica.partitions().get((Object)tp0).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testPutRespectBlockStatus() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 3);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(0));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).addPartitionState(tp2, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).setContainsAllReplicas();
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        LeaderAndIsrBatch leaderAndIsr2 = new LeaderAndIsrBatch(0).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(3)).addPartitionState(tp2, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(3));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr2));
        StopReplicaBatch stopReplica2 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(4));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica2));
        Assertions.assertEquals((int)3, (int)accumulator.size());
        StopReplicaBatch takenStopReplica1 = (StopReplicaBatch)accumulator.take().batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica1.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica1.partitions().get((Object)tp0).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        LeaderAndIsrBatch takenLeaderAndIsr1 = (LeaderAndIsrBatch)accumulator.take().batch();
        Assertions.assertEquals((int)2, (int)takenLeaderAndIsr1.partitions().size());
        Assertions.assertNotNull((Object)takenLeaderAndIsr1.partitions().get((Object)tp1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Assertions.assertNotNull((Object)takenLeaderAndIsr1.partitions().get((Object)tp2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        StopReplicaBatch takenStopReplica2 = (StopReplicaBatch)accumulator.take().batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica2.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica2.partitions().get((Object)tp1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testPutRemoveEmptyBatches() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(2));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        Assertions.assertEquals((int)1, (int)accumulator.size());
        QueueItem item1 = accumulator.take();
        Assertions.assertTrue((boolean)(item1.batch() instanceof StopReplicaBatch));
        StopReplicaBatch takenStopReplica1 = (StopReplicaBatch)item1.batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica1.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica1.partitions().get((Object)tp0).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)0, (int)accumulator.size());
    }

    @Test
    public void testTakeBlocks() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 2);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        IndexedSeq futures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)x$1 -> ControlMetadataBatchTest.$anonfun$testTakeBlocks$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$1)));
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataBatchTest.$anonfun$testTakeBlocks$3(x$2))));
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        UpdateMetadataBatch updateMetadata1 = new UpdateMetadataBatch(0).addPartitionState(tp2, new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)updateMetadata1));
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataBatchTest.$anonfun$testTakeBlocks$4(x$3))));
        accumulator.close();
    }

    @Test
    public void testConcurrentPutsAndTakesInRandomOrder() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 2);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(1));
        UpdateMetadataBatch updateMetadata1 = new UpdateMetadataBatch(0).addPartitionState(tp2, new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeaderEpoch(1));
        .colon.colon puts = new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)leaderAndIsr1), (List)new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)stopReplica1), (List)new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)updateMetadata1), (List)Nil$.MODULE$)));
        IndexedSeq takes = puts.indices().map((Function1 & Serializable)x$4 -> ControlMetadataBatchTest.$anonfun$testConcurrentPutsAndTakesInRandomOrder$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$4)));
        ((List)Random$.MODULE$.shuffle((IterableOnce)puts.$plus$plus((IterableOnce)takes), BuildFrom$.MODULE$.buildFromIterableOps())).map((Function1 & Serializable)x$1 -> this.executor().submit((Runnable)x$1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true})), (Object)puts.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.await())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ControlMetadataBatch[]{leaderAndIsr1, stopReplica1, updateMetadata1})), (Object)((IterableOnceOps)takes.map((Function1 & Serializable)x$6 -> x$6.await())).toSet());
    }

    @Test
    public void testClose() {
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        IndexedSeq futures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)x$7 -> ControlMetadataBatchTest.$anonfun$testClose$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$7)));
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataBatchTest.$anonfun$testClose$3(x$8))));
        accumulator.close();
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataBatchTest.$anonfun$testClose$4(x$9))));
    }

    public QueueItem newQueueItem(ControlMetadataBatch batch) {
        return new QueueItem(batch, (Function2 & Serializable)(x$10, x$11) -> {
            ControlMetadataBatchTest.$anonfun$newQueueItem$1(x$10, x$11);
            return BoxedUnit.UNIT;
        }, Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ Future $anonfun$testTakeBlocks$1(ControlMetadataBatchTest $this, ControlMetadataAccumulator accumulator$1, int x$1) {
        return $this.executor().submit(() -> accumulator$1.take());
    }

    public static final /* synthetic */ boolean $anonfun$testTakeBlocks$3(Future x$2) {
        return !x$2.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testTakeBlocks$4(Future x$3) {
        return x$3.get() instanceof QueueItem;
    }

    public static final /* synthetic */ Take $anonfun$testConcurrentPutsAndTakesInRandomOrder$1(ControlMetadataBatchTest $this, ControlMetadataAccumulator accumulator$2, int x$4) {
        return new Take($this, accumulator$2);
    }

    public static final /* synthetic */ Future $anonfun$testClose$1(ControlMetadataBatchTest $this, ControlMetadataAccumulator accumulator$3, int x$7) {
        return $this.executor().submit(() -> accumulator$3.take());
    }

    public static final /* synthetic */ boolean $anonfun$testClose$3(Future x$8) {
        return !x$8.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testClose$4(Future x$9) {
        return x$9.get() == null;
    }

    public static final /* synthetic */ void $anonfun$newQueueItem$1(ControlMetadataBatch x$10, ControlMetadataBatchResult x$11) {
    }

    public ControlMetadataBatchTest() {
        this.nThreads = 5;
    }

    public interface Action<T>
    extends Runnable {
        public T await();
    }

    public class Put
    implements Action<Object> {
        private final ControlMetadataAccumulator queue;
        private final ControlMetadataBatch batch;
        private final Promise<Object> promise;
        public final /* synthetic */ ControlMetadataBatchTest $outer;

        public ControlMetadataAccumulator queue() {
            return this.queue;
        }

        public ControlMetadataBatch batch() {
            return this.batch;
        }

        public Promise<Object> promise() {
            return this.promise;
        }

        @Override
        public void run() {
            this.queue().put(this.kafka$controller$ControlMetadataBatchTest$Put$$$outer().newQueueItem(this.batch()));
            this.promise().success((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        @Override
        public boolean await() {
            return BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)this.promise().future(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
        }

        public /* synthetic */ ControlMetadataBatchTest kafka$controller$ControlMetadataBatchTest$Put$$$outer() {
            return this.$outer;
        }

        public Put(ControlMetadataBatchTest $outer, ControlMetadataAccumulator queue, ControlMetadataBatch batch) {
            this.queue = queue;
            this.batch = batch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.promise = Promise$.MODULE$.apply();
        }
    }

    public class Take
    implements Action<ControlMetadataBatch> {
        private final ControlMetadataAccumulator queue;
        private final Promise<ControlMetadataBatch> promise;
        public final /* synthetic */ ControlMetadataBatchTest $outer;

        public ControlMetadataAccumulator queue() {
            return this.queue;
        }

        public Promise<ControlMetadataBatch> promise() {
            return this.promise;
        }

        @Override
        public void run() {
            QueueItem item = this.queue().take();
            if (item == null) {
                this.promise().success(null);
                return;
            }
            this.promise().success((Object)item.batch());
        }

        @Override
        public ControlMetadataBatch await() {
            return (ControlMetadataBatch)Await$.MODULE$.result((Awaitable)this.promise().future(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        }

        public /* synthetic */ ControlMetadataBatchTest kafka$controller$ControlMetadataBatchTest$Take$$$outer() {
            return this.$outer;
        }

        public Take(ControlMetadataBatchTest $outer, ControlMetadataAccumulator queue) {
            this.queue = queue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.promise = Promise$.MODULE$.apply();
        }
    }
}

