/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.DataBalanceManager;
import kafka.controller.DataBalanceManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.TestDataBalancer;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019\u0019\u0004\u0001)A\u0005[!9A\u0007\u0001b\u0001\n\u0003)\u0004B\u0002\u001f\u0001A\u0003%a\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003g\u0001\u0011\u0005q\rC\u0003t\u0001\u0011\u0005q\rC\u0003v\u0001\u0011\u0005q\rC\u0003x\u0001\u0011\u0005q\rC\u0003z\u0001\u0011%!\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\u0003-\u0011\u000bG/\u0019\"bY\u0006t7-Z'b]\u0006<WM\u001d+fgRT!!\u0005\n\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001#\u0001\u0004d_:4\u0017nZ\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005kRLGNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#A\u0003)s_B,'\u000f^5fg\u000691m\u001c8gS\u001e\u0004\u0013\u0001E3ya\u0016\u001cG/\u001a3F]\u0012\u0004x.\u001b8u+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0013\u0003\u001d\u0019G.^:uKJL!AM\u0018\u0003\u0011\u0015sG\rU8j]R\f\u0011#\u001a=qK\u000e$X\rZ#oIB|\u0017N\u001c;!\u0003EIg.\u001b;jC2\u0014%o\\6fe&sgm\\\u000b\u0002mA\u0011qGO\u0007\u0002q)\u0011\u0011HE\u0001\u0003u.L!a\u000f\u001d\u0003\u0015\t\u0013xn[3s\u0013:4w.\u0001\nj]&$\u0018.\u00197Ce>\\WM]%oM>\u0004\u0013A\u0007;fgR\u0014\u0015\r\\1oG\u0016\u00148\u000b^1ukN\u001c\u0015\r\u001c7cC\u000e\\GCA ])\r\u00015I\u0015\t\u0003/\u0005K!A\u0011\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\"\u0001\r!R\u0001\u0006KJ\u0014xN\u001d\t\u0003\rBk\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u0015.\u000baaY8n[>t'BA\nM\u0015\tie*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005E;%\u0001C!qS\u0016\u0013(o\u001c:\t\u000bMC\u0001\u0019\u0001+\u0002\u0013M$\u0018\r^;t\u001fB$\bcA\u0012V/&\u0011a\u000b\n\u0002\t\u001fB$\u0018n\u001c8bYB\u0011\u0001LW\u0007\u00023*\u0011!JE\u0005\u00037f\u0013\u0011EQ1mC:\u001cWM]*uCR,8\u000fR3tGJL\u0007\u000f^5p]&sG/\u001a:oC2DQ!\u0018\u0005A\u0002y\u000b\u0011b\u001d;biV\u001c(+\u001a4\u0011\u0007}#w+D\u0001a\u0015\t\t'-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003G\u0012\n!bY8oGV\u0014(/\u001a8u\u0013\t)\u0007MA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0003}!Xm\u001d;ECR\f')\u00197b]\u000e,'o\u0011:fCRLwN\\*vG\u000e,7o\u001d\u000b\u0002\u0001\"\u0012\u0011\"\u001b\t\u0003UFl\u0011a\u001b\u0006\u0003Y6\f1!\u00199j\u0015\tqw.A\u0004kkBLG/\u001a:\u000b\u0005At\u0015!\u00026v]&$\u0018B\u0001:l\u0005\u0011!Vm\u001d;\u0002{Q,7\u000f\u001e#bi\u0006\u0014\u0015\r\\1oG\u0016\u00148\t\\1tg2{\u0017\r\u001a$bS2,(/\u001a*fiV\u0014hn]#ya\u0016\u001cG/\u001a3CC2\fgnY3s'R\fG/^:)\u0005)I\u0017a\u0015;fgR$\u0015\r^1CC2\fgnY3s\u00072\f7o\u001d'pC\u00124\u0015-\u001b7ve\u0016\u0014V\r^;s]N,\u0005\u0010]3di\u0016$W\t_2faRLwN\u001c$s_6lU\r\u001e5pIN\u001c\u0015\r\u001c7fI\nK8*\u00194lC\u0006\u0003\u0018\u000e\u000b\u0002\fS\u0006IE/Z:u\t\u0006$\u0018MQ1mC:\u001cWM]\"mCN\u001cHj\\1e\r\u0006LG.\u001e:f%\u0016\u001cX\u000f\u001c;t\u0013:tun\u00149Ge>l7i\u001c8ue>dG.\u001a:J]Z|7.\u001a3NKRDw\u000eZ:)\u00051I\u0017a\u0006<bY&$G)\u0019;b\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s)\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@\u0013\u0003\u0019\u0019XM\u001d<fe&\u0019\u0011\u0011A?\u0003!Q+7\u000f\u001e#bi\u0006\u0014\u0015\r\\1oG\u0016\u0014\u0018!G5om\u0006d\u0017\u000e\u001a#bi\u0006\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ$\"!a\u0002\u0011\u0007}\tI!C\u0002\u0002\fA\u0011!\u0003R1uC\n\u000bG.\u00198dK6\u000bg.Y4fe\u0002")
public class DataBalanceManagerTest {
    private final Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2081", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
    private final EndPoint expectedEndpoint = EndPoint$.MODULE$.createEndPoint("PLAINTEXT://localhost:7078", Option$.MODULE$.empty());
    private final BrokerInfo initialBrokerInfo = BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{this.expectedEndpoint()}), Option$.MODULE$.empty()), MetadataVersion.latestTesting(), -1);

    public Properties config() {
        return this.config;
    }

    public EndPoint expectedEndpoint() {
        return this.expectedEndpoint;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void testBalancerStatusCallback(AtomicReference<BalancerStatusDescriptionInternal> statusRef, ApiError error, Optional<BalancerStatusDescriptionInternal> statusOpt) {
        statusRef.set(statusOpt.get());
    }

    @Test
    public void testDataBalancerCreationSuccess() {
        TestDataBalancer testDataBalancer = this.validDataBalanceManager();
        Endpoint actualBootstrapServerEndpoint = testDataBalancer.bootstrapServerEndpoint().get();
        Assertions.assertEquals((Object)this.expectedEndpoint().host(), (Object)actualBootstrapServerEndpoint.host());
        Assertions.assertEquals((int)this.expectedEndpoint().port(), (int)actualBootstrapServerEndpoint.port());
        Assertions.assertEquals((Object)this.expectedEndpoint().securityProtocol(), (Object)actualBootstrapServerEndpoint.securityProtocol());
        AtomicReference currentStatus = new AtomicReference();
        AtomicReference testBalancerStatus = new AtomicReference();
        testDataBalancer.balancerStatus((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal>)((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback)(error, statusOpt) -> this.testBalancerStatusCallback(currentStatus, error, statusOpt)));
        Assertions.assertNotNull(currentStatus.get());
        Assertions.assertNull(testBalancerStatus.get());
        new TestDataBalancer().balancerStatus((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal>)((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback)(error, statusOpt) -> this.testBalancerStatusCallback(testBalancerStatus, error, statusOpt)));
        Assertions.assertEquals(testBalancerStatus.get(), currentStatus.get(), (String)new StringBuilder(66).append("Test balancer status ").append(testBalancerStatus.get()).append(" doesn't match that of instantiated balancer ").append(currentStatus.get()).toString());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedBalancerStatus() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        AtomicReference managerStatus = new AtomicReference();
        Assertions.assertNull(managerStatus.get());
        dataBalanceManager.balancerStatus((error, statusOpt) -> this.testBalancerStatusCallback(managerStatus, error, statusOpt));
        Assertions.assertNotNull(managerStatus.get());
        Assertions.assertEquals((Object)BalancerStatus.LOAD_FAILURE, (Object)((BalancerStatusDescriptionInternal)managerStatus.get()).balancerStatus());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> dataBalanceManager.scheduleZkBrokerRemoval(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1 & Serializable)x -> DataBalanceManagerTest.$anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), true, (TopicsMetadataSnapshot)Mockito.mock(TopicsMetadataSnapshot.class), (AliveBrokersMetadata)AliveBrokersSnapshot.EMPTY_SNAPSHOT, error -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> dataBalanceManager.brokerRemovals((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> dataBalanceManager.brokerAdditions((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> dataBalanceManager.evenClusterLoadStatus((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testDataBalancerClassLoadFailureResultsInNoOpFromControllerInvokedMethods() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        dataBalanceManager.onElection((AliveBrokersMetadata)new AliveBrokersSnapshot(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)2L))}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().empty()).asJava()));
        dataBalanceManager.onResignation();
        dataBalanceManager.close();
        dataBalanceManager.updateConfig((KafkaConfig)Mockito.mock(KafkaConfig.class), (KafkaConfig)Mockito.mock(KafkaConfig.class));
        dataBalanceManager.onBrokersStartup(CollectionConverters$.MODULE$.SetHasAsJava((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), (AliveBrokersMetadata)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
        dataBalanceManager.onBrokersFailure(CollectionConverters$.MODULE$.SetHasAsJava((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava());
    }

    private TestDataBalancer validDataBalanceManager() {
        this.config().put("confluent.balancer.class", TestDataBalancer.class.getCanonicalName());
        return (TestDataBalancer)DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(this.config()), this.initialBrokerInfo());
    }

    private DataBalanceManager invalidDataBalanceManager() {
        this.config().put("confluent.balancer.class", "InvalidClassName -- This will throw an error on instantiation");
        return DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(this.config()), this.initialBrokerInfo());
    }

    public static final /* synthetic */ Integer $anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

