/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.AlterReplicaExclusionsResult;
import kafka.common.BrokerReplicaExclusion;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.BrokerChange$;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.ControllerEvent;
import kafka.controller.DataBalanceManager;
import kafka.controller.KafkaController;
import kafka.controller.KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$;
import kafka.controller.KafkaControllerTest$SuccessfulExclusionScenario$;
import kafka.server.BrokerFeatures;
import kafka.server.DelegationTokenManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ZkFinalizedFeatureCache;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00115c\u0001B,Y\u0001uCQ\u0001\u001a\u0001\u0005\u0002\u0015Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019i\b\u0001)A\u0005a\"9a\u0010\u0001b\u0001\n\u0003y\b\u0002CA\f\u0001\u0001\u0006I!!\u0001\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002\u00011A\u0005\u0002\u0005\u001d\u0002\"CA\u001b\u0001\u0001\u0007I\u0011AA\u001c\u0011!\t\u0019\u0005\u0001Q!\n\u0005%\u0002\"CA#\u0001\u0001\u0007I\u0011AA$\u0011%\t)\u0006\u0001a\u0001\n\u0003\t9\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0015BA%\u0011%\ti\u0006\u0001a\u0001\n\u0003\ty\u0006C\u0005\u0002l\u0001\u0001\r\u0011\"\u0001\u0002n!A\u0011\u0011\u000f\u0001!B\u0013\t\t\u0007C\u0005\u0002t\u0001\u0001\r\u0011\"\u0001\u0002v!I\u0011Q\u0010\u0001A\u0002\u0013\u0005\u0011q\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015)\u0003\u0002x!I\u0011Q\u0011\u0001A\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0001\u0003#C\u0001\"!&\u0001A\u0003&\u0011\u0011\u0012\u0005\n\u0003/\u0003\u0001\u0019!C\u0001\u00033C\u0011\"a0\u0001\u0001\u0004%\t!!1\t\u0011\u0005\u0015\u0007\u0001)Q\u0005\u00037C\u0011\"a2\u0001\u0001\u0004%\t!!3\t\u0013\u0005E\u0007\u00011A\u0005\u0002\u0005M\u0007\u0002CAl\u0001\u0001\u0006K!a3\t\u0013\u0005e\u0007\u00011A\u0005\u0002\u0005m\u0007\"CAu\u0001\u0001\u0007I\u0011AAv\u0011!\ty\u000f\u0001Q!\n\u0005u\u0007\"CAy\u0001\u0001\u0007I\u0011AAz\u0011%\tY\u0010\u0001a\u0001\n\u0003\ti\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0015BA{\u0011-\u0011\u0019\u0001\u0001a\u0001\u0002\u0004%\tA!\u0002\t\u0017\t5\u0001\u00011AA\u0002\u0013\u0005!q\u0002\u0005\f\u0005'\u0001\u0001\u0019!A!B\u0013\u00119\u0001C\u0005\u0003\u0016\u0001\u0011\r\u0011\"\u0001\u0003\u0018!A!q\u0004\u0001!\u0002\u0013\u0011I\u0002C\u0006\u0003\"\u0001\u0001\r\u00111A\u0005\u0002\t\r\u0002b\u0003B\u0018\u0001\u0001\u0007\t\u0019!C\u0001\u0005cA1B!\u000e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003&!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B)\u0001\u0011\u0005!\u0011\b\u0005\b\u00057\u0002A\u0011\u0001B\u001d\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005sAqA!\u001b\u0001\t\u0003\u0011I\u0004C\u0004\u0003n\u0001!\tA!\u000f\t\u000f\tE\u0004\u0001\"\u0001\u0003:!9!Q\u000f\u0001\u0005\u0002\te\u0002b\u0002B<\u0001\u0011\u0005!\u0011\u0010\u0005\n\u0005\u001f\u0003\u0011\u0013!C\u0001\u0005#CqAa*\u0001\t\u0003\u0011I\u0004C\u0004\u0003,\u0002!\tA!\u000f\t\u000f\t=\u0006\u0001\"\u0001\u0003:!9!1\u0017\u0001\u0005\u0002\te\u0002b\u0002B\\\u0001\u0011\u0005!\u0011\b\u0005\b\u0005w\u0003A\u0011\u0001B\u001d\u0011\u001d\u0011y\f\u0001C\u0001\u0005sAqAa1\u0001\t\u0003\u0011I\u0004C\u0004\u0003H\u0002!IA!3\t\u000f\re\u0002\u0001\"\u0003\u0004<!91Q\n\u0001\u0005\u0002\teraBB)\u0001!\u000511\u000b\u0004\b\u0007/\u0002\u0001\u0012AB-\u0011\u0019!7\t\"\u0001\u0004\\!91QL\"\u0005\u0002\r}saBBL\u0001!\u00051\u0011\u0014\u0004\b\u00077\u0003\u0001\u0012ABO\u0011\u0019!w\t\"\u0001\u0004 \"I1\u0011U$C\u0002\u0013\u000511\u0015\u0005\t\u0007g;\u0005\u0015!\u0003\u0004&\"91QW$\u0005\u0002\te\u0002bBB\\\u000f\u0012\u00051\u0011\u0018\u0005\b\u0007\u0017\u0004A\u0011\u0001B\u001d\u0011\u001d\u0019y\r\u0001C\u0005\u0007#Dqa!>\u0001\t\u0013\u00199\u0010C\u0004\u0004v\u0002!I\u0001b\u0007\t\u000f\u0011\r\u0002\u0001\"\u0003\u0005&\u001d9A\u0011\u0007-\t\u0002\u0011MbAB,Y\u0011\u0003!)\u0004\u0003\u0004e'\u0012\u0005Aq\u0007\u0005\b\ts\u0019F\u0011\u0001B\u001d\u0011\u001d!\u0019e\u0015C\u0001\u0005s\u00111cS1gW\u0006\u001cuN\u001c;s_2dWM\u001d+fgRT!!\u0017.\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\\\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\r\u0005\u0002h\u00015\t\u0001,A\u0010bYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"\u0014V-];fgR4VM]:j_:,\u0012A\u001b\t\u0003?.L!\u0001\u001c1\u0003\u000bMCwN\u001d;\u0002A\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\bNU3rk\u0016\u001cHOV3sg&|g\u000eI\u0001\u0005i&lW-F\u0001q!\t\t80D\u0001s\u0015\t\u0019H/A\u0003vi&d7O\u0003\u0002vm\u000611m\\7n_:T!aW<\u000b\u0005aL\u0018AB1qC\u000eDWMC\u0001{\u0003\ry'oZ\u0005\u0003yJ\u0014A\u0001V5nK\u0006)A/[7fA\u0005\u0019B/[3s)>\u0004\u0018nY'b]\u0006<WM](qiV\u0011\u0011\u0011\u0001\t\u0006?\u0006\r\u0011qA\u0005\u0004\u0003\u000b\u0001'AB(qi&|g\u000e\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u000bQ|\u0007/[2\u000b\u0007\u0005E!,\u0001\u0003uS\u0016\u0014\u0018\u0002BA\u000b\u0003\u0017\u0011\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002)QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014x\n\u001d;!\u0003IIg.\u001b;jC2\u0014%o\\6fe\u0016\u0003xn\u00195\u0016\u0005\u0005u\u0001cA0\u0002 %\u0019\u0011\u0011\u00051\u0003\t1{gnZ\u0001\u0014S:LG/[1m\u0005J|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\u0007G>tg-[4\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\",\u0001\u0004tKJ4XM]\u0005\u0005\u0003g\tiCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011\u0011HA !\ry\u00161H\u0005\u0004\u0003{\u0001'\u0001B+oSRD\u0011\"!\u0011\f\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\u0011i\\7\t\\5f]R,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014[\u0003\tQ8.\u0003\u0003\u0002T\u00055#!D&bM.\f'l[\"mS\u0016tG/\u0001\u0007{W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005e\u0003\"CA!\u001d\u0005\u0005\t\u0019AA%\u0003%Q8n\u00117jK:$\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003Oj!!!\u001a\u000b\u0007\u0005uC/\u0003\u0003\u0002j\u0005\u0015$aB'fiJL7m]\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005=\u0004\"CA!#\u0005\u0005\t\u0019AA1\u0003!iW\r\u001e:jGN\u0004\u0013!E5oSRL\u0017\r\u001c\"s_.,'/\u00138g_V\u0011\u0011q\u000f\t\u0005\u0003\u0017\nI(\u0003\u0003\u0002|\u00055#A\u0003\"s_.,'/\u00138g_\u0006)\u0012N\\5uS\u0006d'I]8lKJLeNZ8`I\u0015\fH\u0003BA\u001d\u0003\u0003C\u0011\"!\u0011\u0015\u0003\u0003\u0005\r!a\u001e\u0002%%t\u0017\u000e^5bY\n\u0013xn[3s\u0013:4w\u000eI\u0001\ri>\\WM\\'b]\u0006<WM]\u000b\u0003\u0003\u0013\u0003B!a\u000b\u0002\f&!\u0011QRA\u0017\u0005Y!U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014\u0018\u0001\u0005;pW\u0016tW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tI$a%\t\u0013\u0005\u0005s#!AA\u0002\u0005%\u0015!\u0004;pW\u0016tW*\u00198bO\u0016\u0014\b%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014XCAAN!\u0011\ti*!/\u000f\t\u0005}\u00151\u0017\b\u0005\u0003C\u000byK\u0004\u0003\u0002$\u00065f\u0002BAS\u0003Wk!!a*\u000b\u0007\u0005%F,\u0001\u0004=e>|GOP\u0005\u00027&\u0019\u0011q\u0006.\n\t\u0005E\u0016QF\u0001\u0005Y&t7.\u0003\u0003\u00026\u0006]\u0016AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefTA!!-\u0002.%!\u00111XA_\u0005-a\u0015N\\6NC:\fw-\u001a:\u000b\t\u0005U\u0016qW\u0001\u0017G2,8\u000f^3s\u0019&t7.T1oC\u001e,'o\u0018\u0013fcR!\u0011\u0011HAb\u0011%\t\tEGA\u0001\u0002\u0004\tY*A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%\u0001\bce>\\WM\u001d$fCR,(/Z:\u0016\u0005\u0005-\u0007\u0003BA\u0016\u0003\u001bLA!a4\u0002.\tq!I]8lKJ4U-\u0019;ve\u0016\u001c\u0018A\u00052s_.,'OR3biV\u0014Xm]0%KF$B!!\u000f\u0002V\"I\u0011\u0011I\u000f\u0002\u0002\u0003\u0007\u00111Z\u0001\u0010EJ|7.\u001a:GK\u0006$XO]3tA\u0005aa-Z1ukJ,7)Y2iKV\u0011\u0011Q\u001c\t\u0005\u0003?\f)/\u0004\u0002\u0002b*!\u00111]A\u0017\u0003!iW\r^1eCR\f\u0017\u0002BAt\u0003C\u0014qCW6GS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3\u0002!\u0019,\u0017\r^;sK\u000e\u000b7\r[3`I\u0015\fH\u0003BA\u001d\u0003[D\u0011\"!\u0011!\u0003\u0003\u0005\r!!8\u0002\u001b\u0019,\u0017\r^;sK\u000e\u000b7\r[3!\u0003=Y\u0017MZ6b\u0007>tGO]8mY\u0016\u0014XCAA{!\r9\u0017q_\u0005\u0004\u0003sD&aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002'-\fgm[1D_:$(o\u001c7mKJ|F%Z9\u0015\t\u0005e\u0012q \u0005\n\u0003\u0003\u001a\u0013\u0011!a\u0001\u0003k\f\u0001c[1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0011\u0002'\t\fG.\u00198dKJl\u0015M\\1hKJlunY6\u0016\u0005\t\u001d\u0001cA4\u0003\n%\u0019!1\u0002-\u0003%\u0011\u000bG/\u0019\"bY\u0006t7-Z'b]\u0006<WM]\u0001\u0018E\u0006d\u0017M\\2fe6\u000bg.Y4fe6{7m[0%KF$B!!\u000f\u0003\u0012!I\u0011\u0011\t\u0014\u0002\u0002\u0003\u0007!qA\u0001\u0015E\u0006d\u0017M\\2fe6\u000bg.Y4fe6{7m\u001b\u0011\u0002\u001d\u0015\u0004xn\u00195[WZ+'o]5p]V\u0011!\u0011\u0004\t\u0004?\nm\u0011b\u0001B\u000fA\n\u0019\u0011J\u001c;\u0002\u001f\u0015\u0004xn\u00195[WZ+'o]5p]\u0002\na\"\u001a=dYV\u001c\u0018n\u001c8DC\u000eDW-\u0006\u0002\u0003&A!!q\u0005B\u0016\u001b\t\u0011IC\u0003\u0002v5&!!Q\u0006B\u0015\u0005U\u0011V\r\u001d7jG\u0006,\u0005p\u00197vg&|gnQ1dQ\u0016\f!#\u001a=dYV\u001c\u0018n\u001c8DC\u000eDWm\u0018\u0013fcR!\u0011\u0011\bB\u001a\u0011%\t\teKA\u0001\u0002\u0004\u0011)#A\bfq\u000edWo]5p]\u000e\u000b7\r[3!\u0003\u0015\u0019X\r^+q)\t\tI\u0004K\u0002.\u0005{\u0001BAa\u0010\u0003N5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0002ba&TAAa\u0012\u0003J\u00059!.\u001e9ji\u0016\u0014(b\u0001B&s\u0006)!.\u001e8ji&!!q\nB!\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aaF!\u0016\u0011\t\t}\"qK\u0005\u0005\u00053\u0012\tEA\u0005BMR,'/R1dQ\u0006\u0011F/Z:u\u00032$XM\u001d*fa2L7-Y#yG2,8/[8og\u000e{W\u000e\u001d7fi\u0016\u001c8)\u00197mE\u0006\u001c7nV5uQVs7N\\8x]N+'O^3s\u000bb\u001cW\r\u001d;j_:|eNW&Fq\u000e,\u0007\u000f^5p]\"\u001aqFa\u0018\u0011\t\t}\"\u0011M\u0005\u0005\u0005G\u0012\tE\u0001\u0003UKN$\u0018A\u0011;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c(+\u001a;ve:\u001c\u0018J\u001c<bY&$W\t_2mkNLwN\\(o+:D\u0017M\u001c3mK\u0012|\u0005\u000fV=qK\"\u001a\u0001Ga\u0018\u00025Q,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:)\u0007E\u0012y&A\u001euKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7\u000fR8fg:$\b+\u001a:tSN$xJ\u001c#va2L7-\u0019;f\u000bb\u001cG.^:j_:D3A\rB0\u0003\u0005#Xm\u001d;BYR,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t/>\u00148n]%g\t\u0006$\u0018MQ1mC:\u001cWM\u001d+ie><8o\u00148O_RLg-[2bi&|g\u000eK\u00024\u0005?\nqb\u001d;beR\u001cuN\u001c;s_2dWM]\u00010gR\f'\u000f^\"p]R\u0014x\u000e\u001c7fe^KG\u000f[!Ce>\\WM],ji\"$Um\u001a:bI\u0016$7i\\7q_:,g\u000e\u001e\u000b\u0005\u00053\u0011Y\bC\u0005\u0003~U\u0002\n\u00111\u0001\u0003\u0000\u0005y!M]8lKJ\u001cu.\u001c9p]\u0016tG\u000f\u0005\u0003\u0003\u0002\n-UB\u0001BB\u0015\u0011\u0011)Ia\"\u0002\u000b\u0005$W.\u001b8\u000b\u0007\t%e/A\u0004dY&,g\u000e^:\n\t\t5%1\u0011\u0002\u0010\u0005J|7.\u001a:D_6\u0004xN\\3oi\u0006I4\u000f^1si\u000e{g\u000e\u001e:pY2,'oV5uQ\u0006\u0013%o\\6fe^KG\u000f\u001b#fOJ\fG-\u001a3D_6\u0004xN\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0014*\"!q\u0010BKW\t\u00119\n\u0005\u0003\u0003\u001a\n\rVB\u0001BN\u0015\u0011\u0011iJa(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BQA\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015&1\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u0006;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b\u0015\u0004o\t}\u0013a\u000f;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[,ji\"lU\u000f\u001c;ja2,G)Z4sC\u0012,GmQ8na>tWM\u001c;t\u001f:\u0014%o\\6fe\"\u001a\u0001Ha\u0018\u0002qQ,7\u000f^!mi\u0016\u0014(I]8lKJDU-\u00197uQ^KG\u000f['vYRL\u0007\u000f\\3SK\u0006\u001cxN\\:P]\u0012+wM]1eK\u0012\u0014%o\\6fe\"\u001a\u0011Ha\u0018\u0002SQ,7\u000f^!mi\u0016\u0014(I]8lKJDU-\u00197uQ&3G)\u0019;bE\u0006d\u0017M\\2feRC'o\\<tQ\rQ$qL\u0001-i\u0016\u001cH/\u00117uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i/\",g\u000eR3n_RLgn\u001a\"fs>tG\rT5nSRD3a\u000fB0\u0003i!Xm\u001d;EK\u001e\u0014\u0018\rZ3e'R|'/Y4f\u001b\u0016$(/[2tQ\ra$qL\u0001\u001bi\u0016\u001cH\u000fR3he\u0006$W\r\u001a(fi^|'o['fiJL7m\u001d\u0015\u0004{\t}\u0013!\u000b;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[,ji\"LeN^1mS\u0012\u001cu.\u001c9p]\u0016tG\u000fK\u0002?\u0005?\n\u0001f];c[&$\u0018I\u001c3XC&$hi\u001c:BYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"\u001cVoY2fgN$BBa3\u0004\u0004\r]1\u0011EB\u0013\u0007_\u0001bA!4\u0003X\nug\u0002\u0002Bh\u0005'tA!!*\u0003R&\t\u0011-C\u0002\u0003V\u0002\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003Z\nm'\u0001\u0002'jgRT1A!6a!\u0011\u0011yN!@\u000f\t\t\u0005(q\u001f\b\u0005\u0005G\u0014\u0019P\u0004\u0003\u0003f\nEh\u0002\u0002Bt\u0005_tAA!;\u0003n:!\u0011Q\u0015Bv\u0013\u0005Q\u0018B\u0001=z\u0013\tYv/\u0003\u0002vm&\u0019!Q\u001f;\u0002\u000f5,7o]1hK&!!\u0011 B~\u0003u\tE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b*fgB|gn]3ECR\f'b\u0001B{i&!!q`B\u0001\u0005a\u0011%o\\6fe\"+\u0017\r\u001c;i'R\fG/^:SKN,H\u000e\u001e\u0006\u0005\u0005s\u0014Y\u0010C\u0004\u0004\u0006}\u0002\raa\u0002\u0002\rI,\u0017m]8o!\u0011\u0019Ia!\u0005\u000f\t\r-1Q\u0002\t\u0004\u0003K\u0003\u0017bAB\bA\u00061\u0001K]3eK\u001aLAaa\u0005\u0004\u0016\t11\u000b\u001e:j]\u001eT1aa\u0004a\u0011\u001d\u0019Ib\u0010a\u0001\u00077\t\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\r\r%1Q\u0004B\r\u0013\u0011\u0019yb!\u0006\u0003\u0007M+G\u000fC\u0004\u0004$}\u0002\rAa \u0002\u0013\r|W\u000e]8oK:$\bbBB\u0014\u007f\u0001\u00071\u0011F\u0001\rQ\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d\t\u0005\u0005\u0003\u001bY#\u0003\u0003\u0004.\t\r%!F\"p[B|g.\u001a8u\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d\u0005\b\u0007cy\u0004\u0019AB\u001a\u0003\u00151wN]2f!\ry6QG\u0005\u0004\u0007o\u0001'a\u0002\"p_2,\u0017M\\\u0001'gV\u0014W.\u001b;B]\u0012<\u0016-\u001b;G_J\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[#se>\u0014HCBB\u001f\u0007\u0013\u001aY\u0005\u0005\u0003\u0004@\r\u0015SBAB!\u0015\r\u0019\u0019\u0005^\u0001\te\u0016\fX/Z:ug&!1qIB!\u0005!\t\u0005/[#se>\u0014\bbBB\r\u0001\u0002\u000711\u0004\u0005\b\u0007G\u0001\u0005\u0019\u0001B@\u0003e!Xm\u001d;J[Bd\u0017nY5u\u0007\u0016dGn\u0011:fCRLwN\\:)\u0007\u0005\u0013y&A\u0012Tk\u000e\u001cWm]:gk2\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[*dK:\f'/[8\u0011\u0007\rU3)D\u0001\u0001\u0005\r\u001aVoY2fgN4W\u000f\\!mi\u0016\u0014(I]8lKJDU-\u00197uQN\u001bWM\\1sS>\u001c\"a\u00110\u0015\u0005\rM\u0013a\b<fe&4\u0017P\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vgJ+7/\u001e7ugRq\u0011\u0011HB1\u0007K\u001a)h!\u001f\u0004\u0010\u000eM\u0005bBB2\u000b\u0002\u0007!1Z\u0001\u001aEJ|7.\u001a:IK\u0006dG\u000f[*uCR,8OU3tk2$8\u000fC\u0004\u0004h\u0015\u0003\ra!\u001b\u0002+1Lg/\u001a\"s_.,'/\u00133B]\u0012,\u0005o\\2igBA11NB9\u00053\ti\"\u0004\u0002\u0004n)\u00191q\u000e1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004t\r5$aA'ba\"91qO#A\u0002\te\u0011A\u0007(v[\n\u0013xn[3sg^KG\u000f\u001b%fC2$\bn\u00115b]\u001e,\u0007bBB>\u000b\u0002\u00071QP\u0001\u0014\u001d\u0016<H.\u001f%fC2$\b.\u001f\"s_.,'o\u001d\t\u0007\u0007\u0013\u0019iba \u0011\t\r\u000551R\u0007\u0003\u0007\u0007SAa!\"\u0004\b\u0006!A.\u00198h\u0015\t\u0019I)\u0001\u0003kCZ\f\u0017\u0002BBG\u0007\u0007\u0013q!\u00138uK\u001e,'\u000fC\u0004\u0004\u0012\u0016\u0003\ra! \u0002)9+w\u000f\\=EK\u001e\u0014\u0018\rZ3e\u0005J|7.\u001a:t\u0011\u001d\u0019)*\u0012a\u0001\u0007{\n\u0011\u0003Z3he\u0006$W\r\u001a\"s_.,'/\u00133t\u0003m\u0019VoY2fgN4W\u000f\\#yG2,8/[8o'\u000e,g.\u0019:j_B\u00191QK$\u00037M+8mY3tg\u001a,H.\u0012=dYV\u001c\u0018n\u001c8TG\u0016t\u0017M]5p'\t9e\f\u0006\u0002\u0004\u001a\u0006aQ\r_2mkNLwN\\(qgV\u00111Q\u0015\t\u0007\u0007\u0013\u0019iba*\u0011\t\r%6qV\u0007\u0003\u0007WS1!^BW\u0015\r\tyC^\u0005\u0005\u0007c\u001bYKA\fBYR,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8Pa\u0006iQ\r_2mkNLwN\\(qg\u0002\nA\u0001^3ti\u0006\t\u0013m]:feR\u001cVoY2fgN4W\u000f\\#yG2,8/[8o\u0007\u0006dGNY1dWR!\u0011\u0011HB^\u0011\u001d\u0019i\f\u0014a\u0001\u0007\u007f\u000baA]3tk2$\b\u0003\u0003Bg\u0007\u0003\u001cid!2\n\t\r\r'1\u001c\u0002\u0007\u000b&$\b.\u001a:\u0011\t\t\u001d2qY\u0005\u0005\u0007\u0013\u0014IC\u0001\u000fBYR,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t%\u0016\u001cX\u000f\u001c;\u00021Q,7\u000f^!mSZ,'I]8lKJ\u001c8K\\1qg\"|G\u000fK\u0002N\u0005?\nq$Y:tKJ$8+^2dKN\u001ch-\u001e7Fq\u000edWo]5p]J+7/\u001e7u)!\tIda5\u0004`\u000e\r\bbBBk\u001d\u0002\u00071q[\u0001\u0010e\u0016\u001cW-\u001b<fIJ+7/\u001e7ugB11\u0011BB\u000f\u00073\u0004Ba!+\u0004\\&!1Q\\BV\u0005q\u0011%o\\6feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t'+Z:vYRDqa!9O\u0001\u0004\u0011I\"\u0001\tfqB,7\r^3e\u0005J|7.\u001a:JI\"91Q\u001d(A\u0002\r\u001d\u0018AD3ya\u0016\u001cG/\u001a3PaRK\b/\u001a\t\u0005\u0007S\u001cyO\u0004\u0003\u0003\u0002\u000e-\u0018\u0002BBw\u0005\u0007\u000b1\"\u0012=dYV\u001c\u0018n\u001c8Pa&!1\u0011_Bz\u0005\u0019y\u0005\u000fV=qK*!1Q\u001eBB\u0003E1XM]5gs6+GO]5d-\u0006dW/\u001a\u000b\t\u0003s\u0019I\u0010b\u0005\u0005\u0018!911`(A\u0002\ru\u0018aD7fiJL7m\u001d*fO&\u001cHO]=\u0011\t\r}HqB\u0007\u0003\t\u0003QA\u0001b\u0001\u0005\u0006\u0005!1m\u001c:f\u0015\u0011\ti\u0006b\u0002\u000b\t\u0011%A1B\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u00115\u0011aA2p[&!A\u0011\u0003C\u0001\u0005=iU\r\u001e:jGN\u0014VmZ5tiJL\bb\u0002C\u000b\u001f\u0002\u00071qA\u0001\u0011[\u0016$(/[2TS6\u0004H.\u001a(b[\u0016Dq\u0001\"\u0007P\u0001\u0004\u0019y(A\u0007fqB,7\r^3e-\u0006dW/\u001a\u000b\t\u0003s!i\u0002b\b\u0005\"!911 )A\u0002\ru\bb\u0002C\u000b!\u0002\u00071q\u0001\u0005\b\t3\u0001\u0006\u0019AB\u0004\u0003\u0019iW\r\u001e:jGR1Aq\u0005C\u0017\t_\u0001Baa@\u0005*%!A1\u0006C\u0001\u0005\u0019iU\r\u001e:jG\"911`)A\u0002\ru\bb\u0002C\u000b#\u0002\u00071qA\u0001\u0014\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7feR+7\u000f\u001e\t\u0003ON\u001b\"a\u00150\u0015\u0005\u0011M\u0012AC:fiV\u00038\t\\1tg\"\u001aQ\u000b\"\u0010\u0011\t\t}BqH\u0005\u0005\t\u0003\u0012\tEA\u0005CK\u001a|'/Z!mY\u0006iA/Z1s\t><hn\u00117bgND3A\u0016C$!\u0011\u0011y\u0004\"\u0013\n\t\u0011-#\u0011\t\u0002\t\u0003\u001a$XM]!mY\u0002")
public class KafkaControllerTest {
    private volatile KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$ SuccessfulAlterBrokerHealthScenario$module;
    private volatile KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario$module;
    private final short alterBrokerHealthRequestVersion = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
    private final Time time = new MockTime();
    private final Option<TierTopicManager> tierTopicManagerOpt = None$.MODULE$;
    private final long initialBrokerEpoch;
    private KafkaConfig config = null;
    private KafkaZkClient zkClient = null;
    private Metrics metrics = null;
    private BrokerInfo initialBrokerInfo = null;
    private DelegationTokenManager tokenManager = null;
    private ClusterLinkFactory.LinkManager clusterLinkManager = null;
    private BrokerFeatures brokerFeatures = null;
    private ZkFinalizedFeatureCache featureCache = null;
    private KafkaController kafkaController = null;
    private DataBalanceManager balancerManagerMock;
    private final int epochZkVersion;
    private ReplicaExclusionCache exclusionCache;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$ SuccessfulAlterBrokerHealthScenario() {
        if (this.SuccessfulAlterBrokerHealthScenario$module == null) {
            this.SuccessfulAlterBrokerHealthScenario$lzycompute$1();
        }
        return this.SuccessfulAlterBrokerHealthScenario$module;
    }

    public KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario() {
        if (this.SuccessfulExclusionScenario$module == null) {
            this.SuccessfulExclusionScenario$lzycompute$1();
        }
        return this.SuccessfulExclusionScenario$module;
    }

    public short alterBrokerHealthRequestVersion() {
        return this.alterBrokerHealthRequestVersion;
    }

    public Time time() {
        return this.time;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public long initialBrokerEpoch() {
        return this.initialBrokerEpoch;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void initialBrokerInfo_$eq(BrokerInfo x$1) {
        this.initialBrokerInfo = x$1;
    }

    public DelegationTokenManager tokenManager() {
        return this.tokenManager;
    }

    public void tokenManager_$eq(DelegationTokenManager x$1) {
        this.tokenManager = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    public BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    public void brokerFeatures_$eq(BrokerFeatures x$1) {
        this.brokerFeatures = x$1;
    }

    public ZkFinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    public void featureCache_$eq(ZkFinalizedFeatureCache x$1) {
        this.featureCache = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public DataBalanceManager balancerManagerMock() {
        return this.balancerManagerMock;
    }

    public void balancerManagerMock_$eq(DataBalanceManager x$1) {
        this.balancerManagerMock = x$1;
    }

    public int epochZkVersion() {
        return this.epochZkVersion;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public void exclusionCache_$eq(ReplicaExclusionCache x$1) {
        this.exclusionCache = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        props.put(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        props.put("confluent.cells.enable", "true");
        props.put("confluent.cells.implicit.creation.enable", "true");
        boolean apply_doLog = true;
        this.config_$eq(new KafkaConfig((java.util.Map)props, apply_doLog));
        this.zkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.metrics_$eq(new Metrics());
        this.initialBrokerInfo_$eq((BrokerInfo)Mockito.mock(BrokerInfo.class));
        this.tokenManager_$eq((DelegationTokenManager)Mockito.mock(DelegationTokenManager.class));
        this.clusterLinkManager_$eq((ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
        this.brokerFeatures_$eq((BrokerFeatures)Mockito.mock(BrokerFeatures.class));
        this.featureCache_$eq((ZkFinalizedFeatureCache)Mockito.mock(ZkFinalizedFeatureCache.class));
        this.balancerManagerMock_$eq((DataBalanceManager)Mockito.mock(DataBalanceManager.class));
        this.exclusionCache_$eq(new ReplicaExclusionCache());
        TestUtils$.MODULE$.clearYammerMetrics();
        KafkaYammerMetrics.defaultRegistry().shutdown();
        this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.time(), this.metrics(), this.initialBrokerInfo(), this.initialBrokerEpoch(), this.tokenManager(), this.tierTopicManagerOpt(), this.clusterLinkManager(), this.brokerFeatures(), this.featureCache(), this.exclusionCache(), false, (Option)None$.MODULE$, (Option)None$.MODULE$));
        this.kafkaController().dataBalancer_$eq(this.balancerManagerMock());
    }

    @AfterEach
    public void tearDown() {
        if (this.kafkaController().eventManager().thread().isRunning()) {
            this.kafkaController().shutdown();
            return;
        }
    }

    @Test
    public void testAlterReplicaExclusionsCompletesCallbackWithUnknownServerExceptionOnZKException() {
        AlterReplicaExclusionOp exclusionOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.SET);
        this.zkClient().setOrCreateReplicaExclusions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(exclusionOp.brokerId(), exclusionOp.reason())})), this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)"replica_exclusions");
        });
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{exclusionOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$1(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusionsReturnsInvalidExclusionOnUnhandledOpType() {
        AlterReplicaExclusionOp unknownOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.UNKNOWN);
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{unknownOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$2(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusions() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusions$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set exclusionOps = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{new AlterReplicaExclusionOp(1, "", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(2, "excluded", ExclusionOp.OpType.SET)}));
        this.kafkaController().alterBrokerReplicaExclusions((Set)exclusionOps, (Function1 & Serializable)result -> {
            this.callback$3(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        ((ClusterBalanceManager)Mockito.verify((Object)this.balancerManagerMock(), (VerificationMode)Mockito.never())).onAlteredExclusions(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{1}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{2}))).asJava());
    }

    @Test
    public void testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.balancerManagerMock().onAlteredExclusions((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            throw new Exception("test!");
        });
        this.SuccessfulExclusionScenario().test();
    }

    public void startController() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.kafkaController().startup();
    }

    /*
     * WARNING - void declaration
     */
    public int startControllerWithABrokerWithDegradedComponent(BrokerComponent brokerComponent) {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        int degradedBrokerId = 1;
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component of broker for test", brokerComponent.id()));
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$startControllerWithABrokerWithDegradedComponent$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        return degradedBrokerId;
    }

    public BrokerComponent startControllerWithABrokerWithDegradedComponent$default$1() {
        return BrokerComponent.UNSPECIFIED;
    }

    @Test
    public void testAlterBrokerHealth() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        int degradedBrokerId = 2;
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
    }

    @Test
    public void testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker() {
        this.startController();
        int degradedBrokerId = 1;
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(0));
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker() {
        int degradedBrokerId = 1;
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component for test", BrokerComponent.UNSPECIFIED.id()));
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component for test1", BrokerComponent.UNSPECIFIED.id()));
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component for test1", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(0));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    @Test
    public void testAlterBrokerHealthIfDatabalancerThrows() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        this.balancerManagerMock().onBrokerHealthChange((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any(), (AliveBrokersMetadata)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            throw new Exception("test!");
        });
        int degradedBrokerId = 2;
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degrade unspecified component test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, true);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
    }

    @Test
    public void testAlterBrokerHealthWhenDemotingBeyondLimit() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        int degradedBrokerId = 2;
        int demotedBrokerIdBeyondLimit = 3;
        ApiError brokerHealthError = this.submitAndWaitForAlterBrokerHealthError((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId, demotedBrokerIdBeyondLimit}))), BrokerComponent.UNSPECIFIED);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        Assertions.assertEquals((Object)Errors.DEMOTION_LIMIT_REACHED, (Object)brokerHealthError.error());
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("demotion test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId, demotedBrokerIdBeyondLimit}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, true);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(3));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerIdBeyondLimit)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerIdBeyondLimit)}))));
    }

    @Test
    public void testDegradedStorageMetrics() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        int degradedBrokerId = 2;
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.kafkaController().controllerContext().degradedStorageBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedStorageCount", Predef$.MODULE$.int2Integer(0));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded unspecified component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.kafkaController().controllerContext().degradedStorageBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedStorageCount", Predef$.MODULE$.int2Integer(0));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.kafkaController().controllerContext().degradedStorageBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedStorageCount", Predef$.MODULE$.int2Integer(1));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.kafkaController().controllerContext().degradedStorageBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedStorageCount", Predef$.MODULE$.int2Integer(0));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded storage component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId}))), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.kafkaController().controllerContext().degradedStorageBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedStorageCount", Predef$.MODULE$.int2Integer(2));
    }

    @Test
    public void testDegradedNetworkMetrics() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        int degradedBrokerId = 2;
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.kafkaController().controllerContext().degradedNetworkBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedNetworkCount", Predef$.MODULE$.int2Integer(1));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.kafkaController().controllerContext().degradedNetworkBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedNetworkCount", Predef$.MODULE$.int2Integer(0));
        brokerHealthResults = this.submitAndWaitForAlterBrokerHealthSuccess("degraded network component of broker for test", (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId}))), BrokerComponent.NETWORK, ComponentHealthStatus.DEGRADED, false);
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults(brokerHealthResults, (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.kafkaController().controllerContext().degradedNetworkBrokerIds());
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedNetworkCount", Predef$.MODULE$.int2Integer(2));
    }

    @Test
    public void testAlterBrokerHealthWithInvalidComponent() {
        this.startController();
        int degradedBrokerId = 2;
        ApiError requestError = this.submitAndWaitForAlterBrokerHealthError((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId}))), BrokerComponent.UNKNOWN);
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)requestError.error());
    }

    /*
     * WARNING - void declaration
     */
    private List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> submitAndWaitForAlterBrokerHealthSuccess(String reason, scala.collection.immutable.Set<Object> brokerIds, BrokerComponent component, ComponentHealthStatus healthStatus, boolean force) {
        AtomicReference<Object> brokerHealthResult = new AtomicReference<Object>(null);
        this.kafkaController().alterBrokerHealth(reason, brokerIds, component, healthStatus, force, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResult);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$submitAndWaitForAlterBrokerHealthSuccess$2(brokerHealthResult)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker health result callback");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Either either = brokerHealthResult.get();
        if (either instanceof Left) {
            return (List)((Left)either).value();
        }
        if (either instanceof Right) {
            ApiError error = (ApiError)((Right)either).value();
            return (List)Assertions.fail((String)new StringBuilder(77).append("Received error ").append(error).append(" when expecting success for alterBrokerHealth with params ").append(reason).append(" ").append(brokerIds).append(" ").append(component).append(" ").append(healthStatus).append(" ").append(force).toString());
        }
        throw new MatchError((Object)either);
    }

    /*
     * WARNING - void declaration
     */
    private ApiError submitAndWaitForAlterBrokerHealthError(scala.collection.immutable.Set<Object> brokerIds, BrokerComponent component) {
        AtomicReference<Object> brokerHealthResult = new AtomicReference<Object>(null);
        this.kafkaController().alterBrokerHealth("demotion-test", brokerIds, component, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$5(result, brokerHealthResult);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$submitAndWaitForAlterBrokerHealthError$2(brokerHealthResult)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker health result callback");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Either either = brokerHealthResult.get();
        if (either instanceof Left) {
            List results = (List)((Left)either).value();
            return (ApiError)Assertions.fail((String)new StringBuilder(75).append("Received response ").append(results).append(" when expecting error for alterBrokerHealth with params ").append(brokerIds).append(" ").append(component).toString());
        }
        if (either instanceof Right) {
            return (ApiError)((Right)either).value();
        }
        throw new MatchError((Object)either);
    }

    @Test
    public void testImplicitCellCreations() {
        Broker broker = Broker$.MODULE$.apply(0, (Seq)new .colon.colon((Object)new EndPoint("localhost", 8000, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures());
        Broker broker2 = Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)new EndPoint("localhost", 8000, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures());
        Mockito.when((Object)this.zkClient().getAllBrokerAndEpochsInCluster()).thenAnswer(x$6 -> (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)BoxesRunTime.boxToLong((long)1L))})));
        this.kafkaController().process((ControllerEvent)BrokerChange$.MODULE$);
        HashSet<Integer> brokers = new HashSet<Integer>();
        brokers.add(Predef$.MODULE$.int2Integer(0));
        brokers.add(Predef$.MODULE$.int2Integer(1));
        Assertions.assertEquals((Object)((HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Cell(0, brokers, CellState.READY, 6, 15))}))), (Object)this.kafkaController().controllerContext().cellIdToCell());
    }

    @Test
    public void testAliveBrokersSnapshot() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.exclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"reason")}))).asJava());
        this.kafkaController().controllerContext().setDegradedBrokerComponent(1, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("demoted broker for test", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)new AliveBrokersSnapshot(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)3L))}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava()), (Object)this.kafkaController().aliveBrokersSnapshot());
    }

    public void kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult(scala.collection.immutable.Set<BrokerReplicaExclusionResult> receivedResults, int expectedBrokerId, ExclusionOp.OpType expectedOpType) {
        Option findOpt = receivedResults.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KafkaControllerTest.$anonfun$assertSuccessfulExclusionResult$1(expectedBrokerId, p)));
        Assertions.assertFalse((boolean)findOpt.isEmpty(), (String)new StringBuilder(34).append("Could not find broker ").append(expectedBrokerId).append(" in results ").append(receivedResults).toString());
        BrokerReplicaExclusionResult exclusion = (BrokerReplicaExclusionResult)findOpt.get();
        Assertions.assertEquals((int)expectedBrokerId, (int)exclusion.brokerId());
        Assertions.assertEquals((Object)expectedOpType, (Object)exclusion.opType());
        Assertions.assertTrue((!exclusion.apiErrorOptional().isPresent() ? 1 : 0) != 0, (String)new StringBuilder(51).append("Expected exclusion for broker ").append(expectedBrokerId).append(" to not have an error").toString());
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, String expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$3(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$4(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        java.util.Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.controller", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    private final void SuccessfulAlterBrokerHealthScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulAlterBrokerHealthScenario$module == null) {
                this.SuccessfulAlterBrokerHealthScenario$module = new KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$(this);
            }
            return;
        }
    }

    private final void SuccessfulExclusionScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulExclusionScenario$module == null) {
                this.SuccessfulExclusionScenario$module = new KafkaControllerTest$SuccessfulExclusionScenario$(this);
            }
            return;
        }
    }

    private static final void callback$1(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error.error());
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected an error while processing exclusions");
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$2(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertFalse((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to not be successful");
            Assertions.assertEquals((int)1, (int)result2.brokerReplicaExclusionResults().size());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.INVALID_REPLICA_EXCLUSION})), (Object)((IterableOps)((IterableOps)result2.brokerReplicaExclusionResults().map((Function1 & Serializable)r -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.apiErrorOptional())))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.isDefined()))).map((Function1 & Serializable)e -> ((ApiError)e.get()).error()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusions$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusions$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2() {
        return "failed to elect the controller";
    }

    private final void callback$3(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertTrue((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to be successful");
            Assertions.assertEquals((int)2, (int)result2.brokerReplicaExclusionResults().size());
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 1, ExclusionOp.OpType.DELETE);
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 2, ExclusionOp.OpType.SET);
            java.util.Map exclusions = this.kafkaController().replicaExclusionCache().exclusions();
            Assertions.assertEquals((int)1, (int)exclusions.size());
            Assertions.assertTrue((boolean)exclusions.containsKey(BoxesRunTime.boxToInteger((int)1)), (String)"Expected exclusion for broker 1 to be present");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$startControllerWithABrokerWithDegradedComponent$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$startControllerWithABrokerWithDegradedComponent$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$2() {
        return "failed to elect the controller";
    }

    private static final void callback$4(Either result, AtomicReference brokerHealthResult$1) {
        brokerHealthResult$1.set(result);
    }

    public static final /* synthetic */ boolean $anonfun$submitAndWaitForAlterBrokerHealthSuccess$2(AtomicReference brokerHealthResult$1) {
        return brokerHealthResult$1.get() != null;
    }

    public static final /* synthetic */ String $anonfun$submitAndWaitForAlterBrokerHealthSuccess$3() {
        return "Timed out waiting for broker health result callback";
    }

    private static final void callback$5(Either result, AtomicReference brokerHealthResult$2) {
        brokerHealthResult$2.set(result);
    }

    public static final /* synthetic */ boolean $anonfun$submitAndWaitForAlterBrokerHealthError$2(AtomicReference brokerHealthResult$2) {
        return brokerHealthResult$2.get() != null;
    }

    public static final /* synthetic */ String $anonfun$submitAndWaitForAlterBrokerHealthError$3() {
        return "Timed out waiting for broker health result callback";
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulExclusionResult$1(int expectedBrokerId$1, BrokerReplicaExclusionResult p) {
        return p.brokerId() == expectedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(KafkaControllerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$3(KafkaControllerTest $this, MetricsRegistry metricsRegistry$2, String metricSimpleName$2, AtomicReference lastSeenValue$2, String expectedValue$2) {
        String value = (String)((Gauge)$this.metric(metricsRegistry$2, metricSimpleName$2)).value();
        lastSeenValue$2.set(value);
        String string = expectedValue$2;
        return !(string != null ? !string.equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$4(String metricSimpleName$2, String expectedValue$2, AtomicReference lastSeenValue$2) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$2).append(" to be ").append(expectedValue$2).append(" but instead was ").append(lastSeenValue$2.get()).toString();
    }

    public KafkaControllerTest() {
        this.initialBrokerEpoch = 0L;
        this.epochZkVersion = 0;
    }
}

